/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.rcs;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.jrcs.rcs.Archive;
import org.apache.commons.jrcs.rcs.ArchiveParserConstants;
import org.apache.commons.jrcs.rcs.ArchiveParserTokenManager;
import org.apache.commons.jrcs.rcs.CharStream;
import org.apache.commons.jrcs.rcs.FastCharStream;
import org.apache.commons.jrcs.rcs.Node;
import org.apache.commons.jrcs.rcs.ParseException;
import org.apache.commons.jrcs.rcs.Token;
import org.apache.commons.jrcs.rcs.Version;

class ArchiveParser
implements ArchiveParserConstants {
    static final String ident = "RCS ArchiveParser Parser $version$:";
    public ArchiveParserTokenManager token_source;
    public Token token;
    public Token jj_nt;

    public ArchiveParser(InputStream in) {
        this(new FastCharStream(in));
    }

    public static void main(String[] args) {
        ArchiveParser parser;
        if (args.length == 0) {
            System.out.println("RCS ArchiveParser Parser $version$:  Reading from standard input . . .");
            parser = new ArchiveParser(System.in);
        } else if (args.length == 1) {
            System.out.println("RCS ArchiveParser Parser $version$:  Reading from file " + args[0] + " . . .");
            try {
                parser = new ArchiveParser(new FileInputStream(args[0]));
            }
            catch (FileNotFoundException e) {
                System.out.println("RCS ArchiveParser Parser $version$:  File " + args[0] + " not found.");
                return;
            }
        } else {
            System.out.println("RCS ArchiveParser Parser $version$:  Usage is one of:");
            System.out.println("         java ArchiveParser < inputfile");
            System.out.println("OR");
            System.out.println("         java ArchiveParser inputfile");
            return;
        }
        parser.parse();
    }

    public static void load(Archive arc, InputStream input) throws ParseException {
        ArchiveParser parser = new ArchiveParser(input);
        parser.archive(arc);
    }

    public static void load(Archive arc, String fname) throws FileNotFoundException, ParseException {
        ArchiveParser.load(arc, new FileInputStream(fname));
    }

    public void parse() {
        try {
            this.archive(new Archive());
            System.out.println("RCS ArchiveParser Parser version 1.1:  RCS ArchiveParser parsed successfully.");
        }
        catch (ParseException e) {
            System.out.println("RCS ArchiveParser Parser version 1.1:  Encountered errors during parse.");
        }
    }

    public final void archive(Archive arc) throws ParseException {
        this.admin(arc);
        block6: while (true) {
            switch (this.jj_nt.kind) {
                case 25: {
                    break;
                }
                default: {
                    break block6;
                }
            }
            this.delta(arc);
        }
        this.desc(arc);
        block7: while (true) {
            switch (this.jj_nt.kind) {
                case 25: {
                    break;
                }
                default: {
                    break block7;
                }
            }
            this.text(arc);
        }
        this.jj_consume_token(0);
    }

    public final void admin(Archive arc) throws ParseException {
        String string;
        String id;
        Version v;
        this.jj_consume_token(15);
        switch (this.jj_nt.kind) {
            case 25: {
                v = this.version();
                arc.setHead(v);
                break;
            }
        }
        this.jj_consume_token(28);
        switch (this.jj_nt.kind) {
            case 9: {
                this.jj_consume_token(9);
                v = this.version();
                arc.setBranch(v);
                this.jj_consume_token(28);
                break;
            }
        }
        this.jj_consume_token(7);
        block33: while (true) {
            switch (this.jj_nt.kind) {
                case 26: {
                    break;
                }
                default: {
                    break block33;
                }
            }
            id = this.id();
            arc.addUser(id);
        }
        this.jj_consume_token(28);
        this.jj_consume_token(21);
        block34: while (true) {
            switch (this.jj_nt.kind) {
                case 27: {
                    break;
                }
                default: {
                    break block34;
                }
            }
            String sym = this.sym();
            this.jj_consume_token(29);
            v = this.version();
            arc.addSymbol(sym, v);
        }
        this.jj_consume_token(28);
        this.jj_consume_token(16);
        block35: while (true) {
            switch (this.jj_nt.kind) {
                case 26: {
                    break;
                }
                default: {
                    break block35;
                }
            }
            id = this.id();
            this.jj_consume_token(29);
            v = this.version();
            arc.addLock(id, v);
        }
        this.jj_consume_token(28);
        switch (this.jj_nt.kind) {
            case 20: {
                this.jj_consume_token(20);
                arc.setStrictLocking(true);
                this.jj_consume_token(28);
                break;
            }
            default: {
                arc.setStrictLocking(false);
            }
        }
        switch (this.jj_nt.kind) {
            case 11: {
                this.jj_consume_token(11);
                switch (this.jj_nt.kind) {
                    case 30: {
                        string = this.string();
                        arc.setComment(string);
                        break;
                    }
                }
                this.jj_consume_token(28);
                break;
            }
        }
        switch (this.jj_nt.kind) {
            case 14: {
                this.jj_consume_token(14);
                switch (this.jj_nt.kind) {
                    case 30: {
                        string = this.string();
                        arc.setExpand(string);
                        break;
                    }
                }
                this.jj_consume_token(28);
                break;
            }
        }
        block36: while (true) {
            switch (this.jj_nt.kind) {
                case 26: {
                    break;
                }
                default: {
                    break block36;
                }
            }
            this.newPhrase(arc.phrases);
        }
    }

    public final void delta(Archive arc) throws ParseException {
        Version v = this.version();
        Node node = arc.newNode(v);
        this.jj_consume_token(12);
        int[] d = this.date();
        node.setDate(d);
        this.jj_consume_token(28);
        this.jj_consume_token(8);
        String s = this.id();
        node.setAuthor(s);
        this.jj_consume_token(28);
        this.jj_consume_token(19);
        switch (this.jj_nt.kind) {
            case 26: {
                s = this.id();
                node.setState(s);
                break;
            }
        }
        this.jj_consume_token(28);
        this.jj_consume_token(10);
        block12: while (true) {
            switch (this.jj_nt.kind) {
                case 25: {
                    break;
                }
                default: {
                    break block12;
                }
            }
            v = this.version();
            node.addBranch(arc.newBranchNode(v));
        }
        this.jj_consume_token(28);
        this.jj_consume_token(18);
        switch (this.jj_nt.kind) {
            case 25: {
                v = this.version();
                node.setRCSNext(arc.newNode(v));
                break;
            }
        }
        this.jj_consume_token(28);
        block13: while (true) {
            switch (this.jj_nt.kind) {
                case 26: {
                    break;
                }
                default: {
                    break block13;
                }
            }
            this.newPhrase(node.phrases);
        }
    }

    public final void desc(Archive arc) throws ParseException {
        this.jj_consume_token(13);
        String s = this.string();
        arc.setDesc(s);
    }

    public final void text(Archive arc) throws ParseException {
        Version v = this.version();
        Node node = arc.getNode(v);
        this.jj_consume_token(17);
        String log = this.string();
        node.setLog(log);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 26: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            this.newPhrase(node.phrases);
        }
        this.jj_consume_token(22);
        String txt = this.string();
        node.setText(txt);
    }

    public final void newPhrase(Map map) throws ParseException {
        StringBuffer values = new StringBuffer();
        String key = this.id();
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 25: 
                case 26: 
                case 29: 
                case 30: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            String value = this.word();
            values.append(" " + value);
        }
        this.jj_consume_token(28);
        if (map != null) {
            map.put(key, values.toString());
        }
    }

    public final String num() throws ParseException {
        Token num = this.jj_consume_token(25);
        return num.image;
    }

    public final String id() throws ParseException {
        Token id = this.jj_consume_token(26);
        return id.image;
    }

    public final String sym() throws ParseException {
        Token sym = this.jj_consume_token(27);
        return sym.image;
    }

    public final String string() throws ParseException {
        Token s = this.jj_consume_token(30);
        return Archive.unquoteString(s.image);
    }

    public final String word() throws ParseException {
        String word;
        switch (this.jj_nt.kind) {
            case 26: {
                word = this.id();
                break;
            }
            case 25: {
                word = this.num();
                break;
            }
            case 30: {
                word = this.string();
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                word = ":";
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return word;
    }

    public final Version version() throws ParseException {
        Token v = this.jj_consume_token(25);
        return new Version(v.image);
    }

    public final int[] date() throws ParseException {
        int[] n = new int[6];
        n[0] = this.digits();
        this.jj_consume_token(24);
        n[1] = this.digits();
        this.jj_consume_token(24);
        n[2] = this.digits();
        this.jj_consume_token(24);
        n[3] = this.digits();
        this.jj_consume_token(24);
        n[4] = this.digits();
        this.jj_consume_token(24);
        n[5] = this.digits();
        return n;
    }

    public final int digits() throws ParseException {
        Token t = this.jj_consume_token(23);
        return Integer.parseInt(t.image);
    }

    public ArchiveParser(CharStream stream) {
        this.token_source = new ArchiveParserTokenManager(stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
    }

    public void ReInit(CharStream stream) {
        this.token_source.ReInit(stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
    }

    public ArchiveParser(ArchiveParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
    }

    public void ReInit(ArchiveParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        if (this.token.kind == kind) {
            return this.token;
        }
        this.jj_nt = this.token;
        this.token = oldToken;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    public ParseException generateParseException() {
        Token errortok = this.token.next;
        int line = errortok.beginLine;
        int column = errortok.beginColumn;
        String mess = errortok.kind == 0 ? tokenImage[0] : errortok.image;
        return new ParseException("Parse error at line " + line + ", column " + column + ".  Encountered: " + mess);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

