# -*- shell-script -*-
#
# Copyright (c) 2009-2013 Cisco Systems, Inc.  All rights reserved.
# Copyright (c) 2012-2013 Los Alamos National Security, LLC.  All rights reserved.
#
# $COPYRIGHT$
# 
# Additional copyrights may follow
# 
# $HEADER$
#
AC_DEFUN([MCA_opal_event_libevent2021_PRIORITY], [80])

#
# Force this component to compile in static-only mode
#
AC_DEFUN([MCA_opal_event_libevent2021_COMPILE_MODE], [
    AC_MSG_CHECKING([for MCA component $2:$3 compile mode])
    $4="static"
    AC_MSG_RESULT([$$4])
])

AC_DEFUN([MCA_opal_event_libevent2021_POST_CONFIG], [
    AS_IF([test "$1" = "1"], 
          [ # Build libevent/include/event2/event-config.h.  If we
           # don't do it here, then libevent's Makefile.am will build
           # it during "make all", which is too late for us (because
           # other things are built before the event framework that
           # end up including event-config.h).  The steps below were
           # copied from libevent's Makefile.am.

           AC_CONFIG_COMMANDS([opal/mca/event/libevent2021/libevent/include/event2/event-config.h],
                              [basedir="opal/mca/event/libevent2021"
                               file="$basedir/libevent/include/event2/event-config.h"
                               rm -f "$file.new"
                               cat > "$file.new" <<EOF
/* event2/event-config.h
 *
 * This file was generated by autoconf when libevent was built, and
 * post- processed by Open MPI's component configure.m4 (so that
 * Libevent wouldn't build it during "make all") so that its macros
 * would have a uniform prefix.
 *
 * DO NOT EDIT THIS FILE.
 *
 * Do not rely on macros in this file existing in later versions
 */
#ifndef _EVENT2_EVENT_CONFIG_H_
#define _EVENT2_EVENT_CONFIG_H_
EOF

                               sed -e 's/#define /#define _EVENT_/' \
                                   -e 's/#undef /#undef _EVENT_/' \
                                   -e 's/#ifndef /#ifndef _EVENT_/' < "$basedir/libevent/config.h" >> "$file.new"
                               echo "#endif" >> "$file.new"

                               # Only make a new .h file if the
                               # contents haven't changed
                               diff -q $file "$file.new" > /dev/null 2> /dev/null
                               if test "$?" = "0"; then
                                   echo $file is unchanged
                               else
                                   cp "$file.new" $file
                               fi
                               rm -f "$file.new"])

           # Must set this variable so that the framework m4 knows
           # what file to include in opal/mca/event/event.h
           opal_event_base_include="libevent2021/libevent2021.h"

           # Add some stuff to CPPFLAGS so that the rest of the source
           # tree can be built
           file=$basedir/libevent
           CPPFLAGS="$CPPFLAGS -I$OMPI_TOP_SRCDIR/$file -I$OMPI_TOP_SRCDIR/$file/include"
           AS_IF([test "$OMPI_TOP_BUILDDIR" != "$OMPI_TOP_SRCDIR"],
                 [CPPFLAGS="$CPPFLAGS -I$OMPI_TOP_BUILDDIR/$file/include"])
           unset file
          ])
])

# MCA_event_libevent2021_CONFIG([action-if-can-compile], 
#                              [action-if-cant-compile])
# ------------------------------------------------
AC_DEFUN([MCA_opal_event_libevent2021_CONFIG],[
    AC_CONFIG_FILES([opal/mca/event/libevent2021/Makefile])
    basedir="opal/mca/event/libevent2021"

    CFLAGS_save="$CFLAGS"
    CFLAGS="$OMPI_CFLAGS_BEFORE_PICKY $OPAL_VISIBILITY_CFLAGS"
    CPPFLAGS_save="$CPPFLAGS"
    CPPFLAGS="-I$OMPI_TOP_SRCDIR -I$OMPI_TOP_BUILDDIR -I$OMPI_TOP_SRCDIR/opal/include $CPPFLAGS"

    AC_MSG_CHECKING([libevent configuration args])
    event_args="--disable-dns --disable-http --disable-rpc --disable-openssl --enable-thread-support"

    AC_ARG_ENABLE(event-rtsig,
        AC_HELP_STRING([--enable-event-rtsig],
                       [enable support for real time signals (experimental)]))
    if test "$enable_event_rtsig" = "yes"; then
        event_args="$event_args --enable-rtsig"
    fi

    AC_ARG_ENABLE(event-select,
                  AC_HELP_STRING([--disable-event-select], [disable select support]))
    if test "$enable_event_select" = "no"; then
        event_args="$event_args --disable-select"
    fi

    AC_ARG_ENABLE(event-poll,
                  AC_HELP_STRING([--disable-event-poll], [disable poll support]))
    if test "$enable_event_poll" = "no"; then
        event_args="$event_args --disable-poll"
    fi

    AC_ARG_ENABLE(event-devpoll,
                  AC_HELP_STRING([--disable-event-devpoll], [disable devpoll support]))
    if test "$enable_event_devpoll" = "no"; then
        event_args="$event_args --disable-devpoll"
    fi

    AC_ARG_ENABLE(event-kqueue,
                  AC_HELP_STRING([--disable-event-kqueue], [disable kqueue support]))
    if test "$enable_event_kqueue" = "no"; then
        event_args="$event_args --disable-kqueue"
    fi

    AC_ARG_ENABLE(event-epoll,
                  AC_HELP_STRING([--disable-event-epoll], [disable epoll support]))
    if test "$enable_event_epoll" = "no"; then
        event_args="$event_args --disable-epoll"
    fi

    AC_ARG_ENABLE(event-evport,
                  AC_HELP_STRING([--enable-event-evport], [enable evport support]))
    if test "$enable_event_evport" = "yes"; then
        event_args="$event_args --enable-evport"
    else
        event_args="$event_args --disable-evport"
    fi

    AC_ARG_ENABLE(event-signal,
                  AC_HELP_STRING([--disable-event-signal], [disable signal support]))
    if test "$enable_event_signal" = "no"; then
        event_args="$event_args --disable-signal"
    fi

    AC_ARG_ENABLE(event-debug,
                  AC_HELP_STRING([--enable-event-debug], [enable event library debug output]))
    if test "$enable_event_debug" = "yes"; then
        event_args="$event_args --enable-debug-mode"
    fi

    AC_MSG_RESULT([$event_args])

    OMPI_CONFIG_SUBDIR([$basedir/libevent], 
        [$event_args $ompi_subdir_args],
        [libevent_happy="yes"], [libevent_happy="no"])
    if test "$libevent_happy" = "no"; then
        AC_MSG_WARN([Event library failed to configure])
        AC_MSG_ERROR([Cannot continue])
    fi

    # Finally, add some flags to the wrapper compiler if we're
    # building with developer headers so that our headers can
    # be found.
    event_libevent2021_WRAPPER_EXTRA_CPPFLAGS='-I${includedir}/openmpi/opal/mca/event/libevent2021/libevent -I${includedir}/openmpi/opal/mca/event/libevent2021/libevent/include'

    CFLAGS="$CFLAGS_save"
    CPPFLAGS="$CPPFLAGS_save"

    # If we configured successfully, set OPAL_HAVE_WORKING_EVENTOPS to
    # the value in the generated libevent/config.h (NOT
    # libevent/include/event2/event-config.h!).  Otherwise, set it to
    # 0.
    file=$basedir/libevent/config.h
    AS_IF([test "$libevent_happy" = "yes" -a -r $file], 
          [OPAL_HAVE_WORKING_EVENTOPS=`grep HAVE_WORKING_EVENTOPS $file | awk '{print [$]3 }'`
           $1],
          [$2
           OPAL_HAVE_WORKING_EVENTOPS=0])
    unset file
])
