/*  $Id$

    Part of SWI-Prolog

    Author:        Jan Wielemaker
    E-mail:        J.Wielemaker@cs.vu.nl
    WWW:           http://www.swi-prolog.org
    Copyright (C): 1985-2011, University of Amsterdam
			      Vu University Amsterdam

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#define __WIN32__ 1
#if !defined(VC8) && (_MSC_VER >= 1400)	/* Visual studio 8 */
#define VC8 1				/* (aka Microsoft 2005 VC++ */
#endif

#ifdef __MINGW32__
#include <config.h>
#endif

#ifndef __MINGW32__
typedef unsigned long sigset_t;		/* we don't have this */
typedef int mode_t;
#define HAVE_SHLOBJ_H 1
#endif
#define HAVE_SIGSET_T 1			/* For the future */

#define NOTTYCONTROL		TRUE	/* default -tty */
#define O_GMP			1
#define O_PLMT			1
#define _REENTRANT		1

#define OPEN_MAX 32

#define HAVE_UXNT_H 1
#define HAVE_MALLOC_H 1
#define HAVE_VIRTUALALLOC 1
#define HAVE_CLOCK 1			/* clock() timing function */
#define inline __inline

/* Define if you want to associate states */
#define ASSOCIATE_STATE "qlx"
#define ASSOCIATE_SRC	"pl"

#define snprintf _snprintf

#ifdef O_GMP
#define HAVE_GMP_H 1
#define HAVE_LIB_GMP 1
#endif

#ifdef __LCC__
#define NO_MS_EXTENSIONS 1
#endif

/* Define for emulating dlopen(), etc. using LoadLibrary */
#define EMULATE_DLOPEN 1

/* Define to extension used for shared objects if not "so" */
#define SO_EXT "dll"

/* Define for the _xos_... functions */
#define O_XOS 1

/* Define O_RLC for the ../readline library */
#define O_RLC 1

/* Define for Windows DDE support */
#define O_DDE 1

/* Define for Windows DLL support */
#define O_DLL 1

/* Define if you disk-drives are special to you (DOS, Windows, OS/2) */
#define O_HASDRIVES 1

/* Define if you have shares using the notation //host/share */
#define O_HASSHARES 1

/* Maximum length of a path-name.  Note XOS! */
#define MAXPATHLEN 512

/* Define as the return type of signal handlers (int or void).  */
#define RETSIGTYPE void

/* If using the C implementation of alloca, define if you know the
   direction of stack growth for your system; otherwise it will be
   automatically deduced at run-time.
	STACK_DIRECTION > 0 => grows toward higher addresses
	STACK_DIRECTION < 0 => grows toward lower addresses
	STACK_DIRECTION = 0 => direction of growth unknown
 */
#define STACK_DIRECTION -1

/* Define if you have the ANSI C header files.  */
#define STDC_HEADERS 1

/* Define if uchar is not defined in <sys/types.h> */
#define NEED_UCHAR 1

/* Define if SIGPROF and setitimer() are available */
#define O_PROFILE 1

/* The number of bytes in a int.  */
#define SIZEOF_INT 4

/* The number of bytes in a long.  */
#define SIZEOF_LONG 4

/* The number of bytes in a wchar_t.  */
#define SIZEOF_WCHAR_T 2

/* Define if you have the access function.  */
#define HAVE_ACCESS 1

/* Define if you have the chmod function.  */
#define HAVE_CHMOD 1

/* Define if you have the fstat function.  */
#define HAVE_FSTAT 1

/* Define if you have the getcwd function.  */
#define HAVE_GETCWD 1

/* Define if you have the getpid function.  */
#define HAVE_GETPID 1

/* Define if you have the ftime function.  */
#define HAVE_FTIME 1

/* Define if you have the memmove function.  */
#define HAVE_MEMMOVE 1

/* Define if you have the opendir function.  */
#define HAVE_OPENDIR 1

/* Define if you have the popen function.  */
#define HAVE_POPEN 1

/* Define if you have the putenv function.  */
#define HAVE_PUTENV 1

/* Define if you have the remove function.  */
#define HAVE_REMOVE 1

/* Define if you have the rename function.  */
#define HAVE_RENAME 1

/* Define if you have the stricmp() function. */
#define HAVE_STRICMP 1

/* Define if you have the mbscasecoll() function. */
#define mbcasescoll mbsicoll
#define HAVE_MBCASESCOLL 1

/* Define if you have the strlwr() function */
#define HAVE_STRLWR 1

/* Define if you have the rl_insert_close function.  */
#define HAVE_RL_INSERT_CLOSE 1

/* Define if you have the select function.  */
#define HAVE_SELECT 1

/* Define if you have the signal function.  */
#define HAVE_SIGNAL 1

/* Define if you have the srand function.  */
#define HAVE_SRAND 1

/* Define if you have the stat function.  */
#define HAVE_STAT 1

/* Define if you have the strerror function.  */
#define HAVE_STRERROR 1

#define HAVE_CEIL  1
#define HAVE_FLOOR 1

/* Define if you have the <dirent.h> header file.  */
#define HAVE_DIRENT_H 1

/* Define if you have the <malloc.h> header file.  */
#define HAVE_MALLOC_H 1

/* Define if you have the <memory.h> header file.  */
#define HAVE_MEMORY_H 1

/* Define if you have the <ndir.h> header file.  */
/* #undef HAVE_NDIR_H */

/* Define if you have the <string.h> header file.  */
#define HAVE_STRING_H 1

/* Define if you have the <sys/stat.h> header file.  */
#define HAVE_SYS_STAT_H 1

/* Define if you have the m library (-lm).  */
#define HAVE_LIBM 1

/* Define to make use of standard (UNIX98) pthread recursive mutexes */
#define RECURSIVE_MUTEXES 1

/* Define if pthread has pthread_mutexattr_settype() */
#define HAVE_PTHREAD_MUTEXATTR_SETTYPE 1

/* Format for int64_t */
#ifndef INT64_FORMAT
#define INT64_FORMAT "%I64d"
#endif

/* Define to 1 if you have the <locale.h> header file. */
#define HAVE_LOCALE_H 1

/* Define to 1 if you have the `setlocale' function. */
#define HAVE_SETLOCALE 1

/* Define to 1 if you have `isnan' function */
#define HAVE_ISNAN 1

/* Define to 1 if you have `_fpclass' function */
#define HAVE__FPCLASS 1

/* Define to 1 if you have <float.h> header */
#define HAVE_FLOAT_H 1

/* setenv comes from uxnt.c */
#define HAVE_SETENV 1

/* Define to 1 if you have the 'wcsxfrm' function. */
#define HAVE_WCSXFRM 1
