/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.harmony.runtime.java.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import net.sourceforge.retroweaver.harmony.runtime.internal.nls.Messages;
import net.sourceforge.retroweaver.harmony.runtime.java.math.RoundingMode;

public final class MathContext
implements Serializable {
    public static final MathContext DECIMAL128 = new MathContext(34, RoundingMode.HALF_EVEN);
    public static final MathContext DECIMAL32 = new MathContext(7, RoundingMode.HALF_EVEN);
    public static final MathContext DECIMAL64 = new MathContext(16, RoundingMode.HALF_EVEN);
    public static final MathContext UNLIMITED = new MathContext(0, RoundingMode.HALF_UP);
    private static final long serialVersionUID = 5579720004786848255L;
    private int precision;
    private RoundingMode roundingMode;
    private static final char[] chPrecision = new char[]{'p', 'r', 'e', 'c', 'i', 's', 'i', 'o', 'n', '='};
    private static final char[] chRoundingMode = new char[]{'r', 'o', 'u', 'n', 'd', 'i', 'n', 'g', 'M', 'o', 'd', 'e', '='};

    public MathContext(int setPrecision) {
        this(setPrecision, RoundingMode.HALF_UP);
    }

    public MathContext(int setPrecision, RoundingMode setRoundingMode) {
        if (setPrecision < 0) {
            throw new IllegalArgumentException(Messages.getString("math.0C"));
        }
        if (setRoundingMode == null) {
            throw new NullPointerException(Messages.getString("math.0D"));
        }
        this.precision = setPrecision;
        this.roundingMode = setRoundingMode;
    }

    public MathContext(String val) {
        int j;
        int i;
        char[] charVal = val.toCharArray();
        if (charVal.length < 27 || charVal.length > 45) {
            throw new IllegalArgumentException(Messages.getString("math.0E"));
        }
        for (i = 0; i < chPrecision.length && charVal[i] == chPrecision[i]; ++i) {
        }
        if (i < chPrecision.length) {
            throw new IllegalArgumentException(Messages.getString("math.0E"));
        }
        int digit = Character.digit(charVal[i], 10);
        if (digit == -1) {
            throw new IllegalArgumentException(Messages.getString("math.0E"));
        }
        this.precision = this.precision * 10 + digit;
        ++i;
        while (true) {
            if ((digit = Character.digit(charVal[i], 10)) == -1) {
                if (charVal[i] == ' ') {
                    ++i;
                    break;
                }
                throw new IllegalArgumentException(Messages.getString("math.0E"));
            }
            this.precision = this.precision * 10 + digit;
            if (this.precision < 0) {
                throw new IllegalArgumentException(Messages.getString("math.0E"));
            }
            ++i;
        }
        for (j = 0; j < chRoundingMode.length && charVal[i] == chRoundingMode[j]; ++j) {
            ++i;
        }
        if (j < chRoundingMode.length) {
            throw new IllegalArgumentException(Messages.getString("math.0E"));
        }
        this.roundingMode = RoundingMode.valueOf(String.valueOf(charVal, i, charVal.length - i));
    }

    public int getPrecision() {
        return this.precision;
    }

    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public boolean equals(Object x) {
        return x instanceof MathContext && ((MathContext)x).getPrecision() == this.precision && ((MathContext)x).getRoundingMode() == this.roundingMode;
    }

    public int hashCode() {
        return this.precision << 3 | this.roundingMode.ordinal();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(45);
        sb.append(chPrecision);
        sb.append(this.precision);
        sb.append(' ');
        sb.append(chRoundingMode);
        sb.append(this.roundingMode);
        return sb.toString();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.precision < 0) {
            throw new StreamCorruptedException(Messages.getString("math.0F"));
        }
        if (this.roundingMode == null) {
            throw new StreamCorruptedException(Messages.getString("math.10"));
        }
    }
}

