/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.runtime.java.lang.reflect;

import java.lang.reflect.Method;
import net.sourceforge.retroweaver.runtime.java.lang.Class_;
import net.sourceforge.retroweaver.runtime.java.lang.annotation.AIB;
import net.sourceforge.retroweaver.runtime.java.lang.annotation.Annotation;
import net.sourceforge.retroweaver.runtime.java.lang.reflect.ReflectionDescriptor;

/*
 * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Method_ {
    private Method_() {
    }

    public static Object getDefaultValue(Method m) {
        Class<?> c = m.getDeclaringClass();
        if (!Class_.isAnnotation(c)) {
            return null;
        }
        return AIB.getAib(c).getDefaultValue(m.getName());
    }

    public static <T extends Annotation> T getAnnotation(Method m, Class<T> annotationType) {
        Class<?> c = m.getDeclaringClass();
        return AIB.getAib(c).getMethodAnnotation(m.getName(), m.getParameterTypes(), m.getReturnType(), annotationType);
    }

    public static Annotation[] getAnnotations(Method m) {
        return Method_.getDeclaredAnnotations(m);
    }

    public static Annotation[] getDeclaredAnnotations(Method m) {
        Class<?> c = m.getDeclaringClass();
        return AIB.getAib(c).getMethodAnnotations(m.getName(), m.getParameterTypes(), m.getReturnType());
    }

    public static boolean isAnnotationPresent(Method m, Class<? extends Annotation> annotationType) {
        return Method_.getAnnotation(m, annotationType) != null;
    }

    public static Annotation[][] getParameterAnnotations(Method m) {
        Class<?> c = m.getDeclaringClass();
        return AIB.getAib(c).getMethodParameterAnnotations(m.getName(), m.getParameterTypes(), m.getReturnType());
    }

    public static boolean isBridge(Method m) {
        Class<?> c = m.getDeclaringClass();
        return ReflectionDescriptor.getReflectionDescriptor(c).testMethodAccess(m, 64);
    }

    public static boolean isVarArgs(Method m) {
        Class<?> c = m.getDeclaringClass();
        return ReflectionDescriptor.getReflectionDescriptor(c).testMethodAccess(m, 128);
    }

    public static boolean isSynthetic(Method m) {
        Class<?> c = m.getDeclaringClass();
        return ReflectionDescriptor.getReflectionDescriptor(c).testMethodAccess(m, 4096);
    }
}

