
/* rlexamp.q: GNU readline example */

import system;

/* A convenience function which reads a line using readline and enters it into
   the history if it is nonempty. */

get_line PROMPT	= if not null LINE then add_history LINE || LINE
		    where LINE:String = readline PROMPT;

/* Set up a custom completion function. */

def RL_COMPLETION_FUNCTION = complete;

/* A simple completion function. Checks a list of "command" words for possible
   completions. */

complete S _	= filter (is_prefix S) ["bar","foo","gnats","gnu"];

/* This does the same, but only performs completion at the beginning of a line
   (position index 0). */

complete2 S 0	= filter (is_prefix S) ["bar","foo","gnats","gnu"];

/* Like above, but also suppresses readline's default (filename) completion if
   no custom completion is available. This is signalled by ending the list of
   completions with a () entry. */

complete3 S 0	= filter (is_prefix S) ["bar","foo","gnats","gnu"] ++ [()];
complete3 _ _	= [()] otherwise;

/* Check whether X is a prefix of Y. Used as a filter predicate in the
   completion functions. */

is_prefix X Y	= (X=sub Y 0 (#X-1));
