
/* dxl_sample: more elaborate DX interface example 03-05-02 AG */

/* This script illustrates data file generation using the dxl_file function,
   and also shows how to communicate with the DX program via DXLInput/Output.
   The corresponding DX program, which shows the connections in the input
   data, is in dxl_sample.net; this is a simple visual program which you can
   look at with dx -edit.

   There are four parameterless functions for creating sample input data on
   different kinds of grids: `regular', `skewed', `warped' and `irregular'.
   These examples have been taken from the DX manual. Each of the four
   functions creates a temporary data file using the dxl_file function. The
   result returned by these functions is simply the name of the created data
   file, which you can pass to the `image' function.

   To fire up DX with all images, one after another, enter the following:

   ==> image regular || image skewed || image warped || image irregular

   The `image' function invokes DX with the dxl_sample.net program in exec-
   on-change mode, passes the data file name into the DX program, and monitors
   the `camera' output value from the DX program, which contains the current
   "from" point extracted from the camera of the DX image. You can see this
   value change as you rotate the image with the left mouse button. When
   you're done with the image, just close the DX window. The `image' function
   then deletes the temporary data file and returns (). */

include dxl, system;

image NAME:String
	= // load the DX program and set up input and output channels
	  dxl_load H "dxl_sample.net" ||
	  dxl_input H "filename" (str NAME) ||
	  dxl_output H "camera" ||
	  // execute the program
	  dxl_exec_on_change H ||
	  // keep polling for results until the user terminates the
	  // application by closing the anchor window
	  poll H ||
	  // delete the temporary data file
	  unlink NAME
	  where H:DXLHandle = dxl_start "dx -image";

	= writes "Error loading image\n" otherwise;

poll H:DXLHandle
	= printf "%s = %s\n" (dxl_read H) || poll H if dxl_ready H;
	= () otherwise;

// catch error messages returned by dxl_read

dxl_error MSG    = printf "DXL error: %s\n" MSG;

// different data sets to try (taken from "IBM Visualization Data Explorer
// User's Guide", Appendix B.2)

def DATA
	= [1.0, 3.4, 5.0, 2.0,
	   3.4, 5.1, 0.3, 4.5,
	   1.0, 2.3, 4.1, 2.1,
	   6.0, 8.0, 9.1, 2.3,
	   4.5, 5.0, 3.0, 4.3,
	   1.2, 1.2, 3.0, 3.2];

regular	= dxl_file tmpnam
	  (regular_positions [4,2,3] [0,0,0] [[1,0,0],[0,2,0],[0,0,1]])
	  (regular_connections [4,2,3] "cubes")
	  (data "data" "positions" "float" [] DATA);

skewed	= dxl_file tmpnam
	  (regular_positions [4,2,3] [0,0,0] [[1,0.2,0],[0,2,0],[0,0,1]])
	  (regular_connections [4,2,3] "cubes")
	  (data "data" "positions" "float" [] DATA);

warped	= dxl_file tmpnam
	  (positions 3
	   [0.0,	0.0,		0.0,
	    0.0,	0.0,		1.0,
	    0.0,	0.0,		2.0,
	    0.0,	2.0,		0.0,
	    0.0,	2.0,		1.0,
	    0.0,	2.0,		2.0,
	    1.0,	0.841471,	0.0,
	    1.0,	0.841471,	1.0,
	    1.0,	0.841471,	2.0,
	    1.0,	2.841471,	0.0,
	    1.0,	2.841471,	1.0,
	    1.0,	2.841471,	2.0,
	    2.0,	0.9092974,	0.0,
	    2.0,	0.9092974,	1.0,
	    2.0,	0.9092974,	2.0,
	    2.0,	2.909297,	0.0,
	    2.0,	2.909297,	1.0,
	    2.0,	2.909297,	2.0,
	    3.0,	0.14112,	0.0,
	    3.0,	0.14112,	1.0,
	    3.0,	0.14112,	2.0,
	    3.0,	2.14112,	0.0,
	    3.0,	2.14112,	1.0,
	    3.0,	2.14112,	2.0])
	  (regular_connections [4,2,3] "cubes")
	  (data "data" "positions" "float" [] DATA);

irregular
	= dxl_file tmpnam
	  (positions 3
	   [0.0,	0.0,		0.0,
	    0.0,	0.0,		1.0,
	    0.0,	0.0,		2.0,
	    0.0,	2.0,		0.0,
	    0.0,	2.0,		1.0,
	    0.0,	2.0,		2.0,
	    1.0,	0.841471,	0.0,
	    1.0,	0.841471,	1.0,
	    1.0,	0.841471,	2.0,
	    1.0,	2.841471,	0.0,
	    1.0,	2.841471,	1.0,
	    1.0,	2.841471,	2.0,
	    2.0,	0.9092974,	0.0,
	    2.0,	0.9092974,	1.0,
	    2.0,	0.9092974,	2.0,
	    2.0,	2.909297,	0.0,
	    2.0,	2.909297,	1.0,
	    2.0,	2.909297,	2.0,
	    3.0,	0.14112,	0.0,
	    3.0,	0.14112,	1.0,
	    3.0,	0.14112,	2.0,
	    3.0,	2.14112,	0.0,
	    3.0,	2.14112,	1.0,
	    3.0,	2.14112,	2.0])
	  (connections 4 "tetrahedra"
	   [10,	3,	4,	1,
	    3,	10,	9,	6,
	    10,	1,	7,	6,
	    6,	1,	3,	10,
	    6,	1,	0,	3,
	    10,	1,	4,	5,
	    5,	1,	8,	10,
	    8,	5,	2,	1,
	    10,	8,	7,	1,
	    5,	8,	11,	10,
	    15,	6,	9,	10,
	    10,	6,	13,	15,
	    13,	10,	7,	6,
	    15,	13,	12,	6,
	    10,	13,	16,	15,
	    17,	10,	11,	8,
	    10,	17,	16,	13,
	    17,	8,	14,	13,
	    13,	8,	10,	17,
	    13,	8,	7,	10,
	    22,	15,	16,	13,
	    15,	22,	21,	18,
	    22,	13,	19,	18,
	    18,	13,	15,	22,
	    18,	13,	12,	15,
	    22,	13,	16,	17,
	    17,	13,	20,	22,
	    20,	17,	14,	13,
	    22,	20,	19,	13,
	    17,	20,	23,	22])
	  (data "data" "positions" "float" [] DATA);
