/****************************************************************************
    Qt-BSch3V schematic capture
    Copyright (C) 2002-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#ifndef SELCOMP_H
#define SELCOMP_H
#include "selcomp.h"

#include <string>
#include <QScrollArea>

#include "componentview.h"

using namespace std;
class SCompIndex;

class SelComp : protected selcompBase
{ 
    Q_OBJECT

protected:
	QScrollArea* componentView;
	SComponentWidget* componentWidget;

    void libraryChanged();
    void componentChanged();
	void editnameChanged();
	void setLibraryName();
	void setComponentName(int nLib);

	string m_strComponentName;
	int m_nLib;
	int m_nIndex;
	const SCompIndex* m_pCompIndex;

	bool editchangeName;
	bool compSelectionChange;


public:
    SelComp( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, Qt::WFlags fl = 0 );
    ~SelComp();
	
	int exec();
	const SCompIndex* selectedCompIndex() const{return m_pCompIndex;}
	int selectedCompLibNum() const{return m_nLib;}
	int selectedCompIndexNum() const{return m_nIndex;}

protected:
	void accept();
};

#endif // SELCOMP_H
