/****************************************************************************
    Qt-BSch3V schematic capture
    Copyright (C) 2002-2006 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <qpainter.h>
#include <qcolor.h>
#include <qtimer.h>
//Added by qt3to4:
#include <QWheelEvent>
#include <QPixmap>
#include <QEvent>
#include <QResizeEvent>
#include <QMouseEvent>
#include <string>
using namespace std;
#include <qapplication.h>
#include <qbitmap.h>
#include <qcursor.h>
#include <qmessagebox.h>
#include <qfont.h>
#include "cfgdata.h"
#include "coord.h"


#include "xbsch.h"
#include "xbschobj.h"
#include "xbschview.h"
#include "xbschdoc.h"
#include "xbschjunc.h"
#include "xbschline.h"
#include "xbschentry.h"
#include "xbschlabel.h"
#include "xbschtag.h"
#include "xbschcomponent.h"
#include "xbschcomment.h"
#include "drawcomponent.h"

#include "complib.h"

#include "editlabelimpl.h"
#include "edittagimpl.h"
#include "selcompimpl.h"
//#include "editcommentimpl.h"
#include "editcomponentimpl.h"
#include "editcommentdlg.h"
//#include "sheetsizeimpl.h"
#include "setSheetSize.h"
#include "drawobject.h"

#include "xbschglobal.h"


#ifdef Q_WS_MACX
	#include "curstd_b_mac.xpm"
	#include "curstd_m_mac.xpm"
	#include "curmov_b_mac.xpm"
	#include "curmov_m_mac.xpm"
#else
	#include "curstd_b.xpm"
	#include "curstd_m.xpm"
	#include "curmov_b.xpm"
	#include "curmov_m.xpm"
#endif


//QWidget * parent=0, const char * name=0, WFlags f=0 
//SXBSchView::SXBSchView()
SXBSchView::SXBSchView(QWidget * parent):
	Q3ScrollView (parent)
{
	m_fEditHighLight = true;
	//resizeContents(400,300);
	viewport()->setBackgroundColor(QColor("white"));
//	viewport()->setAttribute(Qt::WA_PaintOnScreen);		//Qt4 ɲ
	viewport()->setBackgroundMode(Qt::NoBackground);
	//setAcceptDrops(TRUE);
	//setBackgroundMode(QWidget::PaletteBase);
	//setPalette( QPalette( QColor(0,0,0) ) );

	//QObject::connect(this,SIGNAL(contentsMoving(int,int)),
	//				this,SLOT(whenScroll(int,int)));

	viewport()->setMouseTracking(true);
	
	//˥СɽˤƤʤȡСɽ/ɽȤʤ
	//ɽѹǡڥȤ2ȯݵƫ
	setHScrollBarMode(AlwaysOn);
	setVScrollBarMode(AlwaysOn);
	setDefaultFont();
//	setSmallFont(false);

	m_pDoc = new SXBSchDocSch;
	
	int w,h;
	if(g_cfg.getInt("Sheet","Width",w) && g_cfg.getInt("Sheet","Height",h)){
		m_pDoc->SetSheetSize(SSize(w,h));
	}
	//m_pDoc->SetView(viewport());
	

	int width	=m_pDoc->SheetSize().w();
	int height	=m_pDoc->SheetSize().h();
	resizeContents(width,height);
//	resizeBuffer(width,height);

	m_toolmode = TOOL_SELECTOR;
	m_bDisplayGrid 		= true;
	m_bTimer 			= false;
	m_bLButtonDown 		= false;
	m_bDrawSelectFrame 	= false;
	m_bDrawTempLine		= false;
	m_nZoom	= 2;
	setZoomValue();	//  m_viewScale, m_viewScaleMul 
	//m_viewScale 			= 1;		//ɽ̾ΨνͤϾ1
	//m_viewScaleMul 			= 1;		//ɽΨνͤϾ1
	m_pCursorObj 		= NULL;
	m_moveOption		=0;
	m_bInhibitPlaceObject = false;
	m_bReserveAttribute = false;
	m_bCompleteDrawTemp	= true;

	m_oldContentsX	= -1;
	m_oldContentsY	= -1;
	m_oldOpCount	= -1;
	m_oldViewScale	= -1;
	m_oldViewScaleMul	= -1;
	m_clearTempRect = true;

#ifdef Q_WS_MACX
	unsigned char std_b[32];
	unsigned char std_m[32];
	unsigned char mov_b[32];
	unsigned char mov_m[32];
	{	
		int i;
		for(i=0;i<32;i++)std_b[i]=curstd_b_bits[i];// ^ 0xff;
		for(i=0;i<32;i++)std_m[i]=curstd_m_bits[i];// ^ 0xff;
		for(i=0;i<32;i++)mov_b[i]=curmov_b_bits[i];// ^ 0xff;
		for(i=0;i<32;i++)mov_m[i]=curmov_m_bits[i];// ^ 0xff;
	}
	QBitmap bmp_curstd_b(16,16,(const uchar *)std_b,true);
	QBitmap bmp_curstd_m(16,16,(const uchar *)std_m,true);
	QBitmap bmp_curmov_b(16,16,(const uchar *)mov_b,true);
	QBitmap bmp_curmov_m(16,16,(const uchar *)mov_m,true);
#else
	QBitmap bmp_curstd_b(32,32,(const uchar *)curstd_b_bits,true);
	QBitmap bmp_curstd_m(32,32,(const uchar *)curstd_m_bits,true);
	QBitmap bmp_curmov_b(32,32,(const uchar *)curmov_b_bits,true);
	QBitmap bmp_curmov_m(32,32,(const uchar *)curmov_m_bits,true);
#endif
	
	
	m_pCurStd = new QCursor(bmp_curstd_b,bmp_curstd_m,0,0);
	m_pCurMov = new QCursor(bmp_curmov_b,bmp_curmov_m,0,0);

	//m_pClipboard = QApplication::clipboard();
	//QObject::connect(m_pClipboard,SIGNAL(dataChanged()),this,SLOT(clipboardChanged()) );
	//m_bCanPaste = false;
	
	connect(&m_timerTempDraw,SIGNAL(timeout()),this,SLOT(onTimerDrawTemp()));
//	connect(this,SIGNAL(contentsMoving (int,int)),this,SLOT(scrollBuffer(int,int)));
}

SXBSchView::~SXBSchView()
{
	delete m_pCurStd;
	delete m_pCurMov;
	delete m_pDoc;
}

//।󡦥Ȥ˴Ϣ᥽å
bool SXBSchView::CanZoomIn()
{
	return (m_nZoom<MAX_ZOOM);
//	if(m_viewScale>1)	return true;
//	else				return false;
}

bool SXBSchView::CanZoomOut()
{
	return (m_nZoom>0);
//	if(m_viewScale<5)	return true;
//	else				return false;
}

//̺ɸӥ塼濴ˤ
void SXBSchView::JumpTo(QPoint& jumpto)
{
	//qDebug("JumpTo() %d,%d",jumpto.x(),jumpto.y());
	int sheetw = m_pDoc->SheetSize().w();
	int sheeth = m_pDoc->SheetSize().h();

	//褬̤γʤ˽
	if(jumpto.x()>sheetw) jumpto.setX(sheetw);
	if(jumpto.y()>sheeth) jumpto.setY(sheeth);


	int viewportw = viewport()->width();
	int viewporth = viewport()->height();
	int newContentsX=jumpto.x()*m_viewScaleMul/m_viewScale-viewportw/2;
	int newContentsY=jumpto.y()*m_viewScaleMul/m_viewScale-viewporth/2;
	if(newContentsX<0) newContentsX=0;
	if(newContentsY<0) newContentsY=0;
	setContentsPos (newContentsX,newContentsY);
	QPoint pos=SheetToContents(jumpto);
	pos=contentsToViewport(pos);
	pos=viewport()->mapToGlobal(pos);
	QCursor::setPos(pos);
}



void SXBSchView::ZoomIn(bool menucommand)
{
//	qDebug("ZoomIn %d",menucommand);
//printf("SXBSchView::ZoomIn()\n");
	if(m_bLButtonDown) return;	//ܥ󲡲ϥػ

	QPoint pos;
	if(!menucommand){
		pos=QCursor::pos();
		pos=viewport()->mapFromGlobal(pos);
		pos=viewportToContents(pos);
		pos=ContentsToSheet(pos);
	}

	m_nZoom++;
	setZoomValue();	//  m_viewScale, m_viewScaleMul 

//	switch(m_viewScale){
//	case 1:
//		return;
//	case 2:
//		m_viewScale = 1;
//		break;
//	case 5:
//	default:
//		m_viewScale = 2;
//		break;
//	}
	int width	=m_pDoc->SheetSize().w()*m_viewScaleMul/m_viewScale;
	int height	=m_pDoc->SheetSize().h()*m_viewScaleMul/m_viewScale;
	resizeContents(width,height);
//	resizeBuffer(width,height);
	if(!menucommand)JumpTo(pos);
	m_clearTempRect=true;
	viewport()->update();	//̤ι
}

void SXBSchView::ZoomOut(bool menucommand)
{
//	qDebug("ZoomOut %d",menucommand);
//printf("SXBSchView::ZoomOut()\n");
	if(m_bLButtonDown) return;	//ܥ󲡲ϥػ

	QPoint pos;
	if(!menucommand){
		pos=QCursor::pos();
		pos=viewport()->mapFromGlobal(pos);	
		pos=viewportToContents(pos);
		pos=ContentsToSheet(pos);
	}

	
	m_nZoom--;
	setZoomValue();	//  m_viewScale, m_viewScaleMul 
	
//	switch(m_viewScale){
//	case 5:
//		return;
//	case 1:
//		m_viewScale = 2;
//		break;
//	case 2:
//	default:
//		m_viewScale = 5;
//		break;
//	}
	int width	=m_pDoc->SheetSize().w()*m_viewScaleMul/m_viewScale;
	int height	=m_pDoc->SheetSize().h()*m_viewScaleMul/m_viewScale;
	resizeContents(width,height);
//	resizeBuffer(width,height);
	if(!menucommand)JumpTo(pos);
	m_clearTempRect=true;
	viewport()->update();	//̤ι
}


//ԡ
void SXBSchView::copy()
{
	m_pDoc->copy();
}

//å
void SXBSchView::cut()
{
	if(m_pDoc->m_listTemp.size() > 0 ){
		m_pDoc->cut();
		viewport()->update();	//̤ι
	}
}

//ڡ
void SXBSchView::paste()
{
	if(!m_pDoc->canPaste()) return;
	if(m_toolmode != TOOL_SELECTOR){
		if(!setToolMode(TOOL_SELECTOR)) return;
		emit toolChange();
	}

//	QPainter painter(viewport());
//	painter.translate ( -contentsX(),-contentsY() );


	if(m_pDoc->m_listTemp.size() > 0 ){
//		drawTempDataFrame(&painter);
//		drawTempXBSchObj(&painter,DRAW_XOR,NULL);	
//		drawTempXBSchObj(&painter,DRAW_ON,NULL);	
		m_pDoc->resetSelect();
		updateViewBuffer(true);
		viewport()->update();	//̤ι
	}

	QPoint ptOrigin;
	QPoint ptAtSheet;
	QPoint ptCur = QCursor::pos();
	ptCur = viewport()->mapFromGlobal(ptCur);
	QSize sizeVp = QSize(visibleWidth(),visibleHeight());
	//printf("SXBSchView::paste() C:%d  %d   VP:%d  %d\n",ptCur.x(),ptCur.y(),sizeVp.width(),sizeVp.height());
	if(   (ptCur.x() < 0)
		||(ptCur.y() < 0)
		||(ptCur.x() > sizeVp.width() )
		||(ptCur.y() > sizeVp.height() ) ){
		ptOrigin = QPoint(10,10);	//뤬ӥ塼ΰ賰ʤ̺
	}else{
		ptAtSheet = viewportToContents(ptCur); 	//ΰ֤򥹥ӥ塼ɸѴ
		ptAtSheet = ContentsToSheet(ptAtSheet);	//ΰ֤̺ɸѴ
		
		if(   (ptAtSheet.x() < 10)
			||(ptAtSheet.y() < 10)
			||(ptAtSheet.x() > (m_pDoc->SheetSize().w()-10) )
			||(ptAtSheet.y() > (m_pDoc->SheetSize().h()-10) ) ){
			ptOrigin = QPoint(10,10);
		}else{
			ptOrigin = ptCur;
		}
	}
	ptOrigin = viewportToContents(ptOrigin); 	//ְ֤򥹥ӥ塼ɸѴ
	ptOrigin = ContentsToSheet(ptOrigin);		//ְ֤̺ɸѴ
	
	ptOrigin = snapPoint(ptOrigin);

	//printf("SXBSchView::paste()2 :%d  %d \n",ptOrigin.x(),ptOrigin.y());
	if(m_pDoc->paste( SPoint(ptOrigin.x(),ptOrigin.y()) )){
//		drawTempXBSchObj(&painter,DRAW_XOR,NULL);	
//		m_pDoc->setupRcTempArea();
//		m_pDoc->setupRotateRect();
//		drawTempDataFrame(&painter);
		m_clearTempRect=true;		//2005/05/14
		viewport()->update();	//̤ι
		m_bCompleteDrawTemp = true;
	}
	//repaint(TRUE);
	//viewport()->update();	//̤ι
}

//
void SXBSchView::del()
{
//	QPainter painter(viewport());
//	painter.translate ( -contentsX(),-contentsY() );

	if(m_pDoc->m_listTemp.size() > 0 ){
//		drawTempDataFrame(&painter);
//		drawTempXBSchObj(&painter,DRAW_XOR,NULL);	
		m_pDoc->del();
	}
	//repaint(TRUE);
	viewport()->update();	//̤ι
}

void SXBSchView:: moveToLayer(int nLayer)
{
	if(!canMoveToLayer(nLayer))return;
	m_pDoc->moveToLayer(nLayer);
	m_pDoc->resetSelect();
	viewport()->update();	//̤ι
}

//UNDO
void SXBSchView::undo()
{
	m_pDoc->undo();
	updateViewBuffer(true);
	viewport()->update();	//̤ι
}

//ɽ˴ؤ
void SXBSchView::RefreshView()
{
	updateViewBuffer(true);
	viewport()->update();
}


//Attribute
void SXBSchView::attribute()
{
	if(!m_pDoc->canAttribute()) return;
	XBSchObjListIterator pObjIte =m_pDoc->m_listTemp.begin();
	switch((*pObjIte)->id()){
	case SXBSchObj::ID_LABEL:
		execLabelAttributeDlg((SXBSchLabel*)(*pObjIte));
		break;
	case SXBSchObj::ID_TAG:
		execTagAttributeDlg((SXBSchTag*)(*pObjIte));
		break;
	case SXBSchObj::ID_COMPONENT:
		execComponentAttributeDlg((SXBSchComponent*)(*pObjIte));
		break;
	case SXBSchObj::ID_COMMENT:
		execCommentAttributeDlg((SXBSchComment*)(*pObjIte));
		break;
	}
}


void SXBSchView::setDefaultFont()
{
	string strname;
	if(g_cfg.getString("Font","Name",strname)){
		QFont font(QString::fromLocal8Bit(strname.c_str()));
		int n;
		if(g_cfg.getInt("Font","Size",n)){
			if(n<4)n=4;
			font.setPixelSize(n);
		}
		if(g_cfg.getInt("Font","Bold",n)) font.setBold(n!=0);
		if(g_cfg.getInt("Font","Italic",n)) font.setItalic(n!=0);
		if(g_cfg.getInt("Font","Underline",n)) font.setStrikeOut(n!=0);
		if(g_cfg.getInt("Font","StrikeOut",n)) font.setUnderline(n!=0);
		g_defaultfont=font;
	}
}
/*
//٥롢ǻȤեȤԤʤ
void SXBSchView::setSmallFont(bool updateview)
{
	string strname;
	if(g_cfg.getString("SmallFont","Name",strname)){
		QFont font(QString::fromLocal8Bit(strname.c_str()));
		int n;
		if(g_cfg.getInt("SmallFonFont","Size",n)){
			if(n<4)n=4;
			font.setPixelSize(n);
		}
		if(g_cfg.getInt("SmallFont","Bold",n)) font.setBold(n!=0);
		if(g_cfg.getInt("SmallFont","Italic",n)) font.setItalic(n!=0);
		if(g_cfg.getInt("SmallFont","Underline",n)) font.setStrikeOut(n!=0);
		if(g_cfg.getInt("SmallFont","StrikeOut",n)) font.setUnderline(n!=0);
		m_smallfont=font;
		g_SmallFont.SetFont(font);
		if(updateview){
			m_clearTempRect = true;
			updateViewBuffer(true);
			viewport()->update();
		}
	}
}
*/

//ȤΥȥӥ塼ѹư
void SXBSchView::execCommentAttributeDlg(SXBSchComment* pComment)
{
	editcommentdlg *dlg = new editcommentdlg(this);
    //editcomment *dlg = new editcomment(this,0,true);
	dlg->setText(QString::fromLocal8Bit(pComment->text()));
	if(strlen(pComment->fontName())!=0){
		QFont font(QString::fromLocal8Bit(pComment->fontName()));
		font.setPixelSize(pComment->fontSize());
		font.setBold(pComment->fontBold());
		font.setItalic(pComment->fontItalic());
		font.setStrikeOut(pComment->fontStrikeOut());
		font.setUnderline(pComment->fontUnderline());
		dlg->setFont(font);
	}

	if ( dlg->exec() ) {
        // user clicked OK
		//qDebug((dlg->text()).local8Bit());
		//QPainter painter(viewport());
		//painter.translate ( -contentsX(),-contentsY() );
		//drawTempDataFrame(&painter);
		//drawTempXBSchObj(&painter,DRAW_XOR,NULL);	
		if(!dlg->text().isEmpty()){
			pComment->setText(dlg->text().local8Bit());
			pComment->setFontName(dlg->font().family().local8Bit());
//			QFontInfo fontInfo(dlg->font());				//2003/06/14 Qt3б
//			pComment->setFontSize(fontInfo.pixelSize());	//2003/06/14 Qt3б
			pComment->setFontSize(dlg->font().pixelSize()); //2003/06/14 Qt3б
			pComment->setFontBold(dlg->font().bold());
			pComment->setFontItalic(dlg->font().italic());
			pComment->setFontUnderline(dlg->font().underline());
			pComment->setFontStrikeOut(dlg->font().strikeOut());
			pComment->setSelection(SXBSchObj::SELECT_ALL);
			//g_cfg.setString("Font","Name",pComment->fontName());
			//g_cfg.setInt("Font","Size",pComment->fontSize());
			//g_cfg.setInt("Font","Bold",(pComment->fontBold()?1:0));
			//g_cfg.setInt("Font","Italic",(pComment->fontItalic()?1:0));
			//g_cfg.setInt("Font","Underline",(pComment->fontUnderline()?1:0));
			//g_cfg.setInt("Font","StrikeOut",(pComment->fontStrikeOut()?1:0));
			//drawTempXBSchObj(&painter,DRAW_XOR,NULL);
			//viewport()->update();
			m_clearTempRect = true;
//			m_pDoc->setupRcTempArea();
//			m_pDoc->setupRotateRect();
			//drawTempDataFrame(&painter);
			m_pDoc->setTempDirty();
			m_clearTempRect=true;		//2005/05/14
		}else{
			m_pDoc->del();
		}
		viewport()->update();
	}
//#ifndef _WINDOWS
//	viewport()->update();
//#endif
	delete dlg;
}



//٥Υȥӥ塼ѹư
void SXBSchView::execLabelAttributeDlg(SXBSchLabel* pObj)
{
//	qDebug("SXBSchView::execLabelAttributeDlg()\n");
	EditLabel *dlg = new EditLabel(this,0,true);
	dlg->setText(QString::fromLocal8Bit(pObj->text()));
	if ( dlg->exec() ) {
        // user clicked OK
		//qDebug((dlg->text()).local8Bit());
		//QPainter painter(viewport());
		//painter.translate ( -contentsX(),-contentsY() );
		//drawTempDataFrame(&painter);
		//drawTempXBSchObj(&painter,DRAW_OFF,NULL);	
		if(!dlg->text().isEmpty()){
			pObj->setText(dlg->text().latin1());
			m_pDoc->setupRcTempArea();
			m_pDoc->setupRotateRect();
			//drawTempXBSchObj(&painter,DRAW_XOR,NULL);	
			//drawTempDataFrame(&painter);
			m_pDoc->setTempDirty();
			m_clearTempRect=true;		//2005/05/14
		}else{
			m_pDoc->del();
		}
		viewport()->update();
	}
	delete dlg;
}


//Υȥӥ塼ѹư
void SXBSchView::execTagAttributeDlg(SXBSchTag* pObj)
{
	EditTag *dlg = new EditTag(this,0,true);
	dlg->setText(QString::fromLocal8Bit(pObj->text()));
	dlg->setType(pObj->tagType());
	if ( dlg->exec() ) {
        // user clicked OK
		//qDebug((dlg->text()).local8Bit());
		//QPainter painter(viewport());
		//painter.translate ( -contentsX(),-contentsY() );
		//drawTempDataFrame(&painter);
		//drawTempXBSchObj(&painter,DRAW_OFF,NULL);	
		pObj->setText(dlg->text().latin1());
		pObj->setTagType(dlg->type());
		m_pDoc->setupRcTempArea();
		m_pDoc->setupRotateRect();
		m_pDoc->setTempDirty();
		//drawTempXBSchObj(&painter,DRAW_XOR,NULL);	
		//drawTempDataFrame(&painter);
		m_clearTempRect=true;		//2005/05/14
		viewport()->update();
	}
	delete dlg;
}

//ʤΥȥӥ塼ѹư
void SXBSchView::execComponentAttributeDlg(SXBSchComponent* pObj)
{
	editcomponent *dlg = new editcomponent(this,0,true);
	dlg->setNote( QString::fromLocal8Bit(pObj->note()));
	dlg->setName( QString::fromLocal8Bit(pObj->name()));
	dlg->setOrgName( QString::fromLocal8Bit(pObj->orgname()));
	dlg->setReference( QString::fromLocal8Bit(pObj->refnum()));
	dlg->setBlock( pObj->block());
	dlg->setCompIndex(pObj->compInfoIndex());
	dlg->setNameVertical(!(pObj->nameHorizontal()));
	dlg->setReferenceVertical(!(pObj->refnumHorizontal()));
	if ( dlg->exec() ) {
		//QPainter painter(viewport());
		//painter.translate ( -contentsX(),-contentsY() );
		//drawTempDataFrame(&painter);
		//drawTempXBSchObj(&painter,DRAW_OFF,NULL);
		pObj->setNote(dlg->note().local8Bit());
		pObj->setName(dlg->name().local8Bit());
		pObj->setRefnum(dlg->reference().latin1());
		pObj->setBlock(dlg->block());
		
		pObj->setNameHorizontal(!(dlg->nameVertical()));
		pObj->setRefnumHorizontal(!(dlg->referenceVertical()));
		
		//drawTempXBSchObj(&painter,DRAW_XOR,NULL);	
		//drawTempDataFrame(&painter);
		m_pDoc->setTempDirty();
		m_clearTempRect=true;		//2005/05/14
		viewport()->update();
	}
	delete dlg;
}



//Rotate
void SXBSchView::rotate()
{
	if(m_pCursorObj){
		//QPainter painter(viewport());
		//painter.translate ( -contentsX(),-contentsY() );
		//drawCursorObj(&painter);
		m_pCursorObj->rotate();
		//drawCursorObj(&painter);
		viewport()->update();
		return;
	}

	if(!m_pDoc->canRotate()) return;
//	QPainter painter(viewport());
//	painter.translate ( -contentsX(),-contentsY() );

//	drawTempDataFrame(&painter);
//	drawTempXBSchObj(&painter,DRAW_XOR,NULL);	
	m_pDoc->rotate();
//	drawTempXBSchObj(&painter,DRAW_XOR,NULL);	
//	drawTempDataFrame(&painter);
	viewport()->update();
}

//Mirror
void SXBSchView::mirror()
{
	if(m_pCursorObj){
		//QPainter painter(viewport());
		//painter.translate ( -contentsX(),-contentsY() );
		//drawCursorObj(&painter);
		m_pCursorObj->rotate();
		//drawCursorObj(&painter);
		viewport()->update();
		return;
	}

	
	if(!m_pDoc->canMirror()) return;
//	QPainter painter(viewport());
//	painter.translate ( -contentsX(),-contentsY() );

//	drawTempDataFrame(&painter);
//	drawTempXBSchObj(&painter,DRAW_XOR,NULL);	
	m_pDoc->mirror();
//	drawTempXBSchObj(&painter,DRAW_XOR,NULL);	
//	drawTempDataFrame(&painter);
	viewport()->update();	//̤ι
}

//Invert()
void SXBSchView::invert()
{
}

//ġ˴Ϣ᥽å
bool SXBSchView::setToolMode(BSCH_TOOL_MODE mode)
{
	if(m_bLButtonDown) return false;	//ܥ󲡲ϥġѹԤʤ

//	QPainter painter(viewport());
//	painter.translate ( -contentsX(),-contentsY() );
	
	if(m_pDoc->m_listTemp.size()>0){
//		drawTempDataFrame(&painter);
//		drawTempXBSchObj(&painter,DRAW_OFF,NULL);	//OFFǤϾäʤȤ
//		drawTempXBSchObj(&painter,DRAW_XOR,NULL);	//OFFǤϾäʤȤ
//		drawTempXBSchObj(&painter,DRAW_ON,NULL);	
		m_pDoc->resetSelect();
		updateViewBuffer(true);
		viewport()->update();

	}
	//դޤȤ̥֥Ȥθ
	if(m_pCursorObj){
		//drawCursorObj(&painter);
		delete m_pCursorObj;
		m_pCursorObj = NULL;
		viewport()->update();
	}
	

//	m_toolmode = mode;

	switch(mode){
	case TOOL_SELECTOR:
		if(m_toolmode == TOOL_SELECTOR){
			viewport()->update();
		}
		break;
	case TOOL_JUNCTION:
		m_pCursorObj = (SXBSchObj*) new SXBSchJunc;
		m_pCursorObj->setP1(SPoint(-100,-100));
		break;
	case TOOL_ENTRY:
		m_pCursorObj = (SXBSchObj*) new SXBSchEntry;
		m_pCursorObj->setP1(SPoint(-100,-100));
		break;
	case TOOL_BENTRY:
		m_pCursorObj = (SXBSchObj*) new SXBSchBusEntry;
		m_pCursorObj->setP1(SPoint(-100,-100));
		break;
	default:
		break;
	}
	m_toolmode = mode;

	return true;
}


//åɽ˴Ϣ᥽å
void SXBSchView::setDisplayGrid(bool display)
{
	m_bDisplayGrid = display;
	m_oldOpCount = -1;
	viewport()->update();
}

//ʥåפξ֤˴Ϣ᥽å
void SXBSchView::setSnapGrid(bool snap)
{
	if(m_bLButtonDown) return;
	m_bSnapGrid = snap;
}

//ȥεư
void SXBSchView::resize()
{
//	sheetsize *dlg = new sheetsize(this,0,true);
//	dlg->setWidth(m_pDoc->SheetSize().w());
//	dlg->setHeight(m_pDoc->SheetSize().h());
//	if(dlg->exec()){
//		int w = dlg->width();
//		int h = dlg->height();
//		delete dlg;
//		SetSheetSize(QSize(w,h));
//		g_cfg.setInt("Sheet","Width",w);
//		g_cfg.setInt("Sheet","Height",h);
//	}else{
//		delete dlg;
//	}
	
	setSheetSizeDlg dlg(this);
	dlg.m_width  = m_pDoc->SheetSize().w();
	dlg.m_height = m_pDoc->SheetSize().h();
	if(dlg.exec()){
		int w = dlg.m_width;
		int h = dlg.m_height;
		SetSheetSize(QSize(w,h));
		g_cfg.setInt("Sheet","Width",w);
		g_cfg.setInt("Sheet","Height",h);
	}			
}

//ȥ
void SXBSchView::SetSheetSize(const QSize& s)
{
 	//ɥȤؤ
 	m_pDoc->SetSheetSize(SSize(s.width(),s.height()));
	//ӥ塼κ
	int width	=m_pDoc->SheetSize().w()*m_viewScaleMul/m_viewScale;
	int height	=m_pDoc->SheetSize().h()*m_viewScaleMul/m_viewScale;
	resizeContents(width,height);
//	resizeBuffer(width,height);
	setAutoScrollValue();
	m_oldOpCount = -1;
	viewport()->update();	//̤ι
}

//ȥμ
QSize SXBSchView::SheetSize()
{
	QSize size(m_pDoc->SheetSize().w(),m_pDoc->SheetSize().h());
	return size;
}


//ե¸
int SXBSchView::save(const QString& fname)
{
	int nResult = m_pDoc->writeFile(fname.local8Bit());
	updateViewBuffer(true);
	viewport()->update();	//̤ι
	return nResult;
}

//ե뤫ɤ߹
int SXBSchView::load(const QString& fname)
{
	//qDebug("SXBSchView::load() %s\n",(const char*)fname.local8Bit());
	int nResult = m_pDoc->readFile(fname.local8Bit());
	if(!nResult){//0ｪλ
		int width	=m_pDoc->SheetSize().w()*m_viewScaleMul/m_viewScale;
		int height	=m_pDoc->SheetSize().h()*m_viewScaleMul/m_viewScale;
		resizeContents(width,height);
//		resizeBuffer(width,height);
		setAutoScrollValue();
	}
	m_oldOpCount = -1;
	viewport()->update();	//̤ι
	return nResult;
}

//᡼եν
bool SXBSchView::exportImage(const QString& fname)
{
	m_pDoc->resetSelect();
	updateViewBuffer(true);
	char* pszFormat;

	int w=SheetSize().width();
	int h=SheetSize().height();

//#ifdef _WINDOWS
//	QPixmap buffer(w,h,1);
//	pszFormat="BMP";
//#else
	QPixmap buffer(w,h);
	pszFormat="PNG";
//	QPixmap buffer(w,h);
//	pszFormat="XPM";
//#endif

	QPainter painter;
	painter.begin(&buffer);
	QRect rcClip = QRect(0,0,w,h);
	SRect srcClip =SRect(0,0,w,h);

//	int currentScale = m_viewScale;
//	int currentScaleMul = m_viewScaleMul;
	
//	m_viewScale=1;
//	m_viewScaleMul=1;
	SSize size=m_pDoc->SheetSize();

//#ifdef _WINDOWS
//	painter.setBackgroundColor(Qt::color0);
//	painter.eraseRect(0,0,w,h);
//	g_drawFrame(&painter,size,rcClip,Qt::color1,1,1);
//	drawMainXBSchObj(&painter,DRAW_MONO,&srcClip,1,1);
//#else
	painter.setBackgroundColor(Qt::white);
	painter.eraseRect(0,0,w,h);
	g_drawFrame(&painter,size,rcClip,Qt::black,1,1);
//	drawMainXBSchObj(&painter,DRAW_ON,&srcClip);
	drawMainXBSchObj(&painter,DRAW_MONO,&srcClip,false,1,1);
//#endif
//	m_viewScale = currentScale;
//	m_viewScaleMul = currentScaleMul;
	bool result=buffer.save(fname,pszFormat);


	//qDebug("SXBSchView::exportImage(const QString& fname)");

	viewport()->update();	//̤ι
	return result;
}


//ޥ줿Ȥ˸ƤФ롣
void SXBSchView::contentsMousePressEvent(QMouseEvent* me)
{
//	printf("SXBSchView::contentsMousePressEvent()\n");
//	printf("  X=%d  Y=%d\n",me->x(),me->y());
//	printf("  ContentsX=%d  ContentsY=%d\n",contentsX(),contentsY());
//	printf("  VisibleWidth=%d  VisibleHeight=%d\n", visibleWidth(), visibleHeight());
	
	m_bInhibitPlaceObject = false;
	m_bReserveAttribute = false;

	QPoint ptAtSheet = ContentsToSheet(QPoint(me->x(),me->y()));

	QPoint ptSnap;
	if(m_bSnapGrid) ptSnap = snapPoint(ptAtSheet);
	else			ptSnap = ptAtSheet;


//	QPainter painter(viewport());
//	painter.translate ( -contentsX(),-contentsY() );


//	QPainter *ppainter;

	SXBSchObj* pObj;

	if(me->button() & Qt::LeftButton){
		m_ptLButtonDownAtSheet = ptAtSheet;
		m_bLButtonDown = true;

		QPoint qpSnapTempSnapPoint(m_pDoc->tempSnapPoint().x(),m_pDoc->tempSnapPoint().y());

		int onFlag; 
		//ǡ¸ߤ
		if(m_pDoc->m_listTemp.size() > 0 ){
			m_bInhibitPlaceObject = true;
			onFlag = m_pDoc->isOnTempData(SPoint(m_ptLButtonDownAtSheet.x(),m_ptLButtonDownAtSheet.y()));
			if(onFlag){
				if(m_bSnapGrid){
					QPoint ptSnapTempObject = snapPoint(qpSnapTempSnapPoint);
					if(ptSnapTempObject != qpSnapTempSnapPoint){
						int snapx = ptSnapTempObject.x() - qpSnapTempSnapPoint.x();
						int snapy = ptSnapTempObject.y() - qpSnapTempSnapPoint.y();
						//ppainter = new QPainter(viewport());
						//ppainter->translate ( -contentsX(),-contentsY() );
						//drawTempDataFrame(ppainter);
						//drawTempXBSchObj(ppainter,DRAW_XOR,NULL);
						m_pDoc->moveTempData(snapx,snapy);
						//drawTempXBSchObj(ppainter,DRAW_XOR,NULL);
						//drawTempDataFrame(ppainter);
						//delete ppainter;
						viewport()->update();
					}
				}

				//ưץ
				if(m_pDoc->m_listTemp.size()==1){
					if(onFlag & ON_NAME){
						m_moveOption = MOVE_OPTION_COMPONENT_NAME;
						updateViewBuffer(true);
						//qDebug("Move component name");
					}else if(onFlag & ON_NUM){
						m_moveOption = MOVE_OPTION_COMPONENT_NUM;
						updateViewBuffer(true);
						//qDebug("Move component num");
					}else{
						m_moveOption = 0;
					}
				}else{
					m_moveOption = 0;
				}
				//m_ptLastMoveTempAtSheet = ptSnap;
				m_ptLastMoveTempAtSheet = ptAtSheet;
				return;
			}else{
				//ܥ󲡲ݥȤǡ鳰Ƥ
				//ǡ֤

				//ppainter = new QPainter(viewport());
				//ppainter->translate ( -contentsX(),-contentsY() );
				//drawTempDataFrame(ppainter);
				//drawTempXBSchObj(ppainter,DRAW_OFF,NULL); //OFFǤXORäʤȤ
				//drawTempXBSchObj(ppainter,DRAW_OFF,NULL);
				//drawTempXBSchObj(ppainter,DRAW_ON,NULL);	
				//delete ppainter;
				m_pDoc->resetSelect();
				updateViewBuffer(true);
				viewport()->update();

				// 2002/04/21 ΤȤˤΤޤ޿ֺȤԤʤ
				if(    m_toolmode==TOOL_COMMENT
					|| m_toolmode==TOOL_LABEL
					|| m_toolmode==TOOL_TAG
					|| m_toolmode==TOOL_COMPONENT) return;
			}	
		}

		switch(m_toolmode){
		case TOOL_WIRE:
		case TOOL_BUS:
		case TOOL_DASH:
			m_ptLastMoveAtContents = QPoint(me->x(),me->y());
			m_ptLastMoveAtSheet = ptAtSheet;
			m_bDrawTempLine = true;
			m_nTempLineOrder = 0;
			break;
		case TOOL_SELECTOR:
		case TOOL_DRAG:
			m_ptLastMoveAtContents = QPoint(me->x(),me->y());
			m_ptLastMoveAtSheet = ptAtSheet;
			m_bDrawSelectFrame = true;
			break;
		case TOOL_JUNCTION:
		case TOOL_ENTRY:
		case TOOL_BENTRY:
			if(m_pCursorObj != NULL){
				//ppainter = new QPainter(viewport());
				//ppainter->translate ( -contentsX(),-contentsY() );
				//drawCursorObj(ppainter);
		//	pObj = (SXBSchObj*) new SXBSchJunc;
		//	pObj->setP1(ptSnap);
		//	drawJunction(&painter,pObj,DRAW_ON);
				pObj = m_pCursorObj->duplicate();
				//drawXBSchObj(ppainter,pObj,DRAW_ON,NULL);
				m_pDoc->addSelect(pObj);
				m_pDoc->resetSelect();
				viewport()->update();	//̤ι
				//drawCursorObj(ppainter);
				//delete ppainter;
			}
			break;
/*
		case TOOL_COMMENT:
			m_bLButtonDown = false;
			if(placeComment(ptSnap)){
				ppainter = new QPainter(viewport());
				ppainter->translate ( -contentsX(),-contentsY() );
				drawTempXBSchObj(ppainter,DRAW_XOR,NULL);
				m_pDoc->setupRcTempArea();
				drawTempDataFrame(ppainter);
				m_bCompleteDrawTemp=true;
				delete ppainter;
			}
			break;

		case TOOL_LABEL:
			m_bLButtonDown = false;
			if(placeLabel(ptSnap)){
				ppainter = new QPainter(viewport());
				ppainter->translate ( -contentsX(),-contentsY() );
				drawTempXBSchObj(ppainter,DRAW_XOR,NULL);
				drawTempDataFrame(ppainter);
				m_bCompleteDrawTemp=true;
				delete ppainter;
			}
			break;

		case TOOL_TAG:
			m_bLButtonDown = false;
			if(placeTag(ptSnap)){
				ppainter = new QPainter(viewport());
				ppainter->translate ( -contentsX(),-contentsY() );
				drawTempXBSchObj(ppainter,DRAW_XOR,NULL);
				drawTempDataFrame(ppainter);
				m_bCompleteDrawTemp=true;
				delete ppainter;
			}
			break;

		case TOOL_COMPONENT:
			m_bLButtonDown = false;
			if(placeComponent(ptSnap)){
				ppainter = new QPainter(viewport());
				ppainter->translate ( -contentsX(),-contentsY() );
				drawTempXBSchObj(ppainter,DRAW_XOR,NULL);
				drawTempDataFrame(ppainter);
				m_bCompleteDrawTemp=true;
				delete ppainter;
			}
			break;			
*/

		default:
			break;
		}
	}
}

void SXBSchView::contentsMouseDoubleClickEvent(QMouseEvent *me)
{
	QPoint ptAtSheet = ContentsToSheet(QPoint(me->x(),me->y()));

	QPoint ptSnap;
	if(m_bSnapGrid) ptSnap = snapPoint(ptAtSheet);
	else			ptSnap = ptAtSheet;
	//QPainter *ppainter;

	if(m_toolmode == TOOL_WIRE){
		//ppainter = new QPainter(viewport());
		//ppainter->translate ( -contentsX(),-contentsY() );
		SXBSchObj* pObj = (SXBSchObj*) new SXBSchJunc;
		pObj->setP1(SPoint(ptSnap.x(),ptSnap.y()));
		//drawJunction(ppainter,pObj,DRAW_ON);
		m_pDoc->addSelect(pObj);
		m_pDoc->resetSelect();
		//delete ppainter;
		viewport()->update();
	}else{
		m_bReserveAttribute = true;
		//releaseMouse(); //PantherǤ줬ޤưƤʤ餷
		//attribute();
	}

}


void  SXBSchView::contentsWheelEvent ( QWheelEvent *e )
{
//	qDebug("Wheel %d\n",e->delta());
	if(e->delta()>0)ZoomIn(false);
	else if(e->delta()<0)ZoomOut(false);

}



//Ȥ
bool  SXBSchView::placeComment(const QPoint& point)
{
	editcommentdlg *dlg = new editcommentdlg(this);
//    editcomment *dlg = new editcomment(this,0,true);

	string strname;
	if(g_cfg.getString("Font","Name",strname)){
		QFont font(QString::fromLocal8Bit(strname.c_str()));
		int n;
		if(g_cfg.getInt("Font","Size",n)) font.setPixelSize(n);
		if(g_cfg.getInt("Font","Bold",n)) font.setBold(n!=0);
		if(g_cfg.getInt("Font","Italic",n)) font.setItalic(n!=0);
		if(g_cfg.getInt("Font","Underline",n)) font.setStrikeOut(n!=0);
		if(g_cfg.getInt("Font","StrikeOut",n)) font.setUnderline(n!=0);
		dlg->setFont(font);
	}		

    if ( dlg->exec() ) {
		if(!dlg->text().isEmpty()){
			SXBSchComment *pComment = new SXBSchComment;
			pComment->setP1(SPoint(point.x(),point.y()));
			pComment->setText(dlg->text().local8Bit());
			pComment->setFontName(dlg->font().family().local8Bit());
			//QFontInfo fontInfo(dlg->font());				//2003/06/14 Qt3б
			//pComment->setFontSize(fontInfo.pixelSize());	//2003/06/14 Qt3б
			pComment->setFontSize(dlg->font().pixelSize()); //Qt3б
			pComment->setFontBold(dlg->font().bold());
			pComment->setFontItalic(dlg->font().italic());
			pComment->setFontUnderline(dlg->font().underline());
			pComment->setFontStrikeOut(dlg->font().strikeOut());
			pComment->setSelection(SXBSchObj::SELECT_ALL);
			m_pDoc->addSelect(pComment);
			//g_cfg.setString("Font","Name",pComment->fontName());
			//g_cfg.setInt("Font","Size",pComment->fontSize());
			//g_cfg.setInt("Font","Bold",(pComment->fontBold()?1:0));
			//g_cfg.setInt("Font","Italic",(pComment->fontItalic()?1:0));
			//g_cfg.setInt("Font","Underline",(pComment->fontUnderline()?1:0));
			//g_cfg.setInt("Font","StrikeOut",(pComment->fontStrikeOut()?1:0));
			delete dlg;
			return true;
		}
		delete dlg;
    }else{
		delete dlg;
		if(setToolMode(TOOL_SELECTOR)){
			emit toolChange();
		}
    }
	return false;
}



//٥
bool  SXBSchView::placeLabel(const QPoint& point)
{
    EditLabel *dlg = new EditLabel(this,0,true);
    if ( dlg->exec() ) {
        // user clicked OK
		//qDebug((dlg->text()).local8Bit());
		if(!dlg->text().isEmpty()){
			SXBSchLabel *pLabel = new SXBSchLabel;
			pLabel->setP1(SPoint(point.x(),point.y()));
			pLabel->setText(dlg->text().latin1());
			pLabel->setSelection(SXBSchObj::SELECT_ALL);
			m_pDoc->addSelect(pLabel);
			delete dlg;
			return true;
		}
		delete dlg;
    }else{
 		delete dlg;
		if(setToolMode(TOOL_SELECTOR)){
			emit toolChange();
		}
    }
	return false;
}


//
bool SXBSchView::placeTag(const QPoint& point)
{
    EditTag *dlg = new EditTag(this,0,true);
    if ( dlg->exec() ) {
        // user clicked OK
		//if(!dlg->text().isEmpty()){
			SXBSchTag *pTag = new SXBSchTag;
			pTag->setP1(SPoint(point.x(),point.y()));
			const char* pc = dlg->text().latin1();
			pTag->setText(pc);
			pTag->setTagType(dlg->type());
			pTag->setSelection(SXBSchObj::SELECT_ALL);
			m_pDoc->addSelect(pTag);
		//}
		delete dlg;
		return true;
	}
    else {
        // user clicked Cancel
		//qDebug("SXBSchView::placeLabel  Cancel\n");
		delete dlg;
		if(setToolMode(TOOL_SELECTOR)){
			emit toolChange();
		}
    }
	return false;

}

//ʤ
bool SXBSchView::placeComponent(const QPoint& point)
{
    SelComp *dlg = new SelComp(this,0,true);
    if ( dlg->exec() ){
		const SCompIndex* pCompInfoIndex = dlg->selectedCompIndex();
		SXBSchComponent* pComp = new  SXBSchComponent;
		pComp->setP1(SPoint(point.x(),point.y()));
		pComp->setCompInfoIndex(pCompInfoIndex);
		pComp->setName(pCompInfoIndex->name());
		pComp->setRefnum(pCompInfoIndex->number());
		pComp->setSelection(SXBSchObj::SELECT_ALL);
		m_pDoc->addSelect(pComp);
		delete dlg;
		return true;
	}else{
		delete dlg;
		if(setToolMode(TOOL_SELECTOR)){
			emit toolChange();
		}
    }
	return false;
}




//ޥΥܥ󤬲줿Ȥ˸ƤФ롣	
void SXBSchView::contentsMouseReleaseEvent(QMouseEvent *me)
{
	bool shiftkeyPressed = (me->modifiers() &  Qt::ShiftModifier);

//	printf("SXBSchView::contentsMouseReleaseEvent()\n");
	//	printf("  X=%d  Y=%d\n",me->x(),me->y());
	if(m_bReserveAttribute){
		m_bReserveAttribute = false;
		attribute();
		return;
	}
	
	QPoint ptAtSheet = ContentsToSheet(QPoint(me->x(),me->y()));

	QPoint ptSnap;
	if(m_bSnapGrid) ptSnap = snapPoint(ptAtSheet);
	else			ptSnap = ptAtSheet;

	
//20050724	QPainter painter(viewport());
//20050724	painter.translate ( -contentsX(),-contentsY() );

//	QPoint ptAtSheet = ContentsToSheet(QPoint(me->x(),me->y()));

	if(me->button() & Qt::LeftButton){
		m_bLButtonDown = false;
		int oldMoveOption = m_moveOption;
		m_moveOption   =0;
		if(oldMoveOption){
			updateViewBuffer(true);
			viewport()->update();	//̤ι
		}
		if(m_bDrawSelectFrame){
			//drawSelectFrame(&painter);//,QColor("black"));
			m_bDrawSelectFrame = false;
			int nSelCount = 0;
			QRect rc(m_ptLButtonDownAtSheet,m_ptLastMoveAtSheet);
			rc = rc.normalize();
			if(m_toolmode==TOOL_SELECTOR){
				int moveWidth  = abs(m_ptLButtonDownAtSheet.x() - m_ptLastMoveAtSheet.x());
				int moveHeight = abs(m_ptLButtonDownAtSheet.y() - m_ptLastMoveAtSheet.y());
				if(moveWidth < 3 && moveHeight < 3){
					nSelCount = m_pDoc->select(SPoint(m_ptLastMoveAtSheet.x(),m_ptLastMoveAtSheet.y()));
				}else{
					nSelCount = m_pDoc->select(SRect(rc.left(),rc.top(),rc.width(),rc.height()));
				}
			}else if(m_toolmode==TOOL_DRAG){
				nSelCount = m_pDoc->selectForDrag(SRect(rc.left(),rc.top(),rc.width(),rc.height()),shiftkeyPressed);
			}
			if(nSelCount>0){
//				drawTempXBSchObj(&painter,DRAW_OFF,NULL);
//				drawTempXBSchObj(&painter,DRAW_XOR,NULL);
//				drawTempDataFrame(&painter);
				m_bCompleteDrawTemp = true;
				m_oldOpCount =-1;
				//viewport()->update();	//̤ι
			}				
			viewport()->update();	//̤ι
		}else if(m_bDrawTempLine){
			//drawTempLine(&painter);
			m_bDrawTempLine=false;
			SXBSchObj* pObj1 = NULL;
			SXBSchObj* pObj2 = NULL;

			switch(m_toolmode){
			case TOOL_WIRE:
				pObj1 = new SXBSchWire;
				pObj2 = new SXBSchWire;
				break;
			case TOOL_BUS:
				pObj1 = new SXBSchBus;
				pObj2 = new SXBSchBus;
				break;
			case TOOL_DASH:
				pObj1 = new SXBSchDash;
				pObj2 = new SXBSchDash;
				break;
			default:
				break;
			}
			
			QPoint ptStart = m_ptLButtonDownAtSheet;
			if(m_bSnapGrid) ptStart = snapPoint(ptStart);

			QPoint ptEnd = m_ptLastMoveAtSheet;
			if(m_bSnapGrid) ptEnd = snapPoint(ptEnd);

			QPoint passPoint;
			if(m_nTempLineOrder >= 0){	//ʿ褹
				passPoint.setX(ptEnd.x());
				passPoint.setY(ptStart.y());
			}else{						//ľ褹
				passPoint.setX(ptStart.x());
				passPoint.setY(ptEnd.y());
			}
			if(ptStart==passPoint){
				delete pObj1;
				pObj1 = NULL;
			}else{
				pObj1->setP1(SPoint(ptStart.x(),ptStart.y()));
				pObj1->setP2(SPoint(passPoint.x(),passPoint.y()));
//				drawXBSchObj(&painter,pObj1,DRAW_ON,NULL);
				m_pDoc->addSelect(pObj1);
				m_pDoc->resetSelect();

			}				
			if(passPoint==ptEnd){
				delete pObj2;
				pObj2 = NULL;
			}else{
				pObj2->setP1(SPoint(passPoint.x(),passPoint.y()));
				pObj2->setP2(SPoint(ptEnd.x(),ptEnd.y()));
//				drawXBSchObj(&painter,pObj2,DRAW_ON,NULL);
				m_pDoc->addSelect(pObj2);
				m_pDoc->resetSelect();

			}
			viewport()->update();	//̤ι

		}else if(!m_bInhibitPlaceObject){
//			QPainter *ppainter;
			switch(m_toolmode){
			case TOOL_COMMENT:
				m_bLButtonDown = false;
				if(placeComment(ptSnap)){
					//ppainter = new QPainter(viewport());
					//ppainter->translate ( -contentsX(),-contentsY() );
					//drawTempXBSchObj(ppainter,DRAW_XOR,NULL);
					//m_pDoc->setupRcTempArea();
					//drawTempDataFrame(ppainter);
					//m_bCompleteDrawTemp=true;
					//delete ppainter;
					m_clearTempRect = true;
					viewport()->update();
				}
				break;

			 case TOOL_LABEL:
				m_bLButtonDown = false;
				if(placeLabel(ptSnap)){
					//ppainter = new QPainter(viewport());
					//ppainter->translate ( -contentsX(),-contentsY() );
					//drawTempXBSchObj(ppainter,DRAW_XOR,NULL);
					//drawTempDataFrame(ppainter);
					//m_bCompleteDrawTemp=true;
					//delete ppainter;
					m_clearTempRect = true;
					viewport()->update();

				}
				break;

			  case TOOL_TAG:
				m_bLButtonDown = false;
				if(placeTag(ptSnap)){
					//ppainter = new QPainter(viewport());
					//ppainter->translate ( -contentsX(),-contentsY() );
					//drawTempXBSchObj(ppainter,DRAW_XOR,NULL);
					//drawTempDataFrame(ppainter);
					//m_bCompleteDrawTemp=true;
					//delete ppainter;
					m_clearTempRect = true;
					viewport()->update();

				}
				break;

			  case TOOL_COMPONENT:
				m_bLButtonDown = false;
				if(placeComponent(ptSnap)){
					//ppainter = new QPainter(viewport());
					//ppainter->translate ( -contentsX(),-contentsY() );
					//drawTempXBSchObj(ppainter,DRAW_XOR,NULL);
					//drawTempDataFrame(ppainter);
					//m_bCompleteDrawTemp=true;
					//delete ppainter;
//					qDebug("placeComponent\n");
					m_clearTempRect = true;
					viewport()->update();

				}
				break;			
			  default:
				break;
			}
		}
	}
}

//ޥưȤ˸ƤФ롣
void SXBSchView::contentsMouseMoveEvent(QMouseEvent *me)
{
//20050724	QPainter painter(viewport());
//20050724	painter.translate ( -contentsX(),-contentsY() );

	QPoint ptMoveAtContents(me->x(),me->y());
	QPoint ptMoveAtSheet = ContentsToSheet(ptMoveAtContents);
//	QPoint ptStart = SheetToContents(m_ptLButtonDownAtSheet);
	
	int dx,dy;
	if(ptMoveAtSheet.x()<0) dx = 0;
	else dx = ptMoveAtSheet.x();
	if(ptMoveAtSheet.y()<0) dy = 0;
	else dy = ptMoveAtSheet.y();
	emit cursorMove(dx,dy);

	
	//	if(m_pDoc->isOnTempData(ptMoveAtSheet)) viewport()->setCursor(sizeAllCursor);
	//	else									viewport()->setCursor(arrowCursor);


	//ʥåפθߤΥ֤
	QPoint ptSnap;
	if(m_bSnapGrid)	ptSnap = snapPoint(ptMoveAtSheet);
	else			ptSnap = ptMoveAtSheet;
	QPoint ptSnapLast;
	if(m_bSnapGrid)	ptSnapLast = snapPoint(m_ptLastMoveTempAtSheet);
	else			ptSnapLast = m_ptLastMoveTempAtSheet;


//	qDebug("MouseMove  %d,%d   %d,%d   %d,%d\n",ptMoveAtSheet.x(),ptMoveAtSheet.y(),ptSnapLast.x(),ptSnapLast.y(),ptSnap.x(),ptSnap.y());



	//ܥ󤬲Ƥơǡ¸ߤ
	if((me->state() & Qt::LeftButton) && (m_pDoc->m_listTemp.size() > 0 ) ){
		if(m_moveOption == MOVE_OPTION_COMPONENT_NAME || m_moveOption == MOVE_OPTION_COMPONENT_NUM){
			if(m_ptLastMoveTempAtSheet != ptMoveAtSheet){
				int offsetx = ptMoveAtSheet.x() - m_ptLastMoveTempAtSheet.x();
				int offsety = ptMoveAtSheet.y() - m_ptLastMoveTempAtSheet.y();
				XBSchObjListIterator pObjIte = m_pDoc->m_listTemp.begin();
				SXBSchComponent* pComp = (SXBSchComponent*)(*pObjIte);
				if(m_moveOption == MOVE_OPTION_COMPONENT_NAME){
					//g_drawComponentNameXOR(&painter,pComp,m_viewScale);
					pComp->moveNamePos(offsetx,offsety);
					m_pDoc->setTempDirty();
					//g_drawComponentNameXOR(&painter,pComp,m_viewScale);
					viewport()->update();	//̤ι
				}else if(m_moveOption == MOVE_OPTION_COMPONENT_NUM){
					//g_drawComponentNumXOR(&painter,pComp,m_viewScale);
					pComp->moveRefnumPos(offsetx,offsety);
					m_pDoc->setTempDirty();
					//g_drawComponentNumXOR(&painter,pComp,m_viewScale);
					viewport()->update();	//̤ι
				}
			}
		}else if(ptSnapLast != ptSnap){
//			drawTempDataFrame(&painter);
//			if(m_bComp			leteDrawTemp){
//				drawTempXBSchObj(&painter,DRAW_XOR,NULL);
//			}else{
//				m_timerTempDraw.stop();
//			}
			int offsetx = ptSnap.x() - ptSnapLast.x();
			int offsety = ptSnap.y() - ptSnapLast.y();
			m_pDoc->moveTempData(offsetx,offsety);
//			m_timerTempDraw.start(200,true);
//			m_bCompleteDrawTemp = false;
//			drawTempDataFrame(&painter);
			m_bCompleteDrawTemp = true;
			viewport()->update();	//̤ι

		}
		m_ptLastMoveTempAtSheet = ptMoveAtSheet;
		//ưΥη
		viewport()->setCursor(*m_pCurMov);
		
	}else{
		//ưʳξΥη
		if(m_pDoc->isOnTempData(SPoint(ptMoveAtSheet.x(),ptMoveAtSheet.y()))){
			viewport()->setCursor(*m_pCurMov);
		}else{
			viewport()->setCursor(*m_pCurStd);
		}
	}


	if(m_pCursorObj){
		//drawCursorObj(&painter);
		m_pCursorObj->setP1(SPoint(ptSnap.x(),ptSnap.y()));
		//drawCursorObj(&painter);
		if(ptSnapLast != ptSnap){
			viewport()->update();
		}
		m_ptLastMoveTempAtSheet = ptMoveAtSheet;
	}


	//Windows ˤ motifΤȤ˥塼ɽ˸äޥܥ󲡲å
	//ȯ뤳Ȥкѥå 2001/08/17
	if(!(me->state() & Qt::LeftButton)){
		m_bLButtonDown = false;
		m_bDrawTempLine = false;
		m_bDrawSelectFrame = false;
		//return;
	}

	if(m_bDrawSelectFrame){
		viewport()->update();
		//drawSelectFrame(&painter);//,QColor("black"));
	}else if(m_bDrawTempLine){
//		drawTempLine(&painter);
	}

	//ֺǸưȤκɸפι
	m_ptLastMoveAtContents = ptMoveAtContents;
	m_ptLastMoveAtSheet = ptMoveAtSheet;


	if(m_bDrawSelectFrame){			//ġ
//20050724		drawSelectFrame(&painter);
	}else if(m_bDrawTempLine){		//ġǲ
		QPoint ptMov = m_ptLButtonDownAtSheet - m_ptLastMoveAtSheet;
		if(m_nTempLineOrder == 0){	//Ĥ褫褫̤
			if(abs(ptMov.x()) > 8 || abs(ptMov.y()) > 8){
				if(abs(ptMov.x()) > abs(ptMov.y())){
					m_nTempLineOrder = 1;
				}else{
					m_nTempLineOrder = -1;
				}
			}
		}else{
			if(abs(ptMov.x()) <= 8 && abs(ptMov.y()) <= 8){
				m_nTempLineOrder = 0;
			}
		}
		if(ptSnapLast != ptSnap){
//			qDebug("UpdateTempLine %d,%d   %d,%d\n",ptSnapLast.x(),ptSnapLast.y(),ptSnap.x(),ptSnap.y());
			viewport()->update();
		}
//		drawTempLine(&painter);
		m_ptLastMoveTempAtSheet = ptMoveAtSheet;
	}


	//ܥ󲡲ɽꥢμǥޥư˥륿ޡ
	if(		m_bLButtonDown //(me->state()&(LeftButton | RightButton) )
		&&	(		(contentsX()+10 > ptMoveAtContents.x())
				|| 	(contentsY()+10 > ptMoveAtContents.y())
				||	(contentsX()+visibleWidth()-10 < ptMoveAtContents.x())
				||	(contentsY()+visibleHeight()-10 < ptMoveAtContents.y())
			)
		){
		if(!m_bTimer){
			//printf("Set ScrollTimer\n");
			QTimer::singleShot( 100, this, SLOT(onScrollTimer()) );
//			QTimer *timer = new QTimer(this);
//			connect(timer,SIGNAL(timeout()),this,SLOT(onScrollTimer()) );
//			timer->start(100,true);
			m_bTimer = true;
		}
	}
}

//ӥ塼ݡȤΥѹ줿Ȥ˸ƤФ롣
void SXBSchView::viewportResizeEvent(QResizeEvent *)
{
	//printf("viewportResizeEvent\n");
	setAutoScrollValue();
	//viewport()->update();	//̤ι
}

//ɸѴ˴ؤ
//ContentsκɸsheetɸؤѴ
QPoint SXBSchView::ContentsToSheet(const QPoint& point)
{
	QPoint p(point.x()*m_viewScale/m_viewScaleMul,point.y()*m_viewScale/m_viewScaleMul);
	return p;
}

//ContentsκɸsheetɸؤѴ
QRect SXBSchView::ContentsToSheet(const QRect& rc)
{
	int x1,y1,x2,y2;
	rc.coords(&x1,&y1,&x2,&y2);
	x1 = x1*m_viewScale/m_viewScaleMul;
	y1 = y1*m_viewScale/m_viewScaleMul;
	x2 = x2*m_viewScale/m_viewScaleMul;
	y2 = y2*m_viewScale/m_viewScaleMul;
	QRect r;
	r.setCoords(x1,y1,x2,y2);
	//QRect r(	rc.left()	*m_viewScale,
	//			rc.top()	*m_viewScale,
	//			rc.width()	*m_viewScale,
	//			rc.height()	*m_viewScale);
	return r;
}

//sheetκɸContentsɸؤѴ
QPoint SXBSchView::SheetToContents(const QPoint& point)
{
	QPoint p(point.x()*m_viewScaleMul/m_viewScale,point.y()*m_viewScaleMul/m_viewScale);
	return p;
}

//sheetκɸContentsɸؤѴ
QRect SXBSchView::SheetToContents(const QRect& rc)
{
	int x1,y1,x2,y2;
	rc.coords(&x1,&y1,&x2,&y2);
	x1 = x1*m_viewScaleMul/m_viewScale;
	y1 = y1*m_viewScaleMul/m_viewScale;
	x2 = x2*m_viewScaleMul/m_viewScale;
	y2 = y2*m_viewScaleMul/m_viewScale;
	QRect r;
	r.setCoords(x1,y1,x2,y2);
//	QRect r(	rc.left()	/m_viewScale,
//				rc.top()	/m_viewScale,
//				rc.width()	/m_viewScale,
//				rc.height()	/m_viewScale);
	return r;
}



//ǴΥåɤΰ֤֤
QPoint SXBSchView::snapPoint(const QPoint& point)
{
	QPoint p( ((point.x()+4)/10)*10,((point.y()+4)/10)*10);
	return p;
}

//ưΥ̤
void SXBSchView::setAutoScrollValue()
{
	m_nAutoScrollX = 50;
	m_nAutoScrollY = 50;
}



//SLOT Ȥ SIGNAL contentsMoving(int,int) connectƤ
//뤬Ϥޤľ˸ƤФ롣
//void SXBSchView::whenScroll(int x,int y)
//{
//	//printf("SXBSchView::whenScroll() %d,%d\n",x,y);
//}

//SLOT륿ޡΥॢȽ
//륿ޡưȤϺܥ󤬲Ƥ뤳ȤȤƤ롣
void SXBSchView::onScrollTimer()
{
	m_bTimer = false;
	//printf("SXBSchView::onScrollTimer()\n");
	//ưɬΥå
	if(!m_bLButtonDown) return;
	int x=0;
	int y=0;
	QSize size(m_pDoc->SheetSize().w(),m_pDoc->SheetSize().h());
    //å
	if(contentsX()+10 > m_ptLastMoveAtContents.x()){
		if(contentsX() > 0) x = -m_nAutoScrollX;
	}else
	//å
    if(contentsX()+visibleWidth()-10 < m_ptLastMoveAtContents.x()){
		if(contentsX()+visibleWidth() < size.width()*m_viewScaleMul/m_viewScale)  x = m_nAutoScrollX;
	}
	//å
	if(contentsY()+10 > m_ptLastMoveAtContents.y()){
		if(contentsY() > 0) y = -m_nAutoScrollY;
	}else
	//å
	if(contentsY()+visibleHeight()-10 < m_ptLastMoveAtContents.y()){
		if(contentsY()+visibleHeight() < size.height()*m_viewScaleMul/m_viewScale)  y = m_nAutoScrollY;
	}
		
	if(x || y){
		scrollBy(x,y);	
		QPoint ptCurrent = QCursor::pos();
		ptCurrent = viewport()->mapFromGlobal(ptCurrent);
		QMouseEvent* pme = new QMouseEvent(QEvent::MouseMove,ptCurrent,0,Qt::LeftButton);
		QApplication::postEvent(viewport(),pme);
	}
}

//ǡޥǰưƤȤ˥ޡưǺԤ
void SXBSchView::onTimerDrawTemp()
{
	return;
	
//	if(m_bCompleteDrawTemp) return;
//	QPainter painter(viewport());
//	painter.translate ( -contentsX(),-contentsY() );
//	drawTempXBSchObj(&painter,DRAW_XOR,NULL);
//	m_bCompleteDrawTemp = true;
}

void SXBSchView::resizeEvent ( QResizeEvent *e )
{
	QSize size = e->size();
	//qDebug("%d,%d\n",size.width(),size.height());
	resizeBuffer(size.width(),size.height());
	Q3ScrollView::resizeEvent(e);
}

void SXBSchView::resizeBuffer(int w,int h)
{
	m_viewBuffer.resize(w, h);
	m_viewBuffer.fill(Qt::white);
	drawBuffer(contentsX(),contentsY(),contentsX(),contentsY(),w,h);
//	qDebug("SXBSchView::resizeBuffer  %d,%d\n",w,h);
}

//m_nZoomȤˤơsetZoomValue()ǡm_viewScalem_viewScaleMulꤹ롣
void  SXBSchView::setZoomValue()
{
	if(m_nZoom<0){
		m_nZoom=0;
	}else if (m_nZoom>MAX_ZOOM){
		m_nZoom=MAX_ZOOM;
	}
	static int divTable[]={5,2,1,2,1};
	static int mulTable[]={1,1,1,3,5};
	
	
	m_viewScale=divTable[m_nZoom];			//̾Ψ
	m_viewScaleMul=mulTable[m_nZoom];		//Ψ
}

unsigned SXBSchView::visibleLayer()
{
	return m_pDoc->visibleLayer();
}
void SXBSchView::setVisibleLayer(unsigned n)
{
	 m_pDoc->setVisibleLayer(n);
}

int SXBSchView::activeLayer()
{
	 return m_pDoc->editLayer();
}

void SXBSchView::setActiveLayer(int n)
{
	m_pDoc->setEditLayer(n);
}

bool SXBSchView::darkenNonActiveLayer()
{
	return m_fEditHighLight;
}

void SXBSchView::setDarkenNonActiveLayer(bool f)
{
	m_fEditHighLight = f;
}

bool SXBSchView::canMoveToLayer(int nLayer)
{
	nLayer &= 0x07;
	unsigned  layerTable[] = {0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80};

	return (   canCopy() 
			&& (m_toolmode==TOOL_SELECTOR)
			&& (nLayer != m_pDoc->editLayer()) 
			&& (layerTable[nLayer] & m_pDoc->visibleLayer()) );
}


//void SXBSchView::clipboardChanged()
//{
//	//qDebug("SXBSchView::clipboardChanged()\n");
//}

//void SXBSchView::setContentsPos ( int x, int y )
//{
//	qDebug("SXBSchView::setContentsPos  %d,%d\n",x,y);
//	QScrollView::setContentsPos ( x, y );
//}

//void SXBSchView::scrollBuffer(int x,int y){
//	qDebug("SXBSchView::scrollBuffer  %d,%d\n",x,y);
//
//
//	//drawBuffer(x,y,x,y,visibleWidth(),visibleHeight());
//
//	//m_oldContentsX = x;
//	//m_oldContentsY = y;
//}

