
// This is the implementation of the ComplexDVD plugin for QDVDAuthor.

#include <stdlib.h>

#include <qprogressdialog.h>
#include <qradiobutton.h>
#include <qapplication.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qfileinfo.h>
#include <qcombobox.h>
#include <qlayout.h>
#include <qcursor.h>
#include <qimage.h>
#include <qtimer.h>

#include <qdir.h>
#include <qmessagebox.h>

#include "uicomplexdvd.h"
#include "complexdvd.h"

// The class factories
extern "C"  Plugin::Interface *createPlugin ( ) {
    return new Plugin::ComplexDVD;
}
extern "C" void destroyPlugin ( Plugin::Interface *pDeleteMe ) {
    delete pDeleteMe;
}

#include "../../CONFIG.h"

#ifndef SYSTEM_DIRECTORY
#define SYSTEM_DIRECTORY "/usr"
#endif

namespace Plugin
{

ComplexDVD::ScriptGui::ScriptGui ( QGroupBox *pParent, QString qsScript, QString qsLink, bool bCategory, bool bTheme, bool bImage )
{
  m_qsScript   = qsScript;
  m_qsMainLink = qsLink;
  m_bCategory  = bCategory;
  m_bTheme     = bTheme;
  m_bIsImage   = bImage;
  m_pParent    = pParent;

  QSpacerItem *pSpacer = NULL;
  QVBoxLayout *pParentLayout = (QVBoxLayout *)pParent->layout ( );
  QFileInfo fileInfo ( qsScript );
  QString qsName = fileInfo.baseName ( ); // E.g. fantom-xp

  m_pLayoutScriptTitle = new QHBoxLayout( 0, 0, 6, qsName+"-Layout" );

  m_pRadioScript = new QRadioButton ( pParent, qsName+"-Radio" );
  m_pLayoutScriptTitle->addWidget ( m_pRadioScript );

  m_pLabelScript = new QLabel   ( pParent, qsName+"-Label" );
  m_pLabelScript->setTextFormat ( QLabel::AutoText );
  m_pLayoutScriptTitle->addWidget ( m_pLabelScript );
  pSpacer = new QSpacerItem     ( 88, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
  m_pLayoutScriptTitle->addItem ( pSpacer );
  pParentLayout->addLayout( m_pLayoutScriptTitle );

  m_pLayoutScriptSelection = new QHBoxLayout ( 0, 0, 6, qsName+"-LayoutSelection" );
  m_pLabelScriptCategory   = NULL;
  m_pComboScriptCategory   = NULL;
  m_pLabelScriptTheme      = NULL;
  m_pComboScriptTheme      = NULL;
  if ( bCategory )  {
    m_pLabelScriptCategory = new QLabel( pParent, qsName+"-LabelCategory" );
    m_pLayoutScriptSelection->addWidget( m_pLabelScriptCategory );
    m_pComboScriptCategory = new QComboBox( FALSE, pParent, qsName+"-ComboCategory" );
    m_pComboScriptCategory->setMinimumSize( QSize( 130, 0 ) );
    m_pLayoutScriptSelection->addWidget( m_pComboScriptCategory );
    pSpacer = new QSpacerItem( 50, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    m_pLayoutScriptSelection->addItem( pSpacer );
    m_pLabelScriptCategory->setText( tr( "Category :" ) );
  }
  if ( bTheme )  {
    m_pLabelScriptTheme = new QLabel( pParent, qsName+"-LabelTheme" );
    m_pLayoutScriptSelection->addWidget( m_pLabelScriptTheme );
    m_pComboScriptTheme = new QComboBox( FALSE, pParent, qsName+"-ComboTheme" );
    m_pComboScriptTheme->setMinimumSize( QSize( 130, 0 ) );
    m_pLayoutScriptSelection->addWidget( m_pComboScriptTheme );
    m_pLabelScriptTheme->setText( tr( "Theme :" ) );
  }
  pParentLayout->addLayout( m_pLayoutScriptSelection );

  if ( bImage )
    m_pRadioScript->setText ( tr( "Get menu background from :" ) );
  else 
    m_pRadioScript->setText ( tr( "Get background video from :" ) );

  m_pLabelScript->setText ( tr( "<A HREF=\"%1\">%2</A>" ).arg ( qsLink ).arg ( qsLink ) );

  m_pRadioScript->show ( );
  m_pLabelScript->show ( );
  if ( bCategory )  {
    m_pLabelScriptCategory->show ( );
    m_pComboScriptCategory->show ( );
  }
  if ( bTheme )  {
    m_pLabelScriptTheme->show ( );
    m_pComboScriptTheme->show ( );
  }
}

ComplexDVD::ScriptGui::~ScriptGui ( )
{
  // Don't do nothin'
}

ComplexDVD::exe::exe ( )
{
}

ComplexDVD::exe::~exe ( )
{
}

void ComplexDVD::exe::stdOut ( QString &qsOut )
{
// printf ( "OUT<%s>\n", qsOut.ascii() );
  m_qsOutput = qsOut;
}

int ComplexDVD::exe::start  ( QStringList *pEnv )
{
  m_qsOutput = "";
//printf ( "Command<%s>\n", m_qsCommand.ascii() );
  return Run::start ( pEnv );
}

QString ComplexDVD::exe::getOutput ( )
{
  return m_qsOutput;
}

ComplexDVD::ComplexDVD ( )
{
  srand ( (unsigned)time ( NULL ) );
  m_iNrOfMenus    = 0;
  m_pConfigWidget = NULL;
  m_pActiveGui    = NULL;
  m_qsPluginName  = "ComplexDVD" + QString ( " -%1-" ).arg ( getPluginVersion ( ), 0, 'f', 2 );
  m_qsProjectName = "Unnamed";
  QTimer::singleShot ( 10, this, SLOT ( slotInitTimer ( ) ) );
}

ComplexDVD::~ComplexDVD ( )
{
  if ( m_pConfigWidget )
    delete m_pConfigWidget;
  m_pConfigWidget = NULL;
}

QWidget *ComplexDVD::getConfigWidget ( QWidget *pParent )
{
  // Note this widget has to be destroyed in the library
  m_pConfigWidget = new uiControls ( pParent );
  return m_pConfigWidget;
}

void ComplexDVD::slotInitTimer ( )
{
  // All scripts in the path $SYSTEM_PATH/plugins/complexdvd/scripts
  //     must expose the following interface
  // -i            == info. IP, plus 0, 1, or 2 selections
  // -l            == List all categories
  // -c <category> == list themes of the Category ( sub-category )
  // -t <theme>    == link to web page
  // -n <link>     == Get the max # of pages
  // -r <targetFile> <category> <theme> == get random image off the page
  //
  // The buildup of the interface takes a couple of steps:
  // 1) qsScript -i
  // 2) if we have a category ( 2nd line form #1 )
  //    qsScript -l
  // 3) if we have a theme ( 3rd line from #1 )
  //    qsScript -c <1st category>
  // 4) any time the Category is changed, the Themes are re-queried
  /////////////////////////////////////////////////////////////////////////

  QStringList list;
  m_qsScriptsPath = SYSTEM_DIRECTORY"/share/qdvdauthor/plugins/complexdvd/scripts";

  // First we check to see if we have a script path
  QDir dir ( m_qsScriptsPath );
  if ( ! dir.exists ( ) )  {
    QMessageBox::information ( NULL, tr ("Error !"), tr ("Error, could not find the scripts path for this plugin.\nPlease make sure that the following path exists \n%1\n").arg ( m_qsScriptsPath ), QMessageBox::Ok );
    return;
  }

  // First we have to query if we have Categories, and or themes
  dir.setFilter ( QDir::Files | QDir::NoSymLinks );

  const QFileInfoList *pList = dir.entryInfoList ( );
  if ( pList )  {
    QFileInfoListIterator it ( *pList );
    QFileInfo *pFileInfo = NULL;

    while ( ( pFileInfo = it.current ( ) ) != 0 ) {
      ++it;
      if ( pFileInfo && pFileInfo->isExecutable ( ) )
         createFromScript ( pFileInfo->filePath ( ) );
    }
  }
  if ( m_listScriptsGui.size ( ) < 1 )  {
    QMessageBox::information ( NULL, tr ("Error !"), tr ("Error, could not find the scripts for this plugin.\nPlease make sure that there are scrips inside the following path\n%1\n\nYou can downlod them from http://qdvdauthor.sf.net/plugin_scripts.tar.gz").arg ( m_qsScriptsPath ), QMessageBox::Ok );
  }
  else if ( ! m_pActiveGui )  {
    m_pActiveGui = m_listScriptsGui[0];
    m_pActiveGui->m_pRadioScript->setChecked ( true );
  }

  connect ( m_pConfigWidget->m_pCheckRandomImages, SIGNAL ( toggled ( bool ) ), this, SLOT ( slotRandomImages ( bool ) ) );
}

void ComplexDVD::createFromScript ( QString qsScript )
{
  bool bCategory = false;
  bool bTheme    = false;
  bool bIsImageScript = true;

  QString qsLink, qsOut, qsCommand; // ( "/tmp/fantom-xp.sh -t Computers Apple" );
  QStringList list, listCategory, listTheme;

  // First we determine if the script is for img or for vids
  qsCommand = QString ( "%1 -m" ).arg ( qsScript );
  m_execute.setCommand ( qsCommand );
  m_execute.start ( );
  qsOut = m_execute.getOutput  ( );
  if ( qsOut.find ( "vid" ) > -1 )
    bIsImageScript = false;

  // Next we get the link to the web page ( from the script, 
  // and to see if we have Categories and Themes
  qsCommand = QString ( "%1 -i" ).arg ( qsScript );
  m_execute.setCommand ( qsCommand );
  m_execute.start ( );
  qsOut = m_execute.getOutput ( );
  list = QStringList::split ( "\n", qsOut );

  if ( list.size ( ) > 2 )  {
    if ( list[1].length ( ) > 0 )
      bCategory = true;
    if ( list[2].length ( ) > 0 )
      bTheme = true;
  }
  else if ( ( list.size ( ) > 1 ) && ( list[1].length ( ) > 0 ) )
    bCategory = true;
  if ( list.size ( ) > 0 )
    qsLink = list[0];

  // Next we get the Categories ( if we have them.
  if ( bCategory )  {
    qsCommand = QString ( "%1 -l" ).arg ( qsScript );
    m_execute.setCommand ( qsCommand );
    m_execute.start ( );
    qsOut = m_execute.getOutput ( );
    list = QStringList::split ( "\n", qsOut );
    if ( list.size ( ) < 1 )  {
      bCategory = false;
      bTheme    = false;
    }
    else
      listCategory = list;
  }
  if ( bTheme )  {
    // FInal inquiry are the themes for the First Category, to fill into the ComboBox
    if ( listCategory.size ( ) > 0 )  {
      qsCommand = QString  ( "%1 -c \"%2\"" ).arg ( qsScript ).arg ( listCategory[0] );
      m_execute.setCommand ( qsCommand );
      m_execute.start ( );
      qsOut = m_execute.getOutput ( );
      list = QStringList::split ( "\n", qsOut );
      if ( list.size ( ) < 1 )
        bTheme = false;
      else  { 
        listTheme = list;
      }
    }
  }

  ScriptGui *pGui = new ScriptGui ( bIsImageScript ? m_pConfigWidget->m_pGroupScriptRandom : m_pConfigWidget->m_pGroupVideos, qsScript, qsLink, bCategory, bTheme, bIsImageScript );
  m_listScriptsGui.push_back ( pGui );
  if ( qsScript.find ( "fantom" ) > -1 )  { // m_listScriptsGui.size ( ) == 1 )  {
    pGui->m_pRadioScript->setChecked ( true );
    m_pActiveGui = pGui;
  }

  if ( bCategory )
    pGui->m_pComboScriptCategory->insertStringList ( listCategory );
  if ( bTheme )
    pGui->m_pComboScriptTheme->insertStringList ( listTheme );

  connect ( pGui->m_pRadioScript, SIGNAL ( clicked ( ) ), this, SLOT ( slotCheckedScript ( ) ) );
  if ( bCategory )
    connect ( pGui->m_pComboScriptCategory, SIGNAL ( activated ( int ) ), this, SLOT ( slotComboCategory ( int ) ) );
}

void ComplexDVD::slotCheckedScript ( )
{
  QValueList<ScriptGui *>::iterator it = m_listScriptsGui.begin ( );
  ScriptGui *pGui = NULL;
  while ( it != m_listScriptsGui.end ( ) )  {
    pGui = *it++;
    if ( pGui->m_pRadioScript->hasMouse ( ) )
      m_pActiveGui = pGui;
    pGui->m_pRadioScript->setChecked ( false );
  }
  if ( m_pActiveGui )
       m_pActiveGui->m_pRadioScript->setChecked ( true );
}

void ComplexDVD::slotComboCategory ( int )
{
  QString qsCommand, qsCategory, qsScript, qsOut;
  QStringList list;
  QValueList<ScriptGui *>::iterator it = m_listScriptsGui.begin ( );
  ScriptGui *pGui = NULL;
  while ( it != m_listScriptsGui.end ( ) )  {
    pGui = *it++;
    if ( pGui->m_bCategory )  {
      if ( pGui->m_pComboScriptCategory->hasFocus ( ) )
        break;
    }
  }
  if ( pGui && pGui->m_bCategory && pGui->m_bTheme )  {
    qsScript   = pGui->m_qsScript;
    qsCategory = pGui->m_pComboScriptCategory->currentText ( );
    qsCommand  = QString ( "%1 -c \"%2\"" ).arg ( qsScript ).arg ( qsCategory );
    m_execute.setCommand ( qsCommand );
    m_execute.start ( );
    qsOut = m_execute.getOutput ( );
    list  = QStringList::split ( "\n", qsOut );
    pGui->m_pComboScriptTheme->clear ( );
    if ( list.size ( ) > 0 )
      pGui->m_pComboScriptTheme->insertStringList ( list );
  }
}

void ComplexDVD::slotRandomImages ( bool bOn )
{
  m_pConfigWidget->m_pGroupScriptRandom->setEnabled ( bOn );
  m_pConfigWidget->m_pGroupVideos->setEnabled ( bOn );
}

QString ComplexDVD::getDuration ( QString &qsFile )
{
  QString qsDuration ( "00:00:01.000" );

  if ( m_pActiveGui && ! m_pActiveGui->m_bIsImage )  { 
    QString qsCommand, qsVobFile,  qsTempFile;
    qsVobFile  = qsFile;
    qsVobFile  = qsVobFile.replace ( ".jpg", ".vob" );
    qsTempFile = QString ( "%1/length.txt" ).arg ( m_qsTempPath );
    qsCommand  = QString ( "ffmpeg -i \"%1\" 2>&1 | grep Duration | awk '{ print $2 }' | sed 's/,//g' > %2" ).arg ( qsVobFile ).arg ( qsTempFile );
    printf ( "getDuration : %s\n", qsCommand.ascii ( ) );
    int iRet   = system  ( qsCommand.ascii ( ) ); iRet = iRet;
    QFile file ( qsTempFile );
    if ( file.exists ( ) )  {
      if ( file.open( IO_ReadOnly ) )  {
        QTextStream stream( &file );
        while ( ! stream.atEnd ( ) )
          qsDuration = stream.readLine ( );
        file.close ( );
      }
      if ( qsDuration.length ( ) < 5 )
        qsDuration = "00:00:10.001"; // defaulting to 10 seconds
    }
  }

  return qsDuration;
}


void ComplexDVD::getRandomBackground ( )
{
  // gets random images off of InterFaceLift.com and stores them in /tmp
  int iOffset = 1;
  QString qsCommand, qsTempPath, qsTarget, qsExt;
  qsTempPath = m_qsTempPath + "/" + m_qsProjectName;

  QDialog   progressDialog    ( NULL );
  QGridLayout  progressLayout ( &progressDialog );
  QProgressBar progressBar    ( &progressDialog );
  progressLayout.addWidget    ( &progressBar, 0, 0 );
  progressDialog.resize       ( QSize(550, 50).expandedTo ( progressDialog.minimumSizeHint ( ) ) );
  progressDialog.setCaption   ( tr ( "Receiving random images." ) );
  progressDialog.show         ( );
  progressBar.setTotalSteps   ( m_iNrOfMenus );
  qApp->processEvents         ( 100 );

  if ( m_pConfigWidget && m_pConfigWidget->m_pCheckMainMenu && 
       m_pConfigWidget->m_pCheckMainMenu->isChecked ( ) )
       iOffset ++;

  qsExt = "jpg";
  if ( m_pActiveGui && ! m_pActiveGui->m_bIsImage )
    qsExt = "vob";

  qsCommand = QString ( "if [ -e %1/menu_1.%2 ]; then rm -f %3/menu_*.%4 >/dev/null 2>&1; fi" ).arg ( qsTempPath ).arg ( qsExt ).arg ( qsTempPath ).arg ( qsExt );
  int iRet  = system ( qsCommand.ascii ( ) ); iRet =iRet;

  for ( int t=0; t<m_iNrOfMenus; t++ )  {
    qsTarget  = QString   ( "\"%1/menu_%2.%3\"" ).arg ( qsTempPath ).arg ( t + iOffset ).arg ( qsExt );
    qsCommand = getImgCmd ( qsTarget );

    progressDialog.show     ( ); // why does this dlg disappear ? 
    progressDialog.raise    ( );
    progressBar.setProgress ( t + iOffset );
    qApp->processEvents     ( 10 );

    iRet = system ( qsCommand.ascii ( ) );
  }
}

QString ComplexDVD::getImgCmd ( QString &qsTarget )
{
  // First we find the active script to call
  bool bFound = false;
  QString qsCommand;
  QValueList<ScriptGui *>::iterator it = m_listScriptsGui.begin ( );
  ScriptGui *pGui = NULL;
  while ( it != m_listScriptsGui.end ( ) )  {
    pGui = *it++;
    if ( pGui->m_pRadioScript->isChecked ( ) )  {
      bFound = true;
      break;
    }
  }

  if ( pGui && bFound )  {
    // Get images by calling the script ...
    QString qsCategory, qsTheme;
    if ( pGui->m_bCategory )
      qsCategory = pGui->m_pComboScriptCategory->currentText ( );
    if ( pGui->m_bTheme )
      qsTheme = pGui->m_pComboScriptTheme->currentText ( );

    qsCommand = QString ( "%1 -r %2 \"%3\" \"%4\"" ).arg ( pGui->m_qsScript ).arg ( qsTarget ).arg ( qsCategory ).arg ( qsTheme );
  }

// printf ( "%s\n", qsCommand.ascii () );
  return qsCommand;
}

#if 0
QString ComplexDVD::getImgCmd ( QString &qsTarget )
{

//    qsCommand=QString ( "POTD=`wget -qO - 'interfacelift.com/wallpaper/index.php?sort=random&aspect=&widescreen&w=1280&h=800' | grep \"download</a>\" | sed -e \"s,.*href=\\\",,\" -e \"s,\\\",,\" | awk 'NR==\"3\" {print}' | awk '{ gsub(/dl\\/wallpaper\\//,\"\");gsub(/>download<\\/a>/,\"\");print}'`; wget -q -O \"%1/menu_%2.jpg\"  interfacelift.com/wallpaper/downloads$POTD" ).arg ( qsTempPath ).arg ( t + iOffset );
  int iIdx, iRandom;
  QString  qsRandom, qsCommand;
  QString qsCategory, qsTheme;

  qsCommand=QString ( "fantom-xp.sh -g \"%1\" \"%2\" \"%3\"" ).arg ( qsTarget ).arg ( qsCategory ).arg ( qsTheme );

  if ( m_pConfigWidget->m_pRadioFantomXP->isChecked ( ) )  {
    // Get images from WallpapersArchive.com
    iIdx = m_pConfigWidget->m_pComboCategory->currentItem ( );
    if ( iIdx == 0 ) // random :
         iIdx = ( rand ( ) % ( m_pConfigWidget->m_pComboCategory->count ( ) - 1 ) ) + 1;
    iRandom   = ( rand ( ) % m_listNumberOfImages[iIdx] );
    qsRandom  = m_pConfigWidget->m_pComboCategory->text ( iIdx );

    qsCommand=QString ( "PICURL=`wget -qO - 'wallpapersarchive.com/%1/wallpaper%2/' | grep \"img src=\\\"http://www.wallpapersarchive.com/wallpapers/\" | sed -e \"s/.*src=\\\"//g\" -e \"s/\\\".*//\"`; wget -q --user-agent=MSIE -O %3 $PICURL" ).arg ( qsRandom ).arg ( iRandom ).arg ( qsTarget );
  }
  else if ( m_pConfigWidget->m_pRadioHDRCreme->isChecked ( ) ) {
    // Get images from HDRCreme instead
    iRandom      = ( rand ( ) % 558 + 1 );
    int iRandom2 = ( rand ( ) % 20  + 1 );
//    qsCommand=QString ( "PICURL=`wget -qO - 'hdrcreme.com/photo-gallery?page=%1' | grep imgGalleri | sed -e \"s,.*href=\\\",,\" -e \"s,\\\".*,,\" | head -%2 | tail -1`; PICURL=`wget -qO - hdrcreme.com$PICURL | grep showimagepic | sed -e \"s,.*src=\\\",,\" -e \"s,\\\".*,,\"`; wget -q --user-agent=MSIE -O %3 $PICURL" ).arg ( iRandom ).arg ( iRandom2 ).arg ( qsTarget );
    qsCommand=QString ( "PREURL=http://hdrcreme.com`wget -qO - 'hdrcreme.com/photo-gallery?page=%1' | grep imgGalleri | sed -e \"s,.*href=\\\",,\" -e \"s,\\\".*,,\" | head -%2 | tail -1`; PICURL=`wget -qO - \"$PREURL\" | grep showimagepic | sed -e \"s,.*jQuery.*,,g\"  -e \"s,.*<img ,,g\" | sed -e \"s,.*src=\\\",,\" -e\"s,\\\".*,,g\"`; wget -q --user-agent=MSIE -O %3 $PICURL" ).arg ( iRandom ).arg ( iRandom2 ).arg ( qsTarget );
  }
  else  { // Get background videos from DreamScene
    QString qsScreenshot = qsTarget;
    qsScreenshot = qsScreenshot.replace ( ".vob", ".jpg" );
    iRandom = ( rand ( ) % 205 + 1 );
    qsCommand  = "#!/bin/bash\n";
    qsCommand += "outFile=/tmp/Dream.zip\n";
    qsCommand += "dstDir=" + m_qsTempPath + "\n";
    qsCommand += "cd $dstDir\n";
    qsCommand += "# Retrieve the actual zip file\n";
    qsCommand += QString ( "wget --user-agent=MSIE --post-data=\"Cmd=DownloadFile&ID=%1\" http://www.dreamscene.org/load.php -O $dstDir/Dream.zip\n" ). arg ( iRandom );
    qsCommand += "file=`unzip -Z Dream.zip | grep \"b- defN\" | awk '{ for ( i=9;i<=NF;i++) printf $i " " }'`\n";
    qsCommand += "files=`unzip -o Dream.zip`\n";
    qsCommand += "echo \"ffmpeg -i \"$file\" -ar 48000 -ab 224k -ac 2 -acodec ac3 -y -s 720x480 -b 9900k -f vob " + qsTarget + "\"\n";
    qsCommand += "# For the background we need good quality video/audio which is properly scaled.\n";
    qsCommand += "ffmpeg -i $file -ar 48000 -ab 224k -ac 2 -acodec ac3 -y -s 720x480 -b 9900k -f vob " + qsTarget + "\n";
    qsCommand += "ffmpeg  -an -y -t 00:00:01  -vframes 1 -i " + qsTarget + " -y -f image2 " + qsScreenshot + "\n";
  }

printf ( "%s\n", qsCommand.ascii () );
  return qsCommand;
}
#endif

void ComplexDVD::createMainMenu ( )
{
  // creates a MainMenu with only one Button to the next Menu.
  // This is for the user to fill in 
  SourceGroup::type theType = SourceGroup::NTSC; // pGroup->enType;
  QString qsMenuName = QString ( "Menu 1" ); // this will be converted to VMGM due to the 1
  QString qsMenuXML, qsCommand, qsMenuBackground, qsDuration, qsMenuMovie;

  qsMenuBackground = m_qsTempPath + "/" + m_qsProjectName + "/MainMenu.jpg";
  if ( m_pActiveGui && ! m_pActiveGui->m_bIsImage )
    qsMenuMovie = QString ( "<MenuMovie>%1/%2/MainMenu.vob</MenuMovie>\n" ).arg ( m_qsTempPath ).arg ( m_qsProjectName );

  qsCommand = QString ( "rm \"%1\" >/dev/null 2>&1" ).arg ( qsMenuBackground );
  int iRet  = system ( qsCommand.ascii ( ) ); iRet = iRet;

  qsCommand = getImgCmd ( qsMenuBackground );
  iRet = system ( qsCommand.ascii ( ) );
  qsDuration = getDuration ( qsMenuBackground );

  qsMenuXML += "<MainVMGM MenuWidth=\"720\" TitlesetNr=\"0\" MenuHeight=\"480\" MenuFormat=\"1\" MenuRatio=\"4:3\" MenuNr=\"0\" >\n";
  qsMenuXML += "  <MenuVariables>\n";
  qsMenuXML += "   <MenuOffset>00:00:00.000</MenuOffset>\n";
  qsMenuXML += "   <MenuDuration>" + qsDuration + "</MenuDuration>\n";
  qsMenuXML += qsMenuMovie;
  qsMenuXML += "   <MenuBackground ResizeAlgo=\"Normal Qt\" OffsetX=\"0\" OffsetY=\"0\" StretchType=\"0\" >" + qsMenuBackground + "</MenuBackground>\n";
  qsMenuXML += "   <MenuName>Main Menu VMGM</MenuName>\n";
  qsMenuXML += "   <MaskColors>#00fefffe,#a0ff1414,#a0fa9632,#ff0f0fff,</MaskColors>\n";
  qsMenuXML += "  </MenuVariables>\n";
  qsMenuXML += "  <PreviewVariables>\n";
  qsMenuXML += "   <ButtonObject Action=\"jump+-+Menu 2+-+\" PreAction=\"\" ButtonName=\"Button 1\" >\n";
  qsMenuXML += "    <NormalState>\n";
  qsMenuXML += "     <TextObject BackgroundColor=\"#ffffe866\" TextAlign=\"4,64\" ForegroundColor=\"#ffff1437\" Font=\"Courier,26,-1,5,75,0,0,0,0,0\" Text=\"First Menu\" >\n";
  qsMenuXML += "      <MenuObject Width=\"231\" X=\"257\" Y=\"210\" Height=\"45\" ObjectName=\"First Menu\" />\n";
  qsMenuXML += "     </TextObject>\n";
  qsMenuXML += "    </NormalState>\n";
  qsMenuXML += "    <SelectedState>\n";
  qsMenuXML += "     <TextObject StyleStrategy=\"256\" TextAlign=\"4,64\" ForegroundColor=\"#a0ff1414\" Font=\"Courier,26,-1,5,75,0,0,0,0,0\" Text=\"First Menu\">\n";
  qsMenuXML += "      <MenuObject Width=\"231\" X=\"257\" Y=\"210\" Height=\"45\" ObjectName=\"First Menu\" />\n";
  qsMenuXML += "     </TextObject>\n";
  qsMenuXML += "    </SelectedState>\n";
  qsMenuXML += "    <HighlightedState>\n";
  qsMenuXML += "     <TextObject StyleStrategy=\"256\" TextAlign=\"4,64\" ForegroundColor=\"#a0fa9632\" Font=\"Courier,26,-1,5,75,0,0,0,0,0\" Text=\"First Menu\">\n";
  qsMenuXML += "      <MenuObject Width=\"231\" X=\"257\" Y=\"210\" Height=\"45\" ObjectName=\"First Menu\" />\n";
  qsMenuXML += "     </TextObject>\n";
  qsMenuXML += "    </HighlightedState>\n";
  qsMenuXML += "    <MenuObject Width=\"231\" X=\"257\" Y=\"210\" Height=\"45\" ObjectName=\"Button 1\" />\n";
  qsMenuXML += "   </ButtonObject>\n";
  qsMenuXML += "  </PreviewVariables>\n";
  qsMenuXML += " </MainVMGM>\n";

  emit ( signalNewMenuResponse ( theType, qsMenuName, qsMenuXML ) );
}

bool ComplexDVD::execute ( )
{
  int iButtonsPerMenu = 6;
  // Here we create the DVD Structure for the given input arameters
  QValueList<SourceGroup *>::iterator it = m_listOfGroups.begin ( );
  SourceGroup *pGroup = NULL;
  int iMenuNumber, iCount;
  iMenuNumber = iCount = 0;
  // First we should add the Groups ( SourceFIleEntries ...
  while ( it != m_listOfGroups.end ( ) )  {
    pGroup = *it++;
    emit ( signalNewSource ( pGroup ) );
  }

  QCursor myCursor ( QCursor::WaitCursor );
  QApplication::setOverrideCursor ( myCursor );

  // The next iteration we generate the DVDMenus.
  m_iNrOfMenus  = (int)( ( m_listOfGroups.count ( ) + iButtonsPerMenu - 1 ) / iButtonsPerMenu );

  // Here we eval if we should snap some random images off of the internet
  if ( m_pConfigWidget && m_pConfigWidget->m_pCheckRandomImages && 
       m_pConfigWidget->m_pCheckRandomImages->isChecked ( ) )
    getRandomBackground ( );
  if ( m_pConfigWidget && m_pConfigWidget->m_pCheckMainMenu && 
       m_pConfigWidget->m_pCheckMainMenu->isChecked ( ) )  {
    createMainMenu ( );
    iMenuNumber ++;
  }

  int iProgress   = 0;
  int iSlideCount = 1;
  QDialog   progressDialog    ( NULL );
  QGridLayout  progressLayout ( &progressDialog );
  QProgressBar progressBar    ( &progressDialog );
  progressLayout.addWidget    ( &progressBar, 0, 0 );
  progressDialog.resize       ( QSize(550, 50).expandedTo ( progressDialog.minimumSizeHint ( ) ) );
  progressDialog.setCaption   ( tr ( "Creating [Menu 1]" ) );
  progressDialog.show         ( );
  progressBar.setTotalSteps   ( (int)m_listOfGroups.count ( ) );
  progressBar.setProgress     ( iProgress++  );
  qApp->processEvents         ( 500 );

  QValueList<SourceGroup *> listGroups;
  it = m_listOfGroups.begin  ( );
  while ( it != m_listOfGroups.end  ( ) )  {
    pGroup = *it++;
    // Next we create the Menus required ...
    // The number of menus depends on the max number of buttons per menu ( m_iButtonsPerMenu )
    listGroups.append ( pGroup );
    if ( iCount++ >= iButtonsPerMenu - 1 )  {
      SourceGroup::type theType = pGroup->enType;
      QString qsMenuXML = getMenuXML ( listGroups, ++iMenuNumber, iSlideCount );
      listGroups.clear ( );

      QString qsMenuName = QString ( "Menu %1" ).arg ( iMenuNumber );
      progressDialog.setCaption ( tr ( "Creating [%1]" ).arg ( qsMenuName ) );

      // Create the DVDMenu
      emit ( signalNewMenuResponse ( theType, qsMenuName, qsMenuXML ) );
      iCount = 0;
    }
    progressBar.setProgress ( iProgress++ );
    qApp->processEvents     ( 10 );
  }
  if ( iCount > 0 )  {
      SourceGroup::type theType = pGroup->enType;
      QString qsMenuName, qsMenuXML;
      qsMenuName.sprintf ( "Menu %d", ++iMenuNumber );
      qsMenuXML = getMenuXML ( listGroups, iMenuNumber, iSlideCount );
      listGroups.clear ( );

      // Create the DVDMenu
      //printf ( "%s\n\n\n", qsMenuXML.ascii ( ) );
      emit ( signalNewMenuResponse ( theType, qsMenuName, qsMenuXML ) );
  }
  QApplication::restoreOverrideCursor ( );
  return true;
}

QString ComplexDVD::getMenuXML ( QValueList<SourceGroup *> &list, int iMenuNumber, int &iSlideCount )
{
  QFileInfo fileInfo;
  QString qsMenuXML, qsBackgroundFile, qsMenuName, qsFileName, qsGroupName, qsDuration, qsMenuMovie;
  QString qsHeight = "480";
  QString qsButtonName, qsFrameName, qsObjectName, qsJumpTo, qsX, qsY, qsW, qsH, qsTempPath;
  int iX, iY, iCount = 0;
  SourceGroup *pGroup = NULL;
  if ( list.count ( ) < 1 )
    return qsMenuXML;

  qsTempPath = m_qsTempPath + "/" + m_qsProjectName;
  qsBackgroundFile = SYSTEM_DIRECTORY"/share/qdvdauthor/plugins/complexdvd/background.jpg";
  if ( m_pConfigWidget && m_pConfigWidget->m_pCheckRandomImages && 
       m_pConfigWidget->m_pCheckRandomImages->isChecked ( ) )  {
    if ( m_pActiveGui && ! m_pActiveGui->m_bIsImage ) // m_pConfigWidget->m_pRadioDreamScene->isChecked ( ) )
      qsMenuMovie = QString ( "<MenuMovie>%1/menu_%2.vob</MenuMovie>\n" ).arg ( qsTempPath ).arg ( iMenuNumber );
    qsBackgroundFile = QString ( "%1/menu_%2.jpg" ).arg ( qsTempPath ).arg ( iMenuNumber );
  }

  qsDuration = getDuration ( qsBackgroundFile );
  qsMenuName.sprintf ( "Menu %d", iMenuNumber );
  pGroup = list[0];
  if ( pGroup->enType == SourceGroup::PAL )
    qsHeight = "576";

  qsMenuXML += " <DVDMenu MenuWidth=\"720\" MenuHeight=\""+qsHeight+"\" MenuFormat=\"0\" MenuRatio=\"4:3\" >\n";
  qsMenuXML += "  <MenuVariables>\n";
  qsMenuXML += "   <MenuOffset>00:00:00.000</MenuOffset>\n";
  qsMenuXML += "   <MenuDuration>" + qsDuration + "</MenuDuration>\n";
  qsMenuXML += qsMenuMovie;
  qsMenuXML += "   <MenuBackground ResizeAlgo=\"Normal Qt\" OffsetX=\"0\" OffsetY=\"0\" StretchType=\"2\" >" + qsBackgroundFile + "</MenuBackground>\n";
  qsMenuXML += "   <MenuName>" + qsMenuName + "</MenuName>\n";
  qsMenuXML += "   <MaskColors>#00fefffe,#a0ff1414,#a0fa9632,#ff0f0fff,</MaskColors>\n";
  qsMenuXML += "  </MenuVariables>\n";
  qsMenuXML += "  <PreviewVariables>\n";

  // Transparent area - Top
  qsMenuXML += "   <TextObject BackgroundColor=\"#ffaaff5a\" TextAlign=\"4,64\" ForegroundColor=\"#fff15735\" Font=\"Sans Serif,20,-1,5,75,0,0,0,0,0\" Text=\"\" >\n";
  qsMenuXML += "    <MenuObject Width=\"740\" X=\"0\" Y=\"35\" Height=\"150\" ObjectName=\"\" >\n";
  qsMenuXML += "     <Modifiers Transparency=\"0.60\" />\n";
  qsMenuXML += "    </MenuObject>\n";
  qsMenuXML += "   </TextObject>\n";

  // Transparent area - Bottom
  qsMenuXML += "   <TextObject BackgroundColor=\"#fff4f5f4\" TextAlign=\"4,64\" ForegroundColor=\"#ff000000\" Font=\"Courier,12,-1,5,50,0,0,0,0,0\" Text=\"\" >\n";
  qsMenuXML += "    <MenuObject Width=\"740\" X=\"-8\" Y=\"285\" Height=\"150\" ObjectName=\"\" >\n";
  qsMenuXML += "     <Modifiers Transparency=\"0.60\" />\n";
  qsMenuXML += "    </MenuObject>\n";
  qsMenuXML += "   </TextObject>\n";

  // Next we take care of the Buttons ...
  QValueList<SourceGroup *>::iterator it;
  it = list.begin ( );
  while ( it != list.end ( ) )  {
    pGroup = *it++;

    if ( ! pGroup )
       continue;

    qsFileName  = "";
    qsGroupName = pGroup->qsGroupName;
    if ( pGroup->bSlideshow )  {
      qsGroupName.sprintf ( "[%02d] - %s", iSlideCount++, (const char *)pGroup->qsGroupName.utf8 ( ) );
      qsFileName  = pGroup->qsGroupName + ".vob+-+00:00:00.000";
    }
    else if ( pGroup->listFiles.size ( ) > 0 )  {
      fileInfo.setFile ( pGroup->listFiles[0]->qsFileName );
      qsFileName = fileInfo.fileName ( );
      if ( qsFileName.length ( ) > 0 )
        qsFileName += "+-+00:00:00.000";
    }
//jump+-+[01] - cordes.mpg+-+001_capture001.mpeg+-+00:00:00.000
    qsJumpTo = QString ( "jump+-+%1+-+%2" ).arg ( qsGroupName ).arg ( qsFileName );
    qsButtonName  = QString ( "Button %1" ).arg ( ++iCount );
    qsObjectName  = QString ( "Object_%1" ).arg (   iCount );
    qsFrameName   = QString ( "Frame %1"  ).arg (   iCount );
    iX  = ( iCount-1 )%3 * 210 + 90;
    iY  = ( iCount > 3 ) ? 400 : 150;
    qsX = QString ( "%1" ).arg ( iX );
    qsY = QString ( "%1" ).arg ( iY );

    // First we create the assiciated TextObject
    qsMenuXML += "   <TextObject TextAlign=\"4,64\" ForegroundColor=\"#fff15735\" Font=\"Sans Serif,16,-1,5,75,0,0,0,0,0\" Text=\""+pGroup->qsGroupName+"\" >\n";
    qsMenuXML += "    <MenuObject Width=\"150\" X=\""+qsX+"\" Y=\""+qsY+"\" Height=\"41\" ObjectName=\""+pGroup->qsGroupName+"\" />\n";
    qsMenuXML += "   </TextObject>\n";

    iY = ( iCount > 3 ) ? 295 : 45;

    QRect r = scaleScreenshot ( pGroup->qsScreenshot, 150, 115 );

    qsX = QString ( "%1" ).arg ( iX + r.left ( ) );
    qsY = QString ( "%1" ).arg ( iY + r.top  ( ) );
    qsW = QString ( "%1" ).arg ( r.width  ( ) );
    qsH = QString ( "%1" ).arg ( r.height ( ) );

    // Next we create the ButtonObject for the video jump+-+vmgm+-+
    qsMenuXML += "   <ButtonObject Action=\""+qsJumpTo+"\" ButtonName=\""+qsButtonName+"\"  SourceEntry=\""+qsGroupName+"\" >\n";
    qsMenuXML += "    <NormalState>\n";
    qsMenuXML += "     <ImageObject FileName=\""+pGroup->qsScreenshot+"\" >\n";
    qsMenuXML += "      <Manipulator>\n";
    qsMenuXML += "       <Modifiers/>\n";
    qsMenuXML += "      </Manipulator>\n";
    qsMenuXML += "      <MenuObject Width=\""+qsW+"\" X=\""+qsX+"\" Y=\""+qsY+"\" Height=\""+qsH+"\" ObjectName=\""+qsObjectName+"\" ObjectExtractionPath=\""+qsObjectName+"\" />\n";
    qsMenuXML += "     </ImageObject>\n";
    qsMenuXML += "    </NormalState>\n";

    qsMenuXML += "    <SelectedState>\n";
    qsMenuXML += "     <FrameObject Width=\"10\" Color=\"#a0ff1414\" >\n";
    qsMenuXML += "      <MenuObject Width=\""+qsW+"\" X=\""+qsX+"\" Y=\""+qsY+"\" Height=\""+qsH+"\" ObjectName=\""+qsFrameName+"\" />\n";
    qsMenuXML += "     </FrameObject>\n";
    qsMenuXML += "    </SelectedState>\n";
    qsMenuXML += "    <HighlightedState>\n";
    qsMenuXML += "     <FrameObject Width=\"10\" Color=\"#ff0f0fff\" >\n";
    qsMenuXML += "      <MenuObject Width=\""+qsW+"\" X=\""+qsX+"\" Y=\""+qsY+"\" Height=\""+qsH+"\" ObjectName=\""+qsFrameName+"\" />\n";
    qsMenuXML += "     </FrameObject>\n";
    qsMenuXML += "    </HighlightedState>\n";
    qsMenuXML += "    <MenuObject Width=\""+qsW+"\" X=\""+qsX+"\" Y=\""+qsY+"\" Height=\""+qsH+"\" ObjectName=\""+qsButtonName+"\" />\n";
    qsMenuXML += "   </ButtonObject>\n";
  }
  // Create prev/next buttons
  int  iNrOfMenus = m_iNrOfMenus;
  if ( m_pConfigWidget->m_pCheckMainMenu->isChecked ( ) )
       iNrOfMenus ++;

  bool bPrev = ( iMenuNumber > 1 );
  bool bNext = ( iMenuNumber < iNrOfMenus );
  qsMenuXML += getMenuButtons ( bPrev, bNext, iMenuNumber );

  qsMenuXML += "  </PreviewVariables>\n";
  qsMenuXML += " </DVDMenu>\n";

  return qsMenuXML;
}

QString ComplexDVD::getMenuButtons ( bool bPrev, bool bNext, int iMenuNumber )
{
  QString qsMenuXML, qsMenuName;
  // The three buttons to the previous, next and Main menu ...
  QString qsButtonPrev = SYSTEM_DIRECTORY"/share/qdvdauthor/plugins/complexdvd/prev.png";
  QString qsButtonMain = SYSTEM_DIRECTORY"/share/qdvdauthor/plugins/complexdvd/main.png";
  QString qsButtonNext = SYSTEM_DIRECTORY"/share/qdvdauthor/plugins/complexdvd/next.png";
  if ( bPrev )  {
    if ( iMenuNumber < 3 )
      qsMenuName = QString ( "vmgm" );
    else
      qsMenuName = QString ( "Menu %1" ).arg ( iMenuNumber - 1 );
    qsMenuXML += "   <ButtonObject Action=\"jump+-+"+qsMenuName+"+-+\" ButtonName=\"Button 7\" >\n";
    qsMenuXML += "    <NormalState>\n";
    qsMenuXML += "     <ImageObject FileName=\""+qsButtonPrev+"\" >\n";
    qsMenuXML += "      <Manipulator>\n";
    qsMenuXML += "       <Modifiers/>\n";
    qsMenuXML += "       <ColorKey Color=\"#fffefffe\" />\n";
    qsMenuXML += "      </Manipulator>\n";
    qsMenuXML += "      <MenuObject Width=\"60\" X=\"253\" Y=\"212\" Height=\"45\" ObjectName=\"PrevImg\" ObjectExtractionPath=\"PrevImg\" />\n";
    qsMenuXML += "     </ImageObject>\n";
    qsMenuXML += "    </NormalState>\n";
    qsMenuXML += "    <SelectedState>\n";
    qsMenuXML += "     <MaskObject Color=\"#a0ff1414\" />\n";
    qsMenuXML += "    </SelectedState>\n";
    qsMenuXML += "    <HighlightedState>\n";
    qsMenuXML += "     <MaskObject Color=\"#a0fa9632\" />\n";
    qsMenuXML += "    </HighlightedState>\n";
    qsMenuXML += "    <MenuObject Width=\"60\" X=\"253\" Y=\"212\" Height=\"45\" ObjectName=\"ButtonPrev\" />\n";
    qsMenuXML += "   </ButtonObject>\n";
  }
  if ( bNext )  {
    qsMenuName = QString ( "Menu %1" ).arg ( iMenuNumber + 1 );
    qsMenuXML += "   <ButtonObject Action=\"jump+-+"+qsMenuName+"+-+\" ButtonName=\"Button 8\" >\n";
    qsMenuXML += "    <NormalState>\n";
    qsMenuXML += "     <ImageObject FileName=\""+qsButtonNext+"\" >\n";
    qsMenuXML += "      <Manipulator>\n";
    qsMenuXML += "       <Modifiers/>\n";
    qsMenuXML += "       <ColorKey Color=\"#fffefffe\" />\n";
    qsMenuXML += "      </Manipulator>\n";
    qsMenuXML += "      <MenuObject Width=\"60\" X=\"378\" Y=\"213\" Height=\"45\" ObjectName=\"NextImg\" ObjectExtractionPath=\"NextImg\" />\n";
    qsMenuXML += "     </ImageObject>\n";
    qsMenuXML += "    </NormalState>\n";
    qsMenuXML += "    <SelectedState>\n";
    qsMenuXML += "     <MaskObject Color=\"#a0ff1414\" />\n";
    qsMenuXML += "    </SelectedState>\n";
    qsMenuXML += "    <HighlightedState>\n";
    qsMenuXML += "     <MaskObject Color=\"#a0fa9632\" />\n";
    qsMenuXML += "    </HighlightedState>\n";
    qsMenuXML += "    <MenuObject Width=\"60\" X=\"378\" Y=\"213\" Height=\"45\" ObjectName=\"ButtonNext\" />\n";
    qsMenuXML += "   </ButtonObject>\n";
  }
  // Button to the Main Menu ..
  qsMenuXML += "   <ButtonObject Action=\"jump+-+vmgm+-+\" ButtonName=\"Button 9\" >\n";
  qsMenuXML += "    <NormalState>\n";
  qsMenuXML += "     <ImageObject FileName=\""+qsButtonMain+"\" >\n";
  qsMenuXML += "      <Manipulator>\n";
  qsMenuXML += "       <Modifiers/>\n";
  qsMenuXML += "       <ColorKey Color=\"#fffefffe\" />\n";
  qsMenuXML += "      </Manipulator>\n";
  qsMenuXML += "      <MenuObject Width=\"60\" X=\"315\" Y=\"206\" Height=\"56\" ObjectName=\"MainImg\" ObjectExtractionPath=\"MainImg\" />\n";
  qsMenuXML += "     </ImageObject>\n";
  qsMenuXML += "    </NormalState>\n";
  qsMenuXML += "    <SelectedState>\n";
  qsMenuXML += "     <MaskObject Color=\"#a0ff1414\" />\n";
  qsMenuXML += "    </SelectedState>\n";
  qsMenuXML += "    <HighlightedState>\n";
  qsMenuXML += "     <MaskObject Color=\"#a0fa9632\" />\n";
  qsMenuXML += "    </HighlightedState>\n";
  qsMenuXML += "    <MenuObject Width=\"60\" X=\"315\" Y=\"206\" Height=\"56\" ObjectName=\"ButtonMain\" />\n";
  qsMenuXML += "   </ButtonObject>\n";

  return   qsMenuXML;
}

QRect ComplexDVD::scaleScreenshot ( QString &qsScreenshot, int iWidth, int iHeight )
{
  QRect rect ( 0, 0, iWidth, iHeight );
  QFileInfo fileInfo  ( qsScreenshot );
  if ( ! fileInfo.exists ( ) )
    return rect;

  QString qsTemp = m_qsTempPath + "/" + fileInfo.baseName ( ) + ".png";
  QImage image ( qsScreenshot );
  if (   image.isNull ( ) )
    return rect;

  int x, y, w, h;
  double fScaleX = ( (double)image.height ( ) / image.width  ( ) );
  double fScaleY = ( (double)image.width  ( ) / image.height ( ) );
  x = 0; y = 0; w = iWidth; h = iHeight;

  if ( fScaleX <= fScaleY )  {
    // Here we are scaling based on the width
//    h = (int)( fScaleX * iHeight );
    h = (int)( fScaleX * iWidth );
    y = (int)( (double)( iHeight - h ) / 2.0 );
  }
  else  {
    // Here we are scaling based on the height
    w = (int)( fScaleY * iWidth );
    x = (int)( (double)( iWidth - w ) / 2.0 );
  }

  rect = QRect ( x, y, w, h );
  return rect;
}

}; // end namespace Plugin

