/****************************************************************************
** Class DialogConvert
**
**   Created : Tue Oct 14 09:13:25 2006
**        by : Varol Okan, using XEmaxs
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
**
****************************************************************************/

#ifndef DIALOGCONVERT_H
#define DIALOGCONVERT_H

#include "uidialogconvert.h"

class DVDMenu;
class QDVDAuthor;
class SourceFileEntry;
class SourceFileInfo;
class MenuObject;
class MenuPreview;

class DialogConvert : public uiDialogConvert
{
    Q_OBJECT

    class Pair {
    public:
      Pair ( SourceFileEntry *, SourceFileEntry * );
      Pair ( DVDMenu *, DVDMenu * );
      SourceFileEntry *entries[2];
      DVDMenu         *menus  [2];
    };

public:
   DialogConvert ( QDVDAuthor * );
  ~DialogConvert ( );

  void convert ( DVDMenu    *, bool );

private:
  void createButtonObject  ( MenuPreview *, QString, QString, QRect );
  void setDVDMenuInterface ( DVDMenu *, QString &, bool );
  void fixButtonObjects  ( );
  void fixButtonObjects  ( bool,         bool );
  void createChooserMenu ( DVDMenu *,    bool );
  void updateObject (   MenuObject *          );
  void convert ( MenuObject *, double, double );
  void convert ( SourceFileEntry *,      bool );
  void convert ( bool        , bool );
  bool isPal   ( SourceFileInfo  *  );

protected slots:
  virtual void accept                (      );
  virtual void slotAllMenus          ( bool );
  virtual void slotAllVideos         ( bool );
  virtual void slotChooserMenu       ( bool );
  virtual void slotKeepOriginalMenus ( bool );

private:
  QDVDAuthor *m_pDVDAuthor;
  QString     m_qsOrigNorm;

  // these hold the orig and the converted menus
  QPtrList<Pair> m_listSourceFileEntryPair;
  QPtrList<Pair> m_listDVDMenuPair;
};

#endif // DIALOGCONVERT_H
