/****************************************************************************
** Interface to the GUI.
**
**   Created : Thu Jan 18 22:48:00 2007
**        by : Varol Okan using XEmacs
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
**
****************************************************************************/

#ifndef __DIALOGTHUMBNAIL_H__
#define __DIALOGTHUMBNAIL_H__

#include <qimage.h>

#include "qplayer/mediascanner.h"
#include "uidialogthumbnail.h"

class QDVDAuthor;
class SourceFileInfo;
class SourceFileEntry;

class DialogThumbnail : public uiDialogThumbnail
{
  Q_OBJECT

  class ThumbnailRequest : public ExecuteJob {
  public:
    ThumbnailRequest ( DialogThumbnail *, QIconViewItem *, QString, long );
    virtual ~ThumbnailRequest ( );

    virtual bool response ( );

    QIconViewItem   *pOwnerItem;
    DialogThumbnail *pParent;
  };
  // When the image is rendered the returned data is temp stored in this struct
  // to be executed in timerEvent.
  class WorkWaiting
  {
  public:
     WorkWaiting ( QIconViewItem *, QImage *, QString );
    ~WorkWaiting ( );

    QIconViewItem *pItem;
    QImage        *pImage;
    QString        qsFileName;
  };

 public: // public strctures ...
  class TextAttr
  {
  public:
     TextAttr ( ) { backgroundColor=0; foregroundColor=0; };
    ~TextAttr ( ) { };

    QString qsText;
    QFont   font;
    QRgb    backgroundColor; // including transparency
    QRgb    foregroundColor; // including transparency
  };
  class FrameAttr
  {
  public:
     FrameAttr ( ) { iStyle=Qt::SolidLine; iWidth=4; iJoin=Qt::MiterJoin; color=0; };
    ~FrameAttr ( ) { };
    int  iStyle;
    int  iWidth;
    int  iJoin;
    QRgb color;
  };

public:
  DialogThumbnail ( QDVDAuthor *p=NULL, const char *n=0, WFlags f=0 );
  virtual ~DialogThumbnail ( );

  void initSourceFileEntry( SourceFileEntry * );
  void initSourceFileInfo ( SourceFileInfo  *, QString & );
  void initWork           ( QIconViewItem   *, QImage  *, QString );
  bool updateItem         ( QIconViewItem   *, QImage  *, QString );
  virtual void show           ( );

  static TextAttr  *textAttr  ( );
  static FrameAttr *frameAttr ( );

protected slots:
  virtual void slotFont          ( );
  virtual void slotFrame         ( );
  virtual void slotReload        ( );
  virtual void slotRefresh       ( );
  virtual void slotSizePressed   ( );
  virtual void slotSizeReleased  ( );
  virtual void slotSpaceReleased ( );
  virtual void slotTextType      ( int );
  virtual void slotSizeChanged   ( int );
  virtual void slotSpaceChanged  ( int );
  virtual void slotChapterChanged( QListBoxItem * );

protected:
  virtual void timerEvent ( QTimerEvent * );

  bool    getBufferedThumbnail        (      );
  void    refresh                     ( bool );
  void    refreshEntry                ( bool );
  void    setItemText ( QIconViewItem *, int );
  QString getChapter  ( QIconViewItem *      );
  QIconViewItem *createCurrentItem    ( bool );
   QIconViewItem *createCurrentItem    ( SourceFileInfo *, bool, QString );

  // Replacement for SourceFileInfo / SourceFileEntry vars
  bool    haveSource     ( );
  int     chapterCount   ( );
  void    chapterChanged ( QListBoxItem * );
  QString chapter        ( int );
  SourceFileInfo *getInfoFromChapterNumber ( int );
  int             getChapterNumberFromKey  ( QString );

private:
  static TextAttr  m_textAttr;
  static FrameAttr m_frameAttr;

  SourceFileEntry *m_pSourceFileEntry;
  SourceFileInfo  *m_pSourceFileInfo;
  QImage           m_image;
  QString          m_qsActionString;
  uint             m_iProgress;
  uint             m_iCurrentChapter;
  uint             m_iThumbnailStretchMode;
  uint             m_iThumbnailWidth;
  uint             m_iThumbnailHeight;

  int              m_iSliderWidthStart;
  int              m_iSliderHeightStart;
  QValueList<WorkWaiting *> m_listOfWorkToDo;
};

#endif // __DIALOGTHUMBNAIL_H__

