/*****************************************************************************
 ** After the User has selected and grouped all Images, and Videos, we'll have a list of groups.
 **
 ** To create a DVD structure from this list the following information should be provided.
 ** 
 ** General :
 **  - Plugin to use for DVD creation
 **  - type ( NTSC/PAL )
 **  - Max # menu buttons
 **  - Project Name
 **  - temp path 
 **
 ** Group :
 **  - Type ( Slideshow / Videos )
 **  - Name of the Group
 **  - Create Chapter menu(s) -yes/no-
 **  - Date from - to of material within the group
 **  - Source files
 **  - Audio File(s) for Slideshow
 **
 ** Source Files :  ( Slideshow already in VOB + Chapters )
 **  - File Name
 **  - Start Date - End Date
 **
 ** NOTE: Slideshow information is profided as video file(s). 
 **       I.e. The individual images are already converted int VOBs.
 **
 *****************************************************************************/

#ifndef __PLUGIN_SIMPLEDVD_H__
#define __PLUGIN_SIMPLEDVD_H__

#include <qvaluelist.h>

#include "run.h"
#include "../interface.h"

class uiControls;
class QProgressDialog;
class QHBoxLayout;
class QRadioButton;
class QLabel;
class QComboBox;
class QGroupBox;

namespace Plugin
{

class ComplexDVD : public Interface
{
  Q_OBJECT

  class ScriptGui
  {
    // Container to hold the widgets per script or this plugin
  public:
    ScriptGui ( QGroupBox *, QString, QString , bool, bool, bool );
    virtual ~ScriptGui ( );

    QString       m_qsScript; // Including absolute path
    QString       m_qsMainLink;
    bool          m_bCategory;
    bool          m_bTheme;
    bool          m_bIsImage;
    QGroupBox    *m_pParent;

    QHBoxLayout  *m_pLayoutScriptTitle;
    QRadioButton *m_pRadioScript;
    QLabel       *m_pLabelScript;
    QHBoxLayout  *m_pLayoutScriptSelection;
    QLabel       *m_pLabelScriptCategory;
    QComboBox    *m_pComboScriptCategory;
    QLabel       *m_pLabelScriptTheme;
    QComboBox    *m_pComboScriptTheme;
  };
  class exe : public Run
  {
  public:
             exe ( );
    virtual ~exe ( );

    virtual int  start  ( QStringList *pEnv=0 );
    virtual void stdOut ( QString & );
    QString getOutput ( );
    QString m_qsOutput;
  };

public:
           ComplexDVD ( );
  virtual ~ComplexDVD ( );

  virtual QWidget *getConfigWidget ( QWidget * );
  virtual bool execute ( );

protected slots:
  virtual void slotInitTimer     ( );
  virtual void slotRandomImages  ( bool );
  virtual void slotCheckedScript ( );
  virtual void slotComboCategory ( int );

protected:
  QString getMenuXML      ( QValueList<SourceGroup *> &, int, int & );
  QString getMenuButtons  ( bool, bool, int );
  QString getDuration     ( QString & );
  QRect   scaleScreenshot ( QString  &, int, int );
  QString getImgCmd       ( QString & );
  void    getRandomBackground ( );
  void    createMainMenu      ( );

  int             m_iNrOfMenus;
  uiControls     *m_pConfigWidget;
  QValueList<int> m_listNumberOfImages;

private:
  void createFromScript ( QString );

private: // Private data
  QString m_qsScriptsPath; // Path where the scripts should reside.
  QValueList<ScriptGui *> m_listScriptsGui;
  ScriptGui      *m_pActiveGui;
  ComplexDVD::exe m_execute;
}; // end class SimpleDVD

};  // End namespace Plugin

#endif // __PLUGIN_SIMPLEDVD_H__

