/****************************************************************************
** StructureToolBar - class
**
**   Created : Tue May 04 12:09:08 2004
**        by : Varol Okan using kate editor
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
** This class will create a toolbar, which holds only one widget.
** The StructureWidget is displaying the current structure of the DVD.
**
****************************************************************************/
#include <qmainwindow.h>
#include <qdockarea.h>
#include <qlistview.h>

#include "dvdmenu.h"
#include "menuobject.h"
#include "menupreview.h"
#include "sourcetoolbar.h"
#include "structuretoolbar.h"

StructureItem::~StructureItem ( )
{
//printf ( "    StructureItem : DELETE  <%p> <%s>\n", this, text ( 0 ).ascii ( ) );
  initMe ( StructureItem::Unknown );
}

void StructureItem::initMe ( enType type )
{
//printf ( "    StructureItem : CREATE  <%p> <%s>\n", this, text( 0 ).ascii ( ) );
  m_pDVDMenu     = NULL; 
  m_pMenuPreview = NULL; 
  m_pMenuObject  = NULL; 
  setPixmap ( type );
}

StructureItem *StructureItem::setSibling ( MenuObject *pMenuObject, StructureItem *pItem, QString qsName, QString qsArgs )
{
  StructureItem *pSibling = NULL;

  if ( pItem )
    pSibling = (StructureItem *)pItem->nextSibling ( );
  else
    pSibling = (StructureItem *)firstChild ( );

  if ( ! pSibling )
    pSibling = new StructureItem ( pMenuObject, StructureItem::Unknown, this, pItem, qsName, qsArgs );
  else
    pSibling->setText ( qsName, qsArgs );

  return pSibling;
}

StructureItem *StructureItem::setSibling ( DVDMenu *pDVDMenu, StructureItem *pItem, QString qsName, QString qsArgs )
{
  StructureItem *pSibling = NULL;

  if ( pItem )
    pSibling = (StructureItem *)pItem->nextSibling ( );
  else
    pSibling = (StructureItem *)firstChild ( );

  if ( ! pSibling )
    pSibling = new StructureItem ( pDVDMenu, StructureItem::Unknown, this, pItem, qsName, qsArgs );
  else
    pSibling->setText ( qsName, qsArgs );

  return pSibling;
}

StructureItem *StructureItem::setSibling ( MenuPreview *pMenuPreview, StructureItem *pItem, QString qsName, QString qsArgs )
{
  StructureItem *pSibling = NULL;

  if ( pItem )
    pSibling = (StructureItem *)pItem->nextSibling ( );
  else
    pSibling = (StructureItem *)firstChild ( );

  if ( ! pSibling )
    pSibling = new StructureItem ( pMenuPreview, StructureItem::Unknown, this, pItem, qsName, qsArgs );
  else
    pSibling->setText ( qsName, qsArgs );

  return pSibling;
}

void StructureItem::setPixmap ( StructureItem::enType type )
{
  // This function will load the apropriate pixmap from the resources.
  m_type = type;
  int x, iSize = 32;  // 19 icons stored in this one pix.
  x = (int)type * iSize;

  QPixmap allImages = QPixmap::fromMimeSource ( "structure_icons.png" );
//  QPixmap allImages = QPixmap::fromMimeSource ( "checkered.png" );
  QPixmap thePixmap ( iSize, iSize );
  copyBlt ( &thePixmap, 0, 0, &allImages, x, 0, iSize, iSize );

  if ( ! thePixmap.isNull ( ) )
     QListViewItem::setPixmap ( 0, thePixmap );
}

void StructureItem::setText ( QString &qsName, QString &qsArgs )
{
  if ( text ( 0 ) != qsName )
    setText ( 0,     qsName );
  if ( text ( 1 ) != qsArgs )
    setText ( 1,     qsArgs );
}

void StructureItem::setText ( int iColumn, QString &qsText )
{
  return QListViewItem::setText ( iColumn, qsText );
}

StructureItem *StructureItem::lastChild ( )
{
  StructureItem *pPrev, *pLastItem = (StructureItem *)firstChild ( );
  pPrev = pLastItem;
  while ( pLastItem ) {
    // Special handling for this item ...
    if  ( pLastItem->text ( 0 ) == QObject::tr ( "Specified Buttons" ) )
      return pPrev;
    pPrev     = pLastItem;
    pLastItem = (StructureItem *)pLastItem->nextSibling ( );
  }
  return pPrev;
}

StructureToolBar::StructureToolBar ( QDockWindow *pSourceToolbar )
{
  m_pSourceToolBar = (SourceToolBar *)pSourceToolbar;
  QListView  *pListView = m_pSourceToolBar->getStructureListView ( );
  QTabWidget *pTabCtrl  = m_pSourceToolBar->getTabCtrl           ( );

  connect( pListView, SIGNAL( rightButtonPressed ( QListViewItem *, const QPoint &, int )), this, SLOT (slotRightClickedOnStructure (QListViewItem *, const QPoint &, int)) );
  connect( pListView, SIGNAL( rightButtonPressed ( QListViewItem *, const QPoint &, int )), this, SLOT (slotRightClickedOnTitleset  (QListViewItem *, const QPoint &, int)) );

  connect ( pTabCtrl, SIGNAL ( currentChanged ( QWidget * ) ), this, SLOT ( slotTabChanged ( QWidget * ) ) );
}

StructureToolBar::~StructureToolBar ()
{
}

void StructureToolBar::slotTabChanged ( QWidget *pCurrent )
{
  if (  m_pSourceToolBar->getStructureListView  ( )->parent ( ) == pCurrent )  {
    m_pSourceToolBar->getButton ( true  )->hide ( );
    m_pSourceToolBar->getButton ( false )->hide ( );
  }
  else  {
    m_pSourceToolBar->getButton ( true  )->show ( );
    m_pSourceToolBar->getButton ( false )->show ( );
  }
}

StructureItem *StructureToolBar::clean ( bool )
{
  StructureItem *pMainItem = NULL;
  QListView     *pListView;

  pListView = m_pSourceToolBar->getStructureListView ( );
  // if there is already a 'first' Item, then we return this.
  if  ( pListView->firstChild ( ) )
    return (StructureItem *)pListView->firstChild ( );
  //pListView->clear ();
  pMainItem = new StructureItem ( pListView, StructureItem::DVDProject, tr ("DVD Project") );

  pListView->setSorting( -1, TRUE );
  pMainItem->setExpandable ( TRUE );
  pMainItem->setOpen       ( TRUE );

  return pMainItem;
}

void StructureToolBar::slotRightClickedOnStructure (QListViewItem *pItem, const QPoint &pos, int iColumn)
{
  if ( ( ! pItem ) || (iColumn == -1) || (pItem->rtti () != 5000 ) )
    return; 
  StructureItem *pStructureItem = (StructureItem *)pItem;
  pStructureItem->createContextMenu (pos);
}

void StructureToolBar::slotRightClickedOnTitleset (QListViewItem *, const QPoint &, int)
{
  //  printf ("StructureToolBar::slotRightClickedOnTitleset\n");
}

void StructureItem::createContextMenu    ( QPoint p )
{
  QString qsText  = text ( 1 );
  bool bIntro     = false;
  bool bSoundFile = false;
  if ( text ( 0 ).find ( "Intro File" ) > -1 )
    bIntro = true;
  else if ( text ( 0 ).find ( "Sound File" ) > -1 )
    bSoundFile = true;

  if ( m_pMenuObject )
    m_pMenuObject->createContextMenu  ( p );    
  else if ( m_pMenuPreview )
    m_pMenuPreview->createContextMenu ( p );
  else if ( m_pDVDMenu ) {
    if ( bSoundFile )
      m_pDVDMenu->createSoundMenu ( p, qsText );
    else
      m_pDVDMenu->createIntroExtroMenu( p, bIntro, qsText );
  }
}

