/*
 * Copyright (c) 2016 Heiko Stuebner <heiko@sntech.de>
 *
 * SPDX-License-Identifier:	GPL-2.0
 */

#ifndef _ASM_ARCH_GRF_RK3188_H
#define _ASM_ARCH_GRF_RK3188_H

struct rk3188_grf_gpio_lh {
	u32 l;
	u32 h;
};

struct rk3188_grf {
	struct rk3188_grf_gpio_lh gpio_dir[4];
	struct rk3188_grf_gpio_lh gpio_do[4];
	struct rk3188_grf_gpio_lh gpio_en[4];

	u32 reserved[2];
	u32 gpio0c_iomux;
	u32 gpio0d_iomux;

	u32 gpio1a_iomux;
	u32 gpio1b_iomux;
	u32 gpio1c_iomux;
	u32 gpio1d_iomux;

	u32 gpio2a_iomux;
	u32 gpio2b_iomux;
	u32 gpio2c_iomux;
	u32 gpio2d_iomux;

	u32 gpio3a_iomux;
	u32 gpio3b_iomux;
	u32 gpio3c_iomux;
	u32 gpio3d_iomux;

	u32 soc_con0;
	u32 soc_con1;
	u32 soc_con2;
	u32 soc_status0;

	u32 busdmac_con[3];
	u32 peridmac_con[4];

	u32 cpu_con[6];
	u32 reserved0[2];

	u32 ddrc_con0;
	u32 ddrc_stat;

	u32 io_con[5];
	u32 soc_status1;

	u32 uoc0_con[4];
	u32 uoc1_con[4];
	u32 uoc2_con[2];
	u32 reserved1;
	u32 uoc3_con[2];
	u32 hsic_stat;
	u32 os_reg[8];

	u32 gpio0_p[3];
	u32 gpio1_p[3][4];

	u32 flash_data_p;
	u32 flash_cmd_p;
};
check_member(rk3188_grf, flash_cmd_p, 0x01a4);

/* GRF_GPIO0D_IOMUX */
enum {
	GPIO0D7_SHIFT		= 14,
	GPIO0D7_MASK		= 1,
	GPIO0D7_GPIO		= 0,
	GPIO0D7_SPI1_CSN0,

	GPIO0D6_SHIFT		= 12,
	GPIO0D6_MASK		= 1,
	GPIO0D6_GPIO		= 0,
	GPIO0D6_SPI1_CLK,

	GPIO0D5_SHIFT		= 10,
	GPIO0D5_MASK		= 1,
	GPIO0D5_GPIO		= 0,
	GPIO0D5_SPI1_TXD,

	GPIO0D4_SHIFT		= 8,
	GPIO0D4_MASK		= 1,
	GPIO0D4_GPIO		= 0,
	GPIO0D4_SPI0_RXD,

	GPIO0D3_SHIFT		= 6,
	GPIO0D3_MASK		= 3,
	GPIO0D3_GPIO		= 0,
	GPIO0D3_FLASH_CSN3,
	GPIO0D3_EMMC_RSTN_OUT,

	GPIO0D2_SHIFT		= 4,
	GPIO0D2_MASK		= 3,
	GPIO0D2_GPIO		= 0,
	GPIO0D2_FLASH_CSN2,
	GPIO0D2_EMMC_CMD,

	GPIO0D1_SHIFT		= 2,
	GPIO0D1_MASK		= 1,
	GPIO0D1_GPIO		= 0,
	GPIO0D1_FLASH_CSN1,

	GPIO0D0_SHIFT		= 0,
	GPIO0D0_MASK		= 3,
	GPIO0D0_GPIO		= 0,
	GPIO0D0_FLASH_DQS,
	GPIO0D0_EMMC_CLKOUT
};

/* GRF_GPIO1A_IOMUX */
enum {
	GPIO1A7_SHIFT		= 14,
	GPIO1A7_MASK		= 3,
	GPIO1A7_GPIO		= 0,
	GPIO1A7_UART1_RTS_N,
	GPIO1A7_SPI0_CSN0,

	GPIO1A6_SHIFT		= 12,
	GPIO1A6_MASK		= 3,
	GPIO1A6_GPIO		= 0,
	GPIO1A6_UART1_CTS_N,
	GPIO1A6_SPI0_CLK,

	GPIO1A5_SHIFT		= 10,
	GPIO1A5_MASK		= 3,
	GPIO1A5_GPIO		= 0,
	GPIO1A5_UART1_SOUT,
	GPIO1A5_SPI0_TXD,

	GPIO1A4_SHIFT		= 8,
	GPIO1A4_MASK		= 3,
	GPIO1A4_GPIO		= 0,
	GPIO1A4_UART1_SIN,
	GPIO1A4_SPI0_RXD,

	GPIO1A3_SHIFT		= 6,
	GPIO1A3_MASK		= 1,
	GPIO1A3_GPIO		= 0,
	GPIO1A3_UART0_RTS_N,

	GPIO1A2_SHIFT		= 4,
	GPIO1A2_MASK		= 1,
	GPIO1A2_GPIO		= 0,
	GPIO1A2_UART0_CTS_N,

	GPIO1A1_SHIFT		= 2,
	GPIO1A1_MASK		= 1,
	GPIO1A1_GPIO		= 0,
	GPIO1A1_UART0_SOUT,

	GPIO1A0_SHIFT		= 0,
	GPIO1A0_MASK		= 1,
	GPIO1A0_GPIO		= 0,
	GPIO1A0_UART0_SIN,
};

/* GRF_GPIO1B_IOMUX */
enum {
	GPIO1B7_SHIFT		= 14,
	GPIO1B7_MASK		= 1,
	GPIO1B7_GPIO		= 0,
	GPIO1B7_SPI0_CSN1,

	GPIO1B6_SHIFT		= 12,
	GPIO1B6_MASK		= 3,
	GPIO1B6_GPIO		= 0,
	GPIO1B6_SPDIF_TX,
	GPIO1B6_SPI1_CSN1,

	GPIO1B5_SHIFT		= 10,
	GPIO1B5_MASK		= 3,
	GPIO1B5_GPIO		= 0,
	GPIO1B5_UART3_RTS_N,
	GPIO1B5_RESERVED,

	GPIO1B4_SHIFT		= 8,
	GPIO1B4_MASK		= 3,
	GPIO1B4_GPIO		= 0,
	GPIO1B4_UART3_CTS_N,
	GPIO1B4_GPS_RFCLK,

	GPIO1B3_SHIFT		= 6,
	GPIO1B3_MASK		= 3,
	GPIO1B3_GPIO		= 0,
	GPIO1B3_UART3_SOUT,
	GPIO1B3_GPS_SIG,

	GPIO1B2_SHIFT		= 4,
	GPIO1B2_MASK		= 3,
	GPIO1B2_GPIO		= 0,
	GPIO1B2_UART3_SIN,
	GPIO1B2_GPS_MAG,

	GPIO1B1_SHIFT		= 2,
	GPIO1B1_MASK		= 3,
	GPIO1B1_GPIO		= 0,
	GPIO1B1_UART2_SOUT,
	GPIO1B1_JTAG_TDO,

	GPIO1B0_SHIFT		= 0,
	GPIO1B0_MASK		= 3,
	GPIO1B0_GPIO		= 0,
	GPIO1B0_UART2_SIN,
	GPIO1B0_JTAG_TDI,
};

/* GRF_GPIO1D_IOMUX */
enum {
	GPIO1D7_SHIFT		= 14,
	GPIO1D7_MASK		= 1,
	GPIO1D7_GPIO		= 0,
	GPIO1D7_I2C4_SCL,

	GPIO1D6_SHIFT		= 12,
	GPIO1D6_MASK		= 1,
	GPIO1D6_GPIO		= 0,
	GPIO1D6_I2C4_SDA,

	GPIO1D5_SHIFT		= 10,
	GPIO1D5_MASK		= 1,
	GPIO1D5_GPIO		= 0,
	GPIO1D5_I2C2_SCL,

	GPIO1D4_SHIFT		= 8,
	GPIO1D4_MASK		= 1,
	GPIO1D4_GPIO		= 0,
	GPIO1D4_I2C2_SDA,

	GPIO1D3_SHIFT		= 6,
	GPIO1D3_MASK		= 1,
	GPIO1D3_GPIO		= 0,
	GPIO1D3_I2C1_SCL,

	GPIO1D2_SHIFT		= 4,
	GPIO1D2_MASK		= 1,
	GPIO1D2_GPIO		= 0,
	GPIO1D2_I2C1_SDA,

	GPIO1D1_SHIFT		= 2,
	GPIO1D1_MASK		= 1,
	GPIO1D1_GPIO		= 0,
	GPIO1D1_I2C0_SCL,

	GPIO1D0_SHIFT		= 0,
	GPIO1D0_MASK		= 1,
	GPIO1D0_GPIO		= 0,
	GPIO1D0_I2C0_SDA,
};

/* GRF_GPIO3A_IOMUX */
enum {
	GPIO3A7_SHIFT		= 14,
	GPIO3A7_MASK		= 1,
	GPIO3A7_GPIO		= 0,
	GPIO3A7_SDMMC0_DATA3,

	GPIO3A6_SHIFT		= 12,
	GPIO3A6_MASK		= 1,
	GPIO3A6_GPIO		= 0,
	GPIO3A6_SDMMC0_DATA2,

	GPIO3A5_SHIFT		= 10,
	GPIO3A5_MASK		= 1,
	GPIO3A5_GPIO		= 0,
	GPIO3A5_SDMMC0_DATA1,

	GPIO3A4_SHIFT		= 8,
	GPIO3A4_MASK		= 1,
	GPIO3A4_GPIO		= 0,
	GPIO3A4_SDMMC0_DATA0,

	GPIO3A3_SHIFT		= 6,
	GPIO3A3_MASK		= 1,
	GPIO3A3_GPIO		= 0,
	GPIO3A3_SDMMC0_CMD,

	GPIO3A2_SHIFT		= 4,
	GPIO3A2_MASK		= 1,
	GPIO3A2_GPIO		= 0,
	GPIO3A2_SDMMC0_CLKOUT,

	GPIO3A1_SHIFT		= 2,
	GPIO3A1_MASK		= 1,
	GPIO3A1_GPIO		= 0,
	GPIO3A1_SDMMC0_PWREN,

	GPIO3A0_SHIFT		= 0,
	GPIO3A0_MASK		= 1,
	GPIO3A0_GPIO		= 0,
	GPIO3A0_SDMMC0_RSTN,
};

/* GRF_GPIO3B_IOMUX */
enum {
	GPIO3B7_SHIFT		= 14,
	GPIO3B7_MASK		= 3,
	GPIO3B7_GPIO		= 0,
	GPIO3B7_CIF_DATA11,
	GPIO3B7_I2C3_SCL,

	GPIO3B6_SHIFT		= 12,
	GPIO3B6_MASK		= 3,
	GPIO3B6_GPIO		= 0,
	GPIO3B6_CIF_DATA10,
	GPIO3B6_I2C3_SDA,

	GPIO3B5_SHIFT		= 10,
	GPIO3B5_MASK		= 3,
	GPIO3B5_GPIO		= 0,
	GPIO3B5_CIF_DATA1,
	GPIO3B5_HSADC_DATA9,

	GPIO3B4_SHIFT		= 8,
	GPIO3B4_MASK		= 3,
	GPIO3B4_GPIO		= 0,
	GPIO3B4_CIF_DATA0,
	GPIO3B4_HSADC_DATA8,

	GPIO3B3_SHIFT		= 6,
	GPIO3B3_MASK		= 1,
	GPIO3B3_GPIO		= 0,
	GPIO3B3_CIF_CLKOUT,

	GPIO3B2_SHIFT		= 4,
	GPIO3B2_MASK		= 1,
	GPIO3B2_GPIO		= 0,
	/* no muxes */

	GPIO3B1_SHIFT		= 2,
	GPIO3B1_MASK		= 1,
	GPIO3B1_GPIO		= 0,
	GPIO3B1_SDMMC0_WRITE_PRT,

	GPIO3B0_SHIFT		= 0,
	GPIO3B0_MASK		= 1,
	GPIO3B0_GPIO		= 0,
	GPIO3B0_SDMMC_DETECT_N,
};

/* GRF_GPIO3C_IOMUX */
enum {
	GPIO3C7_SHIFT		= 14,
	GPIO3C7_MASK		= 3,
	GPIO3C7_GPIO		= 0,
	GPIO3C7_SDMMC1_WRITE_PRT,
	GPIO3C7_RMII_CRS_DVALID,
	GPIO3C7_RESERVED,

	GPIO3C6_SHIFT		= 12,
	GPIO3C6_MASK		= 3,
	GPIO3C6_GPIO		= 0,
	GPIO3C6_SDMMC1_DECTN,
	GPIO3C6_RMII_RX_ERR,
	GPIO3C6_RESERVED,

	GPIO3C5_SHIFT		= 10,
	GPIO3C5_MASK		= 3,
	GPIO3C5_GPIO		= 0,
	GPIO3C5_SDMMC1_CLKOUT,
	GPIO3C5_RMII_CLKOUT,
	GPIO3C5_RMII_CLKIN,

	GPIO3C4_SHIFT		= 8,
	GPIO3C4_MASK		= 3,
	GPIO3C4_GPIO		= 0,
	GPIO3C4_SDMMC1_DATA3,
	GPIO3C4_RMII_RXD1,
	GPIO3C4_RESERVED,

	GPIO3C3_SHIFT		= 6,
	GPIO3C3_MASK		= 3,
	GPIO3C3_GPIO		= 0,
	GPIO3C3_SDMMC1_DATA2,
	GPIO3C3_RMII_RXD0,
	GPIO3C3_RESERVED,

	GPIO3C2_SHIFT		= 4,
	GPIO3C2_MASK		= 3,
	GPIO3C2_GPIO		= 0,
	GPIO3C2_SDMMC1_DATA1,
	GPIO3C2_RMII_TXD0,
	GPIO3C2_RESERVED,

	GPIO3C1_SHIFT		= 2,
	GPIO3C1_MASK		= 3,
	GPIO3C1_GPIO		= 0,
	GPIO3C1_SDMMC1_DATA0,
	GPIO3C1_RMII_TXD1,
	GPIO3C1_RESERVED,

	GPIO3C0_SHIFT		= 0,
	GPIO3C0_MASK		= 3,
	GPIO3C0_GPIO		= 0,
	GPIO3C0_SDMMC1_CMD,
	GPIO3C0_RMII_TX_EN,
	GPIO3C0_RESERVED,
};

/* GRF_GPIO3D_IOMUX */
enum {
	GPIO3D6_SHIFT		= 12,
	GPIO3D6_MASK		= 3,
	GPIO3D6_GPIO		= 0,
	GPIO3D6_PWM_3,
	GPIO3D6_JTAG_TMS,
	GPIO3D6_HOST_DRV_VBUS,

	GPIO3D5_SHIFT		= 10,
	GPIO3D5_MASK		= 3,
	GPIO3D5_GPIO		= 0,
	GPIO3D5_PWM_2,
	GPIO3D5_JTAG_TCK,
	GPIO3D5_OTG_DRV_VBUS,

	GPIO3D4_SHIFT		= 8,
	GPIO3D4_MASK		= 3,
	GPIO3D4_GPIO		= 0,
	GPIO3D4_PWM_1,
	GPIO3D4_JTAG_TRSTN,

	GPIO3D3_SHIFT		= 6,
	GPIO3D3_MASK		= 3,
	GPIO3D3_GPIO		= 0,
	GPIO3D3_PWM_0,

	GPIO3D2_SHIFT		= 4,
	GPIO3D2_MASK		= 3,
	GPIO3D2_GPIO		= 0,
	GPIO3D2_SDMMC1_INT_N,

	GPIO3D1_SHIFT		= 2,
	GPIO3D1_MASK		= 3,
	GPIO3D1_GPIO		= 0,
	GPIO3D1_SDMMC1_BACKEND_PWR,
	GPIO3D1_MII_MDCLK,

	GPIO3D0_SHIFT		= 0,
	GPIO3D0_MASK		= 3,
	GPIO3D0_GPIO		= 0,
	GPIO3D0_SDMMC1_PWR_EN,
	GPIO3D0_MII_MD,
};

/* GRF_SOC_CON0 */
enum {
	HSADC_CLK_DIR_SHIFT	= 15,
	HSADC_CLK_DIR_MASK	= 1,

	HSADC_SEL_SHIFT		= 14,
	HSADC_SEL_MASK		= 1,

	NOC_REMAP_SHIFT		= 12,
	NOC_REMAP_MASK		= 1,

	EMMC_FLASH_SEL_SHIFT	= 11,
	EMMC_FLASH_SEL_MASK	= 1,

	TZPC_REVISION_SHIFT	= 7,
	TZPC_REVISION_MASK	= 0xf,

	L2CACHE_ACC_SHIFT	= 5,
	L2CACHE_ACC_MASK	= 3,

	L2RD_WAIT_SHIFT		= 3,
	L2RD_WAIT_MASK		= 3,

	IMEMRD_WAIT_SHIFT	= 1,
	IMEMRD_WAIT_MASK	= 3,
};

/* GRF_SOC_CON1 */
enum {
	RKI2C4_SEL_SHIFT	= 15,
	RKI2C4_SEL_MASK		= 1,

	RKI2C3_SEL_SHIFT	= 14,
	RKI2C3_SEL_MASK		= 1,

	RKI2C2_SEL_SHIFT	= 13,
	RKI2C2_SEL_MASK		= 1,

	RKI2C1_SEL_SHIFT	= 12,
	RKI2C1_SEL_MASK		= 1,

	RKI2C0_SEL_SHIFT	= 11,
	RKI2C0_SEL_MASK		= 1,

	VCODEC_SEL_SHIFT	= 10,
	VCODEC_SEL_MASK		= 1,

	PERI_EMEM_PAUSE_SHIFT	= 9,
	PERI_EMEM_PAUSE_MASK	= 1,

	PERI_USB_PAUSE_SHIFT	= 8,
	PERI_USB_PAUSE_MASK	= 1,

	SMC_MUX_MODE_0_SHIFT	= 6,
	SMC_MUX_MODE_0_MASK	= 1,

	SMC_SRAM_MW_0_SHIFT	= 4,
	SMC_SRAM_MW_0_MASK	= 3,

	SMC_REMAP_0_SHIFT	= 3,
	SMC_REMAP_0_MASK	= 1,

	SMC_A_GT_M0_SYNC_SHIFT	= 2,
	SMC_A_GT_M0_SYNC_MASK	= 1,

	EMAC_SPEED_SHIFT	= 1,
	EMAC_SPEEC_MASK		= 1,

	EMAC_MODE_SHIFT		= 0,
	EMAC_MODE_MASK		= 1,
};

/* GRF_SOC_CON2 */
enum {
	SDIO_CLK_OUT_SR_SHIFT	= 15,
	SDIO_CLK_OUT_SR_MASK	= 1,

	MEM_EMA_L2C_SHIFT	= 11,
	MEM_EMA_L2C_MASK	= 7,

	MEM_EMA_A9_SHIFT	= 8,
	MEM_EMA_A9_MASK		= 7,

	MSCH4_MAINDDR3_SHIFT	= 7,
	MSCH4_MAINDDR3_MASK	= 1,
	MSCH4_MAINDDR3_DDR3	= 1,

	EMAC_NEWRCV_EN_SHIFT	= 6,
	EMAC_NEWRCV_EN_MASK	= 1,

	SW_ADDR15_EN_SHIFT	= 5,
	SW_ADDR15_EN_MASK	= 1,

	SW_ADDR16_EN_SHIFT	= 4,
	SW_ADDR16_EN_MASK	= 1,

	SW_ADDR17_EN_SHIFT	= 3,
	SW_ADDR17_EN_MASK	= 1,

	BANK2_TO_RANK_EN_SHIFT	= 2,
	BANK2_TO_RANK_EN_MASK	= 1,

	RANK_TO_ROW15_EN_SHIFT	= 1,
	RANK_TO_ROW15_EN_MASK	= 1,

	UPCTL_C_ACTIVE_IN_SHIFT = 0,
	UPCTL_C_ACTIVE_IN_MASK	= 1,
	UPCTL_C_ACTIVE_IN_MAY	= 0,
	UPCTL_C_ACTIVE_IN_WILL,
};

/* GRF_DDRC_CON0 */
enum {
	DDR_16BIT_EN_SHIFT	= 15,
	DDR_16BIT_EN_MASK	= 1,

	DTO_LB_SHIFT		= 11,
	DTO_LB_MASK		= 3,

	DTO_TE_SHIFT		= 9,
	DTO_TE_MASK		= 3,

	DTO_PDR_SHIFT		= 7,
	DTO_PDR_MASK		= 3,

	DTO_PDD_SHIFT		= 5,
	DTO_PDD_MASK		= 3,

	DTO_IOM_SHIFT		= 3,
	DTO_IOM_MASK		= 3,

	DTO_OE_SHIFT		= 1,
	DTO_OE_MASK		= 3,

	ATO_AE_SHIFT		= 0,
	ATO_AE_MASK		= 1,
};
#endif
