/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#ifndef COMPLIB_H
#define COMPLIB_H

#include "coord.h"

#include "SPtnObj.h"
#include "SPtnObjArc.h"
#include "SPtnObjCircle.h"
#include "SPtnObjLine.h"
#include "SPtnObjPolygon.h"
#include "SPtnObjText.h"


class SReadCE3;
class SWriteCE3;

#ifdef _BSCH
	extern bool g_notSaveBitPtn;
#endif

#define PIN_LENGTH 10


////////////////////////////////////////////////////////////////////
//ʥ饤֥˴ط


enum PIN_TYPE
{
	PIN_TYPE_NOMAL		=0x00,
	PIN_TYPE_SMALL		=0x01,
	PIN_TYPE_ZLENG		=0x02,
	PIN_TYPE_CLOCK		=0x04,
	PIN_TYPE_NEGATIVE	=0x08,
	PIN_TYPE_NUMHIDE	=0x10
};

enum PIN_LOC
{
	PIN_LOC_L			=0x0,
	PIN_LOC_T			=0x1,
	PIN_LOC_R			=0x2,
	PIN_LOC_B			=0x3
};
/*
enum VECTPTN
{
	VECTPTN_L			=1,
	VECTPTN_C			=2,
	VECTPTN_PG			=3,
	VECTPTN_AR			=4
};
*/



typedef SPtnObj* PSPtnObj;
typedef list<SPtnObj*> SPtnObjList;
typedef list<SPtnObj*>::iterator SPtnObjListIterator;

//LB3饤֥ɤ߹ߤǻȤѥ󥯥饹
class SPtn
{
protected:
	unsigned char* readBmp(SReadCE3& rce3);//,int x,int y,int nBuffSize);
	//bool readLine(SReadCE3& rce3,int* vBuff,int vBuffCount,int* count);
	//bool readCircle(SReadCE3& rce3,int* vBuff,int vBuffCount,int* count);
	//bool readCircleFill(SReadCE3& rce3,int* vBuff,int vBuffCount,int* count);
	//bool readArc(SReadCE3& rce3,int* vBuff,int vBuffCount,int* count);
	//bool readPolygon(SReadCE3& rce3,int* vBuff,int vBuffCount,int* count);

	//bool writeLine(SWriteCE3& wce3,int* buff,int* count);
	//bool writeCircle(SWriteCE3& wce3,int* buff,int* count);
	//bool writeCircleFill(SWriteCE3& wce3,int* buff,int* count);
	//bool writeArc(SWriteCE3& wce3,int* buff,int* count);
	//bool writePolygon(SWriteCE3& wce3,int* buff,int* count);


public:
	char*			m_pszName;		//ѥ̾
	SSize			m_size;			//
	int				m_nBuffsize;	//ХåեΥ
	PSPtnObj*		m_ppvPtn;		//٥ȥѥ󥪥֥ȤΥݥ
	int				m_vPtnCount;
	unsigned char*	m_pBuff;		//ХåեؤΥݥ
//	int*			m_pvBuff;		//٥ȥؤΥݥ
//	int				m_nvBuffsize;	//٥ȥΥХåեΥ

	SPtn(){							//󥹥ȥ饯
		m_pszName=NULL;
		m_nBuffsize=0;
		m_pBuff=NULL;
//		m_nvBuffsize=0;
//		m_pvBuff=NULL;
		m_size=SSize(0,0);
		m_vPtnCount=0;
		m_ppvPtn=NULL;
	}

	SPtn(const SPtn&);				//ԡ󥹥ȥ饯
	SPtn& operator=(const SPtn&);	//黻	

	virtual ~SPtn();				//ǥȥ饯
	bool readCe3(SReadCE3& rce3);
	bool writeCe3(SWriteCE3& wce3,const char* pszName);
	void setSize(const SSize& sizePixel);
};



////////////////////////////////////////////////////////////////////
//ԥ󥯥饹
class SPin
{
protected:
	int			m_nBlock;	//m_nBlockοԥֹʸƤ
	char**		m_ppszNum;	//ԥֹʸؤΥݥ
	char*		m_pszName;	//ԥ̾ؤΥݥ
	int			m_nType;	//ԥΥ
	int			m_nLTRB;	// LTRB
	int			m_nOffset;	// եå
protected:
	void deleteBuff();

public:
	SPin();					//󥹥ȥ饯
	~SPin();
	SPin(const SPin&);				//ԡ󥹥ȥ饯
	SPin& operator=(const SPin&);	//黻

	
	void setBlock(int  nBlock);	//֥å򥻥åȤ롣
	void setPinName(const char* name);				//ԥ̾򥻥åȤ롣
	void setPinNum(int nBlock,const char* name);	//ԥֹ򥻥åȤ롣
	void setType(int type){ m_nType=type;}
	void setLtrb(int ltrb){ m_nLTRB=ltrb;}
	void setOffset(int offset){m_nOffset=offset;}
	const char* pinName() const {return m_pszName;}
	const char* pinNum(int nBlock) const;
	int type() const {return m_nType;}
	int ltrb() const {return m_nLTRB;}
	int offset() const {return m_nOffset;}
	int block() const { return m_nBlock;}

	bool readCe3(SReadCE3& rce3,int block);
	bool writeCe3(SWriteCE3& rce3);
};

typedef SPin* PSPin;

typedef list<SPin*> SPinList;
typedef list<SPin*>::iterator SPinListIterator;


////////////////////////////////////////////////////////////////////
//ʾ󥯥饹
class SCompInfo
{
protected:
	void deleteBuff();

public:
	char*	m_pszRef;	//ǥեֹ
	SSize	m_size;		//ʤΥ
	int		m_nBlock;	//ѥåΥ֥å
	SPtn*	m_pPtn;		//LB3ɤ߹ѥؤΥݥ
	int		m_nPinCount;//ԥ
	PSPin*	m_ppPin;	//LB3ɤ߹ԥ󥯥饹ؤΥݥ
	string	m_note;		//Ρ 2005/04/30
	SCompInfo(){		//󥹥ȥ饯
		m_pszRef	=NULL;
		m_nBlock	=1;
		m_pPtn		=NULL;
		m_nPinCount	=0;
		m_ppPin		=NULL;
		m_note		="";
	}
	~SCompInfo();			//ǥȥ饯

	SCompInfo(const SCompInfo&);			//ԡ󥹥ȥ饯
	SCompInfo& operator=(const SCompInfo&);	//黻

	bool readCe3(SReadCE3& rce3,string& name,string& ptnname);	//ե뤫ɤ߹
	bool writeCe3(SWriteCE3& wce3,const char* pszName);

	void setRef(const char* ref);		//ǥեֹ
	void setSize(const SSize& size,bool createPtn);	// ѥͭϥѥΥѹ
	void setUsePattern(bool usepattern);
	void setBlock(int block);
	void addPin(SPin* ppin);
	void removePin(int ltrb,int offset,bool move);
	void insertNullPin(int ltrb,int offset);
	SPin* pinInfo(int ltrb,int offset);	//ꤷ֤Υԥ
};

////////////////////////////////////////////////////////////////////
//ʥǥå饹
class SCompIndex
{
	char*				m_lpszName;	//̾
public:
	SCompInfo*			m_pCompInfo;//бʾ󥯥饹ؤΥݥ

	SCompIndex(){			//󥹥ȥ饯
		m_lpszName	=NULL;
		m_pCompInfo =NULL;
	}
	~SCompIndex(){			//ǥȥ饯
		delete[]m_lpszName;
	}
	void setName(const char* name);
	void setCompInfo(SCompInfo* pcinfo){m_pCompInfo = pcinfo;}

	SCompInfo* compInfo() const{return m_pCompInfo;}
	const char*	name() const{return m_lpszName;}			//̾
	const char* number() const;			//ֹ
	SSize size() const;					//
	SSize sizePlace(int dir) const;		//ֻο̾Υ
	int	  block() const;				//ѥåΥ֥å
	SPtn*	pattern() const;			//ѥؤΥݥ󥿤
	int	pinCount() const;				//ԥο
	SPin* pin(int index) const;			//ԥξ
	//ԥξ
	//ξ󤫤顢ԥΰ־(LTRBȡΥեå)֤
	//SPin* SCompIndex::pin(int index,int dir,int& nLtrb,SPoint& ptEnd) const;
	SPin* pin(int index,int dir,int& nLtrb,SPoint& ptEnd) const;

};



typedef SCompIndex* PSCompIndex;

typedef list<SPtn*> SPtnList;
typedef list<SPtn*>::iterator SPtnListIterator;

typedef list<SCompInfo*> SCompInfoList;
typedef list<SCompInfo*>::iterator SCompInfoListIterator;

typedef list<SCompIndex*> SCompIndexList;
typedef list<SCompIndex*>::iterator SCompIndexListIterator;


////////////////////////////////////////////////////////////////////
//ʥ饤֥ꥯ饹
class SCompLib
{
public:
	char*			m_lpszLibraryName;		//饤֥̾
	string			m_prop_string;
	SPtnList		m_listPtn;				//ɤ߹ѥΥꥹ
	SCompInfoList	m_listCompInfo;			//ɤ߹߹ʥ饹Υꥹ
	SCompIndexList	m_listCompIndex;		//ɤ߹߹ʥǥåΥꥹ
	PSCompIndex*	m_ppCompIndex;			//ɤ߹߹ʥǥåΥݥ
	int				m_aux1;
	int				m_aux2;


public:
	SCompLib(){										//󥹥ȥ饯
		m_lpszLibraryName=NULL;
		m_ppCompIndex=NULL;
		m_prop_string="";
		m_aux1 = 0;
		m_aux2 = 0;
		//m_nCount=0;
	}
	~SCompLib();										//ǥȥ饯
	bool ReadLb3(SReadCE3& rce3,bool singleComponent = false);//LB3饤֥ɤ߹
	void deleteContent();//Ƥ˴

	bool writeLibraryFile(const char* lpszFileName);	//ե񤭹
	bool readLibraryFile(const char* lpszFileName);		//եɤ߹

	void setLibraryName(const char* name);				//饤֥̾
	const char* libraryName() const ;					//饤֥̾
	int count() const{return m_listCompIndex.size();}	//ʿ
	SCompIndex* compIndex(int nIndexNum) const;			//nܤʤΥǥå

	static bool WriteAlias(SWriteCE3& wce3,const char*  alias,const char*  name);
	string uniqueName(const string& name);	//¸̾ȽŤʤʤ̾

private:
	bool ReadLb3Ptn(SReadCE3& rce3);//ѥɤ߹
	bool ReadLb3Comp(SReadCE3& rce3);
	bool ReadLb3Alias(SReadCE3& rce3);

	void clearPtnList();	//СѿѥꥹȤΥꥢ


	bool isUniqueName(const string& name);	//¸̾ȽʣƤʤɤ

	//bool WriteLb3Pin(SWriteCE3& wce3,const SPin& pin);							//ԥν񤭹
	//bool WriteLb3Ptn(SWriteCE3& wce3,const SPtn& ptn,const char*  name);			//ѥν񤭹
	//bool WriteLb3Comp(SWriteCE3& wce3,const SCompInfo& compinfo,SWriteCE3& wce3);	//ʤν񤭹
	
};


#endif
