# Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
#
# This file is part of Rast.
# See the file COPYING for redistribution information.
#

class GCStartInvoke
  SUPPORTED_VERSION = 1
  NAME = "rast-test-gc-start-invoke"

  def invoke(filter, brigade, mime_type)
    next_brigade = Rast::Brigade.new
    brigade.each do |bucket|
      if bucket.eos?
        next_brigade.insert_tail(Rast::EOSBucket.new)
      else
        next_brigade.insert_tail(Rast::TransientBucket.new(bucket.read))
      end
    end

    GC.start
    filter.pass(next_brigade, mime_type)
  end
end
