/* rygel-basic-management-test-traceroute.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-basic-management-test-traceroute.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Christophe Guiraud,
 *         Jussi Kukkonen
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST (rygel_basic_management_test_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest))
#define RYGEL_BASIC_MANAGEMENT_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTestClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST))
#define RYGEL_BASIC_MANAGEMENT_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTestClass))

typedef struct _RygelBasicManagementTest RygelBasicManagementTest;
typedef struct _RygelBasicManagementTestClass RygelBasicManagementTestClass;
typedef struct _RygelBasicManagementTestPrivate RygelBasicManagementTestPrivate;

#define RYGEL_BASIC_MANAGEMENT_TEST_TYPE_INIT_STATE (rygel_basic_management_test_init_state_get_type ())

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE (rygel_basic_management_test_traceroute_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTraceroute))
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTracerouteClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_TRACEROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_TRACEROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE))
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTracerouteClass))

typedef struct _RygelBasicManagementTestTraceroute RygelBasicManagementTestTraceroute;
typedef struct _RygelBasicManagementTestTracerouteClass RygelBasicManagementTestTracerouteClass;
typedef struct _RygelBasicManagementTestTraceroutePrivate RygelBasicManagementTestTraceroutePrivate;

#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_TYPE_STATUS (rygel_basic_management_test_traceroute_status_get_type ())

#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_TYPE_PROCESS_STATE (rygel_basic_management_test_traceroute_process_state_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_OK,
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_SPAWN_FAILED,
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER
} RygelBasicManagementTestInitState;

struct _RygelBasicManagementTest {
	GObject parent_instance;
	RygelBasicManagementTestPrivate * priv;
	GCancellable* _cancellable;
	RygelBasicManagementTestInitState init_state;
	gchar* id;
	guint iterations;
	GSpawnFlags flags;
	gchar** command;
	gint command_length1;
	gint _command_size_;
};

struct _RygelBasicManagementTestClass {
	GObjectClass parent_class;
	void (*init_iteration) (RygelBasicManagementTest* self);
	void (*handle_output) (RygelBasicManagementTest* self, const gchar* line);
	void (*handle_error) (RygelBasicManagementTest* self, const gchar* line);
	gboolean (*finish_iteration) (RygelBasicManagementTest* self);
	void (*run) (RygelBasicManagementTest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelBasicManagementTest* self, GAsyncResult* _res_);
	const gchar* (*get_method_type) (RygelBasicManagementTest* self);
	const gchar* (*get_results_type) (RygelBasicManagementTest* self);
};

struct _RygelBasicManagementTestTraceroute {
	RygelBasicManagementTest parent_instance;
	RygelBasicManagementTestTraceroutePrivate * priv;
};

struct _RygelBasicManagementTestTracerouteClass {
	RygelBasicManagementTestClass parent_class;
};

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_SUCCESS,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_MAX_HOP_COUNT_EXCEEDED,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_INTERNAL,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_OTHER
} RygelBasicManagementTestTracerouteStatus;

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_INIT,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_HOPS
} RygelBasicManagementTestTracerouteProcessState;

struct _RygelBasicManagementTestTraceroutePrivate {
	gchar* _host;
	guint32 _wait_time_out;
	guint _data_block_size;
	guint _max_hop_count;
	guint _dscp;
	GRegex* regex;
	GRegex* rtt_regex;
	RygelBasicManagementTestTracerouteStatus status;
	gboolean error_set;
	RygelBasicManagementTestTracerouteProcessState state;
	gchar* host_ip;
	gchar* additional_info;
	guint32 response_time;
	gchar* hop_ips;
};


static gpointer rygel_basic_management_test_traceroute_parent_class = NULL;

GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_init_state_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_traceroute_get_type (void) G_GNUC_CONST;
static GType rygel_basic_management_test_traceroute_status_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType rygel_basic_management_test_traceroute_process_state_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTraceroutePrivate))
enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DUMMY_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_HOST,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_WAIT_TIME_OUT,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DATA_BLOCK_SIZE,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_HOP_COUNT,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DSCP,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_METHOD_TYPE,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_RESULTS_TYPE
};
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_TIMEOUT ((guint) 5000)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_DATA_BLOCK_SIZE ((guint) 32)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_HOPS ((guint) 30)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_DSCP ((guint) 30)
static gchar* rygel_basic_management_test_traceroute_status_to_string (RygelBasicManagementTestTracerouteStatus self);
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MIN_TIMEOUT ((guint) 1000)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_TIMEOUT ((guint) 30000)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MIN_DATA_BLOCK_SIZE ((guint) 20)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_DATA_BLOCK_SIZE ((guint) 2048)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_DSCP ((guint) 64)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_HOPS ((guint) 64)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_HOSTS ((guint) 2048)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_RESULT_SIZE ((guint) 4)
RygelBasicManagementTestTraceroute* rygel_basic_management_test_traceroute_new (const gchar* host, guint32 wait_time_out, guint data_block_size, guint max_hop_count, guint dscp);
RygelBasicManagementTestTraceroute* rygel_basic_management_test_traceroute_construct (GType object_type, const gchar* host, guint32 wait_time_out, guint data_block_size, guint max_hop_count, guint dscp);
static void rygel_basic_management_test_traceroute_real_constructed (GObject* base);
guint rygel_basic_management_test_traceroute_get_max_hop_count (RygelBasicManagementTestTraceroute* self);
guint32 rygel_basic_management_test_traceroute_get_wait_time_out (RygelBasicManagementTestTraceroute* self);
guint rygel_basic_management_test_traceroute_get_dscp (RygelBasicManagementTestTraceroute* self);
const gchar* rygel_basic_management_test_traceroute_get_host (RygelBasicManagementTestTraceroute* self);
guint rygel_basic_management_test_traceroute_get_data_block_size (RygelBasicManagementTestTraceroute* self);
static void rygel_basic_management_test_traceroute_set_error (RygelBasicManagementTestTraceroute* self, RygelBasicManagementTestTracerouteStatus status, const gchar* info);
static void rygel_basic_management_test_traceroute_real_handle_error (RygelBasicManagementTest* base, const gchar* line);
static void rygel_basic_management_test_traceroute_real_handle_output (RygelBasicManagementTest* base, const gchar* line);
void rygel_basic_management_test_traceroute_get_results (RygelBasicManagementTestTraceroute* self, gchar** status, gchar** additional_info, guint32* response_time, gchar** hop_ips);
static void rygel_basic_management_test_traceroute_set_host (RygelBasicManagementTestTraceroute* self, const gchar* value);
static void rygel_basic_management_test_traceroute_set_wait_time_out (RygelBasicManagementTestTraceroute* self, guint32 value);
static void rygel_basic_management_test_traceroute_set_data_block_size (RygelBasicManagementTestTraceroute* self, guint value);
static void rygel_basic_management_test_traceroute_set_max_hop_count (RygelBasicManagementTestTraceroute* self, guint value);
static void rygel_basic_management_test_traceroute_set_dscp (RygelBasicManagementTestTraceroute* self, guint value);
static void rygel_basic_management_test_traceroute_finalize (GObject* obj);
const gchar* rygel_basic_management_test_get_method_type (RygelBasicManagementTest* self);
const gchar* rygel_basic_management_test_get_results_type (RygelBasicManagementTest* self);
static void _vala_rygel_basic_management_test_traceroute_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_basic_management_test_traceroute_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static GType rygel_basic_management_test_traceroute_process_state_get_type (void) {
	static volatile gsize rygel_basic_management_test_traceroute_process_state_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_traceroute_process_state_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_INIT, "RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_INIT", "init"}, {RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_HOPS, "RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_HOPS", "hops"}, {0, NULL, NULL}};
		GType rygel_basic_management_test_traceroute_process_state_type_id;
		rygel_basic_management_test_traceroute_process_state_type_id = g_enum_register_static ("RygelBasicManagementTestTracerouteProcessState", values);
		g_once_init_leave (&rygel_basic_management_test_traceroute_process_state_type_id__volatile, rygel_basic_management_test_traceroute_process_state_type_id);
	}
	return rygel_basic_management_test_traceroute_process_state_type_id__volatile;
}


static gchar* rygel_basic_management_test_traceroute_status_to_string (RygelBasicManagementTestTracerouteStatus self) {
	gchar* result = NULL;
#line 54 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	switch (self) {
#line 54 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_SUCCESS:
#line 232 "rygel-basic-management-test-traceroute.c"
		{
			gchar* _tmp0_ = NULL;
#line 56 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp0_ = g_strdup ("Success");
#line 56 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			result = _tmp0_;
#line 56 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			return result;
#line 241 "rygel-basic-management-test-traceroute.c"
		}
#line 54 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME:
#line 245 "rygel-basic-management-test-traceroute.c"
		{
			gchar* _tmp1_ = NULL;
#line 58 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp1_ = g_strdup ("Error_CannotResolveHostName");
#line 58 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			result = _tmp1_;
#line 58 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			return result;
#line 254 "rygel-basic-management-test-traceroute.c"
		}
#line 54 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_MAX_HOP_COUNT_EXCEEDED:
#line 258 "rygel-basic-management-test-traceroute.c"
		{
			gchar* _tmp2_ = NULL;
#line 60 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp2_ = g_strdup ("Error_MaxHopCountExceeded");
#line 60 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			result = _tmp2_;
#line 60 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			return result;
#line 267 "rygel-basic-management-test-traceroute.c"
		}
#line 54 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_INTERNAL:
#line 271 "rygel-basic-management-test-traceroute.c"
		{
			gchar* _tmp3_ = NULL;
#line 62 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp3_ = g_strdup ("Error_Internal");
#line 62 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			result = _tmp3_;
#line 62 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			return result;
#line 280 "rygel-basic-management-test-traceroute.c"
		}
#line 54 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_OTHER:
#line 284 "rygel-basic-management-test-traceroute.c"
		{
			gchar* _tmp4_ = NULL;
#line 64 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp4_ = g_strdup ("Error_Other");
#line 64 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			result = _tmp4_;
#line 64 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			return result;
#line 293 "rygel-basic-management-test-traceroute.c"
		}
		default:
		{
#line 66 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			g_assert_not_reached ();
#line 299 "rygel-basic-management-test-traceroute.c"
		}
	}
}


static GType rygel_basic_management_test_traceroute_status_get_type (void) {
	static volatile gsize rygel_basic_management_test_traceroute_status_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_traceroute_status_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_SUCCESS, "RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_SUCCESS", "success"}, {RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME, "RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME", "error-cannot-resolve-hostname"}, {RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_MAX_HOP_COUNT_EXCEEDED, "RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_MAX_HOP_COUNT_EXCEEDED", "error-max-hop-count-exceeded"}, {RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_INTERNAL, "RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_INTERNAL", "error-internal"}, {RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_OTHER, "RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_OTHER", "error-other"}, {0, NULL, NULL}};
		GType rygel_basic_management_test_traceroute_status_type_id;
		rygel_basic_management_test_traceroute_status_type_id = g_enum_register_static ("RygelBasicManagementTestTracerouteStatus", values);
		g_once_init_leave (&rygel_basic_management_test_traceroute_status_type_id__volatile, rygel_basic_management_test_traceroute_status_type_id);
	}
	return rygel_basic_management_test_traceroute_status_type_id__volatile;
}


RygelBasicManagementTestTraceroute* rygel_basic_management_test_traceroute_construct (GType object_type, const gchar* host, guint32 wait_time_out, guint data_block_size, guint max_hop_count, guint dscp) {
	RygelBasicManagementTestTraceroute * self = NULL;
	const gchar* _tmp0_ = NULL;
	guint32 _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_return_val_if_fail (host != NULL, NULL);
#line 164 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp0_ = host;
#line 164 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp1_ = wait_time_out;
#line 164 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp2_ = data_block_size;
#line 164 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp3_ = max_hop_count;
#line 164 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp4_ = dscp;
#line 164 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	self = (RygelBasicManagementTestTraceroute*) g_object_new (object_type, "host", _tmp0_, "wait-time-out", _tmp1_, "data-block-size", _tmp2_, "max-hop-count", _tmp3_, "dscp", _tmp4_, NULL);
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	return self;
#line 340 "rygel-basic-management-test-traceroute.c"
}


RygelBasicManagementTestTraceroute* rygel_basic_management_test_traceroute_new (const gchar* host, guint32 wait_time_out, guint data_block_size, guint max_hop_count, guint dscp) {
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	return rygel_basic_management_test_traceroute_construct (RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, host, wait_time_out, data_block_size, max_hop_count, dscp);
#line 347 "rygel-basic-management-test-traceroute.c"
}


static void rygel_basic_management_test_traceroute_real_constructed (GObject* base) {
	RygelBasicManagementTestTraceroute * self;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	guint32 _tmp13_ = 0U;
	guint32 _tmp14_ = 0U;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	guint _tmp17_ = 0U;
	guint _tmp18_ = 0U;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	guint _tmp23_ = 0U;
	guint _tmp24_ = 0U;
	gchar* _tmp25_ = NULL;
	gchar** _tmp26_ = NULL;
	gboolean _tmp27_ = FALSE;
	guint32 _tmp28_ = 0U;
	guint32 _tmp29_ = 0U;
	GError * _inner_error_ = NULL;
#line 171 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	self = (RygelBasicManagementTestTraceroute*) base;
#line 172 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	G_OBJECT_CLASS (rygel_basic_management_test_traceroute_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest));
#line 382 "rygel-basic-management-test-traceroute.c"
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_ = NULL;
		GRegex* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		GRegex* _tmp5_ = NULL;
#line 175 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_tmp1_ = g_regex_new ("^\\s*(\\d+)\\s+(\\S+)\\s*(.*)$", 0, 0, &_inner_error_);
#line 175 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_tmp0_ = _tmp1_;
#line 175 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 396 "rygel-basic-management-test-traceroute.c"
			goto __catch3_g_error;
		}
#line 175 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_tmp2_ = _tmp0_;
#line 175 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_tmp0_ = NULL;
#line 175 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_g_regex_unref0 (self->priv->regex);
#line 175 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		self->priv->regex = _tmp2_;
#line 176 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_tmp4_ = g_regex_new ("(\\S+)\\s+ms\\b", 0, 0, &_inner_error_);
#line 176 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_tmp3_ = _tmp4_;
#line 176 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 176 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_g_regex_unref0 (_tmp0_);
#line 415 "rygel-basic-management-test-traceroute.c"
			goto __catch3_g_error;
		}
#line 176 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_tmp5_ = _tmp3_;
#line 176 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_tmp3_ = NULL;
#line 176 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_g_regex_unref0 (self->priv->rtt_regex);
#line 176 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		self->priv->rtt_regex = _tmp5_;
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_g_regex_unref0 (_tmp3_);
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_g_regex_unref0 (_tmp0_);
#line 430 "rygel-basic-management-test-traceroute.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		e = _inner_error_;
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_inner_error_ = NULL;
#line 178 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		g_assert_not_reached ();
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_g_error_free0 (e);
#line 444 "rygel-basic-management-test-traceroute.c"
	}
	__finally3:
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		g_clear_error (&_inner_error_);
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		return;
#line 455 "rygel-basic-management-test-traceroute.c"
	}
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	self->priv->state = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_INIT;
#line 182 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_INTERNAL;
#line 183 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	self->priv->error_set = FALSE;
#line 184 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp6_ = g_strdup ("");
#line 184 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_g_free0 (self->priv->hop_ips);
#line 184 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	self->priv->hop_ips = _tmp6_;
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp7_ = g_strdup ("traceroute");
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp8_ = g_strdup ("-m");
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp9_ = rygel_basic_management_test_traceroute_get_max_hop_count (self);
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp10_ = _tmp9_;
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp11_ = g_strdup_printf ("%u", _tmp10_);
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp12_ = g_strdup ("-w");
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp13_ = rygel_basic_management_test_traceroute_get_wait_time_out (self);
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp14_ = _tmp13_;
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp15_ = g_strdup_printf ("%u", _tmp14_ / 1000);
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp16_ = g_strdup ("-t");
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp17_ = rygel_basic_management_test_traceroute_get_dscp (self);
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp18_ = _tmp17_;
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp19_ = g_strdup_printf ("%u", _tmp18_ >> 2);
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp20_ = g_strdup ("-n");
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp21_ = self->priv->_host;
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp22_ = g_strdup (_tmp21_);
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp23_ = rygel_basic_management_test_traceroute_get_data_block_size (self);
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp24_ = _tmp23_;
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp25_ = g_strdup_printf ("%u", _tmp24_);
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp26_ = g_new0 (gchar*, 10 + 1);
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp26_[0] = _tmp7_;
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp26_[1] = _tmp8_;
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp26_[2] = _tmp11_;
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp26_[3] = _tmp12_;
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp26_[4] = _tmp15_;
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp26_[5] = _tmp16_;
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp26_[6] = _tmp19_;
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp26_[7] = _tmp20_;
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp26_[8] = _tmp22_;
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp26_[9] = _tmp25_;
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	((RygelBasicManagementTest*) self)->command = (_vala_array_free (((RygelBasicManagementTest*) self)->command, ((RygelBasicManagementTest*) self)->command_length1, (GDestroyNotify) g_free), NULL);
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	((RygelBasicManagementTest*) self)->command = _tmp26_;
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	((RygelBasicManagementTest*) self)->command_length1 = 10;
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	((RygelBasicManagementTest*) self)->_command_size_ = ((RygelBasicManagementTest*) self)->command_length1;
#line 195 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp28_ = rygel_basic_management_test_traceroute_get_wait_time_out (self);
#line 195 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp29_ = _tmp28_;
#line 195 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	if (_tmp29_ < ((guint32) RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MIN_TIMEOUT)) {
#line 195 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_tmp27_ = TRUE;
#line 545 "rygel-basic-management-test-traceroute.c"
	} else {
		guint32 _tmp30_ = 0U;
		guint32 _tmp31_ = 0U;
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_tmp30_ = rygel_basic_management_test_traceroute_get_wait_time_out (self);
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_tmp31_ = _tmp30_;
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_tmp27_ = _tmp31_ > ((guint32) RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_TIMEOUT);
#line 555 "rygel-basic-management-test-traceroute.c"
	}
#line 195 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	if (_tmp27_) {
#line 559 "rygel-basic-management-test-traceroute.c"
		gchar* msg = NULL;
		gchar* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		guint32 _tmp34_ = 0U;
		guint32 _tmp35_ = 0U;
		gchar* _tmp36_ = NULL;
#line 198 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
#line 199 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_tmp32_ = g_strdup ("Timeout %u is not in allowed range [%u, %u]");
#line 199 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		msg = _tmp32_;
#line 200 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_tmp33_ = msg;
#line 200 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_tmp34_ = rygel_basic_management_test_traceroute_get_wait_time_out (self);
#line 200 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_tmp35_ = _tmp34_;
#line 200 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_tmp36_ = g_strdup_printf (_tmp33_, _tmp35_, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MIN_TIMEOUT, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_TIMEOUT);
#line 200 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_g_free0 (self->priv->additional_info);
#line 200 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		self->priv->additional_info = _tmp36_;
#line 195 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_g_free0 (msg);
#line 586 "rygel-basic-management-test-traceroute.c"
	} else {
		gboolean _tmp37_ = FALSE;
		guint _tmp38_ = 0U;
		guint _tmp39_ = 0U;
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_tmp38_ = rygel_basic_management_test_traceroute_get_data_block_size (self);
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_tmp39_ = _tmp38_;
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		if (_tmp39_ < RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MIN_DATA_BLOCK_SIZE) {
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp37_ = TRUE;
#line 599 "rygel-basic-management-test-traceroute.c"
		} else {
			guint _tmp40_ = 0U;
			guint _tmp41_ = 0U;
#line 205 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp40_ = rygel_basic_management_test_traceroute_get_data_block_size (self);
#line 205 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp41_ = _tmp40_;
#line 205 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp37_ = _tmp41_ > RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_DATA_BLOCK_SIZE;
#line 609 "rygel-basic-management-test-traceroute.c"
		}
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		if (_tmp37_) {
#line 613 "rygel-basic-management-test-traceroute.c"
			gchar* msg = NULL;
			gchar* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			guint _tmp44_ = 0U;
			guint _tmp45_ = 0U;
			gchar* _tmp46_ = NULL;
#line 206 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
#line 207 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp42_ = g_strdup ("DataBlockSize %u is not in allowed range [%u, %u]");
#line 207 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			msg = _tmp42_;
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp43_ = msg;
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp44_ = rygel_basic_management_test_traceroute_get_data_block_size (self);
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp45_ = _tmp44_;
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp46_ = g_strdup_printf (_tmp43_, _tmp45_, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MIN_DATA_BLOCK_SIZE, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_DATA_BLOCK_SIZE);
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_g_free0 (self->priv->additional_info);
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			self->priv->additional_info = _tmp46_;
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_g_free0 (msg);
#line 640 "rygel-basic-management-test-traceroute.c"
		} else {
			guint _tmp47_ = 0U;
			guint _tmp48_ = 0U;
#line 212 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp47_ = rygel_basic_management_test_traceroute_get_max_hop_count (self);
#line 212 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp48_ = _tmp47_;
#line 212 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			if (_tmp48_ > RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_HOPS) {
#line 650 "rygel-basic-management-test-traceroute.c"
				gchar* msg = NULL;
				gchar* _tmp49_ = NULL;
				const gchar* _tmp50_ = NULL;
				guint _tmp51_ = 0U;
				guint _tmp52_ = 0U;
				gchar* _tmp53_ = NULL;
#line 213 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
#line 214 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp49_ = g_strdup ("MaxHopCount %u is not in allowed range [0, %u]");
#line 214 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				msg = _tmp49_;
#line 215 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp50_ = msg;
#line 215 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp51_ = rygel_basic_management_test_traceroute_get_max_hop_count (self);
#line 215 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp52_ = _tmp51_;
#line 215 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp53_ = g_strdup_printf (_tmp50_, _tmp52_, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_HOPS);
#line 215 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_g_free0 (self->priv->additional_info);
#line 215 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				self->priv->additional_info = _tmp53_;
#line 212 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_g_free0 (msg);
#line 677 "rygel-basic-management-test-traceroute.c"
			} else {
				guint _tmp54_ = 0U;
				guint _tmp55_ = 0U;
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp54_ = rygel_basic_management_test_traceroute_get_dscp (self);
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp55_ = _tmp54_;
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				if (_tmp55_ > RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_DSCP) {
#line 687 "rygel-basic-management-test-traceroute.c"
					gchar* msg = NULL;
					gchar* _tmp56_ = NULL;
					const gchar* _tmp57_ = NULL;
					guint _tmp58_ = 0U;
					guint _tmp59_ = 0U;
					gchar* _tmp60_ = NULL;
#line 219 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					_tmp56_ = g_strdup ("DSCP %u is not in allowed range [0, %u]");
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					msg = _tmp56_;
#line 221 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					_tmp57_ = msg;
#line 221 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					_tmp58_ = rygel_basic_management_test_traceroute_get_dscp (self);
#line 221 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					_tmp59_ = _tmp58_;
#line 221 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					_tmp60_ = g_strdup_printf (_tmp57_, _tmp59_, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_DSCP);
#line 221 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					_g_free0 (self->priv->additional_info);
#line 221 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					self->priv->additional_info = _tmp60_;
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					_g_free0 (msg);
#line 714 "rygel-basic-management-test-traceroute.c"
				}
			}
		}
	}
}


static void rygel_basic_management_test_traceroute_set_error (RygelBasicManagementTestTraceroute* self, RygelBasicManagementTestTracerouteStatus status, const gchar* info) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	RygelBasicManagementTestTracerouteStatus _tmp2_ = 0;
#line 225 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_return_if_fail (self != NULL);
#line 225 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_return_if_fail (info != NULL);
#line 226 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	self->priv->error_set = TRUE;
#line 227 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp0_ = info;
#line 227 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 227 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_g_free0 (self->priv->additional_info);
#line 227 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	self->priv->additional_info = _tmp1_;
#line 228 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp2_ = status;
#line 228 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	self->priv->status = _tmp2_;
#line 744 "rygel-basic-management-test-traceroute.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1278 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1278 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 764 "rygel-basic-management-test-traceroute.c"
}


static void rygel_basic_management_test_traceroute_real_handle_error (RygelBasicManagementTest* base, const gchar* line) {
	RygelBasicManagementTestTraceroute * self;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 231 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	self = (RygelBasicManagementTestTraceroute*) base;
#line 231 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_return_if_fail (line != NULL);
#line 232 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp0_ = line;
#line 232 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp1_ = string_contains (_tmp0_, "Cannot handle \"host\" cmdline arg");
#line 232 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	if (_tmp1_) {
#line 233 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		rygel_basic_management_test_traceroute_set_error (self, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME, "");
#line 784 "rygel-basic-management-test-traceroute.c"
	} else {
		const gchar* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_tmp2_ = line;
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_tmp3_ = string_contains (_tmp2_, "Network is unreachable");
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		if (_tmp3_) {
#line 235 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			rygel_basic_management_test_traceroute_set_error (self, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_OTHER, "Network is unreachable.");
#line 796 "rygel-basic-management-test-traceroute.c"
		} else {
			const gchar* _tmp4_ = NULL;
#line 237 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp4_ = line;
#line 237 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			rygel_basic_management_test_traceroute_set_error (self, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_INTERNAL, _tmp4_);
#line 803 "rygel-basic-management-test-traceroute.c"
		}
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1115 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1116 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1116 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1117 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1117 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1118 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _result_;
#line 1118 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 828 "rygel-basic-management-test-traceroute.c"
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 920 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 921 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 921 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 921 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
#line 921 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 923 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 923 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 853 "rygel-basic-management-test-traceroute.c"
		gchar* _tmp4_ = NULL;
#line 924 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 924 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 924 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 861 "rygel-basic-management-test-traceroute.c"
	} else {
#line 926 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = -1;
#line 926 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 867 "rygel-basic-management-test-traceroute.c"
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1230 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1231 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1231 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1231 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1232 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1232 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 901 "rygel-basic-management-test-traceroute.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1233 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1233 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1233 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 910 "rygel-basic-management-test-traceroute.c"
	}
#line 1235 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1235 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 916 "rygel-basic-management-test-traceroute.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1236 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1236 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1236 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 925 "rygel-basic-management-test-traceroute.c"
	}
#line 1238 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1238 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 931 "rygel-basic-management-test-traceroute.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1238 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1238 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1238 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 940 "rygel-basic-management-test-traceroute.c"
	} else {
#line 1238 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 944 "rygel-basic-management-test-traceroute.c"
	}
#line 1238 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1239 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1239 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 952 "rygel-basic-management-test-traceroute.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1239 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1239 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1239 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 961 "rygel-basic-management-test-traceroute.c"
	} else {
#line 1239 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 965 "rygel-basic-management-test-traceroute.c"
	}
#line 1239 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1240 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1240 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1240 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1241 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1241 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1241 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1241 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1241 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1241 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 987 "rygel-basic-management-test-traceroute.c"
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
#line 789 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, 0.0);
#line 790 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 790 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
#line 790 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 790 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 1005 "rygel-basic-management-test-traceroute.c"
}


static void rygel_basic_management_test_traceroute_real_handle_output (RygelBasicManagementTest* base, const gchar* line) {
	RygelBasicManagementTestTraceroute * self;
	gchar* _error_ = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	RygelBasicManagementTestTracerouteProcessState _tmp3_ = 0;
	GError * _inner_error_ = NULL;
#line 241 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	self = (RygelBasicManagementTestTraceroute*) base;
#line 241 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_return_if_fail (line != NULL);
#line 242 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_error_ = NULL;
#line 244 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp0_ = line;
#line 244 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp1_ = string_strip (_tmp0_);
#line 244 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp2_ = _tmp1_;
#line 244 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_g_free0 (_tmp2_);
#line 245 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp3_ = self->priv->state;
#line 245 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	switch (_tmp3_) {
#line 245 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_INIT:
#line 1037 "rygel-basic-management-test-traceroute.c"
		{
			const gchar* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
#line 247 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp4_ = line;
#line 247 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp5_ = string_contains (_tmp4_, "traceroute to ");
#line 247 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			if (_tmp5_) {
#line 1047 "rygel-basic-management-test-traceroute.c"
				gint start = 0;
				const gchar* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint end = 0;
				const gchar* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
#line 248 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				self->priv->state = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_HOPS;
#line 249 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp6_ = line;
#line 249 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp7_ = string_index_of_char (_tmp6_, (gunichar) '(', 0);
#line 249 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				start = _tmp7_;
#line 250 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp8_ = line;
#line 250 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp9_ = start;
#line 250 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp10_ = string_index_of_char (_tmp8_, (gunichar) ')', _tmp9_);
#line 250 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				end = _tmp10_;
#line 251 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp11_ = end;
#line 251 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp12_ = start;
#line 251 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				if (_tmp11_ > _tmp12_) {
#line 1079 "rygel-basic-management-test-traceroute.c"
					const gchar* _tmp13_ = NULL;
					gint _tmp14_ = 0;
					gint _tmp15_ = 0;
					gchar* _tmp16_ = NULL;
#line 252 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					_tmp13_ = line;
#line 252 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					_tmp14_ = start;
#line 252 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					_tmp15_ = end;
#line 252 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					_tmp16_ = string_slice (_tmp13_, (glong) (_tmp14_ + 1), (glong) _tmp15_);
#line 252 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					_g_free0 (self->priv->host_ip);
#line 252 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					self->priv->host_ip = _tmp16_;
#line 1096 "rygel-basic-management-test-traceroute.c"
				}
			} else {
				const gchar* _tmp17_ = NULL;
#line 255 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp17_ = line;
#line 255 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				g_debug ("rygel-basic-management-test-traceroute.vala:255: traceroute parser: Un" \
"expected line '%s'", _tmp17_);
#line 1104 "rygel-basic-management-test-traceroute.c"
			}
#line 257 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			break;
#line 1108 "rygel-basic-management-test-traceroute.c"
		}
#line 245 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_HOPS:
#line 1112 "rygel-basic-management-test-traceroute.c"
		{
			const gchar* _tmp18_ = NULL;
			gboolean _tmp19_ = FALSE;
			const gchar* _tmp36_ = NULL;
			GMatchInfo* info = NULL;
			GRegex* _tmp38_ = NULL;
			const gchar* _tmp39_ = NULL;
			GMatchInfo* _tmp40_ = NULL;
			gboolean _tmp41_ = FALSE;
			gchar* ip_address = NULL;
			GMatchInfo* _tmp43_ = NULL;
			gchar* _tmp44_ = NULL;
			gboolean _tmp45_ = FALSE;
			const gchar* _tmp48_ = NULL;
			gchar* rtt_string = NULL;
			GMatchInfo* _tmp50_ = NULL;
			gchar* _tmp51_ = NULL;
			GRegex* _tmp52_ = NULL;
			const gchar* _tmp53_ = NULL;
			GMatchInfo* _tmp54_ = NULL;
			gint rtt_count = 0;
			gdouble rtt_average = 0.0;
			gint _tmp67_ = 0;
			gdouble _tmp70_ = 0.0;
			gdouble _tmp71_ = 0.0;
			const gchar* _tmp72_ = NULL;
			gint _tmp73_ = 0;
			gint _tmp74_ = 0;
			const gchar* _tmp77_ = NULL;
			const gchar* _tmp78_ = NULL;
			gchar* _tmp79_ = NULL;
#line 259 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp18_ = line;
#line 259 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp19_ = string_contains (_tmp18_, " !H ");
#line 259 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			if (_tmp19_) {
#line 1150 "rygel-basic-management-test-traceroute.c"
				gchar* _tmp20_ = NULL;
#line 260 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp20_ = g_strdup ("Host is unreachable.");
#line 260 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_g_free0 (_error_);
#line 260 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_error_ = _tmp20_;
#line 1158 "rygel-basic-management-test-traceroute.c"
			} else {
				const gchar* _tmp21_ = NULL;
				gboolean _tmp22_ = FALSE;
#line 261 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp21_ = line;
#line 261 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp22_ = string_contains (_tmp21_, " !N ");
#line 261 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				if (_tmp22_) {
#line 1168 "rygel-basic-management-test-traceroute.c"
					gchar* _tmp23_ = NULL;
#line 262 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					_tmp23_ = g_strdup ("Network is unreachable.");
#line 262 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					_g_free0 (_error_);
#line 262 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					_error_ = _tmp23_;
#line 1176 "rygel-basic-management-test-traceroute.c"
				} else {
					const gchar* _tmp24_ = NULL;
					gboolean _tmp25_ = FALSE;
#line 263 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					_tmp24_ = line;
#line 263 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					_tmp25_ = string_contains (_tmp24_, " !P ");
#line 263 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					if (_tmp25_) {
#line 1186 "rygel-basic-management-test-traceroute.c"
						gchar* _tmp26_ = NULL;
#line 264 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
						_tmp26_ = g_strdup ("Protocol is unreachable.");
#line 264 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
						_g_free0 (_error_);
#line 264 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
						_error_ = _tmp26_;
#line 1194 "rygel-basic-management-test-traceroute.c"
					} else {
						const gchar* _tmp27_ = NULL;
						gboolean _tmp28_ = FALSE;
#line 265 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
						_tmp27_ = line;
#line 265 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
						_tmp28_ = string_contains (_tmp27_, " !S ");
#line 265 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
						if (_tmp28_) {
#line 1204 "rygel-basic-management-test-traceroute.c"
							gchar* _tmp29_ = NULL;
#line 266 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
							_tmp29_ = g_strdup ("Source route failed.");
#line 266 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
							_g_free0 (_error_);
#line 266 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
							_error_ = _tmp29_;
#line 1212 "rygel-basic-management-test-traceroute.c"
						} else {
							const gchar* _tmp30_ = NULL;
							gboolean _tmp31_ = FALSE;
#line 267 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
							_tmp30_ = line;
#line 267 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
							_tmp31_ = string_contains (_tmp30_, " !F ");
#line 267 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
							if (_tmp31_) {
#line 1222 "rygel-basic-management-test-traceroute.c"
								gchar* _tmp32_ = NULL;
#line 268 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
								_tmp32_ = g_strdup ("Fragmentation needed.");
#line 268 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
								_g_free0 (_error_);
#line 268 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
								_error_ = _tmp32_;
#line 1230 "rygel-basic-management-test-traceroute.c"
							} else {
								const gchar* _tmp33_ = NULL;
								gboolean _tmp34_ = FALSE;
#line 269 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
								_tmp33_ = line;
#line 269 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
								_tmp34_ = string_contains (_tmp33_, " !X ");
#line 269 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
								if (_tmp34_) {
#line 1240 "rygel-basic-management-test-traceroute.c"
									gchar* _tmp35_ = NULL;
#line 270 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
									_tmp35_ = g_strdup ("Network blocks traceroute.");
#line 270 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
									_g_free0 (_error_);
#line 270 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
									_error_ = _tmp35_;
#line 1248 "rygel-basic-management-test-traceroute.c"
								}
							}
						}
					}
				}
			}
#line 273 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp36_ = _error_;
#line 273 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			if (_tmp36_ != NULL) {
#line 1259 "rygel-basic-management-test-traceroute.c"
				const gchar* _tmp37_ = NULL;
#line 274 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp37_ = _error_;
#line 274 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				rygel_basic_management_test_traceroute_set_error (self, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_OTHER, _tmp37_);
#line 276 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_g_free0 (_error_);
#line 276 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				return;
#line 1269 "rygel-basic-management-test-traceroute.c"
			}
#line 279 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp38_ = self->priv->regex;
#line 279 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp39_ = line;
#line 279 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp41_ = g_regex_match (_tmp38_, _tmp39_, 0, &_tmp40_);
#line 279 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_g_match_info_unref0 (info);
#line 279 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			info = _tmp40_;
#line 279 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			if (!_tmp41_) {
#line 1283 "rygel-basic-management-test-traceroute.c"
				const gchar* _tmp42_ = NULL;
#line 280 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp42_ = line;
#line 280 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				g_debug ("rygel-basic-management-test-traceroute.vala:280: traceroute parser: Un" \
"expected line '%s'", _tmp42_);
#line 282 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_g_match_info_unref0 (info);
#line 282 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_g_free0 (_error_);
#line 282 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				return;
#line 1295 "rygel-basic-management-test-traceroute.c"
			}
#line 285 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp43_ = info;
#line 285 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp44_ = g_match_info_fetch (_tmp43_, 2);
#line 285 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			ip_address = _tmp44_;
#line 286 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp45_ = self->priv->error_set;
#line 286 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			if (!_tmp45_) {
#line 1307 "rygel-basic-management-test-traceroute.c"
				const gchar* _tmp46_ = NULL;
				const gchar* _tmp47_ = NULL;
#line 287 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp46_ = ip_address;
#line 287 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp47_ = self->priv->host_ip;
#line 287 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				if (g_strcmp0 (_tmp46_, _tmp47_) == 0) {
#line 288 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_SUCCESS;
#line 1318 "rygel-basic-management-test-traceroute.c"
				} else {
#line 292 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_MAX_HOP_COUNT_EXCEEDED;
#line 1322 "rygel-basic-management-test-traceroute.c"
				}
			}
#line 296 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp48_ = ip_address;
#line 296 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			if (g_strcmp0 (_tmp48_, "*") == 0) {
#line 1329 "rygel-basic-management-test-traceroute.c"
				gchar* _tmp49_ = NULL;
#line 297 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp49_ = g_strdup ("");
#line 297 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_g_free0 (ip_address);
#line 297 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				ip_address = _tmp49_;
#line 1337 "rygel-basic-management-test-traceroute.c"
			}
#line 300 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp50_ = info;
#line 300 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp51_ = g_match_info_fetch (_tmp50_, 3);
#line 300 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			rtt_string = _tmp51_;
#line 301 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp52_ = self->priv->rtt_regex;
#line 301 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp53_ = rtt_string;
#line 301 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			g_regex_match (_tmp52_, _tmp53_, 0, &_tmp54_);
#line 301 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_g_match_info_unref0 (info);
#line 301 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			info = _tmp54_;
#line 302 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			rtt_count = 0;
#line 303 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			rtt_average = 0.0;
#line 1359 "rygel-basic-management-test-traceroute.c"
			{
#line 305 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				while (TRUE) {
#line 1363 "rygel-basic-management-test-traceroute.c"
					GMatchInfo* _tmp55_ = NULL;
					gboolean _tmp56_ = FALSE;
					gint _tmp57_ = 0;
					gdouble _tmp58_ = 0.0;
					GMatchInfo* _tmp59_ = NULL;
					gchar* _tmp60_ = NULL;
					gchar* _tmp61_ = NULL;
					gdouble _tmp62_ = 0.0;
					GMatchInfo* _tmp63_ = NULL;
#line 305 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					_tmp55_ = info;
#line 305 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					_tmp56_ = g_match_info_matches (_tmp55_);
#line 305 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					if (!_tmp56_) {
#line 305 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
						break;
#line 1381 "rygel-basic-management-test-traceroute.c"
					}
#line 306 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					_tmp57_ = rtt_count;
#line 306 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					rtt_count = _tmp57_ + 1;
#line 307 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					_tmp58_ = rtt_average;
#line 307 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					_tmp59_ = info;
#line 307 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					_tmp60_ = g_match_info_fetch (_tmp59_, 1);
#line 307 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					_tmp61_ = _tmp60_;
#line 307 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					_tmp62_ = double_parse (_tmp61_);
#line 307 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					rtt_average = _tmp58_ + _tmp62_;
#line 307 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					_g_free0 (_tmp61_);
#line 308 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					_tmp63_ = info;
#line 308 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					g_match_info_next (_tmp63_, &_inner_error_);
#line 308 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 308 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
						if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1409 "rygel-basic-management-test-traceroute.c"
							goto __catch4_g_regex_error;
						}
#line 308 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
						_g_free0 (rtt_string);
#line 308 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
						_g_free0 (ip_address);
#line 308 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
						_g_match_info_unref0 (info);
#line 308 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
						_g_free0 (_error_);
#line 308 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 308 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
						g_clear_error (&_inner_error_);
#line 308 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
						return;
#line 1426 "rygel-basic-management-test-traceroute.c"
					}
				}
			}
			goto __finally4;
			__catch4_g_regex_error:
			{
				GError* e = NULL;
				const gchar* _tmp64_ = NULL;
				GError* _tmp65_ = NULL;
				const gchar* _tmp66_ = NULL;
#line 304 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				e = _inner_error_;
#line 304 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_inner_error_ = NULL;
#line 311 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp64_ = rtt_string;
#line 311 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp65_ = e;
#line 311 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp66_ = _tmp65_->message;
#line 311 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				g_debug ("rygel-basic-management-test-traceroute.vala:311: Failed to parse round" \
" trip time values '%s': %s", _tmp64_, _tmp66_);
#line 304 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_g_error_free0 (e);
#line 1451 "rygel-basic-management-test-traceroute.c"
			}
			__finally4:
#line 304 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 304 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_g_free0 (rtt_string);
#line 304 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_g_free0 (ip_address);
#line 304 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_g_match_info_unref0 (info);
#line 304 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_g_free0 (_error_);
#line 304 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 304 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				g_clear_error (&_inner_error_);
#line 304 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				return;
#line 1470 "rygel-basic-management-test-traceroute.c"
			}
#line 316 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp67_ = rtt_count;
#line 316 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			if (_tmp67_ > 0) {
#line 1476 "rygel-basic-management-test-traceroute.c"
				gdouble _tmp68_ = 0.0;
				gint _tmp69_ = 0;
#line 317 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp68_ = rtt_average;
#line 317 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp69_ = rtt_count;
#line 317 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				rtt_average = _tmp68_ / _tmp69_;
#line 1485 "rygel-basic-management-test-traceroute.c"
			}
#line 320 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp70_ = rtt_average;
#line 320 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp71_ = round (_tmp70_);
#line 320 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			self->priv->response_time = (guint32) ((guint) _tmp71_);
#line 321 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp72_ = self->priv->hop_ips;
#line 321 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp73_ = strlen (_tmp72_);
#line 321 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp74_ = _tmp73_;
#line 321 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			if (_tmp74_ != 0) {
#line 1501 "rygel-basic-management-test-traceroute.c"
				const gchar* _tmp75_ = NULL;
				gchar* _tmp76_ = NULL;
#line 322 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp75_ = self->priv->hop_ips;
#line 322 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_tmp76_ = g_strconcat (_tmp75_, ",", NULL);
#line 322 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				_g_free0 (self->priv->hop_ips);
#line 322 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
				self->priv->hop_ips = _tmp76_;
#line 1512 "rygel-basic-management-test-traceroute.c"
			}
#line 324 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp77_ = self->priv->hop_ips;
#line 324 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp78_ = ip_address;
#line 324 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_tmp79_ = g_strconcat (_tmp77_, _tmp78_, NULL);
#line 324 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_g_free0 (self->priv->hop_ips);
#line 324 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			self->priv->hop_ips = _tmp79_;
#line 326 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_g_free0 (rtt_string);
#line 326 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_g_free0 (ip_address);
#line 326 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			_g_match_info_unref0 (info);
#line 326 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			break;
#line 1532 "rygel-basic-management-test-traceroute.c"
		}
		default:
		{
#line 328 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
			g_assert_not_reached ();
#line 1538 "rygel-basic-management-test-traceroute.c"
		}
	}
#line 241 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_g_free0 (_error_);
#line 1543 "rygel-basic-management-test-traceroute.c"
}


void rygel_basic_management_test_traceroute_get_results (RygelBasicManagementTestTraceroute* self, gchar** status, gchar** additional_info, guint32* response_time, gchar** hop_ips) {
	gchar* _vala_status = NULL;
	gchar* _vala_additional_info = NULL;
	guint32 _vala_response_time = 0U;
	gchar* _vala_hop_ips = NULL;
	RygelBasicManagementTestTracerouteStatus _tmp0_ = 0;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	guint32 _tmp4_ = 0U;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
#line 331 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_return_if_fail (self != NULL);
#line 335 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp0_ = self->priv->status;
#line 335 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp1_ = rygel_basic_management_test_traceroute_status_to_string (_tmp0_);
#line 335 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_g_free0 (_vala_status);
#line 335 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_vala_status = _tmp1_;
#line 336 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp2_ = self->priv->additional_info;
#line 336 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 336 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_g_free0 (_vala_additional_info);
#line 336 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_vala_additional_info = _tmp3_;
#line 337 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp4_ = self->priv->response_time;
#line 337 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_vala_response_time = _tmp4_;
#line 338 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp5_ = self->priv->hop_ips;
#line 338 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 338 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_g_free0 (_vala_hop_ips);
#line 338 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_vala_hop_ips = _tmp6_;
#line 331 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	if (status) {
#line 331 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		*status = _vala_status;
#line 1593 "rygel-basic-management-test-traceroute.c"
	} else {
#line 331 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_g_free0 (_vala_status);
#line 1597 "rygel-basic-management-test-traceroute.c"
	}
#line 331 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	if (additional_info) {
#line 331 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		*additional_info = _vala_additional_info;
#line 1603 "rygel-basic-management-test-traceroute.c"
	} else {
#line 331 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_g_free0 (_vala_additional_info);
#line 1607 "rygel-basic-management-test-traceroute.c"
	}
#line 331 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	if (response_time) {
#line 331 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		*response_time = _vala_response_time;
#line 1613 "rygel-basic-management-test-traceroute.c"
	}
#line 331 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	if (hop_ips) {
#line 331 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		*hop_ips = _vala_hop_ips;
#line 1619 "rygel-basic-management-test-traceroute.c"
	} else {
#line 331 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		_g_free0 (_vala_hop_ips);
#line 1623 "rygel-basic-management-test-traceroute.c"
	}
}


const gchar* rygel_basic_management_test_traceroute_get_host (RygelBasicManagementTestTraceroute* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 71 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 71 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp0_ = self->priv->_host;
#line 71 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	result = _tmp0_;
#line 71 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	return result;
#line 1639 "rygel-basic-management-test-traceroute.c"
}


static void rygel_basic_management_test_traceroute_set_host (RygelBasicManagementTestTraceroute* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 71 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_return_if_fail (self != NULL);
#line 71 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp0_ = value;
#line 71 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 71 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_g_free0 (self->priv->_host);
#line 71 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	self->priv->_host = _tmp1_;
#line 71 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_object_notify ((GObject *) self, "host");
#line 1658 "rygel-basic-management-test-traceroute.c"
}


guint32 rygel_basic_management_test_traceroute_get_wait_time_out (RygelBasicManagementTestTraceroute* self) {
	guint32 result;
	guint32 _tmp0_ = 0U;
#line 82 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp0_ = self->priv->_wait_time_out;
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	result = _tmp0_;
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	return result;
#line 1673 "rygel-basic-management-test-traceroute.c"
}


static void rygel_basic_management_test_traceroute_set_wait_time_out (RygelBasicManagementTestTraceroute* self, guint32 value) {
	guint32 _tmp0_ = 0U;
	guint32 _tmp1_ = 0U;
#line 75 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_return_if_fail (self != NULL);
#line 76 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp0_ = value;
#line 76 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	self->priv->_wait_time_out = _tmp0_;
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp1_ = self->priv->_wait_time_out;
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	if (_tmp1_ == ((guint32) 0)) {
#line 78 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		self->priv->_wait_time_out = (guint32) RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_TIMEOUT;
#line 1692 "rygel-basic-management-test-traceroute.c"
	}
#line 75 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_object_notify ((GObject *) self, "wait-time-out");
#line 1696 "rygel-basic-management-test-traceroute.c"
}


guint rygel_basic_management_test_traceroute_get_data_block_size (RygelBasicManagementTestTraceroute* self) {
	guint result;
	guint _tmp0_ = 0U;
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp0_ = self->priv->_data_block_size;
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	result = _tmp0_;
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	return result;
#line 1711 "rygel-basic-management-test-traceroute.c"
}


static void rygel_basic_management_test_traceroute_set_data_block_size (RygelBasicManagementTestTraceroute* self, guint value) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
#line 91 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_return_if_fail (self != NULL);
#line 92 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp0_ = value;
#line 92 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	self->priv->_data_block_size = _tmp0_;
#line 93 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp1_ = self->priv->_data_block_size;
#line 93 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	if (_tmp1_ == ((guint) 0)) {
#line 94 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		self->priv->_data_block_size = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_DATA_BLOCK_SIZE;
#line 1730 "rygel-basic-management-test-traceroute.c"
	}
#line 91 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_object_notify ((GObject *) self, "data-block-size");
#line 1734 "rygel-basic-management-test-traceroute.c"
}


guint rygel_basic_management_test_traceroute_get_max_hop_count (RygelBasicManagementTestTraceroute* self) {
	guint result;
	guint _tmp0_ = 0U;
#line 114 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 115 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp0_ = self->priv->_max_hop_count;
#line 115 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	result = _tmp0_;
#line 115 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	return result;
#line 1749 "rygel-basic-management-test-traceroute.c"
}


static void rygel_basic_management_test_traceroute_set_max_hop_count (RygelBasicManagementTestTraceroute* self, guint value) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
#line 107 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_return_if_fail (self != NULL);
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp0_ = value;
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	self->priv->_max_hop_count = _tmp0_;
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp1_ = self->priv->_max_hop_count;
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	if (_tmp1_ == ((guint) 0)) {
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		self->priv->_max_hop_count = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_HOPS;
#line 1768 "rygel-basic-management-test-traceroute.c"
	}
#line 107 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_object_notify ((GObject *) self, "max-hop-count");
#line 1772 "rygel-basic-management-test-traceroute.c"
}


guint rygel_basic_management_test_traceroute_get_dscp (RygelBasicManagementTestTraceroute* self) {
	guint result;
	guint _tmp0_ = 0U;
#line 130 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 131 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp0_ = self->priv->_dscp;
#line 131 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	result = _tmp0_;
#line 131 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	return result;
#line 1787 "rygel-basic-management-test-traceroute.c"
}


static void rygel_basic_management_test_traceroute_set_dscp (RygelBasicManagementTestTraceroute* self, guint value) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
#line 123 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_return_if_fail (self != NULL);
#line 124 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp0_ = value;
#line 124 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	self->priv->_dscp = _tmp0_;
#line 125 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp1_ = self->priv->_dscp;
#line 125 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	if (_tmp1_ == ((guint) 0)) {
#line 126 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		self->priv->_dscp = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_DSCP;
#line 1806 "rygel-basic-management-test-traceroute.c"
	}
#line 123 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_object_notify ((GObject *) self, "dscp");
#line 1810 "rygel-basic-management-test-traceroute.c"
}


static const gchar* rygel_basic_management_test_traceroute_real_get_method_type (RygelBasicManagementTest* base) {
	const gchar* result;
	RygelBasicManagementTestTraceroute* self;
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	self = (RygelBasicManagementTestTraceroute*) base;
#line 149 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	result = "Traceroute";
#line 149 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	return result;
#line 1823 "rygel-basic-management-test-traceroute.c"
}


static const gchar* rygel_basic_management_test_traceroute_real_get_results_type (RygelBasicManagementTest* base) {
	const gchar* result;
	RygelBasicManagementTestTraceroute* self;
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	self = (RygelBasicManagementTestTraceroute*) base;
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	result = "GetTracerouteResult";
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	return result;
#line 1836 "rygel-basic-management-test-traceroute.c"
}


static void rygel_basic_management_test_traceroute_class_init (RygelBasicManagementTestTracerouteClass * klass) {
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	rygel_basic_management_test_traceroute_parent_class = g_type_class_peek_parent (klass);
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_type_class_add_private (klass, sizeof (RygelBasicManagementTestTraceroutePrivate));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	((GObjectClass *) klass)->constructed = rygel_basic_management_test_traceroute_real_constructed;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	((RygelBasicManagementTestClass *) klass)->handle_error = rygel_basic_management_test_traceroute_real_handle_error;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	((RygelBasicManagementTestClass *) klass)->handle_output = rygel_basic_management_test_traceroute_real_handle_output;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	RYGEL_BASIC_MANAGEMENT_TEST_CLASS (klass)->get_method_type = rygel_basic_management_test_traceroute_real_get_method_type;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	RYGEL_BASIC_MANAGEMENT_TEST_CLASS (klass)->get_results_type = rygel_basic_management_test_traceroute_real_get_results_type;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_basic_management_test_traceroute_get_property;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_basic_management_test_traceroute_set_property;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_basic_management_test_traceroute_finalize;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_HOST, g_param_spec_string ("host", "host", "host", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_WAIT_TIME_OUT, g_param_spec_uint ("wait-time-out", "wait-time-out", "wait-time-out", 0, G_MAXUINT, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_TIMEOUT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DATA_BLOCK_SIZE, g_param_spec_uint ("data-block-size", "data-block-size", "data-block-size", 0, G_MAXUINT, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_DATA_BLOCK_SIZE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_HOP_COUNT, g_param_spec_uint ("max-hop-count", "max-hop-count", "max-hop-count", 0, G_MAXUINT, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_HOPS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DSCP, g_param_spec_uint ("dscp", "dscp", "dscp", 0, G_MAXUINT, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_DSCP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_METHOD_TYPE, g_param_spec_string ("method-type", "method-type", "method-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_RESULTS_TYPE, g_param_spec_string ("results-type", "results-type", "results-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1875 "rygel-basic-management-test-traceroute.c"
}


static void rygel_basic_management_test_traceroute_instance_init (RygelBasicManagementTestTraceroute * self) {
	gchar* _tmp0_ = NULL;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	self->priv = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_GET_PRIVATE (self);
#line 71 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_tmp0_ = g_strdup ("");
#line 71 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	self->priv->_host = _tmp0_;
#line 1887 "rygel-basic-management-test-traceroute.c"
}


static void rygel_basic_management_test_traceroute_finalize (GObject* obj) {
	RygelBasicManagementTestTraceroute * self;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTraceroute);
#line 71 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_g_free0 (self->priv->_host);
#line 137 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_g_regex_unref0 (self->priv->regex);
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_g_regex_unref0 (self->priv->rtt_regex);
#line 142 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_g_free0 (self->priv->host_ip);
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_g_free0 (self->priv->additional_info);
#line 145 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	_g_free0 (self->priv->hop_ips);
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	G_OBJECT_CLASS (rygel_basic_management_test_traceroute_parent_class)->finalize (obj);
#line 1909 "rygel-basic-management-test-traceroute.c"
}


GType rygel_basic_management_test_traceroute_get_type (void) {
	static volatile gsize rygel_basic_management_test_traceroute_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_traceroute_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelBasicManagementTestTracerouteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_basic_management_test_traceroute_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelBasicManagementTestTraceroute), 0, (GInstanceInitFunc) rygel_basic_management_test_traceroute_instance_init, NULL };
		GType rygel_basic_management_test_traceroute_type_id;
		rygel_basic_management_test_traceroute_type_id = g_type_register_static (RYGEL_TYPE_BASIC_MANAGEMENT_TEST, "RygelBasicManagementTestTraceroute", &g_define_type_info, 0);
		g_once_init_leave (&rygel_basic_management_test_traceroute_type_id__volatile, rygel_basic_management_test_traceroute_type_id);
	}
	return rygel_basic_management_test_traceroute_type_id__volatile;
}


static void _vala_rygel_basic_management_test_traceroute_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelBasicManagementTestTraceroute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTraceroute);
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	switch (property_id) {
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_HOST:
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		g_value_set_string (value, rygel_basic_management_test_traceroute_get_host (self));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		break;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_WAIT_TIME_OUT:
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		g_value_set_uint (value, rygel_basic_management_test_traceroute_get_wait_time_out (self));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		break;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DATA_BLOCK_SIZE:
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		g_value_set_uint (value, rygel_basic_management_test_traceroute_get_data_block_size (self));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		break;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_HOP_COUNT:
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		g_value_set_uint (value, rygel_basic_management_test_traceroute_get_max_hop_count (self));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		break;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DSCP:
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		g_value_set_uint (value, rygel_basic_management_test_traceroute_get_dscp (self));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		break;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_METHOD_TYPE:
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		g_value_set_string (value, rygel_basic_management_test_get_method_type ((RygelBasicManagementTest*) self));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		break;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_RESULTS_TYPE:
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		g_value_set_string (value, rygel_basic_management_test_get_results_type ((RygelBasicManagementTest*) self));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		break;
#line 1972 "rygel-basic-management-test-traceroute.c"
		default:
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		break;
#line 1978 "rygel-basic-management-test-traceroute.c"
	}
}


static void _vala_rygel_basic_management_test_traceroute_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelBasicManagementTestTraceroute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTraceroute);
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
	switch (property_id) {
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_HOST:
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		rygel_basic_management_test_traceroute_set_host (self, g_value_get_string (value));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		break;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_WAIT_TIME_OUT:
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		rygel_basic_management_test_traceroute_set_wait_time_out (self, g_value_get_uint (value));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		break;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DATA_BLOCK_SIZE:
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		rygel_basic_management_test_traceroute_set_data_block_size (self, g_value_get_uint (value));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		break;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_HOP_COUNT:
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		rygel_basic_management_test_traceroute_set_max_hop_count (self, g_value_get_uint (value));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		break;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DSCP:
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		rygel_basic_management_test_traceroute_set_dscp (self, g_value_get_uint (value));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		break;
#line 2018 "rygel-basic-management-test-traceroute.c"
		default:
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-traceroute.vala"
		break;
#line 2024 "rygel-basic-management-test-traceroute.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



