/* rygel-root-device-factory.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-root-device-factory.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2007 OpenedHand Ltd.
 * Copyright (C) 2012 Openismus GmbH.
 *
 * Authors: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                                <zeeshan.ali@nokia.com>
 *          Jorn Baayen <jorn@openedhand.com>
 *          Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gio/gio.h>
#include <libgupnp/gupnp.h>
#include <gee.h>
#include <config.h>
#include <uuid/uuid.h>
#include <libgssdp/gssdp.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_ROOT_DEVICE_FACTORY (rygel_root_device_factory_get_type ())
#define RYGEL_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory))
#define RYGEL_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))
#define RYGEL_IS_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_IS_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_ROOT_DEVICE_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))

typedef struct _RygelRootDeviceFactory RygelRootDeviceFactory;
typedef struct _RygelRootDeviceFactoryClass RygelRootDeviceFactoryClass;
typedef struct _RygelRootDeviceFactoryPrivate RygelRootDeviceFactoryPrivate;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;

#define RYGEL_TYPE_DESCRIPTION_FILE (rygel_description_file_get_type ())
#define RYGEL_DESCRIPTION_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFile))
#define RYGEL_DESCRIPTION_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFileClass))
#define RYGEL_IS_DESCRIPTION_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DESCRIPTION_FILE))
#define RYGEL_IS_DESCRIPTION_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DESCRIPTION_FILE))
#define RYGEL_DESCRIPTION_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFileClass))

typedef struct _RygelDescriptionFile RygelDescriptionFile;
typedef struct _RygelDescriptionFileClass RygelDescriptionFileClass;

#define RYGEL_TYPE_PLUGIN_CAPABILITIES (rygel_plugin_capabilities_get_type ())
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define RYGEL_TYPE_RESOURCE_INFO (rygel_resource_info_get_type ())
#define RYGEL_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfo))
#define RYGEL_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))
#define RYGEL_IS_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_IS_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_RESOURCE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))

typedef struct _RygelResourceInfo RygelResourceInfo;
typedef struct _RygelResourceInfoClass RygelResourceInfoClass;
typedef struct _RygelResourceInfoPrivate RygelResourceInfoPrivate;
#define _rygel_resource_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_resource_info_unref (var), NULL)))

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))

typedef enum  {
	ROOT_DEVICE_FACTORY_ERROR_XML_PARSE
} RootDeviceFactoryError;
#define ROOT_DEVICE_FACTORY_ERROR root_device_factory_error_quark ()
struct _RygelRootDeviceFactory {
	GObject parent_instance;
	RygelRootDeviceFactoryPrivate * priv;
};

struct _RygelRootDeviceFactoryClass {
	GObjectClass parent_class;
};

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gchar** (*get_interfaces) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_engine_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_media_engine) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelRootDeviceFactoryPrivate {
	GUPnPContext* _context;
	RygelConfiguration* config;
	gchar* desc_dir;
};

typedef enum  {
	RYGEL_PLUGIN_CAPABILITIES_NONE = 0,
	RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD = 1 << 0,
	RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD = 1 << 1,
	RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD = 1 << 2,
	RYGEL_PLUGIN_CAPABILITIES_UPLOAD = (RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD | RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD) | RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD,
	RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES = 1 << 3,
	RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS = 1 << 4,
	RYGEL_PLUGIN_CAPABILITIES_DIAGNOSTICS = 1 << 5,
	RYGEL_PLUGIN_CAPABILITIES_ENERGY_MANAGEMENT = 1 << 6
} RygelPluginCapabilities;

struct _RygelResourceInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelResourceInfoPrivate * priv;
	gchar* upnp_type;
	gchar* upnp_id;
	gchar* description_path;
	GType type;
};

struct _RygelResourceInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelResourceInfo *self);
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	gchar* mime_type;
	gchar* uri;
	gchar* file_extension;
	gint64 size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};


extern gchar* rygel_pretty_host_name;
gchar* rygel_pretty_host_name = NULL;
static gpointer rygel_root_device_factory_parent_class = NULL;
static GInitableIface* rygel_root_device_factory_g_initable_parent_iface = NULL;

GQuark root_device_factory_error_quark (void);
gchar* rygel_get_pretty_host_name (void);
GType rygel_root_device_factory_get_type (void) G_GNUC_CONST;
GType rygel_configuration_get_type (void) G_GNUC_CONST;
#define RYGEL_ROOT_DEVICE_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryPrivate))
enum  {
	RYGEL_ROOT_DEVICE_FACTORY_DUMMY_PROPERTY,
	RYGEL_ROOT_DEVICE_FACTORY_CONTEXT
};
RygelRootDeviceFactory* rygel_root_device_factory_new (GUPnPContext* context, GError** error);
RygelRootDeviceFactory* rygel_root_device_factory_construct (GType object_type, GUPnPContext* context, GError** error);
static gboolean rygel_root_device_factory_real_init (GInitable* base, GCancellable* cancellable, GError** error);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
static void rygel_root_device_factory_ensure_dir_exists (RygelRootDeviceFactory* self, const gchar* dir_path, GError** error);
GType rygel_plugin_get_type (void) G_GNUC_CONST;
GType rygel_root_device_get_type (void) G_GNUC_CONST;
RygelRootDevice* rygel_root_device_factory_create (RygelRootDeviceFactory* self, RygelPlugin* plugin, GError** error);
const gchar* rygel_plugin_get_name (RygelPlugin* self);
const gchar* rygel_plugin_get_desc_path (RygelPlugin* self);
static GUPnPXMLDoc* rygel_root_device_factory_create_desc (RygelRootDeviceFactory* self, RygelPlugin* plugin, const gchar* desc_path, const gchar* template_path, GError** error);
GUPnPContext* rygel_root_device_factory_get_context (RygelRootDeviceFactory* self);
RygelRootDevice* rygel_root_device_new (GUPnPContext* context, RygelPlugin* plugin, GUPnPXMLDoc* description_doc, const gchar* description_path, const gchar* description_dir);
RygelRootDevice* rygel_root_device_construct (GType object_type, GUPnPContext* context, RygelPlugin* plugin, GUPnPXMLDoc* description_doc, const gchar* description_path, const gchar* description_dir);
void rygel_plugin_apply_hacks (RygelPlugin* self, RygelRootDevice* device, const gchar* description_path, GError** error);
static GUPnPXMLDoc* rygel_root_device_factory_get_latest_doc (RygelRootDeviceFactory* self, const gchar* path1, const gchar* path2, GError** error);
GType rygel_description_file_get_type (void) G_GNUC_CONST;
RygelDescriptionFile* rygel_description_file_new_from_xml_document (GUPnPXMLDoc* doc);
RygelDescriptionFile* rygel_description_file_construct_from_xml_document (GType object_type, GUPnPXMLDoc* doc);
static void rygel_root_device_factory_add_services_to_desc (RygelRootDeviceFactory* self, RygelDescriptionFile* file, RygelPlugin* plugin);
static void rygel_root_device_factory_add_icons_to_desc (RygelRootDeviceFactory* self, RygelDescriptionFile* file, RygelPlugin* plugin);
void rygel_description_file_set_friendly_name (RygelDescriptionFile* self, const gchar* friendly_name);
static gchar* rygel_root_device_factory_get_friendly_name (RygelRootDeviceFactory* self, RygelPlugin* plugin);
GType rygel_plugin_capabilities_get_type (void) G_GNUC_CONST;
void rygel_description_file_set_dlna_caps (RygelDescriptionFile* self, RygelPluginCapabilities capabilities);
RygelPluginCapabilities rygel_plugin_get_capabilities (RygelPlugin* self);
const gchar* rygel_plugin_get_description (RygelPlugin* self);
void rygel_description_file_set_model_description (RygelDescriptionFile* self, const gchar* model_description);
gchar* rygel_description_file_get_udn (RygelDescriptionFile* self);
void rygel_description_file_set_udn (RygelDescriptionFile* self, const gchar* udn);
void rygel_description_file_save (RygelDescriptionFile* self, const gchar* path, GError** error);
gchar* rygel_configuration_get_title (RygelConfiguration* self, const gchar* section, GError** error);
const gchar* rygel_plugin_get_title (RygelPlugin* self);
void rygel_description_file_clear_service_list (RygelDescriptionFile* self);
gpointer rygel_resource_info_ref (gpointer instance);
void rygel_resource_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_resource_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_resource_info (GValue* value, gpointer v_object);
void rygel_value_take_resource_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_resource_info (const GValue* value);
GType rygel_resource_info_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_plugin_get_resource_infos (RygelPlugin* self);
void rygel_description_file_add_service (RygelDescriptionFile* self, const gchar* device_name, RygelResourceInfo* resource_info);
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_plugin_get_icon_infos (RygelPlugin* self);
GeeArrayList* rygel_plugin_get_default_icons (RygelPlugin* self);
void rygel_description_file_clear_icon_list (RygelDescriptionFile* self);
static gchar* rygel_root_device_factory_get_icon_remote_path (RygelRootDeviceFactory* self, RygelIconInfo* icon_info, RygelPlugin* plugin);
void rygel_description_file_add_icon (RygelDescriptionFile* self, const gchar* device_name, RygelIconInfo* icon_info, const gchar* url);
static void rygel_root_device_factory_set_context (RygelRootDeviceFactory* self, GUPnPContext* value);
static void rygel_root_device_factory_finalize (GObject* obj);
static void _vala_rygel_root_device_factory_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_root_device_factory_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark root_device_factory_error_quark (void) {
	return g_quark_from_static_string ("root_device_factory_error-quark");
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
#line 964 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = separator;
#line 964 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp0_ == NULL) {
#line 965 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		separator = "";
#line 322 "rygel-root-device-factory.c"
	}
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = str_array;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3__length1 = str_array_length1;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = TRUE;
#line 332 "rygel-root-device-factory.c"
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = str_array;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4__length1 = str_array_length1;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp4__length1 > 0;
#line 342 "rygel-root-device-factory.c"
	}
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp2_) {
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 348 "rygel-root-device-factory.c"
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = str_array;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6__length1 = str_array_length1;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (_tmp6__length1 == (-1)) {
#line 359 "rygel-root-device-factory.c"
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			const gchar* _tmp8_ = NULL;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp7_ = str_array;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp7__length1 = str_array_length1;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp8_ = _tmp7_[0];
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp5_ = _tmp8_ != NULL;
#line 371 "rygel-root-device-factory.c"
		} else {
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp5_ = FALSE;
#line 375 "rygel-root-device-factory.c"
		}
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp1_ = _tmp5_;
#line 379 "rygel-root-device-factory.c"
	}
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp1_) {
#line 383 "rygel-root-device-factory.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gsize _tmp35_ = 0UL;
		const gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		const gchar* res = NULL;
		gsize _tmp40_ = 0UL;
		void* _tmp41_ = NULL;
		void* ptr = NULL;
		const gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		void* _tmp45_ = NULL;
		const gchar* _tmp62_ = NULL;
#line 969 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		len = (gsize) 1;
#line 406 "rygel-root-device-factory.c"
		{
			gboolean _tmp9_ = FALSE;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			i = 0;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp9_ = TRUE;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 415 "rygel-root-device-factory.c"
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp21_ = 0;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				const gchar* _tmp24_ = NULL;
				gsize _tmp30_ = 0UL;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (!_tmp9_) {
#line 428 "rygel-root-device-factory.c"
					gint _tmp10_ = 0;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp10_ = i;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					i = _tmp10_ + 1;
#line 434 "rygel-root-device-factory.c"
				}
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp9_ = FALSE;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp13_ = str_array;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp13__length1 = str_array_length1;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (_tmp13__length1 != (-1)) {
#line 444 "rygel-root-device-factory.c"
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp14_ = i;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp15_ = str_array;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp15__length1 = str_array_length1;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp12_ = _tmp14_ < _tmp15__length1;
#line 456 "rygel-root-device-factory.c"
				} else {
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp12_ = FALSE;
#line 460 "rygel-root-device-factory.c"
				}
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (_tmp12_) {
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp11_ = TRUE;
#line 466 "rygel-root-device-factory.c"
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp17_ = str_array;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp17__length1 = str_array_length1;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					if (_tmp17__length1 == (-1)) {
#line 477 "rygel-root-device-factory.c"
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						gint _tmp19_ = 0;
						const gchar* _tmp20_ = NULL;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp18_ = str_array;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp18__length1 = str_array_length1;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp19_ = i;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp20_ = _tmp18_[_tmp19_];
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp16_ = _tmp20_ != NULL;
#line 492 "rygel-root-device-factory.c"
					} else {
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp16_ = FALSE;
#line 496 "rygel-root-device-factory.c"
					}
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp11_ = _tmp16_;
#line 500 "rygel-root-device-factory.c"
				}
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (!_tmp11_) {
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					break;
#line 506 "rygel-root-device-factory.c"
				}
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp22_ = str_array;
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp22__length1 = str_array_length1;
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp23_ = i;
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp24_ = _tmp22_[_tmp23_];
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (_tmp24_ != NULL) {
#line 518 "rygel-root-device-factory.c"
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp25_ = str_array;
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp25__length1 = str_array_length1;
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp26_ = i;
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp27_ = _tmp25_[_tmp26_];
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp28_ = strlen ((const gchar*) _tmp27_);
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp29_ = _tmp28_;
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp21_ = _tmp29_;
#line 539 "rygel-root-device-factory.c"
				} else {
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp21_ = 0;
#line 543 "rygel-root-device-factory.c"
				}
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp30_ = len;
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				len = _tmp30_ + _tmp21_;
#line 549 "rygel-root-device-factory.c"
			}
		}
#line 973 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp31_ = i;
#line 973 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (_tmp31_ == 0) {
#line 556 "rygel-root-device-factory.c"
			gchar* _tmp32_ = NULL;
#line 974 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp32_ = g_strdup ("");
#line 974 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			result = _tmp32_;
#line 974 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return result;
#line 564 "rygel-root-device-factory.c"
		}
#line 976 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp33_ = i;
#line 976 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		str_array_length1 = _tmp33_;
#line 976 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp34_ = str_array_length1;
#line 977 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp35_ = len;
#line 977 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp36_ = separator;
#line 977 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp37_ = strlen ((const gchar*) _tmp36_);
#line 977 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp38_ = _tmp37_;
#line 977 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp39_ = i;
#line 977 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
#line 979 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp40_ = len;
#line 979 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp41_ = g_malloc (_tmp40_);
#line 979 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		res = _tmp41_;
#line 980 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp42_ = res;
#line 980 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp43_ = str_array;
#line 980 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp43__length1 = str_array_length1;
#line 980 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp44_ = _tmp43_[0];
#line 980 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
#line 980 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		ptr = _tmp45_;
#line 602 "rygel-root-device-factory.c"
		{
			gboolean _tmp46_ = FALSE;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			i = 1;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp46_ = TRUE;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 611 "rygel-root-device-factory.c"
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				void* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				void* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp55_ = 0;
				const gchar* _tmp56_ = NULL;
				void* _tmp60_ = NULL;
				void* _tmp61_ = NULL;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (!_tmp46_) {
#line 627 "rygel-root-device-factory.c"
					gint _tmp47_ = 0;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp47_ = i;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					i = _tmp47_ + 1;
#line 633 "rygel-root-device-factory.c"
				}
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp46_ = FALSE;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp48_ = i;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp49_ = str_array;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp49__length1 = str_array_length1;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (!(_tmp48_ < _tmp49__length1)) {
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					break;
#line 647 "rygel-root-device-factory.c"
				}
#line 982 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp50_ = ptr;
#line 982 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp51_ = separator;
#line 982 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
#line 982 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				ptr = _tmp52_;
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp54_ = str_array;
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp54__length1 = str_array_length1;
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp55_ = i;
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp56_ = _tmp54_[_tmp55_];
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (_tmp56_ != NULL) {
#line 667 "rygel-root-device-factory.c"
					gchar** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp58_ = 0;
					const gchar* _tmp59_ = NULL;
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp57_ = str_array;
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp57__length1 = str_array_length1;
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp58_ = i;
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp59_ = _tmp57_[_tmp58_];
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp53_ = (const gchar*) _tmp59_;
#line 682 "rygel-root-device-factory.c"
				} else {
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp53_ = "";
#line 686 "rygel-root-device-factory.c"
				}
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp60_ = ptr;
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				ptr = _tmp61_;
#line 694 "rygel-root-device-factory.c"
			}
		}
#line 986 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp62_ = res;
#line 986 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		res = NULL;
#line 986 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (gchar*) _tmp62_;
#line 986 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 705 "rygel-root-device-factory.c"
	} else {
		gchar* _tmp63_ = NULL;
#line 988 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp63_ = g_strdup ("");
#line 988 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp63_;
#line 988 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 714 "rygel-root-device-factory.c"
	}
}


gchar* rygel_get_pretty_host_name (void) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	GError * _inner_error_ = NULL;
#line 40 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp0_ = rygel_pretty_host_name;
#line 40 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (_tmp0_ == NULL) {
#line 729 "rygel-root-device-factory.c"
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		{
			gchar* machine_info = NULL;
			gchar* _tmp1_ = NULL;
			gchar** lines = NULL;
			const gchar* _tmp2_ = NULL;
			gchar** _tmp3_ = NULL;
			gchar** _tmp4_ = NULL;
			gint lines_length1 = 0;
			gint _lines_size_ = 0;
			gchar** _tmp5_ = NULL;
			gint _tmp5__length1 = 0;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			g_file_get_contents ("/etc/machine-info", &_tmp1_, NULL, &_inner_error_);
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_g_free0 (machine_info);
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			machine_info = _tmp1_;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				_g_free0 (machine_info);
#line 753 "rygel-root-device-factory.c"
				goto __catch12_g_error;
			}
#line 46 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp2_ = machine_info;
#line 46 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, "\n", 0);
#line 46 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			lines = _tmp4_;
#line 46 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			lines_length1 = _vala_array_length (_tmp3_);
#line 46 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_lines_size_ = lines_length1;
#line 48 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp5_ = lines;
#line 48 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp5__length1 = lines_length1;
#line 770 "rygel-root-device-factory.c"
			{
				gchar** line_collection = NULL;
				gint line_collection_length1 = 0;
				gint _line_collection_size_ = 0;
				gint line_it = 0;
#line 48 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				line_collection = _tmp5_;
#line 48 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				line_collection_length1 = _tmp5__length1;
#line 48 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				for (line_it = 0; line_it < _tmp5__length1; line_it = line_it + 1) {
#line 782 "rygel-root-device-factory.c"
					gchar* _tmp6_ = NULL;
					gchar* line = NULL;
#line 48 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
					_tmp6_ = g_strdup (line_collection[line_it]);
#line 48 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
					line = _tmp6_;
#line 789 "rygel-root-device-factory.c"
					{
						gchar** parts = NULL;
						const gchar* _tmp7_ = NULL;
						gchar** _tmp8_ = NULL;
						gchar** _tmp9_ = NULL;
						gint parts_length1 = 0;
						gint _parts_size_ = 0;
						gchar** _tmp10_ = NULL;
						gint _tmp10__length1 = 0;
						const gchar* _tmp11_ = NULL;
#line 49 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
						_tmp7_ = line;
#line 49 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
						_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, "=", 0);
#line 49 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
						parts = _tmp9_;
#line 49 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
						parts_length1 = _vala_array_length (_tmp8_);
#line 49 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
						_parts_size_ = parts_length1;
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
						_tmp10_ = parts;
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
						_tmp10__length1 = parts_length1;
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
						_tmp11_ = _tmp10_[0];
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
						if (g_strcmp0 (_tmp11_, "PRETTY_HOSTNAME") == 0) {
#line 818 "rygel-root-device-factory.c"
							gchar** _tmp12_ = NULL;
							gint _tmp12__length1 = 0;
							gchar** _tmp13_ = NULL;
							gint _tmp13__length1 = 0;
							gchar* _tmp14_ = NULL;
#line 52 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
							_tmp12_ = parts;
#line 52 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
							_tmp12__length1 = parts_length1;
#line 52 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
							_tmp13_ = parts;
#line 52 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
							_tmp13__length1 = parts_length1;
#line 52 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
							_tmp14_ = _vala_g_strjoinv ("=", _tmp12_ + 1, _tmp13__length1 - 1);
#line 52 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
							_g_free0 (rygel_pretty_host_name);
#line 52 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
							rygel_pretty_host_name = _tmp14_;
#line 838 "rygel-root-device-factory.c"
						}
#line 48 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 48 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
						_g_free0 (line);
#line 844 "rygel-root-device-factory.c"
					}
				}
			}
#line 41 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 41 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_g_free0 (machine_info);
#line 852 "rygel-root-device-factory.c"
		}
		goto __finally12;
		__catch12_g_error:
		{
			GError* e = NULL;
			GError* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
#line 41 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			e = _inner_error_;
#line 41 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_inner_error_ = NULL;
#line 56 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp15_ = e;
#line 56 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp16_ = _tmp15_->message;
#line 56 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			g_debug ("rygel-root-device-factory.vala:56: Failed to parse /etc/machine-info: " \
"%s", _tmp16_);
#line 41 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_g_error_free0 (e);
#line 872 "rygel-root-device-factory.c"
		}
		__finally12:
#line 41 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 41 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 41 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			g_clear_error (&_inner_error_);
#line 41 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			return NULL;
#line 883 "rygel-root-device-factory.c"
		}
#line 59 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp17_ = g_get_host_name ();
#line 59 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp18_ = g_strdup (_tmp17_);
#line 59 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (rygel_pretty_host_name);
#line 59 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		rygel_pretty_host_name = _tmp18_;
#line 893 "rygel-root-device-factory.c"
	}
#line 62 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp19_ = rygel_pretty_host_name;
#line 62 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp20_ = g_strdup (_tmp19_);
#line 62 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	result = _tmp20_;
#line 62 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	return result;
#line 903 "rygel-root-device-factory.c"
}


RygelRootDeviceFactory* rygel_root_device_factory_construct (GType object_type, GUPnPContext* context, GError** error) {
	RygelRootDeviceFactory * self = NULL;
	GUPnPContext* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 82 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp0_ = context;
#line 82 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	self = (RygelRootDeviceFactory*) g_object_new (object_type, "context", _tmp0_, NULL);
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_initable_init ((GInitable*) self, NULL, &_inner_error_);
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (self);
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return NULL;
#line 927 "rygel-root-device-factory.c"
	}
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	return self;
#line 931 "rygel-root-device-factory.c"
}


RygelRootDeviceFactory* rygel_root_device_factory_new (GUPnPContext* context, GError** error) {
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	return rygel_root_device_factory_construct (RYGEL_TYPE_ROOT_DEVICE_FACTORY, context, error);
#line 938 "rygel-root-device-factory.c"
}


static gboolean rygel_root_device_factory_real_init (GInitable* base, GCancellable* cancellable, GError** error) {
	RygelRootDeviceFactory * self;
	gboolean result = FALSE;
	RygelConfiguration* _tmp0_ = NULL;
	RygelMetaConfig* _tmp1_ = NULL;
	gchar* config_dir = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
#line 86 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	self = (RygelRootDeviceFactory*) base;
#line 87 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp0_ = self->priv->config;
#line 87 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (_tmp0_ != NULL) {
#line 88 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		result = TRUE;
#line 88 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return result;
#line 966 "rygel-root-device-factory.c"
	}
#line 91 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp1_ = rygel_meta_config_get_default ();
#line 91 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_object_unref0 (self->priv->config);
#line 91 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	self->priv->config = (RygelConfiguration*) _tmp1_;
#line 94 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp2_ = g_get_user_config_dir ();
#line 94 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 94 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	config_dir = _tmp3_;
#line 95 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp4_ = config_dir;
#line 95 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	rygel_root_device_factory_ensure_dir_exists (self, _tmp4_, &_inner_error_);
#line 95 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 95 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 95 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (config_dir);
#line 95 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return FALSE;
#line 992 "rygel-root-device-factory.c"
	}
#line 96 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp5_ = config_dir;
#line 96 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp6_ = g_get_application_name ();
#line 96 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp7_ = g_build_filename (_tmp5_, _tmp6_, NULL);
#line 96 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_free0 (self->priv->desc_dir);
#line 96 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	self->priv->desc_dir = _tmp7_;
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp8_ = self->priv->desc_dir;
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	rygel_root_device_factory_ensure_dir_exists (self, _tmp8_, &_inner_error_);
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (config_dir);
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return FALSE;
#line 1016 "rygel-root-device-factory.c"
	}
#line 100 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	result = TRUE;
#line 100 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_free0 (config_dir);
#line 100 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	return result;
#line 1024 "rygel-root-device-factory.c"
}


RygelRootDevice* rygel_root_device_factory_create (RygelRootDeviceFactory* self, RygelPlugin* plugin, GError** error) {
	RygelRootDevice* result = NULL;
	gchar* desc_path = NULL;
	const gchar* _tmp0_ = NULL;
	RygelPlugin* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* template_path = NULL;
	RygelPlugin* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GUPnPXMLDoc* doc = NULL;
	RygelPlugin* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GUPnPXMLDoc* _tmp15_ = NULL;
	RygelRootDevice* device = NULL;
	GUPnPContext* _tmp16_ = NULL;
	RygelPlugin* _tmp17_ = NULL;
	GUPnPXMLDoc* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	RygelRootDevice* _tmp20_ = NULL;
	RygelPlugin* _tmp21_ = NULL;
	RygelRootDevice* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GError * _inner_error_ = NULL;
#line 103 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 103 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (plugin != NULL, NULL);
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp0_ = self->priv->desc_dir;
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp1_ = plugin;
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp2_ = rygel_plugin_get_name (_tmp1_);
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp3_ = _tmp2_;
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp4_ = g_strconcat (_tmp3_, ".xml", NULL);
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp5_ = _tmp4_;
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp6_ = g_build_filename (_tmp0_, _tmp5_, NULL);
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp7_ = _tmp6_;
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_free0 (_tmp5_);
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	desc_path = _tmp7_;
#line 106 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp8_ = plugin;
#line 106 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp9_ = rygel_plugin_get_desc_path (_tmp8_);
#line 106 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp10_ = _tmp9_;
#line 106 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 106 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	template_path = _tmp11_;
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp12_ = plugin;
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp13_ = desc_path;
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp14_ = template_path;
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp15_ = rygel_root_device_factory_create_desc (self, _tmp12_, _tmp13_, _tmp14_, &_inner_error_);
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	doc = _tmp15_;
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (template_path);
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (desc_path);
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return NULL;
#line 1113 "rygel-root-device-factory.c"
	}
#line 111 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp16_ = self->priv->_context;
#line 111 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp17_ = plugin;
#line 111 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp18_ = doc;
#line 111 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp19_ = desc_path;
#line 111 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp20_ = rygel_root_device_new (_tmp16_, _tmp17_, _tmp18_, _tmp19_, DATA_DIR);
#line 111 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	device = _tmp20_;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp21_ = plugin;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp22_ = device;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp23_ = desc_path;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	rygel_plugin_apply_hacks (_tmp21_, _tmp22_, _tmp23_, &_inner_error_);
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (device);
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (doc);
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (template_path);
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (desc_path);
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return NULL;
#line 1149 "rygel-root-device-factory.c"
	}
#line 118 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	result = device;
#line 118 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_object_unref0 (doc);
#line 118 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_free0 (template_path);
#line 118 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_free0 (desc_path);
#line 118 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	return result;
#line 1161 "rygel-root-device-factory.c"
}


static gchar* uuid_get (void) {
	gchar* result = NULL;
	guchar* id = NULL;
	guchar* _tmp0_ = NULL;
	gint id_length1 = 0;
	gint _id_size_ = 0;
	guchar* unparsed = NULL;
	guchar* _tmp1_ = NULL;
	gint unparsed_length1 = 0;
	gint _unparsed_size_ = 0;
	guchar* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	guchar* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	guchar* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	guchar _tmp6_ = '\0';
	guchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gchar* _tmp8_ = NULL;
#line 8 "./uuid.vapi"
	_tmp0_ = g_new0 (guchar, 16);
#line 8 "./uuid.vapi"
	id = _tmp0_;
#line 8 "./uuid.vapi"
	id_length1 = 16;
#line 8 "./uuid.vapi"
	_id_size_ = id_length1;
#line 9 "./uuid.vapi"
	_tmp1_ = g_new0 (guchar, 51);
#line 9 "./uuid.vapi"
	unparsed = _tmp1_;
#line 9 "./uuid.vapi"
	unparsed_length1 = 51;
#line 9 "./uuid.vapi"
	_unparsed_size_ = unparsed_length1;
#line 11 "./uuid.vapi"
	_tmp2_ = id;
#line 11 "./uuid.vapi"
	_tmp2__length1 = id_length1;
#line 11 "./uuid.vapi"
	uuid_generate (_tmp2_);
#line 12 "./uuid.vapi"
	_tmp3_ = id;
#line 12 "./uuid.vapi"
	_tmp3__length1 = id_length1;
#line 12 "./uuid.vapi"
	_tmp4_ = unparsed;
#line 12 "./uuid.vapi"
	_tmp4__length1 = unparsed_length1;
#line 12 "./uuid.vapi"
	uuid_unparse (_tmp3_, _tmp4_);
#line 13 "./uuid.vapi"
	_tmp5_ = unparsed;
#line 13 "./uuid.vapi"
	_tmp5__length1 = unparsed_length1;
#line 13 "./uuid.vapi"
	_tmp5_[50] = (guchar) '\0';
#line 13 "./uuid.vapi"
	_tmp6_ = _tmp5_[50];
#line 15 "./uuid.vapi"
	_tmp7_ = unparsed;
#line 15 "./uuid.vapi"
	_tmp7__length1 = unparsed_length1;
#line 15 "./uuid.vapi"
	_tmp8_ = g_strdup ((const gchar*) _tmp7_);
#line 15 "./uuid.vapi"
	result = _tmp8_;
#line 15 "./uuid.vapi"
	unparsed = (g_free (unparsed), NULL);
#line 15 "./uuid.vapi"
	id = (g_free (id), NULL);
#line 15 "./uuid.vapi"
	return result;
#line 1241 "rygel-root-device-factory.c"
}


static GUPnPXMLDoc* rygel_root_device_factory_create_desc (RygelRootDeviceFactory* self, RygelPlugin* plugin, const gchar* desc_path, const gchar* template_path, GError** error) {
	GUPnPXMLDoc* result = NULL;
	GUPnPXMLDoc* doc = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GUPnPXMLDoc* _tmp2_ = NULL;
	RygelDescriptionFile* file = NULL;
	GUPnPXMLDoc* _tmp3_ = NULL;
	RygelDescriptionFile* _tmp4_ = NULL;
	RygelDescriptionFile* _tmp5_ = NULL;
	RygelPlugin* _tmp6_ = NULL;
	RygelDescriptionFile* _tmp7_ = NULL;
	RygelPlugin* _tmp8_ = NULL;
	RygelDescriptionFile* _tmp9_ = NULL;
	RygelPlugin* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	RygelDescriptionFile* _tmp13_ = NULL;
	RygelPlugin* _tmp14_ = NULL;
	RygelPluginCapabilities _tmp15_ = 0;
	RygelPluginCapabilities _tmp16_ = 0;
	RygelPlugin* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* udn = NULL;
	RygelDescriptionFile* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	const gchar* _tmp27_ = NULL;
	RygelDescriptionFile* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	GError * _inner_error_ = NULL;
#line 121 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 121 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (plugin != NULL, NULL);
#line 121 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (desc_path != NULL, NULL);
#line 121 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (template_path != NULL, NULL);
#line 124 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp0_ = desc_path;
#line 124 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp1_ = template_path;
#line 124 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp2_ = rygel_root_device_factory_get_latest_doc (self, _tmp0_, _tmp1_, &_inner_error_);
#line 124 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	doc = _tmp2_;
#line 124 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 124 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 124 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return NULL;
#line 1299 "rygel-root-device-factory.c"
	}
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp3_ = doc;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp4_ = rygel_description_file_new_from_xml_document (_tmp3_);
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	file = _tmp4_;
#line 130 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp5_ = file;
#line 130 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp6_ = plugin;
#line 130 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	rygel_root_device_factory_add_services_to_desc (self, _tmp5_, _tmp6_);
#line 131 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp7_ = file;
#line 131 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp8_ = plugin;
#line 131 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	rygel_root_device_factory_add_icons_to_desc (self, _tmp7_, _tmp8_);
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp9_ = file;
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp10_ = plugin;
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp11_ = rygel_root_device_factory_get_friendly_name (self, _tmp10_);
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp12_ = _tmp11_;
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	rygel_description_file_set_friendly_name (_tmp9_, _tmp12_);
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_free0 (_tmp12_);
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp13_ = file;
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp14_ = plugin;
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp15_ = rygel_plugin_get_capabilities (_tmp14_);
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp16_ = _tmp15_;
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	rygel_description_file_set_dlna_caps (_tmp13_, _tmp16_);
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp17_ = plugin;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp18_ = rygel_plugin_get_description (_tmp17_);
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp19_ = _tmp18_;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (_tmp19_ != NULL) {
#line 1349 "rygel-root-device-factory.c"
		RygelDescriptionFile* _tmp20_ = NULL;
		RygelPlugin* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
#line 136 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp20_ = file;
#line 136 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp21_ = plugin;
#line 136 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp22_ = rygel_plugin_get_description (_tmp21_);
#line 136 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp23_ = _tmp22_;
#line 136 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		rygel_description_file_set_model_description (_tmp20_, _tmp23_);
#line 1364 "rygel-root-device-factory.c"
	}
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp24_ = file;
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp25_ = rygel_description_file_get_udn (_tmp24_);
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	udn = _tmp25_;
#line 139 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp27_ = udn;
#line 139 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (_tmp27_ == NULL) {
#line 139 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp26_ = TRUE;
#line 1378 "rygel-root-device-factory.c"
	} else {
		const gchar* _tmp28_ = NULL;
#line 139 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp28_ = udn;
#line 139 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp26_ = g_strcmp0 (_tmp28_, "") == 0;
#line 1385 "rygel-root-device-factory.c"
	}
#line 139 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (_tmp26_) {
#line 1389 "rygel-root-device-factory.c"
		RygelDescriptionFile* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp29_ = file;
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp30_ = uuid_get ();
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp31_ = _tmp30_;
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp32_ = g_strconcat ("uuid:", _tmp31_, NULL);
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp33_ = _tmp32_;
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		rygel_description_file_set_udn (_tmp29_, _tmp33_);
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp33_);
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp31_);
#line 1411 "rygel-root-device-factory.c"
	}
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp34_ = file;
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp35_ = desc_path;
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	rygel_description_file_save (_tmp34_, _tmp35_, &_inner_error_);
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (udn);
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (file);
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (doc);
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return NULL;
#line 1431 "rygel-root-device-factory.c"
	}
#line 145 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	result = doc;
#line 145 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_free0 (udn);
#line 145 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_object_unref0 (file);
#line 145 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	return result;
#line 1441 "rygel-root-device-factory.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1454 "rygel-root-device-factory.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1485 "rygel-root-device-factory.c"
				goto __catch14_g_regex_error;
			}
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return NULL;
#line 1494 "rygel-root-device-factory.c"
		}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1510 "rygel-root-device-factory.c"
				goto __catch14_g_regex_error;
			}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return NULL;
#line 1521 "rygel-root-device-factory.c"
		}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 1535 "rygel-root-device-factory.c"
	}
	goto __finally14;
	__catch14_g_regex_error:
	{
		GError* e = NULL;
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1287 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 1549 "rygel-root-device-factory.c"
	}
	__finally14:
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return NULL;
#line 1560 "rygel-root-device-factory.c"
	}
}


static gchar* rygel_root_device_factory_get_friendly_name (RygelRootDeviceFactory* self, RygelPlugin* plugin) {
	gchar* result = NULL;
	gchar* title = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	GError * _inner_error_ = NULL;
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (plugin != NULL, NULL);
#line 1586 "rygel-root-device-factory.c"
	{
		gchar* _tmp0_ = NULL;
		RygelConfiguration* _tmp1_ = NULL;
		RygelPlugin* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp1_ = self->priv->config;
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp2_ = plugin;
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp3_ = rygel_plugin_get_name (_tmp2_);
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp4_ = _tmp3_;
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp5_ = rygel_configuration_get_title (_tmp1_, _tmp4_, &_inner_error_);
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp0_ = _tmp5_;
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1609 "rygel-root-device-factory.c"
			goto __catch13_g_error;
		}
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp6_ = _tmp0_;
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp0_ = NULL;
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (title);
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		title = _tmp6_;
#line 150 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp0_);
#line 1622 "rygel-root-device-factory.c"
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* err = NULL;
		RygelPlugin* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
#line 150 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		err = _inner_error_;
#line 150 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_inner_error_ = NULL;
#line 153 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp7_ = plugin;
#line 153 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp8_ = rygel_plugin_get_title (_tmp7_);
#line 153 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp9_ = _tmp8_;
#line 153 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp10_ = g_strdup (_tmp9_);
#line 153 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (title);
#line 153 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		title = _tmp10_;
#line 150 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_error_free0 (err);
#line 1650 "rygel-root-device-factory.c"
	}
	__finally13:
#line 150 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 150 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (title);
#line 150 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 150 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_clear_error (&_inner_error_);
#line 150 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return NULL;
#line 1663 "rygel-root-device-factory.c"
	}
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp11_ = title;
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp12_ = g_get_real_name ();
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp13_ = string_replace (_tmp11_, "@REALNAME@", _tmp12_);
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_free0 (title);
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	title = _tmp13_;
#line 157 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp14_ = title;
#line 157 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp15_ = g_get_user_name ();
#line 157 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp16_ = string_replace (_tmp14_, "@USERNAME@", _tmp15_);
#line 157 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_free0 (title);
#line 157 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	title = _tmp16_;
#line 158 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp17_ = title;
#line 158 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp18_ = g_get_host_name ();
#line 158 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp19_ = string_replace (_tmp17_, "@HOSTNAME@", _tmp18_);
#line 158 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_free0 (title);
#line 158 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	title = _tmp19_;
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp20_ = title;
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp21_ = rygel_get_pretty_host_name ();
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp22_ = _tmp21_;
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp23_ = string_replace (_tmp20_, "@PRETTY_HOSTNAME@", _tmp22_);
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_free0 (title);
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	title = _tmp23_;
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_free0 (_tmp22_);
#line 161 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	result = title;
#line 161 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	return result;
#line 1713 "rygel-root-device-factory.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	return self ? g_object_ref (self) : NULL;
#line 1720 "rygel-root-device-factory.c"
}


static void rygel_root_device_factory_add_services_to_desc (RygelRootDeviceFactory* self, RygelDescriptionFile* file, RygelPlugin* plugin) {
	RygelDescriptionFile* _tmp0_ = NULL;
#line 164 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_if_fail (self != NULL);
#line 164 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_if_fail (file != NULL);
#line 164 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_if_fail (plugin != NULL);
#line 166 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp0_ = file;
#line 166 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	rygel_description_file_clear_service_list (_tmp0_);
#line 1736 "rygel-root-device-factory.c"
	{
		GeeArrayList* _resource_info_list = NULL;
		RygelPlugin* _tmp1_ = NULL;
		GeeArrayList* _tmp2_ = NULL;
		GeeArrayList* _tmp3_ = NULL;
		GeeArrayList* _tmp4_ = NULL;
		gint _resource_info_size = 0;
		GeeArrayList* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _resource_info_index = 0;
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp1_ = plugin;
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp2_ = rygel_plugin_get_resource_infos (_tmp1_);
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp3_ = _tmp2_;
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_resource_info_list = _tmp4_;
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp5_ = _resource_info_list;
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp6_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp5_);
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp7_ = _tmp6_;
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_resource_info_size = _tmp7_;
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_resource_info_index = -1;
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		while (TRUE) {
#line 1770 "rygel-root-device-factory.c"
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			RygelResourceInfo* resource_info = NULL;
			GeeArrayList* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gpointer _tmp13_ = NULL;
			RygelResourceInfo* _tmp14_ = NULL;
			GType _tmp15_ = 0UL;
			gboolean _tmp16_ = FALSE;
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp8_ = _resource_info_index;
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_resource_info_index = _tmp8_ + 1;
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp9_ = _resource_info_index;
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp10_ = _resource_info_size;
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			if (!(_tmp9_ < _tmp10_)) {
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				break;
#line 1793 "rygel-root-device-factory.c"
			}
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp11_ = _resource_info_list;
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp12_ = _resource_info_index;
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tmp12_);
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			resource_info = (RygelResourceInfo*) _tmp13_;
#line 169 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp14_ = resource_info;
#line 169 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp15_ = _tmp14_->type;
#line 169 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp16_ = g_type_is_a (_tmp15_, gupnp_service_get_type ());
#line 169 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			if (_tmp16_) {
#line 1811 "rygel-root-device-factory.c"
				RygelDescriptionFile* _tmp17_ = NULL;
				RygelPlugin* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				RygelResourceInfo* _tmp21_ = NULL;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				_tmp17_ = file;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				_tmp18_ = plugin;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				_tmp19_ = rygel_plugin_get_name (_tmp18_);
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				_tmp20_ = _tmp19_;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				_tmp21_ = resource_info;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				rygel_description_file_add_service (_tmp17_, _tmp20_, _tmp21_);
#line 1829 "rygel-root-device-factory.c"
			}
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_rygel_resource_info_unref0 (resource_info);
#line 1833 "rygel-root-device-factory.c"
		}
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (_resource_info_list);
#line 1837 "rygel-root-device-factory.c"
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1198 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1198 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 1861 "rygel-root-device-factory.c"
		glong _tmp4_ = 0L;
#line 1199 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1199 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1199 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 1869 "rygel-root-device-factory.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 1881 "rygel-root-device-factory.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1208 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 1905 "rygel-root-device-factory.c"
		glong _tmp2_ = 0L;
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 1911 "rygel-root-device-factory.c"
	} else {
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1915 "rygel-root-device-factory.c"
	}
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 1919 "rygel-root-device-factory.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 1931 "rygel-root-device-factory.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1214 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1214 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1214 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 1941 "rygel-root-device-factory.c"
	}
#line 1217 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1217 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 1947 "rygel-root-device-factory.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1218 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1218 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1218 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1219 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1219 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 1961 "rygel-root-device-factory.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1221 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1221 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1221 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 1971 "rygel-root-device-factory.c"
	}
#line 1223 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1223 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 1977 "rygel-root-device-factory.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1224 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1224 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1224 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 1986 "rygel-root-device-factory.c"
	}
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 2006 "rygel-root-device-factory.c"
}


static void rygel_root_device_factory_add_icons_to_desc (RygelRootDeviceFactory* self, RygelDescriptionFile* file, RygelPlugin* plugin) {
	GeeArrayList* icons = NULL;
	RygelPlugin* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GeeArrayList* _tmp5_ = NULL;
	RygelDescriptionFile* _tmp16_ = NULL;
#line 175 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_if_fail (self != NULL);
#line 175 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_if_fail (file != NULL);
#line 175 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_if_fail (plugin != NULL);
#line 177 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp0_ = plugin;
#line 177 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp1_ = rygel_plugin_get_icon_infos (_tmp0_);
#line 177 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp2_ = _tmp1_;
#line 177 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 177 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	icons = _tmp3_;
#line 179 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp5_ = icons;
#line 179 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (_tmp5_ == NULL) {
#line 179 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp4_ = TRUE;
#line 2041 "rygel-root-device-factory.c"
	} else {
		GeeArrayList* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 179 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp6_ = icons;
#line 179 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
#line 179 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp8_ = _tmp7_;
#line 179 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp4_ = _tmp8_ == 0;
#line 2054 "rygel-root-device-factory.c"
	}
#line 179 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (_tmp4_) {
#line 2058 "rygel-root-device-factory.c"
		RygelPlugin* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		RygelPlugin* _tmp12_ = NULL;
		GeeArrayList* _tmp13_ = NULL;
		GeeArrayList* _tmp14_ = NULL;
		GeeArrayList* _tmp15_ = NULL;
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp9_ = plugin;
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp10_ = rygel_plugin_get_name (_tmp9_);
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp11_ = _tmp10_;
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_debug ("rygel-root-device-factory.vala:180: No icon provided by plugin '%s'. U" \
"sing Rygel logo.", _tmp11_);
#line 183 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp12_ = plugin;
#line 183 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp13_ = rygel_plugin_get_default_icons (_tmp12_);
#line 183 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp14_ = _tmp13_;
#line 183 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp15_ = _g_object_ref0 (_tmp14_);
#line 183 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (icons);
#line 183 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		icons = _tmp15_;
#line 2086 "rygel-root-device-factory.c"
	}
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp16_ = file;
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	rygel_description_file_clear_icon_list (_tmp16_);
#line 2092 "rygel-root-device-factory.c"
	{
		GeeArrayList* _icon_list = NULL;
		GeeArrayList* _tmp17_ = NULL;
		GeeArrayList* _tmp18_ = NULL;
		gint _icon_size = 0;
		GeeArrayList* _tmp19_ = NULL;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		gint _icon_index = 0;
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp17_ = icons;
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp18_ = _g_object_ref0 (_tmp17_);
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_icon_list = _tmp18_;
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp19_ = _icon_list;
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp20_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp19_);
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp21_ = _tmp20_;
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_icon_size = _tmp21_;
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_icon_index = -1;
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		while (TRUE) {
#line 2120 "rygel-root-device-factory.c"
			gint _tmp22_ = 0;
			gint _tmp23_ = 0;
			gint _tmp24_ = 0;
			RygelIconInfo* icon = NULL;
			GeeArrayList* _tmp25_ = NULL;
			gint _tmp26_ = 0;
			gpointer _tmp27_ = NULL;
			gchar* remote_path = NULL;
			RygelIconInfo* _tmp28_ = NULL;
			RygelPlugin* _tmp29_ = NULL;
			gchar* _tmp30_ = NULL;
			RygelIconInfo* _tmp31_ = NULL;
			const gchar* _tmp32_ = NULL;
			gboolean _tmp33_ = FALSE;
			RygelDescriptionFile* _tmp40_ = NULL;
			RygelPlugin* _tmp41_ = NULL;
			const gchar* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			RygelIconInfo* _tmp44_ = NULL;
			const gchar* _tmp45_ = NULL;
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp22_ = _icon_index;
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_icon_index = _tmp22_ + 1;
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp23_ = _icon_index;
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp24_ = _icon_size;
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			if (!(_tmp23_ < _tmp24_)) {
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				break;
#line 2153 "rygel-root-device-factory.c"
			}
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp25_ = _icon_list;
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp26_ = _icon_index;
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, _tmp26_);
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			icon = (RygelIconInfo*) _tmp27_;
#line 188 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp28_ = icon;
#line 188 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp29_ = plugin;
#line 188 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp30_ = rygel_root_device_factory_get_icon_remote_path (self, _tmp28_, _tmp29_);
#line 188 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			remote_path = _tmp30_;
#line 189 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp31_ = icon;
#line 189 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp32_ = _tmp31_->uri;
#line 189 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp33_ = g_str_has_prefix (_tmp32_, "file://");
#line 189 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			if (_tmp33_) {
#line 2179 "rygel-root-device-factory.c"
				gchar* local_path = NULL;
				RygelIconInfo* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
				gchar* _tmp36_ = NULL;
				GUPnPContext* _tmp37_ = NULL;
				const gchar* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
#line 190 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				_tmp34_ = icon;
#line 190 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				_tmp35_ = _tmp34_->uri;
#line 190 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				_tmp36_ = string_substring (_tmp35_, (glong) 7, (glong) (-1));
#line 190 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				local_path = _tmp36_;
#line 191 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				_tmp37_ = self->priv->_context;
#line 191 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				_tmp38_ = local_path;
#line 191 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				_tmp39_ = remote_path;
#line 191 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				gupnp_context_host_path (_tmp37_, _tmp38_, _tmp39_);
#line 189 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				_g_free0 (local_path);
#line 2205 "rygel-root-device-factory.c"
			}
#line 194 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp40_ = file;
#line 194 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp41_ = plugin;
#line 194 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp42_ = rygel_plugin_get_name (_tmp41_);
#line 194 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp43_ = _tmp42_;
#line 194 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp44_ = icon;
#line 194 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp45_ = remote_path;
#line 194 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			rygel_description_file_add_icon (_tmp40_, _tmp43_, _tmp44_, _tmp45_);
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_g_free0 (remote_path);
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_rygel_icon_info_unref0 (icon);
#line 2225 "rygel-root-device-factory.c"
		}
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (_icon_list);
#line 2229 "rygel-root-device-factory.c"
	}
#line 175 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_object_unref0 (icons);
#line 2233 "rygel-root-device-factory.c"
}


static gchar* rygel_root_device_factory_get_icon_remote_path (RygelRootDeviceFactory* self, RygelIconInfo* icon_info, RygelPlugin* plugin) {
	gchar* result = NULL;
	RygelIconInfo* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 198 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 198 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (icon_info != NULL, NULL);
#line 198 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (plugin != NULL, NULL);
#line 200 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp0_ = icon_info;
#line 200 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp1_ = _tmp0_->uri;
#line 200 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp2_ = g_str_has_prefix (_tmp1_, "file://");
#line 200 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (_tmp2_) {
#line 2256 "rygel-root-device-factory.c"
		RygelPlugin* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		RygelIconInfo* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		RygelIconInfo* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		RygelIconInfo* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		RygelIconInfo* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp3_ = plugin;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp4_ = rygel_plugin_get_name (_tmp3_);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp5_ = _tmp4_;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp6_ = g_strconcat ("/", _tmp5_, NULL);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp7_ = _tmp6_;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp8_ = g_strconcat (_tmp7_, "-", NULL);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp9_ = _tmp8_;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp10_ = icon_info;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp11_ = _tmp10_->width;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp12_ = g_strdup_printf ("%i", _tmp11_);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp13_ = _tmp12_;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp14_ = g_strconcat (_tmp9_, _tmp13_, NULL);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp15_ = _tmp14_;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp16_ = g_strconcat (_tmp15_, "x", NULL);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp17_ = _tmp16_;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp18_ = icon_info;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp19_ = _tmp18_->height;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp20_ = g_strdup_printf ("%i", _tmp19_);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp21_ = _tmp20_;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp22_ = g_strconcat (_tmp17_, _tmp21_, NULL);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp23_ = _tmp22_;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp24_ = g_strconcat (_tmp23_, "x", NULL);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp25_ = _tmp24_;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp26_ = icon_info;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp27_ = _tmp26_->depth;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp28_ = g_strdup_printf ("%i", _tmp27_);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp29_ = _tmp28_;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp30_ = g_strconcat (_tmp25_, _tmp29_, NULL);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp31_ = _tmp30_;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp32_ = g_strconcat (_tmp31_, ".", NULL);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp33_ = _tmp32_;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp34_ = icon_info;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp35_ = _tmp34_->file_extension;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp36_ = g_strconcat (_tmp33_, _tmp35_, NULL);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp37_ = _tmp36_;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp33_);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp31_);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp29_);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp25_);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp23_);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp21_);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp17_);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp15_);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp13_);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp9_);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp7_);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		result = _tmp37_;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return result;
#line 2388 "rygel-root-device-factory.c"
	} else {
		gchar* uri = NULL;
		RygelIconInfo* _tmp38_ = NULL;
		const gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		const gchar* _tmp41_ = NULL;
		GUPnPContext* _tmp42_ = NULL;
		const gchar* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
		gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp38_ = icon_info;
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp39_ = _tmp38_->uri;
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp40_ = g_strdup (_tmp39_);
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		uri = _tmp40_;
#line 209 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp41_ = uri;
#line 209 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp42_ = self->priv->_context;
#line 209 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp43_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp42_);
#line 209 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp44_ = _tmp43_;
#line 209 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp45_ = string_replace (_tmp41_, "@ADDRESS@", _tmp44_);
#line 209 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp46_ = _tmp45_;
#line 209 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_free0 (_tmp46_);
#line 210 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		result = uri;
#line 210 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return result;
#line 2426 "rygel-root-device-factory.c"
	}
}


static GUPnPXMLDoc* rygel_root_device_factory_get_latest_doc (RygelRootDeviceFactory* self, const gchar* path1, const gchar* path2, GError** error) {
	GUPnPXMLDoc* result = NULL;
	GFile* file = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GFileInfo* info = NULL;
	GFile* _tmp8_ = NULL;
	GFileInfo* _tmp9_ = NULL;
	guint64 mod1 = 0ULL;
	GFileInfo* _tmp10_ = NULL;
	guint64 _tmp11_ = 0ULL;
	const gchar* _tmp12_ = NULL;
	GFile* _tmp13_ = NULL;
	GFileInfo* _tmp14_ = NULL;
	GFile* _tmp15_ = NULL;
	GFileInfo* _tmp16_ = NULL;
	GFileInfo* _tmp17_ = NULL;
	guint64 mod2 = 0ULL;
	GFileInfo* _tmp18_ = NULL;
	guint64 _tmp19_ = 0ULL;
	guint64 _tmp20_ = 0ULL;
	guint64 _tmp21_ = 0ULL;
	GError * _inner_error_ = NULL;
#line 214 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 214 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (path1 != NULL, NULL);
#line 214 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (path2 != NULL, NULL);
#line 216 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp0_ = path1;
#line 216 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp1_ = g_file_new_for_path (_tmp0_);
#line 216 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	file = _tmp1_;
#line 217 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp2_ = file;
#line 217 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
#line 217 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (!_tmp3_) {
#line 2474 "rygel-root-device-factory.c"
		GUPnPXMLDoc* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		GUPnPXMLDoc* _tmp6_ = NULL;
		GUPnPXMLDoc* _tmp7_ = NULL;
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp5_ = path2;
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp6_ = gupnp_xml_doc_new_from_path (_tmp5_, &_inner_error_);
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp4_ = _tmp6_;
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			g_propagate_error (error, _inner_error_);
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_g_object_unref0 (file);
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			return NULL;
#line 2493 "rygel-root-device-factory.c"
		}
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp7_ = _tmp4_;
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp4_ = NULL;
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		result = _tmp7_;
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (_tmp4_);
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (file);
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return result;
#line 2507 "rygel-root-device-factory.c"
	}
#line 221 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp8_ = file;
#line 221 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp9_ = g_file_query_info (_tmp8_, G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 221 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	info = _tmp9_;
#line 221 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 221 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 221 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (file);
#line 221 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return NULL;
#line 2523 "rygel-root-device-factory.c"
	}
#line 223 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp10_ = info;
#line 223 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp11_ = g_file_info_get_attribute_uint64 (_tmp10_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
#line 223 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	mod1 = _tmp11_;
#line 225 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp12_ = path2;
#line 225 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp13_ = g_file_new_for_path (_tmp12_);
#line 225 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_object_unref0 (file);
#line 225 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	file = _tmp13_;
#line 226 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp15_ = file;
#line 226 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp16_ = g_file_query_info (_tmp15_, G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 226 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp14_ = _tmp16_;
#line 226 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 226 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 226 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (info);
#line 226 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (file);
#line 226 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return NULL;
#line 2555 "rygel-root-device-factory.c"
	}
#line 226 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp17_ = _tmp14_;
#line 226 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp14_ = NULL;
#line 226 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_object_unref0 (info);
#line 226 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	info = _tmp17_;
#line 228 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp18_ = info;
#line 228 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp19_ = g_file_info_get_attribute_uint64 (_tmp18_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
#line 228 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	mod2 = _tmp19_;
#line 230 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp20_ = mod1;
#line 230 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp21_ = mod2;
#line 230 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (_tmp20_ > _tmp21_) {
#line 2577 "rygel-root-device-factory.c"
		{
			GUPnPXMLDoc* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			GUPnPXMLDoc* _tmp24_ = NULL;
			GUPnPXMLDoc* _tmp25_ = NULL;
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp23_ = path1;
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp24_ = gupnp_xml_doc_new_from_path (_tmp23_, &_inner_error_);
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp22_ = _tmp24_;
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2591 "rygel-root-device-factory.c"
				goto __catch15_g_error;
			}
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp25_ = _tmp22_;
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp22_ = NULL;
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			result = _tmp25_;
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_g_object_unref0 (_tmp22_);
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_g_object_unref0 (_tmp14_);
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_g_object_unref0 (info);
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_g_object_unref0 (file);
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			return result;
#line 2610 "rygel-root-device-factory.c"
		}
		goto __finally15;
		__catch15_g_error:
		{
			GError* _error_ = NULL;
			GUPnPXMLDoc* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
			GUPnPXMLDoc* _tmp28_ = NULL;
			GUPnPXMLDoc* _tmp29_ = NULL;
#line 233 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_error_ = _inner_error_;
#line 233 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_inner_error_ = NULL;
#line 236 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp27_ = path2;
#line 236 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp28_ = gupnp_xml_doc_new_from_path (_tmp27_, &_inner_error_);
#line 236 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp26_ = _tmp28_;
#line 236 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 236 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
				_g_error_free0 (_error_);
#line 2634 "rygel-root-device-factory.c"
				goto __finally15;
			}
#line 236 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp29_ = _tmp26_;
#line 236 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_tmp26_ = NULL;
#line 236 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			result = _tmp29_;
#line 236 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_g_object_unref0 (_tmp26_);
#line 236 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_g_error_free0 (_error_);
#line 236 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_g_object_unref0 (_tmp14_);
#line 236 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_g_object_unref0 (info);
#line 236 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_g_object_unref0 (file);
#line 236 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			return result;
#line 2655 "rygel-root-device-factory.c"
		}
		__finally15:
#line 233 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 233 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (_tmp14_);
#line 233 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (info);
#line 233 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (file);
#line 233 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return NULL;
#line 2668 "rygel-root-device-factory.c"
	} else {
		GUPnPXMLDoc* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		GUPnPXMLDoc* _tmp32_ = NULL;
		GUPnPXMLDoc* _tmp33_ = NULL;
#line 239 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp31_ = path2;
#line 239 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp32_ = gupnp_xml_doc_new_from_path (_tmp31_, &_inner_error_);
#line 239 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp30_ = _tmp32_;
#line 239 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 239 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			g_propagate_error (error, _inner_error_);
#line 239 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_g_object_unref0 (_tmp14_);
#line 239 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_g_object_unref0 (info);
#line 239 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_g_object_unref0 (file);
#line 239 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			return NULL;
#line 2692 "rygel-root-device-factory.c"
		}
#line 239 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp33_ = _tmp30_;
#line 239 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp30_ = NULL;
#line 239 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		result = _tmp33_;
#line 239 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (_tmp30_);
#line 239 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (_tmp14_);
#line 239 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (info);
#line 239 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_g_object_unref0 (file);
#line 239 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		return result;
#line 2710 "rygel-root-device-factory.c"
	}
#line 214 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_object_unref0 (_tmp14_);
#line 214 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_object_unref0 (info);
#line 214 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_object_unref0 (file);
#line 2718 "rygel-root-device-factory.c"
}


static void rygel_root_device_factory_ensure_dir_exists (RygelRootDeviceFactory* self, const gchar* dir_path, GError** error) {
	GFile* file = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GError * _inner_error_ = NULL;
#line 243 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_if_fail (self != NULL);
#line 243 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_if_fail (dir_path != NULL);
#line 244 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp0_ = dir_path;
#line 244 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp1_ = g_file_new_for_path (_tmp0_);
#line 244 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	file = _tmp1_;
#line 245 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp2_ = file;
#line 245 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
#line 245 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	if (!_tmp3_) {
#line 2745 "rygel-root-device-factory.c"
		GFile* _tmp4_ = NULL;
#line 246 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		_tmp4_ = file;
#line 246 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_file_make_directory (_tmp4_, NULL, &_inner_error_);
#line 246 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 246 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			g_propagate_error (error, _inner_error_);
#line 246 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			_g_object_unref0 (file);
#line 246 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
			return;
#line 2759 "rygel-root-device-factory.c"
		}
	}
#line 243 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_object_unref0 (file);
#line 2764 "rygel-root-device-factory.c"
}


GUPnPContext* rygel_root_device_factory_get_context (RygelRootDeviceFactory* self) {
	GUPnPContext* result;
	GUPnPContext* _tmp0_ = NULL;
#line 75 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 75 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp0_ = self->priv->_context;
#line 75 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	result = _tmp0_;
#line 75 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	return result;
#line 2779 "rygel-root-device-factory.c"
}


static void rygel_root_device_factory_set_context (RygelRootDeviceFactory* self, GUPnPContext* value) {
	GUPnPContext* _tmp0_ = NULL;
	GUPnPContext* _tmp1_ = NULL;
#line 75 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_return_if_fail (self != NULL);
#line 75 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp0_ = value;
#line 75 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 75 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_object_unref0 (self->priv->_context);
#line 75 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	self->priv->_context = _tmp1_;
#line 75 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_object_notify ((GObject *) self, "context");
#line 2798 "rygel-root-device-factory.c"
}


static void rygel_root_device_factory_class_init (RygelRootDeviceFactoryClass * klass) {
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	rygel_root_device_factory_parent_class = g_type_class_peek_parent (klass);
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_type_class_add_private (klass, sizeof (RygelRootDeviceFactoryPrivate));
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_root_device_factory_get_property;
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_root_device_factory_set_property;
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_root_device_factory_finalize;
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_ROOT_DEVICE_FACTORY_CONTEXT, g_param_spec_object ("context", "context", "context", gupnp_context_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 2815 "rygel-root-device-factory.c"
}


static void rygel_root_device_factory_g_initable_interface_init (GInitableIface * iface) {
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	rygel_root_device_factory_g_initable_parent_iface = g_type_interface_peek_parent (iface);
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	iface->init = (gboolean (*)(GInitable*, GCancellable*, GError**)) rygel_root_device_factory_real_init;
#line 2824 "rygel-root-device-factory.c"
}


static void rygel_root_device_factory_instance_init (RygelRootDeviceFactory * self) {
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	self->priv = RYGEL_ROOT_DEVICE_FACTORY_GET_PRIVATE (self);
#line 2831 "rygel-root-device-factory.c"
}


static void rygel_root_device_factory_finalize (GObject* obj) {
	RygelRootDeviceFactory * self;
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory);
#line 75 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_object_unref0 (self->priv->_context);
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_object_unref0 (self->priv->config);
#line 79 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	_g_free0 (self->priv->desc_dir);
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	G_OBJECT_CLASS (rygel_root_device_factory_parent_class)->finalize (obj);
#line 2847 "rygel-root-device-factory.c"
}


/**
 * This is a factory to create #RygelRootDevice objects for
 * a given UPnP context.
 *
 * Call rygel_root_device_factory_create() with a plugin
 * to create a root device for the plugin.
 */
GType rygel_root_device_factory_get_type (void) {
	static volatile gsize rygel_root_device_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_root_device_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelRootDeviceFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_root_device_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelRootDeviceFactory), 0, (GInstanceInitFunc) rygel_root_device_factory_instance_init, NULL };
		static const GInterfaceInfo g_initable_info = { (GInterfaceInitFunc) rygel_root_device_factory_g_initable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_root_device_factory_type_id;
		rygel_root_device_factory_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelRootDeviceFactory", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_root_device_factory_type_id, G_TYPE_INITABLE, &g_initable_info);
		g_once_init_leave (&rygel_root_device_factory_type_id__volatile, rygel_root_device_factory_type_id);
	}
	return rygel_root_device_factory_type_id__volatile;
}


static void _vala_rygel_root_device_factory_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelRootDeviceFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory);
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	switch (property_id) {
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		case RYGEL_ROOT_DEVICE_FACTORY_CONTEXT:
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		g_value_set_object (value, rygel_root_device_factory_get_context (self));
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		break;
#line 2883 "rygel-root-device-factory.c"
		default:
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		break;
#line 2889 "rygel-root-device-factory.c"
	}
}


static void _vala_rygel_root_device_factory_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelRootDeviceFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory);
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
	switch (property_id) {
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		case RYGEL_ROOT_DEVICE_FACTORY_CONTEXT:
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		rygel_root_device_factory_set_context (self, g_value_get_object (value));
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		break;
#line 2905 "rygel-root-device-factory.c"
		default:
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-root-device-factory.vala"
		break;
#line 2911 "rygel-root-device-factory.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



