/* rygel-av-transport.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-av-transport.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009,2010 Nokia Corporation.
 * Copyright (C) 2012 Openismus GmbH.
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Neha Shanbhag <N.Shanbhag@cablelabs.com>
 *         Sivakumar Mani <siva@orexel.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <libgupnp-av/gupnp-av.h>
#include <rygel-core.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>


#define RYGEL_TYPE_AV_TRANSPORT (rygel_av_transport_get_type ())
#define RYGEL_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport))
#define RYGEL_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportClass))
#define RYGEL_IS_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AV_TRANSPORT))
#define RYGEL_IS_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AV_TRANSPORT))
#define RYGEL_AV_TRANSPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportClass))

typedef struct _RygelAVTransport RygelAVTransport;
typedef struct _RygelAVTransportClass RygelAVTransportClass;
typedef struct _RygelAVTransportPrivate RygelAVTransportPrivate;

#define RYGEL_TYPE_CHANGE_LOG (rygel_change_log_get_type ())
#define RYGEL_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLog))
#define RYGEL_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))
#define RYGEL_IS_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_IS_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_CHANGE_LOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))

typedef struct _RygelChangeLog RygelChangeLog;
typedef struct _RygelChangeLogClass RygelChangeLogClass;

#define RYGEL_TYPE_MEDIA_PLAYER (rygel_media_player_get_type ())
#define RYGEL_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayer))
#define RYGEL_IS_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_PLAYER))
#define RYGEL_MEDIA_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayerIface))

typedef struct _RygelMediaPlayer RygelMediaPlayer;
typedef struct _RygelMediaPlayerIface RygelMediaPlayerIface;

#define RYGEL_TYPE_PLAYER_CONTROLLER (rygel_player_controller_get_type ())
#define RYGEL_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerController))
#define RYGEL_IS_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAYER_CONTROLLER))
#define RYGEL_PLAYER_CONTROLLER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerControllerIface))

typedef struct _RygelPlayerController RygelPlayerController;
typedef struct _RygelPlayerControllerIface RygelPlayerControllerIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_MEDIA_RENDERER_PLUGIN (rygel_media_renderer_plugin_get_type ())
#define RYGEL_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPlugin))
#define RYGEL_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_MEDIA_RENDERER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))

typedef struct _RygelMediaRendererPlugin RygelMediaRendererPlugin;
typedef struct _RygelMediaRendererPluginClass RygelMediaRendererPluginClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_GUPnPServiceAction_free0(var) ((var == NULL) ? NULL : (var = (_vala_GUPnPServiceAction_free (var), NULL)))
typedef struct _Block2Data Block2Data;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _RygelAvTransportHandlePlaylistData RygelAvTransportHandlePlaylistData;
typedef struct _Block3Data Block3Data;

struct _RygelAVTransport {
	GUPnPService parent_instance;
	RygelAVTransportPrivate * priv;
};

struct _RygelAVTransportClass {
	GUPnPServiceClass parent_class;
};

struct _RygelMediaPlayerIface {
	GTypeInterface parent_iface;
	gboolean (*seek) (RygelMediaPlayer* self, gint64 time);
	gboolean (*seek_bytes) (RygelMediaPlayer* self, gint64 bytes);
	gchar** (*get_protocols) (RygelMediaPlayer* self, int* result_length1);
	gchar** (*get_mime_types) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_state) (RygelMediaPlayer* self);
	void (*set_playback_state) (RygelMediaPlayer* self, const gchar* value);
	gchar** (*get_allowed_playback_speeds) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_speed) (RygelMediaPlayer* self);
	void (*set_playback_speed) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_uri) (RygelMediaPlayer* self);
	void (*set_uri) (RygelMediaPlayer* self, const gchar* value);
	gdouble (*get_volume) (RygelMediaPlayer* self);
	void (*set_volume) (RygelMediaPlayer* self, gdouble value);
	gint64 (*get_duration) (RygelMediaPlayer* self);
	gint64 (*get_size) (RygelMediaPlayer* self);
	gchar* (*get_metadata) (RygelMediaPlayer* self);
	void (*set_metadata) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_mime_type) (RygelMediaPlayer* self);
	void (*set_mime_type) (RygelMediaPlayer* self, const gchar* value);
	gboolean (*get_can_seek) (RygelMediaPlayer* self);
	gboolean (*get_can_seek_bytes) (RygelMediaPlayer* self);
	gchar* (*get_content_features) (RygelMediaPlayer* self);
	void (*set_content_features) (RygelMediaPlayer* self, const gchar* value);
	gint64 (*get_position) (RygelMediaPlayer* self);
	gint64 (*get_byte_position) (RygelMediaPlayer* self);
};

struct _RygelPlayerControllerIface {
	GTypeInterface parent_iface;
	gboolean (*next) (RygelPlayerController* self);
	gboolean (*previous) (RygelPlayerController* self);
	void (*set_single_play_uri) (RygelPlayerController* self, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features);
	void (*set_playlist_uri) (RygelPlayerController* self, const gchar* uri, const gchar* metadata, GUPnPMediaCollection* collection);
	void (*set_next_single_play_uri) (RygelPlayerController* self, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features);
	void (*set_next_playlist_uri) (RygelPlayerController* self, const gchar* uri, const gchar* metadata, GUPnPMediaCollection* collection);
	gboolean (*is_play_mode_valid) (RygelPlayerController* self, const gchar* play_mode);
	const gchar* (*get_playback_state) (RygelPlayerController* self);
	void (*set_playback_state) (RygelPlayerController* self, const gchar* value);
	guint (*get_n_tracks) (RygelPlayerController* self);
	void (*set_n_tracks) (RygelPlayerController* self, guint value);
	guint (*get_track) (RygelPlayerController* self);
	void (*set_track) (RygelPlayerController* self, guint value);
	gchar* (*get_uri) (RygelPlayerController* self);
	void (*set_uri) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_metadata) (RygelPlayerController* self);
	void (*set_metadata) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_track_uri) (RygelPlayerController* self);
	void (*set_track_uri) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_track_metadata) (RygelPlayerController* self);
	void (*set_track_metadata) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_next_uri) (RygelPlayerController* self);
	void (*set_next_uri) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_next_metadata) (RygelPlayerController* self);
	void (*set_next_metadata) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_current_transport_actions) (RygelPlayerController* self);
	const gchar* (*get_play_mode) (RygelPlayerController* self);
	void (*set_play_mode) (RygelPlayerController* self, const gchar* value);
};

struct _RygelAVTransportPrivate {
	SoupSession* session;
	gchar* protocol_info;
	gchar* _status;
	RygelChangeLog* changelog;
	RygelMediaPlayer* player;
	RygelPlayerController* controller;
	gboolean head_faked;
};

struct _Block2Data {
	int _ref_count_;
	RygelAVTransport* self;
	gpointer _async_data_;
};

struct _RygelAvTransportHandlePlaylistData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelAVTransport* self;
	GUPnPServiceAction* action;
	gchar* uri;
	gchar* metadata;
	gchar* mime;
	gchar* features;
	Block2Data* _data2_;
	SoupMessage* message;
	const gchar* _tmp0_;
	SoupMessage* _tmp1_;
	SoupSession* _tmp2_;
	SoupMessage* _tmp3_;
	SoupMessage* _tmp4_;
	SoupMessage* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	GUPnPServiceAction* _tmp8_;
	const gchar* _tmp9_;
	gchar* content_type;
	SoupMessage* _tmp10_;
	SoupMessageHeaders* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	GUPnPMediaCollection* collection;
	const gchar* _tmp14_;
	gboolean _tmp15_;
	GUPnPMediaCollection* _tmp16_;
	GMemoryInputStream* m_stream;
	SoupMessage* _tmp17_;
	SoupMessageBody* _tmp18_;
	guint8* _tmp19_;
	gint _tmp19__length1;
	guint8* _tmp20_;
	gint _tmp20__length1;
	GMemoryInputStream* _tmp21_;
	GDataInputStream* stream;
	GMemoryInputStream* _tmp22_;
	GDataInputStream* _tmp23_;
	gsize length;
	gchar* line;
	GDataInputStream* _tmp24_;
	gsize _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	gboolean _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gboolean _tmp31_;
	gchar* _tmp32_;
	GDataInputStream* _tmp33_;
	gsize _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	GUPnPDIDLLiteItem* item;
	GUPnPMediaCollection* _tmp39_;
	GUPnPDIDLLiteItem* _tmp40_;
	GUPnPDIDLLiteItem* _tmp41_;
	GUPnPDIDLLiteResource* resource;
	GUPnPDIDLLiteItem* _tmp42_;
	GUPnPDIDLLiteResource* _tmp43_;
	GUPnPProtocolInfo* pi;
	GUPnPProtocolInfo* _tmp44_;
	GUPnPDIDLLiteResource* _tmp45_;
	GUPnPProtocolInfo* _tmp46_;
	GUPnPDIDLLiteResource* _tmp47_;
	const gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	GDataInputStream* _tmp52_;
	gsize _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	GError* _error_;
	const gchar* _tmp56_;
	GError* _tmp57_;
	const gchar* _tmp58_;
	GUPnPServiceAction* _tmp59_;
	const gchar* _tmp60_;
	const gchar* xml_string;
	SoupMessage* _tmp61_;
	SoupMessageBody* _tmp62_;
	guint8* _tmp63_;
	gint _tmp63__length1;
	const gchar* _tmp64_;
	GUPnPMediaCollection* _tmp65_;
	GUPnPMediaCollection* _tmp66_;
	GList* _tmp67_;
	GList* _tmp68_;
	guint _tmp69_;
	gboolean _tmp70_;
	GUPnPServiceAction* _tmp71_;
	const gchar* _tmp72_;
	GUPnPServiceAction* _tmp73_;
	const gchar* _tmp74_;
	const gchar* _tmp75_;
	GQuark _tmp77_;
	RygelPlayerController* _tmp78_;
	const gchar* _tmp79_;
	const gchar* _tmp80_;
	GUPnPMediaCollection* _tmp81_;
	RygelPlayerController* _tmp82_;
	const gchar* _tmp83_;
	const gchar* _tmp84_;
	GUPnPMediaCollection* _tmp85_;
	GUPnPServiceAction* _tmp86_;
	GError * _inner_error_;
};

struct _Block3Data {
	int _ref_count_;
	RygelAVTransport* self;
	GUPnPServiceAction* action;
	gchar* uri;
	gchar* metadata;
};


static gpointer rygel_av_transport_parent_class = NULL;

GType rygel_av_transport_get_type (void) G_GNUC_CONST;
GType rygel_change_log_get_type (void) G_GNUC_CONST;
GType rygel_media_player_get_type (void) G_GNUC_CONST;
GType rygel_player_controller_get_type (void) G_GNUC_CONST;
#define RYGEL_AV_TRANSPORT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportPrivate))
enum  {
	RYGEL_AV_TRANSPORT_DUMMY_PROPERTY,
	RYGEL_AV_TRANSPORT_STATUS,
	RYGEL_AV_TRANSPORT_PLAYBACK_MEDIUM,
	RYGEL_AV_TRANSPORT_SPEED
};
#define RYGEL_AV_TRANSPORT_UPNP_ID "urn:upnp-org:serviceId:AVTransport"
#define RYGEL_AV_TRANSPORT_UPNP_TYPE "urn:schemas-upnp-org:service:AVTransport:2"
#define RYGEL_AV_TRANSPORT_UPNP_TYPE_V1 "urn:schemas-upnp-org:service:AVTransport:1"
#define RYGEL_AV_TRANSPORT_DESCRIPTION_PATH "xml/AVTransport2.xml"
#define RYGEL_AV_TRANSPORT_LAST_CHANGE_NS "urn:schemas-upnp-org:metadata-1-0/AVT/"
static void rygel_av_transport_real_constructed (GObject* base);
GType rygel_media_renderer_plugin_get_type (void) G_GNUC_CONST;
RygelChangeLog* rygel_change_log_new (GUPnPService* service, const gchar* service_ns);
RygelChangeLog* rygel_change_log_construct (GType object_type, GUPnPService* service, const gchar* service_ns);
static RygelMediaPlayer* rygel_av_transport_get_player (RygelAVTransport* self);
RygelPlayerController* rygel_media_renderer_plugin_get_controller (RygelMediaRendererPlugin* self);
static void rygel_av_transport_query_last_change_cb (RygelAVTransport* self, GUPnPService* service, const gchar* variable, GValue* value);
static void _rygel_av_transport_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_av_transport_set_av_transport_uri_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_set_next_av_transport_uri_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_set_next_av_transport_uri_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_media_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_media_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_media_info_ex_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_media_info_ex_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_transport_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_transport_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_position_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_position_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_device_capabilities_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_transport_settings_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_transport_settings_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_transport_actions_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_transport_actions_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_stop_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_stop_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_play_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_play_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_pause_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_pause_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_seek_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_seek_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_next_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_next_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_previous_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_previous_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_x_dlna_get_byte_position_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_x_dlna_get_byte_position_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_set_play_mode_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_set_play_mode_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_notify_state_cb (RygelAVTransport* self, GObject* controller, GParamSpec* p);
static void _rygel_av_transport_notify_state_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_n_tracks_cb (RygelAVTransport* self, GObject* controller, GParamSpec* p);
static void _rygel_av_transport_notify_n_tracks_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_track_cb (RygelAVTransport* self, GObject* controller, GParamSpec* p);
static void _rygel_av_transport_notify_track_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_uri_cb (RygelAVTransport* self, GObject* controller, GParamSpec* p);
static void _rygel_av_transport_notify_uri_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_meta_data_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_meta_data_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_track_uri_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_track_uri_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_track_meta_data_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_track_meta_data_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_next_uri_cb (RygelAVTransport* self, GObject* controller, GParamSpec* p);
static void _rygel_av_transport_notify_next_uri_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_next_meta_data_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_next_meta_data_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_play_mode_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_play_mode_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_duration_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_duration_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gchar* rygel_media_renderer_plugin_get_protocol_info (RygelMediaRendererPlugin* self);
RygelMediaPlayer* rygel_media_renderer_plugin_get_player (RygelMediaRendererPlugin* self);
void rygel_change_log_log (RygelChangeLog* self, const gchar* variable, const gchar* value);
const gchar* rygel_player_controller_get_playback_state (RygelPlayerController* self);
gchar* rygel_player_controller_get_current_transport_actions (RygelPlayerController* self);
const gchar* rygel_av_transport_get_status (RygelAVTransport* self);
const gchar* rygel_av_transport_get_playback_medium (RygelAVTransport* self);
const gchar* rygel_player_controller_get_play_mode (RygelPlayerController* self);
gchar* rygel_media_player_get_playback_speed (RygelMediaPlayer* self);
guint rygel_player_controller_get_n_tracks (RygelPlayerController* self);
guint rygel_player_controller_get_track (RygelPlayerController* self);
gchar* rygel_media_player_get_duration_as_str (RygelMediaPlayer* self);
gchar* rygel_player_controller_get_uri (RygelPlayerController* self);
gchar* rygel_player_controller_get_metadata (RygelPlayerController* self);
gchar* rygel_player_controller_get_track_uri (RygelPlayerController* self);
gchar* rygel_player_controller_get_track_metadata (RygelPlayerController* self);
gchar* rygel_player_controller_get_next_uri (RygelPlayerController* self);
gchar* rygel_player_controller_get_next_metadata (RygelPlayerController* self);
gchar* rygel_change_log_finish (RygelChangeLog* self);
static gboolean rygel_av_transport_check_instance_id (RygelAVTransport* self, GUPnPServiceAction* action);
static void rygel_av_transport_handle_new_transport_uri (RygelAVTransport* self, GUPnPServiceAction* action, const gchar* uri, const gchar* metadata);
static gboolean rygel_av_transport_is_valid_mime_type (RygelAVTransport* self, const gchar* mime);
gchar** rygel_media_player_get_mime_types (RygelMediaPlayer* self, int* result_length1);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
gchar* rygel_media_player_get_position_as_str (RygelMediaPlayer* self);
gint64 rygel_media_player_get_byte_position (RygelMediaPlayer* self);
void rygel_player_controller_set_playback_state (RygelPlayerController* self, const gchar* value);
gchar** rygel_media_player_get_allowed_playback_speeds (RygelMediaPlayer* self, int* result_length1);
void rygel_media_player_set_playback_speed (RygelMediaPlayer* self, const gchar* value);
gint64 rygel_time_utils_time_from_string (const gchar* str);
gboolean rygel_media_player_get_can_seek (RygelMediaPlayer* self);
gboolean rygel_media_player_seek (RygelMediaPlayer* self, gint64 time);
gboolean rygel_media_player_get_can_seek_bytes (RygelMediaPlayer* self);
gboolean rygel_media_player_seek_bytes (RygelMediaPlayer* self, gint64 bytes);
void rygel_player_controller_set_track (RygelPlayerController* self, guint value);
gboolean rygel_player_controller_next (RygelPlayerController* self);
gboolean rygel_player_controller_previous (RygelPlayerController* self);
gint64 rygel_media_player_get_size (RygelMediaPlayer* self);
gboolean rygel_player_controller_is_play_mode_valid (RygelPlayerController* self, const gchar* play_mode);
void rygel_player_controller_set_play_mode (RygelPlayerController* self, const gchar* value);
static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self);
static void rygel_av_transport_handle_playlist_data_free (gpointer _data);
static GUPnPServiceAction* _vala_GUPnPServiceAction_copy (GUPnPServiceAction* self);
static void rygel_av_transport_handle_playlist (RygelAVTransport* self, GUPnPServiceAction* action, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_av_transport_handle_playlist_finish (RygelAVTransport* self, GAsyncResult* _res_);
static gboolean rygel_av_transport_handle_playlist_co (RygelAvTransportHandlePlaylistData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda9_ (Block2Data* _data2_);
static void ___lambda9__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static guint8* _vala_array_dup1 (guint8* self, int length);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void rygel_player_controller_set_playlist_uri (RygelPlayerController* self, const gchar* uri, const gchar* metadata, GUPnPMediaCollection* collection);
void rygel_player_controller_set_next_playlist_uri (RygelPlayerController* self, const gchar* uri, const gchar* metadata, GUPnPMediaCollection* collection);
static gboolean rygel_av_transport_is_playlist (RygelAVTransport* self, const gchar* mime, const gchar* features);
static void rygel_av_transport_check_resource (RygelAVTransport* self, SoupMessage* msg, const gchar* _uri, const gchar* _metadata, GUPnPServiceAction* action);
static void ___lambda8_ (RygelAVTransport* self, SoupMessage* msg);
static void ____lambda8__soup_message_got_headers (SoupMessage* _sender, gpointer self);
static void rygel_av_transport_set_single_play_uri (RygelAVTransport* self, GUPnPServiceAction* action, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ___lambda7_ (Block3Data* _data3_, SoupMessage* msg);
static void ____lambda7__soup_message_finished (SoupMessage* _sender, gpointer self);
void rygel_player_controller_set_single_play_uri (RygelPlayerController* self, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features);
void rygel_player_controller_set_next_single_play_uri (RygelPlayerController* self, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features);
RygelAVTransport* rygel_av_transport_new (void);
RygelAVTransport* rygel_av_transport_construct (GType object_type);
void rygel_av_transport_set_status (RygelAVTransport* self, const gchar* value);
gchar* rygel_av_transport_get_speed (RygelAVTransport* self);
void rygel_av_transport_set_speed (RygelAVTransport* self, const gchar* value);
static void rygel_av_transport_finalize (GObject* obj);
static void _vala_rygel_av_transport_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_av_transport_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
#line 86 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return self ? g_object_ref (self) : NULL;
#line 477 "rygel-av-transport.c"
}


static void _rygel_av_transport_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 92 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_query_last_change_cb ((RygelAVTransport*) self, _sender, variable, value);
#line 484 "rygel-av-transport.c"
}


static void _rygel_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 94 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_set_av_transport_uri_cb ((RygelAVTransport*) self, _sender, action);
#line 491 "rygel-av-transport.c"
}


static void _rygel_av_transport_set_next_av_transport_uri_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 96 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_set_next_av_transport_uri_cb ((RygelAVTransport*) self, _sender, action);
#line 498 "rygel-av-transport.c"
}


static void _rygel_av_transport_get_media_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 98 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_get_media_info_cb ((RygelAVTransport*) self, _sender, action);
#line 505 "rygel-av-transport.c"
}


static void _rygel_av_transport_get_media_info_ex_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_get_media_info_ex_cb ((RygelAVTransport*) self, _sender, action);
#line 512 "rygel-av-transport.c"
}


static void _rygel_av_transport_get_transport_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 100 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_get_transport_info_cb ((RygelAVTransport*) self, _sender, action);
#line 519 "rygel-av-transport.c"
}


static void _rygel_av_transport_get_position_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 101 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_get_position_info_cb ((RygelAVTransport*) self, _sender, action);
#line 526 "rygel-av-transport.c"
}


static void _rygel_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 102 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_get_device_capabilities_cb ((RygelAVTransport*) self, _sender, action);
#line 533 "rygel-av-transport.c"
}


static void _rygel_av_transport_get_transport_settings_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 104 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_get_transport_settings_cb ((RygelAVTransport*) self, _sender, action);
#line 540 "rygel-av-transport.c"
}


static void _rygel_av_transport_get_transport_actions_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 106 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_get_transport_actions_cb ((RygelAVTransport*) self, _sender, action);
#line 547 "rygel-av-transport.c"
}


static void _rygel_av_transport_stop_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 108 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_stop_cb ((RygelAVTransport*) self, _sender, action);
#line 554 "rygel-av-transport.c"
}


static void _rygel_av_transport_play_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 109 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_play_cb ((RygelAVTransport*) self, _sender, action);
#line 561 "rygel-av-transport.c"
}


static void _rygel_av_transport_pause_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 110 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_pause_cb ((RygelAVTransport*) self, _sender, action);
#line 568 "rygel-av-transport.c"
}


static void _rygel_av_transport_seek_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 111 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_seek_cb ((RygelAVTransport*) self, _sender, action);
#line 575 "rygel-av-transport.c"
}


static void _rygel_av_transport_next_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_next_cb ((RygelAVTransport*) self, _sender, action);
#line 582 "rygel-av-transport.c"
}


static void _rygel_av_transport_previous_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 113 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_previous_cb ((RygelAVTransport*) self, _sender, action);
#line 589 "rygel-av-transport.c"
}


static void _rygel_av_transport_x_dlna_get_byte_position_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 114 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_x_dlna_get_byte_position_info_cb ((RygelAVTransport*) self, _sender, action);
#line 596 "rygel-av-transport.c"
}


static void _rygel_av_transport_set_play_mode_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 116 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_set_play_mode_cb ((RygelAVTransport*) self, _sender, action);
#line 603 "rygel-av-transport.c"
}


static void _rygel_av_transport_notify_state_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 118 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_notify_state_cb ((RygelAVTransport*) self, _sender, pspec);
#line 610 "rygel-av-transport.c"
}


static void _rygel_av_transport_notify_n_tracks_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 119 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_notify_n_tracks_cb ((RygelAVTransport*) self, _sender, pspec);
#line 617 "rygel-av-transport.c"
}


static void _rygel_av_transport_notify_track_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 120 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_notify_track_cb ((RygelAVTransport*) self, _sender, pspec);
#line 624 "rygel-av-transport.c"
}


static void _rygel_av_transport_notify_uri_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 121 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_notify_uri_cb ((RygelAVTransport*) self, _sender, pspec);
#line 631 "rygel-av-transport.c"
}


static void _rygel_av_transport_notify_meta_data_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 122 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_notify_meta_data_cb ((RygelAVTransport*) self, _sender, pspec);
#line 638 "rygel-av-transport.c"
}


static void _rygel_av_transport_notify_track_uri_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 123 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_notify_track_uri_cb ((RygelAVTransport*) self, _sender, pspec);
#line 645 "rygel-av-transport.c"
}


static void _rygel_av_transport_notify_track_meta_data_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 124 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_notify_track_meta_data_cb ((RygelAVTransport*) self, _sender, pspec);
#line 652 "rygel-av-transport.c"
}


static void _rygel_av_transport_notify_next_uri_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 125 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_notify_next_uri_cb ((RygelAVTransport*) self, _sender, pspec);
#line 659 "rygel-av-transport.c"
}


static void _rygel_av_transport_notify_next_meta_data_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 126 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_notify_next_meta_data_cb ((RygelAVTransport*) self, _sender, pspec);
#line 666 "rygel-av-transport.c"
}


static void _rygel_av_transport_notify_play_mode_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 127 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_notify_play_mode_cb ((RygelAVTransport*) self, _sender, pspec);
#line 673 "rygel-av-transport.c"
}


static void _rygel_av_transport_notify_duration_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 129 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_notify_duration_cb ((RygelAVTransport*) self, _sender, pspec);
#line 680 "rygel-av-transport.c"
}


static void rygel_av_transport_real_constructed (GObject* base) {
	RygelAVTransport * self;
	RygelMediaRendererPlugin* plugin = NULL;
	GUPnPRootDevice* _tmp0_ = NULL;
	GUPnPRootDevice* _tmp1_ = NULL;
	GUPnPRootDevice* _tmp2_ = NULL;
	GUPnPResourceFactory* _tmp3_ = NULL;
	GUPnPResourceFactory* _tmp4_ = NULL;
	RygelMediaRendererPlugin* _tmp5_ = NULL;
	RygelMediaRendererPlugin* _tmp6_ = NULL;
	RygelChangeLog* _tmp7_ = NULL;
	RygelMediaPlayer* _tmp8_ = NULL;
	RygelPlayerController* _tmp9_ = NULL;
	RygelPlayerController* _tmp10_ = NULL;
	RygelPlayerController* _tmp11_ = NULL;
	RygelPlayerController* _tmp12_ = NULL;
	RygelPlayerController* _tmp13_ = NULL;
	RygelPlayerController* _tmp14_ = NULL;
	RygelPlayerController* _tmp15_ = NULL;
	RygelPlayerController* _tmp16_ = NULL;
	RygelPlayerController* _tmp17_ = NULL;
	RygelPlayerController* _tmp18_ = NULL;
	RygelPlayerController* _tmp19_ = NULL;
	RygelMediaPlayer* _tmp20_ = NULL;
	SoupSession* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
#line 84 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self = (RygelAVTransport*) base;
#line 85 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	G_OBJECT_CLASS (rygel_av_transport_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gupnp_service_get_type (), GUPnPService));
#line 86 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_get ((GUPnPService*) self, "root-device", &_tmp0_, NULL);
#line 86 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = _tmp0_;
#line 86 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = _tmp1_;
#line 86 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp2_);
#line 86 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 86 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_MEDIA_RENDERER_PLUGIN) ? ((RygelMediaRendererPlugin*) _tmp4_) : NULL);
#line 86 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = _tmp5_;
#line 86 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (_tmp2_);
#line 86 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	plugin = _tmp6_;
#line 88 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = rygel_change_log_new ((GUPnPService*) self, RYGEL_AV_TRANSPORT_LAST_CHANGE_NS);
#line 88 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (self->priv->changelog);
#line 88 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->changelog = _tmp7_;
#line 89 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp8_ = rygel_av_transport_get_player (self);
#line 89 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (self->priv->player);
#line 89 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->player = _tmp8_;
#line 90 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = rygel_media_renderer_plugin_get_controller (plugin);
#line 90 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (self->priv->controller);
#line 90 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->controller = _tmp9_;
#line 92 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::LastChange", (GCallback) _rygel_av_transport_query_last_change_cb_gupnp_service_query_variable, self, 0);
#line 94 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SetAVTransportURI", (GCallback) _rygel_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked, self, 0);
#line 96 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SetNextAVTransportURI", (GCallback) _rygel_av_transport_set_next_av_transport_uri_cb_gupnp_service_action_invoked, self, 0);
#line 98 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetMediaInfo", (GCallback) _rygel_av_transport_get_media_info_cb_gupnp_service_action_invoked, self, 0);
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetMediaInfo_Ext", (GCallback) _rygel_av_transport_get_media_info_ex_cb_gupnp_service_action_invoked, self, 0);
#line 100 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTransportInfo", (GCallback) _rygel_av_transport_get_transport_info_cb_gupnp_service_action_invoked, self, 0);
#line 101 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetPositionInfo", (GCallback) _rygel_av_transport_get_position_info_cb_gupnp_service_action_invoked, self, 0);
#line 102 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetDeviceCapabilities", (GCallback) _rygel_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked, self, 0);
#line 104 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTransportSettings", (GCallback) _rygel_av_transport_get_transport_settings_cb_gupnp_service_action_invoked, self, 0);
#line 106 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetCurrentTransportActions", (GCallback) _rygel_av_transport_get_transport_actions_cb_gupnp_service_action_invoked, self, 0);
#line 108 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Stop", (GCallback) _rygel_av_transport_stop_cb_gupnp_service_action_invoked, self, 0);
#line 109 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Play", (GCallback) _rygel_av_transport_play_cb_gupnp_service_action_invoked, self, 0);
#line 110 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Pause", (GCallback) _rygel_av_transport_pause_cb_gupnp_service_action_invoked, self, 0);
#line 111 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Seek", (GCallback) _rygel_av_transport_seek_cb_gupnp_service_action_invoked, self, 0);
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Next", (GCallback) _rygel_av_transport_next_cb_gupnp_service_action_invoked, self, 0);
#line 113 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Previous", (GCallback) _rygel_av_transport_previous_cb_gupnp_service_action_invoked, self, 0);
#line 114 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::X_DLNA_GetBytePositionInfo", (GCallback) _rygel_av_transport_x_dlna_get_byte_position_info_cb_gupnp_service_action_invoked, self, 0);
#line 116 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SetPlayMode", (GCallback) _rygel_av_transport_set_play_mode_cb_gupnp_service_action_invoked, self, 0);
#line 118 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp10_ = self->priv->controller;
#line 118 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GObject*) _tmp10_, "notify::playback-state", (GCallback) _rygel_av_transport_notify_state_cb_g_object_notify, self, 0);
#line 119 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp11_ = self->priv->controller;
#line 119 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GObject*) _tmp11_, "notify::n-tracks", (GCallback) _rygel_av_transport_notify_n_tracks_cb_g_object_notify, self, 0);
#line 120 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp12_ = self->priv->controller;
#line 120 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GObject*) _tmp12_, "notify::track", (GCallback) _rygel_av_transport_notify_track_cb_g_object_notify, self, 0);
#line 121 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp13_ = self->priv->controller;
#line 121 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GObject*) _tmp13_, "notify::uri", (GCallback) _rygel_av_transport_notify_uri_cb_g_object_notify, self, 0);
#line 122 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp14_ = self->priv->controller;
#line 122 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GObject*) _tmp14_, "notify::metadata", (GCallback) _rygel_av_transport_notify_meta_data_cb_g_object_notify, self, 0);
#line 123 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp15_ = self->priv->controller;
#line 123 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GObject*) _tmp15_, "notify::track-uri", (GCallback) _rygel_av_transport_notify_track_uri_cb_g_object_notify, self, 0);
#line 124 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp16_ = self->priv->controller;
#line 124 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GObject*) _tmp16_, "notify::track-metadata", (GCallback) _rygel_av_transport_notify_track_meta_data_cb_g_object_notify, self, 0);
#line 125 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp17_ = self->priv->controller;
#line 125 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GObject*) _tmp17_, "notify::next-uri", (GCallback) _rygel_av_transport_notify_next_uri_cb_g_object_notify, self, 0);
#line 126 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp18_ = self->priv->controller;
#line 126 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GObject*) _tmp18_, "notify::next-metadata", (GCallback) _rygel_av_transport_notify_next_meta_data_cb_g_object_notify, self, 0);
#line 127 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp19_ = self->priv->controller;
#line 127 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GObject*) _tmp19_, "notify::play-mode", (GCallback) _rygel_av_transport_notify_play_mode_cb_g_object_notify, self, 0);
#line 129 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp20_ = self->priv->player;
#line 129 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GObject*) _tmp20_, "notify::duration", (GCallback) _rygel_av_transport_notify_duration_cb_g_object_notify, self, 0);
#line 131 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp21_ = soup_session_new ();
#line 131 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (self->priv->session);
#line 131 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->session = _tmp21_;
#line 133 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp22_ = rygel_media_renderer_plugin_get_protocol_info (plugin);
#line 133 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (self->priv->protocol_info);
#line 133 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->protocol_info = _tmp22_;
#line 84 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (plugin);
#line 844 "rygel-av-transport.c"
}


static RygelMediaPlayer* rygel_av_transport_get_player (RygelAVTransport* self) {
	RygelMediaPlayer* result = NULL;
	RygelMediaRendererPlugin* plugin = NULL;
	GUPnPRootDevice* _tmp0_ = NULL;
	GUPnPRootDevice* _tmp1_ = NULL;
	GUPnPRootDevice* _tmp2_ = NULL;
	GUPnPResourceFactory* _tmp3_ = NULL;
	GUPnPResourceFactory* _tmp4_ = NULL;
	RygelMediaRendererPlugin* _tmp5_ = NULL;
	RygelMediaRendererPlugin* _tmp6_ = NULL;
	RygelMediaPlayer* _tmp7_ = NULL;
#line 136 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_get ((GUPnPService*) self, "root-device", &_tmp0_, NULL);
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = _tmp0_;
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = _tmp1_;
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp2_);
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_MEDIA_RENDERER_PLUGIN) ? ((RygelMediaRendererPlugin*) _tmp4_) : NULL);
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = _tmp5_;
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (_tmp2_);
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	plugin = _tmp6_;
#line 139 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = rygel_media_renderer_plugin_get_player (plugin);
#line 139 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	result = _tmp7_;
#line 139 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (plugin);
#line 139 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return result;
#line 887 "rygel-av-transport.c"
}


static void rygel_av_transport_query_last_change_cb (RygelAVTransport* self, GUPnPService* service, const gchar* variable, GValue* value) {
	RygelChangeLog* log = NULL;
	RygelChangeLog* _tmp0_ = NULL;
	RygelPlayerController* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	RygelPlayerController* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	RygelPlayerController* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	RygelMediaPlayer* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	RygelPlayerController* _tmp19_ = NULL;
	guint _tmp20_ = 0U;
	guint _tmp21_ = 0U;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	RygelPlayerController* _tmp24_ = NULL;
	guint _tmp25_ = 0U;
	guint _tmp26_ = 0U;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	RygelMediaPlayer* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	RygelMediaPlayer* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	RygelPlayerController* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	RygelPlayerController* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	RygelPlayerController* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	RygelPlayerController* _tmp51_ = NULL;
	gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	gchar* _tmp54_ = NULL;
	gchar* _tmp55_ = NULL;
	gchar* _tmp56_ = NULL;
	RygelPlayerController* _tmp57_ = NULL;
	gchar* _tmp58_ = NULL;
	gchar* _tmp59_ = NULL;
	gchar* _tmp60_ = NULL;
	RygelPlayerController* _tmp61_ = NULL;
	gchar* _tmp62_ = NULL;
	gchar* _tmp63_ = NULL;
	gchar* _tmp64_ = NULL;
	gchar* _tmp65_ = NULL;
	gchar* _tmp66_ = NULL;
	gchar* _tmp67_ = NULL;
	gchar* _tmp68_ = NULL;
#line 142 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 142 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 142 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (variable != NULL);
#line 142 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (value != NULL);
#line 146 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = rygel_change_log_new (NULL, RYGEL_AV_TRANSPORT_LAST_CHANGE_NS);
#line 146 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	log = _tmp0_;
#line 148 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = self->priv->controller;
#line 148 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = rygel_player_controller_get_playback_state (_tmp1_);
#line 148 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 148 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "TransportState", _tmp3_);
#line 149 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = self->priv->controller;
#line 149 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = rygel_player_controller_get_current_transport_actions (_tmp4_);
#line 149 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = _tmp5_;
#line 149 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = _tmp6_;
#line 149 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentTransportActions", _tmp7_);
#line 149 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp7_);
#line 151 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp8_ = rygel_av_transport_get_status (self);
#line 151 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = _tmp8_;
#line 151 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "TransportStatus", _tmp9_);
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp10_ = rygel_av_transport_get_playback_medium (self);
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp11_ = _tmp10_;
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "PlaybackStorageMedium", _tmp11_);
#line 153 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "RecordStorageMedium", "NOT_IMPLEMENTED");
#line 154 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "PossiblePlaybackStorageMedia", "None,Network");
#line 155 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "PossibleRecordStorageMedia", "NOT_IMPLEMENTED");
#line 156 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp12_ = self->priv->controller;
#line 156 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp13_ = rygel_player_controller_get_play_mode (_tmp12_);
#line 156 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp14_ = _tmp13_;
#line 156 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentPlayMode", _tmp14_);
#line 157 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp15_ = self->priv->player;
#line 157 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp16_ = rygel_media_player_get_playback_speed (_tmp15_);
#line 157 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp17_ = _tmp16_;
#line 157 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp18_ = _tmp17_;
#line 157 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "TransportPlaySpeed", _tmp18_);
#line 157 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp18_);
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "RecordMediumWriteStatus", "NOT_IMPLEMENTED");
#line 159 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentRecordQualityMode", "NOT_IMPLEMENTED");
#line 160 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "PossibleRecordQualityModes", "NOT_IMPLEMENTED");
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp19_ = self->priv->controller;
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp20_ = rygel_player_controller_get_n_tracks (_tmp19_);
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp21_ = _tmp20_;
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp22_ = g_strdup_printf ("%u", _tmp21_);
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp23_ = _tmp22_;
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "NumberOfTracks", _tmp23_);
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp23_);
#line 162 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp24_ = self->priv->controller;
#line 162 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp25_ = rygel_player_controller_get_track (_tmp24_);
#line 162 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp26_ = _tmp25_;
#line 162 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp27_ = g_strdup_printf ("%u", _tmp26_);
#line 162 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp28_ = _tmp27_;
#line 162 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentTrack", _tmp28_);
#line 162 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp28_);
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp29_ = self->priv->player;
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp30_ = rygel_media_player_get_duration_as_str (_tmp29_);
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp31_ = _tmp30_;
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp32_ = _tmp31_;
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentTrackDuration", _tmp32_);
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp32_);
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp33_ = self->priv->player;
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp34_ = rygel_media_player_get_duration_as_str (_tmp33_);
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp35_ = _tmp34_;
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp36_ = _tmp35_;
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentMediaDuration", _tmp36_);
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp36_);
#line 165 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp37_ = self->priv->controller;
#line 165 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp38_ = rygel_player_controller_get_uri (_tmp37_);
#line 165 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp39_ = _tmp38_;
#line 165 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp40_ = _tmp39_;
#line 165 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "AVTransportURI", _tmp40_);
#line 165 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp40_);
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp41_ = self->priv->controller;
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp42_ = rygel_player_controller_get_metadata (_tmp41_);
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp43_ = _tmp42_;
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp44_ = _tmp43_;
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp45_ = g_markup_escape_text (_tmp44_, (gssize) (-1));
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp46_ = _tmp45_;
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "AVTransportURIMetaData", _tmp46_);
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp46_);
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp44_);
#line 168 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp47_ = self->priv->controller;
#line 168 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp48_ = rygel_player_controller_get_track_uri (_tmp47_);
#line 168 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp49_ = _tmp48_;
#line 168 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp50_ = _tmp49_;
#line 168 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentTrackURI", _tmp50_);
#line 168 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp50_);
#line 169 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp51_ = self->priv->controller;
#line 169 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp52_ = rygel_player_controller_get_track_metadata (_tmp51_);
#line 169 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp53_ = _tmp52_;
#line 169 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp54_ = _tmp53_;
#line 169 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp55_ = g_markup_escape_text (_tmp54_, (gssize) (-1));
#line 169 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp56_ = _tmp55_;
#line 169 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentTrackMetaData", _tmp56_);
#line 169 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp56_);
#line 169 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp54_);
#line 171 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp57_ = self->priv->controller;
#line 171 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp58_ = rygel_player_controller_get_next_uri (_tmp57_);
#line 171 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp59_ = _tmp58_;
#line 171 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp60_ = _tmp59_;
#line 171 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "NextAVTransportURI", _tmp60_);
#line 171 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp60_);
#line 172 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp61_ = self->priv->controller;
#line 172 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp62_ = rygel_player_controller_get_next_metadata (_tmp61_);
#line 172 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp63_ = _tmp62_;
#line 172 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp64_ = _tmp63_;
#line 172 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp65_ = g_markup_escape_text (_tmp64_, (gssize) (-1));
#line 172 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp66_ = _tmp65_;
#line 172 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "NextAVTransportURIMetaData", _tmp66_);
#line 172 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp66_);
#line 172 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp64_);
#line 175 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_value_init (value, G_TYPE_STRING);
#line 176 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp67_ = rygel_change_log_finish (log);
#line 176 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp68_ = _tmp67_;
#line 176 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_value_set_string (value, _tmp68_);
#line 176 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp68_);
#line 142 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (log);
#line 1192 "rygel-av-transport.c"
}


static gboolean int64_try_parse (const gchar* str, gint64* _result_) {
	gint64 _vala_result = 0LL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
#line 608 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, FALSE);
#line 610 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 610 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = g_ascii_strtoll (_tmp0_, &_tmp1_, (guint) 0);
#line 610 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	endptr = _tmp1_;
#line 610 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_vala_result = _tmp2_;
#line 611 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = endptr;
#line 611 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp4_ = str;
#line 611 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp5_ = str;
#line 611 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp6_ = strlen (_tmp5_);
#line 611 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp7_ = _tmp6_;
#line 611 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
#line 612 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = TRUE;
#line 612 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (_result_) {
#line 612 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			*_result_ = _vala_result;
#line 1236 "rygel-av-transport.c"
		}
#line 612 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 1240 "rygel-av-transport.c"
	} else {
#line 614 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = FALSE;
#line 614 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (_result_) {
#line 614 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			*_result_ = _vala_result;
#line 1248 "rygel-av-transport.c"
		}
#line 614 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 1252 "rygel-av-transport.c"
	}
#line 608 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_result_) {
#line 608 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		*_result_ = _vala_result;
#line 1258 "rygel-av-transport.c"
	}
}


static gboolean rygel_av_transport_check_instance_id (RygelAVTransport* self, GUPnPServiceAction* action) {
	gboolean result = FALSE;
	gchar* instance_id_string = NULL;
	gint64 instance_id = 0LL;
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gint64 _tmp8_ = 0LL;
#line 180 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 180 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (action != NULL, FALSE);
#line 182 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	instance_id = (gint64) (-1);
#line 184 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 184 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_get (_tmp0_, "InstanceID", G_TYPE_STRING, &instance_id_string, NULL);
#line 185 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = instance_id_string;
#line 185 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp2_ == NULL) {
#line 185 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp1_ = TRUE;
#line 1287 "rygel-av-transport.c"
	} else {
		const gchar* _tmp3_ = NULL;
		gint64 _tmp4_ = 0LL;
		gboolean _tmp5_ = FALSE;
#line 186 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp3_ = instance_id_string;
#line 186 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp5_ = int64_try_parse (_tmp3_, &_tmp4_);
#line 186 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		instance_id = _tmp4_;
#line 186 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp1_ = !_tmp5_;
#line 1300 "rygel-av-transport.c"
	}
#line 185 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp1_) {
#line 1304 "rygel-av-transport.c"
		GUPnPServiceAction* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 187 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp6_ = action;
#line 187 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp7_ = _ ("Invalid argument");
#line 187 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return_error (_tmp6_, (guint) 402, _tmp7_);
#line 189 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		result = FALSE;
#line 189 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (instance_id_string);
#line 189 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return result;
#line 1319 "rygel-av-transport.c"
	}
#line 192 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp8_ = instance_id;
#line 192 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp8_ != ((gint64) 0)) {
#line 1325 "rygel-av-transport.c"
		GUPnPServiceAction* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 193 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp9_ = action;
#line 193 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp10_ = _ ("Invalid InstanceID");
#line 193 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return_error (_tmp9_, (guint) 718, _tmp10_);
#line 195 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		result = FALSE;
#line 195 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (instance_id_string);
#line 195 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return result;
#line 1340 "rygel-av-transport.c"
	}
#line 198 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	result = TRUE;
#line 198 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (instance_id_string);
#line 198 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return result;
#line 1348 "rygel-av-transport.c"
}


static void rygel_av_transport_set_av_transport_uri_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* _uri = NULL;
	gchar* _metadata = NULL;
	GUPnPServiceAction* _tmp2_ = NULL;
	GUPnPServiceAction* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
#line 201 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 201 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 201 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 203 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 203 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 203 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 204 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 1375 "rygel-av-transport.c"
	}
#line 209 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = action;
#line 209 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_get (_tmp2_, "CurrentURI", G_TYPE_STRING, &_uri, "CurrentURIMetaData", G_TYPE_STRING, &_metadata, NULL);
#line 216 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = action;
#line 216 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _uri;
#line 216 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _metadata;
#line 216 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_handle_new_transport_uri (self, _tmp3_, _tmp4_, _tmp5_);
#line 201 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_metadata);
#line 201 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_uri);
#line 1393 "rygel-av-transport.c"
}


static void rygel_av_transport_set_next_av_transport_uri_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* _uri = NULL;
	gchar* _metadata = NULL;
	GUPnPServiceAction* _tmp2_ = NULL;
	GUPnPServiceAction* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
#line 219 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 219 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 219 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 221 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 221 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 221 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 222 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 1420 "rygel-av-transport.c"
	}
#line 227 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = action;
#line 227 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_get (_tmp2_, "NextURI", G_TYPE_STRING, &_uri, "NextURIMetaData", G_TYPE_STRING, &_metadata, NULL);
#line 234 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = action;
#line 234 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _uri;
#line 234 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _metadata;
#line 234 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_handle_new_transport_uri (self, _tmp3_, _tmp4_, _tmp5_);
#line 219 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_metadata);
#line 219 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_uri);
#line 1438 "rygel-av-transport.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1451 "rygel-av-transport.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1482 "rygel-av-transport.c"
				goto __catch2_g_regex_error;
			}
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return NULL;
#line 1491 "rygel-av-transport.c"
		}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1507 "rygel-av-transport.c"
				goto __catch2_g_regex_error;
			}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return NULL;
#line 1518 "rygel-av-transport.c"
		}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 1532 "rygel-av-transport.c"
	}
	goto __finally2;
	__catch2_g_regex_error:
	{
		GError* e = NULL;
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1287 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 1546 "rygel-av-transport.c"
	}
	__finally2:
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return NULL;
#line 1557 "rygel-av-transport.c"
	}
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	for (i = 0; i < stack_length; i++) {
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			return TRUE;
#line 1570 "rygel-av-transport.c"
		}
	}
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return FALSE;
#line 1575 "rygel-av-transport.c"
}


static gboolean rygel_av_transport_is_valid_mime_type (RygelAVTransport* self, const gchar* mime) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* normalized = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	RygelMediaPlayer* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gchar** _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gboolean _tmp11_ = FALSE;
#line 237 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 238 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = mime;
#line 238 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp0_ == NULL) {
#line 239 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		result = FALSE;
#line 239 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return result;
#line 1605 "rygel-av-transport.c"
	}
#line 242 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = mime;
#line 242 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = g_utf8_strdown (_tmp1_, (gssize) (-1));
#line 242 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 242 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = string_replace (_tmp3_, " ", "");
#line 242 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _tmp4_;
#line 242 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp3_);
#line 242 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	normalized = _tmp5_;
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = normalized;
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = self->priv->player;
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = rygel_media_player_get_mime_types (_tmp7_, &_tmp8_);
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp10_ = _tmp9_;
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp10__length1 = _tmp8_;
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp11_ = _vala_string_array_contains (_tmp10_, _tmp8_, _tmp6_);
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	result = _tmp11_;
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (normalized);
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return result;
#line 1641 "rygel-av-transport.c"
}


static void rygel_av_transport_get_media_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* media_duration = NULL;
	RygelPlayerController* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	GUPnPServiceAction* _tmp9_ = NULL;
	RygelPlayerController* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	guint _tmp12_ = 0U;
	const gchar* _tmp13_ = NULL;
	RygelPlayerController* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	RygelPlayerController* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	RygelPlayerController* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	RygelPlayerController* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	GUPnPServiceAction* _tmp32_ = NULL;
#line 247 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 247 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 247 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 249 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 249 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 249 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 1690 "rygel-av-transport.c"
	}
#line 254 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = self->priv->controller;
#line 254 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = rygel_player_controller_get_n_tracks (_tmp2_);
#line 254 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 254 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp4_ > ((guint) 1)) {
#line 1700 "rygel-av-transport.c"
		gchar* _tmp5_ = NULL;
#line 257 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp5_ = g_strdup ("0:00:00");
#line 257 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (media_duration);
#line 257 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		media_duration = _tmp5_;
#line 1708 "rygel-av-transport.c"
	} else {
		RygelMediaPlayer* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 259 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp6_ = self->priv->player;
#line 259 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp7_ = rygel_media_player_get_duration_as_str (_tmp6_);
#line 259 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp8_ = _tmp7_;
#line 259 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (media_duration);
#line 259 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		media_duration = _tmp8_;
#line 1723 "rygel-av-transport.c"
	}
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = action;
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp10_ = self->priv->controller;
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp11_ = rygel_player_controller_get_n_tracks (_tmp10_);
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp12_ = _tmp11_;
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp13_ = media_duration;
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp14_ = self->priv->controller;
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp15_ = rygel_player_controller_get_uri (_tmp14_);
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp16_ = _tmp15_;
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp17_ = _tmp16_;
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp18_ = self->priv->controller;
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp19_ = rygel_player_controller_get_metadata (_tmp18_);
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp20_ = _tmp19_;
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp21_ = _tmp20_;
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp22_ = self->priv->controller;
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp23_ = rygel_player_controller_get_next_uri (_tmp22_);
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp24_ = _tmp23_;
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp25_ = _tmp24_;
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp26_ = self->priv->controller;
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp27_ = rygel_player_controller_get_next_metadata (_tmp26_);
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp28_ = _tmp27_;
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp29_ = _tmp28_;
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp30_ = rygel_av_transport_get_playback_medium (self);
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp31_ = _tmp30_;
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_set (_tmp9_, "NrTracks", G_TYPE_UINT, _tmp12_, "MediaDuration", G_TYPE_STRING, _tmp13_, "CurrentURI", G_TYPE_STRING, _tmp17_, "CurrentURIMetaData", G_TYPE_STRING, _tmp21_, "NextURI", G_TYPE_STRING, _tmp25_, "NextURIMetaData", G_TYPE_STRING, _tmp29_, "PlayMedium", G_TYPE_STRING, _tmp31_, "RecordMedium", G_TYPE_STRING, "NOT_IMPLEMENTED", "WriteStatus", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp29_);
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp25_);
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp21_);
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp17_);
#line 290 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp32_ = action;
#line 290 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp32_);
#line 247 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (media_duration);
#line 1787 "rygel-av-transport.c"
}


static void rygel_av_transport_get_media_info_ex_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* media_duration = NULL;
	RygelPlayerController* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	GUPnPServiceAction* _tmp9_ = NULL;
	RygelPlayerController* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	guint _tmp12_ = 0U;
	const gchar* _tmp13_ = NULL;
	RygelPlayerController* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	RygelPlayerController* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	RygelPlayerController* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	RygelPlayerController* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	GUPnPServiceAction* _tmp32_ = NULL;
#line 293 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 293 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 293 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 295 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 295 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 295 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 296 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 1836 "rygel-av-transport.c"
	}
#line 300 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = self->priv->controller;
#line 300 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = rygel_player_controller_get_n_tracks (_tmp2_);
#line 300 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 300 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp4_ > ((guint) 1)) {
#line 1846 "rygel-av-transport.c"
		gchar* _tmp5_ = NULL;
#line 303 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp5_ = g_strdup ("0:00:00");
#line 303 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (media_duration);
#line 303 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		media_duration = _tmp5_;
#line 1854 "rygel-av-transport.c"
	} else {
		RygelMediaPlayer* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 305 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp6_ = self->priv->player;
#line 305 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp7_ = rygel_media_player_get_duration_as_str (_tmp6_);
#line 305 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp8_ = _tmp7_;
#line 305 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (media_duration);
#line 305 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		media_duration = _tmp8_;
#line 1869 "rygel-av-transport.c"
	}
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = action;
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp10_ = self->priv->controller;
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp11_ = rygel_player_controller_get_n_tracks (_tmp10_);
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp12_ = _tmp11_;
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp13_ = media_duration;
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp14_ = self->priv->controller;
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp15_ = rygel_player_controller_get_uri (_tmp14_);
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp16_ = _tmp15_;
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp17_ = _tmp16_;
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp18_ = self->priv->controller;
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp19_ = rygel_player_controller_get_metadata (_tmp18_);
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp20_ = _tmp19_;
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp21_ = _tmp20_;
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp22_ = self->priv->controller;
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp23_ = rygel_player_controller_get_next_uri (_tmp22_);
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp24_ = _tmp23_;
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp25_ = _tmp24_;
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp26_ = self->priv->controller;
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp27_ = rygel_player_controller_get_next_metadata (_tmp26_);
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp28_ = _tmp27_;
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp29_ = _tmp28_;
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp30_ = rygel_av_transport_get_playback_medium (self);
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp31_ = _tmp30_;
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_set (_tmp9_, "CurrentType", G_TYPE_STRING, "NO_MEDIA", "NrTracks", G_TYPE_UINT, _tmp12_, "MediaDuration", G_TYPE_STRING, _tmp13_, "CurrentURI", G_TYPE_STRING, _tmp17_, "CurrentURIMetaData", G_TYPE_STRING, _tmp21_, "NextURI", G_TYPE_STRING, _tmp25_, "NextURIMetaData", G_TYPE_STRING, _tmp29_, "PlayMedium", G_TYPE_STRING, _tmp31_, "RecordMedium", G_TYPE_STRING, "NOT_IMPLEMENTED", "WriteStatus", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp29_);
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp25_);
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp21_);
#line 308 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp17_);
#line 339 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp32_ = action;
#line 339 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp32_);
#line 293 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (media_duration);
#line 1933 "rygel-av-transport.c"
}


static void rygel_av_transport_get_transport_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_ = NULL;
	RygelPlayerController* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	RygelMediaPlayer* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GUPnPServiceAction* _tmp12_ = NULL;
#line 343 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 343 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 343 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 345 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 345 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 345 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 346 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 1965 "rygel-av-transport.c"
	}
#line 349 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = action;
#line 349 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = self->priv->controller;
#line 349 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = rygel_player_controller_get_playback_state (_tmp3_);
#line 349 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _tmp4_;
#line 349 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = rygel_av_transport_get_status (self);
#line 349 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = _tmp6_;
#line 349 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp8_ = self->priv->player;
#line 349 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = rygel_media_player_get_playback_speed (_tmp8_);
#line 349 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp10_ = _tmp9_;
#line 349 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp11_ = _tmp10_;
#line 349 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_set (_tmp2_, "CurrentTransportState", G_TYPE_STRING, _tmp5_, "CurrentTransportStatus", G_TYPE_STRING, _tmp7_, "CurrentSpeed", G_TYPE_STRING, _tmp11_, NULL);
#line 349 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp11_);
#line 359 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp12_ = action;
#line 359 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp12_);
#line 1995 "rygel-av-transport.c"
}


static void rygel_av_transport_get_transport_actions_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_ = NULL;
	RygelPlayerController* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GUPnPServiceAction* _tmp7_ = NULL;
#line 362 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 362 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 362 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 364 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 364 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 364 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 365 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 2022 "rygel-av-transport.c"
	}
#line 368 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = action;
#line 368 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = self->priv->controller;
#line 368 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = rygel_player_controller_get_current_transport_actions (_tmp3_);
#line 368 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _tmp4_;
#line 368 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = _tmp5_;
#line 368 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_set (_tmp2_, "Actions", G_TYPE_STRING, _tmp6_, NULL);
#line 368 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp6_);
#line 372 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = action;
#line 372 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp7_);
#line 2042 "rygel-av-transport.c"
}


static void rygel_av_transport_get_position_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_ = NULL;
	RygelPlayerController* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	RygelMediaPlayer* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	RygelPlayerController* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	RygelPlayerController* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	RygelMediaPlayer* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	RygelMediaPlayer* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	RygelMediaPlayer* _tmp26_ = NULL;
	gint64 _tmp27_ = 0LL;
	gint64 _tmp28_ = 0LL;
	RygelMediaPlayer* _tmp29_ = NULL;
	gint64 _tmp30_ = 0LL;
	gint64 _tmp31_ = 0LL;
	GUPnPServiceAction* _tmp32_ = NULL;
#line 375 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 375 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 375 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 377 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 377 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 377 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 378 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 2094 "rygel-av-transport.c"
	}
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = action;
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = self->priv->controller;
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = rygel_player_controller_get_track (_tmp3_);
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _tmp4_;
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = self->priv->player;
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = rygel_media_player_get_duration_as_str (_tmp6_);
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp8_ = _tmp7_;
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = _tmp8_;
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp10_ = self->priv->controller;
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp11_ = rygel_player_controller_get_track_metadata (_tmp10_);
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp12_ = _tmp11_;
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp13_ = _tmp12_;
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp14_ = self->priv->controller;
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp15_ = rygel_player_controller_get_track_uri (_tmp14_);
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp16_ = _tmp15_;
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp17_ = _tmp16_;
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp18_ = self->priv->player;
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp19_ = rygel_media_player_get_position_as_str (_tmp18_);
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp20_ = _tmp19_;
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp21_ = _tmp20_;
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp22_ = self->priv->player;
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp23_ = rygel_media_player_get_position_as_str (_tmp22_);
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp24_ = _tmp23_;
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp25_ = _tmp24_;
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp26_ = self->priv->player;
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp27_ = rygel_media_player_get_byte_position (_tmp26_);
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp28_ = _tmp27_;
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp29_ = self->priv->player;
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp30_ = rygel_media_player_get_byte_position (_tmp29_);
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp31_ = _tmp30_;
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_set (_tmp2_, "Track", G_TYPE_UINT, _tmp5_, "TrackDuration", G_TYPE_STRING, _tmp9_, "TrackMetaData", G_TYPE_STRING, _tmp13_, "TrackURI", G_TYPE_STRING, _tmp17_, "RelTime", G_TYPE_STRING, _tmp21_, "AbsTime", G_TYPE_STRING, _tmp25_, "RelCount", G_TYPE_INT64, _tmp28_, "AbsCount", G_TYPE_INT64, _tmp31_, NULL);
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp25_);
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp21_);
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp17_);
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp13_);
#line 381 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp9_);
#line 406 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp32_ = action;
#line 406 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp32_);
#line 2172 "rygel-av-transport.c"
}


static void rygel_av_transport_get_device_capabilities_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_ = NULL;
	GUPnPServiceAction* _tmp3_ = NULL;
#line 409 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 409 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 409 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 411 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 411 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 411 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 412 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 2195 "rygel-av-transport.c"
	}
#line 415 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = action;
#line 415 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_set (_tmp2_, "PlayMedia", G_TYPE_STRING, "None,Network", "RecMedia", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecQualityModes", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
#line 425 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = action;
#line 425 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp3_);
#line 2205 "rygel-av-transport.c"
}


static void rygel_av_transport_get_transport_settings_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_ = NULL;
	RygelPlayerController* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GUPnPServiceAction* _tmp6_ = NULL;
#line 428 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 428 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 428 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 430 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 430 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 430 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 431 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 2231 "rygel-av-transport.c"
	}
#line 434 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = action;
#line 434 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = self->priv->controller;
#line 434 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = rygel_player_controller_get_play_mode (_tmp3_);
#line 434 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _tmp4_;
#line 434 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_set (_tmp2_, "PlayMode", G_TYPE_STRING, _tmp5_, "RecQualityMode", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
#line 441 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = action;
#line 441 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp6_);
#line 2247 "rygel-av-transport.c"
}


static void rygel_av_transport_stop_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	RygelPlayerController* _tmp2_ = NULL;
	GUPnPServiceAction* _tmp3_ = NULL;
#line 444 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 444 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 444 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 445 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 445 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 445 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 446 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 2270 "rygel-av-transport.c"
	}
#line 449 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = self->priv->controller;
#line 449 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_player_controller_set_playback_state (_tmp2_, "STOPPED");
#line 451 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = action;
#line 451 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp3_);
#line 2280 "rygel-av-transport.c"
}


static void rygel_av_transport_play_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* speed = NULL;
	GUPnPServiceAction* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	RygelMediaPlayer* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gboolean _tmp8_ = FALSE;
	RygelMediaPlayer* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	RygelPlayerController* _tmp13_ = NULL;
	GUPnPServiceAction* _tmp14_ = NULL;
#line 454 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 454 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 454 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 455 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 455 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 455 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 456 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 2316 "rygel-av-transport.c"
	}
#line 461 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = action;
#line 461 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_get (_tmp2_, "Speed", G_TYPE_STRING, &speed, NULL);
#line 462 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = speed;
#line 462 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = self->priv->player;
#line 462 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = rygel_media_player_get_allowed_playback_speeds (_tmp4_, &_tmp5__length1);
#line 462 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = _tmp5_;
#line 462 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6__length1 = _tmp5__length1;
#line 462 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = _tmp6_;
#line 462 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7__length1 = _tmp6__length1;
#line 462 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp8_ = !_vala_string_array_contains (_tmp7_, _tmp6__length1, _tmp3_);
#line 462 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
#line 462 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp8_) {
#line 2342 "rygel-av-transport.c"
		GUPnPServiceAction* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 463 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp9_ = action;
#line 463 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp10_ = _ ("Play speed not supported");
#line 463 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return_error (_tmp9_, (guint) 717, _tmp10_);
#line 465 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (speed);
#line 465 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 2355 "rygel-av-transport.c"
	}
#line 469 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp11_ = self->priv->player;
#line 469 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp12_ = speed;
#line 469 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_media_player_set_playback_speed (_tmp11_, _tmp12_);
#line 470 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp13_ = self->priv->controller;
#line 470 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_player_controller_set_playback_state (_tmp13_, "PLAYING");
#line 472 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp14_ = action;
#line 472 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp14_);
#line 454 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (speed);
#line 2373 "rygel-av-transport.c"
}


static void rygel_av_transport_pause_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	RygelPlayerController* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	RygelPlayerController* _tmp7_ = NULL;
	GUPnPServiceAction* _tmp8_ = NULL;
#line 475 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 475 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 475 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 476 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 476 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 476 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 477 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 2399 "rygel-av-transport.c"
	}
#line 480 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = self->priv->controller;
#line 480 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = rygel_player_controller_get_playback_state (_tmp2_);
#line 480 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 480 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (g_strcmp0 (_tmp4_, "PLAYING") != 0) {
#line 2409 "rygel-av-transport.c"
		GUPnPServiceAction* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 481 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp5_ = action;
#line 481 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp6_ = _ ("Transition not available");
#line 481 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return_error (_tmp5_, (guint) 701, _tmp6_);
#line 483 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 2420 "rygel-av-transport.c"
	}
#line 486 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = self->priv->controller;
#line 486 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_player_controller_set_playback_state (_tmp7_, "PAUSED_PLAYBACK");
#line 488 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp8_ = action;
#line 488 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp8_);
#line 2430 "rygel-av-transport.c"
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
#line 605 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, 0LL);
#line 606 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 606 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
#line 606 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 606 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 2448 "rygel-av-transport.c"
}


static void rygel_av_transport_seek_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* unit = NULL;
	gchar* target = NULL;
	GUPnPServiceAction* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GQuark _tmp6_ = 0U;
#line 504 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	static GQuark _tmp5_label0 = 0;
#line 504 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	static GQuark _tmp5_label1 = 0;
#line 504 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	static GQuark _tmp5_label2 = 0;
#line 504 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	static GQuark _tmp5_label3 = 0;
#line 504 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	static GQuark _tmp5_label4 = 0;
#line 504 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	static GQuark _tmp5_label5 = 0;
#line 491 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 491 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 491 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 492 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 492 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 492 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 493 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 2487 "rygel-av-transport.c"
	}
#line 498 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = action;
#line 498 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_get (_tmp2_, "Unit", G_TYPE_STRING, &unit, "Target", G_TYPE_STRING, &target, NULL);
#line 504 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = unit;
#line 504 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 504 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
#line 504 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if ((_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("ABS_TIME")))) || (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("REL_TIME"))))) {
#line 504 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		switch (0) {
#line 2503 "rygel-av-transport.c"
			default:
			{
				gint64 seek_target = 0LL;
				const gchar* _tmp7_ = NULL;
				gint64 _tmp8_ = 0LL;
				gint64 _tmp9_ = 0LL;
				RygelMediaPlayer* _tmp10_ = NULL;
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				RygelMediaPlayer* _tmp15_ = NULL;
				gint64 _tmp16_ = 0LL;
				gboolean _tmp17_ = FALSE;
				GUPnPServiceAction* _tmp20_ = NULL;
#line 507 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp7_ = target;
#line 507 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp8_ = rygel_time_utils_time_from_string (_tmp7_);
#line 507 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				seek_target = _tmp8_;
#line 508 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp9_ = seek_target;
#line 508 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				g_debug ("rygel-av-transport.vala:508: Seeking to %lld sec", _tmp9_ / G_TIME_SPAN_SECOND);
#line 510 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp10_ = self->priv->player;
#line 510 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp11_ = rygel_media_player_get_can_seek (_tmp10_);
#line 510 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp12_ = _tmp11_;
#line 510 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				if (!_tmp12_) {
#line 2535 "rygel-av-transport.c"
					GUPnPServiceAction* _tmp13_ = NULL;
					const gchar* _tmp14_ = NULL;
#line 511 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp13_ = action;
#line 511 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp14_ = _ ("Seek mode not supported");
#line 511 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					gupnp_service_action_return_error (_tmp13_, (guint) 710, _tmp14_);
#line 513 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_g_free0 (target);
#line 513 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_g_free0 (unit);
#line 513 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					return;
#line 2550 "rygel-av-transport.c"
				}
#line 516 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp15_ = self->priv->player;
#line 516 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp16_ = seek_target;
#line 516 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp17_ = rygel_media_player_seek (_tmp15_, _tmp16_);
#line 516 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				if (!_tmp17_) {
#line 2560 "rygel-av-transport.c"
					GUPnPServiceAction* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
#line 517 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp18_ = action;
#line 517 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp19_ = _ ("Illegal seek target");
#line 517 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					gupnp_service_action_return_error (_tmp18_, (guint) 711, _tmp19_);
#line 519 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_g_free0 (target);
#line 519 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_g_free0 (unit);
#line 519 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					return;
#line 2575 "rygel-av-transport.c"
				}
#line 522 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp20_ = action;
#line 522 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				gupnp_service_action_return (_tmp20_);
#line 524 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_g_free0 (target);
#line 524 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_g_free0 (unit);
#line 524 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				return;
#line 2587 "rygel-av-transport.c"
			}
		}
	} else if (((_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("REL_COUNT")))) || (_tmp6_ == ((0 != _tmp5_label3) ? _tmp5_label3 : (_tmp5_label3 = g_quark_from_static_string ("X_DLNA_REL_BYTE"))))) || (_tmp6_ == ((0 != _tmp5_label4) ? _tmp5_label4 : (_tmp5_label4 = g_quark_from_static_string ("ABS_COUNT"))))) {
#line 504 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		switch (0) {
#line 2593 "rygel-av-transport.c"
			default:
			{
				gint64 seek_target = 0LL;
				const gchar* _tmp21_ = NULL;
				gint64 _tmp22_ = 0LL;
				const gchar* _tmp23_ = NULL;
				gint64 _tmp28_ = 0LL;
				RygelMediaPlayer* _tmp29_ = NULL;
				gboolean _tmp30_ = FALSE;
				gboolean _tmp31_ = FALSE;
				RygelMediaPlayer* _tmp34_ = NULL;
				gint64 _tmp35_ = 0LL;
				gboolean _tmp36_ = FALSE;
				GUPnPServiceAction* _tmp39_ = NULL;
#line 528 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp21_ = target;
#line 528 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp22_ = int64_parse (_tmp21_);
#line 528 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				seek_target = _tmp22_;
#line 530 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp23_ = unit;
#line 530 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				if (g_strcmp0 (_tmp23_, "ABS_COUNT") != 0) {
#line 2618 "rygel-av-transport.c"
					gint64 _tmp24_ = 0LL;
					RygelMediaPlayer* _tmp25_ = NULL;
					gint64 _tmp26_ = 0LL;
					gint64 _tmp27_ = 0LL;
#line 531 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp24_ = seek_target;
#line 531 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp25_ = self->priv->player;
#line 531 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp26_ = rygel_media_player_get_byte_position (_tmp25_);
#line 531 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp27_ = _tmp26_;
#line 531 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					seek_target = _tmp24_ + _tmp27_;
#line 2633 "rygel-av-transport.c"
				}
#line 533 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp28_ = seek_target;
#line 533 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				g_debug ("rygel-av-transport.vala:533: Seeking to %lld bytes.", _tmp28_);
#line 535 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp29_ = self->priv->player;
#line 535 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp30_ = rygel_media_player_get_can_seek_bytes (_tmp29_);
#line 535 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp31_ = _tmp30_;
#line 535 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				if (!_tmp31_) {
#line 2647 "rygel-av-transport.c"
					GUPnPServiceAction* _tmp32_ = NULL;
					const gchar* _tmp33_ = NULL;
#line 536 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp32_ = action;
#line 536 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp33_ = _ ("Seek mode not supported");
#line 536 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					gupnp_service_action_return_error (_tmp32_, (guint) 710, _tmp33_);
#line 538 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_g_free0 (target);
#line 538 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_g_free0 (unit);
#line 538 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					return;
#line 2662 "rygel-av-transport.c"
				}
#line 541 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp34_ = self->priv->player;
#line 541 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp35_ = seek_target;
#line 541 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp36_ = rygel_media_player_seek_bytes (_tmp34_, _tmp35_);
#line 541 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				if (!_tmp36_) {
#line 2672 "rygel-av-transport.c"
					GUPnPServiceAction* _tmp37_ = NULL;
					const gchar* _tmp38_ = NULL;
#line 542 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp37_ = action;
#line 542 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp38_ = _ ("Illegal seek target");
#line 542 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					gupnp_service_action_return_error (_tmp37_, (guint) 711, _tmp38_);
#line 544 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_g_free0 (target);
#line 544 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_g_free0 (unit);
#line 544 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					return;
#line 2687 "rygel-av-transport.c"
				}
#line 547 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp39_ = action;
#line 547 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				gupnp_service_action_return (_tmp39_);
#line 549 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_g_free0 (target);
#line 549 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_g_free0 (unit);
#line 549 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				return;
#line 2699 "rygel-av-transport.c"
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label5) ? _tmp5_label5 : (_tmp5_label5 = g_quark_from_static_string ("TRACK_NR")))) {
#line 504 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		switch (0) {
#line 2705 "rygel-av-transport.c"
			default:
			{
				const gchar* _tmp40_ = NULL;
				gint track = 0;
				const gchar* _tmp41_ = NULL;
				gint _tmp42_ = 0;
				gboolean _tmp43_ = FALSE;
				gint _tmp44_ = 0;
				RygelPlayerController* _tmp51_ = NULL;
				gint _tmp52_ = 0;
				GUPnPServiceAction* _tmp53_ = NULL;
#line 551 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp40_ = target;
#line 551 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				g_debug ("rygel-av-transport.vala:551: Setting track to %s.", _tmp40_);
#line 552 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp41_ = target;
#line 552 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp42_ = atoi (_tmp41_);
#line 552 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				track = _tmp42_;
#line 554 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp44_ = track;
#line 554 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				if (_tmp44_ < 1) {
#line 554 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp43_ = TRUE;
#line 2733 "rygel-av-transport.c"
				} else {
					gint _tmp45_ = 0;
					RygelPlayerController* _tmp46_ = NULL;
					guint _tmp47_ = 0U;
					guint _tmp48_ = 0U;
#line 554 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp45_ = track;
#line 554 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp46_ = self->priv->controller;
#line 554 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp47_ = rygel_player_controller_get_n_tracks (_tmp46_);
#line 554 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp48_ = _tmp47_;
#line 554 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp43_ = ((guint) _tmp45_) > _tmp48_;
#line 2749 "rygel-av-transport.c"
				}
#line 554 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				if (_tmp43_) {
#line 2753 "rygel-av-transport.c"
					GUPnPServiceAction* _tmp49_ = NULL;
					const gchar* _tmp50_ = NULL;
#line 555 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp49_ = action;
#line 555 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp50_ = _ ("Illegal seek target");
#line 555 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					gupnp_service_action_return_error (_tmp49_, (guint) 711, _tmp50_);
#line 557 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_g_free0 (target);
#line 557 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_g_free0 (unit);
#line 557 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					return;
#line 2768 "rygel-av-transport.c"
				}
#line 560 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp51_ = self->priv->controller;
#line 560 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp52_ = track;
#line 560 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				rygel_player_controller_set_track (_tmp51_, (guint) _tmp52_);
#line 562 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp53_ = action;
#line 562 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				gupnp_service_action_return (_tmp53_);
#line 564 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				break;
#line 2782 "rygel-av-transport.c"
			}
		}
	} else {
#line 504 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		switch (0) {
#line 2788 "rygel-av-transport.c"
			default:
			{
				GUPnPServiceAction* _tmp54_ = NULL;
				const gchar* _tmp55_ = NULL;
#line 566 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp54_ = action;
#line 566 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp55_ = _ ("Seek mode not supported");
#line 566 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				gupnp_service_action_return_error (_tmp54_, (guint) 710, _tmp55_);
#line 568 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_g_free0 (target);
#line 568 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_g_free0 (unit);
#line 568 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				return;
#line 2805 "rygel-av-transport.c"
			}
		}
	}
#line 491 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (target);
#line 491 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (unit);
#line 2813 "rygel-av-transport.c"
}


static void rygel_av_transport_next_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	RygelPlayerController* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 572 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 572 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 572 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 573 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 573 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 573 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 574 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 2836 "rygel-av-transport.c"
	}
#line 577 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = self->priv->controller;
#line 577 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = rygel_player_controller_next (_tmp2_);
#line 577 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp3_) {
#line 2844 "rygel-av-transport.c"
		GUPnPServiceAction* _tmp4_ = NULL;
#line 578 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp4_ = action;
#line 578 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return (_tmp4_);
#line 2850 "rygel-av-transport.c"
	} else {
		GUPnPServiceAction* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 580 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp5_ = action;
#line 580 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp6_ = _ ("Illegal seek target");
#line 580 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return_error (_tmp5_, (guint) 711, _tmp6_);
#line 2860 "rygel-av-transport.c"
	}
}


static void rygel_av_transport_previous_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	RygelPlayerController* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 584 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 584 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 584 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 585 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 585 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 585 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 586 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 2884 "rygel-av-transport.c"
	}
#line 589 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = self->priv->controller;
#line 589 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = rygel_player_controller_previous (_tmp2_);
#line 589 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp3_) {
#line 2892 "rygel-av-transport.c"
		GUPnPServiceAction* _tmp4_ = NULL;
#line 590 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp4_ = action;
#line 590 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return (_tmp4_);
#line 2898 "rygel-av-transport.c"
	} else {
		GUPnPServiceAction* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 592 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp5_ = action;
#line 592 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp6_ = _ ("Illegal seek target");
#line 592 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return_error (_tmp5_, (guint) 711, _tmp6_);
#line 2908 "rygel-av-transport.c"
	}
}


static void rygel_av_transport_x_dlna_get_byte_position_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	RygelPlayerController* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GUPnPServiceAction* _tmp20_ = NULL;
#line 596 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 596 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 596 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 598 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 598 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 598 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 599 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 2936 "rygel-av-transport.c"
	}
#line 602 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = self->priv->controller;
#line 602 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = rygel_player_controller_get_uri (_tmp2_);
#line 602 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 602 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _tmp4_;
#line 602 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = g_strcmp0 (_tmp5_, "") == 0;
#line 602 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp5_);
#line 602 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp6_) {
#line 2952 "rygel-av-transport.c"
		GUPnPServiceAction* _tmp7_ = NULL;
#line 603 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp7_ = action;
#line 603 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_set (_tmp7_, "TrackSize", G_TYPE_STRING, "", "RelByte", G_TYPE_STRING, "", "AbsByte", G_TYPE_STRING, "", NULL);
#line 2958 "rygel-av-transport.c"
	} else {
		gchar* position = NULL;
		RygelMediaPlayer* _tmp8_ = NULL;
		gint64 _tmp9_ = 0LL;
		gint64 _tmp10_ = 0LL;
		gchar* _tmp11_ = NULL;
		GUPnPServiceAction* _tmp12_ = NULL;
		RygelMediaPlayer* _tmp13_ = NULL;
		gint64 _tmp14_ = 0LL;
		gint64 _tmp15_ = 0LL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 613 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp8_ = self->priv->player;
#line 613 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp9_ = rygel_media_player_get_byte_position (_tmp8_);
#line 613 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp10_ = _tmp9_;
#line 613 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp11_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp10_);
#line 613 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		position = _tmp11_;
#line 614 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp12_ = action;
#line 614 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp13_ = self->priv->player;
#line 614 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp14_ = rygel_media_player_get_size (_tmp13_);
#line 614 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp15_ = _tmp14_;
#line 614 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp16_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp15_);
#line 614 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp17_ = _tmp16_;
#line 614 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp18_ = position;
#line 614 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp19_ = position;
#line 614 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_set (_tmp12_, "TrackSize", G_TYPE_STRING, _tmp17_, "RelByte", G_TYPE_STRING, _tmp18_, "AbsByte", G_TYPE_STRING, _tmp19_, NULL);
#line 614 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (_tmp17_);
#line 602 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (position);
#line 3005 "rygel-av-transport.c"
	}
#line 625 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp20_ = action;
#line 625 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp20_);
#line 3011 "rygel-av-transport.c"
}


static void rygel_av_transport_set_play_mode_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* play_mode = NULL;
	GUPnPServiceAction* _tmp2_ = NULL;
	RygelPlayerController* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	RygelPlayerController* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GUPnPServiceAction* _tmp10_ = NULL;
#line 628 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 628 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 628 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 630 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 630 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 630 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 631 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 3040 "rygel-av-transport.c"
	}
#line 636 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = action;
#line 636 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_get (_tmp2_, "NewPlayMode", G_TYPE_STRING, &play_mode, NULL);
#line 640 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = self->priv->controller;
#line 640 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = play_mode;
#line 640 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = rygel_player_controller_is_play_mode_valid (_tmp3_, _tmp4_);
#line 640 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp5_) {
#line 3054 "rygel-av-transport.c"
		GUPnPServiceAction* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 641 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp6_ = action;
#line 641 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp7_ = _ ("Play mode not supported");
#line 641 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return_error (_tmp6_, (guint) 712, _tmp7_);
#line 642 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (play_mode);
#line 642 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 3067 "rygel-av-transport.c"
	}
#line 645 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp8_ = self->priv->controller;
#line 645 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = play_mode;
#line 645 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_player_controller_set_play_mode (_tmp8_, _tmp9_);
#line 647 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp10_ = action;
#line 647 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp10_);
#line 628 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (play_mode);
#line 3081 "rygel-av-transport.c"
}


static void rygel_av_transport_notify_state_cb (RygelAVTransport* self, GObject* controller, GParamSpec* p) {
	gchar* state = NULL;
	RygelPlayerController* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	RygelChangeLog* _tmp4_ = NULL;
	RygelChangeLog* _tmp5_ = NULL;
	RygelPlayerController* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
#line 650 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 650 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (controller != NULL);
#line 650 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 651 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->controller;
#line 651 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_player_controller_get_playback_state (_tmp0_);
#line 651 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = _tmp1_;
#line 651 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 651 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	state = _tmp3_;
#line 652 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = self->priv->changelog;
#line 652 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp4_, "TransportState", state);
#line 653 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = self->priv->changelog;
#line 653 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = self->priv->controller;
#line 653 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = rygel_player_controller_get_current_transport_actions (_tmp6_);
#line 653 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp8_ = _tmp7_;
#line 653 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = _tmp8_;
#line 653 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp5_, "CurrentTransportActions", _tmp9_);
#line 653 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp9_);
#line 650 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (state);
#line 3133 "rygel-av-transport.c"
}


static void rygel_av_transport_notify_n_tracks_cb (RygelAVTransport* self, GObject* controller, GParamSpec* p) {
	RygelChangeLog* _tmp0_ = NULL;
	RygelPlayerController* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
#line 657 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 657 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (controller != NULL);
#line 657 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 658 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->changelog;
#line 658 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = self->priv->controller;
#line 658 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = rygel_player_controller_get_n_tracks (_tmp1_);
#line 658 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 658 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = g_strdup_printf ("%u", _tmp3_);
#line 658 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _tmp4_;
#line 658 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp0_, "NumberOfTracks", _tmp5_);
#line 658 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp5_);
#line 3166 "rygel-av-transport.c"
}


static void rygel_av_transport_notify_track_cb (RygelAVTransport* self, GObject* controller, GParamSpec* p) {
	RygelChangeLog* _tmp0_ = NULL;
	RygelPlayerController* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
#line 662 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 662 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (controller != NULL);
#line 662 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 663 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->changelog;
#line 663 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = self->priv->controller;
#line 663 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = rygel_player_controller_get_track (_tmp1_);
#line 663 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 663 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = g_strdup_printf ("%u", _tmp3_);
#line 663 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _tmp4_;
#line 663 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp0_, "CurrentTrack", _tmp5_);
#line 663 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp5_);
#line 3199 "rygel-av-transport.c"
}


static void rygel_av_transport_notify_duration_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_ = NULL;
	RygelMediaPlayer* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	RygelChangeLog* _tmp5_ = NULL;
	RygelMediaPlayer* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
#line 667 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 667 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (player != NULL);
#line 667 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 668 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->changelog;
#line 668 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = self->priv->player;
#line 668 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = rygel_media_player_get_duration_as_str (_tmp1_);
#line 668 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 668 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 668 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp0_, "CurrentTrackDuration", _tmp4_);
#line 668 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp4_);
#line 670 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = self->priv->changelog;
#line 670 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = self->priv->player;
#line 670 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = rygel_media_player_get_duration_as_str (_tmp6_);
#line 670 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp8_ = _tmp7_;
#line 670 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = _tmp8_;
#line 670 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp5_, "CurrentMediaDuration", _tmp9_);
#line 670 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp9_);
#line 3248 "rygel-av-transport.c"
}


static void rygel_av_transport_notify_uri_cb (RygelAVTransport* self, GObject* controller, GParamSpec* p) {
	RygelChangeLog* _tmp0_ = NULL;
	RygelPlayerController* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 674 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 674 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (controller != NULL);
#line 674 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 675 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->changelog;
#line 675 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = self->priv->controller;
#line 675 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = rygel_player_controller_get_uri (_tmp1_);
#line 675 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 675 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 675 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp0_, "AVTransportURI", _tmp4_);
#line 675 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp4_);
#line 3278 "rygel-av-transport.c"
}


static void rygel_av_transport_notify_meta_data_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_ = NULL;
	RygelPlayerController* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
#line 678 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 678 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (player != NULL);
#line 678 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 679 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->changelog;
#line 679 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = self->priv->controller;
#line 679 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = rygel_player_controller_get_metadata (_tmp1_);
#line 679 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 679 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 679 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = g_markup_escape_text (_tmp4_, (gssize) (-1));
#line 679 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = _tmp5_;
#line 679 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp0_, "AVTransportURIMetaData", _tmp6_);
#line 679 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp6_);
#line 679 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp4_);
#line 3316 "rygel-av-transport.c"
}


static void rygel_av_transport_notify_track_uri_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_ = NULL;
	RygelPlayerController* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 683 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 683 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (player != NULL);
#line 683 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 684 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->changelog;
#line 684 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = self->priv->controller;
#line 684 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = rygel_player_controller_get_track_uri (_tmp1_);
#line 684 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 684 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 684 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp0_, "CurrentTrackURI", _tmp4_);
#line 684 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp4_);
#line 3346 "rygel-av-transport.c"
}


static void rygel_av_transport_notify_track_meta_data_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_ = NULL;
	RygelPlayerController* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
#line 687 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 687 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (player != NULL);
#line 687 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 688 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->changelog;
#line 688 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = self->priv->controller;
#line 688 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = rygel_player_controller_get_track_metadata (_tmp1_);
#line 688 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 688 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 688 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = g_markup_escape_text (_tmp4_, (gssize) (-1));
#line 688 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = _tmp5_;
#line 688 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp0_, "CurrentTrackMetaData", _tmp6_);
#line 688 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp6_);
#line 688 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp4_);
#line 3384 "rygel-av-transport.c"
}


static void rygel_av_transport_notify_next_uri_cb (RygelAVTransport* self, GObject* controller, GParamSpec* p) {
	RygelChangeLog* _tmp0_ = NULL;
	RygelPlayerController* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 692 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 692 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (controller != NULL);
#line 692 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 693 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->changelog;
#line 693 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = self->priv->controller;
#line 693 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = rygel_player_controller_get_next_uri (_tmp1_);
#line 693 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 693 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 693 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp0_, "NextAVTransportURI", _tmp4_);
#line 693 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp4_);
#line 3414 "rygel-av-transport.c"
}


static void rygel_av_transport_notify_next_meta_data_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_ = NULL;
	RygelPlayerController* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
#line 696 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 696 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (player != NULL);
#line 696 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 697 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->changelog;
#line 697 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = self->priv->controller;
#line 697 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = rygel_player_controller_get_next_metadata (_tmp1_);
#line 697 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 697 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 697 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = g_markup_escape_text (_tmp4_, (gssize) (-1));
#line 697 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = _tmp5_;
#line 697 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp0_, "NextAVTransportURIMetaData", _tmp6_);
#line 697 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp6_);
#line 697 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp4_);
#line 3452 "rygel-av-transport.c"
}


static void rygel_av_transport_notify_play_mode_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_ = NULL;
	RygelPlayerController* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 701 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 701 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (player != NULL);
#line 701 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 702 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->changelog;
#line 702 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = self->priv->controller;
#line 702 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = rygel_player_controller_get_play_mode (_tmp1_);
#line 702 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 702 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp0_, "CurrentPlayMode", _tmp3_);
#line 3477 "rygel-av-transport.c"
}


static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self) {
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_boxed_free (gupnp_service_action_get_type (), self);
#line 3484 "rygel-av-transport.c"
}


static void rygel_av_transport_handle_playlist_data_free (gpointer _data) {
	RygelAvTransportHandlePlaylistData* _data_;
	_data_ = _data;
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	__vala_GUPnPServiceAction_free0 (_data_->action);
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_data_->uri);
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_data_->metadata);
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_data_->mime);
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_data_->features);
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (_data_->self);
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_slice_free (RygelAvTransportHandlePlaylistData, _data_);
#line 3505 "rygel-av-transport.c"
}


static GUPnPServiceAction* _vala_GUPnPServiceAction_copy (GUPnPServiceAction* self) {
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return g_boxed_copy (gupnp_service_action_get_type (), self);
#line 3512 "rygel-av-transport.c"
}


static gpointer __vala_GUPnPServiceAction_copy0 (gpointer self) {
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return self ? _vala_GUPnPServiceAction_copy (self) : NULL;
#line 3519 "rygel-av-transport.c"
}


static void rygel_av_transport_handle_playlist (RygelAVTransport* self, GUPnPServiceAction* action, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelAvTransportHandlePlaylistData* _data_;
	RygelAVTransport* _tmp0_ = NULL;
	GUPnPServiceAction* _tmp1_ = NULL;
	GUPnPServiceAction* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_ = g_slice_new0 (RygelAvTransportHandlePlaylistData);
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_av_transport_handle_playlist);
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_av_transport_handle_playlist_data_free);
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->self = _tmp0_;
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = action;
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = __vala_GUPnPServiceAction_copy0 (_tmp1_);
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	__vala_GUPnPServiceAction_free0 (_data_->action);
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->action = _tmp2_;
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = uri;
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_data_->uri);
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->uri = _tmp4_;
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = metadata;
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_data_->metadata);
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->metadata = _tmp6_;
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = mime;
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_data_->mime);
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->mime = _tmp8_;
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = features;
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp10_ = g_strdup (_tmp9_);
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_data_->features);
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->features = _tmp10_;
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_handle_playlist_co (_data_);
#line 3588 "rygel-av-transport.c"
}


static void rygel_av_transport_handle_playlist_finish (RygelAVTransport* self, GAsyncResult* _res_) {
	RygelAvTransportHandlePlaylistData* _data_;
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 3596 "rygel-av-transport.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 705 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 705 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return _data2_;
#line 3605 "rygel-av-transport.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 705 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 3614 "rygel-av-transport.c"
		RygelAVTransport* self;
#line 705 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		self = _data2_->self;
#line 705 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_object_unref0 (self);
#line 705 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_slice_free (Block2Data, _data2_);
#line 3622 "rygel-av-transport.c"
	}
}


static void __lambda9_ (Block2Data* _data2_) {
	RygelAVTransport* self;
#line 711 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self = _data2_->self;
#line 712 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_handle_playlist_co (_data2_->_async_data_);
#line 3633 "rygel-av-transport.c"
}


static void ___lambda9__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
#line 711 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	__lambda9_ (self);
#line 711 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	block2_data_unref (self);
#line 3642 "rygel-av-transport.c"
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
#line 727 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 3649 "rygel-av-transport.c"
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1115 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1116 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1116 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1117 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1117 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1118 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _result_;
#line 1118 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 3672 "rygel-av-transport.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 768 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 3679 "rygel-av-transport.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 768 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 768 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_list_free (self);
#line 3688 "rygel-av-transport.c"
}


static gboolean rygel_av_transport_handle_playlist_co (RygelAvTransportHandlePlaylistData* _data_) {
#line 776 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	static GQuark _tmp76_label0 = 0;
#line 776 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	static GQuark _tmp76_label1 = 0;
#line 705 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	switch (_data_->_state_) {
#line 705 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case 0:
#line 3701 "rygel-av-transport.c"
		goto _state_0;
#line 705 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case 1:
#line 3705 "rygel-av-transport.c"
		goto _state_1;
		default:
#line 705 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_assert_not_reached ();
#line 3710 "rygel-av-transport.c"
	}
	_state_0:
#line 705 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_data2_ = g_slice_new0 (Block2Data);
#line 705 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_data2_->_ref_count_ = 1;
#line 705 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_data2_->self = g_object_ref (_data_->self);
#line 705 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_data2_->_async_data_ = _data_;
#line 710 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp0_ = NULL;
#line 710 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp0_ = _data_->uri;
#line 710 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp1_ = NULL;
#line 710 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp1_ = soup_message_new ("GET", _data_->_tmp0_);
#line 710 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->message = _data_->_tmp1_;
#line 711 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp2_ = NULL;
#line 711 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp2_ = _data_->self->priv->session;
#line 711 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp3_ = NULL;
#line 711 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp3_ = _data_->message;
#line 711 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp4_ = NULL;
#line 711 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
#line 711 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	soup_session_queue_message (_data_->_tmp2_, _data_->_tmp4_, ___lambda9__soup_session_callback, block2_data_ref (_data_->_data2_));
#line 714 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_state_ = 1;
#line 714 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return FALSE;
#line 3749 "rygel-av-transport.c"
	_state_1:
	;
#line 716 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp5_ = NULL;
#line 716 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp5_ = _data_->message;
#line 716 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp6_ = 0U;
#line 716 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_get (_data_->_tmp5_, "status-code", &_data_->_tmp6_, NULL);
#line 716 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp7_ = 0U;
#line 716 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp7_ = _data_->_tmp6_;
#line 716 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_data_->_tmp7_ != ((guint) 200)) {
#line 717 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp8_ = NULL;
#line 717 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp8_ = _data_->action;
#line 717 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp9_ = NULL;
#line 717 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp9_ = _ ("Resource not found");
#line 717 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return_error (_data_->_tmp8_, (guint) 716, _data_->_tmp9_);
#line 719 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_object_unref0 (_data_->message);
#line 719 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		block2_data_unref (_data_->_data2_);
#line 719 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_data2_ = NULL;
#line 719 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		if (_data_->_state_ == 0) {
#line 719 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3786 "rygel-av-transport.c"
		} else {
#line 719 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3790 "rygel-av-transport.c"
		}
#line 719 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_object_unref (_data_->_async_result);
#line 719 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return FALSE;
#line 3796 "rygel-av-transport.c"
	}
#line 722 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp10_ = NULL;
#line 722 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp10_ = _data_->message;
#line 722 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp11_ = NULL;
#line 722 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp11_ = _data_->_tmp10_->response_headers;
#line 722 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp12_ = NULL;
#line 722 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp12_ = soup_message_headers_get_content_type (_data_->_tmp11_, NULL);
#line 722 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp13_ = NULL;
#line 722 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp13_ = g_strdup (_data_->_tmp12_);
#line 722 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->content_type = _data_->_tmp13_;
#line 724 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->collection = NULL;
#line 725 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp14_ = NULL;
#line 725 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp14_ = _data_->content_type;
#line 725 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp15_ = FALSE;
#line 725 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp15_ = g_str_has_suffix (_data_->_tmp14_, "mpegurl");
#line 725 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_data_->_tmp15_) {
#line 726 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp16_ = NULL;
#line 726 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp16_ = gupnp_media_collection_new ();
#line 726 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_object_unref0 (_data_->collection);
#line 726 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->collection = _data_->_tmp16_;
#line 727 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp17_ = NULL;
#line 727 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp17_ = _data_->message;
#line 727 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp18_ = NULL;
#line 727 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp18_ = _data_->_tmp17_->response_body;
#line 727 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp19_ = NULL;
#line 727 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp19__length1 = 0;
#line 727 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp19_ = _data_->_tmp18_->data;
#line 727 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp19__length1 = (gint) _data_->_tmp18_->length;
#line 727 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp20_ = NULL;
#line 727 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp20__length1 = 0;
#line 727 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp20_ = (_data_->_tmp19_ != NULL) ? _vala_array_dup1 (_data_->_tmp19_, _data_->_tmp19__length1) : ((gpointer) _data_->_tmp19_);
#line 727 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp20__length1 = _data_->_tmp19__length1;
#line 727 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp21_ = NULL;
#line 727 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp21_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_data_->_tmp20_, _data_->_tmp20__length1, NULL);
#line 727 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->m_stream = _data_->_tmp21_;
#line 729 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp22_ = NULL;
#line 729 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp22_ = _data_->m_stream;
#line 729 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp23_ = NULL;
#line 729 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp23_ = g_data_input_stream_new ((GInputStream*) _data_->_tmp22_);
#line 729 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->stream = _data_->_tmp23_;
#line 732 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_debug ("rygel-av-transport.vala:732: Trying to parse m3u playlist");
#line 3878 "rygel-av-transport.c"
		{
#line 734 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_data_->_tmp24_ = NULL;
#line 734 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_data_->_tmp24_ = _data_->stream;
#line 734 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_data_->_tmp25_ = 0UL;
#line 734 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_data_->_tmp26_ = NULL;
#line 734 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_data_->_tmp26_ = g_data_input_stream_read_line (_data_->_tmp24_, &_data_->_tmp25_, NULL, &_data_->_inner_error_);
#line 734 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_data_->length = _data_->_tmp25_;
#line 734 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_data_->line = _data_->_tmp26_;
#line 734 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 3896 "rygel-av-transport.c"
				goto __catch3_g_error;
			}
#line 735 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			while (TRUE) {
#line 735 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp27_ = NULL;
#line 735 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp27_ = _data_->line;
#line 735 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				if (!(_data_->_tmp27_ != NULL)) {
#line 735 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					break;
#line 3909 "rygel-av-transport.c"
				}
#line 738 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				while (TRUE) {
#line 738 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_data_->_tmp29_ = NULL;
#line 738 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_data_->_tmp29_ = _data_->line;
#line 738 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					if (_data_->_tmp29_ != NULL) {
#line 738 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
						_data_->_tmp30_ = NULL;
#line 738 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
						_data_->_tmp30_ = _data_->line;
#line 738 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
						_data_->_tmp31_ = FALSE;
#line 738 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
						_data_->_tmp31_ = g_str_has_prefix (_data_->_tmp30_, "#");
#line 738 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
						_data_->_tmp28_ = _data_->_tmp31_;
#line 3929 "rygel-av-transport.c"
					} else {
#line 738 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
						_data_->_tmp28_ = FALSE;
#line 3933 "rygel-av-transport.c"
					}
#line 738 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					if (!_data_->_tmp28_) {
#line 738 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
						break;
#line 3939 "rygel-av-transport.c"
					}
#line 739 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_data_->_tmp33_ = NULL;
#line 739 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_data_->_tmp33_ = _data_->stream;
#line 739 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_data_->_tmp34_ = 0UL;
#line 739 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_data_->_tmp35_ = NULL;
#line 739 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_data_->_tmp35_ = g_data_input_stream_read_line (_data_->_tmp33_, &_data_->_tmp34_, NULL, &_data_->_inner_error_);
#line 739 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_data_->length = _data_->_tmp34_;
#line 739 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_data_->_tmp32_ = _data_->_tmp35_;
#line 739 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 739 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
						_g_free0 (_data_->line);
#line 3959 "rygel-av-transport.c"
						goto __catch3_g_error;
					}
#line 739 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_data_->_tmp36_ = NULL;
#line 739 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_data_->_tmp36_ = _data_->_tmp32_;
#line 739 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_data_->_tmp32_ = NULL;
#line 739 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_g_free0 (_data_->line);
#line 739 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_data_->line = _data_->_tmp36_;
#line 738 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_g_free0 (_data_->_tmp32_);
#line 3974 "rygel-av-transport.c"
				}
#line 743 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp37_ = NULL;
#line 743 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp37_ = _data_->line;
#line 743 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				if (_data_->_tmp37_ == NULL) {
#line 744 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					break;
#line 3984 "rygel-av-transport.c"
				}
#line 747 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp38_ = NULL;
#line 747 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp38_ = _data_->line;
#line 747 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				g_debug ("rygel-av-transport.vala:747: Adding uri with %s", _data_->_tmp38_);
#line 748 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp39_ = NULL;
#line 748 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp39_ = _data_->collection;
#line 748 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp40_ = NULL;
#line 748 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp40_ = gupnp_media_collection_add_item (_data_->_tmp39_);
#line 748 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->item = _data_->_tmp40_;
#line 749 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp41_ = NULL;
#line 749 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp41_ = _data_->item;
#line 749 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				gupnp_didl_lite_object_set_upnp_class ((GUPnPDIDLLiteObject*) _data_->_tmp41_, "object.item.audioItem");
#line 751 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp42_ = NULL;
#line 751 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp42_ = _data_->item;
#line 751 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp43_ = NULL;
#line 751 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp43_ = gupnp_didl_lite_object_add_resource ((GUPnPDIDLLiteObject*) _data_->_tmp42_);
#line 751 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->resource = _data_->_tmp43_;
#line 752 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp44_ = NULL;
#line 752 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp44_ = gupnp_protocol_info_new_from_string ("*:*:*:*", &_data_->_inner_error_);
#line 752 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->pi = _data_->_tmp44_;
#line 752 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 752 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_g_object_unref0 (_data_->resource);
#line 752 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_g_object_unref0 (_data_->item);
#line 752 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_g_free0 (_data_->line);
#line 4032 "rygel-av-transport.c"
					goto __catch3_g_error;
				}
#line 753 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp45_ = NULL;
#line 753 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp45_ = _data_->resource;
#line 753 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp46_ = NULL;
#line 753 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp46_ = _data_->pi;
#line 753 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				gupnp_didl_lite_resource_set_protocol_info (_data_->_tmp45_, _data_->_tmp46_);
#line 754 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp47_ = NULL;
#line 754 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp47_ = _data_->resource;
#line 754 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp48_ = NULL;
#line 754 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp48_ = _data_->line;
#line 754 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp49_ = NULL;
#line 754 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp49_ = string_strip (_data_->_tmp48_);
#line 754 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp50_ = NULL;
#line 754 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp50_ = _data_->_tmp49_;
#line 754 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				gupnp_didl_lite_resource_set_uri (_data_->_tmp47_, _data_->_tmp50_);
#line 754 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_g_free0 (_data_->_tmp50_);
#line 756 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp52_ = NULL;
#line 756 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp52_ = _data_->stream;
#line 756 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp53_ = 0UL;
#line 756 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp54_ = NULL;
#line 756 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp54_ = g_data_input_stream_read_line (_data_->_tmp52_, &_data_->_tmp53_, NULL, &_data_->_inner_error_);
#line 756 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->length = _data_->_tmp53_;
#line 756 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp51_ = _data_->_tmp54_;
#line 756 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 756 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_g_object_unref0 (_data_->pi);
#line 756 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_g_object_unref0 (_data_->resource);
#line 756 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_g_object_unref0 (_data_->item);
#line 756 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_g_free0 (_data_->line);
#line 4089 "rygel-av-transport.c"
					goto __catch3_g_error;
				}
#line 756 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp55_ = NULL;
#line 756 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp55_ = _data_->_tmp51_;
#line 756 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp51_ = NULL;
#line 756 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_g_free0 (_data_->line);
#line 756 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->line = _data_->_tmp55_;
#line 735 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_g_free0 (_data_->_tmp51_);
#line 735 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_g_object_unref0 (_data_->pi);
#line 735 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_g_object_unref0 (_data_->resource);
#line 735 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_g_object_unref0 (_data_->item);
#line 4110 "rygel-av-transport.c"
			}
#line 733 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_g_free0 (_data_->line);
#line 4114 "rygel-av-transport.c"
		}
		goto __finally3;
		__catch3_g_error:
		{
#line 733 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_data_->_error_ = _data_->_inner_error_;
#line 733 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_data_->_inner_error_ = NULL;
#line 759 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_data_->_tmp56_ = NULL;
#line 759 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_data_->_tmp56_ = _ ("Problem parsing playlist: %s");
#line 759 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_data_->_tmp57_ = NULL;
#line 759 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_data_->_tmp57_ = _data_->_error_;
#line 759 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_data_->_tmp58_ = NULL;
#line 759 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_data_->_tmp58_ = _data_->_tmp57_->message;
#line 759 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			g_warning (_data_->_tmp56_, _data_->_tmp58_);
#line 761 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_data_->_tmp59_ = NULL;
#line 761 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_data_->_tmp59_ = _data_->action;
#line 761 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_data_->_tmp60_ = NULL;
#line 761 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_data_->_tmp60_ = _ ("Resource not found");
#line 761 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			gupnp_service_action_return_error (_data_->_tmp59_, (guint) 716, _data_->_tmp60_);
#line 763 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_g_error_free0 (_data_->_error_);
#line 763 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_g_object_unref0 (_data_->stream);
#line 763 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_g_object_unref0 (_data_->m_stream);
#line 763 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_g_object_unref0 (_data_->collection);
#line 763 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_g_free0 (_data_->content_type);
#line 763 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_g_object_unref0 (_data_->message);
#line 763 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			block2_data_unref (_data_->_data2_);
#line 763 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_data_->_data2_ = NULL;
#line 763 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			if (_data_->_state_ == 0) {
#line 763 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4167 "rygel-av-transport.c"
			} else {
#line 763 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 4171 "rygel-av-transport.c"
			}
#line 763 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			g_object_unref (_data_->_async_result);
#line 763 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			return FALSE;
#line 4177 "rygel-av-transport.c"
		}
		__finally3:
#line 733 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 733 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_g_object_unref0 (_data_->stream);
#line 733 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_g_object_unref0 (_data_->m_stream);
#line 733 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_g_object_unref0 (_data_->collection);
#line 733 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_g_free0 (_data_->content_type);
#line 733 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_g_object_unref0 (_data_->message);
#line 733 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			block2_data_unref (_data_->_data2_);
#line 733 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_data_->_data2_ = NULL;
#line 733 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 733 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			g_clear_error (&_data_->_inner_error_);
#line 733 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			return FALSE;
#line 4202 "rygel-av-transport.c"
		}
#line 725 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_object_unref0 (_data_->stream);
#line 725 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_object_unref0 (_data_->m_stream);
#line 4208 "rygel-av-transport.c"
	} else {
#line 766 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp61_ = NULL;
#line 766 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp61_ = _data_->message;
#line 766 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp62_ = NULL;
#line 766 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp62_ = _data_->_tmp61_->response_body;
#line 766 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp63_ = NULL;
#line 766 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp63__length1 = 0;
#line 766 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp63_ = _data_->_tmp62_->data;
#line 766 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp63__length1 = (gint) _data_->_tmp62_->length;
#line 766 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->xml_string = (const gchar*) _data_->_tmp63_;
#line 767 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp64_ = NULL;
#line 767 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp64_ = _data_->xml_string;
#line 767 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp65_ = NULL;
#line 767 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp65_ = gupnp_media_collection_new_from_string (_data_->_tmp64_);
#line 767 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_object_unref0 (_data_->collection);
#line 767 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->collection = _data_->_tmp65_;
#line 768 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp66_ = NULL;
#line 768 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp66_ = _data_->collection;
#line 768 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp67_ = NULL;
#line 768 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp67_ = gupnp_media_collection_get_items (_data_->_tmp66_);
#line 768 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp68_ = NULL;
#line 768 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp68_ = _data_->_tmp67_;
#line 768 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp69_ = 0U;
#line 768 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp69_ = g_list_length (_data_->_tmp68_);
#line 768 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp70_ = FALSE;
#line 768 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp70_ = _data_->_tmp69_ == ((guint) 0);
#line 768 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		__g_list_free__g_object_unref0_0 (_data_->_tmp68_);
#line 768 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		if (_data_->_tmp70_) {
#line 770 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_data_->_tmp71_ = NULL;
#line 770 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_data_->_tmp71_ = _data_->action;
#line 770 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_data_->_tmp72_ = NULL;
#line 770 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_data_->_tmp72_ = _ ("Resource not found");
#line 770 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			gupnp_service_action_return_error (_data_->_tmp71_, (guint) 716, _data_->_tmp72_);
#line 772 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_g_object_unref0 (_data_->collection);
#line 772 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_g_free0 (_data_->content_type);
#line 772 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_g_object_unref0 (_data_->message);
#line 772 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			block2_data_unref (_data_->_data2_);
#line 772 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_data_->_data2_ = NULL;
#line 772 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			if (_data_->_state_ == 0) {
#line 772 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4288 "rygel-av-transport.c"
			} else {
#line 772 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 4292 "rygel-av-transport.c"
			}
#line 772 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			g_object_unref (_data_->_async_result);
#line 772 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			return FALSE;
#line 4298 "rygel-av-transport.c"
		}
	}
#line 776 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp73_ = NULL;
#line 776 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp73_ = _data_->action;
#line 776 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp74_ = NULL;
#line 776 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp74_ = gupnp_service_action_get_name (_data_->_tmp73_);
#line 776 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp75_ = NULL;
#line 776 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp77_ = 0U;
#line 776 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp75_ = _data_->_tmp74_;
#line 776 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp77_ = (NULL == _data_->_tmp75_) ? 0 : g_quark_from_string (_data_->_tmp75_);
#line 776 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_data_->_tmp77_ == ((0 != _tmp76_label0) ? _tmp76_label0 : (_tmp76_label0 = g_quark_from_static_string ("SetAVTransportURI")))) {
#line 776 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		switch (0) {
#line 4321 "rygel-av-transport.c"
			default:
			{
#line 778 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp78_ = NULL;
#line 778 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp78_ = _data_->self->priv->controller;
#line 778 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp79_ = NULL;
#line 778 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp79_ = _data_->uri;
#line 778 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp80_ = NULL;
#line 778 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp80_ = _data_->metadata;
#line 778 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp81_ = NULL;
#line 778 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp81_ = _data_->collection;
#line 778 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				rygel_player_controller_set_playlist_uri (_data_->_tmp78_, _data_->_tmp79_, _data_->_tmp80_, _data_->_tmp81_);
#line 779 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				break;
#line 4344 "rygel-av-transport.c"
			}
		}
	} else if (_data_->_tmp77_ == ((0 != _tmp76_label1) ? _tmp76_label1 : (_tmp76_label1 = g_quark_from_static_string ("SetNextAVTransportURI")))) {
#line 776 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		switch (0) {
#line 4350 "rygel-av-transport.c"
			default:
			{
#line 781 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp82_ = NULL;
#line 781 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp82_ = _data_->self->priv->controller;
#line 781 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp83_ = NULL;
#line 781 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp83_ = _data_->uri;
#line 781 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp84_ = NULL;
#line 781 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp84_ = _data_->metadata;
#line 781 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp85_ = NULL;
#line 781 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_data_->_tmp85_ = _data_->collection;
#line 781 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				rygel_player_controller_set_next_playlist_uri (_data_->_tmp82_, _data_->_tmp83_, _data_->_tmp84_, _data_->_tmp85_);
#line 782 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				break;
#line 4373 "rygel-av-transport.c"
			}
		}
	} else {
#line 776 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		switch (0) {
#line 4379 "rygel-av-transport.c"
			default:
			{
#line 784 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				g_assert_not_reached ();
#line 4384 "rygel-av-transport.c"
			}
		}
	}
#line 787 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp86_ = NULL;
#line 787 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp86_ = _data_->action;
#line 787 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_data_->_tmp86_);
#line 705 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (_data_->collection);
#line 705 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_data_->content_type);
#line 705 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (_data_->message);
#line 705 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	block2_data_unref (_data_->_data2_);
#line 705 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_data2_ = NULL;
#line 705 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_data_->_state_ == 0) {
#line 705 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4408 "rygel-av-transport.c"
	} else {
#line 705 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4412 "rygel-av-transport.c"
	}
#line 705 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_unref (_data_->_async_result);
#line 705 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return FALSE;
#line 4418 "rygel-av-transport.c"
}


static gboolean rygel_av_transport_is_playlist (RygelAVTransport* self, const gchar* mime, const gchar* features) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
#line 790 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 791 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = mime;
#line 791 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp4_ != NULL) {
#line 4435 "rygel-av-transport.c"
		const gchar* _tmp5_ = NULL;
#line 791 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp5_ = mime;
#line 791 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp3_ = g_strcmp0 (_tmp5_, "text/xml") == 0;
#line 4441 "rygel-av-transport.c"
	} else {
#line 791 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp3_ = FALSE;
#line 4445 "rygel-av-transport.c"
	}
#line 791 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp3_) {
#line 4449 "rygel-av-transport.c"
		const gchar* _tmp6_ = NULL;
#line 792 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp6_ = features;
#line 792 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp2_ = _tmp6_ != NULL;
#line 4455 "rygel-av-transport.c"
	} else {
#line 791 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp2_ = FALSE;
#line 4459 "rygel-av-transport.c"
	}
#line 791 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp2_) {
#line 4463 "rygel-av-transport.c"
		const gchar* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 793 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp7_ = features;
#line 793 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp8_ = g_str_has_prefix (_tmp7_, "DLNA.ORG_PN=DIDL_S");
#line 793 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp1_ = _tmp8_;
#line 4472 "rygel-av-transport.c"
	} else {
#line 791 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp1_ = FALSE;
#line 4476 "rygel-av-transport.c"
	}
#line 791 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp1_) {
#line 791 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp0_ = TRUE;
#line 4482 "rygel-av-transport.c"
	} else {
		const gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
#line 794 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp9_ = mime;
#line 794 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp10_ = g_str_has_suffix (_tmp9_, "mpegurl");
#line 794 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp0_ = _tmp10_;
#line 4492 "rygel-av-transport.c"
	}
#line 791 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	result = _tmp0_;
#line 791 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return result;
#line 4498 "rygel-av-transport.c"
}


static void ___lambda8_ (RygelAVTransport* self, SoupMessage* msg) {
	SoupSession* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessage* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
#line 816 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (msg != NULL);
#line 817 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->head_faked = TRUE;
#line 818 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->session;
#line 818 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = msg;
#line 818 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = msg;
#line 818 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_get (_tmp2_, "status-code", &_tmp3_, NULL);
#line 818 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 818 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	soup_session_cancel_message (_tmp0_, _tmp1_, _tmp4_);
#line 4524 "rygel-av-transport.c"
}


static void ____lambda8__soup_message_got_headers (SoupMessage* _sender, gpointer self) {
#line 816 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	___lambda8_ ((RygelAVTransport*) self, _sender);
#line 4531 "rygel-av-transport.c"
}


static void rygel_av_transport_check_resource (RygelAVTransport* self, SoupMessage* msg, const gchar* _uri, const gchar* _metadata, GUPnPServiceAction* action) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	SoupMessage* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	gboolean _tmp25_ = FALSE;
	SoupMessage* _tmp26_ = NULL;
	guint _tmp27_ = 0U;
	guint _tmp28_ = 0U;
	gchar* mime = NULL;
	SoupMessage* _tmp38_ = NULL;
	SoupMessageHeaders* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gchar* features = NULL;
	SoupMessage* _tmp42_ = NULL;
	SoupMessageHeaders* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gboolean _tmp46_ = FALSE;
	const gchar* _tmp47_ = NULL;
	gboolean _tmp48_ = FALSE;
	const gchar* _tmp55_ = NULL;
	const gchar* _tmp56_ = NULL;
	gboolean _tmp57_ = FALSE;
#line 799 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 799 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (msg != NULL);
#line 799 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (_uri != NULL);
#line 799 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (_metadata != NULL);
#line 799 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 806 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = msg;
#line 806 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_get (_tmp4_, "status-code", &_tmp5_, NULL);
#line 806 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = _tmp5_;
#line 806 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp6_ == ((guint) SOUP_STATUS_MALFORMED)) {
#line 806 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp3_ = TRUE;
#line 4583 "rygel-av-transport.c"
	} else {
		SoupMessage* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
		guint _tmp9_ = 0U;
#line 807 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp7_ = msg;
#line 807 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_object_get (_tmp7_, "status-code", &_tmp8_, NULL);
#line 807 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp9_ = _tmp8_;
#line 807 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp3_ = _tmp9_ == ((guint) SOUP_STATUS_BAD_REQUEST);
#line 4596 "rygel-av-transport.c"
	}
#line 806 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp3_) {
#line 806 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp2_ = TRUE;
#line 4602 "rygel-av-transport.c"
	} else {
		SoupMessage* _tmp10_ = NULL;
		guint _tmp11_ = 0U;
		guint _tmp12_ = 0U;
#line 808 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp10_ = msg;
#line 808 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_object_get (_tmp10_, "status-code", &_tmp11_, NULL);
#line 808 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp12_ = _tmp11_;
#line 808 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp2_ = _tmp12_ == ((guint) SOUP_STATUS_METHOD_NOT_ALLOWED);
#line 4615 "rygel-av-transport.c"
	}
#line 806 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp2_) {
#line 806 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp1_ = TRUE;
#line 4621 "rygel-av-transport.c"
	} else {
		SoupMessage* _tmp13_ = NULL;
		guint _tmp14_ = 0U;
		guint _tmp15_ = 0U;
#line 809 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp13_ = msg;
#line 809 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_object_get (_tmp13_, "status-code", &_tmp14_, NULL);
#line 809 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp15_ = _tmp14_;
#line 809 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp1_ = _tmp15_ == ((guint) SOUP_STATUS_NOT_IMPLEMENTED);
#line 4634 "rygel-av-transport.c"
	}
#line 806 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp1_) {
#line 4638 "rygel-av-transport.c"
		SoupMessage* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
#line 810 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp16_ = msg;
#line 810 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_object_get (_tmp16_, "method", &_tmp17_, NULL);
#line 810 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp18_ = _tmp17_;
#line 810 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp19_ = _tmp18_;
#line 810 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp0_ = g_strcmp0 (_tmp19_, "HEAD") == 0;
#line 810 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (_tmp19_);
#line 4655 "rygel-av-transport.c"
	} else {
#line 806 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp0_ = FALSE;
#line 4659 "rygel-av-transport.c"
	}
#line 806 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp0_) {
#line 4663 "rygel-av-transport.c"
		SoupMessage* _tmp20_ = NULL;
		SoupMessage* _tmp21_ = NULL;
		SoupSession* _tmp22_ = NULL;
		SoupMessage* _tmp23_ = NULL;
		SoupMessage* _tmp24_ = NULL;
#line 811 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_debug ("rygel-av-transport.vala:811: Peer does not support HEAD, trying GET");
#line 812 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp20_ = msg;
#line 812 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_object_set (_tmp20_, "method", "GET", NULL);
#line 816 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp21_ = msg;
#line 816 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_signal_connect_object (_tmp21_, "got-headers", (GCallback) ____lambda8__soup_message_got_headers, self, 0);
#line 821 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp22_ = self->priv->session;
#line 821 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp23_ = msg;
#line 821 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp24_ = _g_object_ref0 (_tmp23_);
#line 821 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		soup_session_queue_message (_tmp22_, _tmp24_, NULL, NULL);
#line 823 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 4689 "rygel-av-transport.c"
	}
#line 826 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp26_ = msg;
#line 826 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_get (_tmp26_, "status-code", &_tmp27_, NULL);
#line 826 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp28_ = _tmp27_;
#line 826 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp28_ != ((guint) SOUP_STATUS_OK)) {
#line 4699 "rygel-av-transport.c"
		gboolean _tmp29_ = FALSE;
#line 826 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp29_ = self->priv->head_faked;
#line 826 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp25_ = !_tmp29_;
#line 4705 "rygel-av-transport.c"
	} else {
#line 826 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp25_ = FALSE;
#line 4709 "rygel-av-transport.c"
	}
#line 826 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp25_) {
#line 4713 "rygel-av-transport.c"
		const gchar* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		SoupMessage* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		GUPnPServiceAction* _tmp36_ = NULL;
		const gchar* _tmp37_ = NULL;
#line 829 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp30_ = _ ("Failed to access resource at %s: %s");
#line 829 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp31_ = _uri;
#line 829 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp32_ = msg;
#line 829 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_object_get (_tmp32_, "reason-phrase", &_tmp33_, NULL);
#line 829 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp34_ = _tmp33_;
#line 829 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp35_ = _tmp34_;
#line 829 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_warning (_tmp30_, _tmp31_, _tmp35_);
#line 829 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (_tmp35_);
#line 833 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp36_ = action;
#line 833 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp37_ = _ ("Resource not found");
#line 833 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return_error (_tmp36_, (guint) 716, _tmp37_);
#line 835 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 4746 "rygel-av-transport.c"
	}
#line 838 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp38_ = msg;
#line 838 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp39_ = _tmp38_->response_headers;
#line 838 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp40_ = soup_message_headers_get_one (_tmp39_, "Content-Type");
#line 838 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp41_ = g_strdup (_tmp40_);
#line 838 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	mime = _tmp41_;
#line 839 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp42_ = msg;
#line 839 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp43_ = _tmp42_->response_headers;
#line 839 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp44_ = soup_message_headers_get_one (_tmp43_, "contentFeatures.dlna.org");
#line 839 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp45_ = g_strdup (_tmp44_);
#line 839 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	features = _tmp45_;
#line 842 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp47_ = mime;
#line 842 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp48_ = rygel_av_transport_is_valid_mime_type (self, _tmp47_);
#line 842 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp48_) {
#line 4774 "rygel-av-transport.c"
		const gchar* _tmp49_ = NULL;
		const gchar* _tmp50_ = NULL;
		gboolean _tmp51_ = FALSE;
#line 843 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp49_ = mime;
#line 843 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp50_ = features;
#line 843 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp51_ = rygel_av_transport_is_playlist (self, _tmp49_, _tmp50_);
#line 843 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp46_ = !_tmp51_;
#line 4786 "rygel-av-transport.c"
	} else {
#line 842 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp46_ = FALSE;
#line 4790 "rygel-av-transport.c"
	}
#line 842 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp46_) {
#line 4794 "rygel-av-transport.c"
		const gchar* _tmp52_ = NULL;
		GUPnPServiceAction* _tmp53_ = NULL;
		const gchar* _tmp54_ = NULL;
#line 844 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp52_ = mime;
#line 844 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_debug ("rygel-av-transport.vala:844: Unsupported mime type %s", _tmp52_);
#line 845 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp53_ = action;
#line 845 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp54_ = _ ("Illegal MIME-type");
#line 845 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return_error (_tmp53_, (guint) 714, _tmp54_);
#line 847 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (features);
#line 847 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (mime);
#line 847 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 4814 "rygel-av-transport.c"
	}
#line 850 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp55_ = mime;
#line 850 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp56_ = features;
#line 850 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp57_ = rygel_av_transport_is_playlist (self, _tmp55_, _tmp56_);
#line 850 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp57_) {
#line 4824 "rygel-av-transport.c"
		GUPnPServiceAction* _tmp58_ = NULL;
		const gchar* _tmp59_ = NULL;
		const gchar* _tmp60_ = NULL;
		const gchar* _tmp61_ = NULL;
		const gchar* _tmp62_ = NULL;
#line 852 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp58_ = action;
#line 852 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp59_ = _uri;
#line 852 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp60_ = _metadata;
#line 852 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp61_ = mime;
#line 852 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp62_ = features;
#line 852 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_av_transport_handle_playlist (self, _tmp58_, _tmp59_, _tmp60_, _tmp61_, _tmp62_, NULL, NULL);
#line 4842 "rygel-av-transport.c"
	} else {
		GUPnPServiceAction* _tmp63_ = NULL;
		const gchar* _tmp64_ = NULL;
		const gchar* _tmp65_ = NULL;
		const gchar* _tmp66_ = NULL;
		const gchar* _tmp67_ = NULL;
#line 858 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp63_ = action;
#line 858 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp64_ = _uri;
#line 858 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp65_ = _metadata;
#line 858 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp66_ = mime;
#line 858 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp67_ = features;
#line 858 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_av_transport_set_single_play_uri (self, _tmp63_, _tmp64_, _tmp65_, _tmp66_, _tmp67_);
#line 4861 "rygel-av-transport.c"
	}
#line 799 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (features);
#line 799 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (mime);
#line 4867 "rygel-av-transport.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return _data3_;
#line 4876 "rygel-av-transport.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 4885 "rygel-av-transport.c"
		RygelAVTransport* self;
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		self = _data3_->self;
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		__vala_GUPnPServiceAction_free0 (_data3_->action);
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (_data3_->uri);
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (_data3_->metadata);
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_object_unref0 (self);
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_slice_free (Block3Data, _data3_);
#line 4899 "rygel-av-transport.c"
	}
}


static void ___lambda7_ (Block3Data* _data3_, SoupMessage* msg) {
	RygelAVTransport* self;
	SoupMessage* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GUPnPServiceAction* _tmp3_ = NULL;
#line 870 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self = _data3_->self;
#line 870 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (msg != NULL);
#line 871 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = msg;
#line 871 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = _data3_->uri;
#line 871 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = _data3_->metadata;
#line 871 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _data3_->action;
#line 871 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_check_resource (self, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 4924 "rygel-av-transport.c"
}


static void ____lambda7__soup_message_finished (SoupMessage* _sender, gpointer self) {
#line 870 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	___lambda7_ (self, _sender);
#line 4931 "rygel-av-transport.c"
}


static void rygel_av_transport_handle_new_transport_uri (RygelAVTransport* self, GUPnPServiceAction* action, const gchar* uri, const gchar* metadata) {
	Block3Data* _data3_;
	GUPnPServiceAction* _tmp0_ = NULL;
	GUPnPServiceAction* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (uri != NULL);
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (metadata != NULL);
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data3_->_ref_count_ = 1;
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data3_->self = g_object_ref (self);
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	__vala_GUPnPServiceAction_free0 (_data3_->action);
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data3_->action = _tmp1_;
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = uri;
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_data3_->uri);
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data3_->uri = _tmp3_;
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = metadata;
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_data3_->metadata);
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data3_->metadata = _tmp5_;
#line 865 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = _data3_->uri;
#line 865 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp8_ = g_str_has_prefix (_tmp7_, "http://");
#line 865 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp8_) {
#line 865 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp6_ = TRUE;
#line 4992 "rygel-av-transport.c"
	} else {
		const gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
#line 865 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp9_ = _data3_->uri;
#line 865 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp10_ = g_str_has_prefix (_tmp9_, "https://");
#line 865 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp6_ = _tmp10_;
#line 5002 "rygel-av-transport.c"
	}
#line 865 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp6_) {
#line 5006 "rygel-av-transport.c"
		SoupMessage* message = NULL;
		const gchar* _tmp11_ = NULL;
		SoupMessage* _tmp12_ = NULL;
		SoupMessage* _tmp13_ = NULL;
		SoupMessageHeaders* _tmp14_ = NULL;
		SoupMessage* _tmp15_ = NULL;
		SoupSession* _tmp16_ = NULL;
		SoupMessage* _tmp17_ = NULL;
		SoupMessage* _tmp18_ = NULL;
#line 866 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp11_ = _data3_->uri;
#line 866 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp12_ = soup_message_new ("HEAD", _tmp11_);
#line 866 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		message = _tmp12_;
#line 867 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp13_ = message;
#line 867 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp14_ = _tmp13_->request_headers;
#line 867 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		soup_message_headers_append (_tmp14_, "getContentFeatures.dlna.org", "1");
#line 869 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		self->priv->head_faked = FALSE;
#line 870 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp15_ = message;
#line 870 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_signal_connect_data (_tmp15_, "finished", (GCallback) ____lambda7__soup_message_finished, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 874 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp16_ = self->priv->session;
#line 874 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp17_ = message;
#line 874 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp18_ = _g_object_ref0 (_tmp17_);
#line 874 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		soup_session_queue_message (_tmp16_, _tmp18_, NULL, NULL);
#line 865 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_object_unref0 (message);
#line 5044 "rygel-av-transport.c"
	} else {
		GUPnPServiceAction* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
#line 876 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp19_ = _data3_->action;
#line 876 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp20_ = _data3_->uri;
#line 876 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp21_ = _data3_->metadata;
#line 876 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_av_transport_set_single_play_uri (self, _tmp19_, _tmp20_, _tmp21_, NULL, NULL);
#line 5057 "rygel-av-transport.c"
	}
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	block3_data_unref (_data3_);
#line 862 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data3_ = NULL;
#line 5063 "rygel-av-transport.c"
}


static void rygel_av_transport_set_single_play_uri (RygelAVTransport* self, GUPnPServiceAction* action, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features) {
	GUPnPServiceAction* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GQuark _tmp4_ = 0U;
#line 885 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	static GQuark _tmp3_label0 = 0;
#line 885 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	static GQuark _tmp3_label1 = 0;
#line 5076 "rygel-av-transport.c"
	GUPnPServiceAction* _tmp15_ = NULL;
#line 880 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 880 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 880 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (uri != NULL);
#line 880 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (metadata != NULL);
#line 885 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 885 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = gupnp_service_action_get_name (_tmp0_);
#line 885 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = _tmp1_;
#line 885 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
#line 885 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("SetAVTransportURI")))) {
#line 885 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		switch (0) {
#line 5098 "rygel-av-transport.c"
			default:
			{
				RygelPlayerController* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
#line 887 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp5_ = self->priv->controller;
#line 887 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp6_ = uri;
#line 887 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp7_ = metadata;
#line 887 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp8_ = mime;
#line 887 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp9_ = features;
#line 887 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				rygel_player_controller_set_single_play_uri (_tmp5_, _tmp6_, _tmp7_, _tmp8_, _tmp9_);
#line 888 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				break;
#line 5120 "rygel-av-transport.c"
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("SetNextAVTransportURI")))) {
#line 885 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		switch (0) {
#line 5126 "rygel-av-transport.c"
			default:
			{
				RygelPlayerController* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
#line 890 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp10_ = self->priv->controller;
#line 890 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp11_ = uri;
#line 890 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp12_ = metadata;
#line 890 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp13_ = mime;
#line 890 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp14_ = features;
#line 890 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				rygel_player_controller_set_next_single_play_uri (_tmp10_, _tmp11_, _tmp12_, _tmp13_, _tmp14_);
#line 891 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				break;
#line 5148 "rygel-av-transport.c"
			}
		}
	} else {
#line 885 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		switch (0) {
#line 5154 "rygel-av-transport.c"
			default:
			{
#line 893 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				g_assert_not_reached ();
#line 5159 "rygel-av-transport.c"
			}
		}
	}
#line 896 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp15_ = action;
#line 896 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp15_);
#line 5167 "rygel-av-transport.c"
}


RygelAVTransport* rygel_av_transport_construct (GType object_type) {
	RygelAVTransport * self = NULL;
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self = (RygelAVTransport*) g_object_new (object_type, NULL);
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return self;
#line 5177 "rygel-av-transport.c"
}


RygelAVTransport* rygel_av_transport_new (void) {
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return rygel_av_transport_construct (RYGEL_TYPE_AV_TRANSPORT);
#line 5184 "rygel-av-transport.c"
}


const gchar* rygel_av_transport_get_status (RygelAVTransport* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 47 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 48 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->_status;
#line 48 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	result = _tmp0_;
#line 48 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return result;
#line 5199 "rygel-av-transport.c"
}


void rygel_av_transport_set_status (RygelAVTransport* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	RygelChangeLog* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 52 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = value;
#line 52 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 52 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (self->priv->_status);
#line 52 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->_status = _tmp1_;
#line 54 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = self->priv->changelog;
#line 54 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = self->priv->_status;
#line 54 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp2_, "TransportStatus", _tmp3_);
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_notify ((GObject *) self, "status");
#line 5226 "rygel-av-transport.c"
}


const gchar* rygel_av_transport_get_playback_medium (RygelAVTransport* self) {
	const gchar* result;
	RygelPlayerController* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 59 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 60 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->controller;
#line 60 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_player_controller_get_uri (_tmp0_);
#line 60 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = _tmp1_;
#line 60 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 60 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = g_strcmp0 (_tmp3_, "") == 0;
#line 60 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp3_);
#line 60 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp4_) {
#line 61 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		result = "NONE";
#line 61 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return result;
#line 5257 "rygel-av-transport.c"
	} else {
#line 63 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		result = "NETWORK";
#line 63 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return result;
#line 5263 "rygel-av-transport.c"
	}
}


gchar* rygel_av_transport_get_speed (RygelAVTransport* self) {
	gchar* result;
	RygelMediaPlayer* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 69 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 70 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->player;
#line 70 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_media_player_get_playback_speed (_tmp0_);
#line 70 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = _tmp1_;
#line 70 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	result = _tmp2_;
#line 70 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return result;
#line 5285 "rygel-av-transport.c"
}


void rygel_av_transport_set_speed (RygelAVTransport* self, const gchar* value) {
	RygelMediaPlayer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	RygelChangeLog* _tmp2_ = NULL;
	RygelMediaPlayer* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
#line 73 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 74 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->player;
#line 74 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = value;
#line 74 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_media_player_set_playback_speed (_tmp0_, _tmp1_);
#line 76 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = self->priv->changelog;
#line 76 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = self->priv->player;
#line 76 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = rygel_media_player_get_playback_speed (_tmp3_);
#line 76 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _tmp4_;
#line 76 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = _tmp5_;
#line 76 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp2_, "TransportPlaySpeed", _tmp6_);
#line 76 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp6_);
#line 73 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_notify ((GObject *) self, "speed");
#line 5321 "rygel-av-transport.c"
}


static void rygel_av_transport_class_init (RygelAVTransportClass * klass) {
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_parent_class = g_type_class_peek_parent (klass);
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_type_class_add_private (klass, sizeof (RygelAVTransportPrivate));
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	((GObjectClass *) klass)->constructed = rygel_av_transport_real_constructed;
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_av_transport_get_property;
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_av_transport_set_property;
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_av_transport_finalize;
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_STATUS, g_param_spec_string ("status", "status", "status", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_PLAYBACK_MEDIUM, g_param_spec_string ("playback-medium", "playback-medium", "playback-medium", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_SPEED, g_param_spec_string ("speed", "speed", "speed", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 5344 "rygel-av-transport.c"
}


static void rygel_av_transport_instance_init (RygelAVTransport * self) {
	gchar* _tmp0_ = NULL;
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv = RYGEL_AV_TRANSPORT_GET_PRIVATE (self);
#line 45 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = g_strdup ("OK");
#line 45 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->_status = _tmp0_;
#line 5356 "rygel-av-transport.c"
}


static void rygel_av_transport_finalize (GObject* obj) {
	RygelAVTransport * self;
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport);
#line 42 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (self->priv->session);
#line 43 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (self->priv->protocol_info);
#line 45 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (self->priv->_status);
#line 80 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (self->priv->changelog);
#line 81 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (self->priv->player);
#line 82 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (self->priv->controller);
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	G_OBJECT_CLASS (rygel_av_transport_parent_class)->finalize (obj);
#line 5378 "rygel-av-transport.c"
}


GType rygel_av_transport_get_type (void) {
	static volatile gsize rygel_av_transport_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_av_transport_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelAVTransportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_av_transport_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelAVTransport), 0, (GInstanceInitFunc) rygel_av_transport_instance_init, NULL };
		GType rygel_av_transport_type_id;
		rygel_av_transport_type_id = g_type_register_static (gupnp_service_get_type (), "RygelAVTransport", &g_define_type_info, 0);
		g_once_init_leave (&rygel_av_transport_type_id__volatile, rygel_av_transport_type_id);
	}
	return rygel_av_transport_type_id__volatile;
}


static void _vala_rygel_av_transport_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelAVTransport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport);
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	switch (property_id) {
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_STATUS:
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_value_set_string (value, rygel_av_transport_get_status (self));
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_PLAYBACK_MEDIUM:
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_value_set_string (value, rygel_av_transport_get_playback_medium (self));
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_SPEED:
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_value_take_string (value, rygel_av_transport_get_speed (self));
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 5417 "rygel-av-transport.c"
		default:
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 5423 "rygel-av-transport.c"
	}
}


static void _vala_rygel_av_transport_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelAVTransport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport);
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	switch (property_id) {
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_STATUS:
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_av_transport_set_status (self, g_value_get_string (value));
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_SPEED:
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_av_transport_set_speed (self, g_value_get_string (value));
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 5445 "rygel-av-transport.c"
		default:
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 5451 "rygel-av-transport.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



