/* rygel-player-controller.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-player-controller.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2014 Atlantic PuffinPack AB.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_PLAYER_CONTROLLER (rygel_player_controller_get_type ())
#define RYGEL_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerController))
#define RYGEL_IS_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAYER_CONTROLLER))
#define RYGEL_PLAYER_CONTROLLER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerControllerIface))

typedef struct _RygelPlayerController RygelPlayerController;
typedef struct _RygelPlayerControllerIface RygelPlayerControllerIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelPlayerControllerIface {
	GTypeInterface parent_iface;
	gboolean (*next) (RygelPlayerController* self);
	gboolean (*previous) (RygelPlayerController* self);
	void (*set_single_play_uri) (RygelPlayerController* self, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features);
	void (*set_playlist_uri) (RygelPlayerController* self, const gchar* uri, const gchar* metadata, GUPnPMediaCollection* collection);
	void (*set_next_single_play_uri) (RygelPlayerController* self, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features);
	void (*set_next_playlist_uri) (RygelPlayerController* self, const gchar* uri, const gchar* metadata, GUPnPMediaCollection* collection);
	gboolean (*is_play_mode_valid) (RygelPlayerController* self, const gchar* play_mode);
	const gchar* (*get_playback_state) (RygelPlayerController* self);
	void (*set_playback_state) (RygelPlayerController* self, const gchar* value);
	guint (*get_n_tracks) (RygelPlayerController* self);
	void (*set_n_tracks) (RygelPlayerController* self, guint value);
	guint (*get_track) (RygelPlayerController* self);
	void (*set_track) (RygelPlayerController* self, guint value);
	gchar* (*get_uri) (RygelPlayerController* self);
	void (*set_uri) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_metadata) (RygelPlayerController* self);
	void (*set_metadata) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_track_uri) (RygelPlayerController* self);
	void (*set_track_uri) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_track_metadata) (RygelPlayerController* self);
	void (*set_track_metadata) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_next_uri) (RygelPlayerController* self);
	void (*set_next_uri) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_next_metadata) (RygelPlayerController* self);
	void (*set_next_metadata) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_current_transport_actions) (RygelPlayerController* self);
	const gchar* (*get_play_mode) (RygelPlayerController* self);
	void (*set_play_mode) (RygelPlayerController* self, const gchar* value);
};



GType rygel_player_controller_get_type (void) G_GNUC_CONST;
gboolean rygel_player_controller_next (RygelPlayerController* self);
gboolean rygel_player_controller_previous (RygelPlayerController* self);
void rygel_player_controller_set_single_play_uri (RygelPlayerController* self, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features);
void rygel_player_controller_set_playlist_uri (RygelPlayerController* self, const gchar* uri, const gchar* metadata, GUPnPMediaCollection* collection);
void rygel_player_controller_set_next_single_play_uri (RygelPlayerController* self, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features);
void rygel_player_controller_set_next_playlist_uri (RygelPlayerController* self, const gchar* uri, const gchar* metadata, GUPnPMediaCollection* collection);
gboolean rygel_player_controller_is_play_mode_valid (RygelPlayerController* self, const gchar* play_mode);
gchar* rygel_player_controller_unescape (RygelPlayerController* self, const gchar* input);
const gchar* rygel_player_controller_get_playback_state (RygelPlayerController* self);
void rygel_player_controller_set_playback_state (RygelPlayerController* self, const gchar* value);
guint rygel_player_controller_get_n_tracks (RygelPlayerController* self);
void rygel_player_controller_set_n_tracks (RygelPlayerController* self, guint value);
guint rygel_player_controller_get_track (RygelPlayerController* self);
void rygel_player_controller_set_track (RygelPlayerController* self, guint value);
gchar* rygel_player_controller_get_uri (RygelPlayerController* self);
void rygel_player_controller_set_uri (RygelPlayerController* self, const gchar* value);
gchar* rygel_player_controller_get_metadata (RygelPlayerController* self);
void rygel_player_controller_set_metadata (RygelPlayerController* self, const gchar* value);
gchar* rygel_player_controller_get_track_uri (RygelPlayerController* self);
void rygel_player_controller_set_track_uri (RygelPlayerController* self, const gchar* value);
gchar* rygel_player_controller_get_track_metadata (RygelPlayerController* self);
void rygel_player_controller_set_track_metadata (RygelPlayerController* self, const gchar* value);
gchar* rygel_player_controller_get_next_uri (RygelPlayerController* self);
void rygel_player_controller_set_next_uri (RygelPlayerController* self, const gchar* value);
gchar* rygel_player_controller_get_next_metadata (RygelPlayerController* self);
void rygel_player_controller_set_next_metadata (RygelPlayerController* self, const gchar* value);
gchar* rygel_player_controller_get_current_transport_actions (RygelPlayerController* self);
const gchar* rygel_player_controller_get_play_mode (RygelPlayerController* self);
void rygel_player_controller_set_play_mode (RygelPlayerController* self, const gchar* value);


gboolean rygel_player_controller_next (RygelPlayerController* self) {
#line 65 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 65 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->next (self);
#line 115 "rygel-player-controller.c"
}


gboolean rygel_player_controller_previous (RygelPlayerController* self) {
#line 67 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 67 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->previous (self);
#line 124 "rygel-player-controller.c"
}


void rygel_player_controller_set_single_play_uri (RygelPlayerController* self, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features) {
#line 69 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (self != NULL);
#line 69 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->set_single_play_uri (self, uri, metadata, mime, features);
#line 133 "rygel-player-controller.c"
}


void rygel_player_controller_set_playlist_uri (RygelPlayerController* self, const gchar* uri, const gchar* metadata, GUPnPMediaCollection* collection) {
#line 74 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (self != NULL);
#line 74 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->set_playlist_uri (self, uri, metadata, collection);
#line 142 "rygel-player-controller.c"
}


void rygel_player_controller_set_next_single_play_uri (RygelPlayerController* self, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features) {
#line 78 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (self != NULL);
#line 78 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->set_next_single_play_uri (self, uri, metadata, mime, features);
#line 151 "rygel-player-controller.c"
}


void rygel_player_controller_set_next_playlist_uri (RygelPlayerController* self, const gchar* uri, const gchar* metadata, GUPnPMediaCollection* collection) {
#line 83 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (self != NULL);
#line 83 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->set_next_playlist_uri (self, uri, metadata, collection);
#line 160 "rygel-player-controller.c"
}


gboolean rygel_player_controller_is_play_mode_valid (RygelPlayerController* self, const gchar* play_mode) {
#line 87 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 87 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->is_play_mode_valid (self, play_mode);
#line 169 "rygel-player-controller.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 182 "rygel-player-controller.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 213 "rygel-player-controller.c"
				goto __catch1_g_regex_error;
			}
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return NULL;
#line 222 "rygel-player-controller.c"
		}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 238 "rygel-player-controller.c"
				goto __catch1_g_regex_error;
			}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return NULL;
#line 249 "rygel-player-controller.c"
		}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 263 "rygel-player-controller.c"
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* e = NULL;
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1287 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 277 "rygel-player-controller.c"
	}
	__finally1:
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return NULL;
#line 288 "rygel-player-controller.c"
	}
}


gchar* rygel_player_controller_unescape (RygelPlayerController* self, const gchar* input) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
#line 89 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (input != NULL, NULL);
#line 90 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = input;
#line 90 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp1_ = string_replace (_tmp0_, "&quot;", "\"");
#line 90 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_result_ = _tmp1_;
#line 91 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp2_ = _result_;
#line 91 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp3_ = string_replace (_tmp2_, "&lt;", "<");
#line 91 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_g_free0 (_result_);
#line 91 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_result_ = _tmp3_;
#line 92 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp4_ = _result_;
#line 92 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp5_ = string_replace (_tmp4_, "&gt;", ">");
#line 92 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_g_free0 (_result_);
#line 92 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_result_ = _tmp5_;
#line 93 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp6_ = _result_;
#line 93 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp7_ = string_replace (_tmp6_, "&apos;", "'");
#line 93 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_g_free0 (_result_);
#line 93 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_result_ = _tmp7_;
#line 94 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp8_ = _result_;
#line 94 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp9_ = string_replace (_tmp8_, "&amp;", "&");
#line 94 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_g_free0 (_result_);
#line 94 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_result_ = _tmp9_;
#line 96 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	result = _result_;
#line 96 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return result;
#line 350 "rygel-player-controller.c"
}


const gchar* rygel_player_controller_get_playback_state (RygelPlayerController* self) {
#line 45 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 45 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->get_playback_state (self);
#line 359 "rygel-player-controller.c"
}


void rygel_player_controller_set_playback_state (RygelPlayerController* self, const gchar* value) {
#line 45 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (self != NULL);
#line 45 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->set_playback_state (self, value);
#line 368 "rygel-player-controller.c"
}


guint rygel_player_controller_get_n_tracks (RygelPlayerController* self) {
#line 47 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 47 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->get_n_tracks (self);
#line 377 "rygel-player-controller.c"
}


void rygel_player_controller_set_n_tracks (RygelPlayerController* self, guint value) {
#line 47 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (self != NULL);
#line 47 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->set_n_tracks (self, value);
#line 386 "rygel-player-controller.c"
}


guint rygel_player_controller_get_track (RygelPlayerController* self) {
#line 49 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 49 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->get_track (self);
#line 395 "rygel-player-controller.c"
}


void rygel_player_controller_set_track (RygelPlayerController* self, guint value) {
#line 49 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (self != NULL);
#line 49 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->set_track (self, value);
#line 404 "rygel-player-controller.c"
}


gchar* rygel_player_controller_get_uri (RygelPlayerController* self) {
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->get_uri (self);
#line 413 "rygel-player-controller.c"
}


void rygel_player_controller_set_uri (RygelPlayerController* self, const gchar* value) {
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (self != NULL);
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->set_uri (self, value);
#line 422 "rygel-player-controller.c"
}


gchar* rygel_player_controller_get_metadata (RygelPlayerController* self) {
#line 52 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 52 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->get_metadata (self);
#line 431 "rygel-player-controller.c"
}


void rygel_player_controller_set_metadata (RygelPlayerController* self, const gchar* value) {
#line 52 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (self != NULL);
#line 52 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->set_metadata (self, value);
#line 440 "rygel-player-controller.c"
}


gchar* rygel_player_controller_get_track_uri (RygelPlayerController* self) {
#line 54 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 54 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->get_track_uri (self);
#line 449 "rygel-player-controller.c"
}


void rygel_player_controller_set_track_uri (RygelPlayerController* self, const gchar* value) {
#line 54 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (self != NULL);
#line 54 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->set_track_uri (self, value);
#line 458 "rygel-player-controller.c"
}


gchar* rygel_player_controller_get_track_metadata (RygelPlayerController* self) {
#line 56 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 56 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->get_track_metadata (self);
#line 467 "rygel-player-controller.c"
}


void rygel_player_controller_set_track_metadata (RygelPlayerController* self, const gchar* value) {
#line 56 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (self != NULL);
#line 56 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->set_track_metadata (self, value);
#line 476 "rygel-player-controller.c"
}


gchar* rygel_player_controller_get_next_uri (RygelPlayerController* self) {
#line 58 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 58 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->get_next_uri (self);
#line 485 "rygel-player-controller.c"
}


void rygel_player_controller_set_next_uri (RygelPlayerController* self, const gchar* value) {
#line 58 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (self != NULL);
#line 58 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->set_next_uri (self, value);
#line 494 "rygel-player-controller.c"
}


gchar* rygel_player_controller_get_next_metadata (RygelPlayerController* self) {
#line 59 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 59 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->get_next_metadata (self);
#line 503 "rygel-player-controller.c"
}


void rygel_player_controller_set_next_metadata (RygelPlayerController* self, const gchar* value) {
#line 59 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (self != NULL);
#line 59 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->set_next_metadata (self, value);
#line 512 "rygel-player-controller.c"
}


gchar* rygel_player_controller_get_current_transport_actions (RygelPlayerController* self) {
#line 61 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 61 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->get_current_transport_actions (self);
#line 521 "rygel-player-controller.c"
}


const gchar* rygel_player_controller_get_play_mode (RygelPlayerController* self) {
#line 63 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 63 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->get_play_mode (self);
#line 530 "rygel-player-controller.c"
}


void rygel_player_controller_set_play_mode (RygelPlayerController* self, const gchar* value) {
#line 63 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (self != NULL);
#line 63 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self)->set_play_mode (self, value);
#line 539 "rygel-player-controller.c"
}


static void rygel_player_controller_base_init (RygelPlayerControllerIface * iface) {
#line 39 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	static gboolean initialized = FALSE;
#line 39 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	if (!initialized) {
#line 39 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		initialized = TRUE;
#line 39 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		g_object_interface_install_property (iface, g_param_spec_string ("playback-state", "playback-state", "playback-state", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 39 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		g_object_interface_install_property (iface, g_param_spec_uint ("n-tracks", "n-tracks", "n-tracks", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 39 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		g_object_interface_install_property (iface, g_param_spec_uint ("track", "track", "track", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 39 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		g_object_interface_install_property (iface, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 39 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		g_object_interface_install_property (iface, g_param_spec_string ("metadata", "metadata", "metadata", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 39 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		g_object_interface_install_property (iface, g_param_spec_string ("track-uri", "track-uri", "track-uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 39 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		g_object_interface_install_property (iface, g_param_spec_string ("track-metadata", "track-metadata", "track-metadata", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 39 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		g_object_interface_install_property (iface, g_param_spec_string ("next-uri", "next-uri", "next-uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 39 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		g_object_interface_install_property (iface, g_param_spec_string ("next-metadata", "next-metadata", "next-metadata", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 39 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		g_object_interface_install_property (iface, g_param_spec_string ("current-transport-actions", "current-transport-actions", "current-transport-actions", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 39 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		g_object_interface_install_property (iface, g_param_spec_string ("play-mode", "play-mode", "play-mode", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 572 "rygel-player-controller.c"
	}
}


/**
 * This class keeps track of global states that are not dependant on the
 * RygelMediaPlayer.
 *
 * These states are:
 * # URI
 * # MetaData
 * # Number of tracks
 * # Current track
 * # Playback state
 *
 * In case of playlists this class will also control the player. It needs to
 * proxy the playback state to react on end of item to be able to switch to
 * the next item.
 */
GType rygel_player_controller_get_type (void) {
	static volatile gsize rygel_player_controller_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_player_controller_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPlayerControllerIface), (GBaseInitFunc) rygel_player_controller_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_player_controller_type_id;
		rygel_player_controller_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelPlayerController", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_player_controller_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&rygel_player_controller_type_id__volatile, rygel_player_controller_type_id);
	}
	return rygel_player_controller_type_id__volatile;
}



