/* rygel-time-utils.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-time-utils.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_TIME_UTILS (rygel_time_utils_get_type ())
#define RYGEL_TIME_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TIME_UTILS, RygelTimeUtils))
#define RYGEL_TIME_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TIME_UTILS, RygelTimeUtilsClass))
#define RYGEL_IS_TIME_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TIME_UTILS))
#define RYGEL_IS_TIME_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TIME_UTILS))
#define RYGEL_TIME_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TIME_UTILS, RygelTimeUtilsClass))

typedef struct _RygelTimeUtils RygelTimeUtils;
typedef struct _RygelTimeUtilsClass RygelTimeUtilsClass;
typedef struct _RygelTimeUtilsPrivate RygelTimeUtilsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelParamSpecTimeUtils RygelParamSpecTimeUtils;

struct _RygelTimeUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTimeUtilsPrivate * priv;
};

struct _RygelTimeUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTimeUtils *self);
};

struct _RygelParamSpecTimeUtils {
	GParamSpec parent_instance;
};


static gpointer rygel_time_utils_parent_class = NULL;

gpointer rygel_time_utils_ref (gpointer instance);
void rygel_time_utils_unref (gpointer instance);
GParamSpec* rygel_param_spec_time_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_time_utils (GValue* value, gpointer v_object);
void rygel_value_take_time_utils (GValue* value, gpointer v_object);
gpointer rygel_value_get_time_utils (const GValue* value);
GType rygel_time_utils_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_TIME_UTILS_DUMMY_PROPERTY
};
gint64 rygel_time_utils_time_from_string (const gchar* str);
gchar* rygel_time_utils_time_to_string (gint64 time);
RygelTimeUtils* rygel_time_utils_construct (GType object_type);
static void rygel_time_utils_finalize (RygelTimeUtils* obj);


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 996 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 997 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 997 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 997 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 997 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 99 "rygel-time-utils.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1198 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1198 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 122 "rygel-time-utils.c"
		glong _tmp4_ = 0L;
#line 1199 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1199 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1199 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 130 "rygel-time-utils.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 142 "rygel-time-utils.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1208 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 166 "rygel-time-utils.c"
		glong _tmp2_ = 0L;
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 172 "rygel-time-utils.c"
	} else {
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 176 "rygel-time-utils.c"
	}
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 180 "rygel-time-utils.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 192 "rygel-time-utils.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1214 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1214 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1214 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 202 "rygel-time-utils.c"
	}
#line 1217 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1217 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 208 "rygel-time-utils.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1218 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1218 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1218 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1219 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1219 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 222 "rygel-time-utils.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1221 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1221 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1221 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 232 "rygel-time-utils.c"
	}
#line 1223 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1223 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 238 "rygel-time-utils.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1224 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1224 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1224 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 247 "rygel-time-utils.c"
	}
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 267 "rygel-time-utils.c"
}


gint64 rygel_time_utils_time_from_string (const gchar* str) {
	gint64 result = 0LL;
	guint64 hours = 0ULL;
	guint64 minutes = 0ULL;
	guint64 seconds = 0ULL;
	guint64 msecs = 0ULL;
	gchar* time_str = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint sign = 0;
	const gchar* _tmp2_ = NULL;
	gchar _tmp3_ = '\0';
	const gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	g_return_val_if_fail (str != NULL, 0LL);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	_tmp0_ = str;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	time_str = _tmp1_;
#line 30 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	sign = 1;
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	_tmp2_ = str;
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	_tmp3_ = string_get (_tmp2_, (glong) 0);
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	switch (_tmp3_) {
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		case '-':
#line 303 "rygel-time-utils.c"
		{
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
#line 34 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
			sign = -1;
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
			_tmp4_ = str;
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
			_tmp5_ = string_substring (_tmp4_, (glong) 1, (glong) (-1));
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
			_g_free0 (time_str);
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
			time_str = _tmp5_;
#line 37 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
			break;
#line 319 "rygel-time-utils.c"
		}
#line 32 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		case '+':
#line 323 "rygel-time-utils.c"
		{
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
#line 39 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
			_tmp6_ = str;
#line 39 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
			_tmp7_ = string_substring (_tmp6_, (glong) 1, (glong) (-1));
#line 39 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
			_g_free0 (time_str);
#line 39 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
			time_str = _tmp7_;
#line 41 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
			break;
#line 337 "rygel-time-utils.c"
		}
		default:
		{
#line 43 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
			break;
#line 343 "rygel-time-utils.c"
		}
	}
#line 46 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	_tmp8_ = time_str;
#line 46 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	sscanf (_tmp8_, "%llu:%2llu:%2llu.%3llu", &hours, &minutes, &seconds, &msecs);
#line 52 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	_tmp9_ = sign;
#line 52 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	result = _tmp9_ * ((((gint64) (((hours * 3600) + (minutes * 60)) + seconds)) * G_TIME_SPAN_SECOND) + (((gint64) msecs) * G_TIME_SPAN_MILLISECOND));
#line 52 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	_g_free0 (time_str);
#line 52 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	return result;
#line 358 "rygel-time-utils.c"
}


gchar* rygel_time_utils_time_to_string (gint64 time) {
	gchar* result = NULL;
	guint64 hours = 0ULL;
	guint64 minutes = 0ULL;
	guint64 seconds = 0ULL;
	guint64 totsecs = 0ULL;
	guint64 msecs = 0ULL;
	gchar* sign = NULL;
	gchar* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
	guint64 _tmp6_ = 0ULL;
	guint64 _tmp7_ = 0ULL;
	guint64 _tmp8_ = 0ULL;
	gint64 _tmp9_ = 0LL;
	const gchar* _tmp10_ = NULL;
	guint64 _tmp11_ = 0ULL;
	gchar* _tmp12_ = NULL;
#line 58 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	_tmp0_ = g_strdup ("");
#line 58 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	sign = _tmp0_;
#line 60 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	_tmp1_ = time;
#line 60 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	if (_tmp1_ < ((gint64) 0)) {
#line 389 "rygel-time-utils.c"
		gchar* _tmp2_ = NULL;
		gint64 _tmp3_ = 0LL;
#line 61 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		_tmp2_ = g_strdup ("-");
#line 61 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		_g_free0 (sign);
#line 61 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		sign = _tmp2_;
#line 62 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		_tmp3_ = time;
#line 62 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		time = -_tmp3_;
#line 402 "rygel-time-utils.c"
	}
#line 65 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	_tmp4_ = time;
#line 65 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	hours = (guint64) ((_tmp4_ / G_TIME_SPAN_SECOND) / 3600);
#line 66 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	_tmp5_ = time;
#line 66 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	seconds = (guint64) ((_tmp5_ / G_TIME_SPAN_SECOND) % 3600);
#line 67 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	_tmp6_ = seconds;
#line 67 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	minutes = _tmp6_ / 60;
#line 68 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	_tmp7_ = seconds;
#line 68 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	seconds = _tmp7_ % 60;
#line 70 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	_tmp8_ = seconds;
#line 70 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	totsecs = (((hours * 3600) + (minutes * 60)) + _tmp8_) * G_TIME_SPAN_SECOND;
#line 71 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	_tmp9_ = time;
#line 71 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	msecs = (_tmp9_ - totsecs) / G_TIME_SPAN_MILLISECOND;
#line 73 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	_tmp10_ = sign;
#line 73 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	_tmp11_ = seconds;
#line 73 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	_tmp12_ = g_strdup_printf ("%s%llu:%.2llu:%.2llu.%.3llu", _tmp10_, hours, minutes, _tmp11_, msecs);
#line 73 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	result = _tmp12_;
#line 73 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	_g_free0 (sign);
#line 73 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	return result;
#line 440 "rygel-time-utils.c"
}


RygelTimeUtils* rygel_time_utils_construct (GType object_type) {
	RygelTimeUtils* self = NULL;
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	self = (RygelTimeUtils*) g_type_create_instance (object_type);
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	return self;
#line 450 "rygel-time-utils.c"
}


static void rygel_value_time_utils_init (GValue* value) {
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	value->data[0].v_pointer = NULL;
#line 457 "rygel-time-utils.c"
}


static void rygel_value_time_utils_free_value (GValue* value) {
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	if (value->data[0].v_pointer) {
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		rygel_time_utils_unref (value->data[0].v_pointer);
#line 466 "rygel-time-utils.c"
	}
}


static void rygel_value_time_utils_copy_value (const GValue* src_value, GValue* dest_value) {
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	if (src_value->data[0].v_pointer) {
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		dest_value->data[0].v_pointer = rygel_time_utils_ref (src_value->data[0].v_pointer);
#line 476 "rygel-time-utils.c"
	} else {
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		dest_value->data[0].v_pointer = NULL;
#line 480 "rygel-time-utils.c"
	}
}


static gpointer rygel_value_time_utils_peek_pointer (const GValue* value) {
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	return value->data[0].v_pointer;
#line 488 "rygel-time-utils.c"
}


static gchar* rygel_value_time_utils_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	if (collect_values[0].v_pointer) {
#line 495 "rygel-time-utils.c"
		RygelTimeUtils* object;
		object = collect_values[0].v_pointer;
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		if (object->parent_instance.g_class == NULL) {
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 502 "rygel-time-utils.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 506 "rygel-time-utils.c"
		}
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		value->data[0].v_pointer = rygel_time_utils_ref (object);
#line 510 "rygel-time-utils.c"
	} else {
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		value->data[0].v_pointer = NULL;
#line 514 "rygel-time-utils.c"
	}
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	return NULL;
#line 518 "rygel-time-utils.c"
}


static gchar* rygel_value_time_utils_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelTimeUtils** object_p;
	object_p = collect_values[0].v_pointer;
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	if (!object_p) {
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 529 "rygel-time-utils.c"
	}
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	if (!value->data[0].v_pointer) {
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		*object_p = NULL;
#line 535 "rygel-time-utils.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		*object_p = value->data[0].v_pointer;
#line 539 "rygel-time-utils.c"
	} else {
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		*object_p = rygel_time_utils_ref (value->data[0].v_pointer);
#line 543 "rygel-time-utils.c"
	}
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	return NULL;
#line 547 "rygel-time-utils.c"
}


GParamSpec* rygel_param_spec_time_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecTimeUtils* spec;
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_TIME_UTILS), NULL);
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	return G_PARAM_SPEC (spec);
#line 561 "rygel-time-utils.c"
}


gpointer rygel_value_get_time_utils (const GValue* value) {
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TIME_UTILS), NULL);
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	return value->data[0].v_pointer;
#line 570 "rygel-time-utils.c"
}


void rygel_value_set_time_utils (GValue* value, gpointer v_object) {
	RygelTimeUtils* old;
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TIME_UTILS));
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	old = value->data[0].v_pointer;
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	if (v_object) {
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_TIME_UTILS));
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		value->data[0].v_pointer = v_object;
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		rygel_time_utils_ref (value->data[0].v_pointer);
#line 590 "rygel-time-utils.c"
	} else {
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		value->data[0].v_pointer = NULL;
#line 594 "rygel-time-utils.c"
	}
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	if (old) {
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		rygel_time_utils_unref (old);
#line 600 "rygel-time-utils.c"
	}
}


void rygel_value_take_time_utils (GValue* value, gpointer v_object) {
	RygelTimeUtils* old;
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TIME_UTILS));
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	old = value->data[0].v_pointer;
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	if (v_object) {
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_TIME_UTILS));
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		value->data[0].v_pointer = v_object;
#line 619 "rygel-time-utils.c"
	} else {
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		value->data[0].v_pointer = NULL;
#line 623 "rygel-time-utils.c"
	}
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	if (old) {
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		rygel_time_utils_unref (old);
#line 629 "rygel-time-utils.c"
	}
}


static void rygel_time_utils_class_init (RygelTimeUtilsClass * klass) {
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	rygel_time_utils_parent_class = g_type_class_peek_parent (klass);
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	((RygelTimeUtilsClass *) klass)->finalize = rygel_time_utils_finalize;
#line 639 "rygel-time-utils.c"
}


static void rygel_time_utils_instance_init (RygelTimeUtils * self) {
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	self->ref_count = 1;
#line 646 "rygel-time-utils.c"
}


static void rygel_time_utils_finalize (RygelTimeUtils* obj) {
	RygelTimeUtils * self;
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_TIME_UTILS, RygelTimeUtils);
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	g_signal_handlers_destroy (self);
#line 656 "rygel-time-utils.c"
}


GType rygel_time_utils_get_type (void) {
	static volatile gsize rygel_time_utils_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_time_utils_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_time_utils_init, rygel_value_time_utils_free_value, rygel_value_time_utils_copy_value, rygel_value_time_utils_peek_pointer, "p", rygel_value_time_utils_collect_value, "p", rygel_value_time_utils_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelTimeUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_time_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTimeUtils), 0, (GInstanceInitFunc) rygel_time_utils_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_time_utils_type_id;
		rygel_time_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelTimeUtils", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_time_utils_type_id__volatile, rygel_time_utils_type_id);
	}
	return rygel_time_utils_type_id__volatile;
}


gpointer rygel_time_utils_ref (gpointer instance) {
	RygelTimeUtils* self;
	self = instance;
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	g_atomic_int_inc (&self->ref_count);
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	return instance;
#line 681 "rygel-time-utils.c"
}


void rygel_time_utils_unref (gpointer instance) {
	RygelTimeUtils* self;
	self = instance;
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		RYGEL_TIME_UTILS_GET_CLASS (self)->finalize (self);
#line 26 "/home/jens/Source/rygel/src/librygel-renderer/rygel-time-utils.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 694 "rygel-time-utils.c"
	}
}



