/* rygel-content-directory.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-content-directory.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2007 OpenedHand Ltd.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Jorn Baayen <jorn@openedhand.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <rygel-core.h>
#include <uuid/uuid.h>
#include <glib/gi18n-lib.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_IMPORT_RESOURCE (rygel_import_resource_get_type ())
#define RYGEL_IMPORT_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResource))
#define RYGEL_IMPORT_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResourceClass))
#define RYGEL_IS_IMPORT_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_IMPORT_RESOURCE))
#define RYGEL_IS_IMPORT_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_IMPORT_RESOURCE))
#define RYGEL_IMPORT_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResourceClass))

typedef struct _RygelImportResource RygelImportResource;
typedef struct _RygelImportResourceClass RygelImportResourceClass;

#define RYGEL_TYPE_LAST_CHANGE (rygel_last_change_get_type ())
#define RYGEL_LAST_CHANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LAST_CHANGE, RygelLastChange))
#define RYGEL_LAST_CHANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LAST_CHANGE, RygelLastChangeClass))
#define RYGEL_IS_LAST_CHANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LAST_CHANGE))
#define RYGEL_IS_LAST_CHANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LAST_CHANGE))
#define RYGEL_LAST_CHANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LAST_CHANGE, RygelLastChangeClass))

typedef struct _RygelLastChange RygelLastChange;
typedef struct _RygelLastChangeClass RygelLastChangeClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_SERVER_PLUGIN (rygel_media_server_plugin_get_type ())
#define RYGEL_MEDIA_SERVER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPlugin))
#define RYGEL_MEDIA_SERVER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginClass))
#define RYGEL_IS_MEDIA_SERVER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN))
#define RYGEL_IS_MEDIA_SERVER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_SERVER_PLUGIN))
#define RYGEL_MEDIA_SERVER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginClass))

typedef struct _RygelMediaServerPlugin RygelMediaServerPlugin;
typedef struct _RygelMediaServerPluginClass RygelMediaServerPluginClass;

#define RYGEL_TYPE_TRACKABLE_CONTAINER (rygel_trackable_container_get_type ())
#define RYGEL_TRACKABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER, RygelTrackableContainer))
#define RYGEL_IS_TRACKABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER))
#define RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER, RygelTrackableContainerIface))

typedef struct _RygelTrackableContainer RygelTrackableContainer;
typedef struct _RygelTrackableContainerIface RygelTrackableContainerIface;

#define RYGEL_TYPE_OBJECT_EVENT_TYPE (rygel_object_event_type_get_type ())

#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;

#define RYGEL_TYPE_BROWSE (rygel_browse_get_type ())
#define RYGEL_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BROWSE, RygelBrowse))
#define RYGEL_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BROWSE, RygelBrowseClass))
#define RYGEL_IS_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BROWSE))
#define RYGEL_IS_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BROWSE))
#define RYGEL_BROWSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BROWSE, RygelBrowseClass))

typedef struct _RygelBrowse RygelBrowse;
typedef struct _RygelBrowseClass RygelBrowseClass;

#define RYGEL_TYPE_SEARCH (rygel_search_get_type ())
#define RYGEL_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH, RygelSearch))
#define RYGEL_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH, RygelSearchClass))
#define RYGEL_IS_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH))
#define RYGEL_IS_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH))
#define RYGEL_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH, RygelSearchClass))

typedef struct _RygelSearch RygelSearch;
typedef struct _RygelSearchClass RygelSearchClass;

#define RYGEL_TYPE_OBJECT_CREATOR (rygel_object_creator_get_type ())
#define RYGEL_OBJECT_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreator))
#define RYGEL_OBJECT_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreatorClass))
#define RYGEL_IS_OBJECT_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_OBJECT_CREATOR))
#define RYGEL_IS_OBJECT_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_OBJECT_CREATOR))
#define RYGEL_OBJECT_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreatorClass))

typedef struct _RygelObjectCreator RygelObjectCreator;
typedef struct _RygelObjectCreatorClass RygelObjectCreatorClass;

#define RYGEL_TYPE_REFERENCE_CREATOR (rygel_reference_creator_get_type ())
#define RYGEL_REFERENCE_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_REFERENCE_CREATOR, RygelReferenceCreator))
#define RYGEL_REFERENCE_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_REFERENCE_CREATOR, RygelReferenceCreatorClass))
#define RYGEL_IS_REFERENCE_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_REFERENCE_CREATOR))
#define RYGEL_IS_REFERENCE_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_REFERENCE_CREATOR))
#define RYGEL_REFERENCE_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_REFERENCE_CREATOR, RygelReferenceCreatorClass))

typedef struct _RygelReferenceCreator RygelReferenceCreator;
typedef struct _RygelReferenceCreatorClass RygelReferenceCreatorClass;

#define RYGEL_TYPE_ITEM_DESTROYER (rygel_item_destroyer_get_type ())
#define RYGEL_ITEM_DESTROYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyer))
#define RYGEL_ITEM_DESTROYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyerClass))
#define RYGEL_IS_ITEM_DESTROYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_DESTROYER))
#define RYGEL_IS_ITEM_DESTROYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_DESTROYER))
#define RYGEL_ITEM_DESTROYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyerClass))

typedef struct _RygelItemDestroyer RygelItemDestroyer;
typedef struct _RygelItemDestroyerClass RygelItemDestroyerClass;

#define RYGEL_TYPE_ITEM_UPDATER (rygel_item_updater_get_type ())
#define RYGEL_ITEM_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdater))
#define RYGEL_ITEM_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdaterClass))
#define RYGEL_IS_ITEM_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_UPDATER))
#define RYGEL_IS_ITEM_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_UPDATER))
#define RYGEL_ITEM_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdaterClass))

typedef struct _RygelItemUpdater RygelItemUpdater;
typedef struct _RygelItemUpdaterClass RygelItemUpdaterClass;
typedef struct _RygelImportResourcePrivate RygelImportResourcePrivate;

#define RYGEL_TYPE_TRANSFER_STATUS (rygel_transfer_status_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_LAST_CHANGE_ENTRY (rygel_last_change_entry_get_type ())
#define RYGEL_LAST_CHANGE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LAST_CHANGE_ENTRY, RygelLastChangeEntry))
#define RYGEL_LAST_CHANGE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LAST_CHANGE_ENTRY, RygelLastChangeEntryClass))
#define RYGEL_IS_LAST_CHANGE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LAST_CHANGE_ENTRY))
#define RYGEL_IS_LAST_CHANGE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LAST_CHANGE_ENTRY))
#define RYGEL_LAST_CHANGE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LAST_CHANGE_ENTRY, RygelLastChangeEntryClass))

typedef struct _RygelLastChangeEntry RygelLastChangeEntry;
typedef struct _RygelLastChangeEntryClass RygelLastChangeEntryClass;

#define RYGEL_TYPE_LAST_CHANGE_ST_DONE (rygel_last_change_st_done_get_type ())
#define RYGEL_LAST_CHANGE_ST_DONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LAST_CHANGE_ST_DONE, RygelLastChangeStDone))
#define RYGEL_LAST_CHANGE_ST_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LAST_CHANGE_ST_DONE, RygelLastChangeStDoneClass))
#define RYGEL_IS_LAST_CHANGE_ST_DONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LAST_CHANGE_ST_DONE))
#define RYGEL_IS_LAST_CHANGE_ST_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LAST_CHANGE_ST_DONE))
#define RYGEL_LAST_CHANGE_ST_DONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LAST_CHANGE_ST_DONE, RygelLastChangeStDoneClass))

typedef struct _RygelLastChangeStDone RygelLastChangeStDone;
typedef struct _RygelLastChangeStDoneClass RygelLastChangeStDoneClass;
typedef struct _Block5Data Block5Data;

#define RYGEL_TYPE_LAST_CHANGE_OBJ_ADD (rygel_last_change_obj_add_get_type ())
#define RYGEL_LAST_CHANGE_OBJ_ADD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_ADD, RygelLastChangeObjAdd))
#define RYGEL_LAST_CHANGE_OBJ_ADD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LAST_CHANGE_OBJ_ADD, RygelLastChangeObjAddClass))
#define RYGEL_IS_LAST_CHANGE_OBJ_ADD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_ADD))
#define RYGEL_IS_LAST_CHANGE_OBJ_ADD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LAST_CHANGE_OBJ_ADD))
#define RYGEL_LAST_CHANGE_OBJ_ADD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_ADD, RygelLastChangeObjAddClass))

typedef struct _RygelLastChangeObjAdd RygelLastChangeObjAdd;
typedef struct _RygelLastChangeObjAddClass RygelLastChangeObjAddClass;

#define RYGEL_TYPE_LAST_CHANGE_OBJ_MOD (rygel_last_change_obj_mod_get_type ())
#define RYGEL_LAST_CHANGE_OBJ_MOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_MOD, RygelLastChangeObjMod))
#define RYGEL_LAST_CHANGE_OBJ_MOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LAST_CHANGE_OBJ_MOD, RygelLastChangeObjModClass))
#define RYGEL_IS_LAST_CHANGE_OBJ_MOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_MOD))
#define RYGEL_IS_LAST_CHANGE_OBJ_MOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LAST_CHANGE_OBJ_MOD))
#define RYGEL_LAST_CHANGE_OBJ_MOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_MOD, RygelLastChangeObjModClass))

typedef struct _RygelLastChangeObjMod RygelLastChangeObjMod;
typedef struct _RygelLastChangeObjModClass RygelLastChangeObjModClass;

#define RYGEL_TYPE_LAST_CHANGE_OBJ_DEL (rygel_last_change_obj_del_get_type ())
#define RYGEL_LAST_CHANGE_OBJ_DEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_DEL, RygelLastChangeObjDel))
#define RYGEL_LAST_CHANGE_OBJ_DEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LAST_CHANGE_OBJ_DEL, RygelLastChangeObjDelClass))
#define RYGEL_IS_LAST_CHANGE_OBJ_DEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_DEL))
#define RYGEL_IS_LAST_CHANGE_OBJ_DEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LAST_CHANGE_OBJ_DEL))
#define RYGEL_LAST_CHANGE_OBJ_DEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_DEL, RygelLastChangeObjDelClass))

typedef struct _RygelLastChangeObjDel RygelLastChangeObjDel;
typedef struct _RygelLastChangeObjDelClass RygelLastChangeObjDelClass;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelContentDirectoryServiceResetData RygelContentDirectoryServiceResetData;
#define _rygel_dlna_profile_unref0(var) ((var == NULL) ? NULL : (var = (rygel_dlna_profile_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

/**
 * Errors used by ContentDirectory and deriving classes.
 */
typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_CURRENT_TAG_VALUE = 702,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE = 703,
	RYGEL_CONTENT_DIRECTORY_ERROR_REQUIRED_TAG = 704,
	RYGEL_CONTENT_DIRECTORY_ERROR_READ_ONLY_TAG = 705,
	RYGEL_CONTENT_DIRECTORY_ERROR_PARAMETER_MISMATCH = 706,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SEARCH_CRITERIA = 708,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER = 710,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_FILE_TRANSFER = 717,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_OUTDATED_OBJECT_METADATA = 728,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

struct _RygelContentDirectoryPrivate {
	GeeArrayList* updated_containers;
	GeeArrayList* active_imports;
	GeeArrayList* finished_imports;
	gboolean clear_updated_containers;
	guint update_notify_id;
	RygelLastChange* last_change;
	gchar* service_reset_token;
};

struct _RygelTrackableContainerIface {
	GTypeInterface parent_iface;
	void (*add_child) (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_child_finish) (RygelTrackableContainer* self, GAsyncResult* _res_);
	void (*remove_child) (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_child_finish) (RygelTrackableContainer* self, GAsyncResult* _res_);
	gchar* (*get_service_reset_token) (RygelTrackableContainer* self);
	void (*set_service_reset_token) (RygelTrackableContainer* self, const gchar* token);
	guint32 (*get_system_update_id) (RygelTrackableContainer* self);
};

typedef enum  {
	RYGEL_OBJECT_EVENT_TYPE_ADDED = 0,
	RYGEL_OBJECT_EVENT_TYPE_MODIFIED = 1,
	RYGEL_OBJECT_EVENT_TYPE_DELETED = 2
} RygelObjectEventType;

typedef enum  {
	RYGEL_TRANSFER_STATUS_COMPLETED,
	RYGEL_TRANSFER_STATUS_ERROR,
	RYGEL_TRANSFER_STATUS_IN_PROGRESS,
	RYGEL_TRANSFER_STATUS_STOPPED
} RygelTransferStatus;

struct _RygelImportResource {
	GObject parent_instance;
	RygelImportResourcePrivate * priv;
	gchar* source_uri;
	gchar* destination_uri;
	guint32 transfer_id;
	RygelTransferStatus status;
	gint64 bytes_copied;
	gint64 bytes_total;
};

struct _RygelImportResourceClass {
	GObjectClass parent_class;
};

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	GeeList* (*preroll) (RygelDataSource* self, RygelHTTPSeekRequest* seek, RygelPlaySpeedRequest* playspeed, GError** error);
	void (*start) (RygelDataSource* self, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	void (*add_uri) (RygelMediaObject* self, const gchar* uri);
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	RygelDataSource* (*create_stream_source_for_resource) (RygelMediaObject* self, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	guint32 update_id;
	gint64 storage_used;
	gint64 total_deleted_child_count;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _Block5Data {
	int _ref_count_;
	RygelContentDirectory* self;
	RygelImportResource* import;
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelContentDirectoryServiceResetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelContentDirectory* self;
	RygelMediaServerPlugin* plugin;
	GUPnPRootDevice* _tmp0_;
	GUPnPRootDevice* _tmp1_;
	GUPnPRootDevice* _tmp2_;
	GUPnPResourceFactory* _tmp3_;
	GUPnPResourceFactory* _tmp4_;
	RygelMediaServerPlugin* _tmp5_;
	RygelMediaServerPlugin* _tmp6_;
	RygelMediaServerPlugin* _tmp7_;
	gchar* _tmp8_;
	RygelMediaContainer* _tmp9_;
	RygelTrackableContainer* trackable;
	RygelMediaContainer* _tmp10_;
	RygelTrackableContainer* _tmp11_;
	RygelTrackableContainer* _tmp12_;
	const gchar* _tmp13_;
	RygelRelationalExpression* expression;
	RygelRelationalExpression* _tmp14_;
	RygelRelationalExpression* _tmp15_;
	gchar* _tmp16_;
	RygelRelationalExpression* _tmp17_;
	gchar* _tmp18_;
	RygelRelationalExpression* _tmp19_;
	RygelSearchableContainer* root;
	RygelMediaContainer* _tmp20_;
	RygelSearchableContainer* _tmp21_;
	RygelSearchableContainer* _tmp22_;
	guint32 matches;
	RygelMediaObjects* objects;
	RygelSearchableContainer* _tmp23_;
	RygelRelationalExpression* _tmp24_;
	guint _tmp25_;
	RygelMediaObjects* _tmp26_;
	RygelMediaObjects* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	guint32 count;
	RygelMediaObjects* _object_list;
	RygelMediaObjects* _tmp30_;
	RygelMediaObjects* _tmp31_;
	gint _object_size;
	RygelMediaObjects* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	gint _object_index;
	gint _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	RygelMediaObject* object;
	RygelMediaObjects* _tmp38_;
	gint _tmp39_;
	gpointer _tmp40_;
	RygelMediaObject* _tmp41_;
	guint32 _tmp42_;
	RygelMediaObject* _tmp43_;
	RygelMediaContainer* container;
	RygelMediaObject* _tmp44_;
	RygelMediaContainer* _tmp45_;
	RygelMediaContainer* _tmp46_;
	RygelMediaContainer* _tmp47_;
	guint _tmp48_;
	guint _tmp49_;
	RygelMediaContainer* _tmp50_;
	guint32 _tmp51_;
	guint32 _tmp52_;
	RygelMediaServerPlugin* _tmp53_;
	const gchar* _tmp54_;
	GError* _error_;
	GError * _inner_error_;
};


static gpointer rygel_content_directory_parent_class = NULL;

GQuark rygel_content_directory_error_quark (void);
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_import_resource_get_type (void) G_GNUC_CONST;
GType rygel_last_change_get_type (void) G_GNUC_CONST;
#define RYGEL_CONTENT_DIRECTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryPrivate))
enum  {
	RYGEL_CONTENT_DIRECTORY_DUMMY_PROPERTY
};
#define RYGEL_CONTENT_DIRECTORY_UPNP_ID "urn:upnp-org:serviceId:ContentDirectory"
#define RYGEL_CONTENT_DIRECTORY_UPNP_TYPE "urn:schemas-upnp-org:service:ContentDirectory:3"
#define RYGEL_CONTENT_DIRECTORY_UPNP_TYPE_V1 "urn:schemas-upnp-org:service:ContentDirectory:1"
#define RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH "xml/ContentDirectory.xml"
#define RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH_NO_TRACK "xml/ContentDirectory-NoTrack.xml"
static void rygel_content_directory_real_constructed (GObject* base);
GType rygel_media_server_plugin_get_type (void) G_GNUC_CONST;
RygelMediaContainer* rygel_media_server_plugin_get_root_container (RygelMediaServerPlugin* self);
RygelHTTPServer* rygel_http_server_new (RygelContentDirectory* content_dir, const gchar* name);
RygelHTTPServer* rygel_http_server_construct (GType object_type, RygelContentDirectory* content_dir, const gchar* name);
gboolean rygel_media_container_equal_func (RygelMediaContainer* a, RygelMediaContainer* b);
static gboolean _rygel_media_container_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
GType rygel_trackable_container_get_type (void) G_GNUC_CONST;
gchar* rygel_trackable_container_get_service_reset_token (RygelTrackableContainer* self);
guint32 rygel_trackable_container_get_system_update_id (RygelTrackableContainer* self);
GType rygel_object_event_type_get_type (void) G_GNUC_CONST;
static void rygel_content_directory_on_container_updated (RygelContentDirectory* self, RygelMediaContainer* root_container, RygelMediaContainer* updated_container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update);
static void _rygel_content_directory_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self);
static void rygel_content_directory_on_sub_tree_updates_finished (RygelContentDirectory* self, RygelMediaContainer* root_container, RygelMediaObject* sub_tree_root);
static void _rygel_content_directory_on_sub_tree_updates_finished_rygel_media_container_sub_tree_updates_finished (RygelMediaContainer* _sender, RygelMediaObject* sub_tree_root, gpointer self);
RygelLastChange* rygel_last_change_new (void);
RygelLastChange* rygel_last_change_construct (GType object_type);
static void rygel_content_directory_browse_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_browse_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_search_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_search_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_create_object_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_create_object_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_create_reference_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_create_reference_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_destroy_object_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_destroy_object_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_update_object_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_update_object_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_import_resource_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_import_resource_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_get_transfer_progress_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_transfer_progress_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_stop_transfer_resource_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_stop_transfer_resource_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_get_dlna_upload_profiles_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_dlna_upload_profiles_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_query_transfer_ids (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_transfer_ids_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_get_system_update_id_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_system_update_id_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_query_system_update_id (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_system_update_id_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_query_container_update_ids (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_container_update_ids_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_get_search_capabilities_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_search_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_query_search_capabilities (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_search_capabilities_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_get_sort_capabilities_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_sort_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_query_sort_capabilities (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_sort_capabilities_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_get_feature_list_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_feature_list_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_query_feature_list (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_feature_list_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_query_last_change (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_last_change_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_query_service_reset_token (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_service_reset_token_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_get_service_reset_token_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_service_reset_token_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
GType rygel_media_query_action_get_type (void) G_GNUC_CONST;
GType rygel_browse_get_type (void) G_GNUC_CONST;
static GUPnPServiceAction* _vala_GUPnPServiceAction_copy (GUPnPServiceAction* self);
RygelBrowse* rygel_browse_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelBrowse* rygel_browse_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_search_get_type (void) G_GNUC_CONST;
RygelSearch* rygel_search_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelSearch* rygel_search_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_object_creator_get_type (void) G_GNUC_CONST;
RygelObjectCreator* rygel_object_creator_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelObjectCreator* rygel_object_creator_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_reference_creator_get_type (void) G_GNUC_CONST;
RygelReferenceCreator* rygel_reference_creator_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelReferenceCreator* rygel_reference_creator_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_item_destroyer_get_type (void) G_GNUC_CONST;
RygelItemDestroyer* rygel_item_destroyer_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelItemDestroyer* rygel_item_destroyer_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_item_updater_get_type (void) G_GNUC_CONST;
RygelItemUpdater* rygel_item_updater_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelItemUpdater* rygel_item_updater_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelImportResource* rygel_import_resource_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelImportResource* rygel_import_resource_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
static void rygel_content_directory_on_import_completed (RygelContentDirectory* self, RygelStateMachine* machine);
static void _rygel_content_directory_on_import_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
static gchar* rygel_content_directory_create_transfer_ids (RygelContentDirectory* self);
static RygelImportResource* rygel_content_directory_find_import_for_action (RygelContentDirectory* self, GUPnPServiceAction* action, GError** error);
const gchar* rygel_import_resource_get_status_as_string (RygelImportResource* self);
GType rygel_transfer_status_get_type (void) G_GNUC_CONST;
static gchar* rygel_content_directory_create_container_update_ids (RygelContentDirectory* self);
const gchar* rygel_media_server_plugin_get_search_caps (RygelMediaServerPlugin* self);
#define RYGEL_MEDIA_OBJECTS_SORT_CAPS "@id,@parentID,dc:title,upnp:class," "upnp:artist,upnp:author,upnp:album," "dc:date,upnp:originalTrackNumber"
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
static gboolean rygel_content_directory_handle_system_update (RygelContentDirectory* self);
static void rygel_content_directory_service_reset (RygelContentDirectory* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_content_directory_service_reset_finish (RygelContentDirectory* self, GAsyncResult* _res_);
static void rygel_content_directory_handle_last_change (RygelContentDirectory* self, RygelMediaContainer* updated_container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update);
static void rygel_content_directory_add_last_change_entry (RygelContentDirectory* self, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update);
static gboolean rygel_content_directory_set_update_ids (RygelContentDirectory* self, RygelMediaContainer* updated_container, RygelMediaObject* object, RygelObjectEventType event_type);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
void rygel_media_object_set_object_update_id (RygelMediaObject* self, guint value);
static void rygel_content_directory_handle_container_update_ids (RygelContentDirectory* self, RygelMediaContainer* updated_container, RygelMediaObject* object);
static void rygel_content_directory_ensure_timeout (RygelContentDirectory* self);
GType rygel_last_change_entry_get_type (void) G_GNUC_CONST;
GType rygel_last_change_st_done_get_type (void) G_GNUC_CONST;
RygelLastChangeStDone* rygel_last_change_st_done_new (const gchar* id, guint update_id);
RygelLastChangeStDone* rygel_last_change_st_done_construct (GType object_type, const gchar* id, guint update_id);
void rygel_last_change_add_event (RygelLastChange* self, RygelLastChangeEntry* entry);
static gboolean rygel_content_directory_update_notify (RygelContentDirectory* self);
gchar* rygel_last_change_get_log (RygelLastChange* self);
void rygel_last_change_clear_on_new_event (RygelLastChange* self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean __lambda15_ (Block5Data* _data5_);
static gboolean ___lambda15__gsource_func (gpointer self);
static gboolean _rygel_content_directory_update_notify_gsource_func (gpointer self);
RygelMediaContainer* rygel_media_object_get_parent (RygelMediaObject* self);
const gchar* rygel_media_object_get_upnp_class (RygelMediaObject* self);
RygelLastChangeObjAdd* rygel_last_change_obj_add_new (const gchar* id, guint update_id, gboolean sub_tree_update, const gchar* parent_id, const gchar* upnp_class);
RygelLastChangeObjAdd* rygel_last_change_obj_add_construct (GType object_type, const gchar* id, guint update_id, gboolean sub_tree_update, const gchar* parent_id, const gchar* upnp_class);
GType rygel_last_change_obj_add_get_type (void) G_GNUC_CONST;
RygelLastChangeObjMod* rygel_last_change_obj_mod_new (const gchar* id, guint update_id, gboolean sub_tree_update);
RygelLastChangeObjMod* rygel_last_change_obj_mod_construct (GType object_type, const gchar* id, guint update_id, gboolean sub_tree_update);
GType rygel_last_change_obj_mod_get_type (void) G_GNUC_CONST;
RygelLastChangeObjDel* rygel_last_change_obj_del_new (const gchar* id, guint update_id, gboolean sub_tree_update);
RygelLastChangeObjDel* rygel_last_change_obj_del_construct (GType object_type, const gchar* id, guint update_id, gboolean sub_tree_update);
GType rygel_last_change_obj_del_get_type (void) G_GNUC_CONST;
static void rygel_content_directory_service_reset_data_free (gpointer _data);
static gboolean rygel_content_directory_service_reset_co (RygelContentDirectoryServiceResetData* _data_);
void rygel_trackable_container_set_service_reset_token (RygelTrackableContainer* self, const gchar* token);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_content_directory_service_reset_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
guint rygel_media_object_get_object_update_id (RygelMediaObject* self);
GList* rygel_media_server_plugin_get_upload_profiles (RygelMediaServerPlugin* self);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
RygelContentDirectory* rygel_content_directory_new (void);
RygelContentDirectory* rygel_content_directory_construct (GType object_type);
static void rygel_content_directory_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark rygel_content_directory_error_quark (void) {
	return g_quark_from_static_string ("rygel_content_directory_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return self ? g_object_ref (self) : NULL;
#line 800 "rygel-content-directory.c"
}


static gboolean _rygel_media_container_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = rygel_media_container_equal_func ((RygelMediaContainer*) a, (RygelMediaContainer*) b);
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return result;
#line 809 "rygel-content-directory.c"
}


static gchar* uuid_get (void) {
	gchar* result = NULL;
	guchar* id = NULL;
	guchar* _tmp0_ = NULL;
	gint id_length1 = 0;
	gint _id_size_ = 0;
	guchar* unparsed = NULL;
	guchar* _tmp1_ = NULL;
	gint unparsed_length1 = 0;
	gint _unparsed_size_ = 0;
	guchar* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	guchar* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	guchar* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	guchar _tmp6_ = '\0';
	guchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gchar* _tmp8_ = NULL;
#line 8 "../../src/librygel-core/uuid.vapi"
	_tmp0_ = g_new0 (guchar, 16);
#line 8 "../../src/librygel-core/uuid.vapi"
	id = _tmp0_;
#line 8 "../../src/librygel-core/uuid.vapi"
	id_length1 = 16;
#line 8 "../../src/librygel-core/uuid.vapi"
	_id_size_ = id_length1;
#line 9 "../../src/librygel-core/uuid.vapi"
	_tmp1_ = g_new0 (guchar, 51);
#line 9 "../../src/librygel-core/uuid.vapi"
	unparsed = _tmp1_;
#line 9 "../../src/librygel-core/uuid.vapi"
	unparsed_length1 = 51;
#line 9 "../../src/librygel-core/uuid.vapi"
	_unparsed_size_ = unparsed_length1;
#line 11 "../../src/librygel-core/uuid.vapi"
	_tmp2_ = id;
#line 11 "../../src/librygel-core/uuid.vapi"
	_tmp2__length1 = id_length1;
#line 11 "../../src/librygel-core/uuid.vapi"
	uuid_generate (_tmp2_);
#line 12 "../../src/librygel-core/uuid.vapi"
	_tmp3_ = id;
#line 12 "../../src/librygel-core/uuid.vapi"
	_tmp3__length1 = id_length1;
#line 12 "../../src/librygel-core/uuid.vapi"
	_tmp4_ = unparsed;
#line 12 "../../src/librygel-core/uuid.vapi"
	_tmp4__length1 = unparsed_length1;
#line 12 "../../src/librygel-core/uuid.vapi"
	uuid_unparse (_tmp3_, _tmp4_);
#line 13 "../../src/librygel-core/uuid.vapi"
	_tmp5_ = unparsed;
#line 13 "../../src/librygel-core/uuid.vapi"
	_tmp5__length1 = unparsed_length1;
#line 13 "../../src/librygel-core/uuid.vapi"
	_tmp5_[50] = (guchar) '\0';
#line 13 "../../src/librygel-core/uuid.vapi"
	_tmp6_ = _tmp5_[50];
#line 15 "../../src/librygel-core/uuid.vapi"
	_tmp7_ = unparsed;
#line 15 "../../src/librygel-core/uuid.vapi"
	_tmp7__length1 = unparsed_length1;
#line 15 "../../src/librygel-core/uuid.vapi"
	_tmp8_ = g_strdup ((const gchar*) _tmp7_);
#line 15 "../../src/librygel-core/uuid.vapi"
	result = _tmp8_;
#line 15 "../../src/librygel-core/uuid.vapi"
	unparsed = (g_free (unparsed), NULL);
#line 15 "../../src/librygel-core/uuid.vapi"
	id = (g_free (id), NULL);
#line 15 "../../src/librygel-core/uuid.vapi"
	return result;
#line 889 "rygel-content-directory.c"
}


static void _rygel_content_directory_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self) {
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_on_container_updated ((RygelContentDirectory*) self, _sender, container, object, event_type, sub_tree_update);
#line 896 "rygel-content-directory.c"
}


static void _rygel_content_directory_on_sub_tree_updates_finished_rygel_media_container_sub_tree_updates_finished (RygelMediaContainer* _sender, RygelMediaObject* sub_tree_root, gpointer self) {
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_on_sub_tree_updates_finished ((RygelContentDirectory*) self, _sender, sub_tree_root);
#line 903 "rygel-content-directory.c"
}


static void _rygel_content_directory_browse_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_browse_cb ((RygelContentDirectory*) self, _sender, action);
#line 910 "rygel-content-directory.c"
}


static void _rygel_content_directory_search_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_search_cb ((RygelContentDirectory*) self, _sender, action);
#line 917 "rygel-content-directory.c"
}


static void _rygel_content_directory_create_object_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_create_object_cb ((RygelContentDirectory*) self, _sender, action);
#line 924 "rygel-content-directory.c"
}


static void _rygel_content_directory_create_reference_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_create_reference_cb ((RygelContentDirectory*) self, _sender, action);
#line 931 "rygel-content-directory.c"
}


static void _rygel_content_directory_destroy_object_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_destroy_object_cb ((RygelContentDirectory*) self, _sender, action);
#line 938 "rygel-content-directory.c"
}


static void _rygel_content_directory_update_object_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_update_object_cb ((RygelContentDirectory*) self, _sender, action);
#line 945 "rygel-content-directory.c"
}


static void _rygel_content_directory_import_resource_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_import_resource_cb ((RygelContentDirectory*) self, _sender, action);
#line 952 "rygel-content-directory.c"
}


static void _rygel_content_directory_get_transfer_progress_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_get_transfer_progress_cb ((RygelContentDirectory*) self, _sender, action);
#line 959 "rygel-content-directory.c"
}


static void _rygel_content_directory_stop_transfer_resource_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_stop_transfer_resource_cb ((RygelContentDirectory*) self, _sender, action);
#line 966 "rygel-content-directory.c"
}


static void _rygel_content_directory_get_dlna_upload_profiles_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_get_dlna_upload_profiles_cb ((RygelContentDirectory*) self, _sender, action);
#line 973 "rygel-content-directory.c"
}


static void _rygel_content_directory_query_transfer_ids_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_query_transfer_ids ((RygelContentDirectory*) self, _sender, variable, value);
#line 980 "rygel-content-directory.c"
}


static void _rygel_content_directory_get_system_update_id_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_get_system_update_id_cb ((RygelContentDirectory*) self, _sender, action);
#line 987 "rygel-content-directory.c"
}


static void _rygel_content_directory_query_system_update_id_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_query_system_update_id ((RygelContentDirectory*) self, _sender, variable, value);
#line 994 "rygel-content-directory.c"
}


static void _rygel_content_directory_query_container_update_ids_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_query_container_update_ids ((RygelContentDirectory*) self, _sender, variable, value);
#line 1001 "rygel-content-directory.c"
}


static void _rygel_content_directory_get_search_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_get_search_capabilities_cb ((RygelContentDirectory*) self, _sender, action);
#line 1008 "rygel-content-directory.c"
}


static void _rygel_content_directory_query_search_capabilities_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_query_search_capabilities ((RygelContentDirectory*) self, _sender, variable, value);
#line 1015 "rygel-content-directory.c"
}


static void _rygel_content_directory_get_sort_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_get_sort_capabilities_cb ((RygelContentDirectory*) self, _sender, action);
#line 1022 "rygel-content-directory.c"
}


static void _rygel_content_directory_query_sort_capabilities_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_query_sort_capabilities ((RygelContentDirectory*) self, _sender, variable, value);
#line 1029 "rygel-content-directory.c"
}


static void _rygel_content_directory_get_feature_list_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_get_feature_list_cb ((RygelContentDirectory*) self, _sender, action);
#line 1036 "rygel-content-directory.c"
}


static void _rygel_content_directory_query_feature_list_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_query_feature_list ((RygelContentDirectory*) self, _sender, variable, value);
#line 1043 "rygel-content-directory.c"
}


static void _rygel_content_directory_query_last_change_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_query_last_change ((RygelContentDirectory*) self, _sender, variable, value);
#line 1050 "rygel-content-directory.c"
}


static void _rygel_content_directory_query_service_reset_token_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_query_service_reset_token ((RygelContentDirectory*) self, _sender, variable, value);
#line 1057 "rygel-content-directory.c"
}


static void _rygel_content_directory_get_service_reset_token_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_get_service_reset_token_cb ((RygelContentDirectory*) self, _sender, action);
#line 1064 "rygel-content-directory.c"
}


static void rygel_content_directory_real_constructed (GObject* base) {
	RygelContentDirectory * self;
	GCancellable* _tmp0_ = NULL;
	RygelMediaServerPlugin* plugin = NULL;
	GUPnPRootDevice* _tmp1_ = NULL;
	GUPnPRootDevice* _tmp2_ = NULL;
	GUPnPRootDevice* _tmp3_ = NULL;
	GUPnPResourceFactory* _tmp4_ = NULL;
	GUPnPResourceFactory* _tmp5_ = NULL;
	RygelMediaServerPlugin* _tmp6_ = NULL;
	RygelMediaServerPlugin* _tmp7_ = NULL;
	RygelMediaServerPlugin* _tmp8_ = NULL;
	RygelMediaContainer* _tmp9_ = NULL;
	RygelMediaContainer* _tmp10_ = NULL;
	RygelMediaContainer* _tmp11_ = NULL;
	RygelMediaServerPlugin* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	RygelHTTPServer* _tmp15_ = NULL;
	GeeArrayList* _tmp16_ = NULL;
	GeeArrayList* _tmp17_ = NULL;
	GeeArrayList* _tmp18_ = NULL;
	RygelMediaContainer* _tmp19_ = NULL;
	RygelMediaContainer* _tmp27_ = NULL;
	RygelMediaContainer* _tmp28_ = NULL;
	RygelLastChange* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	RygelHTTPServer* _tmp31_ = NULL;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self = (RygelContentDirectory*) base;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	G_OBJECT_CLASS (rygel_content_directory_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gupnp_service_get_type (), GUPnPService));
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = g_cancellable_new ();
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (self->cancellable);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self->cancellable = _tmp0_;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_object_get ((GUPnPService*) self, "root-device", &_tmp1_, NULL);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = _tmp1_;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp3_ = _tmp2_;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp4_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp3_);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp5_ = _tmp4_;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, RYGEL_TYPE_MEDIA_SERVER_PLUGIN) ? ((RygelMediaServerPlugin*) _tmp5_) : NULL);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp7_ = _tmp6_;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (_tmp3_);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	plugin = _tmp7_;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp8_ = plugin;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp9_ = rygel_media_server_plugin_get_root_container (_tmp8_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp10_ = _tmp9_;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp11_ = _g_object_ref0 (_tmp10_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (self->root_container);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self->root_container = _tmp11_;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp12_ = plugin;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp13_ = rygel_plugin_get_name ((RygelPlugin*) _tmp12_);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp14_ = _tmp13_;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp15_ = rygel_http_server_new (self, _tmp14_);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (self->http_server);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self->http_server = _tmp15_;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp16_ = gee_array_list_new (RYGEL_TYPE_MEDIA_CONTAINER, (GBoxedCopyFunc) g_object_ref, g_object_unref, _rygel_media_container_equal_func_gee_equal_data_func, NULL, NULL);
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (self->priv->updated_containers);
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self->priv->updated_containers = _tmp16_;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp17_ = gee_array_list_new (RYGEL_TYPE_IMPORT_RESOURCE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (self->priv->active_imports);
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self->priv->active_imports = _tmp17_;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp18_ = gee_array_list_new (RYGEL_TYPE_IMPORT_RESOURCE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (self->priv->finished_imports);
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self->priv->finished_imports = _tmp18_;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp19_ = self->root_container;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, RYGEL_TYPE_TRACKABLE_CONTAINER)) {
#line 1170 "rygel-content-directory.c"
		RygelTrackableContainer* trackable = NULL;
		RygelMediaContainer* _tmp20_ = NULL;
		RygelTrackableContainer* _tmp21_ = NULL;
		RygelTrackableContainer* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		RygelTrackableContainer* _tmp24_ = NULL;
		guint32 _tmp25_ = 0U;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp20_ = self->root_container;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, RYGEL_TYPE_TRACKABLE_CONTAINER) ? ((RygelTrackableContainer*) _tmp20_) : NULL);
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		trackable = _tmp21_;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp22_ = trackable;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp23_ = rygel_trackable_container_get_service_reset_token (_tmp22_);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_free0 (self->priv->service_reset_token);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		self->priv->service_reset_token = _tmp23_;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp24_ = trackable;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp25_ = rygel_trackable_container_get_system_update_id (_tmp24_);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		self->system_update_id = _tmp25_;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (trackable);
#line 1200 "rygel-content-directory.c"
	} else {
		gchar* _tmp26_ = NULL;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp26_ = uuid_get ();
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_free0 (self->priv->service_reset_token);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		self->priv->service_reset_token = _tmp26_;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		self->system_update_id = (guint32) 0;
#line 1211 "rygel-content-directory.c"
	}
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp27_ = self->root_container;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object (_tmp27_, "container-updated", (GCallback) _rygel_content_directory_on_container_updated_rygel_media_container_container_updated, self, 0);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp28_ = self->root_container;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object (_tmp28_, "sub-tree-updates-finished", (GCallback) _rygel_content_directory_on_sub_tree_updates_finished_rygel_media_container_sub_tree_updates_finished, self, 0);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp29_ = rygel_last_change_new ();
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (self->priv->last_change);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self->priv->last_change = _tmp29_;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp30_ = g_strdup ("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" "<Features xmlns=\"urn:schemas-upnp-org:av:avs\" " "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " "xsi:schemaLocation=\"urn:schemas-upnp-org:av:avs" "http://www.upnp.org/schemas/av/avs-v1-20060531.xsd\">" "</Features>");
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (self->feature_list);
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self->feature_list = _tmp30_;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Browse", (GCallback) _rygel_content_directory_browse_cb_gupnp_service_action_invoked, self, 0);
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Search", (GCallback) _rygel_content_directory_search_cb_gupnp_service_action_invoked, self, 0);
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::CreateObject", (GCallback) _rygel_content_directory_create_object_cb_gupnp_service_action_invoked, self, 0);
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::CreateReference", (GCallback) _rygel_content_directory_create_reference_cb_gupnp_service_action_invoked, self, 0);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::DestroyObject", (GCallback) _rygel_content_directory_destroy_object_cb_gupnp_service_action_invoked, self, 0);
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::UpdateObject", (GCallback) _rygel_content_directory_update_object_cb_gupnp_service_action_invoked, self, 0);
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::ImportResource", (GCallback) _rygel_content_directory_import_resource_cb_gupnp_service_action_invoked, self, 0);
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTransferProgress", (GCallback) _rygel_content_directory_get_transfer_progress_cb_gupnp_service_action_invoked, self, 0);
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::StopTransferResource", (GCallback) _rygel_content_directory_stop_transfer_resource_cb_gupnp_service_action_invoked, self, 0);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::X_GetDLNAUploadProfiles", (GCallback) _rygel_content_directory_get_dlna_upload_profiles_cb_gupnp_service_action_invoked, self, 0);
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::TransferIDs", (GCallback) _rygel_content_directory_query_transfer_ids_gupnp_service_query_variable, self, 0);
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetSystemUpdateID", (GCallback) _rygel_content_directory_get_system_update_id_cb_gupnp_service_action_invoked, self, 0);
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::SystemUpdateID", (GCallback) _rygel_content_directory_query_system_update_id_gupnp_service_query_variable, self, 0);
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::ContainerUpdateIDs", (GCallback) _rygel_content_directory_query_container_update_ids_gupnp_service_query_variable, self, 0);
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetSearchCapabilities", (GCallback) _rygel_content_directory_get_search_capabilities_cb_gupnp_service_action_invoked, self, 0);
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::SearchCapabilities", (GCallback) _rygel_content_directory_query_search_capabilities_gupnp_service_query_variable, self, 0);
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetSortCapabilities", (GCallback) _rygel_content_directory_get_sort_capabilities_cb_gupnp_service_action_invoked, self, 0);
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::SortCapabilities", (GCallback) _rygel_content_directory_query_sort_capabilities_gupnp_service_query_variable, self, 0);
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetFeatureList", (GCallback) _rygel_content_directory_get_feature_list_cb_gupnp_service_action_invoked, self, 0);
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::FeatureList", (GCallback) _rygel_content_directory_query_feature_list_gupnp_service_query_variable, self, 0);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::LastChange", (GCallback) _rygel_content_directory_query_last_change_gupnp_service_query_variable, self, 0);
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::ServiceResetToken", (GCallback) _rygel_content_directory_query_service_reset_token_gupnp_service_query_variable, self, 0);
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetServiceResetToken", (GCallback) _rygel_content_directory_get_service_reset_token_cb_gupnp_service_action_invoked, self, 0);
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp31_ = self->http_server;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_state_machine_run ((RygelStateMachine*) _tmp31_, NULL, NULL);
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (plugin);
#line 1285 "rygel-content-directory.c"
}


static GUPnPServiceAction* _vala_GUPnPServiceAction_copy (GUPnPServiceAction* self) {
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return g_boxed_copy (gupnp_service_action_get_type (), self);
#line 1292 "rygel-content-directory.c"
}


static gpointer __vala_GUPnPServiceAction_copy0 (gpointer self) {
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return self ? _vala_GUPnPServiceAction_copy (self) : NULL;
#line 1299 "rygel-content-directory.c"
}


static void rygel_content_directory_browse_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	RygelBrowse* browse = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	GUPnPServiceAction* _tmp1_ = NULL;
	RygelBrowse* _tmp2_ = NULL;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = rygel_browse_new (self, _tmp1_);
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	browse = _tmp2_;
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_state_machine_run ((RygelStateMachine*) browse, NULL, NULL);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (browse);
#line 1326 "rygel-content-directory.c"
}


static void rygel_content_directory_search_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	RygelSearch* search = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	GUPnPServiceAction* _tmp1_ = NULL;
	RygelSearch* _tmp2_ = NULL;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = rygel_search_new (self, _tmp1_);
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	search = _tmp2_;
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_state_machine_run ((RygelStateMachine*) search, NULL, NULL);
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (search);
#line 1353 "rygel-content-directory.c"
}


static void rygel_content_directory_create_object_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	RygelObjectCreator* creator = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	GUPnPServiceAction* _tmp1_ = NULL;
	RygelObjectCreator* _tmp2_ = NULL;
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = rygel_object_creator_new (self, _tmp1_);
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	creator = _tmp2_;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_state_machine_run ((RygelStateMachine*) creator, NULL, NULL);
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (creator);
#line 1380 "rygel-content-directory.c"
}


static void rygel_content_directory_create_reference_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	RygelReferenceCreator* creator = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	GUPnPServiceAction* _tmp1_ = NULL;
	RygelReferenceCreator* _tmp2_ = NULL;
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = rygel_reference_creator_new (self, _tmp1_);
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	creator = _tmp2_;
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_state_machine_run ((RygelStateMachine*) creator, NULL, NULL);
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (creator);
#line 1407 "rygel-content-directory.c"
}


static void rygel_content_directory_destroy_object_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	RygelItemDestroyer* destroyer = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	GUPnPServiceAction* _tmp1_ = NULL;
	RygelItemDestroyer* _tmp2_ = NULL;
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 221 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 221 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
#line 221 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = rygel_item_destroyer_new (self, _tmp1_);
#line 221 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	destroyer = _tmp2_;
#line 223 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_state_machine_run ((RygelStateMachine*) destroyer, NULL, NULL);
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (destroyer);
#line 1434 "rygel-content-directory.c"
}


static void rygel_content_directory_update_object_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	RygelItemUpdater* updater = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	GUPnPServiceAction* _tmp1_ = NULL;
	RygelItemUpdater* _tmp2_ = NULL;
#line 227 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 227 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 227 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = rygel_item_updater_new (self, _tmp1_);
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	updater = _tmp2_;
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_state_machine_run ((RygelStateMachine*) updater, NULL, NULL);
#line 227 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (updater);
#line 1461 "rygel-content-directory.c"
}


static void _rygel_content_directory_on_import_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
#line 239 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_on_import_completed ((RygelContentDirectory*) self, _sender);
#line 1468 "rygel-content-directory.c"
}


static void rygel_content_directory_import_resource_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	RygelImportResource* import = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	GUPnPServiceAction* _tmp1_ = NULL;
	RygelImportResource* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 237 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 237 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
#line 237 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = rygel_import_resource_new (self, _tmp1_);
#line 237 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	import = _tmp2_;
#line 239 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((RygelStateMachine*) import, "completed", (GCallback) _rygel_content_directory_on_import_completed_rygel_state_machine_completed, self, 0);
#line 240 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp3_ = self->priv->active_imports;
#line 240 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, import);
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_state_machine_run ((RygelStateMachine*) import, NULL, NULL);
#line 244 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp4_ = rygel_content_directory_create_transfer_ids (self);
#line 244 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp5_ = _tmp4_;
#line 244 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_notify ((GUPnPService*) self, "TransferIDs", G_TYPE_STRING, _tmp5_, NULL);
#line 244 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (_tmp5_);
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (import);
#line 1512 "rygel-content-directory.c"
}


static void rygel_content_directory_query_transfer_ids (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 250 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 250 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 250 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (variable != NULL);
#line 250 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (value != NULL);
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_init (value, G_TYPE_STRING);
#line 254 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = rygel_content_directory_create_transfer_ids (self);
#line 254 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = _tmp0_;
#line 254 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_set_string (value, _tmp1_);
#line 254 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (_tmp1_);
#line 1537 "rygel-content-directory.c"
}


static void rygel_content_directory_get_transfer_progress_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GError * _inner_error_ = NULL;
#line 258 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 258 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 258 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 260 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 260 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 260 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp1_ != ((guint) 1)) {
#line 1557 "rygel-content-directory.c"
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 261 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp2_ = action;
#line 261 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp3_ = _ ("Invalid argument");
#line 261 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 263 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		return;
#line 1568 "rygel-content-directory.c"
	}
	{
		RygelImportResource* import = NULL;
		GUPnPServiceAction* _tmp4_ = NULL;
		RygelImportResource* _tmp5_ = NULL;
		GUPnPServiceAction* _tmp6_ = NULL;
		RygelImportResource* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		RygelImportResource* _tmp10_ = NULL;
		gint64 _tmp11_ = 0LL;
		RygelImportResource* _tmp12_ = NULL;
		gint64 _tmp13_ = 0LL;
		GUPnPServiceAction* _tmp14_ = NULL;
#line 267 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp4_ = action;
#line 267 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp5_ = rygel_content_directory_find_import_for_action (self, _tmp4_, &_inner_error_);
#line 267 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		import = _tmp5_;
#line 267 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1591 "rygel-content-directory.c"
			goto __catch30_g_error;
		}
#line 269 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp6_ = action;
#line 269 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp7_ = import;
#line 269 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp8_ = rygel_import_resource_get_status_as_string (_tmp7_);
#line 269 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp9_ = _tmp8_;
#line 269 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp10_ = import;
#line 269 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp11_ = _tmp10_->bytes_copied;
#line 269 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp12_ = import;
#line 269 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp13_ = _tmp12_->bytes_total;
#line 269 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gupnp_service_action_set (_tmp6_, "TransferStatus", G_TYPE_STRING, _tmp9_, "TransferLength", G_TYPE_INT64, _tmp11_, "TransferTotal", G_TYPE_INT64, _tmp13_, NULL);
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp14_ = action;
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gupnp_service_action_return (_tmp14_);
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (import);
#line 1618 "rygel-content-directory.c"
	}
	goto __finally30;
	__catch30_g_error:
	{
		GError* _error_ = NULL;
		GUPnPServiceAction* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		GError* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_error_ = _inner_error_;
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_inner_error_ = NULL;
#line 281 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp15_ = action;
#line 281 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp16_ = _error_;
#line 281 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp17_ = _tmp16_->code;
#line 281 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp18_ = _error_;
#line 281 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp19_ = _tmp18_->message;
#line 281 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gupnp_service_action_return_error (_tmp15_, (guint) _tmp17_, _tmp19_);
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_error_free0 (_error_);
#line 1647 "rygel-content-directory.c"
	}
	__finally30:
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_clear_error (&_inner_error_);
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		return;
#line 1658 "rygel-content-directory.c"
	}
}


static void rygel_content_directory_stop_transfer_resource_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GError * _inner_error_ = NULL;
#line 286 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 286 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 286 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 288 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 288 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 288 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp1_ != ((guint) 1)) {
#line 1679 "rygel-content-directory.c"
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 289 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp2_ = action;
#line 289 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp3_ = _ ("Invalid argument");
#line 289 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 291 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		return;
#line 1690 "rygel-content-directory.c"
	}
	{
		RygelImportResource* import = NULL;
		GUPnPServiceAction* _tmp4_ = NULL;
		RygelImportResource* _tmp5_ = NULL;
		RygelImportResource* _tmp6_ = NULL;
		GCancellable* _tmp7_ = NULL;
		GCancellable* _tmp8_ = NULL;
		GUPnPServiceAction* _tmp9_ = NULL;
#line 295 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp4_ = action;
#line 295 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp5_ = rygel_content_directory_find_import_for_action (self, _tmp4_, &_inner_error_);
#line 295 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		import = _tmp5_;
#line 295 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1708 "rygel-content-directory.c"
			goto __catch31_g_error;
		}
#line 296 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp6_ = import;
#line 296 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp7_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _tmp6_);
#line 296 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp8_ = _tmp7_;
#line 296 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_cancellable_cancel (_tmp8_);
#line 298 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp9_ = action;
#line 298 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gupnp_service_action_return (_tmp9_);
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (import);
#line 1725 "rygel-content-directory.c"
	}
	goto __finally31;
	__catch31_g_error:
	{
		GError* _error_ = NULL;
		GUPnPServiceAction* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_error_ = _inner_error_;
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_inner_error_ = NULL;
#line 300 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp10_ = action;
#line 300 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp11_ = _error_;
#line 300 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp12_ = _tmp11_->code;
#line 300 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp13_ = _error_;
#line 300 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp14_ = _tmp13_->message;
#line 300 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gupnp_service_action_return_error (_tmp10_, (guint) _tmp12_, _tmp14_);
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_error_free0 (_error_);
#line 1754 "rygel-content-directory.c"
	}
	__finally31:
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_clear_error (&_inner_error_);
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		return;
#line 1765 "rygel-content-directory.c"
	}
}


static void rygel_content_directory_get_system_update_id_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_ = NULL;
	guint32 _tmp5_ = 0U;
	GUPnPServiceAction* _tmp6_ = NULL;
#line 305 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 305 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 305 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 307 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 307 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 307 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp1_ != ((guint) 0)) {
#line 1788 "rygel-content-directory.c"
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp2_ = action;
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp3_ = _ ("Invalid argument");
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 310 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		return;
#line 1799 "rygel-content-directory.c"
	}
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp4_ = action;
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp5_ = self->system_update_id;
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_action_set (_tmp4_, "Id", G_TYPE_UINT, _tmp5_, NULL);
#line 316 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp6_ = action;
#line 316 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_action_return (_tmp6_);
#line 1811 "rygel-content-directory.c"
}


static void rygel_content_directory_query_system_update_id (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	guint32 _tmp0_ = 0U;
#line 320 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 320 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 320 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (variable != NULL);
#line 320 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (value != NULL);
#line 324 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_init (value, G_TYPE_UINT);
#line 325 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = self->system_update_id;
#line 325 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_set_uint (value, (guint) _tmp0_);
#line 1831 "rygel-content-directory.c"
}


static void rygel_content_directory_query_container_update_ids (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	gchar* update_ids = NULL;
	gchar* _tmp0_ = NULL;
#line 329 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 329 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 329 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (variable != NULL);
#line 329 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (value != NULL);
#line 332 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = rygel_content_directory_create_container_update_ids (self);
#line 332 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	update_ids = _tmp0_;
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_init (value, G_TYPE_STRING);
#line 336 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_set_string (value, update_ids);
#line 329 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (update_ids);
#line 1856 "rygel-content-directory.c"
}


static void rygel_content_directory_get_search_capabilities_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	RygelMediaServerPlugin* plugin = NULL;
	GUPnPRootDevice* _tmp4_ = NULL;
	GUPnPRootDevice* _tmp5_ = NULL;
	GUPnPRootDevice* _tmp6_ = NULL;
	GUPnPResourceFactory* _tmp7_ = NULL;
	GUPnPResourceFactory* _tmp8_ = NULL;
	RygelMediaServerPlugin* _tmp9_ = NULL;
	RygelMediaServerPlugin* _tmp10_ = NULL;
	GUPnPServiceAction* _tmp11_ = NULL;
	RygelMediaServerPlugin* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GUPnPServiceAction* _tmp15_ = NULL;
#line 340 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 340 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 340 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 342 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 342 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 342 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp1_ != ((guint) 0)) {
#line 1888 "rygel-content-directory.c"
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 343 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp2_ = action;
#line 343 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp3_ = _ ("Invalid argument");
#line 343 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		return;
#line 1899 "rygel-content-directory.c"
	}
#line 348 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_object_get ((GUPnPService*) self, "root-device", &_tmp4_, NULL);
#line 348 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp5_ = _tmp4_;
#line 348 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp6_ = _tmp5_;
#line 348 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp7_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp6_);
#line 348 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp8_ = _tmp7_;
#line 348 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, RYGEL_TYPE_MEDIA_SERVER_PLUGIN) ? ((RygelMediaServerPlugin*) _tmp8_) : NULL);
#line 348 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp10_ = _tmp9_;
#line 348 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (_tmp6_);
#line 348 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	plugin = _tmp10_;
#line 351 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp11_ = action;
#line 351 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp12_ = plugin;
#line 351 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp13_ = rygel_media_server_plugin_get_search_caps (_tmp12_);
#line 351 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp14_ = _tmp13_;
#line 351 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_action_set (_tmp11_, "SearchCaps", G_TYPE_STRING, _tmp14_, NULL);
#line 353 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp15_ = action;
#line 353 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_action_return (_tmp15_);
#line 340 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (plugin);
#line 1935 "rygel-content-directory.c"
}


static void rygel_content_directory_query_search_capabilities (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	RygelMediaServerPlugin* plugin = NULL;
	GUPnPRootDevice* _tmp0_ = NULL;
	GUPnPRootDevice* _tmp1_ = NULL;
	GUPnPRootDevice* _tmp2_ = NULL;
	GUPnPResourceFactory* _tmp3_ = NULL;
	GUPnPResourceFactory* _tmp4_ = NULL;
	RygelMediaServerPlugin* _tmp5_ = NULL;
	RygelMediaServerPlugin* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
#line 357 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 357 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 357 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (variable != NULL);
#line 357 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (value != NULL);
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_object_get ((GUPnPService*) self, "root-device", &_tmp0_, NULL);
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = _tmp0_;
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = _tmp1_;
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp3_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp2_);
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp4_ = _tmp3_;
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_MEDIA_SERVER_PLUGIN) ? ((RygelMediaServerPlugin*) _tmp4_) : NULL);
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp6_ = _tmp5_;
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (_tmp2_);
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	plugin = _tmp6_;
#line 363 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_init (value, G_TYPE_STRING);
#line 364 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp7_ = rygel_media_server_plugin_get_search_caps (plugin);
#line 364 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp8_ = _tmp7_;
#line 364 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_set_string (value, _tmp8_);
#line 357 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (plugin);
#line 1986 "rygel-content-directory.c"
}


static void rygel_content_directory_get_sort_capabilities_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_ = NULL;
	GUPnPServiceAction* _tmp5_ = NULL;
#line 368 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 368 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 368 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 371 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 371 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 371 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp1_ != ((guint) 0)) {
#line 2007 "rygel-content-directory.c"
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 372 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp2_ = action;
#line 372 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp3_ = _ ("Invalid argument");
#line 372 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 374 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		return;
#line 2018 "rygel-content-directory.c"
	}
#line 378 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp4_ = action;
#line 378 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_action_set (_tmp4_, "SortCaps", G_TYPE_STRING, RYGEL_MEDIA_OBJECTS_SORT_CAPS, NULL);
#line 380 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp5_ = action;
#line 380 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_action_return (_tmp5_);
#line 2028 "rygel-content-directory.c"
}


static void rygel_content_directory_query_sort_capabilities (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
#line 384 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 384 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 384 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (variable != NULL);
#line 384 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (value != NULL);
#line 388 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_init (value, G_TYPE_STRING);
#line 389 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_set_string (value, RYGEL_MEDIA_OBJECTS_SORT_CAPS);
#line 2045 "rygel-content-directory.c"
}


static void rygel_content_directory_get_feature_list_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GUPnPServiceAction* _tmp6_ = NULL;
#line 393 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 393 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 393 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 396 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 396 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 396 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp1_ != ((guint) 0)) {
#line 2067 "rygel-content-directory.c"
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 397 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp2_ = action;
#line 397 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp3_ = _ ("Invalid argument");
#line 397 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 399 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		return;
#line 2078 "rygel-content-directory.c"
	}
#line 403 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp4_ = action;
#line 403 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp5_ = self->feature_list;
#line 403 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_action_set (_tmp4_, "FeatureList", G_TYPE_STRING, _tmp5_, NULL);
#line 405 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp6_ = action;
#line 405 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_action_return (_tmp6_);
#line 2090 "rygel-content-directory.c"
}


static void rygel_content_directory_query_feature_list (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	const gchar* _tmp0_ = NULL;
#line 409 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 409 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 409 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (variable != NULL);
#line 409 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (value != NULL);
#line 413 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_init (value, G_TYPE_STRING);
#line 414 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = self->feature_list;
#line 414 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_set_string (value, _tmp0_);
#line 2110 "rygel-content-directory.c"
}


static gchar* rygel_content_directory_create_container_update_ids (RygelContentDirectory* self) {
	gchar* result = NULL;
	gchar* update_ids = NULL;
	gchar* _tmp0_ = NULL;
#line 417 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 418 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = g_strdup ("");
#line 418 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	update_ids = _tmp0_;
#line 2124 "rygel-content-directory.c"
	{
		GeeArrayList* _container_list = NULL;
		GeeArrayList* _tmp1_ = NULL;
		GeeArrayList* _tmp2_ = NULL;
		gint _container_size = 0;
		GeeArrayList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _container_index = 0;
#line 420 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp1_ = self->priv->updated_containers;
#line 420 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 420 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_container_list = _tmp2_;
#line 420 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp3_ = _container_list;
#line 420 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
#line 420 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp5_ = _tmp4_;
#line 420 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_container_size = _tmp5_;
#line 420 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_container_index = -1;
#line 420 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		while (TRUE) {
#line 2152 "rygel-content-directory.c"
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			RygelMediaContainer* container = NULL;
			GeeArrayList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			const gchar* _tmp15_ = NULL;
			RygelMediaContainer* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			RygelMediaContainer* _tmp21_ = NULL;
			guint32 _tmp22_ = 0U;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
#line 420 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp6_ = _container_index;
#line 420 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_container_index = _tmp6_ + 1;
#line 420 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp7_ = _container_index;
#line 420 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp8_ = _container_size;
#line 420 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 420 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				break;
#line 2186 "rygel-content-directory.c"
			}
#line 420 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp9_ = _container_list;
#line 420 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp10_ = _container_index;
#line 420 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 420 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			container = (RygelMediaContainer*) _tmp11_;
#line 421 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp12_ = update_ids;
#line 421 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			if (g_strcmp0 (_tmp12_, "") != 0) {
#line 2200 "rygel-content-directory.c"
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp13_ = update_ids;
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp14_ = g_strconcat (_tmp13_, ",", NULL);
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_g_free0 (update_ids);
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				update_ids = _tmp14_;
#line 2211 "rygel-content-directory.c"
			}
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp15_ = update_ids;
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp16_ = container;
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp17_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp16_);
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp18_ = _tmp17_;
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp19_ = g_strconcat (_tmp18_, ",", NULL);
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp20_ = _tmp19_;
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp21_ = container;
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp22_ = _tmp21_->update_id;
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp23_ = g_strdup_printf ("%u", _tmp22_);
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp24_ = _tmp23_;
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp25_ = g_strconcat (_tmp20_, _tmp24_, NULL);
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp26_ = _tmp25_;
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp27_ = g_strconcat (_tmp15_, _tmp26_, NULL);
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_free0 (update_ids);
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			update_ids = _tmp27_;
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_free0 (_tmp26_);
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_free0 (_tmp24_);
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_free0 (_tmp20_);
#line 420 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_object_unref0 (container);
#line 2251 "rygel-content-directory.c"
		}
#line 420 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (_container_list);
#line 2255 "rygel-content-directory.c"
	}
#line 428 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	result = update_ids;
#line 428 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return result;
#line 2261 "rygel-content-directory.c"
}


static gboolean rygel_content_directory_handle_system_update (RygelContentDirectory* self) {
	gboolean result = FALSE;
	RygelMediaServerPlugin* plugin = NULL;
	GUPnPRootDevice* _tmp0_ = NULL;
	GUPnPRootDevice* _tmp1_ = NULL;
	GUPnPRootDevice* _tmp2_ = NULL;
	GUPnPResourceFactory* _tmp3_ = NULL;
	GUPnPResourceFactory* _tmp4_ = NULL;
	RygelMediaServerPlugin* _tmp5_ = NULL;
	RygelMediaServerPlugin* _tmp6_ = NULL;
	guint32 _tmp7_ = 0U;
	gboolean _tmp8_ = FALSE;
	guint32 _tmp9_ = 0U;
#line 431 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 432 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_object_get ((GUPnPService*) self, "root-device", &_tmp0_, NULL);
#line 432 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = _tmp0_;
#line 432 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = _tmp1_;
#line 432 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp3_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp2_);
#line 432 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp4_ = _tmp3_;
#line 432 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_MEDIA_SERVER_PLUGIN) ? ((RygelMediaServerPlugin*) _tmp4_) : NULL);
#line 432 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp6_ = _tmp5_;
#line 432 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (_tmp2_);
#line 432 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	plugin = _tmp6_;
#line 437 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp7_ = self->system_update_id;
#line 437 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self->system_update_id = _tmp7_ + 1;
#line 438 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp9_ = self->system_update_id;
#line 438 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp9_ == ((guint32) 0)) {
#line 2306 "rygel-content-directory.c"
		RygelMediaServerPlugin* _tmp10_ = NULL;
		RygelPluginCapabilities _tmp11_ = 0;
		RygelPluginCapabilities _tmp12_ = 0;
#line 439 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp10_ = plugin;
#line 439 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp11_ = rygel_plugin_get_capabilities ((RygelPlugin*) _tmp10_);
#line 439 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp12_ = _tmp11_;
#line 439 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp8_ = (_tmp12_ & RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) == RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES;
#line 2318 "rygel-content-directory.c"
	} else {
#line 438 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp8_ = FALSE;
#line 2322 "rygel-content-directory.c"
	}
#line 438 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp8_) {
#line 442 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		rygel_content_directory_service_reset (self, NULL, NULL);
#line 444 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		result = TRUE;
#line 444 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (plugin);
#line 444 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		return result;
#line 2334 "rygel-content-directory.c"
	}
#line 447 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	result = FALSE;
#line 447 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (plugin);
#line 447 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return result;
#line 2342 "rygel-content-directory.c"
}


static void rygel_content_directory_handle_last_change (RygelContentDirectory* self, RygelMediaContainer* updated_container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update) {
	RygelMediaContainer* _tmp0_ = NULL;
#line 450 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 450 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (updated_container != NULL);
#line 450 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (object != NULL);
#line 454 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = updated_container;
#line 454 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_TRACKABLE_CONTAINER)) {
#line 2358 "rygel-content-directory.c"
		RygelMediaObject* _tmp1_ = NULL;
		RygelObjectEventType _tmp2_ = 0;
		gboolean _tmp3_ = FALSE;
#line 455 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp1_ = object;
#line 455 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp2_ = event_type;
#line 455 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp3_ = sub_tree_update;
#line 455 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		rygel_content_directory_add_last_change_entry (self, _tmp1_, _tmp2_, _tmp3_);
#line 2370 "rygel-content-directory.c"
	}
}


static gboolean rygel_content_directory_set_update_ids (RygelContentDirectory* self, RygelMediaContainer* updated_container, RygelMediaObject* object, RygelObjectEventType event_type) {
	gboolean result = FALSE;
	gboolean container_changed = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	RygelObjectEventType _tmp2_ = 0;
	RygelMediaObject* _tmp9_ = NULL;
	guint32 _tmp10_ = 0U;
	RygelMediaObject* _tmp11_ = NULL;
#line 459 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 459 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_val_if_fail (updated_container != NULL, FALSE);
#line 459 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_val_if_fail (object != NULL, FALSE);
#line 462 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	container_changed = FALSE;
#line 464 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = event_type;
#line 464 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp2_ == RYGEL_OBJECT_EVENT_TYPE_ADDED) {
#line 464 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp1_ = TRUE;
#line 2398 "rygel-content-directory.c"
	} else {
		RygelObjectEventType _tmp3_ = 0;
#line 465 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp3_ = event_type;
#line 465 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp1_ = _tmp3_ == RYGEL_OBJECT_EVENT_TYPE_DELETED;
#line 2405 "rygel-content-directory.c"
	}
#line 464 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp1_) {
#line 464 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp0_ = TRUE;
#line 2411 "rygel-content-directory.c"
	} else {
		gboolean _tmp4_ = FALSE;
		RygelObjectEventType _tmp5_ = 0;
#line 466 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp5_ = event_type;
#line 466 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		if (_tmp5_ == RYGEL_OBJECT_EVENT_TYPE_MODIFIED) {
#line 2419 "rygel-content-directory.c"
			RygelMediaObject* _tmp6_ = NULL;
#line 467 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp6_ = object;
#line 467 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, RYGEL_TYPE_MEDIA_ITEM);
#line 2425 "rygel-content-directory.c"
		} else {
#line 466 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp4_ = FALSE;
#line 2429 "rygel-content-directory.c"
		}
#line 466 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp0_ = _tmp4_;
#line 2433 "rygel-content-directory.c"
	}
#line 464 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp0_) {
#line 2437 "rygel-content-directory.c"
		RygelMediaContainer* _tmp7_ = NULL;
		guint32 _tmp8_ = 0U;
#line 468 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp7_ = updated_container;
#line 468 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp8_ = self->system_update_id;
#line 468 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp7_->update_id = _tmp8_;
#line 469 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		container_changed = TRUE;
#line 2448 "rygel-content-directory.c"
	}
#line 472 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp9_ = object;
#line 472 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp10_ = self->system_update_id;
#line 472 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_media_object_set_object_update_id (_tmp9_, (guint) _tmp10_);
#line 475 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp11_ = object;
#line 475 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, RYGEL_TYPE_MEDIA_CONTAINER)) {
#line 2460 "rygel-content-directory.c"
		RygelMediaObject* _tmp12_ = NULL;
		guint32 _tmp13_ = 0U;
#line 476 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp12_ = object;
#line 476 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp13_ = self->system_update_id;
#line 476 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		(G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp12_) : NULL)->update_id = _tmp13_;
#line 2469 "rygel-content-directory.c"
	}
#line 479 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	result = container_changed;
#line 479 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return result;
#line 2475 "rygel-content-directory.c"
}


static void rygel_content_directory_handle_container_update_ids (RygelContentDirectory* self, RygelMediaContainer* updated_container, RygelMediaObject* object) {
	gboolean updated = FALSE;
	RygelMediaContainer* _tmp0_ = NULL;
	gboolean is_container = FALSE;
	RygelMediaObject* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp12_ = FALSE;
#line 482 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 482 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (object != NULL);
#line 484 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = updated_container;
#line 484 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	updated = _tmp0_ != NULL;
#line 485 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = object;
#line 485 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	is_container = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_MEDIA_CONTAINER);
#line 487 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp3_ = updated;
#line 487 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (!_tmp3_) {
#line 2505 "rygel-content-directory.c"
		gboolean _tmp4_ = FALSE;
#line 487 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp4_ = is_container;
#line 487 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp2_ = !_tmp4_;
#line 2511 "rygel-content-directory.c"
	} else {
#line 487 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp2_ = FALSE;
#line 2515 "rygel-content-directory.c"
	}
#line 487 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp2_) {
#line 488 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		return;
#line 2521 "rygel-content-directory.c"
	}
#line 491 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp5_ = self->priv->clear_updated_containers;
#line 491 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp5_) {
#line 2527 "rygel-content-directory.c"
		GeeArrayList* _tmp6_ = NULL;
#line 492 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp6_ = self->priv->updated_containers;
#line 492 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp6_);
#line 493 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		self->priv->clear_updated_containers = FALSE;
#line 2535 "rygel-content-directory.c"
	}
#line 497 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp7_ = updated;
#line 497 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp7_) {
#line 2541 "rygel-content-directory.c"
		GeeArrayList* _tmp8_ = NULL;
		RygelMediaContainer* _tmp9_ = NULL;
		GeeArrayList* _tmp10_ = NULL;
		RygelMediaContainer* _tmp11_ = NULL;
#line 498 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp8_ = self->priv->updated_containers;
#line 498 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp9_ = updated_container;
#line 498 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp8_, _tmp9_);
#line 499 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp10_ = self->priv->updated_containers;
#line 499 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp11_ = updated_container;
#line 499 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
#line 2558 "rygel-content-directory.c"
	}
#line 502 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp12_ = is_container;
#line 502 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp12_) {
#line 2564 "rygel-content-directory.c"
		RygelMediaContainer* container = NULL;
		RygelMediaObject* _tmp13_ = NULL;
		RygelMediaContainer* _tmp14_ = NULL;
		GeeArrayList* _tmp15_ = NULL;
		RygelMediaContainer* _tmp16_ = NULL;
		GeeArrayList* _tmp17_ = NULL;
		RygelMediaContainer* _tmp18_ = NULL;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp13_ = object;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp13_) : NULL);
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		container = _tmp14_;
#line 505 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp15_ = self->priv->updated_containers;
#line 505 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp16_ = container;
#line 505 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp15_, _tmp16_);
#line 506 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp17_ = self->priv->updated_containers;
#line 506 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp18_ = container;
#line 506 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp18_);
#line 502 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (container);
#line 2592 "rygel-content-directory.c"
	}
}


/**
     * handler for container_updated signal on root_container. We don't
     * immediately send the notification for changes but schedule the
     * notification after 0.2 seconds. Also we don't clear the updated
     * container list immediately after notification but rather in this
     * function. Please refer to ContentDirectory version 2 specs for details
     * on why we do all this the way we do.
     *
     * @param root_container the root_container
     * @param updated_container the container that just got updated
     */
static void rygel_content_directory_on_container_updated (RygelContentDirectory* self, RygelMediaContainer* root_container, RygelMediaContainer* updated_container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update) {
	gboolean _tmp0_ = FALSE;
	RygelMediaContainer* _tmp1_ = NULL;
	RygelMediaObject* _tmp2_ = NULL;
	RygelObjectEventType _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gboolean changed = FALSE;
	RygelMediaContainer* _tmp5_ = NULL;
	RygelMediaObject* _tmp6_ = NULL;
	RygelObjectEventType _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	RygelMediaContainer* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	RygelMediaObject* _tmp12_ = NULL;
#line 521 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 521 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (root_container != NULL);
#line 521 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (updated_container != NULL);
#line 521 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (object != NULL);
#line 526 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = rygel_content_directory_handle_system_update (self);
#line 526 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp0_) {
#line 527 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		return;
#line 2636 "rygel-content-directory.c"
	}
#line 529 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = updated_container;
#line 529 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = object;
#line 529 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp3_ = event_type;
#line 529 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp4_ = sub_tree_update;
#line 529 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_handle_last_change (self, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 534 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp5_ = updated_container;
#line 534 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp6_ = object;
#line 534 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp7_ = event_type;
#line 534 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp8_ = rygel_content_directory_set_update_ids (self, _tmp5_, _tmp6_, _tmp7_);
#line 534 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	changed = _tmp8_;
#line 535 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp10_ = changed;
#line 535 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp10_) {
#line 2662 "rygel-content-directory.c"
		RygelMediaContainer* _tmp11_ = NULL;
#line 535 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp11_ = updated_container;
#line 535 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp9_ = _tmp11_;
#line 2668 "rygel-content-directory.c"
	} else {
#line 535 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp9_ = NULL;
#line 2672 "rygel-content-directory.c"
	}
#line 535 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp12_ = object;
#line 535 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_handle_container_update_ids (self, _tmp9_, _tmp12_);
#line 538 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_ensure_timeout (self);
#line 2680 "rygel-content-directory.c"
}


static void rygel_content_directory_on_sub_tree_updates_finished (RygelContentDirectory* self, RygelMediaContainer* root_container, RygelMediaObject* sub_tree_root) {
	RygelLastChangeStDone* entry = NULL;
	RygelMediaObject* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	guint32 _tmp3_ = 0U;
	RygelLastChangeStDone* _tmp4_ = NULL;
	RygelLastChange* _tmp5_ = NULL;
#line 541 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 541 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (root_container != NULL);
#line 541 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (sub_tree_root != NULL);
#line 545 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = sub_tree_root;
#line 545 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = rygel_media_object_get_id (_tmp0_);
#line 545 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = _tmp1_;
#line 545 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp3_ = self->system_update_id;
#line 545 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp4_ = rygel_last_change_st_done_new (_tmp2_, (guint) _tmp3_);
#line 545 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	entry = _tmp4_;
#line 548 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp5_ = self->priv->last_change;
#line 548 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_last_change_add_event (_tmp5_, (RygelLastChangeEntry*) entry);
#line 549 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_ensure_timeout (self);
#line 541 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (entry);
#line 2718 "rygel-content-directory.c"
}


static gboolean rygel_content_directory_update_notify (RygelContentDirectory* self) {
	gboolean result = FALSE;
	gchar* update_ids = NULL;
	gchar* _tmp0_ = NULL;
	guint32 _tmp1_ = 0U;
	RygelLastChange* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	RygelLastChange* _tmp5_ = NULL;
#line 552 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 553 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = rygel_content_directory_create_container_update_ids (self);
#line 553 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	update_ids = _tmp0_;
#line 555 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_notify ((GUPnPService*) self, "ContainerUpdateIDs", G_TYPE_STRING, update_ids, NULL);
#line 556 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = self->system_update_id;
#line 556 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_notify ((GUPnPService*) self, "SystemUpdateID", G_TYPE_UINT, _tmp1_, NULL);
#line 557 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = self->priv->last_change;
#line 557 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp3_ = rygel_last_change_get_log (_tmp2_);
#line 557 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp4_ = _tmp3_;
#line 557 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_notify ((GUPnPService*) self, "LastChange", G_TYPE_STRING, _tmp4_, NULL);
#line 557 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (_tmp4_);
#line 559 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self->priv->clear_updated_containers = TRUE;
#line 560 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self->priv->update_notify_id = (guint) 0;
#line 561 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp5_ = self->priv->last_change;
#line 561 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_last_change_clear_on_new_event (_tmp5_);
#line 563 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	result = FALSE;
#line 563 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (update_ids);
#line 563 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return result;
#line 2767 "rygel-content-directory.c"
}


static gchar* rygel_content_directory_create_transfer_ids (RygelContentDirectory* self) {
	gchar* result = NULL;
	gchar* ids = NULL;
	gchar* _tmp0_ = NULL;
#line 566 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 567 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = g_strdup ("");
#line 567 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	ids = _tmp0_;
#line 2781 "rygel-content-directory.c"
	{
		GeeArrayList* _import_list = NULL;
		GeeArrayList* _tmp1_ = NULL;
		GeeArrayList* _tmp2_ = NULL;
		gint _import_size = 0;
		GeeArrayList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _import_index = 0;
#line 569 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp1_ = self->priv->active_imports;
#line 569 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 569 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_import_list = _tmp2_;
#line 569 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp3_ = _import_list;
#line 569 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
#line 569 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp5_ = _tmp4_;
#line 569 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_import_size = _tmp5_;
#line 569 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_import_index = -1;
#line 569 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		while (TRUE) {
#line 2809 "rygel-content-directory.c"
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			RygelImportResource* import = NULL;
			GeeArrayList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			const gchar* _tmp15_ = NULL;
			RygelImportResource* _tmp16_ = NULL;
			guint32 _tmp17_ = 0U;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
#line 569 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp6_ = _import_index;
#line 569 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_import_index = _tmp6_ + 1;
#line 569 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp7_ = _import_index;
#line 569 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp8_ = _import_size;
#line 569 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 569 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				break;
#line 2836 "rygel-content-directory.c"
			}
#line 569 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp9_ = _import_list;
#line 569 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp10_ = _import_index;
#line 569 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 569 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			import = (RygelImportResource*) _tmp11_;
#line 570 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp12_ = ids;
#line 570 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			if (g_strcmp0 (_tmp12_, "") != 0) {
#line 2850 "rygel-content-directory.c"
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
#line 571 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp13_ = ids;
#line 571 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp14_ = g_strconcat (_tmp13_, ",", NULL);
#line 571 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_g_free0 (ids);
#line 571 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				ids = _tmp14_;
#line 2861 "rygel-content-directory.c"
			}
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp15_ = ids;
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp16_ = import;
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp17_ = _tmp16_->transfer_id;
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp18_ = g_strdup_printf ("%u", _tmp17_);
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp19_ = _tmp18_;
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp20_ = g_strconcat (_tmp15_, _tmp19_, NULL);
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_free0 (ids);
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			ids = _tmp20_;
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_free0 (_tmp19_);
#line 569 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_object_unref0 (import);
#line 2883 "rygel-content-directory.c"
		}
#line 569 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (_import_list);
#line 2887 "rygel-content-directory.c"
	}
#line 577 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	result = ids;
#line 577 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return result;
#line 2893 "rygel-content-directory.c"
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 580 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 580 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return _data5_;
#line 2902 "rygel-content-directory.c"
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 580 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 2911 "rygel-content-directory.c"
		RygelContentDirectory* self;
#line 580 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		self = _data5_->self;
#line 580 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (_data5_->import);
#line 580 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (self);
#line 580 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_slice_free (Block5Data, _data5_);
#line 2921 "rygel-content-directory.c"
	}
}


static gboolean __lambda15_ (Block5Data* _data5_) {
	RygelContentDirectory* self;
	gboolean result = FALSE;
	GeeArrayList* _tmp0_ = NULL;
#line 593 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self = _data5_->self;
#line 594 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = self->priv->finished_imports;
#line 594 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _data5_->import);
#line 596 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	result = FALSE;
#line 596 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return result;
#line 2940 "rygel-content-directory.c"
}


static gboolean ___lambda15__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda15_ (self);
#line 593 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return result;
#line 2949 "rygel-content-directory.c"
}


static void rygel_content_directory_on_import_completed (RygelContentDirectory* self, RygelStateMachine* machine) {
	Block5Data* _data5_;
	RygelStateMachine* _tmp0_ = NULL;
	RygelImportResource* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
#line 580 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 580 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (machine != NULL);
#line 580 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 580 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data5_->_ref_count_ = 1;
#line 580 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data5_->self = g_object_ref (self);
#line 581 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = machine;
#line 581 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_IMPORT_RESOURCE) ? ((RygelImportResource*) _tmp0_) : NULL);
#line 581 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data5_->import = _tmp1_;
#line 583 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = self->priv->finished_imports;
#line 583 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, _data5_->import);
#line 584 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp3_ = self->priv->active_imports;
#line 584 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp3_, _data5_->import);
#line 587 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp4_ = rygel_content_directory_create_transfer_ids (self);
#line 587 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp5_ = _tmp4_;
#line 587 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_notify ((GUPnPService*) self, "TransferIDs", G_TYPE_STRING, _tmp5_, NULL);
#line 587 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (_tmp5_);
#line 593 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 30, ___lambda15__gsource_func, block5_data_ref (_data5_), block5_data_unref);
#line 580 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	block5_data_unref (_data5_);
#line 580 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data5_ = NULL;
#line 2999 "rygel-content-directory.c"
}


static RygelImportResource* rygel_content_directory_find_import_for_action (RygelContentDirectory* self, GUPnPServiceAction* action, GError** error) {
	RygelImportResource* result = NULL;
	RygelImportResource* ret = NULL;
	guint32 transfer_id = 0U;
	gchar* transfer_id_string = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	guint32 _tmp2_ = 0U;
	RygelImportResource* _tmp40_ = NULL;
	GError * _inner_error_ = NULL;
#line 600 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 600 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_val_if_fail (action != NULL, NULL);
#line 602 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	ret = NULL;
#line 607 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 607 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_action_get (_tmp0_, "TransferID", G_TYPE_UINT, &transfer_id, "TransferID", G_TYPE_STRING, &transfer_id_string, NULL);
#line 613 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = transfer_id;
#line 613 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp2_ == ((guint32) 0)) {
#line 3027 "rygel-content-directory.c"
		gboolean _tmp3_ = FALSE;
		const gchar* _tmp4_ = NULL;
#line 614 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp4_ = transfer_id_string;
#line 614 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		if (_tmp4_ == NULL) {
#line 614 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp3_ = TRUE;
#line 3036 "rygel-content-directory.c"
		} else {
			const gchar* _tmp5_ = NULL;
#line 614 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp5_ = transfer_id_string;
#line 614 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp3_ = g_strcmp0 (_tmp5_, "0") != 0;
#line 3043 "rygel-content-directory.c"
		}
#line 614 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp1_ = _tmp3_;
#line 3047 "rygel-content-directory.c"
	} else {
#line 613 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp1_ = FALSE;
#line 3051 "rygel-content-directory.c"
	}
#line 613 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp1_) {
#line 3055 "rygel-content-directory.c"
		const gchar* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
#line 615 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp6_ = _ ("Invalid argument");
#line 615 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp7_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _tmp6_);
#line 615 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_inner_error_ = _tmp7_;
#line 615 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		if (_inner_error_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
#line 615 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			g_propagate_error (error, _inner_error_);
#line 615 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_free0 (transfer_id_string);
#line 615 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_object_unref0 (ret);
#line 615 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			return NULL;
#line 3074 "rygel-content-directory.c"
		} else {
#line 615 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_free0 (transfer_id_string);
#line 615 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_object_unref0 (ret);
#line 615 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 615 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			g_clear_error (&_inner_error_);
#line 615 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			return NULL;
#line 3086 "rygel-content-directory.c"
		}
	}
	{
		GeeArrayList* _import_list = NULL;
		GeeArrayList* _tmp8_ = NULL;
		GeeArrayList* _tmp9_ = NULL;
		gint _import_size = 0;
		GeeArrayList* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _import_index = 0;
#line 619 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp8_ = self->priv->active_imports;
#line 619 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 619 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_import_list = _tmp9_;
#line 619 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp10_ = _import_list;
#line 619 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp11_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp10_);
#line 619 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp12_ = _tmp11_;
#line 619 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_import_size = _tmp12_;
#line 619 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_import_index = -1;
#line 619 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		while (TRUE) {
#line 3116 "rygel-content-directory.c"
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			RygelImportResource* import = NULL;
			GeeArrayList* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gpointer _tmp18_ = NULL;
			RygelImportResource* _tmp19_ = NULL;
			guint32 _tmp20_ = 0U;
			guint32 _tmp21_ = 0U;
#line 619 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp13_ = _import_index;
#line 619 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_import_index = _tmp13_ + 1;
#line 619 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp14_ = _import_index;
#line 619 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp15_ = _import_size;
#line 619 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			if (!(_tmp14_ < _tmp15_)) {
#line 619 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				break;
#line 3139 "rygel-content-directory.c"
			}
#line 619 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp16_ = _import_list;
#line 619 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp17_ = _import_index;
#line 619 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp17_);
#line 619 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			import = (RygelImportResource*) _tmp18_;
#line 620 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp19_ = import;
#line 620 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp20_ = _tmp19_->transfer_id;
#line 620 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp21_ = transfer_id;
#line 620 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			if (_tmp20_ == _tmp21_) {
#line 3157 "rygel-content-directory.c"
				RygelImportResource* _tmp22_ = NULL;
				RygelImportResource* _tmp23_ = NULL;
#line 621 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp22_ = import;
#line 621 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp23_ = _g_object_ref0 (_tmp22_);
#line 621 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_g_object_unref0 (ret);
#line 621 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				ret = _tmp23_;
#line 623 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_g_object_unref0 (import);
#line 623 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				break;
#line 3172 "rygel-content-directory.c"
			}
#line 619 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_object_unref0 (import);
#line 3176 "rygel-content-directory.c"
		}
#line 619 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (_import_list);
#line 3180 "rygel-content-directory.c"
	}
	{
		GeeArrayList* _import_list = NULL;
		GeeArrayList* _tmp24_ = NULL;
		GeeArrayList* _tmp25_ = NULL;
		gint _import_size = 0;
		GeeArrayList* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
		gint _import_index = 0;
#line 627 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp24_ = self->priv->finished_imports;
#line 627 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp25_ = _g_object_ref0 (_tmp24_);
#line 627 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_import_list = _tmp25_;
#line 627 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp26_ = _import_list;
#line 627 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp27_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp26_);
#line 627 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp28_ = _tmp27_;
#line 627 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_import_size = _tmp28_;
#line 627 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_import_index = -1;
#line 627 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		while (TRUE) {
#line 3209 "rygel-content-directory.c"
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			RygelImportResource* import = NULL;
			GeeArrayList* _tmp32_ = NULL;
			gint _tmp33_ = 0;
			gpointer _tmp34_ = NULL;
			RygelImportResource* _tmp35_ = NULL;
			guint32 _tmp36_ = 0U;
			guint32 _tmp37_ = 0U;
#line 627 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp29_ = _import_index;
#line 627 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_import_index = _tmp29_ + 1;
#line 627 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp30_ = _import_index;
#line 627 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp31_ = _import_size;
#line 627 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			if (!(_tmp30_ < _tmp31_)) {
#line 627 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				break;
#line 3232 "rygel-content-directory.c"
			}
#line 627 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp32_ = _import_list;
#line 627 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp33_ = _import_index;
#line 627 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _tmp32_, _tmp33_);
#line 627 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			import = (RygelImportResource*) _tmp34_;
#line 628 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp35_ = import;
#line 628 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp36_ = _tmp35_->transfer_id;
#line 628 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp37_ = transfer_id;
#line 628 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			if (_tmp36_ == _tmp37_) {
#line 3250 "rygel-content-directory.c"
				RygelImportResource* _tmp38_ = NULL;
				RygelImportResource* _tmp39_ = NULL;
#line 629 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp38_ = import;
#line 629 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp39_ = _g_object_ref0 (_tmp38_);
#line 629 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_g_object_unref0 (ret);
#line 629 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				ret = _tmp39_;
#line 631 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_g_object_unref0 (import);
#line 631 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				break;
#line 3265 "rygel-content-directory.c"
			}
#line 627 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_object_unref0 (import);
#line 3269 "rygel-content-directory.c"
		}
#line 627 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (_import_list);
#line 3273 "rygel-content-directory.c"
	}
#line 635 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp40_ = ret;
#line 635 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp40_ == NULL) {
#line 3279 "rygel-content-directory.c"
		const gchar* _tmp41_ = NULL;
		GError* _tmp42_ = NULL;
#line 636 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp41_ = _ ("No such file transfer");
#line 636 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp42_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_FILE_TRANSFER, _tmp41_);
#line 636 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_inner_error_ = _tmp42_;
#line 636 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		if (_inner_error_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
#line 636 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			g_propagate_error (error, _inner_error_);
#line 636 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_free0 (transfer_id_string);
#line 636 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_object_unref0 (ret);
#line 636 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			return NULL;
#line 3298 "rygel-content-directory.c"
		} else {
#line 636 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_free0 (transfer_id_string);
#line 636 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_object_unref0 (ret);
#line 636 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 636 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			g_clear_error (&_inner_error_);
#line 636 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			return NULL;
#line 3310 "rygel-content-directory.c"
		}
	}
#line 640 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	result = ret;
#line 640 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (transfer_id_string);
#line 640 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return result;
#line 3319 "rygel-content-directory.c"
}


static void rygel_content_directory_query_last_change (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	RygelLastChange* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 644 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 644 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 644 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (variable != NULL);
#line 644 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (value != NULL);
#line 647 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_init (value, G_TYPE_STRING);
#line 648 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = self->priv->last_change;
#line 648 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = rygel_last_change_get_log (_tmp0_);
#line 648 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = _tmp1_;
#line 648 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_set_string (value, _tmp2_);
#line 648 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (_tmp2_);
#line 3347 "rygel-content-directory.c"
}


static gboolean _rygel_content_directory_update_notify_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_content_directory_update_notify ((RygelContentDirectory*) self);
#line 654 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return result;
#line 3356 "rygel-content-directory.c"
}


static void rygel_content_directory_ensure_timeout (RygelContentDirectory* self) {
	guint _tmp0_ = 0U;
#line 651 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 653 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = self->priv->update_notify_id;
#line 653 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp0_ == ((guint) 0)) {
#line 3368 "rygel-content-directory.c"
		guint _tmp1_ = 0U;
#line 654 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp1_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, _rygel_content_directory_update_notify_gsource_func, g_object_ref (self), g_object_unref);
#line 654 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		self->priv->update_notify_id = _tmp1_;
#line 3374 "rygel-content-directory.c"
	}
}


static void rygel_content_directory_add_last_change_entry (RygelContentDirectory* self, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update) {
	RygelLastChangeEntry* entry = NULL;
	RygelObjectEventType _tmp0_ = 0;
	RygelLastChange* _tmp27_ = NULL;
	RygelLastChangeEntry* _tmp28_ = NULL;
#line 658 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 658 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (object != NULL);
#line 664 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = event_type;
#line 664 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	switch (_tmp0_) {
#line 664 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		case RYGEL_OBJECT_EVENT_TYPE_ADDED:
#line 3394 "rygel-content-directory.c"
		{
			RygelMediaObject* _tmp1_ = NULL;
			const gchar* _tmp2_ = NULL;
			const gchar* _tmp3_ = NULL;
			guint32 _tmp4_ = 0U;
			gboolean _tmp5_ = FALSE;
			RygelMediaObject* _tmp6_ = NULL;
			RygelMediaContainer* _tmp7_ = NULL;
			RygelMediaContainer* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			RygelMediaObject* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			RygelLastChangeObjAdd* _tmp14_ = NULL;
#line 666 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp1_ = object;
#line 666 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp2_ = rygel_media_object_get_id (_tmp1_);
#line 666 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp3_ = _tmp2_;
#line 666 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp4_ = self->system_update_id;
#line 666 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp5_ = sub_tree_update;
#line 666 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp6_ = object;
#line 666 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp7_ = rygel_media_object_get_parent (_tmp6_);
#line 666 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp8_ = _tmp7_;
#line 666 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp9_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp8_);
#line 666 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp10_ = _tmp9_;
#line 666 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp11_ = object;
#line 666 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp12_ = rygel_media_object_get_upnp_class (_tmp11_);
#line 666 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp13_ = _tmp12_;
#line 666 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp14_ = rygel_last_change_obj_add_new (_tmp3_, (guint) _tmp4_, _tmp5_, _tmp10_, _tmp13_);
#line 666 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_object_unref0 (entry);
#line 666 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			entry = (RygelLastChangeEntry*) _tmp14_;
#line 671 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			break;
#line 3444 "rygel-content-directory.c"
		}
#line 664 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		case RYGEL_OBJECT_EVENT_TYPE_MODIFIED:
#line 3448 "rygel-content-directory.c"
		{
			RygelMediaObject* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			guint32 _tmp18_ = 0U;
			gboolean _tmp19_ = FALSE;
			RygelLastChangeObjMod* _tmp20_ = NULL;
#line 674 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp15_ = object;
#line 674 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp16_ = rygel_media_object_get_id (_tmp15_);
#line 674 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp17_ = _tmp16_;
#line 674 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp18_ = self->system_update_id;
#line 674 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp19_ = sub_tree_update;
#line 674 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp20_ = rygel_last_change_obj_mod_new (_tmp17_, (guint) _tmp18_, _tmp19_);
#line 674 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_object_unref0 (entry);
#line 674 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			entry = (RygelLastChangeEntry*) _tmp20_;
#line 677 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			break;
#line 3474 "rygel-content-directory.c"
		}
#line 664 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		case RYGEL_OBJECT_EVENT_TYPE_DELETED:
#line 3478 "rygel-content-directory.c"
		{
			RygelMediaObject* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			guint32 _tmp24_ = 0U;
			gboolean _tmp25_ = FALSE;
			RygelLastChangeObjDel* _tmp26_ = NULL;
#line 680 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp21_ = object;
#line 680 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp22_ = rygel_media_object_get_id (_tmp21_);
#line 680 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp23_ = _tmp22_;
#line 680 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp24_ = self->system_update_id;
#line 680 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp25_ = sub_tree_update;
#line 680 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp26_ = rygel_last_change_obj_del_new (_tmp23_, (guint) _tmp24_, _tmp25_);
#line 680 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_object_unref0 (entry);
#line 680 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			entry = (RygelLastChangeEntry*) _tmp26_;
#line 683 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			break;
#line 3504 "rygel-content-directory.c"
		}
		default:
		{
#line 686 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			g_assert_not_reached ();
#line 3510 "rygel-content-directory.c"
		}
	}
#line 689 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp27_ = self->priv->last_change;
#line 689 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp28_ = entry;
#line 689 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_last_change_add_event (_tmp27_, _tmp28_);
#line 658 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (entry);
#line 3521 "rygel-content-directory.c"
}


static void rygel_content_directory_get_service_reset_token_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GUPnPServiceAction* _tmp2_ = NULL;
#line 693 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 693 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 693 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 695 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 695 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = self->priv->service_reset_token;
#line 695 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_action_set (_tmp0_, "ResetToken", G_TYPE_STRING, _tmp1_, NULL);
#line 696 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = action;
#line 696 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_action_return (_tmp2_);
#line 3545 "rygel-content-directory.c"
}


static void rygel_content_directory_query_service_reset_token (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	const gchar* _tmp0_ = NULL;
#line 699 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 699 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 699 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (variable != NULL);
#line 699 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (value != NULL);
#line 702 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_init (value, G_TYPE_STRING);
#line 703 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = self->priv->service_reset_token;
#line 703 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_set_string (value, _tmp0_);
#line 3565 "rygel-content-directory.c"
}


static void rygel_content_directory_service_reset_data_free (gpointer _data) {
	RygelContentDirectoryServiceResetData* _data_;
	_data_ = _data;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (_data_->self);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_slice_free (RygelContentDirectoryServiceResetData, _data_);
#line 3576 "rygel-content-directory.c"
}


static void rygel_content_directory_service_reset (RygelContentDirectory* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelContentDirectoryServiceResetData* _data_;
	RygelContentDirectory* _tmp0_ = NULL;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_ = g_slice_new0 (RygelContentDirectoryServiceResetData);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_content_directory_service_reset);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_content_directory_service_reset_data_free);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->self = _tmp0_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_service_reset_co (_data_);
#line 3595 "rygel-content-directory.c"
}


static void rygel_content_directory_service_reset_finish (RygelContentDirectory* self, GAsyncResult* _res_) {
	RygelContentDirectoryServiceResetData* _data_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 3603 "rygel-content-directory.c"
}


static void rygel_content_directory_service_reset_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelContentDirectoryServiceResetData* _data_;
#line 730 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_ = _user_data_;
#line 730 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_source_object_ = source_object;
#line 730 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_res_ = _res_;
#line 730 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_service_reset_co (_data_);
#line 3617 "rygel-content-directory.c"
}


static gboolean rygel_content_directory_service_reset_co (RygelContentDirectoryServiceResetData* _data_) {
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	switch (_data_->_state_) {
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		case 0:
#line 3626 "rygel-content-directory.c"
		goto _state_0;
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		case 1:
#line 3630 "rygel-content-directory.c"
		goto _state_1;
		default:
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_assert_not_reached ();
#line 3635 "rygel-content-directory.c"
	}
	_state_0:
#line 707 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_debug ("rygel-content-directory.vala:707: SystemUpdateID overflow, initiating " \
"service reset procedure");
#line 709 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp0_ = NULL;
#line 709 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_object_get ((GUPnPService*) _data_->self, "root-device", &_data_->_tmp0_, NULL);
#line 709 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp1_ = NULL;
#line 709 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp1_ = _data_->_tmp0_;
#line 709 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp2_ = NULL;
#line 709 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 709 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp3_ = NULL;
#line 709 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp3_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _data_->_tmp2_);
#line 709 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp4_ = NULL;
#line 709 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp4_ = _data_->_tmp3_;
#line 709 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp5_ = NULL;
#line 709 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp4_, RYGEL_TYPE_MEDIA_SERVER_PLUGIN) ? ((RygelMediaServerPlugin*) _data_->_tmp4_) : NULL);
#line 709 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp6_ = NULL;
#line 709 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp6_ = _data_->_tmp5_;
#line 709 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (_data_->_tmp2_);
#line 709 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->plugin = _data_->_tmp6_;
#line 710 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp7_ = NULL;
#line 710 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp7_ = _data_->plugin;
#line 710 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_plugin_set_active ((RygelPlugin*) _data_->_tmp7_, FALSE);
#line 711 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp8_ = NULL;
#line 711 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp8_ = uuid_get ();
#line 711 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (_data_->self->priv->service_reset_token);
#line 711 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->self->priv->service_reset_token = _data_->_tmp8_;
#line 712 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp9_ = NULL;
#line 712 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp9_ = _data_->self->root_container;
#line 712 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp9_, RYGEL_TYPE_TRACKABLE_CONTAINER)) {
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp10_ = NULL;
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp10_ = _data_->self->root_container;
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp11_ = NULL;
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp10_, RYGEL_TYPE_TRACKABLE_CONTAINER) ? ((RygelTrackableContainer*) _data_->_tmp10_) : NULL);
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->trackable = _data_->_tmp11_;
#line 714 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp12_ = NULL;
#line 714 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp12_ = _data_->trackable;
#line 714 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp13_ = NULL;
#line 714 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp13_ = _data_->self->priv->service_reset_token;
#line 714 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		rygel_trackable_container_set_service_reset_token (_data_->_tmp12_, _data_->_tmp13_);
#line 712 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (_data_->trackable);
#line 3714 "rygel-content-directory.c"
	}
#line 717 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp14_ = NULL;
#line 717 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp14_ = rygel_relational_expression_new ();
#line 717 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->expression = _data_->_tmp14_;
#line 718 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp15_ = NULL;
#line 718 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp15_ = _data_->expression;
#line 718 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp16_ = NULL;
#line 718 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp16_ = g_strdup ("upnp:objectUpdateID");
#line 718 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (((RygelSearchExpression*) _data_->_tmp15_)->operand1);
#line 718 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	((RygelSearchExpression*) _data_->_tmp15_)->operand1 = _data_->_tmp16_;
#line 719 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp17_ = NULL;
#line 719 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp17_ = _data_->expression;
#line 719 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp18_ = NULL;
#line 719 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp18_ = g_strdup ("true");
#line 719 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (((RygelSearchExpression*) _data_->_tmp17_)->operand2);
#line 719 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	((RygelSearchExpression*) _data_->_tmp17_)->operand2 = _data_->_tmp18_;
#line 720 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp19_ = NULL;
#line 720 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp19_ = _data_->expression;
#line 720 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	((RygelSearchExpression*) _data_->_tmp19_)->op = (gpointer) ((gintptr) GUPNP_SEARCH_CRITERIA_OP_EXISTS);
#line 3752 "rygel-content-directory.c"
	{
#line 723 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp20_ = NULL;
#line 723 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp20_ = _data_->self->root_container;
#line 723 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp21_ = NULL;
#line 723 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp20_, RYGEL_TYPE_SEARCHABLE_CONTAINER) ? ((RygelSearchableContainer*) _data_->_tmp20_) : NULL);
#line 723 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->root = _data_->_tmp21_;
#line 724 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp22_ = NULL;
#line 724 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp22_ = _data_->root;
#line 724 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		if (_data_->_tmp22_ == NULL) {
#line 726 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_object_unref0 (_data_->root);
#line 726 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_rygel_search_expression_unref0 (_data_->expression);
#line 726 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_object_unref0 (_data_->plugin);
#line 726 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			if (_data_->_state_ == 0) {
#line 726 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3780 "rygel-content-directory.c"
			} else {
#line 726 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 3784 "rygel-content-directory.c"
			}
#line 726 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			g_object_unref (_data_->_async_result);
#line 726 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			return FALSE;
#line 3790 "rygel-content-directory.c"
		}
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->matches = (guint32) 0;
#line 730 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp23_ = NULL;
#line 730 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp23_ = _data_->root;
#line 730 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp24_ = NULL;
#line 730 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp24_ = _data_->expression;
#line 730 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp25_ = 0U;
#line 730 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_state_ = 1;
#line 730 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		rygel_searchable_container_search (_data_->_tmp23_, (RygelSearchExpression*) _data_->_tmp24_, (guint) 0, (guint) 0, "", NULL, rygel_content_directory_service_reset_ready, _data_);
#line 730 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		return FALSE;
#line 3810 "rygel-content-directory.c"
		_state_1:
#line 730 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp26_ = NULL;
#line 730 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp26_ = rygel_searchable_container_search_finish (_data_->_tmp23_, _data_->_res_, &_data_->_tmp25_, &_data_->_inner_error_);
#line 730 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->matches = (guint32) _data_->_tmp25_;
#line 730 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->objects = _data_->_tmp26_;
#line 730 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 730 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_object_unref0 (_data_->root);
#line 3824 "rygel-content-directory.c"
			goto __catch32_g_error;
		}
#line 736 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp27_ = NULL;
#line 736 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp27_ = _data_->objects;
#line 736 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp28_ = 0;
#line 736 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp28_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp27_);
#line 736 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp29_ = 0;
#line 736 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp29_ = _data_->_tmp28_;
#line 736 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		if (_data_->_tmp29_ > 0) {
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_data_->count = (guint32) 1;
#line 3843 "rygel-content-directory.c"
			{
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_data_->_tmp30_ = NULL;
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_data_->_tmp30_ = _data_->objects;
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_data_->_tmp31_ = NULL;
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_data_->_tmp31_ = _g_object_ref0 (_data_->_tmp30_);
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_data_->_object_list = _data_->_tmp31_;
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_data_->_tmp32_ = NULL;
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_data_->_tmp32_ = _data_->_object_list;
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_data_->_tmp33_ = 0;
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_data_->_tmp33_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp32_);
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_data_->_tmp34_ = 0;
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_data_->_tmp34_ = _data_->_tmp33_;
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_data_->_object_size = _data_->_tmp34_;
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_data_->_object_index = -1;
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				while (TRUE) {
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp35_ = 0;
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp35_ = _data_->_object_index;
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_object_index = _data_->_tmp35_ + 1;
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp36_ = 0;
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp36_ = _data_->_object_index;
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp37_ = 0;
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp37_ = _data_->_object_size;
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					if (!(_data_->_tmp36_ < _data_->_tmp37_)) {
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						break;
#line 3891 "rygel-content-directory.c"
					}
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp38_ = NULL;
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp38_ = _data_->_object_list;
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp39_ = 0;
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp39_ = _data_->_object_index;
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp40_ = NULL;
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp40_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp38_, _data_->_tmp39_);
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->object = (RygelMediaObject*) _data_->_tmp40_;
#line 739 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp41_ = NULL;
#line 739 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp41_ = _data_->object;
#line 739 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp42_ = 0U;
#line 739 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp42_ = _data_->count;
#line 739 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->count = _data_->_tmp42_ + 1;
#line 739 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					rygel_media_object_set_object_update_id (_data_->_tmp41_, (guint) _data_->_tmp42_);
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp43_ = NULL;
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp43_ = _data_->object;
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp43_, RYGEL_TYPE_TRACKABLE_CONTAINER)) {
#line 742 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp44_ = NULL;
#line 742 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp44_ = _data_->object;
#line 742 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp45_ = NULL;
#line 742 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp45_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp44_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _data_->_tmp44_) : NULL);
#line 742 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->container = _data_->_tmp45_;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp46_ = NULL;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp46_ = _data_->container;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp47_ = NULL;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp47_ = _data_->container;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp48_ = 0U;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp48_ = rygel_media_object_get_object_update_id ((RygelMediaObject*) _data_->_tmp47_);
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp49_ = 0U;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp49_ = _data_->_tmp48_;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp46_->update_id = (guint32) _data_->_tmp49_;
#line 744 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp50_ = NULL;
#line 744 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp50_ = _data_->container;
#line 744 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp50_->total_deleted_child_count = (gint64) 0;
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_g_object_unref0 (_data_->container);
#line 3961 "rygel-content-directory.c"
					}
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_g_object_unref0 (_data_->object);
#line 3965 "rygel-content-directory.c"
				}
#line 738 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_g_object_unref0 (_data_->_object_list);
#line 3969 "rygel-content-directory.c"
			}
#line 749 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_data_->_tmp51_ = 0U;
#line 749 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_data_->_tmp51_ = _data_->count;
#line 749 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_data_->self->system_update_id = _data_->_tmp51_ - 1;
#line 750 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_data_->_tmp52_ = 0U;
#line 750 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_data_->_tmp52_ = _data_->self->system_update_id;
#line 750 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			g_debug ("rygel-content-directory.vala:750: New SystemUpdateID is %u", (guint) _data_->_tmp52_);
#line 3983 "rygel-content-directory.c"
		}
#line 753 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_debug ("rygel-content-directory.vala:753: Service reset procedure done, device" \
" coming up again");
#line 754 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp53_ = NULL;
#line 754 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp53_ = _data_->plugin;
#line 754 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		rygel_plugin_set_active ((RygelPlugin*) _data_->_tmp53_, TRUE);
#line 755 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp54_ = NULL;
#line 755 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp54_ = _data_->self->priv->service_reset_token;
#line 755 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_debug ("rygel-content-directory.vala:755: New service reset token is %s", _data_->_tmp54_);
#line 722 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (_data_->objects);
#line 722 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (_data_->root);
#line 4003 "rygel-content-directory.c"
	}
	goto __finally32;
	__catch32_g_error:
	{
#line 722 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 722 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_inner_error_ = NULL;
#line 756 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_warning ("rygel-content-directory.vala:756: Failed to search for objects...");
#line 722 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_error_free0 (_data_->_error_);
#line 4016 "rygel-content-directory.c"
	}
	__finally32:
#line 722 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 722 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_rygel_search_expression_unref0 (_data_->expression);
#line 722 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (_data_->plugin);
#line 722 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 722 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_clear_error (&_data_->_inner_error_);
#line 722 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		return FALSE;
#line 4031 "rygel-content-directory.c"
	}
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (_data_->plugin);
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_data_->_state_ == 0) {
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4041 "rygel-content-directory.c"
	} else {
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4045 "rygel-content-directory.c"
	}
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_object_unref (_data_->_async_result);
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return FALSE;
#line 4051 "rygel-content-directory.c"
}


static gpointer _rygel_dlna_profile_ref0 (gpointer self) {
#line 776 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return self ? rygel_dlna_profile_ref (self) : NULL;
#line 4058 "rygel-content-directory.c"
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
#line 785 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	for (i = 0; i < stack_length; i++) {
#line 785 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 785 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			return TRUE;
#line 4070 "rygel-content-directory.c"
		}
	}
#line 785 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return FALSE;
#line 4075 "rygel-content-directory.c"
}


static void rygel_content_directory_get_dlna_upload_profiles_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	gchar* upload_profiles = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	RygelMediaServerPlugin* plugin = NULL;
	GUPnPRootDevice* _tmp4_ = NULL;
	GUPnPRootDevice* _tmp5_ = NULL;
	GUPnPRootDevice* _tmp6_ = NULL;
	GUPnPResourceFactory* _tmp7_ = NULL;
	GUPnPResourceFactory* _tmp8_ = NULL;
	RygelMediaServerPlugin* _tmp9_ = NULL;
	RygelMediaServerPlugin* _tmp10_ = NULL;
	GList* profiles = NULL;
	RygelMediaServerPlugin* _tmp11_ = NULL;
	GList* _tmp12_ = NULL;
	GList* _tmp13_ = NULL;
	gchar** requested_profiles = NULL;
	const gchar* _tmp14_ = NULL;
	gchar** _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gint requested_profiles_length1 = 0;
	gint _requested_profiles_size_ = 0;
	GString* builder = NULL;
	GString* _tmp17_ = NULL;
	GList* _tmp18_ = NULL;
	GString* _tmp39_ = NULL;
	gssize _tmp40_ = 0L;
	GUPnPServiceAction* _tmp44_ = NULL;
	GString* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	GUPnPServiceAction* _tmp47_ = NULL;
#line 760 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 760 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 760 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 762 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	upload_profiles = NULL;
#line 764 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 764 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_action_get (_tmp0_, "UploadProfiles", G_TYPE_STRING, &upload_profiles, NULL);
#line 766 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = upload_profiles;
#line 766 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp1_ == NULL) {
#line 4126 "rygel-content-directory.c"
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 767 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp2_ = action;
#line 767 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp3_ = _ ("Invalid argument");
#line 767 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 769 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_free0 (upload_profiles);
#line 769 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		return;
#line 4139 "rygel-content-directory.c"
	}
#line 772 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_object_get ((GUPnPService*) self, "root-device", &_tmp4_, NULL);
#line 772 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp5_ = _tmp4_;
#line 772 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp6_ = _tmp5_;
#line 772 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp7_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp6_);
#line 772 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp8_ = _tmp7_;
#line 772 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, RYGEL_TYPE_MEDIA_SERVER_PLUGIN) ? ((RygelMediaServerPlugin*) _tmp8_) : NULL);
#line 772 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp10_ = _tmp9_;
#line 772 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (_tmp6_);
#line 772 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	plugin = _tmp10_;
#line 773 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp11_ = plugin;
#line 773 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp12_ = rygel_media_server_plugin_get_upload_profiles (_tmp11_);
#line 773 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp13_ = _tmp12_;
#line 773 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	profiles = _tmp13_;
#line 774 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp14_ = upload_profiles;
#line 774 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp16_ = _tmp15_ = g_strsplit (_tmp14_, ",", 0);
#line 774 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	requested_profiles = _tmp16_;
#line 774 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	requested_profiles_length1 = _vala_array_length (_tmp15_);
#line 774 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_requested_profiles_size_ = requested_profiles_length1;
#line 775 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp17_ = g_string_new ("");
#line 775 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	builder = _tmp17_;
#line 776 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp18_ = profiles;
#line 4183 "rygel-content-directory.c"
	{
		GList* profile_collection = NULL;
		GList* profile_it = NULL;
#line 776 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		profile_collection = _tmp18_;
#line 776 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
#line 4191 "rygel-content-directory.c"
			RygelDLNAProfile* _tmp19_ = NULL;
			RygelDLNAProfile* profile = NULL;
#line 776 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp19_ = _rygel_dlna_profile_ref0 ((RygelDLNAProfile*) profile_it->data);
#line 776 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			profile = _tmp19_;
#line 4198 "rygel-content-directory.c"
			{
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				RygelDLNAProfile* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				gboolean _tmp24_ = FALSE;
				gboolean _tmp30_ = FALSE;
				gchar** _tmp31_ = NULL;
				gint _tmp31__length1 = 0;
#line 778 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp22_ = profile;
#line 778 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp23_ = _tmp22_->name;
#line 778 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp24_ = g_str_has_suffix (_tmp23_, "_ICO");
#line 778 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				if (_tmp24_) {
#line 778 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp21_ = TRUE;
#line 4218 "rygel-content-directory.c"
				} else {
					RygelDLNAProfile* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
					gboolean _tmp27_ = FALSE;
#line 779 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp25_ = profile;
#line 779 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp26_ = _tmp25_->name;
#line 779 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp27_ = g_str_has_suffix (_tmp26_, "_TN");
#line 779 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp21_ = _tmp27_;
#line 4231 "rygel-content-directory.c"
				}
#line 778 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				if (_tmp21_) {
#line 778 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp20_ = TRUE;
#line 4237 "rygel-content-directory.c"
				} else {
					RygelDLNAProfile* _tmp28_ = NULL;
					const gchar* _tmp29_ = NULL;
#line 780 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp28_ = profile;
#line 780 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp29_ = _tmp28_->name;
#line 780 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp20_ = g_strcmp0 (_tmp29_, "DIDL_S") == 0;
#line 4247 "rygel-content-directory.c"
				}
#line 778 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				if (_tmp20_) {
#line 781 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_rygel_dlna_profile_unref0 (profile);
#line 781 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					continue;
#line 4255 "rygel-content-directory.c"
				}
#line 784 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp31_ = requested_profiles;
#line 784 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp31__length1 = requested_profiles_length1;
#line 784 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				if (_tmp31__length1 == 0) {
#line 784 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp30_ = TRUE;
#line 4265 "rygel-content-directory.c"
				} else {
					RygelDLNAProfile* _tmp32_ = NULL;
					const gchar* _tmp33_ = NULL;
					gchar** _tmp34_ = NULL;
					gint _tmp34__length1 = 0;
#line 785 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp32_ = profile;
#line 785 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp33_ = _tmp32_->name;
#line 785 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp34_ = requested_profiles;
#line 785 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp34__length1 = requested_profiles_length1;
#line 785 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp30_ = _vala_string_array_contains (_tmp34_, _tmp34__length1, _tmp33_);
#line 4281 "rygel-content-directory.c"
				}
#line 784 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				if (_tmp30_) {
#line 4285 "rygel-content-directory.c"
					GString* _tmp35_ = NULL;
					RygelDLNAProfile* _tmp36_ = NULL;
					const gchar* _tmp37_ = NULL;
					GString* _tmp38_ = NULL;
#line 786 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp35_ = builder;
#line 786 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp36_ = profile;
#line 786 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp37_ = _tmp36_->name;
#line 786 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					g_string_append (_tmp35_, _tmp37_);
#line 787 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp38_ = builder;
#line 787 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					g_string_append (_tmp38_, ",");
#line 4302 "rygel-content-directory.c"
				}
#line 776 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_rygel_dlna_profile_unref0 (profile);
#line 4306 "rygel-content-directory.c"
			}
		}
	}
#line 791 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp39_ = builder;
#line 791 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp40_ = _tmp39_->len;
#line 791 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp40_ > ((gssize) 0)) {
#line 4316 "rygel-content-directory.c"
		GString* _tmp41_ = NULL;
		GString* _tmp42_ = NULL;
		gssize _tmp43_ = 0L;
#line 792 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp41_ = builder;
#line 792 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp42_ = builder;
#line 792 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp43_ = _tmp42_->len;
#line 792 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_string_truncate (_tmp41_, (gsize) (_tmp43_ - 1));
#line 4328 "rygel-content-directory.c"
	}
#line 795 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp44_ = action;
#line 795 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp45_ = builder;
#line 795 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp46_ = _tmp45_->str;
#line 795 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_action_set (_tmp44_, "SupportedUploadProfiles", G_TYPE_STRING, _tmp46_, NULL);
#line 796 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp47_ = action;
#line 796 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_action_return (_tmp47_);
#line 760 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_string_free0 (builder);
#line 760 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	requested_profiles = (_vala_array_free (requested_profiles, requested_profiles_length1, (GDestroyNotify) g_free), NULL);
#line 760 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (plugin);
#line 760 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (upload_profiles);
#line 4350 "rygel-content-directory.c"
}


RygelContentDirectory* rygel_content_directory_construct (GType object_type) {
	RygelContentDirectory * self = NULL;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self = (RygelContentDirectory*) g_object_new (object_type, NULL);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return self;
#line 4360 "rygel-content-directory.c"
}


RygelContentDirectory* rygel_content_directory_new (void) {
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return rygel_content_directory_construct (RYGEL_TYPE_CONTENT_DIRECTORY);
#line 4367 "rygel-content-directory.c"
}


static void rygel_content_directory_class_init (RygelContentDirectoryClass * klass) {
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_parent_class = g_type_class_peek_parent (klass);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_type_class_add_private (klass, sizeof (RygelContentDirectoryPrivate));
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	((GObjectClass *) klass)->constructed = rygel_content_directory_real_constructed;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_content_directory_finalize;
#line 4380 "rygel-content-directory.c"
}


static void rygel_content_directory_instance_init (RygelContentDirectory * self) {
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self->priv = RYGEL_CONTENT_DIRECTORY_GET_PRIVATE (self);
#line 4387 "rygel-content-directory.c"
}


static void rygel_content_directory_finalize (GObject* obj) {
	RygelContentDirectory * self;
	GCancellable* _tmp0_ = NULL;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory);
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = self->cancellable;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_cancellable_cancel (_tmp0_);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (self->feature_list);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (self->http_server);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (self->root_container);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (self->priv->updated_containers);
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (self->priv->active_imports);
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (self->priv->finished_imports);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (self->cancellable);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (self->priv->last_change);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (self->priv->service_reset_token);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	G_OBJECT_CLASS (rygel_content_directory_parent_class)->finalize (obj);
#line 4420 "rygel-content-directory.c"
}


/**
 * Basic implementation of UPnP ContentDirectory service version 2. Most often
 * plugins will provide a child of this class. The inheriting classes should
 * override create_root_container method.
 */
GType rygel_content_directory_get_type (void) {
	static volatile gsize rygel_content_directory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_content_directory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelContentDirectoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_content_directory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelContentDirectory), 0, (GInstanceInitFunc) rygel_content_directory_instance_init, NULL };
		GType rygel_content_directory_type_id;
		rygel_content_directory_type_id = g_type_register_static (gupnp_service_get_type (), "RygelContentDirectory", &g_define_type_info, 0);
		g_once_init_leave (&rygel_content_directory_type_id__volatile, rygel_content_directory_type_id);
	}
	return rygel_content_directory_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



