/* rygel-media-engine.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-media-engine.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_MEDIA_ENGINE (rygel_media_engine_get_type ())
#define RYGEL_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngine))
#define RYGEL_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))
#define RYGEL_IS_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_IS_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_MEDIA_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))

typedef struct _RygelMediaEngine RygelMediaEngine;
typedef struct _RygelMediaEngineClass RygelMediaEngineClass;
typedef struct _RygelMediaEnginePrivate RygelMediaEnginePrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;

#define RYGEL_TYPE_ENGINE_LOADER (rygel_engine_loader_get_type ())
#define RYGEL_ENGINE_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ENGINE_LOADER, RygelEngineLoader))
#define RYGEL_ENGINE_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ENGINE_LOADER, RygelEngineLoaderClass))
#define RYGEL_IS_ENGINE_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ENGINE_LOADER))
#define RYGEL_IS_ENGINE_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ENGINE_LOADER))
#define RYGEL_ENGINE_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ENGINE_LOADER, RygelEngineLoaderClass))

typedef struct _RygelEngineLoader RygelEngineLoader;
typedef struct _RygelEngineLoaderClass RygelEngineLoaderClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

typedef enum  {
	RYGEL_MEDIA_ENGINE_ERROR_NOT_FOUND
} RygelMediaEngineError;
#define RYGEL_MEDIA_ENGINE_ERROR rygel_media_engine_error_quark ()
struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	GeeList* (*preroll) (RygelDataSource* self, RygelHTTPSeekRequest* seek, RygelPlaySpeedRequest* playspeed, GError** error);
	void (*start) (RygelDataSource* self, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelMediaEngine {
	GObject parent_instance;
	RygelMediaEnginePrivate * priv;
};

struct _RygelMediaEngineClass {
	GObjectClass parent_class;
	GList* (*get_dlna_profiles) (RygelMediaEngine* self);
	void (*get_resources_for_item) (RygelMediaEngine* self, RygelMediaObject* item, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeList* (*get_resources_for_item_finish) (RygelMediaEngine* self, GAsyncResult* _res_);
	RygelDataSource* (*create_data_source_for_resource) (RygelMediaEngine* self, RygelMediaObject* item, RygelMediaResource* resource, GError** error);
	RygelDataSource* (*create_data_source_for_uri) (RygelMediaEngine* self, const gchar* uri, GError** error);
};


static gpointer rygel_media_engine_parent_class = NULL;
static RygelMediaEngine* rygel_media_engine_instance;
static RygelMediaEngine* rygel_media_engine_instance = NULL;

GQuark rygel_media_engine_error_quark (void);
GType rygel_media_engine_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_ENGINE_DUMMY_PROPERTY
};
void rygel_media_engine_init (GError** error);
GType rygel_engine_loader_get_type (void) G_GNUC_CONST;
RygelEngineLoader* rygel_engine_loader_new (void);
RygelEngineLoader* rygel_engine_loader_construct (GType object_type);
RygelMediaEngine* rygel_engine_loader_load_engine (RygelEngineLoader* self);
RygelMediaEngine* rygel_media_engine_get_default (void);
GList* rygel_media_engine_get_dlna_profiles (RygelMediaEngine* self);
static GList* rygel_media_engine_real_get_dlna_profiles (RygelMediaEngine* self);
void rygel_media_engine_get_resources_for_item (RygelMediaEngine* self, RygelMediaObject* item, GAsyncReadyCallback _callback_, gpointer _user_data_);
GeeList* rygel_media_engine_get_resources_for_item_finish (RygelMediaEngine* self, GAsyncResult* _res_);
RygelDataSource* rygel_media_engine_create_data_source_for_resource (RygelMediaEngine* self, RygelMediaObject* item, RygelMediaResource* resource, GError** error);
static RygelDataSource* rygel_media_engine_real_create_data_source_for_resource (RygelMediaEngine* self, RygelMediaObject* item, RygelMediaResource* resource, GError** error);
RygelDataSource* rygel_media_engine_create_data_source_for_uri (RygelMediaEngine* self, const gchar* uri, GError** error);
static RygelDataSource* rygel_media_engine_real_create_data_source_for_uri (RygelMediaEngine* self, const gchar* uri, GError** error);
RygelMediaEngine* rygel_media_engine_construct (GType object_type);
static void rygel_media_engine_finalize (GObject* obj);


GQuark rygel_media_engine_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_engine_error-quark");
}


void rygel_media_engine_init (GError** error) {
	RygelEngineLoader* loader = NULL;
	RygelEngineLoader* _tmp0_ = NULL;
	RygelEngineLoader* _tmp1_ = NULL;
	RygelMediaEngine* _tmp2_ = NULL;
	RygelMediaEngine* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	_tmp0_ = rygel_engine_loader_new ();
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	loader = _tmp0_;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	_tmp1_ = loader;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	_tmp2_ = rygel_engine_loader_load_engine (_tmp1_);
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	_g_object_unref0 (rygel_media_engine_instance);
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	rygel_media_engine_instance = _tmp2_;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	_tmp3_ = rygel_media_engine_instance;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	if (_tmp3_ == NULL) {
#line 208 "rygel-media-engine.c"
		const gchar* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
		_tmp4_ = _ ("No media engine found.");
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
		_tmp5_ = g_error_new_literal (RYGEL_MEDIA_ENGINE_ERROR, RYGEL_MEDIA_ENGINE_ERROR_NOT_FOUND, _tmp4_);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
		_inner_error_ = _tmp5_;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
		g_propagate_error (error, _inner_error_);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
		_g_object_unref0 (loader);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
		return;
#line 223 "rygel-media-engine.c"
	}
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	_g_object_unref0 (loader);
#line 227 "rygel-media-engine.c"
}


/**
     * Get the singleton instance of the currently used media engine.
     *
     * @return An instance of a concrete #RygelMediaEngine implementation.
     */
static gpointer _g_object_ref0 (gpointer self) {
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	return self ? g_object_ref (self) : NULL;
#line 239 "rygel-media-engine.c"
}


RygelMediaEngine* rygel_media_engine_get_default (void) {
	RygelMediaEngine* result = NULL;
	RygelMediaEngine* _tmp0_ = NULL;
	RygelMediaEngine* _tmp2_ = NULL;
	RygelMediaEngine* _tmp3_ = NULL;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	_tmp0_ = rygel_media_engine_instance;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	if (_tmp0_ == NULL) {
#line 252 "rygel-media-engine.c"
		const gchar* _tmp1_ = NULL;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
		_tmp1_ = _ ("MediaEngine.init was not called. Cannot continue.");
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
		g_error ("rygel-media-engine.vala:73: %s", _tmp1_);
#line 258 "rygel-media-engine.c"
	}
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	_tmp2_ = rygel_media_engine_instance;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	result = _tmp3_;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	return result;
#line 268 "rygel-media-engine.c"
}


/**
     * Get a list of the DLNA profiles that the media engine can stream.
     *
     * This information is needed to implement DLNA's
     * ConnectionManager.GetProtocolInfo call and to determine whether Rygel
     * can accept an uploaded file.
     *
     * @return A list of #RygelDLNAProfile<!-- -->s
     */
static GList* rygel_media_engine_real_get_dlna_profiles (RygelMediaEngine* self) {
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	g_critical ("Type `%s' does not implement abstract method `rygel_media_engine_get_dlna_profiles'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	return NULL;
#line 286 "rygel-media-engine.c"
}


GList* rygel_media_engine_get_dlna_profiles (RygelMediaEngine* self) {
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	return RYGEL_MEDIA_ENGINE_GET_CLASS (self)->get_dlna_profiles (self);
#line 295 "rygel-media-engine.c"
}


void rygel_media_engine_get_resources_for_item (RygelMediaEngine* self, RygelMediaObject* item, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	RYGEL_MEDIA_ENGINE_GET_CLASS (self)->get_resources_for_item (self, item, _callback_, _user_data_);
#line 302 "rygel-media-engine.c"
}


GeeList* rygel_media_engine_get_resources_for_item_finish (RygelMediaEngine* self, GAsyncResult* _res_) {
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	return RYGEL_MEDIA_ENGINE_GET_CLASS (self)->get_resources_for_item_finish (self, _res_);
#line 309 "rygel-media-engine.c"
}


/**
     * Get a #DataSource for given #MediaResource representation of the #MediaObject.
     *
     * @param item The #MediaObject to create the #DataSource for
     * @param resource The specific resource to create the #DataSource for
     *
     * @return A #DataSource representing the given item resource
     */
static RygelDataSource* rygel_media_engine_real_create_data_source_for_resource (RygelMediaEngine* self, RygelMediaObject* item, RygelMediaResource* resource, GError** error) {
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	g_critical ("Type `%s' does not implement abstract method `rygel_media_engine_create_data_source_for_resource'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	return NULL;
#line 326 "rygel-media-engine.c"
}


RygelDataSource* rygel_media_engine_create_data_source_for_resource (RygelMediaEngine* self, RygelMediaObject* item, RygelMediaResource* resource, GError** error) {
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	return RYGEL_MEDIA_ENGINE_GET_CLASS (self)->create_data_source_for_resource (self, item, resource, error);
#line 335 "rygel-media-engine.c"
}


/**
     * Get a #DataSource for the URI.
     *
     * @param uri to create the #DataSource for.
     * @return A #DataSource representing the uri
     */
static RygelDataSource* rygel_media_engine_real_create_data_source_for_uri (RygelMediaEngine* self, const gchar* uri, GError** error) {
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	g_critical ("Type `%s' does not implement abstract method `rygel_media_engine_create_data_source_for_uri'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	return NULL;
#line 350 "rygel-media-engine.c"
}


RygelDataSource* rygel_media_engine_create_data_source_for_uri (RygelMediaEngine* self, const gchar* uri, GError** error) {
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	return RYGEL_MEDIA_ENGINE_GET_CLASS (self)->create_data_source_for_uri (self, uri, error);
#line 359 "rygel-media-engine.c"
}


RygelMediaEngine* rygel_media_engine_construct (GType object_type) {
	RygelMediaEngine * self = NULL;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	self = (RygelMediaEngine*) g_object_new (object_type, NULL);
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	return self;
#line 369 "rygel-media-engine.c"
}


static void rygel_media_engine_class_init (RygelMediaEngineClass * klass) {
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	rygel_media_engine_parent_class = g_type_class_peek_parent (klass);
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	((RygelMediaEngineClass *) klass)->get_dlna_profiles = rygel_media_engine_real_get_dlna_profiles;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	((RygelMediaEngineClass *) klass)->create_data_source_for_resource = rygel_media_engine_real_create_data_source_for_resource;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	((RygelMediaEngineClass *) klass)->create_data_source_for_uri = rygel_media_engine_real_create_data_source_for_uri;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_engine_finalize;
#line 384 "rygel-media-engine.c"
	/**
	     * Signaled when one or more #MediaResources<!-- -->s associated with a MediaObject changes.
	     * #get_resources_for_item should be called in response to this signal to retrieve the
	     * updated list of MediaResources for the associated MediaObject.
	     *
	     * @param media_object_uri is the uri associated with a MediaObject.=
	     */
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	g_signal_new ("resource_changed", RYGEL_TYPE_MEDIA_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 394 "rygel-media-engine.c"
}


static void rygel_media_engine_instance_init (RygelMediaEngine * self) {
}


static void rygel_media_engine_finalize (GObject* obj) {
	RygelMediaEngine * self;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngine);
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-media-engine.vala"
	G_OBJECT_CLASS (rygel_media_engine_parent_class)->finalize (obj);
#line 408 "rygel-media-engine.c"
}


/**
 * This is the base class for media engines that contain knowledge about 
 * the streaming and transformational capabilites of the media library in use.
 *
 * Media engines express what representations of a MediaObject they can
 * produce by returning MediaResource objects which will, in turn, be
 * used to express to endpoints representations can be streamed from
 * the MediaServer. These representations may include transformations,
 * time-scaled representations, and/or encrypted representations.
 *
 * See, for instance, Rygel's built-in "gstreamer" and "simple" media engines,
 * or the external rygel-gst-0-10-media-engine module.
 *
 * The actual media engine used by Rygel at runtime is specified
 * by the media-engine configuration key.
 * For instance, in rygel.conf:
 * media-engine=librygel-media-engine-gst.so
 *
 * Media engines should also derive their own #RygelDataSource,
 * returning an instance of it from create_data_source().
 *
 * See the
 * <link linkend="implementing-media-engines">Implementing Media Engines</link> section.
 */
GType rygel_media_engine_get_type (void) {
	static volatile gsize rygel_media_engine_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaEngine), 0, (GInstanceInitFunc) rygel_media_engine_instance_init, NULL };
		GType rygel_media_engine_type_id;
		rygel_media_engine_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaEngine", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_engine_type_id__volatile, rygel_media_engine_type_id);
	}
	return rygel_media_engine_type_id__volatile;
}



