/* rygel-media-object.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-media-object.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Doug Galligan <doug@sentosatech.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <libxml/tree.h>
#include <rygel-core.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelMediaObjectGetWritableData RygelMediaObjectGetWritableData;
typedef struct _RygelMediaObjectGetWritablesData RygelMediaObjectGetWritablesData;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_MEDIA_FILE_ITEM (rygel_media_file_item_get_type ())
#define RYGEL_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem))
#define RYGEL_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))
#define RYGEL_IS_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_IS_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_MEDIA_FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))

typedef struct _RygelMediaFileItem RygelMediaFileItem;
typedef struct _RygelMediaFileItemClass RygelMediaFileItemClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define RYGEL_TYPE_SERIALIZER_TYPE (rygel_serializer_type_get_type ())

#define RYGEL_TYPE_UPDATABLE_OBJECT (rygel_updatable_object_get_type ())
#define RYGEL_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_UPDATABLE_OBJECT, RygelUpdatableObject))
#define RYGEL_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_UPDATABLE_OBJECT))
#define RYGEL_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_UPDATABLE_OBJECT, RygelUpdatableObjectIface))

typedef struct _RygelUpdatableObject RygelUpdatableObject;
typedef struct _RygelUpdatableObjectIface RygelUpdatableObjectIface;
typedef struct _RygelMediaObjectApplyFragmentsData RygelMediaObjectApplyFragmentsData;
typedef struct _RygelMediaObjectCheckWritableData RygelMediaObjectCheckWritableData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	GeeList* (*preroll) (RygelDataSource* self, RygelHTTPSeekRequest* seek, RygelPlaySpeedRequest* playspeed, GError** error);
	void (*start) (RygelDataSource* self, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	void (*add_uri) (RygelMediaObject* self, const gchar* uri);
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	RygelDataSource* (*create_stream_source_for_resource) (RygelMediaObject* self, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaObjectPrivate {
	gchar* _id;
	gchar* _ref_id;
	gchar* _upnp_class;
	gchar* _date;
	gchar* _creator;
	guint64 _modified;
	guint _object_update_id;
	gchar* _artist;
	gchar* _genre;
	GeeArrayList* uris;
	GeeList* media_resources;
	RygelMediaContainer* _parent_ref;
	gchar* _title;
};

struct _RygelMediaObjectGetWritableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaObject* self;
	GCancellable* cancellable;
	GFile* result;
	GeeArrayList* _uri_list;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _uri_size;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _uri_index;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gchar* uri;
	GeeArrayList* _tmp8_;
	gint _tmp9_;
	gpointer _tmp10_;
	GFile* file;
	const gchar* _tmp11_;
	GFile* _tmp12_;
	gboolean _tmp13_;
	GFile* _tmp14_;
	GCancellable* _tmp15_;
	gboolean _tmp16_;
	GError * _inner_error_;
};

struct _RygelMediaObjectGetWritablesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaObject* self;
	GCancellable* cancellable;
	GeeArrayList* result;
	GeeArrayList* writables;
	GeeArrayList* _tmp0_;
	GeeArrayList* _uri_list;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _uri_size;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _uri_index;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar* uri;
	GeeArrayList* _tmp9_;
	gint _tmp10_;
	gpointer _tmp11_;
	GFile* file;
	const gchar* _tmp12_;
	GFile* _tmp13_;
	gboolean _tmp14_;
	GFile* _tmp15_;
	GCancellable* _tmp16_;
	gboolean _tmp17_;
	GeeArrayList* _tmp18_;
	GFile* _tmp19_;
	GError * _inner_error_;
};

struct _Block4Data {
	int _ref_count_;
	gchar* replaced_string;
};

typedef enum  {
	RYGEL_SERIALIZER_TYPE_GENERIC_DIDL,
	RYGEL_SERIALIZER_TYPE_DIDL_S,
	RYGEL_SERIALIZER_TYPE_M3UEXT
} RygelSerializerType;

struct _RygelUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit) (RygelUpdatableObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_finish) (RygelUpdatableObject* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaObjectApplyFragmentsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaObject* self;
	GeeLinkedList* current_fragments;
	GeeLinkedList* new_fragments;
	RygelHTTPServer* http_server;
	GUPnPDIDLLiteFragmentResult result;
	GUPnPDIDLLiteFragmentResult _result_;
	RygelSerializer* writer;
	RygelSerializer* _tmp0_;
	GUPnPDIDLLiteObject* didl_object;
	RygelSerializer* _tmp1_;
	RygelHTTPServer* _tmp2_;
	GUPnPDIDLLiteObject* _tmp3_;
	GUPnPDIDLLiteObject* _tmp4_;
	xmlNode* _tmp5_;
	xmlNode* _tmp6_;
	GUPnPDIDLLiteObject* _tmp7_;
	xmlNs* _tmp8_;
	xmlNs* _tmp9_;
	GUPnPDIDLLiteObject* _tmp10_;
	GeeLinkedList* _tmp11_;
	gint _tmp12_;
	gpointer* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	GeeLinkedList* _tmp15_;
	gint _tmp16_;
	gpointer* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	GUPnPDIDLLiteFragmentResult _tmp19_;
	GUPnPDIDLLiteFragmentResult _tmp20_;
	GUPnPDIDLLiteObject* _tmp21_;
	GError* e;
	GError * _inner_error_;
};

struct _RygelMediaObjectCheckWritableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaObject* self;
	GFile* file;
	GCancellable* cancellable;
	gboolean result;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GFile* _tmp5_;
	gboolean _tmp6_;
	GFileInfo* info;
	GFile* _tmp7_;
	GCancellable* _tmp8_;
	GFileInfo* _tmp9_;
	GFileInfo* _tmp10_;
	gboolean _tmp11_;
	GError* _error_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_MEDIA_ITEM_ERROR_BAD_URI
} RygelMediaItemError;
#define RYGEL_MEDIA_ITEM_ERROR rygel_media_item_error_quark ()

static gpointer rygel_media_object_parent_class = NULL;
static GRegex* rygel_media_object_real_name_regex;
static GRegex* rygel_media_object_real_name_regex = NULL;
static GRegex* rygel_media_object_user_name_regex;
static GRegex* rygel_media_object_user_name_regex = NULL;
static GRegex* rygel_media_object_host_name_regex;
static GRegex* rygel_media_object_host_name_regex = NULL;
static GRegex* rygel_media_object_pretty_name_regex;
static GRegex* rygel_media_object_pretty_name_regex = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_OBJECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectPrivate))
enum  {
	RYGEL_MEDIA_OBJECT_DUMMY_PROPERTY,
	RYGEL_MEDIA_OBJECT_ID,
	RYGEL_MEDIA_OBJECT_REF_ID,
	RYGEL_MEDIA_OBJECT_UPNP_CLASS,
	RYGEL_MEDIA_OBJECT_DATE,
	RYGEL_MEDIA_OBJECT_CREATOR,
	RYGEL_MEDIA_OBJECT_MODIFIED,
	RYGEL_MEDIA_OBJECT_OBJECT_UPDATE_ID,
	RYGEL_MEDIA_OBJECT_ARTIST,
	RYGEL_MEDIA_OBJECT_GENRE,
	RYGEL_MEDIA_OBJECT_PARENT,
	RYGEL_MEDIA_OBJECT_PARENT_REF,
	RYGEL_MEDIA_OBJECT_TITLE,
	RYGEL_MEDIA_OBJECT_OCM_FLAGS,
	RYGEL_MEDIA_OBJECT_RESTRICTED
};
GeeList* rygel_media_object_get_uris (RygelMediaObject* self);
gchar* rygel_media_object_get_primary_uri (RygelMediaObject* self);
void rygel_media_object_add_uri (RygelMediaObject* self, const gchar* uri);
static void rygel_media_object_real_add_uri (RygelMediaObject* self, const gchar* uri);
static void rygel_media_object_real_constructed (GObject* base);
static void rygel_media_object_get_writable_data_free (gpointer _data);
void rygel_media_object_get_writable (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFile* rygel_media_object_get_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_media_object_get_writable_co (RygelMediaObjectGetWritableData* _data_);
static void rygel_media_object_check_writable (RygelMediaObject* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_object_check_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static void rygel_media_object_get_writable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_media_object_get_writables_data_free (gpointer _data);
void rygel_media_object_get_writables (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GeeArrayList* rygel_media_object_get_writables_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_media_object_get_writables_co (RygelMediaObjectGetWritablesData* _data_);
static void rygel_media_object_get_writables_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GeeList* rygel_media_object_get_resource_list (RygelMediaObject* self);
RygelMediaResource* rygel_media_object_get_resource_by_name (RygelMediaObject* self, const gchar* resource_name);
gchar* rygel_media_resource_get_name (RygelMediaResource* self);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
static GUPnPDIDLLiteObject* rygel_media_object_real_serialize (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
void rygel_media_object_serialize_resource_list (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object, RygelHTTPServer* http_server, GError** error);
GHashTable* rygel_http_server_get_replacements (RygelHTTPServer* self);
const gchar* rygel_media_resource_get_uri (RygelMediaResource* self);
gchar* rygel_http_server_create_uri_for_object (RygelHTTPServer* self, RygelMediaObject* object, gint thumbnail_index, gint subtitle_index, const gchar* resource_name);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_file_item_get_type (void) G_GNUC_CONST;
gboolean rygel_media_file_item_get_place_holder (RygelMediaFileItem* self);
void rygel_media_resource_set_import_uri (RygelMediaResource* self, const gchar* value);
void rygel_media_resource_set_uri (RygelMediaResource* self, const gchar* value);
void rygel_http_server_set_resource_delivery_options (RygelHTTPServer* self, RygelMediaResource* res);
GUPnPDIDLLiteResource* rygel_media_resource_serialize (RygelMediaResource* self, GUPnPDIDLLiteResource* didl_resource, GHashTable* replacements);
gchar* rygel_media_object_get_protocol_for_uri (RygelMediaObject* self, const gchar* uri, GError** error);
gboolean rygel_http_server_is_local (RygelHTTPServer* self);
gchar* rygel_media_object_apply_replacements (GHashTable* replacement_pairs, const gchar* source_string);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda4_ (Block4Data* _data4_, const gchar* search_string, const gchar* replacement);
static void ___lambda4__gh_func (gconstpointer key, gconstpointer value, gpointer self);
RygelDataSource* rygel_media_object_create_stream_source_for_resource (RygelMediaObject* self, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error);
static RygelDataSource* rygel_media_object_real_create_stream_source_for_resource (RygelMediaObject* self, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error);
void rygel_media_object_apply_didl_lite (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
static void rygel_media_object_real_apply_didl_lite (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
void rygel_media_object_set_title (RygelMediaObject* self, const gchar* value);
static gchar* rygel_media_object_get_first (RygelMediaObject* self, GList* contributors);
void rygel_media_object_set_artist (RygelMediaObject* self, const gchar* value);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void rygel_media_object_set_genre (RygelMediaObject* self, const gchar* value);
static void rygel_media_object_clean_node (RygelMediaObject* self, xmlNode* node, xmlNs* ns);
static void rygel_media_object_apply_fragments_data_free (gpointer _data);
void rygel_media_object_apply_fragments (RygelMediaObject* self, GeeLinkedList* current_fragments, GeeLinkedList* new_fragments, RygelHTTPServer* http_server, GAsyncReadyCallback _callback_, gpointer _user_data_);
GUPnPDIDLLiteFragmentResult rygel_media_object_apply_fragments_finish (RygelMediaObject* self, GAsyncResult* _res_);
static gboolean rygel_media_object_apply_fragments_co (RygelMediaObjectApplyFragmentsData* _data_);
GType rygel_serializer_type_get_type (void) G_GNUC_CONST;
RygelSerializer* rygel_serializer_new (RygelSerializerType type);
RygelSerializer* rygel_serializer_construct (GType object_type, RygelSerializerType type);
GType rygel_updatable_object_get_type (void) G_GNUC_CONST;
void rygel_updatable_object_commit (RygelUpdatableObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_updatable_object_commit_finish (RygelUpdatableObject* self, GAsyncResult* _res_, GError** error);
static void rygel_media_object_apply_fragments_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
static gint rygel_media_object_real_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
gint rygel_media_object_compare_string_props (RygelMediaObject* self, const gchar* prop1, const gchar* prop2);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
RygelMediaContainer* rygel_media_object_get_parent (RygelMediaObject* self);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
const gchar* rygel_media_object_get_upnp_class (RygelMediaObject* self);
const gchar* rygel_media_object_get_artist (RygelMediaObject* self);
const gchar* rygel_media_object_get_genre (RygelMediaObject* self);
const gchar* rygel_media_object_get_creator (RygelMediaObject* self);
static gint rygel_media_object_compare_by_date (RygelMediaObject* self, RygelMediaObject* object);
gint rygel_media_object_compare_int_props (RygelMediaObject* self, gint prop1, gint prop2);
static void rygel_media_object_check_writable_data_free (gpointer _data);
static gboolean rygel_media_object_check_writable_co (RygelMediaObjectCheckWritableData* _data_);
#define RYGEL_WRITABLE_CONTAINER_WRITABLE_SCHEME "rygel-writable://"
static void rygel_media_object_check_writable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
const gchar* rygel_media_object_get_date (RygelMediaObject* self);
static gint rygel_media_object_compare_long (RygelMediaObject* self, glong a, glong b);
GQuark rygel_media_item_error_quark (void);
RygelMediaObject* rygel_media_object_construct (GType object_type);
void rygel_media_object_set_id (RygelMediaObject* self, const gchar* value);
const gchar* rygel_media_object_get_ref_id (RygelMediaObject* self);
void rygel_media_object_set_ref_id (RygelMediaObject* self, const gchar* value);
void rygel_media_object_set_upnp_class (RygelMediaObject* self, const gchar* value);
void rygel_media_object_set_date (RygelMediaObject* self, const gchar* value);
void rygel_media_object_set_creator (RygelMediaObject* self, const gchar* value);
guint64 rygel_media_object_get_modified (RygelMediaObject* self);
void rygel_media_object_set_modified (RygelMediaObject* self, guint64 value);
guint rygel_media_object_get_object_update_id (RygelMediaObject* self);
void rygel_media_object_set_object_update_id (RygelMediaObject* self, guint value);
void rygel_media_object_set_parent (RygelMediaObject* self, RygelMediaContainer* value);
RygelMediaContainer* rygel_media_object_get_parent_ref (RygelMediaObject* self);
void rygel_media_object_set_parent_ref (RygelMediaObject* self, RygelMediaContainer* value);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
gboolean rygel_media_object_get_restricted (RygelMediaObject* self);
static void rygel_media_object_finalize (GObject* obj);
static void _vala_rygel_media_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return self ? g_object_ref (self) : NULL;
#line 532 "rygel-media-object.c"
}


GeeList* rygel_media_object_get_uris (RygelMediaObject* self) {
	GeeList* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = self->priv->uris;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = _g_object_ref0 ((GeeList*) _tmp0_);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _tmp1_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 550 "rygel-media-object.c"
}


gchar* rygel_media_object_get_primary_uri (RygelMediaObject* self) {
	gchar* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GeeArrayList* _tmp3_ = NULL;
	gpointer _tmp4_ = NULL;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = self->priv->uris;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = gee_collection_get_is_empty ((GeeCollection*) _tmp0_);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp2_ = _tmp1_;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_tmp2_) {
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		result = NULL;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return result;
#line 575 "rygel-media-object.c"
	}
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp3_ = self->priv->uris;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, 0);
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = (gchar*) _tmp4_;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 585 "rygel-media-object.c"
}


static void rygel_media_object_real_add_uri (RygelMediaObject* self, const gchar* uri) {
	GeeArrayList* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (uri != NULL);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = self->priv->uris;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = uri;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 600 "rygel-media-object.c"
}


void rygel_media_object_add_uri (RygelMediaObject* self, const gchar* uri) {
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (self != NULL);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	RYGEL_MEDIA_OBJECT_GET_CLASS (self)->add_uri (self, uri);
#line 609 "rygel-media-object.c"
}


static void rygel_media_object_real_constructed (GObject* base) {
	RygelMediaObject * self;
	GeeArrayList* _tmp0_ = NULL;
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self = (RygelMediaObject*) base;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	G_OBJECT_CLASS (rygel_media_object_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (self->priv->uris);
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self->priv->uris = _tmp0_;
#line 626 "rygel-media-object.c"
}


static void rygel_media_object_get_writable_data_free (gpointer _data) {
	RygelMediaObjectGetWritableData* _data_;
	_data_ = _data;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->cancellable);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->result);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->self);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_slice_free (RygelMediaObjectGetWritableData, _data_);
#line 641 "rygel-media-object.c"
}


void rygel_media_object_get_writable (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaObjectGetWritableData* _data_;
	RygelMediaObject* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_ = g_slice_new0 (RygelMediaObjectGetWritableData);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_object_get_writable);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_object_get_writable_data_free);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->self = _tmp0_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = cancellable;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->cancellable);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->cancellable = _tmp2_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	rygel_media_object_get_writable_co (_data_);
#line 670 "rygel-media-object.c"
}


GFile* rygel_media_object_get_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error) {
	GFile* result;
	RygelMediaObjectGetWritableData* _data_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return NULL;
#line 681 "rygel-media-object.c"
	}
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _data_->result;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->result = NULL;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 691 "rygel-media-object.c"
}


/**
     * Fetches a File object for any writable URI available for this object.
     *
     * @param cancellable A GLib.Cancellable
     */
static void rygel_media_object_get_writable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaObjectGetWritableData* _data_;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_ = _user_data_;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_source_object_ = source_object;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_res_ = _res_;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	rygel_media_object_get_writable_co (_data_);
#line 710 "rygel-media-object.c"
}


static gboolean rygel_media_object_get_writable_co (RygelMediaObjectGetWritableData* _data_) {
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	switch (_data_->_state_) {
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case 0:
#line 719 "rygel-media-object.c"
		goto _state_0;
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case 1:
#line 723 "rygel-media-object.c"
		goto _state_1;
		default:
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_assert_not_reached ();
#line 728 "rygel-media-object.c"
	}
	_state_0:
	{
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp0_ = NULL;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp0_ = _data_->self->priv->uris;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp1_ = NULL;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_uri_list = _data_->_tmp1_;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp2_ = NULL;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp2_ = _data_->_uri_list;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp3_ = 0;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp2_);
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp4_ = 0;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp4_ = _data_->_tmp3_;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_uri_size = _data_->_tmp4_;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_uri_index = -1;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		while (TRUE) {
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp5_ = 0;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp5_ = _data_->_uri_index;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_uri_index = _data_->_tmp5_ + 1;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp6_ = 0;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp6_ = _data_->_uri_index;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp7_ = 0;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp7_ = _data_->_uri_size;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (!(_data_->_tmp6_ < _data_->_tmp7_)) {
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				break;
#line 778 "rygel-media-object.c"
			}
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp8_ = NULL;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp8_ = _data_->_uri_list;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp9_ = 0;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp9_ = _data_->_uri_index;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp10_ = NULL;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp8_, _data_->_tmp9_);
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->uri = (gchar*) _data_->_tmp10_;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp11_ = NULL;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp11_ = _data_->uri;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp12_ = NULL;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp12_ = g_file_new_for_uri (_data_->_tmp11_);
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->file = _data_->_tmp12_;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp14_ = NULL;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp14_ = _data_->file;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp15_ = NULL;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp15_ = _data_->cancellable;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_state_ = 1;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			rygel_media_object_check_writable (_data_->self, _data_->_tmp14_, _data_->_tmp15_, rygel_media_object_get_writable_ready, _data_);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			return FALSE;
#line 818 "rygel-media-object.c"
			_state_1:
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp16_ = FALSE;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp16_ = rygel_media_object_check_writable_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp13_ = _data_->_tmp16_;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				g_error_free (_data_->_inner_error_);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_g_object_unref0 (_data_->file);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_g_free0 (_data_->uri);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_g_object_unref0 (_data_->_uri_list);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				if (_data_->_state_ == 0) {
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 842 "rygel-media-object.c"
				} else {
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 846 "rygel-media-object.c"
				}
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				g_object_unref (_data_->_async_result);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				return FALSE;
#line 852 "rygel-media-object.c"
			}
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (_data_->_tmp13_) {
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_data_->result = _data_->file;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_g_free0 (_data_->uri);
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_g_object_unref0 (_data_->_uri_list);
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				if (_data_->_state_ == 0) {
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 866 "rygel-media-object.c"
				} else {
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 870 "rygel-media-object.c"
				}
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				g_object_unref (_data_->_async_result);
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				return FALSE;
#line 876 "rygel-media-object.c"
			}
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_object_unref0 (_data_->file);
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_free0 (_data_->uri);
#line 882 "rygel-media-object.c"
		}
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_object_unref0 (_data_->_uri_list);
#line 886 "rygel-media-object.c"
	}
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->result = NULL;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_data_->_state_ == 0) {
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 894 "rygel-media-object.c"
	} else {
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 898 "rygel-media-object.c"
	}
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_unref (_data_->_async_result);
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return FALSE;
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_data_->_state_ == 0) {
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 908 "rygel-media-object.c"
	} else {
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 912 "rygel-media-object.c"
	}
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_unref (_data_->_async_result);
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return FALSE;
#line 918 "rygel-media-object.c"
}


static void rygel_media_object_get_writables_data_free (gpointer _data) {
	RygelMediaObjectGetWritablesData* _data_;
	_data_ = _data;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->cancellable);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->result);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->self);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_slice_free (RygelMediaObjectGetWritablesData, _data_);
#line 933 "rygel-media-object.c"
}


void rygel_media_object_get_writables (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaObjectGetWritablesData* _data_;
	RygelMediaObject* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_ = g_slice_new0 (RygelMediaObjectGetWritablesData);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_object_get_writables);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_object_get_writables_data_free);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->self = _tmp0_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = cancellable;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->cancellable);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->cancellable = _tmp2_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	rygel_media_object_get_writables_co (_data_);
#line 962 "rygel-media-object.c"
}


GeeArrayList* rygel_media_object_get_writables_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error) {
	GeeArrayList* result;
	RygelMediaObjectGetWritablesData* _data_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return NULL;
#line 973 "rygel-media-object.c"
	}
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _data_->result;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->result = NULL;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 983 "rygel-media-object.c"
}


/**
     * Fetches File objects for all writable URIs available for this object.
     *
     * @param cancellable A GLib.Cancellable
     */
static void rygel_media_object_get_writables_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaObjectGetWritablesData* _data_;
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_ = _user_data_;
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_source_object_ = source_object;
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_res_ = _res_;
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	rygel_media_object_get_writables_co (_data_);
#line 1002 "rygel-media-object.c"
}


static gboolean rygel_media_object_get_writables_co (RygelMediaObjectGetWritablesData* _data_) {
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	switch (_data_->_state_) {
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case 0:
#line 1011 "rygel-media-object.c"
		goto _state_0;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case 1:
#line 1015 "rygel-media-object.c"
		goto _state_1;
		default:
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_assert_not_reached ();
#line 1020 "rygel-media-object.c"
	}
	_state_0:
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp0_ = NULL;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp0_ = gee_array_list_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->writables = _data_->_tmp0_;
#line 1029 "rygel-media-object.c"
	{
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp1_ = NULL;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp1_ = _data_->self->priv->uris;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp2_ = NULL;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_uri_list = _data_->_tmp2_;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp3_ = NULL;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp3_ = _data_->_uri_list;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp4_ = 0;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp3_);
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp5_ = 0;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_uri_size = _data_->_tmp5_;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_uri_index = -1;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		while (TRUE) {
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp6_ = 0;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp6_ = _data_->_uri_index;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_uri_index = _data_->_tmp6_ + 1;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp7_ = 0;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp7_ = _data_->_uri_index;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp8_ = 0;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp8_ = _data_->_uri_size;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (!(_data_->_tmp7_ < _data_->_tmp8_)) {
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				break;
#line 1077 "rygel-media-object.c"
			}
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp9_ = NULL;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp9_ = _data_->_uri_list;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp10_ = 0;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp10_ = _data_->_uri_index;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp11_ = NULL;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp9_, _data_->_tmp10_);
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->uri = (gchar*) _data_->_tmp11_;
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp12_ = NULL;
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp12_ = _data_->uri;
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp13_ = NULL;
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp13_ = g_file_new_for_uri (_data_->_tmp12_);
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->file = _data_->_tmp13_;
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp15_ = NULL;
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp15_ = _data_->file;
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp16_ = NULL;
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp16_ = _data_->cancellable;
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_state_ = 1;
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			rygel_media_object_check_writable (_data_->self, _data_->_tmp15_, _data_->_tmp16_, rygel_media_object_get_writables_ready, _data_);
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			return FALSE;
#line 1117 "rygel-media-object.c"
			_state_1:
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp17_ = FALSE;
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp17_ = rygel_media_object_check_writable_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp14_ = _data_->_tmp17_;
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				g_error_free (_data_->_inner_error_);
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_g_object_unref0 (_data_->file);
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_g_free0 (_data_->uri);
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_g_object_unref0 (_data_->_uri_list);
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_g_object_unref0 (_data_->writables);
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				if (_data_->_state_ == 0) {
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1143 "rygel-media-object.c"
				} else {
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 1147 "rygel-media-object.c"
				}
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				g_object_unref (_data_->_async_result);
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				return FALSE;
#line 1153 "rygel-media-object.c"
			}
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (_data_->_tmp14_) {
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_data_->_tmp18_ = NULL;
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_data_->_tmp18_ = _data_->writables;
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_data_->_tmp19_ = NULL;
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_data_->_tmp19_ = _data_->file;
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp18_, _data_->_tmp19_);
#line 1167 "rygel-media-object.c"
			}
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_object_unref0 (_data_->file);
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_free0 (_data_->uri);
#line 1173 "rygel-media-object.c"
		}
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_object_unref0 (_data_->_uri_list);
#line 1177 "rygel-media-object.c"
	}
#line 217 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->result = _data_->writables;
#line 217 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_data_->_state_ == 0) {
#line 217 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1185 "rygel-media-object.c"
	} else {
#line 217 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1189 "rygel-media-object.c"
	}
#line 217 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_unref (_data_->_async_result);
#line 217 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return FALSE;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->writables);
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_data_->_state_ == 0) {
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1201 "rygel-media-object.c"
	} else {
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1205 "rygel-media-object.c"
	}
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_unref (_data_->_async_result);
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return FALSE;
#line 1211 "rygel-media-object.c"
}


/**
     * Return the MediaResource list.
     */
GeeList* rygel_media_object_get_resource_list (RygelMediaObject* self) {
	GeeList* result = NULL;
	GeeList* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
#line 223 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = self->priv->media_resources;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _tmp1_;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 1232 "rygel-media-object.c"
}


RygelMediaResource* rygel_media_object_get_resource_by_name (RygelMediaObject* self, const gchar* resource_name) {
	RygelMediaResource* result = NULL;
#line 227 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 227 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (resource_name != NULL, NULL);
#line 1242 "rygel-media-object.c"
	{
		GeeList* _resource_list = NULL;
		GeeList* _tmp0_ = NULL;
		GeeList* _tmp1_ = NULL;
		gint _resource_size = 0;
		GeeList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _resource_index = 0;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp0_ = self->priv->media_resources;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_resource_list = _tmp1_;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp2_ = _resource_list;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp4_ = _tmp3_;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_resource_size = _tmp4_;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_resource_index = -1;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		while (TRUE) {
#line 1270 "rygel-media-object.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			RygelMediaResource* resource = NULL;
			GeeList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			RygelMediaResource* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			gboolean _tmp15_ = FALSE;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp5_ = _resource_index;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_resource_index = _tmp5_ + 1;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp6_ = _resource_index;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp7_ = _resource_size;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				break;
#line 1295 "rygel-media-object.c"
			}
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp8_ = _resource_list;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp9_ = _resource_index;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp10_ = gee_list_get (_tmp8_, _tmp9_);
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			resource = (RygelMediaResource*) _tmp10_;
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp11_ = resource;
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp12_ = rygel_media_resource_get_name (_tmp11_);
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp13_ = _tmp12_;
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp14_ = resource_name;
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp15_ = g_strcmp0 (_tmp13_, _tmp14_) == 0;
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_free0 (_tmp13_);
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (_tmp15_) {
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				result = resource;
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_g_object_unref0 (_resource_list);
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				return result;
#line 1325 "rygel-media-object.c"
			}
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_object_unref0 (resource);
#line 1329 "rygel-media-object.c"
		}
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_object_unref0 (_resource_list);
#line 1333 "rygel-media-object.c"
	}
#line 234 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = NULL;
#line 234 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 1339 "rygel-media-object.c"
}


static GUPnPDIDLLiteObject* rygel_media_object_real_serialize (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error) {
#line 237 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_critical ("Type `%s' does not implement abstract method `rygel_media_object_serialize'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 237 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return NULL;
#line 1348 "rygel-media-object.c"
}


GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error) {
#line 237 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 237 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return RYGEL_MEDIA_OBJECT_GET_CLASS (self)->serialize (self, serializer, http_server, error);
#line 1357 "rygel-media-object.c"
}


/**
     * Serialize the resource list
     *
     * Any resource with an empty URIs will get a resource-based HTTP URI and have its protocol
     * and delivery options adjusted to the HTTPServer.
     *
     * Internal (e.g. "file:") resources will only be included when the http server
     * is on the local host.
     *
     * Resources will be serialized in list order.
     */
void rygel_media_object_serialize_resource_list (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object, RygelHTTPServer* http_server, GError** error) {
	GHashTable* replacements = NULL;
	RygelHTTPServer* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 252 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (self != NULL);
#line 252 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (didl_object != NULL);
#line 252 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (http_server != NULL);
#line 255 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = http_server;
#line 255 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = rygel_http_server_get_replacements (_tmp0_);
#line 255 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	replacements = _tmp1_;
#line 1389 "rygel-media-object.c"
	{
		GeeList* _res_list = NULL;
		GeeList* _tmp2_ = NULL;
		gint _res_size = 0;
		GeeList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _res_index = 0;
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp2_ = rygel_media_object_get_resource_list (self);
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_res_list = _tmp2_;
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp3_ = _res_list;
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp5_ = _tmp4_;
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_res_size = _tmp5_;
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_res_index = -1;
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		while (TRUE) {
#line 1414 "rygel-media-object.c"
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			RygelMediaResource* res = NULL;
			GeeList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			RygelMediaResource* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp6_ = _res_index;
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_res_index = _tmp6_ + 1;
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp7_ = _res_index;
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp8_ = _res_size;
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				break;
#line 1438 "rygel-media-object.c"
			}
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp9_ = _res_list;
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp10_ = _res_index;
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp11_ = gee_list_get (_tmp9_, _tmp10_);
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			res = (RygelMediaResource*) _tmp11_;
#line 257 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp13_ = res;
#line 257 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp14_ = rygel_media_resource_get_uri (_tmp13_);
#line 257 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp15_ = _tmp14_;
#line 257 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (_tmp15_ == NULL) {
#line 257 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp12_ = TRUE;
#line 1458 "rygel-media-object.c"
			} else {
				RygelMediaResource* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
#line 257 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp16_ = res;
#line 257 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp17_ = rygel_media_resource_get_uri (_tmp16_);
#line 257 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp18_ = _tmp17_;
#line 257 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp12_ = g_strcmp0 (_tmp18_, "") == 0;
#line 1471 "rygel-media-object.c"
			}
#line 257 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (_tmp12_) {
#line 1475 "rygel-media-object.c"
				gchar* uri = NULL;
				RygelHTTPServer* _tmp19_ = NULL;
				RygelMediaResource* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				gboolean _tmp25_ = FALSE;
				GUPnPDIDLLiteResource* didl_resource = NULL;
				GUPnPDIDLLiteObject* _tmp32_ = NULL;
				GUPnPDIDLLiteResource* _tmp33_ = NULL;
				RygelHTTPServer* _tmp34_ = NULL;
				RygelMediaResource* _tmp35_ = NULL;
				RygelMediaResource* _tmp36_ = NULL;
				GUPnPDIDLLiteResource* _tmp37_ = NULL;
				GHashTable* _tmp38_ = NULL;
				GUPnPDIDLLiteResource* _tmp39_ = NULL;
				GUPnPDIDLLiteResource* _tmp40_ = NULL;
				RygelMediaResource* _tmp41_ = NULL;
				RygelMediaResource* _tmp42_ = NULL;
#line 258 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp19_ = http_server;
#line 258 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp20_ = res;
#line 258 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp21_ = rygel_media_resource_get_name (_tmp20_);
#line 258 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp22_ = _tmp21_;
#line 258 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp23_ = rygel_http_server_create_uri_for_object (_tmp19_, self, -1, -1, _tmp22_);
#line 258 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp24_ = _tmp23_;
#line 258 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_g_free0 (_tmp22_);
#line 258 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				uri = _tmp24_;
#line 262 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
#line 1514 "rygel-media-object.c"
					gboolean _tmp26_ = FALSE;
					gboolean _tmp27_ = FALSE;
#line 263 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					_tmp26_ = rygel_media_file_item_get_place_holder (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) self) : NULL);
#line 263 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					_tmp27_ = _tmp26_;
#line 263 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					_tmp25_ = _tmp27_;
#line 1523 "rygel-media-object.c"
				} else {
#line 262 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					_tmp25_ = FALSE;
#line 1527 "rygel-media-object.c"
				}
#line 262 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				if (_tmp25_) {
#line 1531 "rygel-media-object.c"
					RygelMediaResource* _tmp28_ = NULL;
					const gchar* _tmp29_ = NULL;
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					_tmp28_ = res;
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					_tmp29_ = uri;
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					rygel_media_resource_set_import_uri (_tmp28_, _tmp29_);
#line 1540 "rygel-media-object.c"
				} else {
					RygelMediaResource* _tmp30_ = NULL;
					const gchar* _tmp31_ = NULL;
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					_tmp30_ = res;
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					_tmp31_ = uri;
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					rygel_media_resource_set_uri (_tmp30_, _tmp31_);
#line 1550 "rygel-media-object.c"
				}
#line 268 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp32_ = didl_object;
#line 268 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp33_ = gupnp_didl_lite_object_add_resource (_tmp32_);
#line 268 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				didl_resource = _tmp33_;
#line 269 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp34_ = http_server;
#line 269 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp35_ = res;
#line 269 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				rygel_http_server_set_resource_delivery_options (_tmp34_, _tmp35_);
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp36_ = res;
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp37_ = didl_resource;
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp38_ = replacements;
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp39_ = rygel_media_resource_serialize (_tmp36_, _tmp37_, _tmp38_);
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp40_ = _tmp39_;
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_g_object_unref0 (_tmp40_);
#line 271 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp41_ = res;
#line 271 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				rygel_media_resource_set_uri (_tmp41_, NULL);
#line 272 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp42_ = res;
#line 272 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				rygel_media_resource_set_import_uri (_tmp42_, NULL);
#line 257 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_g_object_unref0 (didl_resource);
#line 257 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_g_free0 (uri);
#line 1588 "rygel-media-object.c"
			} else {
				{
					gchar* protocol = NULL;
					RygelMediaResource* _tmp43_ = NULL;
					const gchar* _tmp44_ = NULL;
					const gchar* _tmp45_ = NULL;
					gchar* _tmp46_ = NULL;
					gboolean _tmp47_ = FALSE;
					const gchar* _tmp48_ = NULL;
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					_tmp43_ = res;
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					_tmp44_ = rygel_media_resource_get_uri (_tmp43_);
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					_tmp45_ = _tmp44_;
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					_tmp46_ = rygel_media_object_get_protocol_for_uri (self, _tmp45_, &_inner_error_);
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					protocol = _tmp46_;
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1610 "rygel-media-object.c"
						goto __catch14_g_error;
					}
#line 276 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					_tmp48_ = protocol;
#line 276 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					if (g_strcmp0 (_tmp48_, "internal") != 0) {
#line 276 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
						_tmp47_ = TRUE;
#line 1619 "rygel-media-object.c"
					} else {
						RygelHTTPServer* _tmp49_ = NULL;
						gboolean _tmp50_ = FALSE;
#line 276 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
						_tmp49_ = http_server;
#line 276 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
						_tmp50_ = rygel_http_server_is_local (_tmp49_);
#line 276 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
						_tmp47_ = _tmp50_;
#line 1629 "rygel-media-object.c"
					}
#line 276 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					if (_tmp47_) {
#line 1633 "rygel-media-object.c"
						GUPnPDIDLLiteResource* didl_resource = NULL;
						GUPnPDIDLLiteObject* _tmp51_ = NULL;
						GUPnPDIDLLiteResource* _tmp52_ = NULL;
						RygelMediaResource* _tmp53_ = NULL;
						GUPnPDIDLLiteResource* _tmp54_ = NULL;
						GHashTable* _tmp55_ = NULL;
						GUPnPDIDLLiteResource* _tmp56_ = NULL;
						GUPnPDIDLLiteResource* _tmp57_ = NULL;
#line 278 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
						_tmp51_ = didl_object;
#line 278 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
						_tmp52_ = gupnp_didl_lite_object_add_resource (_tmp51_);
#line 278 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
						didl_resource = _tmp52_;
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
						_tmp53_ = res;
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
						_tmp54_ = didl_resource;
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
						_tmp55_ = replacements;
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
						_tmp56_ = rygel_media_resource_serialize (_tmp53_, _tmp54_, _tmp55_);
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
						_tmp57_ = _tmp56_;
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
						_g_object_unref0 (_tmp57_);
#line 276 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
						_g_object_unref0 (didl_resource);
#line 1662 "rygel-media-object.c"
					}
#line 274 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					_g_free0 (protocol);
#line 1666 "rygel-media-object.c"
				}
				goto __finally14;
				__catch14_g_error:
				{
					GError* e = NULL;
					const gchar* _tmp58_ = NULL;
					RygelMediaResource* _tmp59_ = NULL;
					const gchar* _tmp60_ = NULL;
					const gchar* _tmp61_ = NULL;
#line 274 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					e = _inner_error_;
#line 274 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					_inner_error_ = NULL;
#line 282 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					_tmp58_ = _ ("Could not determine protocol for %s");
#line 282 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					_tmp59_ = res;
#line 282 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					_tmp60_ = rygel_media_resource_get_uri (_tmp59_);
#line 282 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					_tmp61_ = _tmp60_;
#line 282 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					g_warning (_tmp58_, _tmp61_);
#line 274 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					_g_error_free0 (e);
#line 1692 "rygel-media-object.c"
				}
				__finally14:
#line 274 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 274 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					g_propagate_error (error, _inner_error_);
#line 274 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					_g_object_unref0 (res);
#line 274 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					_g_object_unref0 (_res_list);
#line 274 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					_g_hash_table_unref0 (replacements);
#line 274 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					return;
#line 1707 "rygel-media-object.c"
				}
			}
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_object_unref0 (res);
#line 1712 "rygel-media-object.c"
		}
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_object_unref0 (_res_list);
#line 1716 "rygel-media-object.c"
	}
#line 252 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_hash_table_unref0 (replacements);
#line 1720 "rygel-media-object.c"
}


/**
     * Replace each key in replacement_pairs with its corresponding
     * value in the source_string and return the result.
     *
     * If source_string is null, null is returned.
     */
static Block4Data* block4_data_ref (Block4Data* _data4_) {
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return _data4_;
#line 1735 "rygel-media-object.c"
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_free0 (_data4_->replaced_string);
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_slice_free (Block4Data, _data4_);
#line 1748 "rygel-media-object.c"
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1762 "rygel-media-object.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1793 "rygel-media-object.c"
				goto __catch15_g_regex_error;
			}
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return NULL;
#line 1802 "rygel-media-object.c"
		}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1818 "rygel-media-object.c"
				goto __catch15_g_regex_error;
			}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return NULL;
#line 1829 "rygel-media-object.c"
		}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 1843 "rygel-media-object.c"
	}
	goto __finally15;
	__catch15_g_regex_error:
	{
		GError* e = NULL;
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1287 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 1857 "rygel-media-object.c"
	}
	__finally15:
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return NULL;
#line 1868 "rygel-media-object.c"
	}
}


static void __lambda4_ (Block4Data* _data4_, const gchar* search_string, const gchar* replacement) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 301 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (search_string != NULL);
#line 301 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (replacement != NULL);
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = _data4_->replaced_string;
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = search_string;
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp2_ = replacement;
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp3_ = string_replace (_tmp0_, _tmp1_, _tmp2_);
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_free0 (_data4_->replaced_string);
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data4_->replaced_string = _tmp3_;
#line 1894 "rygel-media-object.c"
}


static void ___lambda4__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
#line 301 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	__lambda4_ (self, (const gchar*) key, (const gchar*) value);
#line 1901 "rygel-media-object.c"
}


gchar* rygel_media_object_apply_replacements (GHashTable* replacement_pairs, const gchar* source_string) {
	gchar* result = NULL;
	Block4Data* _data4_;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GHashTable* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (replacement_pairs != NULL, NULL);
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (source_string != NULL, NULL);
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data4_->_ref_count_ = 1;
#line 297 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = source_string;
#line 297 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_tmp0_ == NULL) {
#line 298 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		result = NULL;
#line 298 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		block4_data_unref (_data4_);
#line 298 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data4_ = NULL;
#line 298 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return result;
#line 1934 "rygel-media-object.c"
	}
#line 300 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = source_string;
#line 300 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 300 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data4_->replaced_string = _tmp2_;
#line 301 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp3_ = replacement_pairs;
#line 301 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_hash_table_foreach (_tmp3_, ___lambda4__gh_func, _data4_);
#line 306 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp4_ = _data4_->replaced_string;
#line 306 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 306 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _tmp5_;
#line 306 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	block4_data_unref (_data4_);
#line 306 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data4_ = NULL;
#line 306 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 1958 "rygel-media-object.c"
}


/**
     * Create a stream source for the given resource
     */
static RygelDataSource* rygel_media_object_real_create_stream_source_for_resource (RygelMediaObject* self, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error) {
#line 312 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_critical ("Type `%s' does not implement abstract method `rygel_media_object_create_stream_source_for_resource'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 312 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return NULL;
#line 1970 "rygel-media-object.c"
}


RygelDataSource* rygel_media_object_create_stream_source_for_resource (RygelMediaObject* self, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error) {
#line 312 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 312 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return RYGEL_MEDIA_OBJECT_GET_CLASS (self)->create_stream_source_for_resource (self, request, resource, error);
#line 1979 "rygel-media-object.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 319 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 1986 "rygel-media-object.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 319 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 319 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_list_free (self);
#line 1995 "rygel-media-object.c"
}


static void rygel_media_object_real_apply_didl_lite (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object) {
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GUPnPDIDLLiteObject* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GUPnPDIDLLiteObject* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (didl_object != NULL);
#line 318 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = didl_object;
#line 318 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = gupnp_didl_lite_object_get_title (_tmp0_);
#line 318 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp2_ = _tmp1_;
#line 318 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	rygel_media_object_set_title (self, _tmp2_);
#line 319 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp3_ = didl_object;
#line 319 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp4_ = gupnp_didl_lite_object_get_artists (_tmp3_);
#line 319 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp5_ = _tmp4_;
#line 319 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp6_ = rygel_media_object_get_first (self, _tmp5_);
#line 319 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp7_ = _tmp6_;
#line 319 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	rygel_media_object_set_artist (self, _tmp7_);
#line 319 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_free0 (_tmp7_);
#line 319 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	__g_list_free__g_object_unref0_0 (_tmp5_);
#line 320 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp8_ = didl_object;
#line 320 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp9_ = gupnp_didl_lite_object_get_genre (_tmp8_);
#line 320 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp10_ = _tmp9_;
#line 320 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	rygel_media_object_set_genre (self, _tmp10_);
#line 2045 "rygel-media-object.c"
}


void rygel_media_object_apply_didl_lite (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object) {
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (self != NULL);
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	RYGEL_MEDIA_OBJECT_GET_CLASS (self)->apply_didl_lite (self, didl_object);
#line 2054 "rygel-media-object.c"
}


static void rygel_media_object_clean_node (RygelMediaObject* self, xmlNode* node, xmlNs* ns) {
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_ = NULL;
	xmlAttr* attr = NULL;
	xmlNode* _tmp1_ = NULL;
	xmlAttr* _tmp2_ = NULL;
	xmlNode* child = NULL;
	xmlNode* _tmp26_ = NULL;
	xmlNode* _tmp27_ = NULL;
#line 324 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (self != NULL);
#line 325 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 325 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	list = _tmp0_;
#line 326 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = node;
#line 326 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp2_ = _tmp1_->properties;
#line 326 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	attr = _tmp2_;
#line 327 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	while (TRUE) {
#line 2081 "rygel-media-object.c"
		xmlAttr* _tmp3_ = NULL;
		xmlAttr* _tmp4_ = NULL;
		xmlNs* _tmp5_ = NULL;
		xmlNs* _tmp6_ = NULL;
		xmlAttr* _tmp10_ = NULL;
		xmlAttr* _tmp11_ = NULL;
#line 327 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp3_ = attr;
#line 327 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (!(_tmp3_ != NULL)) {
#line 327 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			break;
#line 2094 "rygel-media-object.c"
		}
#line 328 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp4_ = attr;
#line 328 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp5_ = _tmp4_->ns;
#line 328 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp6_ = ns;
#line 328 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (_tmp5_ == _tmp6_) {
#line 2104 "rygel-media-object.c"
			GeeArrayList* _tmp7_ = NULL;
			xmlAttr* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
#line 329 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp7_ = list;
#line 329 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp8_ = attr;
#line 329 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp9_ = _tmp8_->name;
#line 329 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp9_);
#line 2116 "rygel-media-object.c"
		}
#line 332 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp10_ = attr;
#line 332 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp11_ = _tmp10_->next;
#line 332 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		attr = _tmp11_;
#line 2124 "rygel-media-object.c"
	}
	{
		GeeArrayList* _name_list = NULL;
		GeeArrayList* _tmp12_ = NULL;
		GeeArrayList* _tmp13_ = NULL;
		gint _name_size = 0;
		GeeArrayList* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint _name_index = 0;
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp12_ = list;
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp13_ = _g_object_ref0 (_tmp12_);
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_name_list = _tmp13_;
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp14_ = _name_list;
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp15_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp14_);
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp16_ = _tmp15_;
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_name_size = _tmp16_;
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_name_index = -1;
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		while (TRUE) {
#line 2153 "rygel-media-object.c"
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			gchar* name = NULL;
			GeeArrayList* _tmp20_ = NULL;
			gint _tmp21_ = 0;
			gpointer _tmp22_ = NULL;
			xmlNode* _tmp23_ = NULL;
			xmlNs* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp17_ = _name_index;
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_name_index = _tmp17_ + 1;
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp18_ = _name_index;
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp19_ = _name_size;
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (!(_tmp18_ < _tmp19_)) {
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				break;
#line 2176 "rygel-media-object.c"
			}
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp20_ = _name_list;
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp21_ = _name_index;
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _tmp21_);
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			name = (gchar*) _tmp22_;
#line 336 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp23_ = node;
#line 336 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp24_ = ns;
#line 336 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp25_ = name;
#line 336 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			xmlUnsetNsProp (_tmp23_, _tmp24_, (xmlChar*) _tmp25_);
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_free0 (name);
#line 2196 "rygel-media-object.c"
		}
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_object_unref0 (_name_list);
#line 2200 "rygel-media-object.c"
	}
#line 339 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp26_ = node;
#line 339 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp27_ = _tmp26_->children;
#line 339 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	child = _tmp27_;
#line 340 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	while (TRUE) {
#line 2210 "rygel-media-object.c"
		xmlNode* _tmp28_ = NULL;
		xmlNode* _tmp29_ = NULL;
		xmlNs* _tmp30_ = NULL;
		xmlNode* _tmp31_ = NULL;
		xmlNode* _tmp32_ = NULL;
#line 340 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp28_ = child;
#line 340 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (!(_tmp28_ != NULL)) {
#line 340 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			break;
#line 2222 "rygel-media-object.c"
		}
#line 341 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp29_ = child;
#line 341 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp30_ = ns;
#line 341 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_clean_node (self, _tmp29_, _tmp30_);
#line 342 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp31_ = child;
#line 342 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp32_ = _tmp31_->next;
#line 342 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		child = _tmp32_;
#line 2236 "rygel-media-object.c"
	}
#line 324 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (list);
#line 2240 "rygel-media-object.c"
}


static void rygel_media_object_apply_fragments_data_free (gpointer _data) {
	RygelMediaObjectApplyFragmentsData* _data_;
	_data_ = _data;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->current_fragments);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->new_fragments);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->http_server);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->self);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_slice_free (RygelMediaObjectApplyFragmentsData, _data_);
#line 2257 "rygel-media-object.c"
}


void rygel_media_object_apply_fragments (RygelMediaObject* self, GeeLinkedList* current_fragments, GeeLinkedList* new_fragments, RygelHTTPServer* http_server, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaObjectApplyFragmentsData* _data_;
	RygelMediaObject* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	GeeLinkedList* _tmp2_ = NULL;
	GeeLinkedList* _tmp3_ = NULL;
	GeeLinkedList* _tmp4_ = NULL;
	RygelHTTPServer* _tmp5_ = NULL;
	RygelHTTPServer* _tmp6_ = NULL;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_ = g_slice_new0 (RygelMediaObjectApplyFragmentsData);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_object_apply_fragments);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_object_apply_fragments_data_free);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->self = _tmp0_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = current_fragments;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->current_fragments);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->current_fragments = _tmp2_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp3_ = new_fragments;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->new_fragments);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->new_fragments = _tmp4_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp5_ = http_server;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->http_server);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->http_server = _tmp6_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	rygel_media_object_apply_fragments_co (_data_);
#line 2306 "rygel-media-object.c"
}


GUPnPDIDLLiteFragmentResult rygel_media_object_apply_fragments_finish (RygelMediaObject* self, GAsyncResult* _res_) {
	GUPnPDIDLLiteFragmentResult result;
	RygelMediaObjectApplyFragmentsData* _data_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _data_->result;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 2319 "rygel-media-object.c"
}


static void rygel_media_object_apply_fragments_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaObjectApplyFragmentsData* _data_;
#line 368 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_ = _user_data_;
#line 368 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_source_object_ = source_object;
#line 368 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_res_ = _res_;
#line 368 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	rygel_media_object_apply_fragments_co (_data_);
#line 2333 "rygel-media-object.c"
}


static gboolean rygel_media_object_apply_fragments_co (RygelMediaObjectApplyFragmentsData* _data_) {
#line 346 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	switch (_data_->_state_) {
#line 346 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case 0:
#line 2342 "rygel-media-object.c"
		goto _state_0;
#line 346 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case 1:
#line 2346 "rygel-media-object.c"
		goto _state_1;
		default:
#line 346 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_assert_not_reached ();
#line 2351 "rygel-media-object.c"
	}
	_state_0:
#line 350 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_result_ = GUPNP_DIDL_LITE_FRAGMENT_RESULT_UNKNOWN_ERROR;
#line 2356 "rygel-media-object.c"
	{
#line 353 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp0_ = NULL;
#line 353 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp0_ = rygel_serializer_new (RYGEL_SERIALIZER_TYPE_GENERIC_DIDL);
#line 353 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->writer = _data_->_tmp0_;
#line 354 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp1_ = NULL;
#line 354 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp1_ = _data_->writer;
#line 354 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp2_ = NULL;
#line 354 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp2_ = _data_->http_server;
#line 354 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp3_ = NULL;
#line 354 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp3_ = rygel_media_object_serialize (_data_->self, _data_->_tmp1_, _data_->_tmp2_, &_data_->_inner_error_);
#line 354 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->didl_object = _data_->_tmp3_;
#line 354 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 354 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_object_unref0 (_data_->writer);
#line 2382 "rygel-media-object.c"
			goto __catch16_g_error;
		}
#line 358 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp4_ = NULL;
#line 358 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp4_ = _data_->didl_object;
#line 358 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp5_ = NULL;
#line 358 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp5_ = gupnp_didl_lite_object_get_xml_node (_data_->_tmp4_);
#line 358 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp6_ = NULL;
#line 358 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp6_ = _data_->_tmp5_;
#line 358 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp7_ = NULL;
#line 358 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp7_ = _data_->didl_object;
#line 358 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp8_ = NULL;
#line 358 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp8_ = gupnp_didl_lite_object_get_dlna_namespace (_data_->_tmp7_);
#line 358 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp9_ = NULL;
#line 358 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp9_ = _data_->_tmp8_;
#line 358 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_clean_node (_data_->self, _data_->_tmp6_, _data_->_tmp9_);
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp10_ = NULL;
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp10_ = _data_->didl_object;
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp11_ = NULL;
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp11_ = _data_->current_fragments;
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp12_ = 0;
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp13_ = NULL;
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp13_ = gee_collection_to_array ((GeeCollection*) _data_->_tmp11_, &_data_->_tmp12_);
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp14_ = NULL;
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp14__length1 = 0;
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp14_ = _data_->_tmp13_;
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp14__length1 = _data_->_tmp12_;
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp15_ = NULL;
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp15_ = _data_->new_fragments;
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp16_ = 0;
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp17_ = NULL;
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp17_ = gee_collection_to_array ((GeeCollection*) _data_->_tmp15_, &_data_->_tmp16_);
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp18_ = NULL;
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp18__length1 = 0;
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp18_ = _data_->_tmp17_;
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp18__length1 = _data_->_tmp16_;
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp19_ = 0;
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp19_ = gupnp_didl_lite_object_apply_fragments (_data_->_tmp10_, _data_->_tmp14_, _data_->_tmp12_, _data_->_tmp18_, _data_->_tmp16_);
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_result_ = _data_->_tmp19_;
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp18_ = (_vala_array_free (_data_->_tmp18_, _data_->_tmp18__length1, (GDestroyNotify) g_free), NULL);
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp14_ = (_vala_array_free (_data_->_tmp14_, _data_->_tmp14__length1, (GDestroyNotify) g_free), NULL);
#line 365 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp20_ = 0;
#line 365 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp20_ = _data_->_result_;
#line 365 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (_data_->_tmp20_ == GUPNP_DIDL_LITE_FRAGMENT_RESULT_OK) {
#line 366 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp21_ = NULL;
#line 366 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp21_ = _data_->didl_object;
#line 366 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			rygel_media_object_apply_didl_lite (_data_->self, _data_->_tmp21_);
#line 367 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->self, RYGEL_TYPE_UPDATABLE_OBJECT)) {
#line 368 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_data_->_state_ = 1;
#line 368 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				rygel_updatable_object_commit (G_TYPE_CHECK_INSTANCE_TYPE (_data_->self, RYGEL_TYPE_UPDATABLE_OBJECT) ? ((RygelUpdatableObject*) _data_->self) : NULL, rygel_media_object_apply_fragments_ready, _data_);
#line 368 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				return FALSE;
#line 2481 "rygel-media-object.c"
				_state_1:
#line 368 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				rygel_updatable_object_commit_finish (G_TYPE_CHECK_INSTANCE_TYPE (_data_->self, RYGEL_TYPE_UPDATABLE_OBJECT) ? ((RygelUpdatableObject*) _data_->self) : NULL, _data_->_res_, &_data_->_inner_error_);
#line 368 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 368 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					_g_object_unref0 (_data_->didl_object);
#line 368 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					_g_object_unref0 (_data_->writer);
#line 2491 "rygel-media-object.c"
					goto __catch16_g_error;
				}
			}
		}
#line 352 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_object_unref0 (_data_->didl_object);
#line 352 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_object_unref0 (_data_->writer);
#line 2500 "rygel-media-object.c"
	}
	goto __finally16;
	__catch16_g_error:
	{
#line 352 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->e = _data_->_inner_error_;
#line 352 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_inner_error_ = NULL;
#line 352 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_error_free0 (_data_->e);
#line 2511 "rygel-media-object.c"
	}
	__finally16:
#line 352 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 352 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 352 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_clear_error (&_data_->_inner_error_);
#line 352 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return FALSE;
#line 2522 "rygel-media-object.c"
	}
#line 374 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->result = _data_->_result_;
#line 374 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_data_->_state_ == 0) {
#line 374 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2530 "rygel-media-object.c"
	} else {
#line 374 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2534 "rygel-media-object.c"
	}
#line 374 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_unref (_data_->_async_result);
#line 374 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return FALSE;
#line 346 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_data_->_state_ == 0) {
#line 346 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2544 "rygel-media-object.c"
	} else {
#line 346 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2548 "rygel-media-object.c"
	}
#line 346 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_unref (_data_->_async_result);
#line 346 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return FALSE;
#line 2554 "rygel-media-object.c"
}


static gint rygel_media_object_real_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	static GQuark _tmp2_label0 = 0;
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	static GQuark _tmp2_label1 = 0;
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	static GQuark _tmp2_label2 = 0;
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	static GQuark _tmp2_label3 = 0;
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	static GQuark _tmp2_label4 = 0;
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	static GQuark _tmp2_label5 = 0;
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	static GQuark _tmp2_label6 = 0;
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	static GQuark _tmp2_label7 = 0;
#line 377 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (media_object != NULL, 0);
#line 377 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (property != NULL, 0);
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = property;
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = _tmp0_;
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("@id")))) {
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		switch (0) {
#line 2593 "rygel-media-object.c"
			default:
			{
				const gchar* _tmp4_ = NULL;
				RygelMediaObject* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				gint _tmp7_ = 0;
#line 381 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp4_ = self->priv->_id;
#line 381 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp5_ = media_object;
#line 381 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp6_ = _tmp5_->priv->_id;
#line 381 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp7_ = rygel_media_object_compare_string_props (self, _tmp4_, _tmp6_);
#line 381 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				result = _tmp7_;
#line 381 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				return result;
#line 2612 "rygel-media-object.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("@parentID")))) {
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		switch (0) {
#line 2618 "rygel-media-object.c"
			default:
			{
				RygelMediaContainer* _tmp8_ = NULL;
				RygelMediaContainer* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				RygelMediaObject* _tmp11_ = NULL;
				RygelMediaContainer* _tmp12_ = NULL;
				RygelMediaContainer* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				gint _tmp15_ = 0;
#line 383 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp8_ = rygel_media_object_get_parent (self);
#line 383 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp9_ = _tmp8_;
#line 383 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp10_ = ((RygelMediaObject*) _tmp9_)->priv->_id;
#line 383 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp11_ = media_object;
#line 383 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp12_ = rygel_media_object_get_parent (_tmp11_);
#line 383 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp13_ = _tmp12_;
#line 383 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp14_ = ((RygelMediaObject*) _tmp13_)->priv->_id;
#line 383 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp15_ = rygel_media_object_compare_string_props (self, _tmp10_, _tmp14_);
#line 383 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				result = _tmp15_;
#line 383 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				return result;
#line 2649 "rygel-media-object.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("dc:title")))) {
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		switch (0) {
#line 2655 "rygel-media-object.c"
			default:
			{
				const gchar* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				RygelMediaObject* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				gint _tmp21_ = 0;
#line 386 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp16_ = rygel_media_object_get_title (self);
#line 386 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp17_ = _tmp16_;
#line 386 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp18_ = media_object;
#line 386 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp19_ = rygel_media_object_get_title (_tmp18_);
#line 386 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp20_ = _tmp19_;
#line 386 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp21_ = rygel_media_object_compare_string_props (self, _tmp17_, _tmp20_);
#line 386 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				result = _tmp21_;
#line 386 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				return result;
#line 2680 "rygel-media-object.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("upnp:class")))) {
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		switch (0) {
#line 2686 "rygel-media-object.c"
			default:
			{
				const gchar* _tmp22_ = NULL;
				RygelMediaObject* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				gint _tmp25_ = 0;
#line 388 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp22_ = self->priv->_upnp_class;
#line 388 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp23_ = media_object;
#line 388 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp24_ = _tmp23_->priv->_upnp_class;
#line 388 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp25_ = rygel_media_object_compare_string_props (self, _tmp22_, _tmp24_);
#line 388 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				result = _tmp25_;
#line 388 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				return result;
#line 2705 "rygel-media-object.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("dc:artist")))) {
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		switch (0) {
#line 2711 "rygel-media-object.c"
			default:
			{
				const gchar* _tmp26_ = NULL;
				RygelMediaObject* _tmp27_ = NULL;
				const gchar* _tmp28_ = NULL;
				gint _tmp29_ = 0;
#line 391 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp26_ = self->priv->_artist;
#line 391 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp27_ = media_object;
#line 391 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp28_ = _tmp27_->priv->_artist;
#line 391 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp29_ = rygel_media_object_compare_string_props (self, _tmp26_, _tmp28_);
#line 391 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				result = _tmp29_;
#line 391 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				return result;
#line 2730 "rygel-media-object.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("upnp:genre")))) {
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		switch (0) {
#line 2736 "rygel-media-object.c"
			default:
			{
				const gchar* _tmp30_ = NULL;
				RygelMediaObject* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				gint _tmp33_ = 0;
#line 393 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp30_ = self->priv->_genre;
#line 393 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp31_ = media_object;
#line 393 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp32_ = _tmp31_->priv->_genre;
#line 393 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp33_ = rygel_media_object_compare_string_props (self, _tmp30_, _tmp32_);
#line 393 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				result = _tmp33_;
#line 393 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				return result;
#line 2755 "rygel-media-object.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("dc:creator")))) {
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		switch (0) {
#line 2761 "rygel-media-object.c"
			default:
			{
				const gchar* _tmp34_ = NULL;
				RygelMediaObject* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
				gint _tmp37_ = 0;
#line 395 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp34_ = self->priv->_creator;
#line 395 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp35_ = media_object;
#line 395 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp36_ = _tmp35_->priv->_creator;
#line 395 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp37_ = rygel_media_object_compare_string_props (self, _tmp34_, _tmp36_);
#line 395 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				result = _tmp37_;
#line 395 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				return result;
#line 2780 "rygel-media-object.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("dc:date")))) {
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		switch (0) {
#line 2786 "rygel-media-object.c"
			default:
			{
				RygelMediaObject* _tmp38_ = NULL;
				gint _tmp39_ = 0;
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp38_ = media_object;
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp39_ = rygel_media_object_compare_by_date (self, _tmp38_);
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				result = _tmp39_;
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				return result;
#line 2799 "rygel-media-object.c"
			}
		}
	} else {
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		switch (0) {
#line 2805 "rygel-media-object.c"
			default:
			{
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				result = 0;
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				return result;
#line 2812 "rygel-media-object.c"
			}
		}
	}
}


gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property) {
#line 377 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 377 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return RYGEL_MEDIA_OBJECT_GET_CLASS (self)->compare_by_property (self, media_object, property);
#line 2824 "rygel-media-object.c"
}


gint rygel_media_object_compare_string_props (RygelMediaObject* self, const gchar* prop1, const gchar* prop2) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
#line 404 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 404 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (prop1 != NULL, 0);
#line 404 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (prop2 != NULL, 0);
#line 405 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = prop1;
#line 405 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_tmp0_ == NULL) {
#line 406 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		result = -1;
#line 406 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return result;
#line 2845 "rygel-media-object.c"
	} else {
		const gchar* _tmp1_ = NULL;
#line 407 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp1_ = prop2;
#line 407 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (_tmp1_ == NULL) {
#line 408 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			result = 1;
#line 408 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			return result;
#line 2856 "rygel-media-object.c"
		} else {
			const gchar* _tmp2_ = NULL;
			const gchar* _tmp3_ = NULL;
			gint _tmp4_ = 0;
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp2_ = prop1;
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp3_ = prop2;
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp4_ = g_utf8_collate (_tmp2_, _tmp3_);
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			result = _tmp4_;
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			return result;
#line 2871 "rygel-media-object.c"
		}
	}
}


gint rygel_media_object_compare_int_props (RygelMediaObject* self, gint prop1, gint prop2) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 414 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 415 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = prop1;
#line 415 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = prop2;
#line 415 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp2_ = CLAMP (_tmp0_ - _tmp1_, -1, 1);
#line 415 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _tmp2_;
#line 415 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 2894 "rygel-media-object.c"
}


static void rygel_media_object_check_writable_data_free (gpointer _data) {
	RygelMediaObjectCheckWritableData* _data_;
	_data_ = _data;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->file);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->cancellable);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->self);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_slice_free (RygelMediaObjectCheckWritableData, _data_);
#line 2909 "rygel-media-object.c"
}


static void rygel_media_object_check_writable (RygelMediaObject* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaObjectCheckWritableData* _data_;
	RygelMediaObject* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_ = g_slice_new0 (RygelMediaObjectCheckWritableData);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_object_check_writable);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_object_check_writable_data_free);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->self = _tmp0_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = file;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->file);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->file = _tmp2_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp3_ = cancellable;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->cancellable);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->cancellable = _tmp4_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	rygel_media_object_check_writable_co (_data_);
#line 2948 "rygel-media-object.c"
}


static gboolean rygel_media_object_check_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	RygelMediaObjectCheckWritableData* _data_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return FALSE;
#line 2959 "rygel-media-object.c"
	}
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _data_->result;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 2967 "rygel-media-object.c"
}


static void rygel_media_object_check_writable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaObjectCheckWritableData* _data_;
#line 432 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_ = _user_data_;
#line 432 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_source_object_ = source_object;
#line 432 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_res_ = _res_;
#line 432 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	rygel_media_object_check_writable_co (_data_);
#line 2981 "rygel-media-object.c"
}


static gboolean rygel_media_object_check_writable_co (RygelMediaObjectCheckWritableData* _data_) {
#line 418 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	switch (_data_->_state_) {
#line 418 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case 0:
#line 2990 "rygel-media-object.c"
		goto _state_0;
#line 418 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case 1:
#line 2994 "rygel-media-object.c"
		goto _state_1;
		default:
#line 418 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_assert_not_reached ();
#line 2999 "rygel-media-object.c"
	}
	_state_0:
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp0_ = NULL;
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp0_ = _data_->file;
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp1_ = NULL;
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp1_ = g_file_get_uri_scheme (_data_->_tmp0_);
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp2_ = NULL;
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp3_ = FALSE;
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp3_ = g_str_has_prefix (RYGEL_WRITABLE_CONTAINER_WRITABLE_SCHEME, _data_->_tmp2_);
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp4_ = FALSE;
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp4_ = _data_->_tmp3_;
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_free0 (_data_->_tmp2_);
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_data_->_tmp4_) {
#line 424 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->result = TRUE;
#line 424 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (_data_->_state_ == 0) {
#line 424 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3032 "rygel-media-object.c"
		} else {
#line 424 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3036 "rygel-media-object.c"
		}
#line 424 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_object_unref (_data_->_async_result);
#line 424 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return FALSE;
#line 3042 "rygel-media-object.c"
	}
#line 427 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp5_ = NULL;
#line 427 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp5_ = _data_->file;
#line 427 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp6_ = FALSE;
#line 427 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp6_ = g_file_is_native (_data_->_tmp5_);
#line 427 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (!_data_->_tmp6_) {
#line 428 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->result = FALSE;
#line 428 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (_data_->_state_ == 0) {
#line 428 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3060 "rygel-media-object.c"
		} else {
#line 428 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3064 "rygel-media-object.c"
		}
#line 428 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_object_unref (_data_->_async_result);
#line 428 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return FALSE;
#line 3070 "rygel-media-object.c"
	}
	{
#line 432 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp7_ = NULL;
#line 432 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp7_ = _data_->file;
#line 432 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp8_ = NULL;
#line 432 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp8_ = _data_->cancellable;
#line 432 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_state_ = 1;
#line 432 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_file_query_info_async (_data_->_tmp7_, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, _data_->_tmp8_, rygel_media_object_check_writable_ready, _data_);
#line 432 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return FALSE;
#line 3087 "rygel-media-object.c"
		_state_1:
#line 432 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp9_ = NULL;
#line 432 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp9_ = g_file_query_info_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
#line 432 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->info = _data_->_tmp9_;
#line 432 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 432 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (g_error_matches (_data_->_inner_error_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
#line 3099 "rygel-media-object.c"
				goto __catch17_g_io_error_not_found;
			}
			goto __finally17;
		}
#line 438 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp10_ = NULL;
#line 438 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp10_ = _data_->info;
#line 438 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp11_ = FALSE;
#line 438 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp11_ = g_file_info_get_attribute_boolean (_data_->_tmp10_, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE);
#line 438 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->result = _data_->_tmp11_;
#line 438 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_object_unref0 (_data_->info);
#line 438 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (_data_->_state_ == 0) {
#line 438 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3120 "rygel-media-object.c"
		} else {
#line 438 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3124 "rygel-media-object.c"
		}
#line 438 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_object_unref (_data_->_async_result);
#line 438 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return FALSE;
#line 3130 "rygel-media-object.c"
	}
	goto __finally17;
	__catch17_g_io_error_not_found:
	{
#line 431 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 431 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_inner_error_ = NULL;
#line 440 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->result = TRUE;
#line 440 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_error_free0 (_data_->_error_);
#line 440 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (_data_->_state_ == 0) {
#line 440 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3147 "rygel-media-object.c"
		} else {
#line 440 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3151 "rygel-media-object.c"
		}
#line 440 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_object_unref (_data_->_async_result);
#line 440 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return FALSE;
#line 3157 "rygel-media-object.c"
	}
	__finally17:
#line 431 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 431 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_error_free (_data_->_inner_error_);
#line 431 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_data_->_state_ == 0) {
#line 431 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3168 "rygel-media-object.c"
	} else {
#line 431 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3172 "rygel-media-object.c"
	}
#line 431 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_unref (_data_->_async_result);
#line 431 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return FALSE;
#line 418 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_data_->_state_ == 0) {
#line 418 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3182 "rygel-media-object.c"
	} else {
#line 418 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3186 "rygel-media-object.c"
	}
#line 418 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_unref (_data_->_async_result);
#line 418 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return FALSE;
#line 3192 "rygel-media-object.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1278 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1278 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 3212 "rygel-media-object.c"
}


static gint rygel_media_object_compare_by_date (RygelMediaObject* self, RygelMediaObject* object) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
#line 444 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 444 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (object != NULL, 0);
#line 445 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = self->priv->_date;
#line 445 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_tmp0_ == NULL) {
#line 446 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		result = -1;
#line 446 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return result;
#line 3231 "rygel-media-object.c"
	} else {
		RygelMediaObject* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 447 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp1_ = object;
#line 447 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp2_ = _tmp1_->priv->_date;
#line 447 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (_tmp2_ == NULL) {
#line 448 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			result = 1;
#line 448 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			return result;
#line 3245 "rygel-media-object.c"
		} else {
			gchar* our_date = NULL;
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			gchar* other_date = NULL;
			RygelMediaObject* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
			const gchar* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
			GTimeVal tv1 = {0};
			const gchar* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			GTimeVal tv2 = {0};
			RygelMediaObject* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			gboolean _tmp20_ = FALSE;
			gint ret = 0;
			GTimeVal _tmp21_ = {0};
			glong _tmp22_ = 0L;
			GTimeVal _tmp23_ = {0};
			glong _tmp24_ = 0L;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
#line 450 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp3_ = self->priv->_date;
#line 450 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp4_ = g_strdup (_tmp3_);
#line 450 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			our_date = _tmp4_;
#line 451 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp5_ = object;
#line 451 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp6_ = _tmp5_->priv->_date;
#line 451 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp7_ = g_strdup (_tmp6_);
#line 451 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			other_date = _tmp7_;
#line 453 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp8_ = our_date;
#line 453 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp9_ = string_contains (_tmp8_, "T");
#line 453 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (!_tmp9_) {
#line 3292 "rygel-media-object.c"
				const gchar* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
#line 454 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp10_ = our_date;
#line 454 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp11_ = g_strconcat (_tmp10_, "T00:00:00Z", NULL);
#line 454 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_g_free0 (our_date);
#line 454 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				our_date = _tmp11_;
#line 3303 "rygel-media-object.c"
			}
#line 457 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp12_ = other_date;
#line 457 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp13_ = string_contains (_tmp12_, "T");
#line 457 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (!_tmp13_) {
#line 3311 "rygel-media-object.c"
				const gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
#line 458 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp14_ = other_date;
#line 458 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp15_ = g_strconcat (_tmp14_, "T00:00:00Z", NULL);
#line 458 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_g_free0 (other_date);
#line 458 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				other_date = _tmp15_;
#line 3322 "rygel-media-object.c"
			}
#line 461 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_get_current_time (&tv1);
#line 462 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp16_ = self->priv->_date;
#line 462 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp17_ = g_time_val_from_iso8601 (_tmp16_, &tv1);
#line 462 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_vala_assert (_tmp17_, "tv1.from_iso8601 (this.date)");
#line 464 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_get_current_time (&tv2);
#line 465 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp18_ = object;
#line 465 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp19_ = _tmp18_->priv->_date;
#line 465 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp20_ = g_time_val_from_iso8601 (_tmp19_, &tv2);
#line 465 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_vala_assert (_tmp20_, "tv2.from_iso8601 (object.date)");
#line 467 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp21_ = tv1;
#line 467 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp22_ = _tmp21_.tv_sec;
#line 467 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp23_ = tv2;
#line 467 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp24_ = _tmp23_.tv_sec;
#line 467 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp25_ = rygel_media_object_compare_long (self, _tmp22_, _tmp24_);
#line 467 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			ret = _tmp25_;
#line 468 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp26_ = ret;
#line 468 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (_tmp26_ == 0) {
#line 3358 "rygel-media-object.c"
				GTimeVal _tmp27_ = {0};
				glong _tmp28_ = 0L;
				GTimeVal _tmp29_ = {0};
				glong _tmp30_ = 0L;
				gint _tmp31_ = 0;
#line 469 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp27_ = tv1;
#line 469 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp28_ = _tmp27_.tv_usec;
#line 469 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp29_ = tv2;
#line 469 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp30_ = _tmp29_.tv_usec;
#line 469 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp31_ = rygel_media_object_compare_long (self, _tmp28_, _tmp30_);
#line 469 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				ret = _tmp31_;
#line 3376 "rygel-media-object.c"
			}
#line 472 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			result = ret;
#line 472 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_free0 (other_date);
#line 472 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_free0 (our_date);
#line 472 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			return result;
#line 3386 "rygel-media-object.c"
		}
	}
}


static gint rygel_media_object_compare_long (RygelMediaObject* self, glong a, glong b) {
	gint result = 0;
	glong _tmp0_ = 0L;
	glong _tmp1_ = 0L;
#line 476 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 477 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = a;
#line 477 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = b;
#line 477 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_tmp0_ < _tmp1_) {
#line 478 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		result = -1;
#line 478 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return result;
#line 3408 "rygel-media-object.c"
	} else {
		glong _tmp2_ = 0L;
		glong _tmp3_ = 0L;
#line 479 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp2_ = a;
#line 479 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp3_ = b;
#line 479 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (_tmp2_ > _tmp3_) {
#line 480 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			result = 1;
#line 480 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			return result;
#line 3422 "rygel-media-object.c"
		} else {
#line 482 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			result = 0;
#line 482 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			return result;
#line 3428 "rygel-media-object.c"
		}
	}
}


static gchar* rygel_media_object_get_first (RygelMediaObject* self, GList* contributors) {
	gchar* result = NULL;
	GList* _tmp0_ = NULL;
	gchar* _tmp6_ = NULL;
#line 486 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 487 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = contributors;
#line 487 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_tmp0_ != NULL) {
#line 3444 "rygel-media-object.c"
		GList* _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 488 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp1_ = contributors;
#line 488 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp2_ = _tmp1_->data;
#line 488 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp3_ = gupnp_didl_lite_contributor_get_name ((GUPnPDIDLLiteContributor*) _tmp2_);
#line 488 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp4_ = _tmp3_;
#line 488 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 488 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		result = _tmp5_;
#line 488 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return result;
#line 3464 "rygel-media-object.c"
	}
#line 491 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp6_ = g_strdup ("");
#line 491 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _tmp6_;
#line 491 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 3472 "rygel-media-object.c"
}


gchar* rygel_media_object_get_protocol_for_uri (RygelMediaObject* self, const gchar* uri, GError** error) {
	gchar* result = NULL;
	gchar* scheme = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
#line 494 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 494 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 495 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = uri;
#line 495 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = g_uri_parse_scheme (_tmp0_);
#line 495 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	scheme = _tmp1_;
#line 496 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp2_ = scheme;
#line 496 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_tmp2_ == NULL) {
#line 3498 "rygel-media-object.c"
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
#line 497 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp3_ = _ ("Bad URI: %s");
#line 497 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp4_ = uri;
#line 497 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp5_ = g_error_new (RYGEL_MEDIA_ITEM_ERROR, RYGEL_MEDIA_ITEM_ERROR_BAD_URI, _tmp3_, _tmp4_);
#line 497 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_inner_error_ = _tmp5_;
#line 497 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_propagate_error (error, _inner_error_);
#line 497 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_free0 (scheme);
#line 497 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return NULL;
#line 3516 "rygel-media-object.c"
	}
#line 500 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp6_ = scheme;
#line 500 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (g_strcmp0 (_tmp6_, "http") == 0) {
#line 3522 "rygel-media-object.c"
		gchar* _tmp7_ = NULL;
#line 501 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp7_ = g_strdup ("http-get");
#line 501 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		result = _tmp7_;
#line 501 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_free0 (scheme);
#line 501 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return result;
#line 3532 "rygel-media-object.c"
	} else {
		const gchar* _tmp8_ = NULL;
#line 502 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp8_ = scheme;
#line 502 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (g_strcmp0 (_tmp8_, "file") == 0) {
#line 3539 "rygel-media-object.c"
			gchar* _tmp9_ = NULL;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp9_ = g_strdup ("internal");
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			result = _tmp9_;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_free0 (scheme);
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			return result;
#line 3549 "rygel-media-object.c"
		} else {
			const gchar* _tmp10_ = NULL;
#line 504 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp10_ = scheme;
#line 504 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (g_strcmp0 (_tmp10_, "rtsp") == 0) {
#line 3556 "rygel-media-object.c"
				gchar* _tmp11_ = NULL;
#line 506 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp11_ = g_strdup ("rtsp-rtp-udp");
#line 506 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				result = _tmp11_;
#line 506 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_g_free0 (scheme);
#line 506 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				return result;
#line 3566 "rygel-media-object.c"
			} else {
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
#line 509 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp12_ = _ ("Failed to probe protocol for URI %s. Assuming '%s'");
#line 509 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp13_ = uri;
#line 509 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp14_ = scheme;
#line 509 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				g_warning (_tmp12_, _tmp13_, _tmp14_);
#line 513 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				result = scheme;
#line 513 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				return result;
#line 3583 "rygel-media-object.c"
			}
		}
	}
#line 494 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_free0 (scheme);
#line 3589 "rygel-media-object.c"
}


RygelMediaObject* rygel_media_object_construct (GType object_type) {
	RygelMediaObject * self = NULL;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self = (RygelMediaObject*) g_object_new (object_type, NULL);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return self;
#line 3599 "rygel-media-object.c"
}


const gchar* rygel_media_object_get_id (RygelMediaObject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = self->priv->_id;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _tmp0_;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 3614 "rygel-media-object.c"
}


void rygel_media_object_set_id (RygelMediaObject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (self != NULL);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = value;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_free0 (self->priv->_id);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self->priv->_id = _tmp1_;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_notify ((GObject *) self, "id");
#line 3633 "rygel-media-object.c"
}


const gchar* rygel_media_object_get_ref_id (RygelMediaObject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = self->priv->_ref_id;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _tmp0_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 3648 "rygel-media-object.c"
}


void rygel_media_object_set_ref_id (RygelMediaObject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (self != NULL);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = value;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_free0 (self->priv->_ref_id);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self->priv->_ref_id = _tmp1_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_notify ((GObject *) self, "ref-id");
#line 3667 "rygel-media-object.c"
}


const gchar* rygel_media_object_get_upnp_class (RygelMediaObject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = self->priv->_upnp_class;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _tmp0_;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 3682 "rygel-media-object.c"
}


void rygel_media_object_set_upnp_class (RygelMediaObject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (self != NULL);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = value;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_free0 (self->priv->_upnp_class);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self->priv->_upnp_class = _tmp1_;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_notify ((GObject *) self, "upnp-class");
#line 3701 "rygel-media-object.c"
}


const gchar* rygel_media_object_get_date (RygelMediaObject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = self->priv->_date;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _tmp0_;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 3716 "rygel-media-object.c"
}


void rygel_media_object_set_date (RygelMediaObject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (self != NULL);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = value;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_free0 (self->priv->_date);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self->priv->_date = _tmp1_;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_notify ((GObject *) self, "date");
#line 3735 "rygel-media-object.c"
}


const gchar* rygel_media_object_get_creator (RygelMediaObject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = self->priv->_creator;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _tmp0_;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 3750 "rygel-media-object.c"
}


void rygel_media_object_set_creator (RygelMediaObject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (self != NULL);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = value;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_free0 (self->priv->_creator);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self->priv->_creator = _tmp1_;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_notify ((GObject *) self, "creator");
#line 3769 "rygel-media-object.c"
}


guint64 rygel_media_object_get_modified (RygelMediaObject* self) {
	guint64 result;
	guint64 _tmp0_ = 0ULL;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, 0ULL);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = self->priv->_modified;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _tmp0_;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 3784 "rygel-media-object.c"
}


void rygel_media_object_set_modified (RygelMediaObject* self, guint64 value) {
	guint64 _tmp0_ = 0ULL;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (self != NULL);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = value;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self->priv->_modified = _tmp0_;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_notify ((GObject *) self, "modified");
#line 3798 "rygel-media-object.c"
}


guint rygel_media_object_get_object_update_id (RygelMediaObject* self) {
	guint result;
	guint _tmp0_ = 0U;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = self->priv->_object_update_id;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _tmp0_;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 3813 "rygel-media-object.c"
}


void rygel_media_object_set_object_update_id (RygelMediaObject* self, guint value) {
	guint _tmp0_ = 0U;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (self != NULL);
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = value;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self->priv->_object_update_id = _tmp0_;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_notify ((GObject *) self, "object-update-id");
#line 3827 "rygel-media-object.c"
}


const gchar* rygel_media_object_get_artist (RygelMediaObject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = self->priv->_artist;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _tmp0_;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 3842 "rygel-media-object.c"
}


void rygel_media_object_set_artist (RygelMediaObject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (self != NULL);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = value;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_free0 (self->priv->_artist);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self->priv->_artist = _tmp1_;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_notify ((GObject *) self, "artist");
#line 3861 "rygel-media-object.c"
}


const gchar* rygel_media_object_get_genre (RygelMediaObject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = self->priv->_genre;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _tmp0_;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 3876 "rygel-media-object.c"
}


void rygel_media_object_set_genre (RygelMediaObject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (self != NULL);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = value;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_free0 (self->priv->_genre);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self->priv->_genre = _tmp1_;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_notify ((GObject *) self, "genre");
#line 3895 "rygel-media-object.c"
}


RygelMediaContainer* rygel_media_object_get_parent (RygelMediaObject* self) {
	RygelMediaContainer* result;
	RygelMediaContainer* _tmp0_ = NULL;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = self->parent_ptr;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _tmp0_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 3910 "rygel-media-object.c"
}


void rygel_media_object_set_parent (RygelMediaObject* self, RygelMediaContainer* value) {
	RygelMediaContainer* _tmp0_ = NULL;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (self != NULL);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = value;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self->parent_ptr = _tmp0_;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_notify ((GObject *) self, "parent");
#line 3924 "rygel-media-object.c"
}


RygelMediaContainer* rygel_media_object_get_parent_ref (RygelMediaObject* self) {
	RygelMediaContainer* result;
	RygelMediaContainer* _tmp0_ = NULL;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = self->priv->_parent_ref;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _tmp0_;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 3939 "rygel-media-object.c"
}


void rygel_media_object_set_parent_ref (RygelMediaObject* self, RygelMediaContainer* value) {
	RygelMediaContainer* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	RygelMediaContainer* _tmp2_ = NULL;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (self != NULL);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = value;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	rygel_media_object_set_parent (self, _tmp0_);
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = value;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (self->priv->_parent_ref);
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self->priv->_parent_ref = _tmp2_;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_notify ((GObject *) self, "parent-ref");
#line 3963 "rygel-media-object.c"
}


const gchar* rygel_media_object_get_title (RygelMediaObject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = self->priv->_title;
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _tmp0_;
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 3978 "rygel-media-object.c"
}


void rygel_media_object_set_title (RygelMediaObject* self, const gchar* value) {
	GError * _inner_error_ = NULL;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (self != NULL);
#line 3986 "rygel-media-object.c"
	{
		gchar* _tmp0_ = NULL;
		GRegex* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		GRegex* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		GRegex* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		GRegex* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp1_ = rygel_media_object_real_name_regex;
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp2_ = value;
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp3_ = g_get_real_name ();
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp4_ = g_regex_replace_literal (_tmp1_, _tmp2_, (gssize) (-1), 0, _tmp3_, 0, &_inner_error_);
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp0_ = _tmp4_;
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 4028 "rygel-media-object.c"
				goto __catch18_g_regex_error;
			}
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_clear_error (&_inner_error_);
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			return;
#line 4037 "rygel-media-object.c"
		}
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp5_ = _tmp0_;
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp0_ = NULL;
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_free0 (self->priv->_title);
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		self->priv->_title = _tmp5_;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp7_ = rygel_media_object_user_name_regex;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp8_ = self->priv->_title;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp9_ = g_get_user_name ();
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp10_ = g_regex_replace_literal (_tmp7_, _tmp8_, (gssize) (-1), 0, _tmp9_, 0, &_inner_error_);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp6_ = _tmp10_;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_free0 (_tmp0_);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 4063 "rygel-media-object.c"
				goto __catch18_g_regex_error;
			}
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_free0 (_tmp0_);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_clear_error (&_inner_error_);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			return;
#line 4074 "rygel-media-object.c"
		}
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp11_ = _tmp6_;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp6_ = NULL;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_free0 (self->priv->_title);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		self->priv->_title = _tmp11_;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp13_ = rygel_media_object_host_name_regex;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp14_ = self->priv->_title;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp15_ = g_get_host_name ();
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp16_ = g_regex_replace_literal (_tmp13_, _tmp14_, (gssize) (-1), 0, _tmp15_, 0, &_inner_error_);
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp12_ = _tmp16_;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_free0 (_tmp6_);
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_free0 (_tmp0_);
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 4102 "rygel-media-object.c"
				goto __catch18_g_regex_error;
			}
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_free0 (_tmp6_);
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_free0 (_tmp0_);
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_clear_error (&_inner_error_);
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			return;
#line 4115 "rygel-media-object.c"
		}
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp17_ = _tmp12_;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp12_ = NULL;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_free0 (self->priv->_title);
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		self->priv->_title = _tmp17_;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp19_ = rygel_media_object_pretty_name_regex;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp20_ = self->priv->_title;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp21_ = rygel_get_pretty_host_name ();
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp22_ = _tmp21_;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp23_ = g_regex_replace_literal (_tmp19_, _tmp20_, (gssize) (-1), 0, _tmp22_, 0, &_inner_error_);
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp24_ = _tmp23_;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_free0 (_tmp22_);
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp18_ = _tmp24_;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_free0 (_tmp12_);
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_free0 (_tmp6_);
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_free0 (_tmp0_);
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 4151 "rygel-media-object.c"
				goto __catch18_g_regex_error;
			}
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_free0 (_tmp12_);
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_free0 (_tmp6_);
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_free0 (_tmp0_);
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_clear_error (&_inner_error_);
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			return;
#line 4166 "rygel-media-object.c"
		}
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp25_ = _tmp18_;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp18_ = NULL;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_free0 (self->priv->_title);
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		self->priv->_title = _tmp25_;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_free0 (_tmp18_);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_free0 (_tmp12_);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_free0 (_tmp6_);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_free0 (_tmp0_);
#line 4184 "rygel-media-object.c"
	}
	goto __finally18;
	__catch18_g_regex_error:
	{
		GError* err = NULL;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		err = _inner_error_;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_inner_error_ = NULL;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_assert_not_reached ();
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_error_free0 (err);
#line 4198 "rygel-media-object.c"
	}
	__finally18:
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_clear_error (&_inner_error_);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return;
#line 4209 "rygel-media-object.c"
	}
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_notify ((GObject *) self, "title");
#line 4213 "rygel-media-object.c"
}


GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self) {
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return RYGEL_MEDIA_OBJECT_GET_CLASS (self)->get_ocm_flags (self);
#line 4222 "rygel-media-object.c"
}


static GUPnPOCMFlags rygel_media_object_real_get_ocm_flags (RygelMediaObject* base) {
	GUPnPOCMFlags result;
	RygelMediaObject* self;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self = base;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = GUPNP_OCM_FLAGS_NONE;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 4235 "rygel-media-object.c"
}


gboolean rygel_media_object_get_restricted (RygelMediaObject* self) {
	gboolean result;
	GUPnPOCMFlags _tmp0_ = 0;
	GUPnPOCMFlags _tmp1_ = 0;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = rygel_media_object_get_ocm_flags (self);
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = _tmp0_;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _tmp1_ == GUPNP_OCM_FLAGS_NONE;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 4253 "rygel-media-object.c"
}


static void rygel_media_object_class_init (RygelMediaObjectClass * klass) {
	GError * _inner_error_ = NULL;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	rygel_media_object_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaObjectPrivate));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	((RygelMediaObjectClass *) klass)->add_uri = rygel_media_object_real_add_uri;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	((GObjectClass *) klass)->constructed = rygel_media_object_real_constructed;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	((RygelMediaObjectClass *) klass)->serialize = rygel_media_object_real_serialize;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	((RygelMediaObjectClass *) klass)->create_stream_source_for_resource = rygel_media_object_real_create_stream_source_for_resource;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	((RygelMediaObjectClass *) klass)->apply_didl_lite = rygel_media_object_real_apply_didl_lite;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	((RygelMediaObjectClass *) klass)->compare_by_property = rygel_media_object_real_compare_by_property;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->get_ocm_flags = rygel_media_object_real_get_ocm_flags;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_object_get_property;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_object_set_property;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_object_finalize;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_ID, g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_REF_ID, g_param_spec_string ("ref-id", "ref-id", "ref-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_UPNP_CLASS, g_param_spec_string ("upnp-class", "upnp-class", "upnp-class", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_DATE, g_param_spec_string ("date", "date", "date", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_CREATOR, g_param_spec_string ("creator", "creator", "creator", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_MODIFIED, g_param_spec_uint64 ("modified", "modified", "modified", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_OBJECT_UPDATE_ID, g_param_spec_uint ("object-update-id", "object-update-id", "object-update-id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_ARTIST, g_param_spec_string ("artist", "artist", "artist", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_GENRE, g_param_spec_string ("genre", "genre", "genre", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_PARENT, g_param_spec_object ("parent", "parent", "parent", RYGEL_TYPE_MEDIA_CONTAINER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_PARENT_REF, g_param_spec_object ("parent-ref", "parent-ref", "parent-ref", RYGEL_TYPE_MEDIA_CONTAINER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 4305 "rygel-media-object.c"
	/**
	     * The human-readable title of this container or item.
	     * These variables will be substituted:
	     *
	     *  - @@REALNAME@ will be substituted by the user's real name.
	     *  - @@USERNAME@ will be substituted by the users's login ID.
	     *  - @@HOSTNAME@ will be substituted by the name of the machine.
	     *  - @@ADDRESS@ will be substituted by the IP address of network interface used for the UpNP communication.
	     *  - @@PRETTY_HOSTNAME@ will be substituted by the human readable name of the machine
	     *    (PRETTY_HOSTNAME field of /etc/machine-info)
	     */
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_TITLE, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_OCM_FLAGS, g_param_spec_flags ("ocm-flags", "ocm-flags", "ocm-flags", gupnp_ocm_flags_get_type (), 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_RESTRICTED, g_param_spec_boolean ("restricted", "restricted", "restricted", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 4323 "rygel-media-object.c"
	{
		GRegex* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		GRegex* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		GRegex* _tmp9_ = NULL;
		GRegex* _tmp10_ = NULL;
		GRegex* _tmp11_ = NULL;
		GRegex* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		GRegex* _tmp15_ = NULL;
		GRegex* _tmp16_ = NULL;
		GRegex* _tmp17_ = NULL;
		GRegex* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		GRegex* _tmp21_ = NULL;
		GRegex* _tmp22_ = NULL;
		GRegex* _tmp23_ = NULL;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp1_ = g_regex_escape_string ("@REALNAME@", -1);
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp2_ = _tmp1_;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp4_ = _tmp3_;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_free0 (_tmp2_);
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp0_ = _tmp4_;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 4365 "rygel-media-object.c"
				goto __catch19_g_regex_error;
			}
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_clear_error (&_inner_error_);
#line 4372 "rygel-media-object.c"
		}
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp5_ = _tmp0_;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp0_ = NULL;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_regex_unref0 (rygel_media_object_real_name_regex);
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_real_name_regex = _tmp5_;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp7_ = g_regex_escape_string ("@USERNAME@", -1);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp8_ = _tmp7_;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp10_ = _tmp9_;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_free0 (_tmp8_);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp6_ = _tmp10_;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_regex_unref0 (_tmp0_);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 4400 "rygel-media-object.c"
				goto __catch19_g_regex_error;
			}
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_regex_unref0 (_tmp0_);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_clear_error (&_inner_error_);
#line 4409 "rygel-media-object.c"
		}
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp11_ = _tmp6_;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp6_ = NULL;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_regex_unref0 (rygel_media_object_user_name_regex);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_user_name_regex = _tmp11_;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp13_ = g_regex_escape_string ("@HOSTNAME@", -1);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp14_ = _tmp13_;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp15_ = g_regex_new (_tmp14_, 0, 0, &_inner_error_);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp16_ = _tmp15_;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_free0 (_tmp14_);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp12_ = _tmp16_;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_regex_unref0 (_tmp6_);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_regex_unref0 (_tmp0_);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 4439 "rygel-media-object.c"
				goto __catch19_g_regex_error;
			}
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_regex_unref0 (_tmp6_);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_regex_unref0 (_tmp0_);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_clear_error (&_inner_error_);
#line 4450 "rygel-media-object.c"
		}
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp17_ = _tmp12_;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp12_ = NULL;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_regex_unref0 (rygel_media_object_host_name_regex);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_host_name_regex = _tmp17_;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp19_ = g_regex_escape_string ("@PRETTY_HOSTNAME@", -1);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp20_ = _tmp19_;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp21_ = g_regex_new (_tmp20_, 0, 0, &_inner_error_);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp22_ = _tmp21_;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_free0 (_tmp20_);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp18_ = _tmp22_;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_regex_unref0 (_tmp12_);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_regex_unref0 (_tmp6_);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_regex_unref0 (_tmp0_);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 4482 "rygel-media-object.c"
				goto __catch19_g_regex_error;
			}
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_regex_unref0 (_tmp12_);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_regex_unref0 (_tmp6_);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_regex_unref0 (_tmp0_);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_clear_error (&_inner_error_);
#line 4495 "rygel-media-object.c"
		}
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp23_ = _tmp18_;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp18_ = NULL;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_regex_unref0 (rygel_media_object_pretty_name_regex);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_pretty_name_regex = _tmp23_;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_regex_unref0 (_tmp18_);
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_regex_unref0 (_tmp12_);
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_regex_unref0 (_tmp6_);
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_regex_unref0 (_tmp0_);
#line 4513 "rygel-media-object.c"
	}
	goto __finally19;
	__catch19_g_regex_error:
	{
		GError* err = NULL;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		err = _inner_error_;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_inner_error_ = NULL;
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_assert_not_reached ();
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_error_free0 (err);
#line 4527 "rygel-media-object.c"
	}
	__finally19:
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_clear_error (&_inner_error_);
#line 4536 "rygel-media-object.c"
	}
}


static void rygel_media_object_instance_init (RygelMediaObject * self) {
	GeeLinkedList* _tmp0_ = NULL;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self->priv = RYGEL_MEDIA_OBJECT_GET_PRIVATE (self);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = gee_linked_list_new (RYGEL_TYPE_MEDIA_RESOURCE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self->priv->media_resources = (GeeList*) _tmp0_;
#line 4549 "rygel-media-object.c"
}


static void rygel_media_object_finalize (GObject* obj) {
	RygelMediaObject * self;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_free0 (self->priv->_id);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_free0 (self->priv->_ref_id);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_free0 (self->priv->_upnp_class);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_free0 (self->priv->_date);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_free0 (self->priv->_creator);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_free0 (self->priv->_artist);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_free0 (self->priv->_genre);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (self->priv->uris);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (self->priv->media_resources);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (self->priv->_parent_ref);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_free0 (self->priv->_title);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	G_OBJECT_CLASS (rygel_media_object_parent_class)->finalize (obj);
#line 4581 "rygel-media-object.c"
}


/**
 * Represents a media object (container or item).
 *
 * The derived RygelMediaContainer class represents a container
 * and the derived MediaItem classes represent media items.
 */
GType rygel_media_object_get_type (void) {
	static volatile gsize rygel_media_object_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObject), 0, (GInstanceInitFunc) rygel_media_object_instance_init, NULL };
		GType rygel_media_object_type_id;
		rygel_media_object_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaObject", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_object_type_id__volatile, rygel_media_object_type_id);
	}
	return rygel_media_object_type_id__volatile;
}


static void _vala_rygel_media_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	switch (property_id) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_ID:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_value_set_string (value, rygel_media_object_get_id (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_REF_ID:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_value_set_string (value, rygel_media_object_get_ref_id (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_UPNP_CLASS:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_value_set_string (value, rygel_media_object_get_upnp_class (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_DATE:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_value_set_string (value, rygel_media_object_get_date (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_CREATOR:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_value_set_string (value, rygel_media_object_get_creator (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_MODIFIED:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_value_set_uint64 (value, rygel_media_object_get_modified (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_OBJECT_UPDATE_ID:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_value_set_uint (value, rygel_media_object_get_object_update_id (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_ARTIST:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_value_set_string (value, rygel_media_object_get_artist (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_GENRE:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_value_set_string (value, rygel_media_object_get_genre (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_PARENT:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_value_set_object (value, rygel_media_object_get_parent (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_PARENT_REF:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_value_set_object (value, rygel_media_object_get_parent_ref (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_TITLE:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_value_set_string (value, rygel_media_object_get_title (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_OCM_FLAGS:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_value_set_flags (value, rygel_media_object_get_ocm_flags (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_RESTRICTED:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_value_set_boolean (value, rygel_media_object_get_restricted (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 4692 "rygel-media-object.c"
		default:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 4698 "rygel-media-object.c"
	}
}


static void _vala_rygel_media_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	switch (property_id) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_ID:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_set_id (self, g_value_get_string (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_REF_ID:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_set_ref_id (self, g_value_get_string (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_UPNP_CLASS:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_set_upnp_class (self, g_value_get_string (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_DATE:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_set_date (self, g_value_get_string (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_CREATOR:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_set_creator (self, g_value_get_string (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_MODIFIED:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_set_modified (self, g_value_get_uint64 (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_OBJECT_UPDATE_ID:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_set_object_update_id (self, g_value_get_uint (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_ARTIST:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_set_artist (self, g_value_get_string (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_GENRE:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_set_genre (self, g_value_get_string (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_PARENT:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_set_parent (self, g_value_get_object (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_PARENT_REF:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_set_parent_ref (self, g_value_get_object (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_TITLE:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_set_title (self, g_value_get_string (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 4780 "rygel-media-object.c"
		default:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 4786 "rygel-media-object.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



