/* rygel-gst-data-source.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-gst-data-source.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *         Prasanna Modem <prasanna@ecaspia.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <gst/gst.h>
#include <gst/base/base.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>


#define RYGEL_TYPE_GST_DATA_SOURCE (rygel_gst_data_source_get_type ())
#define RYGEL_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSource))
#define RYGEL_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourceClass))
#define RYGEL_IS_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_DATA_SOURCE))
#define RYGEL_IS_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_DATA_SOURCE))
#define RYGEL_GST_DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourceClass))

typedef struct _RygelGstDataSource RygelGstDataSource;
typedef struct _RygelGstDataSourceClass RygelGstDataSourceClass;
typedef struct _RygelGstDataSourcePrivate RygelGstDataSourcePrivate;

#define RYGEL_TYPE_GST_SINK (rygel_gst_sink_get_type ())
#define RYGEL_GST_SINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_SINK, RygelGstSink))
#define RYGEL_GST_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_SINK, RygelGstSinkClass))
#define RYGEL_IS_GST_SINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_SINK))
#define RYGEL_IS_GST_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_SINK))
#define RYGEL_GST_SINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_SINK, RygelGstSinkClass))

typedef struct _RygelGstSink RygelGstSink;
typedef struct _RygelGstSinkClass RygelGstSinkClass;
typedef struct _RygelGstSinkPrivate RygelGstSinkPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	RYGEL_GST_DATA_SOURCE_ERROR_NOT_COMPATIBLE
} RygelGstDataSourceError;
#define RYGEL_GST_DATA_SOURCE_ERROR rygel_gst_data_source_error_quark ()
struct _RygelGstDataSource {
	GObject parent_instance;
	RygelGstDataSourcePrivate * priv;
	GstElement* src;
	RygelMediaResource* res;
};

struct _RygelGstDataSourceClass {
	GObjectClass parent_class;
};

struct _RygelGstDataSourcePrivate {
	GstPipeline* pipeline;
	RygelHTTPSeekRequest* seek;
	RygelGstSink* sink;
	guint bus_watch_id;
};

struct _RygelGstSink {
	GstBaseSink parent_instance;
	RygelGstSinkPrivate * priv;
	GCancellable* cancellable;
};

struct _RygelGstSinkClass {
	GstBaseSinkClass parent_class;
};

typedef enum  {
	RYGEL_GST_ERROR_MISSING_PLUGIN,
	RYGEL_GST_ERROR_LINK
} RygelGstError;
#define RYGEL_GST_ERROR rygel_gst_error_quark ()

static gpointer rygel_gst_data_source_parent_class = NULL;
static RygelDataSourceIface* rygel_gst_data_source_rygel_data_source_parent_iface = NULL;

GQuark rygel_gst_data_source_error_quark (void);
GType rygel_gst_data_source_get_type (void) G_GNUC_CONST;
GType rygel_gst_sink_get_type (void) G_GNUC_CONST;
#define RYGEL_GST_DATA_SOURCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourcePrivate))
enum  {
	RYGEL_GST_DATA_SOURCE_DUMMY_PROPERTY
};
RygelGstDataSource* rygel_gst_data_source_new (const gchar* uri, RygelMediaResource* resource, GError** error);
RygelGstDataSource* rygel_gst_data_source_construct (GType object_type, const gchar* uri, RygelMediaResource* resource, GError** error);
GstElement* rygel_gst_utils_create_source_for_uri (const gchar* uri);
RygelGstDataSource* rygel_gst_data_source_new_from_element (GstElement* element);
RygelGstDataSource* rygel_gst_data_source_construct_from_element (GType object_type, GstElement* element);
static GeeList* rygel_gst_data_source_real_preroll (RygelDataSource* base, RygelHTTPSeekRequest* seek_request, RygelPlaySpeedRequest* playspeed_request, GError** error);
static void rygel_gst_data_source_real_start (RygelDataSource* base, GError** error);
static void rygel_gst_data_source_prepare_pipeline (RygelGstDataSource* self, const gchar* name, GstElement* src, GError** error);
static void rygel_gst_data_source_real_freeze (RygelDataSource* base);
void rygel_gst_sink_freeze (RygelGstSink* self);
static void rygel_gst_data_source_real_thaw (RygelDataSource* base);
void rygel_gst_sink_thaw (RygelGstSink* self);
static void rygel_gst_data_source_real_stop (RygelDataSource* base);
static gboolean __lambda6_ (RygelGstDataSource* self);
static gboolean ___lambda6__gsource_func (gpointer self);
RygelGstSink* rygel_gst_sink_new (RygelDataSource* source, RygelHTTPSeekRequest* offsets);
RygelGstSink* rygel_gst_sink_construct (GType object_type, RygelDataSource* source, RygelHTTPSeekRequest* offsets);
static void rygel_gst_data_source_src_pad_added (RygelGstDataSource* self, GstElement* src, GstPad* src_pad);
static void _rygel_gst_data_source_src_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self);
GQuark rygel_gst_error_quark (void);
static gboolean rygel_gst_data_source_bus_handler (RygelGstDataSource* self, GstBus* bus, GstMessage* message);
static gboolean _rygel_gst_data_source_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
#define RYGEL_GST_SINK_NAME "http-gst-sink"
GstElement* rygel_gst_utils_get_rtp_depayloader (GstCaps* caps);
static inline void _dynamic_set_streamable0 (GstElement* obj, gboolean value);
static inline void _dynamic_set_fragment_duration1 (GstElement* obj, gint value);
static gboolean rygel_gst_data_source_perform_seek (RygelGstDataSource* self);
static gboolean ___lambda5_ (RygelGstDataSource* self);
static gboolean ____lambda5__gsource_func (gpointer self);
static void rygel_gst_data_source_finalize (GObject* obj);


GQuark rygel_gst_data_source_error_quark (void) {
	return g_quark_from_static_string ("rygel_gst_data_source_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	return self ? g_object_ref (self) : NULL;
#line 156 "rygel-gst-data-source.c"
}


RygelGstDataSource* rygel_gst_data_source_construct (GType object_type, const gchar* uri, RygelMediaResource* resource, GError** error) {
	RygelGstDataSource * self = NULL;
	RygelMediaResource* _tmp0_ = NULL;
	RygelMediaResource* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GstElement* _tmp3_ = NULL;
	GstElement* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 40 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 40 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self = (RygelGstDataSource*) g_object_new (object_type, NULL);
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp0_ = resource;
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_g_object_unref0 (self->res);
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self->res = _tmp1_;
#line 42 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp2_ = uri;
#line 42 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp3_ = rygel_gst_utils_create_source_for_uri (_tmp2_);
#line 42 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_g_object_unref0 (self->src);
#line 42 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self->src = _tmp3_;
#line 43 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp4_ = self->src;
#line 43 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (_tmp4_ == NULL) {
#line 192 "rygel-gst-data-source.c"
		gchar* msg = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
#line 44 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp5_ = _ ("Could not create GstElement for URI %s");
#line 44 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 44 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		msg = _tmp6_;
#line 46 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp7_ = msg;
#line 46 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp8_ = uri;
#line 46 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp9_ = g_error_new (RYGEL_GST_DATA_SOURCE_ERROR, RYGEL_GST_DATA_SOURCE_ERROR_NOT_COMPATIBLE, _tmp7_, _tmp8_);
#line 46 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_inner_error_ = _tmp9_;
#line 46 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		g_propagate_error (error, _inner_error_);
#line 46 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_g_free0 (msg);
#line 46 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_g_object_unref0 (self);
#line 46 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		return NULL;
#line 221 "rygel-gst-data-source.c"
	}
#line 40 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	return self;
#line 225 "rygel-gst-data-source.c"
}


RygelGstDataSource* rygel_gst_data_source_new (const gchar* uri, RygelMediaResource* resource, GError** error) {
#line 40 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	return rygel_gst_data_source_construct (RYGEL_TYPE_GST_DATA_SOURCE, uri, resource, error);
#line 232 "rygel-gst-data-source.c"
}


RygelGstDataSource* rygel_gst_data_source_construct_from_element (GType object_type, GstElement* element) {
	RygelGstDataSource * self = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
#line 60 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_return_val_if_fail (element != NULL, NULL);
#line 60 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self = (RygelGstDataSource*) g_object_new (object_type, NULL);
#line 61 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp0_ = element;
#line 61 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 61 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_g_object_unref0 (self->src);
#line 61 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self->src = _tmp1_;
#line 60 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	return self;
#line 254 "rygel-gst-data-source.c"
}


RygelGstDataSource* rygel_gst_data_source_new_from_element (GstElement* element) {
#line 60 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	return rygel_gst_data_source_construct_from_element (RYGEL_TYPE_GST_DATA_SOURCE, element);
#line 261 "rygel-gst-data-source.c"
}


static GeeList* rygel_gst_data_source_real_preroll (RygelDataSource* base, RygelHTTPSeekRequest* seek_request, RygelPlaySpeedRequest* playspeed_request, GError** error) {
	RygelGstDataSource * self;
	GeeList* result = NULL;
	GeeArrayList* response_list = NULL;
	GeeArrayList* _tmp0_ = NULL;
	RygelPlaySpeedRequest* _tmp1_ = NULL;
	RygelHTTPSeekRequest* _tmp4_ = NULL;
	RygelHTTPSeekRequest* _tmp32_ = NULL;
	RygelHTTPSeekRequest* _tmp33_ = NULL;
	GError * _inner_error_ = NULL;
#line 64 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self = (RygelGstDataSource*) base;
#line 67 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 67 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	response_list = _tmp0_;
#line 69 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp1_ = playspeed_request;
#line 69 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (_tmp1_ != NULL) {
#line 285 "rygel-gst-data-source.c"
		const gchar* _tmp2_ = NULL;
		GError* _tmp3_ = NULL;
#line 70 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp2_ = _ ("Playspeed not supported");
#line 70 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp3_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_PLAYSPEED_FAILED, _tmp2_);
#line 70 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_inner_error_ = _tmp3_;
#line 70 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		g_propagate_error (error, _inner_error_);
#line 70 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_g_object_unref0 (response_list);
#line 70 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		return NULL;
#line 300 "rygel-gst-data-source.c"
	}
#line 74 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp4_ = seek_request;
#line 74 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (_tmp4_ == NULL) {
#line 75 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		g_debug ("rygel-gst-data-source.vala:75: No seek requested - sending entire bina" \
"ry");
#line 308 "rygel-gst-data-source.c"
	} else {
		RygelHTTPSeekRequest* _tmp5_ = NULL;
#line 76 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp5_ = seek_request;
#line 76 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST)) {
#line 315 "rygel-gst-data-source.c"
			RygelHTTPByteSeekResponse* seek_response = NULL;
			RygelHTTPSeekRequest* _tmp6_ = NULL;
			RygelHTTPByteSeekResponse* _tmp7_ = NULL;
			RygelHTTPByteSeekResponse* _tmp8_ = NULL;
			gint64 _tmp9_ = 0LL;
			gint64 _tmp10_ = 0LL;
			RygelHTTPByteSeekResponse* _tmp11_ = NULL;
			gint64 _tmp12_ = 0LL;
			gint64 _tmp13_ = 0LL;
			RygelHTTPByteSeekResponse* _tmp14_ = NULL;
#line 77 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp6_ = seek_request;
#line 77 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp7_ = rygel_http_byte_seek_response_new_from_request (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST) ? ((RygelHTTPByteSeekRequest*) _tmp6_) : NULL);
#line 77 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			seek_response = _tmp7_;
#line 79 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp8_ = seek_response;
#line 79 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp9_ = rygel_http_byte_seek_response_get_start_byte (_tmp8_);
#line 79 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp10_ = _tmp9_;
#line 79 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp11_ = seek_response;
#line 79 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp12_ = rygel_http_byte_seek_response_get_end_byte (_tmp11_);
#line 79 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp13_ = _tmp12_;
#line 79 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			g_debug ("rygel-gst-data-source.vala:79: Processing byte seek request for bytes " \
"%lld-%lld", _tmp10_, _tmp13_);
#line 81 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp14_ = seek_response;
#line 81 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) response_list, (RygelHTTPResponseElement*) _tmp14_);
#line 76 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_g_object_unref0 (seek_response);
#line 352 "rygel-gst-data-source.c"
		} else {
			RygelHTTPSeekRequest* _tmp15_ = NULL;
#line 83 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp15_ = self->priv->seek;
#line 83 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST)) {
#line 359 "rygel-gst-data-source.c"
				RygelHTTPTimeSeekRequest* time_seek = NULL;
				RygelHTTPSeekRequest* _tmp16_ = NULL;
				RygelHTTPTimeSeekRequest* _tmp17_ = NULL;
				RygelHTTPTimeSeekResponse* seek_response = NULL;
				RygelHTTPTimeSeekRequest* _tmp18_ = NULL;
				RygelMediaResource* _tmp19_ = NULL;
				glong _tmp20_ = 0L;
				glong _tmp21_ = 0L;
				RygelHTTPTimeSeekResponse* _tmp22_ = NULL;
				RygelHTTPTimeSeekResponse* _tmp23_ = NULL;
				gint64 _tmp24_ = 0LL;
				gint64 _tmp25_ = 0LL;
				RygelHTTPTimeSeekResponse* _tmp26_ = NULL;
				gint64 _tmp27_ = 0LL;
				gint64 _tmp28_ = 0LL;
				RygelHTTPTimeSeekResponse* _tmp29_ = NULL;
#line 84 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp16_ = seek_request;
#line 84 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST) ? ((RygelHTTPTimeSeekRequest*) _tmp16_) : NULL);
#line 84 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				time_seek = _tmp17_;
#line 87 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp18_ = time_seek;
#line 87 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp19_ = self->res;
#line 87 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp20_ = rygel_media_resource_get_duration (_tmp19_);
#line 87 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp21_ = _tmp20_;
#line 87 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp22_ = rygel_http_time_seek_response_new_from_request (_tmp18_, (gint64) _tmp21_);
#line 87 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				seek_response = _tmp22_;
#line 88 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp23_ = seek_response;
#line 88 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp24_ = rygel_http_time_seek_response_get_start_time (_tmp23_);
#line 88 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp25_ = _tmp24_;
#line 88 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp26_ = seek_response;
#line 88 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp27_ = rygel_http_time_seek_response_get_end_time (_tmp26_);
#line 88 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp28_ = _tmp27_;
#line 88 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				g_debug ("rygel-gst-data-source.vala:88: Processing time seek request for %lldns" \
"-%lldns", _tmp25_, _tmp28_);
#line 90 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp29_ = seek_response;
#line 90 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) response_list, (RygelHTTPResponseElement*) _tmp29_);
#line 83 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_g_object_unref0 (seek_response);
#line 83 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_g_object_unref0 (time_seek);
#line 416 "rygel-gst-data-source.c"
			} else {
				const gchar* _tmp30_ = NULL;
				GError* _tmp31_ = NULL;
#line 93 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp30_ = _ ("HTTPSeekRequest type unsupported");
#line 93 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp31_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED, _tmp30_);
#line 93 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_inner_error_ = _tmp31_;
#line 93 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				g_propagate_error (error, _inner_error_);
#line 93 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_g_object_unref0 (response_list);
#line 93 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				return NULL;
#line 432 "rygel-gst-data-source.c"
			}
		}
	}
#line 97 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp32_ = seek_request;
#line 97 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp33_ = _g_object_ref0 (_tmp32_);
#line 97 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_g_object_unref0 (self->priv->seek);
#line 97 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self->priv->seek = _tmp33_;
#line 98 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	result = (GeeList*) response_list;
#line 98 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	return result;
#line 448 "rygel-gst-data-source.c"
}


static void rygel_gst_data_source_real_start (RygelDataSource* base, GError** error) {
	RygelGstDataSource * self;
	GstElement* _tmp0_ = NULL;
	RygelHTTPSeekRequest* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 101 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self = (RygelGstDataSource*) base;
#line 102 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp0_ = self->src;
#line 102 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	rygel_gst_data_source_prepare_pipeline (self, "RygelGstDataSource", _tmp0_, &_inner_error_);
#line 102 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 102 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		g_propagate_error (error, _inner_error_);
#line 102 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		return;
#line 469 "rygel-gst-data-source.c"
	}
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp1_ = self->priv->seek;
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (_tmp1_ != NULL) {
#line 475 "rygel-gst-data-source.c"
		GstPipeline* _tmp2_ = NULL;
#line 104 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp2_ = self->priv->pipeline;
#line 104 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		gst_element_set_state ((GstElement*) _tmp2_, GST_STATE_PAUSED);
#line 481 "rygel-gst-data-source.c"
	} else {
		GstPipeline* _tmp3_ = NULL;
#line 106 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp3_ = self->priv->pipeline;
#line 106 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		gst_element_set_state ((GstElement*) _tmp3_, GST_STATE_PLAYING);
#line 488 "rygel-gst-data-source.c"
	}
}


static void rygel_gst_data_source_real_freeze (RygelDataSource* base) {
	RygelGstDataSource * self;
	RygelGstSink* _tmp0_ = NULL;
#line 110 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self = (RygelGstDataSource*) base;
#line 111 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp0_ = self->priv->sink;
#line 111 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	rygel_gst_sink_freeze (_tmp0_);
#line 502 "rygel-gst-data-source.c"
}


static void rygel_gst_data_source_real_thaw (RygelDataSource* base) {
	RygelGstDataSource * self;
	RygelGstSink* _tmp0_ = NULL;
#line 114 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self = (RygelGstDataSource*) base;
#line 115 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp0_ = self->priv->sink;
#line 115 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	rygel_gst_sink_thaw (_tmp0_);
#line 515 "rygel-gst-data-source.c"
}


static gboolean __lambda6_ (RygelGstDataSource* self) {
	gboolean result = FALSE;
#line 126 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_signal_emit_by_name ((RygelDataSource*) self, "done");
#line 126 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	result = FALSE;
#line 126 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	return result;
#line 527 "rygel-gst-data-source.c"
}


static gboolean ___lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda6_ ((RygelGstDataSource*) self);
#line 126 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	return result;
#line 536 "rygel-gst-data-source.c"
}


static void rygel_gst_data_source_real_stop (RygelDataSource* base) {
	RygelGstDataSource * self;
	RygelGstSink* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GstPipeline* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
#line 118 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self = (RygelGstDataSource*) base;
#line 120 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp0_ = self->priv->sink;
#line 120 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp1_ = _tmp0_->cancellable;
#line 120 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_cancellable_cancel (_tmp1_);
#line 121 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp2_ = self->priv->pipeline;
#line 121 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	gst_element_set_state ((GstElement*) _tmp2_, GST_STATE_NULL);
#line 122 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp3_ = self->priv->bus_watch_id;
#line 122 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (_tmp3_ != ((guint) 0)) {
#line 562 "rygel-gst-data-source.c"
		guint _tmp4_ = 0U;
#line 123 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp4_ = self->priv->bus_watch_id;
#line 123 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		g_source_remove (_tmp4_);
#line 124 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		self->priv->bus_watch_id = (guint) 0;
#line 570 "rygel-gst-data-source.c"
	}
#line 126 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda6__gsource_func, g_object_ref (self), g_object_unref);
#line 574 "rygel-gst-data-source.c"
}


static void _rygel_gst_data_source_src_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self) {
#line 143 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	rygel_gst_data_source_src_pad_added ((RygelGstDataSource*) self, _sender, pad);
#line 581 "rygel-gst-data-source.c"
}


static gboolean _rygel_gst_data_source_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
	gboolean result;
	result = rygel_gst_data_source_bus_handler ((RygelGstDataSource*) self, bus, message);
#line 155 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	return result;
#line 590 "rygel-gst-data-source.c"
}


static void rygel_gst_data_source_prepare_pipeline (RygelGstDataSource* self, const gchar* name, GstElement* src, GError** error) {
	RygelHTTPSeekRequest* _tmp0_ = NULL;
	RygelGstSink* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GstPipeline* _tmp3_ = NULL;
	GstPipeline* _tmp4_ = NULL;
	GstPipeline* _tmp7_ = NULL;
	GstElement* _tmp8_ = NULL;
	RygelGstSink* _tmp9_ = NULL;
	GstElement* _tmp10_ = NULL;
	guint16 _tmp11_ = 0U;
	GstBus* bus = NULL;
	GstPipeline* _tmp27_ = NULL;
	GstBus* _tmp28_ = NULL;
	GstBus* _tmp29_ = NULL;
	guint _tmp30_ = 0U;
	GError * _inner_error_ = NULL;
#line 129 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_return_if_fail (self != NULL);
#line 129 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_return_if_fail (name != NULL);
#line 129 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_return_if_fail (src != NULL);
#line 131 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp0_ = self->priv->seek;
#line 131 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp1_ = rygel_gst_sink_new ((RygelDataSource*) self, _tmp0_);
#line 131 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_object_ref_sink (_tmp1_);
#line 131 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_g_object_unref0 (self->priv->sink);
#line 131 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self->priv->sink = _tmp1_;
#line 133 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp2_ = name;
#line 133 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp3_ = (GstPipeline*) gst_pipeline_new (_tmp2_);
#line 133 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_object_ref_sink (_tmp3_);
#line 133 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_g_object_unref0 (self->priv->pipeline);
#line 133 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self->priv->pipeline = _tmp3_;
#line 134 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp4_ = self->priv->pipeline;
#line 134 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (_tmp4_ == NULL) {
#line 641 "rygel-gst-data-source.c"
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
#line 135 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp5_ = _ ("Failed to create pipeline");
#line 135 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp6_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_GENERAL, _tmp5_);
#line 135 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_inner_error_ = _tmp6_;
#line 135 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		g_propagate_error (error, _inner_error_);
#line 135 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		return;
#line 654 "rygel-gst-data-source.c"
	}
#line 139 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp7_ = self->priv->pipeline;
#line 139 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp8_ = src;
#line 139 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp9_ = self->priv->sink;
#line 139 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	gst_bin_add_many ((GstBin*) _tmp7_, _tmp8_, (GstElement*) _tmp9_, NULL);
#line 141 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp10_ = src;
#line 141 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp11_ = _tmp10_->numsrcpads;
#line 141 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (((gint) _tmp11_) == 0) {
#line 670 "rygel-gst-data-source.c"
		GstElement* _tmp12_ = NULL;
#line 143 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp12_ = src;
#line 143 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		g_signal_connect_object (_tmp12_, "pad-added", (GCallback) _rygel_gst_data_source_src_pad_added_gst_element_pad_added, self, 0);
#line 676 "rygel-gst-data-source.c"
	} else {
		GstElement* _tmp13_ = NULL;
		RygelGstSink* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
#line 146 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp13_ = src;
#line 146 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp14_ = self->priv->sink;
#line 146 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp15_ = gst_element_link (_tmp13_, (GstElement*) _tmp14_);
#line 146 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		if (!_tmp15_) {
#line 689 "rygel-gst-data-source.c"
			const gchar* _tmp16_ = NULL;
			GstElement* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			RygelGstSink* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			GError* _tmp25_ = NULL;
			GError* _tmp26_ = NULL;
#line 147 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp16_ = _ ("Failed to link %s to %s");
#line 147 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp17_ = src;
#line 147 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			g_object_get ((GstObject*) _tmp17_, "name", &_tmp18_, NULL);
#line 147 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp19_ = _tmp18_;
#line 147 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp20_ = _tmp19_;
#line 147 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp21_ = self->priv->sink;
#line 147 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			g_object_get ((GstObject*) _tmp21_, "name", &_tmp22_, NULL);
#line 147 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp23_ = _tmp22_;
#line 147 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp24_ = _tmp23_;
#line 147 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp25_ = g_error_new (RYGEL_GST_ERROR, RYGEL_GST_ERROR_LINK, _tmp16_, _tmp20_, _tmp24_);
#line 147 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp26_ = _tmp25_;
#line 147 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_g_free0 (_tmp24_);
#line 147 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_g_free0 (_tmp20_);
#line 147 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_inner_error_ = _tmp26_;
#line 147 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			g_propagate_error (error, _inner_error_);
#line 147 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			return;
#line 733 "rygel-gst-data-source.c"
		}
	}
#line 154 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp27_ = self->priv->pipeline;
#line 154 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp28_ = gst_pipeline_get_bus (_tmp27_);
#line 154 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	bus = _tmp28_;
#line 155 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp29_ = bus;
#line 155 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp30_ = gst_bus_add_watch_full (_tmp29_, G_PRIORITY_DEFAULT, _rygel_gst_data_source_bus_handler_gst_bus_func, g_object_ref (self), g_object_unref);
#line 155 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self->priv->bus_watch_id = _tmp30_;
#line 129 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_g_object_unref0 (bus);
#line 750 "rygel-gst-data-source.c"
}


static void rygel_gst_data_source_src_pad_added (RygelGstDataSource* self, GstElement* src, GstPad* src_pad) {
	GstCaps* caps = NULL;
	GstPad* _tmp0_ = NULL;
	GstCaps* _tmp1_ = NULL;
	GstElement* sink = NULL;
	GstPipeline* _tmp2_ = NULL;
	GstElement* _tmp3_ = NULL;
	GstPad* sink_pad = NULL;
	GstElement* depay = NULL;
	GstCaps* _tmp4_ = NULL;
	GstElement* _tmp5_ = NULL;
	GstElement* _tmp6_ = NULL;
	GstPad* _tmp29_ = NULL;
	GstPad* _tmp30_ = NULL;
	GstPadLinkReturn _tmp31_ = 0;
	GstElement* _tmp41_ = NULL;
#line 158 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_return_if_fail (self != NULL);
#line 158 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_return_if_fail (src != NULL);
#line 158 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_return_if_fail (src_pad != NULL);
#line 159 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp0_ = src_pad;
#line 159 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp1_ = gst_pad_query_caps (_tmp0_, NULL);
#line 159 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	caps = _tmp1_;
#line 161 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp2_ = self->priv->pipeline;
#line 161 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp3_ = gst_bin_get_by_name ((GstBin*) _tmp2_, RYGEL_GST_SINK_NAME);
#line 161 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	sink = _tmp3_;
#line 164 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp4_ = caps;
#line 164 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp5_ = rygel_gst_utils_get_rtp_depayloader (_tmp4_);
#line 164 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	depay = _tmp5_;
#line 165 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp6_ = depay;
#line 165 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (_tmp6_ != NULL) {
#line 798 "rygel-gst-data-source.c"
		GstPipeline* _tmp7_ = NULL;
		GstElement* _tmp8_ = NULL;
		GstElement* _tmp9_ = NULL;
		GstElement* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		GstElement* _tmp21_ = NULL;
		GstPad* _tmp22_ = NULL;
		GstCaps* _tmp23_ = NULL;
		GstPad* _tmp24_ = NULL;
#line 166 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp7_ = self->priv->pipeline;
#line 166 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp8_ = depay;
#line 166 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		gst_bin_add ((GstBin*) _tmp7_, _tmp8_);
#line 167 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp9_ = depay;
#line 167 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp10_ = sink;
#line 167 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp11_ = gst_element_link (_tmp9_, _tmp10_);
#line 167 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		if (!_tmp11_) {
#line 822 "rygel-gst-data-source.c"
			const gchar* _tmp12_ = NULL;
			GstElement* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			GstElement* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
#line 168 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp12_ = _ ("Failed to link %s to %s");
#line 168 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp13_ = depay;
#line 168 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			g_object_get ((GstObject*) _tmp13_, "name", &_tmp14_, NULL);
#line 168 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp15_ = _tmp14_;
#line 168 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp16_ = _tmp15_;
#line 168 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp17_ = sink;
#line 168 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			g_object_get ((GstObject*) _tmp17_, "name", &_tmp18_, NULL);
#line 168 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp19_ = _tmp18_;
#line 168 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp20_ = _tmp19_;
#line 168 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			g_critical (_tmp12_, _tmp16_, _tmp20_);
#line 168 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_g_free0 (_tmp20_);
#line 168 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_g_free0 (_tmp16_);
#line 171 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			g_signal_emit_by_name ((RygelDataSource*) self, "done");
#line 173 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_g_object_unref0 (depay);
#line 173 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_g_object_unref0 (sink_pad);
#line 173 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_g_object_unref0 (sink);
#line 173 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_gst_caps_unref0 (caps);
#line 173 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			return;
#line 868 "rygel-gst-data-source.c"
		}
#line 176 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp21_ = depay;
#line 176 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp22_ = src_pad;
#line 176 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp23_ = caps;
#line 176 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp24_ = gst_element_get_compatible_pad (_tmp21_, _tmp22_, _tmp23_);
#line 176 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_g_object_unref0 (sink_pad);
#line 176 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		sink_pad = _tmp24_;
#line 882 "rygel-gst-data-source.c"
	} else {
		GstElement* _tmp25_ = NULL;
		GstPad* _tmp26_ = NULL;
		GstCaps* _tmp27_ = NULL;
		GstPad* _tmp28_ = NULL;
#line 178 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp25_ = sink;
#line 178 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp26_ = src_pad;
#line 178 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp27_ = caps;
#line 178 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp28_ = gst_element_get_compatible_pad (_tmp25_, _tmp26_, _tmp27_);
#line 178 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_g_object_unref0 (sink_pad);
#line 178 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		sink_pad = _tmp28_;
#line 900 "rygel-gst-data-source.c"
	}
#line 181 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp29_ = src_pad;
#line 181 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp30_ = sink_pad;
#line 181 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp31_ = gst_pad_link_full (_tmp29_, _tmp30_, GST_PAD_LINK_CHECK_DEFAULT);
#line 181 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (_tmp31_ != GST_PAD_LINK_OK) {
#line 910 "rygel-gst-data-source.c"
		const gchar* _tmp32_ = NULL;
		GstPad* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		GstPad* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
#line 182 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp32_ = _ ("Failed to link pad %s to %s");
#line 182 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp33_ = src_pad;
#line 182 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		g_object_get ((GstObject*) _tmp33_, "name", &_tmp34_, NULL);
#line 182 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp35_ = _tmp34_;
#line 182 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp36_ = _tmp35_;
#line 182 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp37_ = sink_pad;
#line 182 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		g_object_get ((GstObject*) _tmp37_, "name", &_tmp38_, NULL);
#line 182 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp39_ = _tmp38_;
#line 182 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp40_ = _tmp39_;
#line 182 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		g_critical (_tmp32_, _tmp36_, _tmp40_);
#line 182 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_g_free0 (_tmp40_);
#line 182 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_g_free0 (_tmp36_);
#line 185 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		g_signal_emit_by_name ((RygelDataSource*) self, "done");
#line 187 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_g_object_unref0 (depay);
#line 187 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_g_object_unref0 (sink_pad);
#line 187 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_g_object_unref0 (sink);
#line 187 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_gst_caps_unref0 (caps);
#line 187 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		return;
#line 956 "rygel-gst-data-source.c"
	}
#line 190 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp41_ = depay;
#line 190 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (_tmp41_ != NULL) {
#line 962 "rygel-gst-data-source.c"
		GstElement* _tmp42_ = NULL;
#line 191 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp42_ = depay;
#line 191 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		gst_element_sync_state_with_parent (_tmp42_);
#line 968 "rygel-gst-data-source.c"
	}
#line 158 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_g_object_unref0 (depay);
#line 158 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_g_object_unref0 (sink_pad);
#line 158 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_g_object_unref0 (sink);
#line 158 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_gst_caps_unref0 (caps);
#line 978 "rygel-gst-data-source.c"
}


static inline void _dynamic_set_streamable0 (GstElement* obj, gboolean value) {
#line 218 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_object_set (obj, "streamable", value, NULL);
#line 985 "rygel-gst-data-source.c"
}


static inline void _dynamic_set_fragment_duration1 (GstElement* obj, gint value) {
#line 219 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_object_set (obj, "fragment-duration", value, NULL);
#line 992 "rygel-gst-data-source.c"
}


static gboolean ___lambda5_ (RygelGstDataSource* self) {
	gboolean result = FALSE;
#line 252 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_signal_emit_by_name ((RygelDataSource*) self, "done");
#line 254 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	result = FALSE;
#line 254 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	return result;
#line 1004 "rygel-gst-data-source.c"
}


static gboolean ____lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda5_ ((RygelGstDataSource*) self);
#line 251 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	return result;
#line 1013 "rygel-gst-data-source.c"
}


static gboolean rygel_gst_data_source_bus_handler (RygelGstDataSource* self, GstBus* bus, GstMessage* message) {
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GstMessage* _tmp0_ = NULL;
	GstMessageType _tmp1_ = 0;
	gboolean _tmp50_ = FALSE;
#line 195 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 195 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_return_val_if_fail (bus != NULL, FALSE);
#line 195 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_return_val_if_fail (message != NULL, FALSE);
#line 196 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	ret = TRUE;
#line 198 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp0_ = message;
#line 198 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp1_ = _tmp0_->type;
#line 198 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (_tmp1_ == GST_MESSAGE_EOS) {
#line 199 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		ret = FALSE;
#line 1039 "rygel-gst-data-source.c"
	} else {
		GstMessage* _tmp2_ = NULL;
		GstMessageType _tmp3_ = 0;
#line 200 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp2_ = message;
#line 200 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp3_ = _tmp2_->type;
#line 200 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		if (_tmp3_ == GST_MESSAGE_STATE_CHANGED) {
#line 1049 "rygel-gst-data-source.c"
			GstMessage* _tmp4_ = NULL;
			GstObject* _tmp5_ = NULL;
			GstPipeline* _tmp6_ = NULL;
			GstState old_state = 0;
			GstState new_state = 0;
			GstMessage* _tmp7_ = NULL;
			GstState _tmp8_ = 0;
			GstState _tmp9_ = 0;
			gboolean _tmp10_ = FALSE;
			GstState _tmp11_ = 0;
			RygelHTTPSeekRequest* _tmp22_ = NULL;
#line 201 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp4_ = message;
#line 201 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp5_ = _tmp4_->src;
#line 201 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp6_ = self->priv->pipeline;
#line 201 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			if (_tmp5_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gst_object_get_type (), GstObject)) {
#line 202 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				result = TRUE;
#line 202 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				return result;
#line 1073 "rygel-gst-data-source.c"
			}
#line 208 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp7_ = message;
#line 208 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			gst_message_parse_state_changed (_tmp7_, &_tmp8_, &_tmp9_, NULL);
#line 208 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			old_state = _tmp8_;
#line 208 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			new_state = _tmp9_;
#line 212 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp11_ = old_state;
#line 212 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			if (_tmp11_ == GST_STATE_NULL) {
#line 1087 "rygel-gst-data-source.c"
				GstState _tmp12_ = 0;
#line 212 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp12_ = new_state;
#line 212 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp10_ = _tmp12_ == GST_STATE_READY;
#line 1093 "rygel-gst-data-source.c"
			} else {
#line 212 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp10_ = FALSE;
#line 1097 "rygel-gst-data-source.c"
			}
#line 212 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			if (_tmp10_) {
#line 1101 "rygel-gst-data-source.c"
				GstElement* element = NULL;
				GstPipeline* _tmp13_ = NULL;
				GstElement* _tmp14_ = NULL;
				GstElement* _tmp15_ = NULL;
#line 213 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp13_ = self->priv->pipeline;
#line 213 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp14_ = gst_bin_get_by_name ((GstBin*) _tmp13_, "muxer");
#line 213 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				element = _tmp14_;
#line 214 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp15_ = element;
#line 214 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				if (_tmp15_ != NULL) {
#line 1116 "rygel-gst-data-source.c"
					gchar* name = NULL;
					GstElement* _tmp16_ = NULL;
					GstElementFactory* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
#line 215 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_tmp16_ = element;
#line 215 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_tmp17_ = gst_element_get_factory (_tmp16_);
#line 215 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_tmp18_ = gst_object_get_name ((GstObject*) _tmp17_);
#line 215 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					name = _tmp18_;
#line 217 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_tmp19_ = name;
#line 217 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					if (g_strcmp0 (_tmp19_, "mp4mux") == 0) {
#line 1134 "rygel-gst-data-source.c"
						GstElement* _tmp20_ = NULL;
						GstElement* _tmp21_ = NULL;
#line 218 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
						_tmp20_ = element;
#line 218 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
						_dynamic_set_streamable0 (_tmp20_, TRUE);
#line 219 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
						_tmp21_ = element;
#line 219 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
						_dynamic_set_fragment_duration1 (_tmp21_, 1000);
#line 1145 "rygel-gst-data-source.c"
					}
#line 214 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_g_free0 (name);
#line 1149 "rygel-gst-data-source.c"
				}
#line 212 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_g_object_unref0 (element);
#line 1153 "rygel-gst-data-source.c"
			}
#line 224 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp22_ = self->priv->seek;
#line 224 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			if (_tmp22_ != NULL) {
#line 1159 "rygel-gst-data-source.c"
				gboolean _tmp23_ = FALSE;
				GstState _tmp24_ = 0;
#line 225 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp24_ = old_state;
#line 225 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				if (_tmp24_ == GST_STATE_READY) {
#line 1166 "rygel-gst-data-source.c"
					GstState _tmp25_ = 0;
#line 225 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_tmp25_ = new_state;
#line 225 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_tmp23_ = _tmp25_ == GST_STATE_PAUSED;
#line 1172 "rygel-gst-data-source.c"
				} else {
#line 225 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_tmp23_ = FALSE;
#line 1176 "rygel-gst-data-source.c"
				}
#line 225 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				if (_tmp23_) {
#line 1180 "rygel-gst-data-source.c"
					gboolean _tmp26_ = FALSE;
#line 226 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_tmp26_ = rygel_gst_data_source_perform_seek (self);
#line 226 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					if (_tmp26_) {
#line 1186 "rygel-gst-data-source.c"
						GstPipeline* _tmp27_ = NULL;
#line 227 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
						_tmp27_ = self->priv->pipeline;
#line 227 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
						gst_element_set_state ((GstElement*) _tmp27_, GST_STATE_PLAYING);
#line 1192 "rygel-gst-data-source.c"
					}
				}
			}
		} else {
			GError* err = NULL;
			gchar* err_msg = NULL;
			GstMessage* _tmp28_ = NULL;
			GstMessageType _tmp29_ = 0;
#line 235 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp28_ = message;
#line 235 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp29_ = _tmp28_->type;
#line 235 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			if (_tmp29_ == GST_MESSAGE_ERROR) {
#line 1207 "rygel-gst-data-source.c"
				GstMessage* _tmp30_ = NULL;
				GError* _tmp31_ = NULL;
				gchar* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
				GstPipeline* _tmp34_ = NULL;
				gchar* _tmp35_ = NULL;
				gchar* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				const gchar* _tmp38_ = NULL;
#line 236 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp30_ = message;
#line 236 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				gst_message_parse_error (_tmp30_, &_tmp31_, &_tmp32_);
#line 236 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_g_error_free0 (err);
#line 236 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				err = _tmp31_;
#line 236 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_g_free0 (err_msg);
#line 236 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				err_msg = _tmp32_;
#line 237 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp33_ = _ ("Error from pipeline %s: %s");
#line 237 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp34_ = self->priv->pipeline;
#line 237 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				g_object_get ((GstObject*) _tmp34_, "name", &_tmp35_, NULL);
#line 237 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp36_ = _tmp35_;
#line 237 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp37_ = _tmp36_;
#line 237 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp38_ = err_msg;
#line 237 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				g_critical (_tmp33_, _tmp37_, _tmp38_);
#line 237 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_g_free0 (_tmp37_);
#line 241 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				ret = FALSE;
#line 1247 "rygel-gst-data-source.c"
			} else {
				GstMessage* _tmp39_ = NULL;
				GstMessageType _tmp40_ = 0;
#line 242 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp39_ = message;
#line 242 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp40_ = _tmp39_->type;
#line 242 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				if (_tmp40_ == GST_MESSAGE_WARNING) {
#line 1257 "rygel-gst-data-source.c"
					GstMessage* _tmp41_ = NULL;
					GError* _tmp42_ = NULL;
					gchar* _tmp43_ = NULL;
					const gchar* _tmp44_ = NULL;
					GstPipeline* _tmp45_ = NULL;
					gchar* _tmp46_ = NULL;
					gchar* _tmp47_ = NULL;
					gchar* _tmp48_ = NULL;
					const gchar* _tmp49_ = NULL;
#line 243 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_tmp41_ = message;
#line 243 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					gst_message_parse_warning (_tmp41_, &_tmp42_, &_tmp43_);
#line 243 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_g_error_free0 (err);
#line 243 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					err = _tmp42_;
#line 243 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_g_free0 (err_msg);
#line 243 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					err_msg = _tmp43_;
#line 244 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_tmp44_ = _ ("Warning from pipeline %s: %s");
#line 244 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_tmp45_ = self->priv->pipeline;
#line 244 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					g_object_get ((GstObject*) _tmp45_, "name", &_tmp46_, NULL);
#line 244 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_tmp47_ = _tmp46_;
#line 244 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_tmp48_ = _tmp47_;
#line 244 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_tmp49_ = err_msg;
#line 244 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					g_warning (_tmp44_, _tmp48_, _tmp49_);
#line 244 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_g_free0 (_tmp48_);
#line 1295 "rygel-gst-data-source.c"
				}
			}
#line 200 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_g_free0 (err_msg);
#line 200 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_g_error_free0 (err);
#line 1302 "rygel-gst-data-source.c"
		}
	}
#line 250 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp50_ = ret;
#line 250 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (!_tmp50_) {
#line 251 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		g_idle_add_full (G_PRIORITY_DEFAULT, ____lambda5__gsource_func, g_object_ref (self), g_object_unref);
#line 257 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		self->priv->bus_watch_id = (guint) 0;
#line 1313 "rygel-gst-data-source.c"
	}
#line 260 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	result = ret;
#line 260 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	return result;
#line 1319 "rygel-gst-data-source.c"
}


static gboolean rygel_gst_data_source_perform_seek (RygelGstDataSource* self) {
	gboolean result = FALSE;
	GstSeekType stop_type = 0;
	GstFormat format = 0;
	GstSeekFlags flags = 0;
	gint64 start = 0LL;
	gint64 stop = 0LL;
	RygelHTTPSeekRequest* _tmp0_ = NULL;
	gint64 _tmp31_ = 0LL;
	GstPipeline* _tmp32_ = NULL;
	GstFormat _tmp33_ = 0;
	GstSeekFlags _tmp34_ = 0;
	gint64 _tmp35_ = 0LL;
	GstSeekType _tmp36_ = 0;
	gint64 _tmp37_ = 0LL;
	gboolean _tmp38_ = FALSE;
#line 263 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 264 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	stop_type = GST_SEEK_TYPE_NONE;
#line 266 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	flags = GST_SEEK_FLAG_FLUSH;
#line 269 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp0_ = self->priv->seek;
#line 269 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST)) {
#line 1349 "rygel-gst-data-source.c"
		RygelHTTPTimeSeekRequest* time_seek = NULL;
		RygelHTTPSeekRequest* _tmp1_ = NULL;
		RygelHTTPTimeSeekRequest* _tmp2_ = NULL;
		GstSeekFlags _tmp3_ = 0;
		RygelHTTPTimeSeekRequest* _tmp4_ = NULL;
		gint64 _tmp5_ = 0LL;
		RygelHTTPTimeSeekRequest* _tmp6_ = NULL;
		gint64 _tmp7_ = 0LL;
		gint64 _tmp8_ = 0LL;
		gint64 _tmp9_ = 0LL;
#line 270 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp1_ = self->priv->seek;
#line 270 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST) ? ((RygelHTTPTimeSeekRequest*) _tmp1_) : NULL);
#line 270 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		time_seek = _tmp2_;
#line 271 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		format = GST_FORMAT_TIME;
#line 272 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp3_ = flags;
#line 272 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		flags = _tmp3_ | GST_SEEK_FLAG_KEY_UNIT;
#line 273 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp4_ = time_seek;
#line 273 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp5_ = _tmp4_->start_time;
#line 273 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		start = _tmp5_ * GST_USECOND;
#line 274 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp6_ = time_seek;
#line 274 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp7_ = _tmp6_->end_time;
#line 274 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		stop = _tmp7_ * GST_USECOND;
#line 275 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp8_ = start;
#line 275 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp9_ = stop;
#line 275 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		g_debug ("rygel-gst-data-source.vala:275: Performing time-range seek: %lldns to " \
"%lldns", _tmp8_, _tmp9_);
#line 269 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_g_object_unref0 (time_seek);
#line 1392 "rygel-gst-data-source.c"
	} else {
		RygelHTTPSeekRequest* _tmp10_ = NULL;
#line 276 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp10_ = self->priv->seek;
#line 276 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST)) {
#line 1399 "rygel-gst-data-source.c"
			RygelHTTPByteSeekRequest* byte_seek = NULL;
			RygelHTTPSeekRequest* _tmp11_ = NULL;
			RygelHTTPByteSeekRequest* _tmp12_ = NULL;
			RygelHTTPByteSeekRequest* _tmp13_ = NULL;
			gint64 _tmp14_ = 0LL;
			gint64 _tmp15_ = 0LL;
			RygelHTTPByteSeekRequest* _tmp16_ = NULL;
			gint64 _tmp17_ = 0LL;
			gint64 _tmp18_ = 0LL;
			GstSeekFlags _tmp19_ = 0;
			RygelHTTPByteSeekRequest* _tmp20_ = NULL;
			gint64 _tmp21_ = 0LL;
			gint64 _tmp22_ = 0LL;
			RygelHTTPByteSeekRequest* _tmp23_ = NULL;
			gint64 _tmp24_ = 0LL;
			gint64 _tmp25_ = 0LL;
			gint64 _tmp26_ = 0LL;
			gint64 _tmp27_ = 0LL;
#line 277 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp11_ = self->priv->seek;
#line 277 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST) ? ((RygelHTTPByteSeekRequest*) _tmp11_) : NULL);
#line 277 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			byte_seek = _tmp12_;
#line 278 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp13_ = byte_seek;
#line 278 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp14_ = rygel_http_byte_seek_request_get_range_length (_tmp13_);
#line 278 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp15_ = _tmp14_;
#line 278 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp16_ = byte_seek;
#line 278 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp17_ = rygel_http_byte_seek_request_get_total_size (_tmp16_);
#line 278 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp18_ = _tmp17_;
#line 278 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			if (_tmp15_ >= _tmp18_) {
#line 280 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				result = TRUE;
#line 280 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_g_object_unref0 (byte_seek);
#line 280 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				return result;
#line 1444 "rygel-gst-data-source.c"
			}
#line 282 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			format = GST_FORMAT_BYTES;
#line 283 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp19_ = flags;
#line 283 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			flags = _tmp19_ | GST_SEEK_FLAG_ACCURATE;
#line 284 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp20_ = byte_seek;
#line 284 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp21_ = rygel_http_byte_seek_request_get_start_byte (_tmp20_);
#line 284 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp22_ = _tmp21_;
#line 284 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			start = _tmp22_;
#line 285 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp23_ = byte_seek;
#line 285 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp24_ = rygel_http_byte_seek_request_get_end_byte (_tmp23_);
#line 285 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp25_ = _tmp24_;
#line 285 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			stop = _tmp25_;
#line 286 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp26_ = start;
#line 286 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp27_ = stop;
#line 286 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			g_debug ("rygel-gst-data-source.vala:286: Performing byte-range seek: bytes %lld" \
" to %lld", _tmp26_, _tmp27_);
#line 276 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_g_object_unref0 (byte_seek);
#line 1476 "rygel-gst-data-source.c"
		} else {
			const gchar* _tmp28_ = NULL;
			GError* _tmp29_ = NULL;
			GError* _tmp30_ = NULL;
#line 288 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp28_ = _ ("Unsupported seek type");
#line 288 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp29_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED, _tmp28_);
#line 288 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp30_ = _tmp29_;
#line 288 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			g_signal_emit_by_name ((RygelDataSource*) self, "error", _tmp30_);
#line 288 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_g_error_free0 (_tmp30_);
#line 289 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			result = FALSE;
#line 289 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			return result;
#line 1495 "rygel-gst-data-source.c"
		}
	}
#line 292 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp31_ = stop;
#line 292 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (_tmp31_ > ((gint64) 0)) {
#line 293 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		stop_type = GST_SEEK_TYPE_SET;
#line 1504 "rygel-gst-data-source.c"
	}
#line 296 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp32_ = self->priv->pipeline;
#line 296 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp33_ = format;
#line 296 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp34_ = flags;
#line 296 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp35_ = start;
#line 296 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp36_ = stop_type;
#line 296 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp37_ = stop;
#line 296 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp38_ = gst_element_seek ((GstElement*) _tmp32_, 1.0, _tmp33_, _tmp34_, GST_SEEK_TYPE_SET, _tmp35_, _tmp36_, _tmp37_ + 1);
#line 296 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (!_tmp38_) {
#line 1522 "rygel-gst-data-source.c"
		const gchar* _tmp39_ = NULL;
		gint64 _tmp40_ = 0LL;
		gint64 _tmp41_ = 0LL;
		const gchar* _tmp42_ = NULL;
		GError* _tmp43_ = NULL;
		GError* _tmp44_ = NULL;
#line 303 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp39_ = _ ("Failed to seek to offsets %lld:%lld");
#line 303 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp40_ = start;
#line 303 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp41_ = stop;
#line 303 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		g_warning (_tmp39_, _tmp40_, _tmp41_);
#line 306 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp42_ = _ ("Failed to seek");
#line 306 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp43_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED, _tmp42_);
#line 306 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp44_ = _tmp43_;
#line 306 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		g_signal_emit_by_name ((RygelDataSource*) self, "error", _tmp44_);
#line 306 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_g_error_free0 (_tmp44_);
#line 308 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		result = FALSE;
#line 308 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		return result;
#line 1551 "rygel-gst-data-source.c"
	}
#line 311 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	result = TRUE;
#line 311 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	return result;
#line 1557 "rygel-gst-data-source.c"
}


static void rygel_gst_data_source_class_init (RygelGstDataSourceClass * klass) {
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	rygel_gst_data_source_parent_class = g_type_class_peek_parent (klass);
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_type_class_add_private (klass, sizeof (RygelGstDataSourcePrivate));
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_gst_data_source_finalize;
#line 1568 "rygel-gst-data-source.c"
}


static void rygel_gst_data_source_rygel_data_source_interface_init (RygelDataSourceIface * iface) {
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	rygel_gst_data_source_rygel_data_source_parent_iface = g_type_interface_peek_parent (iface);
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	iface->preroll = (GeeList* (*)(RygelDataSource*, RygelHTTPSeekRequest*, RygelPlaySpeedRequest*, GError**)) rygel_gst_data_source_real_preroll;
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	iface->start = (void (*)(RygelDataSource*, GError**)) rygel_gst_data_source_real_start;
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	iface->freeze = (void (*)(RygelDataSource*)) rygel_gst_data_source_real_freeze;
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	iface->thaw = (void (*)(RygelDataSource*)) rygel_gst_data_source_real_thaw;
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	iface->stop = (void (*)(RygelDataSource*)) rygel_gst_data_source_real_stop;
#line 1585 "rygel-gst-data-source.c"
}


static void rygel_gst_data_source_instance_init (RygelGstDataSource * self) {
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self->priv = RYGEL_GST_DATA_SOURCE_GET_PRIVATE (self);
#line 36 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self->priv->seek = NULL;
#line 1594 "rygel-gst-data-source.c"
}


static void rygel_gst_data_source_finalize (GObject* obj) {
	RygelGstDataSource * self;
	RygelGstSink* _tmp0_ = NULL;
	GstPipeline* _tmp3_ = NULL;
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSource);
#line 51 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp0_ = self->priv->sink;
#line 51 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (_tmp0_ != NULL) {
#line 1608 "rygel-gst-data-source.c"
		RygelGstSink* _tmp1_ = NULL;
		GCancellable* _tmp2_ = NULL;
#line 52 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp1_ = self->priv->sink;
#line 52 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp2_ = _tmp1_->cancellable;
#line 52 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		g_cancellable_cancel (_tmp2_);
#line 1617 "rygel-gst-data-source.c"
	}
#line 55 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp3_ = self->priv->pipeline;
#line 55 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (_tmp3_ != NULL) {
#line 1623 "rygel-gst-data-source.c"
		GstPipeline* _tmp4_ = NULL;
#line 56 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp4_ = self->priv->pipeline;
#line 56 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		gst_element_set_state ((GstElement*) _tmp4_, GST_STATE_NULL);
#line 1629 "rygel-gst-data-source.c"
	}
#line 33 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_g_object_unref0 (self->src);
#line 34 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_g_object_unref0 (self->res);
#line 35 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_g_object_unref0 (self->priv->pipeline);
#line 36 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_g_object_unref0 (self->priv->seek);
#line 37 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_g_object_unref0 (self->priv->sink);
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	G_OBJECT_CLASS (rygel_gst_data_source_parent_class)->finalize (obj);
#line 1643 "rygel-gst-data-source.c"
}


GType rygel_gst_data_source_get_type (void) {
	static volatile gsize rygel_gst_data_source_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_gst_data_source_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelGstDataSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_gst_data_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelGstDataSource), 0, (GInstanceInitFunc) rygel_gst_data_source_instance_init, NULL };
		static const GInterfaceInfo rygel_data_source_info = { (GInterfaceInitFunc) rygel_gst_data_source_rygel_data_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_gst_data_source_type_id;
		rygel_gst_data_source_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelGstDataSource", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_gst_data_source_type_id, RYGEL_TYPE_DATA_SOURCE, &rygel_data_source_info);
		g_once_init_leave (&rygel_gst_data_source_type_id__volatile, rygel_gst_data_source_type_id);
	}
	return rygel_gst_data_source_type_id__volatile;
}



