/* rygel-gst-transcoder.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-gst-transcoder.vala, do not modify */

/*
 * Copyright (C) 2009-2012 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Prasanna Modem <prasanna@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <gst/pbutils/pbutils.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <libgupnp-av/gupnp-av.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>


#define RYGEL_TYPE_GST_TRANSCODER (rygel_gst_transcoder_get_type ())
#define RYGEL_GST_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoder))
#define RYGEL_GST_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoderClass))
#define RYGEL_IS_GST_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_TRANSCODER))
#define RYGEL_IS_GST_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_TRANSCODER))
#define RYGEL_GST_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoderClass))

typedef struct _RygelGstTranscoder RygelGstTranscoder;
typedef struct _RygelGstTranscoderClass RygelGstTranscoderClass;
typedef struct _RygelGstTranscoderPrivate RygelGstTranscoderPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_GST_DATA_SOURCE (rygel_gst_data_source_get_type ())
#define RYGEL_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSource))
#define RYGEL_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourceClass))
#define RYGEL_IS_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_DATA_SOURCE))
#define RYGEL_IS_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_DATA_SOURCE))
#define RYGEL_GST_DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourceClass))

typedef struct _RygelGstDataSource RygelGstDataSource;
typedef struct _RygelGstDataSourceClass RygelGstDataSourceClass;
typedef struct _RygelGstDataSourcePrivate RygelGstDataSourcePrivate;
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _gst_message_unref0(var) ((var == NULL) ? NULL : (var = (gst_message_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	RYGEL_GST_TRANSCODER_ERROR_CANT_TRANSCODE
} RygelGstTranscoderError;
#define RYGEL_GST_TRANSCODER_ERROR rygel_gst_transcoder_error_quark ()
struct _RygelGstTranscoder {
	GObject parent_instance;
	RygelGstTranscoderPrivate * priv;
};

struct _RygelGstTranscoderClass {
	GObjectClass parent_class;
	RygelMediaResource* (*get_resource_for_item) (RygelGstTranscoder* self, RygelMediaFileItem* item);
	guint (*get_distance) (RygelGstTranscoder* self, RygelMediaFileItem* item);
	GstEncodingProfile* (*get_encoding_profile) (RygelGstTranscoder* self);
};

struct _RygelGstTranscoderPrivate {
	gchar* _name;
	gchar* _mime_type;
	gchar* _dlna_profile;
	gchar* _extension;
	gchar* _preset;
	GstElement* decoder;
	GstElement* encoder;
	gboolean link_failed;
};

struct _RygelGstDataSource {
	GObject parent_instance;
	RygelGstDataSourcePrivate * priv;
	GstElement* src;
	RygelMediaResource* res;
};

struct _RygelGstDataSourceClass {
	GObjectClass parent_class;
};


static gpointer rygel_gst_transcoder_parent_class = NULL;

GQuark rygel_gst_transcoder_error_quark (void);
GType rygel_gst_transcoder_get_type (void) G_GNUC_CONST;
#define RYGEL_GST_TRANSCODER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoderPrivate))
enum  {
	RYGEL_GST_TRANSCODER_DUMMY_PROPERTY,
	RYGEL_GST_TRANSCODER_NAME,
	RYGEL_GST_TRANSCODER_MIME_TYPE,
	RYGEL_GST_TRANSCODER_DLNA_PROFILE,
	RYGEL_GST_TRANSCODER_EXTENSION,
	RYGEL_GST_TRANSCODER_PRESET
};
#define RYGEL_GST_TRANSCODER_DEFAULT_ENCODING_PRESET "Rygel DLNA preset"
#define RYGEL_GST_TRANSCODER_DECODE_BIN "decodebin"
#define RYGEL_GST_TRANSCODER_ENCODE_BIN "encodebin"
#define RYGEL_GST_TRANSCODER_DESCRIPTION "Encoder and decoder are not " "compatible"
RygelGstTranscoder* rygel_gst_transcoder_construct (GType object_type, const gchar* name, const gchar* mime_type, const gchar* dlna_profile, const gchar* extension);
static void rygel_gst_transcoder_real_constructed (GObject* base);
RygelMediaResource* rygel_gst_transcoder_get_resource_for_item (RygelGstTranscoder* self, RygelMediaFileItem* item);
static RygelMediaResource* rygel_gst_transcoder_real_get_resource_for_item (RygelGstTranscoder* self, RygelMediaFileItem* item);
const gchar* rygel_gst_transcoder_get_name (RygelGstTranscoder* self);
const gchar* rygel_gst_transcoder_get_mime_type (RygelGstTranscoder* self);
const gchar* rygel_gst_transcoder_get_dlna_profile (RygelGstTranscoder* self);
const gchar* rygel_gst_transcoder_get_extension (RygelGstTranscoder* self);
guint rygel_gst_transcoder_get_distance (RygelGstTranscoder* self, RygelMediaFileItem* item);
static guint rygel_gst_transcoder_real_get_distance (RygelGstTranscoder* self, RygelMediaFileItem* item);
RygelDataSource* rygel_gst_transcoder_create_source (RygelGstTranscoder* self, RygelMediaFileItem* item, RygelDataSource* src, GError** error);
GType rygel_gst_data_source_get_type (void) G_GNUC_CONST;
GstElement* rygel_gst_utils_create_element (const gchar* factoryname, const gchar* name, GError** error);
GstEncodingProfile* rygel_gst_transcoder_get_encoding_profile (RygelGstTranscoder* self);
static inline void _dynamic_set_profile2 (GstElement* obj, GstEncodingProfile* value);
static inline GstElement* _dynamic_get_profile3 (GstElement* obj);
void rygel_gst_utils_dump_encoding_profile (GstEncodingProfile* profile, gint indent);
static inline GstEncodingProfile* _dynamic_get_profile4 (GstElement* obj);
static void rygel_gst_transcoder_on_decoder_pad_added (RygelGstTranscoder* self, GstElement* decodebin, GstPad* new_pad);
static void _rygel_gst_transcoder_on_decoder_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self);
static gboolean rygel_gst_transcoder_on_autoplug_continue (RygelGstTranscoder* self, GstElement* decodebin, GstPad* new_pad, GstCaps* caps);
static gboolean _rygel_gst_transcoder_on_autoplug_continue_dynamic_autoplug_continue0_ (GstElement* _sender, GstPad* new_pad, GstCaps* caps, gpointer self);
static void g_cclosure_user_marshal_BOOLEAN__OBJECT_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
gulong _dynamic_autoplug_continue1_connect (gpointer obj, const char * signal_name, GCallback handler, gpointer data);
static void rygel_gst_transcoder_on_no_more_pads (RygelGstTranscoder* self, GstElement* decodebin);
static void _rygel_gst_transcoder_on_no_more_pads_gst_element_no_more_pads (GstElement* _sender, gpointer self);
RygelGstDataSource* rygel_gst_data_source_new_from_element (GstElement* element);
RygelGstDataSource* rygel_gst_data_source_construct_from_element (GType object_type, GstElement* element);
static GstEncodingProfile* rygel_gst_transcoder_real_get_encoding_profile (RygelGstTranscoder* self);
static void rygel_gst_transcoder_set_name (RygelGstTranscoder* self, const gchar* value);
static void rygel_gst_transcoder_set_mime_type (RygelGstTranscoder* self, const gchar* value);
static void rygel_gst_transcoder_set_dlna_profile (RygelGstTranscoder* self, const gchar* value);
static void rygel_gst_transcoder_set_extension (RygelGstTranscoder* self, const gchar* value);
const gchar* rygel_gst_transcoder_get_preset (RygelGstTranscoder* self);
void rygel_gst_transcoder_set_preset (RygelGstTranscoder* self, const gchar* value);
static void rygel_gst_transcoder_finalize (GObject* obj);
static void _vala_rygel_gst_transcoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_gst_transcoder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark rygel_gst_transcoder_error_quark (void) {
	return g_quark_from_static_string ("rygel_gst_transcoder_error-quark");
}


RygelGstTranscoder* rygel_gst_transcoder_construct (GType object_type, const gchar* name, const gchar* mime_type, const gchar* dlna_profile, const gchar* extension) {
	RygelGstTranscoder * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 60 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 60 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (mime_type != NULL, NULL);
#line 60 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (dlna_profile != NULL, NULL);
#line 60 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (extension != NULL, NULL);
#line 64 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp0_ = name;
#line 64 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp1_ = mime_type;
#line 64 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp2_ = dlna_profile;
#line 64 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp3_ = extension;
#line 64 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	self = (RygelGstTranscoder*) g_object_new (object_type, "name", _tmp0_, "mime-type", _tmp1_, "dlna-profile", _tmp2_, "extension", _tmp3_, NULL);
#line 60 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return self;
#line 202 "rygel-gst-transcoder.c"
}


static void rygel_gst_transcoder_real_constructed (GObject* base) {
	RygelGstTranscoder * self;
#line 70 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	self = (RygelGstTranscoder*) base;
#line 71 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	G_OBJECT_CLASS (rygel_gst_transcoder_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
#line 73 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	self->priv->link_failed = TRUE;
#line 214 "rygel-gst-transcoder.c"
}


/**
     * Get the supported (transcoded) MediaResource for the given content item
     *
     * @return A MediaResources or null if the transcoder cannot
     * transcode this media item
     */
static RygelMediaResource* rygel_gst_transcoder_real_get_resource_for_item (RygelGstTranscoder* self, RygelMediaFileItem* item) {
	RygelMediaResource* result = NULL;
	RygelMediaResource* res = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaResource* _tmp1_ = NULL;
	RygelMediaResource* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	RygelMediaResource* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	RygelMediaResource* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	RygelMediaResource* _tmp8_ = NULL;
	RygelMediaResource* _tmp9_ = NULL;
	RygelMediaResource* _tmp10_ = NULL;
	RygelMediaFileItem* _tmp11_ = NULL;
#line 82 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 83 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp0_ = self->priv->_name;
#line 83 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp1_ = rygel_media_resource_new (_tmp0_);
#line 83 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	res = _tmp1_;
#line 85 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp2_ = res;
#line 85 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp3_ = self->priv->_mime_type;
#line 85 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	rygel_media_resource_set_mime_type (_tmp2_, _tmp3_);
#line 86 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp4_ = res;
#line 86 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp5_ = self->priv->_dlna_profile;
#line 86 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	rygel_media_resource_set_dlna_profile (_tmp4_, _tmp5_);
#line 87 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp6_ = res;
#line 87 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp7_ = self->priv->_extension;
#line 87 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	rygel_media_resource_set_extension (_tmp6_, _tmp7_);
#line 88 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp8_ = res;
#line 88 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	rygel_media_resource_set_dlna_conversion (_tmp8_, GUPNP_DLNA_CONVERSION_TRANSCODED);
#line 89 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp9_ = res;
#line 89 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	rygel_media_resource_set_dlna_flags (_tmp9_, ((GUPNP_DLNA_FLAGS_DLNA_V15 | GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE) | GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE) | GUPNP_DLNA_FLAGS_CONNECTION_STALL);
#line 94 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp10_ = res;
#line 94 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	rygel_media_resource_set_dlna_operation (_tmp10_, GUPNP_DLNA_OPERATION_TIMESEEK);
#line 97 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp11_ = item;
#line 97 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, RYGEL_TYPE_AUDIO_ITEM)) {
#line 281 "rygel-gst-transcoder.c"
		RygelMediaResource* _tmp12_ = NULL;
		RygelMediaFileItem* _tmp13_ = NULL;
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 98 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp12_ = res;
#line 98 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp13_ = item;
#line 98 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp14_ = rygel_audio_item_get_duration (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp13_) : NULL);
#line 98 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp15_ = _tmp14_;
#line 98 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		rygel_media_resource_set_duration (_tmp12_, _tmp15_);
#line 296 "rygel-gst-transcoder.c"
	}
#line 101 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	result = res;
#line 101 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return result;
#line 302 "rygel-gst-transcoder.c"
}


RygelMediaResource* rygel_gst_transcoder_get_resource_for_item (RygelGstTranscoder* self, RygelMediaFileItem* item) {
#line 82 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 82 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return RYGEL_GST_TRANSCODER_GET_CLASS (self)->get_resource_for_item (self, item);
#line 311 "rygel-gst-transcoder.c"
}


/**
     * Gets a numeric value that gives an gives an estimate of how hard
     * it would be for this transcoder to trancode @item to the target profile of
     * this transcoder.
     *
     * @param item the media item to calculate the distance for
     *
     * @return      the distance from the @item, uint.MIN if providing such a
     *              value is impossible or uint.MAX if it doesn't make any
     *              sense to use this transcoder for @item
     */
static guint rygel_gst_transcoder_real_get_distance (RygelGstTranscoder* self, RygelMediaFileItem* item) {
#line 115 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_critical ("Type `%s' does not implement abstract method `rygel_gst_transcoder_get_distance'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 115 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return 0U;
#line 331 "rygel-gst-transcoder.c"
}


guint rygel_gst_transcoder_get_distance (RygelGstTranscoder* self, RygelMediaFileItem* item) {
#line 115 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 115 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return RYGEL_GST_TRANSCODER_GET_CLASS (self)->get_distance (self, item);
#line 340 "rygel-gst-transcoder.c"
}


/**
     * Creates a transcoding source.
     *
     * @param src the media item to create the transcoding source for
     * @param src the original (non-transcoding) source
     *
     * @return      the new transcoding source
     */
static gpointer _g_object_ref0 (gpointer self) {
#line 129 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return self ? g_object_ref (self) : NULL;
#line 355 "rygel-gst-transcoder.c"
}


static inline void _dynamic_set_profile2 (GstElement* obj, GstEncodingProfile* value) {
#line 136 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_object_set (obj, "profile", value, NULL);
#line 362 "rygel-gst-transcoder.c"
}


static inline GstElement* _dynamic_get_profile3 (GstElement* obj) {
	GstElement* result;
#line 137 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_object_get (obj, "profile", &result, NULL);
#line 137 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return result;
#line 372 "rygel-gst-transcoder.c"
}


static inline GstEncodingProfile* _dynamic_get_profile4 (GstElement* obj) {
	GstEncodingProfile* result;
#line 145 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_object_get (obj, "profile", &result, NULL);
#line 145 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return result;
#line 382 "rygel-gst-transcoder.c"
}


static void _rygel_gst_transcoder_on_decoder_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self) {
#line 152 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	rygel_gst_transcoder_on_decoder_pad_added ((RygelGstTranscoder*) self, _sender, pad);
#line 389 "rygel-gst-transcoder.c"
}


static gboolean _rygel_gst_transcoder_on_autoplug_continue_dynamic_autoplug_continue0_ (GstElement* _sender, GstPad* new_pad, GstCaps* caps, gpointer self) {
	gboolean result;
	result = rygel_gst_transcoder_on_autoplug_continue ((RygelGstTranscoder*) self, _sender, new_pad, caps);
#line 153 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return result;
#line 398 "rygel-gst-transcoder.c"
}


static void g_cclosure_user_marshal_BOOLEAN__OBJECT_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__OBJECT_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_BOOLEAN__OBJECT_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
#line 153 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_if_fail (return_value != NULL);
#line 153 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_if_fail (n_param_values == 3);
#line 153 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 153 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		data1 = closure->data;
#line 153 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		data2 = param_values->data[0].v_pointer;
#line 420 "rygel-gst-transcoder.c"
	} else {
#line 153 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		data1 = param_values->data[0].v_pointer;
#line 153 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		data2 = closure->data;
#line 426 "rygel-gst-transcoder.c"
	}
#line 153 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	callback = (GMarshalFunc_BOOLEAN__OBJECT_POINTER) (marshal_data ? marshal_data : cc->callback);
#line 153 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	v_return = callback (data1, g_value_get_object (param_values + 1), g_value_get_pointer (param_values + 2), data2);
#line 153 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_value_set_boolean (return_value, v_return);
#line 434 "rygel-gst-transcoder.c"
}


gulong _dynamic_autoplug_continue1_connect (gpointer obj, const char * signal_name, GCallback handler, gpointer data) {
#line 153 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return g_signal_connect_object (obj, signal_name, handler, data, 0);
#line 441 "rygel-gst-transcoder.c"
}


static void _rygel_gst_transcoder_on_no_more_pads_gst_element_no_more_pads (GstElement* _sender, gpointer self) {
#line 154 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	rygel_gst_transcoder_on_no_more_pads ((RygelGstTranscoder*) self, _sender);
#line 448 "rygel-gst-transcoder.c"
}


RygelDataSource* rygel_gst_transcoder_create_source (RygelGstTranscoder* self, RygelMediaFileItem* item, RygelDataSource* src, GError** error) {
	RygelDataSource* result = NULL;
	RygelDataSource* _tmp0_ = NULL;
	RygelGstDataSource* orig_source = NULL;
	RygelDataSource* _tmp1_ = NULL;
	RygelGstDataSource* _tmp2_ = NULL;
	GstElement* _tmp3_ = NULL;
	GstElement* _tmp4_ = NULL;
	GstElement* _tmp5_ = NULL;
	GstElement* _tmp6_ = NULL;
	GstElement* _tmp7_ = NULL;
	GstElement* _tmp8_ = NULL;
	GstElement* _tmp9_ = NULL;
	GstEncodingProfile* _tmp10_ = NULL;
	GstEncodingProfile* _tmp11_ = NULL;
	GstElement* _tmp12_ = NULL;
	GstElement* _tmp13_ = NULL;
	GstElement* _tmp14_ = NULL;
	GObjectClass* _tmp19_ = NULL;
	GType _tmp20_ = 0UL;
	const gchar* _tmp21_ = NULL;
	GstElement* _tmp22_ = NULL;
	GstEncodingProfile* _tmp23_ = NULL;
	GstEncodingProfile* _tmp24_ = NULL;
	GstBin* bin = NULL;
	GstBin* _tmp25_ = NULL;
	GstBin* _tmp26_ = NULL;
	RygelGstDataSource* _tmp27_ = NULL;
	GstElement* _tmp28_ = NULL;
	GstElement* _tmp29_ = NULL;
	GstElement* _tmp30_ = NULL;
	RygelGstDataSource* _tmp31_ = NULL;
	GstElement* _tmp32_ = NULL;
	GstElement* _tmp33_ = NULL;
	GstElement* _tmp34_ = NULL;
	GstElement* _tmp35_ = NULL;
	GstElement* _tmp36_ = NULL;
	GstPad* pad = NULL;
	GstElement* _tmp37_ = NULL;
	GstPad* _tmp38_ = NULL;
	GstGhostPad* ghost = NULL;
	GstPad* _tmp39_ = NULL;
	GstGhostPad* _tmp40_ = NULL;
	GstBin* _tmp41_ = NULL;
	GstGhostPad* _tmp42_ = NULL;
	GstBin* _tmp43_ = NULL;
	RygelGstDataSource* _tmp44_ = NULL;
	GError * _inner_error_ = NULL;
#line 125 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 125 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 125 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (src != NULL, NULL);
#line 127 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp0_ = src;
#line 127 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_GST_DATA_SOURCE), "src is GstDataSource");
#line 129 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp1_ = src;
#line 129 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_GST_DATA_SOURCE) ? ((RygelGstDataSource*) _tmp1_) : NULL);
#line 129 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	orig_source = _tmp2_;
#line 131 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp4_ = rygel_gst_utils_create_element (RYGEL_GST_TRANSCODER_DECODE_BIN, RYGEL_GST_TRANSCODER_DECODE_BIN, &_inner_error_);
#line 131 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp3_ = _tmp4_;
#line 131 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 131 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 131 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_g_object_unref0 (orig_source);
#line 131 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		return NULL;
#line 528 "rygel-gst-transcoder.c"
	}
#line 131 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp5_ = _tmp3_;
#line 131 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp3_ = NULL;
#line 131 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_object_unref0 (self->priv->decoder);
#line 131 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	self->priv->decoder = _tmp5_;
#line 133 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp7_ = rygel_gst_utils_create_element (RYGEL_GST_TRANSCODER_ENCODE_BIN, RYGEL_GST_TRANSCODER_ENCODE_BIN, &_inner_error_);
#line 133 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp6_ = _tmp7_;
#line 133 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 133 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 133 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_g_object_unref0 (_tmp3_);
#line 133 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_g_object_unref0 (orig_source);
#line 133 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		return NULL;
#line 552 "rygel-gst-transcoder.c"
	}
#line 133 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp8_ = _tmp6_;
#line 133 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp6_ = NULL;
#line 133 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_object_unref0 (self->priv->encoder);
#line 133 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	self->priv->encoder = _tmp8_;
#line 136 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp9_ = self->priv->encoder;
#line 136 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp10_ = rygel_gst_transcoder_get_encoding_profile (self);
#line 136 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp11_ = _tmp10_;
#line 136 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_dynamic_set_profile2 (_tmp9_, _tmp11_);
#line 136 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_object_unref0 (_tmp11_);
#line 137 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp12_ = self->priv->encoder;
#line 137 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp13_ = _dynamic_get_profile3 (_tmp12_);
#line 137 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp14_ = _tmp13_;
#line 137 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	if (_tmp14_ == NULL) {
#line 580 "rygel-gst-transcoder.c"
		gchar* message = NULL;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		GError* _tmp18_ = NULL;
#line 138 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp15_ = _ ("Could not create a transcoder configuration. Your GStreamer installati" \
"on might be missing a plug-in");
#line 138 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp16_ = g_strdup (_tmp15_);
#line 138 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		message = _tmp16_;
#line 140 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp17_ = message;
#line 140 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp18_ = g_error_new_literal (RYGEL_GST_TRANSCODER_ERROR, RYGEL_GST_TRANSCODER_ERROR_CANT_TRANSCODE, _tmp17_);
#line 140 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_inner_error_ = _tmp18_;
#line 140 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 140 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_g_free0 (message);
#line 140 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_g_object_unref0 (_tmp6_);
#line 140 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_g_object_unref0 (_tmp3_);
#line 140 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_g_object_unref0 (orig_source);
#line 140 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		return NULL;
#line 610 "rygel-gst-transcoder.c"
	}
#line 143 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp19_ = G_OBJECT_GET_CLASS ((GObject*) self);
#line 143 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp20_ = G_TYPE_FROM_CLASS ((GTypeClass*) _tmp19_);
#line 143 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp21_ = g_type_name (_tmp20_);
#line 143 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_debug ("rygel-gst-transcoder.vala:143: %s using the following encoding profile" \
":", _tmp21_);
#line 145 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp22_ = self->priv->encoder;
#line 145 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp23_ = _dynamic_get_profile4 (_tmp22_);
#line 145 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp24_ = _tmp23_;
#line 145 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	rygel_gst_utils_dump_encoding_profile (_tmp24_, 2);
#line 147 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp25_ = (GstBin*) gst_bin_new ("transcoder-source");
#line 147 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_object_ref_sink (_tmp25_);
#line 147 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	bin = _tmp25_;
#line 148 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp26_ = bin;
#line 148 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp27_ = orig_source;
#line 148 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp28_ = _tmp27_->src;
#line 148 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp29_ = self->priv->decoder;
#line 148 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp30_ = self->priv->encoder;
#line 148 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	gst_bin_add_many (_tmp26_, _tmp28_, _tmp29_, _tmp30_, NULL);
#line 150 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp31_ = orig_source;
#line 150 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp32_ = _tmp31_->src;
#line 150 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp33_ = self->priv->decoder;
#line 150 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	gst_element_link (_tmp32_, _tmp33_);
#line 152 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp34_ = self->priv->decoder;
#line 152 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_signal_connect_object (_tmp34_, "pad-added", (GCallback) _rygel_gst_transcoder_on_decoder_pad_added_gst_element_pad_added, self, 0);
#line 153 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp35_ = self->priv->decoder;
#line 153 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_dynamic_autoplug_continue1_connect (_tmp35_, "autoplug_continue", (GCallback) _rygel_gst_transcoder_on_autoplug_continue_dynamic_autoplug_continue0_, self);
#line 154 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp36_ = self->priv->decoder;
#line 154 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_signal_connect_object (_tmp36_, "no-more-pads", (GCallback) _rygel_gst_transcoder_on_no_more_pads_gst_element_no_more_pads, self, 0);
#line 156 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp37_ = self->priv->encoder;
#line 156 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp38_ = gst_element_get_static_pad (_tmp37_, "src");
#line 156 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	pad = _tmp38_;
#line 157 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp39_ = pad;
#line 157 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp40_ = (GstGhostPad*) gst_ghost_pad_new (NULL, _tmp39_);
#line 157 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_object_ref_sink (_tmp40_);
#line 157 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	ghost = _tmp40_;
#line 158 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp41_ = bin;
#line 158 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp42_ = ghost;
#line 158 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	gst_element_add_pad ((GstElement*) _tmp41_, (GstPad*) _tmp42_);
#line 160 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp43_ = bin;
#line 160 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp44_ = rygel_gst_data_source_new_from_element ((GstElement*) _tmp43_);
#line 160 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	result = (RygelDataSource*) _tmp44_;
#line 160 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_object_unref0 (ghost);
#line 160 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_object_unref0 (pad);
#line 160 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_object_unref0 (bin);
#line 160 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_object_unref0 (_tmp6_);
#line 160 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_object_unref0 (_tmp3_);
#line 160 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_object_unref0 (orig_source);
#line 160 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return result;
#line 706 "rygel-gst-transcoder.c"
}


/**
     * Gets the Gst.EncodingProfile for this transcoder.
     *
     * @return      the Gst.EncodingProfile for this transcoder.
     */
static GstEncodingProfile* rygel_gst_transcoder_real_get_encoding_profile (RygelGstTranscoder* self) {
#line 168 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_critical ("Type `%s' does not implement abstract method `rygel_gst_transcoder_get_encoding_profile'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 168 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return NULL;
#line 720 "rygel-gst-transcoder.c"
}


GstEncodingProfile* rygel_gst_transcoder_get_encoding_profile (RygelGstTranscoder* self) {
#line 168 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 168 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return RYGEL_GST_TRANSCODER_GET_CLASS (self)->get_encoding_profile (self);
#line 729 "rygel-gst-transcoder.c"
}


static gboolean rygel_gst_transcoder_on_autoplug_continue (RygelGstTranscoder* self, GstElement* decodebin, GstPad* new_pad, GstCaps* caps) {
	gboolean result = FALSE;
	GstPad* sinkpad = NULL;
	GstElement* _tmp0_ = NULL;
	GstCaps* _tmp1_ = NULL;
	GstPad* _tmp2_ = NULL;
#line 170 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 170 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (decodebin != NULL, FALSE);
#line 170 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (new_pad != NULL, FALSE);
#line 170 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (caps != NULL, FALSE);
#line 173 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	sinkpad = NULL;
#line 175 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp0_ = self->priv->encoder;
#line 175 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp1_ = caps;
#line 175 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_signal_emit_by_name (_tmp0_, "request-pad", _tmp1_, &sinkpad, NULL);
#line 176 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp2_ = sinkpad;
#line 176 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	if (_tmp2_ == NULL) {
#line 177 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		result = TRUE;
#line 177 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_g_object_unref0 (sinkpad);
#line 177 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		return result;
#line 765 "rygel-gst-transcoder.c"
	}
#line 180 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	result = FALSE;
#line 180 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_object_unref0 (sinkpad);
#line 180 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return result;
#line 773 "rygel-gst-transcoder.c"
}


static void rygel_gst_transcoder_on_decoder_pad_added (RygelGstTranscoder* self, GstElement* decodebin, GstPad* new_pad) {
	GstPad* sinkpad = NULL;
	GstElement* _tmp0_ = NULL;
	GstPad* _tmp1_ = NULL;
	GstPad* _tmp2_ = NULL;
	GstPad* _tmp3_ = NULL;
	GstPad* _tmp8_ = NULL;
	gboolean pad_link_ok = FALSE;
	GstPad* _tmp13_ = NULL;
	GstPad* _tmp14_ = NULL;
	GstPadLinkReturn _tmp15_ = 0;
	gboolean _tmp16_ = FALSE;
#line 183 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_if_fail (self != NULL);
#line 183 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_if_fail (decodebin != NULL);
#line 183 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_if_fail (new_pad != NULL);
#line 186 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp0_ = self->priv->encoder;
#line 186 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp1_ = new_pad;
#line 186 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp2_ = gst_element_get_compatible_pad (_tmp0_, _tmp1_, NULL);
#line 186 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_object_unref0 (sinkpad);
#line 186 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	sinkpad = _tmp2_;
#line 188 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp3_ = sinkpad;
#line 188 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	if (_tmp3_ == NULL) {
#line 809 "rygel-gst-transcoder.c"
		GstCaps* caps = NULL;
		GstPad* _tmp4_ = NULL;
		GstCaps* _tmp5_ = NULL;
		GstElement* _tmp6_ = NULL;
		GstCaps* _tmp7_ = NULL;
#line 189 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp4_ = new_pad;
#line 189 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp5_ = gst_pad_query_caps (_tmp4_, NULL);
#line 189 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		caps = _tmp5_;
#line 190 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp6_ = self->priv->encoder;
#line 190 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp7_ = caps;
#line 190 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		g_signal_emit_by_name (_tmp6_, "request-pad", _tmp7_, &sinkpad, NULL);
#line 188 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_gst_caps_unref0 (caps);
#line 829 "rygel-gst-transcoder.c"
	}
#line 193 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp8_ = sinkpad;
#line 193 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	if (_tmp8_ == NULL) {
#line 835 "rygel-gst-transcoder.c"
		GstPad* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
#line 194 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp9_ = new_pad;
#line 194 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		g_object_get ((GstObject*) _tmp9_, "name", &_tmp10_, NULL);
#line 194 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp11_ = _tmp10_;
#line 194 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp12_ = _tmp11_;
#line 194 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		g_debug ("rygel-gst-transcoder.vala:194: No compatible encodebin pad found for p" \
"ad '%s', ignoring..", _tmp12_);
#line 194 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_g_free0 (_tmp12_);
#line 197 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_g_object_unref0 (sinkpad);
#line 197 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		return;
#line 856 "rygel-gst-transcoder.c"
	}
#line 200 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp13_ = new_pad;
#line 200 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp14_ = sinkpad;
#line 200 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp15_ = gst_pad_link_full (_tmp13_, _tmp14_, GST_PAD_LINK_CHECK_DEFAULT);
#line 200 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	pad_link_ok = _tmp15_ == GST_PAD_LINK_OK;
#line 201 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp16_ = pad_link_ok;
#line 201 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	if (!_tmp16_) {
#line 870 "rygel-gst-transcoder.c"
		GstPad* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		GstPad* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
#line 202 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp17_ = new_pad;
#line 202 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		g_object_get ((GstObject*) _tmp17_, "name", &_tmp18_, NULL);
#line 202 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp19_ = _tmp18_;
#line 202 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp20_ = _tmp19_;
#line 202 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp21_ = sinkpad;
#line 202 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		g_object_get ((GstObject*) _tmp21_, "name", &_tmp22_, NULL);
#line 202 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp23_ = _tmp22_;
#line 202 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp24_ = _tmp23_;
#line 202 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		g_warning ("rygel-gst-transcoder.vala:202: Failed to link pad '%s' to '%s'", _tmp20_, _tmp24_);
#line 202 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_g_free0 (_tmp24_);
#line 202 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_g_free0 (_tmp20_);
#line 901 "rygel-gst-transcoder.c"
	} else {
#line 206 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		self->priv->link_failed = FALSE;
#line 905 "rygel-gst-transcoder.c"
	}
#line 209 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_object_unref0 (sinkpad);
#line 209 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return;
#line 911 "rygel-gst-transcoder.c"
}


static gpointer _gst_message_ref0 (gpointer self) {
#line 227 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return self ? gst_message_ref (self) : NULL;
#line 918 "rygel-gst-transcoder.c"
}


static void rygel_gst_transcoder_on_no_more_pads (RygelGstTranscoder* self, GstElement* decodebin) {
	gboolean _tmp0_ = FALSE;
#line 215 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_if_fail (self != NULL);
#line 215 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_if_fail (decodebin != NULL);
#line 217 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp0_ = self->priv->link_failed;
#line 217 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	if (_tmp0_) {
#line 932 "rygel-gst-transcoder.c"
		GstBin* bin = NULL;
		GstElement* _tmp1_ = NULL;
		GstObject* _tmp2_ = NULL;
		GstBin* _tmp3_ = NULL;
		GError* _error_ = NULL;
		GError* _tmp4_ = NULL;
		GstMessage* message = NULL;
		GstBin* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		GstMessage* _tmp7_ = NULL;
		GstBus* bus = NULL;
		GstBin* _tmp8_ = NULL;
		GstBus* _tmp9_ = NULL;
		GstBus* _tmp10_ = NULL;
		GstMessage* _tmp11_ = NULL;
		GstMessage* _tmp12_ = NULL;
#line 219 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp1_ = self->priv->encoder;
#line 219 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp2_ = gst_object_get_parent ((GstObject*) _tmp1_);
#line 219 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gst_bin_get_type ()) ? ((GstBin*) _tmp2_) : NULL;
#line 219 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		if (_tmp3_ == NULL) {
#line 219 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
			_g_object_unref0 (_tmp2_);
#line 959 "rygel-gst-transcoder.c"
		}
#line 219 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		bin = _tmp3_;
#line 220 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp4_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, "Could not link");
#line 220 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_error_ = _tmp4_;
#line 221 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp5_ = bin;
#line 221 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp6_ = _error_;
#line 221 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp7_ = gst_message_new_error ((GstObject*) _tmp5_, _tmp6_, RYGEL_GST_TRANSCODER_DESCRIPTION);
#line 221 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		message = _tmp7_;
#line 226 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp8_ = bin;
#line 226 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp9_ = gst_element_get_bus ((GstElement*) _tmp8_);
#line 226 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		bus = _tmp9_;
#line 227 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp10_ = bus;
#line 227 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp11_ = message;
#line 227 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp12_ = _gst_message_ref0 (_tmp11_);
#line 227 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		gst_bus_post (_tmp10_, _tmp12_);
#line 217 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_g_object_unref0 (bus);
#line 217 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_gst_message_unref0 (message);
#line 217 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_g_error_free0 (_error_);
#line 217 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_g_object_unref0 (bin);
#line 997 "rygel-gst-transcoder.c"
	}
}


const gchar* rygel_gst_transcoder_get_name (RygelGstTranscoder* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 42 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 42 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp0_ = self->priv->_name;
#line 42 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	result = _tmp0_;
#line 42 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return result;
#line 1013 "rygel-gst-transcoder.c"
}


static void rygel_gst_transcoder_set_name (RygelGstTranscoder* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 42 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_if_fail (self != NULL);
#line 42 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp0_ = value;
#line 42 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 42 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_free0 (self->priv->_name);
#line 42 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	self->priv->_name = _tmp1_;
#line 42 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_object_notify ((GObject *) self, "name");
#line 1032 "rygel-gst-transcoder.c"
}


const gchar* rygel_gst_transcoder_get_mime_type (RygelGstTranscoder* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 43 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 43 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp0_ = self->priv->_mime_type;
#line 43 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	result = _tmp0_;
#line 43 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return result;
#line 1047 "rygel-gst-transcoder.c"
}


static void rygel_gst_transcoder_set_mime_type (RygelGstTranscoder* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 43 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_if_fail (self != NULL);
#line 43 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp0_ = value;
#line 43 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 43 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_free0 (self->priv->_mime_type);
#line 43 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	self->priv->_mime_type = _tmp1_;
#line 43 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_object_notify ((GObject *) self, "mime-type");
#line 1066 "rygel-gst-transcoder.c"
}


const gchar* rygel_gst_transcoder_get_dlna_profile (RygelGstTranscoder* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 44 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 44 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp0_ = self->priv->_dlna_profile;
#line 44 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	result = _tmp0_;
#line 44 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return result;
#line 1081 "rygel-gst-transcoder.c"
}


static void rygel_gst_transcoder_set_dlna_profile (RygelGstTranscoder* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 44 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_if_fail (self != NULL);
#line 44 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp0_ = value;
#line 44 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 44 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_free0 (self->priv->_dlna_profile);
#line 44 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	self->priv->_dlna_profile = _tmp1_;
#line 44 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_object_notify ((GObject *) self, "dlna-profile");
#line 1100 "rygel-gst-transcoder.c"
}


const gchar* rygel_gst_transcoder_get_extension (RygelGstTranscoder* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 45 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 45 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp0_ = self->priv->_extension;
#line 45 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	result = _tmp0_;
#line 45 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return result;
#line 1115 "rygel-gst-transcoder.c"
}


static void rygel_gst_transcoder_set_extension (RygelGstTranscoder* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 45 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_if_fail (self != NULL);
#line 45 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp0_ = value;
#line 45 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 45 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_free0 (self->priv->_extension);
#line 45 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	self->priv->_extension = _tmp1_;
#line 45 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_object_notify ((GObject *) self, "extension");
#line 1134 "rygel-gst-transcoder.c"
}


const gchar* rygel_gst_transcoder_get_preset (RygelGstTranscoder* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 47 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 47 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp0_ = self->priv->_preset;
#line 47 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	result = _tmp0_;
#line 47 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return result;
#line 1149 "rygel-gst-transcoder.c"
}


void rygel_gst_transcoder_set_preset (RygelGstTranscoder* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 48 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_if_fail (self != NULL);
#line 48 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp0_ = value;
#line 48 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 48 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_free0 (self->priv->_preset);
#line 48 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	self->priv->_preset = _tmp1_;
#line 48 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_object_notify ((GObject *) self, "preset");
#line 1168 "rygel-gst-transcoder.c"
}


static void rygel_gst_transcoder_class_init (RygelGstTranscoderClass * klass) {
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	rygel_gst_transcoder_parent_class = g_type_class_peek_parent (klass);
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_type_class_add_private (klass, sizeof (RygelGstTranscoderPrivate));
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	((GObjectClass *) klass)->constructed = rygel_gst_transcoder_real_constructed;
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	((RygelGstTranscoderClass *) klass)->get_resource_for_item = rygel_gst_transcoder_real_get_resource_for_item;
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	((RygelGstTranscoderClass *) klass)->get_distance = rygel_gst_transcoder_real_get_distance;
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	((RygelGstTranscoderClass *) klass)->get_encoding_profile = rygel_gst_transcoder_real_get_encoding_profile;
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_gst_transcoder_get_property;
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_gst_transcoder_set_property;
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_gst_transcoder_finalize;
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_TRANSCODER_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_TRANSCODER_MIME_TYPE, g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_TRANSCODER_DLNA_PROFILE, g_param_spec_string ("dlna-profile", "dlna-profile", "dlna-profile", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_TRANSCODER_EXTENSION, g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_TRANSCODER_PRESET, g_param_spec_string ("preset", "preset", "preset", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1201 "rygel-gst-transcoder.c"
}


static void rygel_gst_transcoder_instance_init (RygelGstTranscoder * self) {
	gchar* _tmp0_ = NULL;
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	self->priv = RYGEL_GST_TRANSCODER_GET_PRIVATE (self);
#line 47 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp0_ = g_strdup (RYGEL_GST_TRANSCODER_DEFAULT_ENCODING_PRESET);
#line 47 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	self->priv->_preset = _tmp0_;
#line 1213 "rygel-gst-transcoder.c"
}


static void rygel_gst_transcoder_finalize (GObject* obj) {
	RygelGstTranscoder * self;
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoder);
#line 42 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_free0 (self->priv->_name);
#line 43 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_free0 (self->priv->_mime_type);
#line 44 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_free0 (self->priv->_dlna_profile);
#line 45 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_free0 (self->priv->_extension);
#line 47 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_free0 (self->priv->_preset);
#line 55 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_object_unref0 (self->priv->decoder);
#line 56 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_object_unref0 (self->priv->encoder);
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	G_OBJECT_CLASS (rygel_gst_transcoder_parent_class)->finalize (obj);
#line 1237 "rygel-gst-transcoder.c"
}


/**
 * The base Transcoder class used by gstreamer media engine.
 * Each implementation derives from it and must
 * implement get_resources_for_item and get_encoding_profile methods.
 */
GType rygel_gst_transcoder_get_type (void) {
	static volatile gsize rygel_gst_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_gst_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelGstTranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_gst_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelGstTranscoder), 0, (GInstanceInitFunc) rygel_gst_transcoder_instance_init, NULL };
		GType rygel_gst_transcoder_type_id;
		rygel_gst_transcoder_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelGstTranscoder", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_gst_transcoder_type_id__volatile, rygel_gst_transcoder_type_id);
	}
	return rygel_gst_transcoder_type_id__volatile;
}


static void _vala_rygel_gst_transcoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelGstTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoder);
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	switch (property_id) {
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		case RYGEL_GST_TRANSCODER_NAME:
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		g_value_set_string (value, rygel_gst_transcoder_get_name (self));
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		break;
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		case RYGEL_GST_TRANSCODER_MIME_TYPE:
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		g_value_set_string (value, rygel_gst_transcoder_get_mime_type (self));
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		break;
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		case RYGEL_GST_TRANSCODER_DLNA_PROFILE:
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		g_value_set_string (value, rygel_gst_transcoder_get_dlna_profile (self));
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		break;
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		case RYGEL_GST_TRANSCODER_EXTENSION:
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		g_value_set_string (value, rygel_gst_transcoder_get_extension (self));
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		break;
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		case RYGEL_GST_TRANSCODER_PRESET:
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		g_value_set_string (value, rygel_gst_transcoder_get_preset (self));
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		break;
#line 1293 "rygel-gst-transcoder.c"
		default:
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		break;
#line 1299 "rygel-gst-transcoder.c"
	}
}


static void _vala_rygel_gst_transcoder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelGstTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoder);
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	switch (property_id) {
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		case RYGEL_GST_TRANSCODER_NAME:
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		rygel_gst_transcoder_set_name (self, g_value_get_string (value));
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		break;
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		case RYGEL_GST_TRANSCODER_MIME_TYPE:
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		rygel_gst_transcoder_set_mime_type (self, g_value_get_string (value));
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		break;
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		case RYGEL_GST_TRANSCODER_DLNA_PROFILE:
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		rygel_gst_transcoder_set_dlna_profile (self, g_value_get_string (value));
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		break;
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		case RYGEL_GST_TRANSCODER_EXTENSION:
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		rygel_gst_transcoder_set_extension (self, g_value_get_string (value));
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		break;
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		case RYGEL_GST_TRANSCODER_PRESET:
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		rygel_gst_transcoder_set_preset (self, g_value_get_string (value));
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		break;
#line 1339 "rygel-gst-transcoder.c"
		default:
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		break;
#line 1345 "rygel-gst-transcoder.c"
	}
}



