/* rygel-simple-media-engine.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-simple-media-engine.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_SIMPLE_MEDIA_ENGINE (rygel_simple_media_engine_get_type ())
#define RYGEL_SIMPLE_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SIMPLE_MEDIA_ENGINE, RygelSimpleMediaEngine))
#define RYGEL_SIMPLE_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SIMPLE_MEDIA_ENGINE, RygelSimpleMediaEngineClass))
#define RYGEL_IS_SIMPLE_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SIMPLE_MEDIA_ENGINE))
#define RYGEL_IS_SIMPLE_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SIMPLE_MEDIA_ENGINE))
#define RYGEL_SIMPLE_MEDIA_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SIMPLE_MEDIA_ENGINE, RygelSimpleMediaEngineClass))

typedef struct _RygelSimpleMediaEngine RygelSimpleMediaEngine;
typedef struct _RygelSimpleMediaEngineClass RygelSimpleMediaEngineClass;
typedef struct _RygelSimpleMediaEnginePrivate RygelSimpleMediaEnginePrivate;
#define __g_list_free__rygel_dlna_profile_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__rygel_dlna_profile_unref0_ (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelSimpleMediaEngineGetResourcesForItemData RygelSimpleMediaEngineGetResourcesForItemData;

#define RYGEL_TYPE_SIMPLE_DATA_SOURCE (rygel_simple_data_source_get_type ())
#define RYGEL_SIMPLE_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SIMPLE_DATA_SOURCE, RygelSimpleDataSource))
#define RYGEL_SIMPLE_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SIMPLE_DATA_SOURCE, RygelSimpleDataSourceClass))
#define RYGEL_IS_SIMPLE_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SIMPLE_DATA_SOURCE))
#define RYGEL_IS_SIMPLE_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SIMPLE_DATA_SOURCE))
#define RYGEL_SIMPLE_DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SIMPLE_DATA_SOURCE, RygelSimpleDataSourceClass))

typedef struct _RygelSimpleDataSource RygelSimpleDataSource;
typedef struct _RygelSimpleDataSourceClass RygelSimpleDataSourceClass;

struct _RygelSimpleMediaEngine {
	RygelMediaEngine parent_instance;
	RygelSimpleMediaEnginePrivate * priv;
};

struct _RygelSimpleMediaEngineClass {
	RygelMediaEngineClass parent_class;
};

struct _RygelSimpleMediaEnginePrivate {
	GList* profiles;
};

struct _RygelSimpleMediaEngineGetResourcesForItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSimpleMediaEngine* self;
	RygelMediaObject* object;
	GeeList* result;
	RygelMediaObject* _tmp0_;
	RygelMediaFileItem* item;
	RygelMediaObject* _tmp1_;
	RygelMediaFileItem* _tmp2_;
	gchar* source_uri;
	RygelMediaFileItem* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	GeeList* resources;
	GeeArrayList* _tmp11_;
	RygelMediaResource* primary_res;
	RygelMediaFileItem* _tmp12_;
	RygelMediaResource* _tmp13_;
	RygelMediaResource* _tmp14_;
	RygelMediaResource* _tmp15_;
	RygelMediaResource* _tmp16_;
	GUPnPDLNAFlags _tmp17_;
	GUPnPDLNAFlags _tmp18_;
	RygelMediaResource* http_res;
	RygelMediaResource* _tmp19_;
	RygelMediaResource* _tmp20_;
	RygelMediaResource* _tmp21_;
	GeeList* _tmp22_;
	RygelMediaResource* _tmp23_;
	GeeList* _tmp24_;
	RygelMediaResource* _tmp25_;
};


static gpointer rygel_simple_media_engine_parent_class = NULL;

GType rygel_simple_media_engine_get_type (void) G_GNUC_CONST;
#define RYGEL_SIMPLE_MEDIA_ENGINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_SIMPLE_MEDIA_ENGINE, RygelSimpleMediaEnginePrivate))
enum  {
	RYGEL_SIMPLE_MEDIA_ENGINE_DUMMY_PROPERTY
};
static void _rygel_dlna_profile_unref0_ (gpointer var);
static void _g_list_free__rygel_dlna_profile_unref0_ (GList* self);
RygelSimpleMediaEngine* rygel_simple_media_engine_new (void);
RygelSimpleMediaEngine* rygel_simple_media_engine_construct (GType object_type);
static GList* rygel_simple_media_engine_real_get_dlna_profiles (RygelMediaEngine* base);
static void rygel_simple_media_engine_real_get_resources_for_item_data_free (gpointer _data);
static void rygel_simple_media_engine_real_get_resources_for_item (RygelMediaEngine* base, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_simple_media_engine_real_get_resources_for_item_co (RygelSimpleMediaEngineGetResourcesForItemData* _data_);
static RygelDataSource* rygel_simple_media_engine_real_create_data_source_for_resource (RygelMediaEngine* base, RygelMediaObject* object, RygelMediaResource* resource, GError** error);
RygelSimpleDataSource* rygel_simple_data_source_new (const gchar* uri);
RygelSimpleDataSource* rygel_simple_data_source_construct (GType object_type, const gchar* uri);
GType rygel_simple_data_source_get_type (void) G_GNUC_CONST;
static RygelDataSource* rygel_simple_media_engine_real_create_data_source_for_uri (RygelMediaEngine* base, const gchar* uri, GError** error);
static void rygel_simple_media_engine_finalize (GObject* obj);
RygelMediaEngine* module_get_instance (void);


static void _rygel_dlna_profile_unref0_ (gpointer var) {
#line 35 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	(var == NULL) ? NULL : (var = (rygel_dlna_profile_unref (var), NULL));
#line 147 "rygel-simple-media-engine.c"
}


static void _g_list_free__rygel_dlna_profile_unref0_ (GList* self) {
#line 35 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	g_list_foreach (self, (GFunc) _rygel_dlna_profile_unref0_, NULL);
#line 35 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	g_list_free (self);
#line 156 "rygel-simple-media-engine.c"
}


RygelSimpleMediaEngine* rygel_simple_media_engine_construct (GType object_type) {
	RygelSimpleMediaEngine * self = NULL;
#line 37 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	self = (RygelSimpleMediaEngine*) rygel_media_engine_construct (object_type);
#line 37 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	return self;
#line 166 "rygel-simple-media-engine.c"
}


RygelSimpleMediaEngine* rygel_simple_media_engine_new (void) {
#line 37 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	return rygel_simple_media_engine_construct (RYGEL_TYPE_SIMPLE_MEDIA_ENGINE);
#line 173 "rygel-simple-media-engine.c"
}


static GList* rygel_simple_media_engine_real_get_dlna_profiles (RygelMediaEngine* base) {
	RygelSimpleMediaEngine * self;
	GList* result = NULL;
	GList* _tmp0_ = NULL;
#line 39 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	self = (RygelSimpleMediaEngine*) base;
#line 40 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_tmp0_ = self->priv->profiles;
#line 40 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	result = _tmp0_;
#line 40 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	return result;
#line 189 "rygel-simple-media-engine.c"
}


static void rygel_simple_media_engine_real_get_resources_for_item_data_free (gpointer _data) {
	RygelSimpleMediaEngineGetResourcesForItemData* _data_;
	_data_ = _data;
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_g_object_unref0 (_data_->object);
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_g_object_unref0 (_data_->result);
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_g_object_unref0 (_data_->self);
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	g_slice_free (RygelSimpleMediaEngineGetResourcesForItemData, _data_);
#line 204 "rygel-simple-media-engine.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	return self ? g_object_ref (self) : NULL;
#line 211 "rygel-simple-media-engine.c"
}


static void rygel_simple_media_engine_real_get_resources_for_item (RygelMediaEngine* base, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSimpleMediaEngine * self;
	RygelSimpleMediaEngineGetResourcesForItemData* _data_;
	RygelSimpleMediaEngine* _tmp0_ = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	RygelMediaObject* _tmp2_ = NULL;
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	self = (RygelSimpleMediaEngine*) base;
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_ = g_slice_new0 (RygelSimpleMediaEngineGetResourcesForItemData);
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_simple_media_engine_real_get_resources_for_item);
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_simple_media_engine_real_get_resources_for_item_data_free);
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->self = _tmp0_;
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_tmp1_ = object;
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_g_object_unref0 (_data_->object);
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->object = _tmp2_;
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	rygel_simple_media_engine_real_get_resources_for_item_co (_data_);
#line 243 "rygel-simple-media-engine.c"
}


static GeeList* rygel_simple_media_engine_real_get_resources_for_item_finish (RygelMediaEngine* base, GAsyncResult* _res_) {
	GeeList* result;
	RygelSimpleMediaEngineGetResourcesForItemData* _data_;
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	result = _data_->result;
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->result = NULL;
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	return result;
#line 258 "rygel-simple-media-engine.c"
}


static gboolean rygel_simple_media_engine_real_get_resources_for_item_co (RygelSimpleMediaEngineGetResourcesForItemData* _data_) {
#line 43 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	switch (_data_->_state_) {
#line 43 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
		case 0:
#line 267 "rygel-simple-media-engine.c"
		goto _state_0;
		default:
#line 43 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
		g_assert_not_reached ();
#line 272 "rygel-simple-media-engine.c"
	}
	_state_0:
#line 45 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp0_ = NULL;
#line 45 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp0_ = _data_->object;
#line 45 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp0_, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
#line 46 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
		g_warning ("rygel-simple-media-engine.vala:46: Can only process file-based MediaOb" \
"jects (MediaFileItems)");
#line 47 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
		_data_->result = NULL;
#line 47 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
		if (_data_->_state_ == 0) {
#line 47 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 289 "rygel-simple-media-engine.c"
		} else {
#line 47 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 293 "rygel-simple-media-engine.c"
		}
#line 47 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
		g_object_unref (_data_->_async_result);
#line 47 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
		return FALSE;
#line 299 "rygel-simple-media-engine.c"
	}
#line 50 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp1_ = NULL;
#line 50 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp1_ = _data_->object;
#line 50 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp2_ = NULL;
#line 50 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp1_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _data_->_tmp1_) : NULL);
#line 50 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->item = _data_->_tmp2_;
#line 53 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp3_ = NULL;
#line 53 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp3_ = _data_->item;
#line 53 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp4_ = NULL;
#line 53 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp4_ = rygel_media_object_get_primary_uri ((RygelMediaObject*) _data_->_tmp3_);
#line 53 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->source_uri = _data_->_tmp4_;
#line 54 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp5_ = NULL;
#line 54 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp5_ = _data_->source_uri;
#line 54 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp6_ = FALSE;
#line 54 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp6_ = g_str_has_prefix (_data_->_tmp5_, "file://");
#line 54 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	if (!_data_->_tmp6_) {
#line 55 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
		_data_->_tmp7_ = NULL;
#line 55 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
		_data_->_tmp7_ = _data_->source_uri;
#line 55 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
		_data_->_tmp8_ = NULL;
#line 55 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
		_data_->_tmp8_ = g_strconcat ("Can't process non-file uri ", _data_->_tmp7_, NULL);
#line 55 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
		_data_->_tmp9_ = NULL;
#line 55 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
		_data_->_tmp9_ = _data_->_tmp8_;
#line 55 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
		g_warning ("rygel-simple-media-engine.vala:55: %s", _data_->_tmp9_);
#line 55 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
		_g_free0 (_data_->_tmp9_);
#line 347 "rygel-simple-media-engine.c"
	}
#line 58 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp10_ = NULL;
#line 58 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp10_ = _data_->source_uri;
#line 58 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	g_debug ("rygel-simple-media-engine.vala:58: get_resources_for_item (%s)", _data_->_tmp10_);
#line 60 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp11_ = NULL;
#line 60 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp11_ = gee_array_list_new (RYGEL_TYPE_MEDIA_RESOURCE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 60 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->resources = (GeeList*) _data_->_tmp11_;
#line 62 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp12_ = NULL;
#line 62 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp12_ = _data_->item;
#line 62 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp13_ = NULL;
#line 62 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp13_ = rygel_media_file_item_get_primary_resource (_data_->_tmp12_);
#line 62 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->primary_res = _data_->_tmp13_;
#line 65 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp14_ = NULL;
#line 65 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp14_ = _data_->primary_res;
#line 65 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	rygel_media_resource_set_dlna_operation (_data_->_tmp14_, GUPNP_DLNA_OPERATION_RANGE);
#line 68 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp15_ = NULL;
#line 68 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp15_ = _data_->primary_res;
#line 68 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp16_ = NULL;
#line 68 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp16_ = _data_->primary_res;
#line 68 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp17_ = 0;
#line 68 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp17_ = rygel_media_resource_get_dlna_flags (_data_->_tmp16_);
#line 68 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp18_ = 0;
#line 68 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp18_ = _data_->_tmp17_;
#line 68 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	rygel_media_resource_set_dlna_flags (_data_->_tmp16_, _data_->_tmp18_ | GUPNP_DLNA_FLAGS_CONNECTION_STALL);
#line 71 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp19_ = NULL;
#line 71 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp19_ = _data_->primary_res;
#line 71 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp20_ = NULL;
#line 71 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp20_ = rygel_media_resource_new_from_resource ("primary_http", _data_->_tmp19_);
#line 71 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->http_res = _data_->_tmp20_;
#line 73 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp21_ = NULL;
#line 73 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp21_ = _data_->http_res;
#line 73 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	rygel_media_resource_set_uri (_data_->_tmp21_, "");
#line 74 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp22_ = NULL;
#line 74 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp22_ = _data_->resources;
#line 74 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp23_ = NULL;
#line 74 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp23_ = _data_->http_res;
#line 74 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	gee_collection_add ((GeeCollection*) _data_->_tmp22_, _data_->_tmp23_);
#line 76 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp24_ = NULL;
#line 76 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp24_ = _data_->resources;
#line 76 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp25_ = NULL;
#line 76 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->_tmp25_ = _data_->primary_res;
#line 76 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	gee_collection_add ((GeeCollection*) _data_->_tmp24_, _data_->_tmp25_);
#line 78 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_data_->result = _data_->resources;
#line 78 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_g_object_unref0 (_data_->http_res);
#line 78 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_g_object_unref0 (_data_->primary_res);
#line 78 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_g_free0 (_data_->source_uri);
#line 78 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_g_object_unref0 (_data_->item);
#line 78 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	if (_data_->_state_ == 0) {
#line 78 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 445 "rygel-simple-media-engine.c"
	} else {
#line 78 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 449 "rygel-simple-media-engine.c"
	}
#line 78 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	g_object_unref (_data_->_async_result);
#line 78 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	return FALSE;
#line 43 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_g_object_unref0 (_data_->http_res);
#line 43 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_g_object_unref0 (_data_->primary_res);
#line 43 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_g_object_unref0 (_data_->resources);
#line 43 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_g_free0 (_data_->source_uri);
#line 43 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_g_object_unref0 (_data_->item);
#line 43 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	if (_data_->_state_ == 0) {
#line 43 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 469 "rygel-simple-media-engine.c"
	} else {
#line 43 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 473 "rygel-simple-media-engine.c"
	}
#line 43 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	g_object_unref (_data_->_async_result);
#line 43 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	return FALSE;
#line 479 "rygel-simple-media-engine.c"
}


static RygelDataSource* rygel_simple_media_engine_real_create_data_source_for_resource (RygelMediaEngine* base, RygelMediaObject* object, RygelMediaResource* resource, GError** error) {
	RygelSimpleMediaEngine * self;
	RygelDataSource* result = NULL;
	RygelMediaObject* _tmp0_ = NULL;
	gchar* source_uri = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	RygelSimpleDataSource* _tmp4_ = NULL;
#line 81 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	self = (RygelSimpleMediaEngine*) base;
#line 81 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	g_return_val_if_fail (object != NULL, NULL);
#line 81 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	g_return_val_if_fail (resource != NULL, NULL);
#line 84 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_tmp0_ = object;
#line 84 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
#line 85 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
		g_warning ("rygel-simple-media-engine.vala:85: Can only process file-based MediaOb" \
"jects (MediaFileItems)");
#line 86 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
		result = NULL;
#line 86 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
		return result;
#line 508 "rygel-simple-media-engine.c"
	}
#line 90 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_tmp1_ = object;
#line 90 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_tmp2_ = rygel_media_object_get_primary_uri (_tmp1_);
#line 90 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	source_uri = _tmp2_;
#line 91 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_tmp3_ = source_uri;
#line 91 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_tmp4_ = rygel_simple_data_source_new (_tmp3_);
#line 91 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	result = (RygelDataSource*) _tmp4_;
#line 91 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_g_free0 (source_uri);
#line 91 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	return result;
#line 526 "rygel-simple-media-engine.c"
}


static RygelDataSource* rygel_simple_media_engine_real_create_data_source_for_uri (RygelMediaEngine* base, const gchar* uri, GError** error) {
	RygelSimpleMediaEngine * self;
	RygelDataSource* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	RygelSimpleDataSource* _tmp4_ = NULL;
#line 94 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	self = (RygelSimpleMediaEngine*) base;
#line 94 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 95 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_tmp0_ = uri;
#line 95 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_tmp1_ = g_str_has_prefix (_tmp0_, "file://");
#line 95 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	if (!_tmp1_) {
#line 96 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
		result = NULL;
#line 96 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
		return result;
#line 552 "rygel-simple-media-engine.c"
	}
#line 98 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_tmp2_ = uri;
#line 98 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	g_debug ("rygel-simple-media-engine.vala:98: creating data source for %s", _tmp2_);
#line 99 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_tmp3_ = uri;
#line 99 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_tmp4_ = rygel_simple_data_source_new (_tmp3_);
#line 99 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	result = (RygelDataSource*) _tmp4_;
#line 99 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	return result;
#line 566 "rygel-simple-media-engine.c"
}


static void rygel_simple_media_engine_class_init (RygelSimpleMediaEngineClass * klass) {
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	rygel_simple_media_engine_parent_class = g_type_class_peek_parent (klass);
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	g_type_class_add_private (klass, sizeof (RygelSimpleMediaEnginePrivate));
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	((RygelMediaEngineClass *) klass)->get_dlna_profiles = rygel_simple_media_engine_real_get_dlna_profiles;
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	((RygelMediaEngineClass *) klass)->get_resources_for_item = rygel_simple_media_engine_real_get_resources_for_item;
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	((RygelMediaEngineClass *) klass)->get_resources_for_item_finish = rygel_simple_media_engine_real_get_resources_for_item_finish;
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	((RygelMediaEngineClass *) klass)->create_data_source_for_resource = rygel_simple_media_engine_real_create_data_source_for_resource;
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	((RygelMediaEngineClass *) klass)->create_data_source_for_uri = rygel_simple_media_engine_real_create_data_source_for_uri;
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_simple_media_engine_finalize;
#line 587 "rygel-simple-media-engine.c"
}


static void rygel_simple_media_engine_instance_init (RygelSimpleMediaEngine * self) {
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	self->priv = RYGEL_SIMPLE_MEDIA_ENGINE_GET_PRIVATE (self);
#line 35 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	self->priv->profiles = NULL;
#line 596 "rygel-simple-media-engine.c"
}


static void rygel_simple_media_engine_finalize (GObject* obj) {
	RygelSimpleMediaEngine * self;
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_SIMPLE_MEDIA_ENGINE, RygelSimpleMediaEngine);
#line 35 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	__g_list_free__rygel_dlna_profile_unref0_0 (self->priv->profiles);
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	G_OBJECT_CLASS (rygel_simple_media_engine_parent_class)->finalize (obj);
#line 608 "rygel-simple-media-engine.c"
}


/**
 * The simple media engine does not use GStreamer or any other
 * multimedia framework. Therefore its capabilities are limited.
 *
 * It does not support transcoding - get_resources() returns null.
 * Also, its RygelSimpleDataSource does not support time-base seeking.
 */
GType rygel_simple_media_engine_get_type (void) {
	static volatile gsize rygel_simple_media_engine_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_simple_media_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSimpleMediaEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_simple_media_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSimpleMediaEngine), 0, (GInstanceInitFunc) rygel_simple_media_engine_instance_init, NULL };
		GType rygel_simple_media_engine_type_id;
		rygel_simple_media_engine_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ENGINE, "RygelSimpleMediaEngine", &g_define_type_info, 0);
		g_once_init_leave (&rygel_simple_media_engine_type_id__volatile, rygel_simple_media_engine_type_id);
	}
	return rygel_simple_media_engine_type_id__volatile;
}


RygelMediaEngine* module_get_instance (void) {
	RygelMediaEngine* result = NULL;
	RygelSimpleMediaEngine* _tmp0_ = NULL;
#line 104 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	_tmp0_ = rygel_simple_media_engine_new ();
#line 104 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	result = (RygelMediaEngine*) _tmp0_;
#line 104 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-media-engine.vala"
	return result;
#line 640 "rygel-simple-media-engine.c"
}



