/* rygel-media-export-query-container-factory.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-media-export-query-container-factory.vala, do not modify */

/*
 * Copyright (C) 2011 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-server.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY (rygel_media_export_query_container_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactory))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactoryClass))

typedef struct _RygelMediaExportQueryContainerFactory RygelMediaExportQueryContainerFactory;
typedef struct _RygelMediaExportQueryContainerFactoryClass RygelMediaExportQueryContainerFactoryClass;
typedef struct _RygelMediaExportQueryContainerFactoryPrivate RygelMediaExportQueryContainerFactoryPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER (rygel_media_export_query_container_get_type ())
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainer))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))

typedef struct _RygelMediaExportQueryContainer RygelMediaExportQueryContainer;
typedef struct _RygelMediaExportQueryContainerClass RygelMediaExportQueryContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_LEAF_QUERY_CONTAINER (rygel_media_export_leaf_query_container_get_type ())
#define RYGEL_MEDIA_EXPORT_LEAF_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_LEAF_QUERY_CONTAINER, RygelMediaExportLeafQueryContainer))
#define RYGEL_MEDIA_EXPORT_LEAF_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_LEAF_QUERY_CONTAINER, RygelMediaExportLeafQueryContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_LEAF_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_LEAF_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_LEAF_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_LEAF_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_LEAF_QUERY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_LEAF_QUERY_CONTAINER, RygelMediaExportLeafQueryContainerClass))

typedef struct _RygelMediaExportLeafQueryContainer RygelMediaExportLeafQueryContainer;
typedef struct _RygelMediaExportLeafQueryContainerClass RygelMediaExportLeafQueryContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_NODE_QUERY_CONTAINER (rygel_media_export_node_query_container_get_type ())
#define RYGEL_MEDIA_EXPORT_NODE_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_NODE_QUERY_CONTAINER, RygelMediaExportNodeQueryContainer))
#define RYGEL_MEDIA_EXPORT_NODE_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_NODE_QUERY_CONTAINER, RygelMediaExportNodeQueryContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_NODE_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_NODE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_NODE_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_NODE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_NODE_QUERY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_NODE_QUERY_CONTAINER, RygelMediaExportNodeQueryContainerClass))

typedef struct _RygelMediaExportNodeQueryContainer RygelMediaExportNodeQueryContainer;
typedef struct _RygelMediaExportNodeQueryContainerClass RygelMediaExportNodeQueryContainerClass;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))

struct _RygelMediaExportQueryContainerFactory {
	GObject parent_instance;
	RygelMediaExportQueryContainerFactoryPrivate * priv;
};

struct _RygelMediaExportQueryContainerFactoryClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportQueryContainerFactoryPrivate {
	GeeHashMap* virtual_container_map;
};


static gpointer rygel_media_export_query_container_factory_parent_class = NULL;
static RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_instance;
static RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_instance = NULL;

GType rygel_media_export_query_container_factory_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactoryPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_DUMMY_PROPERTY
};
RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_get_default (void);
static RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_new (void);
static RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_construct (GType object_type);
void rygel_media_export_query_container_factory_register_id (RygelMediaExportQueryContainerFactory* self, gchar** id);
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX "virtual-container:"
gchar* rygel_media_export_query_container_factory_get_virtual_container_definition (RygelMediaExportQueryContainerFactory* self, const gchar* hash);
GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_query_container_get_type (void) G_GNUC_CONST;
RygelMediaExportQueryContainer* rygel_media_export_query_container_factory_create_from_hashed_id (RygelMediaExportQueryContainerFactory* self, const gchar* id, const gchar* name);
RygelMediaExportQueryContainer* rygel_media_export_query_container_factory_create_from_description_id (RygelMediaExportQueryContainerFactory* self, const gchar* definition_id, const gchar* name);
static RygelSearchExpression* rygel_media_export_query_container_factory_parse_description (const gchar* description, gchar** pattern, gchar** attribute, gchar** upnp_class, gchar** name);
RygelMediaExportLeafQueryContainer* rygel_media_export_leaf_query_container_new (RygelSearchExpression* expression, const gchar* id, const gchar* name);
RygelMediaExportLeafQueryContainer* rygel_media_export_leaf_query_container_construct (GType object_type, RygelSearchExpression* expression, const gchar* id, const gchar* name);
GType rygel_media_export_leaf_query_container_get_type (void) G_GNUC_CONST;
RygelMediaExportNodeQueryContainer* rygel_media_export_node_query_container_new (RygelSearchExpression* expression, const gchar* id, const gchar* name, const gchar* template, const gchar* attribute);
RygelMediaExportNodeQueryContainer* rygel_media_export_node_query_container_construct (GType object_type, RygelSearchExpression* expression, const gchar* id, const gchar* name, const gchar* template, const gchar* attribute);
GType rygel_media_export_node_query_container_get_type (void) G_GNUC_CONST;
static gchar* rygel_media_export_query_container_factory_map_upnp_class (const gchar* attribute);
static void rygel_media_export_query_container_factory_update_search_expression (RygelSearchExpression** expression, const gchar* key, const gchar* value);
static void rygel_media_export_query_container_factory_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
#line 39 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	return self ? g_object_ref (self) : NULL;
#line 141 "rygel-media-export-query-container-factory.c"
}


RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_get_default (void) {
	RygelMediaExportQueryContainerFactory* result = NULL;
	RygelMediaExportQueryContainerFactory* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	RygelMediaExportQueryContainerFactory* _tmp3_ = NULL;
	RygelMediaExportQueryContainerFactory* _tmp4_ = NULL;
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp0_ = rygel_media_export_query_container_factory_instance;
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp1_ = G_UNLIKELY (_tmp0_ == NULL);
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	if (_tmp1_) {
#line 157 "rygel-media-export-query-container-factory.c"
		RygelMediaExportQueryContainerFactory* _tmp2_ = NULL;
#line 36 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp2_ = rygel_media_export_query_container_factory_new ();
#line 36 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_g_object_unref0 (rygel_media_export_query_container_factory_instance);
#line 36 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		rygel_media_export_query_container_factory_instance = _tmp2_;
#line 165 "rygel-media-export-query-container-factory.c"
	}
#line 39 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp3_ = rygel_media_export_query_container_factory_instance;
#line 39 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 39 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	result = _tmp4_;
#line 39 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	return result;
#line 175 "rygel-media-export-query-container-factory.c"
}


static RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_construct (GType object_type) {
	RygelMediaExportQueryContainerFactory * self = NULL;
	GeeHashMap* _tmp0_ = NULL;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	self = (RygelMediaExportQueryContainerFactory*) g_object_new (object_type, NULL);
#line 44 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 44 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_object_unref0 (self->priv->virtual_container_map);
#line 44 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	self->priv->virtual_container_map = _tmp0_;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	return self;
#line 192 "rygel-media-export-query-container-factory.c"
}


static RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_new (void) {
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	return rygel_media_export_query_container_factory_construct (RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY);
#line 199 "rygel-media-export-query-container-factory.c"
}


/**
     * Register a plaintext description for a query container. The passed
     * string will be modified to the checksum id of the container.
     *
     * @param id Originally contains the plaintext id which is replaced with
     *           the hashed id on return.
     */
void rygel_media_export_query_container_factory_register_id (RygelMediaExportQueryContainerFactory* self, gchar** id) {
	gchar* md5 = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_if_fail (self != NULL);
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_if_fail (*id != NULL);
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp0_ = *id;
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp1_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp0_, (gsize) (-1));
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	md5 = _tmp1_;
#line 59 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp2_ = self->priv->virtual_container_map;
#line 59 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp3_ = md5;
#line 59 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, _tmp3_);
#line 59 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	if (!_tmp4_) {
#line 237 "rygel-media-export-query-container-factory.c"
		GeeHashMap* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 60 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp5_ = self->priv->virtual_container_map;
#line 60 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp6_ = md5;
#line 60 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp7_ = *id;
#line 60 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, _tmp6_, _tmp7_);
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp8_ = md5;
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp9_ = *id;
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		g_debug ("rygel-media-export-query-container-factory.vala:61: Registering %s for" \
" %s", _tmp8_, _tmp9_);
#line 257 "rygel-media-export-query-container-factory.c"
	}
#line 64 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp10_ = md5;
#line 64 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp11_ = g_strconcat (RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, _tmp10_, NULL);
#line 64 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (*id);
#line 64 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	*id = _tmp11_;
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (md5);
#line 269 "rygel-media-export-query-container-factory.c"
}


/**
     * Get the plaintext definition from a hashed id.
     *
     * Inverse function of register_id().
     *
     * @param hash A hashed id
     * @return the plaintext defintion of the virtual folder
     */
static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 290 "rygel-media-export-query-container-factory.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 321 "rygel-media-export-query-container-factory.c"
				goto __catch52_g_regex_error;
			}
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return NULL;
#line 330 "rygel-media-export-query-container-factory.c"
		}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 346 "rygel-media-export-query-container-factory.c"
				goto __catch52_g_regex_error;
			}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return NULL;
#line 357 "rygel-media-export-query-container-factory.c"
		}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 371 "rygel-media-export-query-container-factory.c"
	}
	goto __finally52;
	__catch52_g_regex_error:
	{
		GError* e = NULL;
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1287 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 385 "rygel-media-export-query-container-factory.c"
	}
	__finally52:
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return NULL;
#line 396 "rygel-media-export-query-container-factory.c"
	}
}


gchar* rygel_media_export_query_container_factory_get_virtual_container_definition (RygelMediaExportQueryContainerFactory* self, const gchar* hash) {
	gchar* result = NULL;
	gchar* id = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_val_if_fail (hash != NULL, NULL);
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp0_ = hash;
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp1_ = string_replace (_tmp0_, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	id = _tmp1_;
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp2_ = self->priv->virtual_container_map;
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, id);
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	result = (gchar*) _tmp3_;
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (id);
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	return result;
#line 428 "rygel-media-export-query-container-factory.c"
}


/**
     * Factory method.
     *
     * Create a QueryContainer directly from MD5 hashed id.
     *
     * @param id    The hashed id of the container
     * @param name  An the title of the container. If not supplied, it will
     *              be derived from the plain-text description of the
     *              container
     * @return A new instance of QueryContainer or null if id does not exist
     */
RygelMediaExportQueryContainer* rygel_media_export_query_container_factory_create_from_hashed_id (RygelMediaExportQueryContainerFactory* self, const gchar* id, const gchar* name) {
	RygelMediaExportQueryContainer* result = NULL;
	gchar* definition_id = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	RygelMediaExportQueryContainer* _tmp5_ = NULL;
#line 92 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 92 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 92 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp0_ = id;
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp1_ = rygel_media_export_query_container_factory_get_virtual_container_definition (self, _tmp0_);
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	definition_id = _tmp1_;
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp2_ = definition_id;
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	if (_tmp2_ == NULL) {
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		result = NULL;
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_g_free0 (definition_id);
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		return result;
#line 474 "rygel-media-export-query-container-factory.c"
	}
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp3_ = definition_id;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp4_ = name;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp5_ = rygel_media_export_query_container_factory_create_from_description_id (self, _tmp3_, _tmp4_);
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	result = _tmp5_;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (definition_id);
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	return result;
#line 488 "rygel-media-export-query-container-factory.c"
}


/**
     * Factory method.
     *
     * Create a QueryContainer from a plain-text description string.
     *
     * @param definition Plain-text defintion of the query-container
     * @param name       The title of the container. If not supplied, it
     *                   will be derived from the plain-text description of
     *                   the container
     * @return A new instance of QueryContainer
     */
RygelMediaExportQueryContainer* rygel_media_export_query_container_factory_create_from_description_id (RygelMediaExportQueryContainerFactory* self, const gchar* definition_id, const gchar* name) {
	RygelMediaExportQueryContainer* result = NULL;
	gchar* title = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* attribute = NULL;
	gchar* pattern = NULL;
	gchar* upnp_class = NULL;
	RygelMediaExportQueryContainer* container = NULL;
	gchar* id = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	RygelSearchExpression* expression = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	RygelSearchExpression* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp22_ = NULL;
#line 113 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 113 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_val_if_fail (definition_id != NULL, NULL);
#line 113 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp0_ = name;
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	title = _tmp1_;
#line 116 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	attribute = NULL;
#line 117 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	pattern = NULL;
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	upnp_class = NULL;
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp2_ = definition_id;
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	id = _tmp3_;
#line 122 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	rygel_media_export_query_container_factory_register_id (self, &id);
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp4_ = definition_id;
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp8_ = rygel_media_export_query_container_factory_parse_description (_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_, &title);
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (pattern);
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	pattern = _tmp5_;
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (attribute);
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	attribute = _tmp6_;
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (upnp_class);
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	upnp_class = _tmp7_;
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	expression = _tmp8_;
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp10_ = pattern;
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	if (_tmp10_ == NULL) {
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp9_ = TRUE;
#line 574 "rygel-media-export-query-container-factory.c"
	} else {
		const gchar* _tmp11_ = NULL;
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp11_ = pattern;
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp9_ = g_strcmp0 (_tmp11_, "") == 0;
#line 581 "rygel-media-export-query-container-factory.c"
	}
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	if (_tmp9_) {
#line 585 "rygel-media-export-query-container-factory.c"
		RygelSearchExpression* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		RygelMediaExportLeafQueryContainer* _tmp15_ = NULL;
#line 134 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp12_ = expression;
#line 134 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp13_ = id;
#line 134 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp14_ = title;
#line 134 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp15_ = rygel_media_export_leaf_query_container_new (_tmp12_, _tmp13_, _tmp14_);
#line 134 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_g_object_unref0 (container);
#line 134 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		container = (RygelMediaExportQueryContainer*) _tmp15_;
#line 602 "rygel-media-export-query-container-factory.c"
	} else {
		RygelSearchExpression* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		RygelMediaExportNodeQueryContainer* _tmp21_ = NULL;
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp16_ = expression;
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp17_ = id;
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp18_ = title;
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp19_ = pattern;
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp20_ = attribute;
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp21_ = rygel_media_export_node_query_container_new (_tmp16_, _tmp17_, _tmp18_, _tmp19_, _tmp20_);
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_g_object_unref0 (container);
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		container = (RygelMediaExportQueryContainer*) _tmp21_;
#line 626 "rygel-media-export-query-container-factory.c"
	}
#line 145 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp22_ = upnp_class;
#line 145 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	if (_tmp22_ != NULL) {
#line 632 "rygel-media-export-query-container-factory.c"
		RygelMediaExportQueryContainer* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp23_ = container;
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp24_ = upnp_class;
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		rygel_media_object_set_upnp_class ((RygelMediaObject*) _tmp23_, _tmp24_);
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp25_ = upnp_class;
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		if (g_strcmp0 (_tmp25_, RYGEL_MEDIA_CONTAINER_MUSIC_ALBUM) == 0) {
#line 646 "rygel-media-export-query-container-factory.c"
			RygelMediaExportQueryContainer* _tmp26_ = NULL;
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp26_ = container;
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			rygel_media_container_set_sort_criteria ((RygelMediaContainer*) _tmp26_, RYGEL_MEDIA_CONTAINER_ALBUM_SORT_CRITERIA);
#line 652 "rygel-media-export-query-container-factory.c"
		}
	}
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	result = container;
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_rygel_search_expression_unref0 (expression);
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (id);
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (upnp_class);
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (pattern);
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (attribute);
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (title);
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	return result;
#line 671 "rygel-media-export-query-container-factory.c"
}


/**
     * Map a DIDL attribute to a UPnP container class.
     *
     * @return A matching UPnP class for the attribute or null if it can't be
     *         mapped.
     */
static gchar* rygel_media_export_query_container_factory_map_upnp_class (const gchar* attribute) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	static GQuark _tmp2_label0 = 0;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	static GQuark _tmp2_label1 = 0;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	static GQuark _tmp2_label2 = 0;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	static GQuark _tmp2_label3 = 0;
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_val_if_fail (attribute != NULL, NULL);
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp0_ = attribute;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp1_ = _tmp0_;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("upnp:album")))) {
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		switch (0) {
#line 706 "rygel-media-export-query-container-factory.c"
			default:
			{
				gchar* _tmp4_ = NULL;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_tmp4_ = g_strdup (RYGEL_MEDIA_CONTAINER_MUSIC_ALBUM);
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				result = _tmp4_;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				return result;
#line 716 "rygel-media-export-query-container-factory.c"
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("dc:creator")))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("upnp:artist"))))) {
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		switch (0) {
#line 722 "rygel-media-export-query-container-factory.c"
			default:
			{
				gchar* _tmp5_ = NULL;
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_tmp5_ = g_strdup (RYGEL_MEDIA_CONTAINER_MUSIC_ARTIST);
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				result = _tmp5_;
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				return result;
#line 732 "rygel-media-export-query-container-factory.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("dc:genre")))) {
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		switch (0) {
#line 738 "rygel-media-export-query-container-factory.c"
			default:
			{
				gchar* _tmp6_ = NULL;
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_tmp6_ = g_strdup (RYGEL_MEDIA_CONTAINER_MUSIC_GENRE);
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				result = _tmp6_;
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				return result;
#line 748 "rygel-media-export-query-container-factory.c"
			}
		}
	} else {
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		switch (0) {
#line 754 "rygel-media-export-query-container-factory.c"
			default:
			{
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				result = NULL;
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				return result;
#line 761 "rygel-media-export-query-container-factory.c"
			}
		}
	}
}


/**
     * Parse a plaintext container description into a search expression.
     *
     * Also generates a name for the container and other meta-data necessary
     * for node containers.
     *
     * @param description The plaintext container description
     * @param pattern     Contains the pattern used for child containers if
     *                    descrption is for a node container, null otherwise.
     * @param attribute   Contains the UPnP attribute the container describes.
     * @param name        If passed empty, name will be generated from the
     *                    description.
     * @return A SearchExpression corresponding to the non-variable part of
     *         the description.
     */
static gpointer _rygel_search_expression_ref0 (gpointer self) {
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	return self ? rygel_search_expression_ref (self) : NULL;
#line 786 "rygel-media-export-query-container-factory.c"
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
#line 964 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = separator;
#line 964 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp0_ == NULL) {
#line 965 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		separator = "";
#line 803 "rygel-media-export-query-container-factory.c"
	}
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = str_array;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3__length1 = str_array_length1;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = TRUE;
#line 813 "rygel-media-export-query-container-factory.c"
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = str_array;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4__length1 = str_array_length1;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp4__length1 > 0;
#line 823 "rygel-media-export-query-container-factory.c"
	}
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp2_) {
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 829 "rygel-media-export-query-container-factory.c"
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = str_array;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6__length1 = str_array_length1;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (_tmp6__length1 == (-1)) {
#line 840 "rygel-media-export-query-container-factory.c"
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			const gchar* _tmp8_ = NULL;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp7_ = str_array;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp7__length1 = str_array_length1;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp8_ = _tmp7_[0];
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp5_ = _tmp8_ != NULL;
#line 852 "rygel-media-export-query-container-factory.c"
		} else {
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp5_ = FALSE;
#line 856 "rygel-media-export-query-container-factory.c"
		}
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp1_ = _tmp5_;
#line 860 "rygel-media-export-query-container-factory.c"
	}
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp1_) {
#line 864 "rygel-media-export-query-container-factory.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gsize _tmp35_ = 0UL;
		const gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		const gchar* res = NULL;
		gsize _tmp40_ = 0UL;
		void* _tmp41_ = NULL;
		void* ptr = NULL;
		const gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		void* _tmp45_ = NULL;
		const gchar* _tmp62_ = NULL;
#line 969 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		len = (gsize) 1;
#line 887 "rygel-media-export-query-container-factory.c"
		{
			gboolean _tmp9_ = FALSE;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			i = 0;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp9_ = TRUE;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 896 "rygel-media-export-query-container-factory.c"
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp21_ = 0;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				const gchar* _tmp24_ = NULL;
				gsize _tmp30_ = 0UL;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (!_tmp9_) {
#line 909 "rygel-media-export-query-container-factory.c"
					gint _tmp10_ = 0;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp10_ = i;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					i = _tmp10_ + 1;
#line 915 "rygel-media-export-query-container-factory.c"
				}
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp9_ = FALSE;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp13_ = str_array;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp13__length1 = str_array_length1;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (_tmp13__length1 != (-1)) {
#line 925 "rygel-media-export-query-container-factory.c"
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp14_ = i;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp15_ = str_array;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp15__length1 = str_array_length1;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp12_ = _tmp14_ < _tmp15__length1;
#line 937 "rygel-media-export-query-container-factory.c"
				} else {
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp12_ = FALSE;
#line 941 "rygel-media-export-query-container-factory.c"
				}
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (_tmp12_) {
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp11_ = TRUE;
#line 947 "rygel-media-export-query-container-factory.c"
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp17_ = str_array;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp17__length1 = str_array_length1;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					if (_tmp17__length1 == (-1)) {
#line 958 "rygel-media-export-query-container-factory.c"
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						gint _tmp19_ = 0;
						const gchar* _tmp20_ = NULL;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp18_ = str_array;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp18__length1 = str_array_length1;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp19_ = i;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp20_ = _tmp18_[_tmp19_];
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp16_ = _tmp20_ != NULL;
#line 973 "rygel-media-export-query-container-factory.c"
					} else {
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp16_ = FALSE;
#line 977 "rygel-media-export-query-container-factory.c"
					}
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp11_ = _tmp16_;
#line 981 "rygel-media-export-query-container-factory.c"
				}
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (!_tmp11_) {
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					break;
#line 987 "rygel-media-export-query-container-factory.c"
				}
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp22_ = str_array;
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp22__length1 = str_array_length1;
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp23_ = i;
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp24_ = _tmp22_[_tmp23_];
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (_tmp24_ != NULL) {
#line 999 "rygel-media-export-query-container-factory.c"
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp25_ = str_array;
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp25__length1 = str_array_length1;
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp26_ = i;
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp27_ = _tmp25_[_tmp26_];
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp28_ = strlen ((const gchar*) _tmp27_);
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp29_ = _tmp28_;
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp21_ = _tmp29_;
#line 1020 "rygel-media-export-query-container-factory.c"
				} else {
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp21_ = 0;
#line 1024 "rygel-media-export-query-container-factory.c"
				}
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp30_ = len;
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				len = _tmp30_ + _tmp21_;
#line 1030 "rygel-media-export-query-container-factory.c"
			}
		}
#line 973 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp31_ = i;
#line 973 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (_tmp31_ == 0) {
#line 1037 "rygel-media-export-query-container-factory.c"
			gchar* _tmp32_ = NULL;
#line 974 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp32_ = g_strdup ("");
#line 974 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			result = _tmp32_;
#line 974 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return result;
#line 1045 "rygel-media-export-query-container-factory.c"
		}
#line 976 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp33_ = i;
#line 976 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		str_array_length1 = _tmp33_;
#line 976 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp34_ = str_array_length1;
#line 977 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp35_ = len;
#line 977 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp36_ = separator;
#line 977 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp37_ = strlen ((const gchar*) _tmp36_);
#line 977 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp38_ = _tmp37_;
#line 977 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp39_ = i;
#line 977 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
#line 979 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp40_ = len;
#line 979 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp41_ = g_malloc (_tmp40_);
#line 979 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		res = _tmp41_;
#line 980 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp42_ = res;
#line 980 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp43_ = str_array;
#line 980 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp43__length1 = str_array_length1;
#line 980 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp44_ = _tmp43_[0];
#line 980 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
#line 980 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		ptr = _tmp45_;
#line 1083 "rygel-media-export-query-container-factory.c"
		{
			gboolean _tmp46_ = FALSE;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			i = 1;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp46_ = TRUE;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 1092 "rygel-media-export-query-container-factory.c"
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				void* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				void* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp55_ = 0;
				const gchar* _tmp56_ = NULL;
				void* _tmp60_ = NULL;
				void* _tmp61_ = NULL;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (!_tmp46_) {
#line 1108 "rygel-media-export-query-container-factory.c"
					gint _tmp47_ = 0;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp47_ = i;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					i = _tmp47_ + 1;
#line 1114 "rygel-media-export-query-container-factory.c"
				}
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp46_ = FALSE;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp48_ = i;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp49_ = str_array;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp49__length1 = str_array_length1;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (!(_tmp48_ < _tmp49__length1)) {
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					break;
#line 1128 "rygel-media-export-query-container-factory.c"
				}
#line 982 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp50_ = ptr;
#line 982 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp51_ = separator;
#line 982 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
#line 982 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				ptr = _tmp52_;
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp54_ = str_array;
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp54__length1 = str_array_length1;
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp55_ = i;
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp56_ = _tmp54_[_tmp55_];
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (_tmp56_ != NULL) {
#line 1148 "rygel-media-export-query-container-factory.c"
					gchar** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp58_ = 0;
					const gchar* _tmp59_ = NULL;
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp57_ = str_array;
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp57__length1 = str_array_length1;
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp58_ = i;
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp59_ = _tmp57_[_tmp58_];
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp53_ = (const gchar*) _tmp59_;
#line 1163 "rygel-media-export-query-container-factory.c"
				} else {
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp53_ = "";
#line 1167 "rygel-media-export-query-container-factory.c"
				}
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp60_ = ptr;
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				ptr = _tmp61_;
#line 1175 "rygel-media-export-query-container-factory.c"
			}
		}
#line 986 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp62_ = res;
#line 986 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		res = NULL;
#line 986 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (gchar*) _tmp62_;
#line 986 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 1186 "rygel-media-export-query-container-factory.c"
	} else {
		gchar* _tmp63_ = NULL;
#line 988 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp63_ = g_strdup ("");
#line 988 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp63_;
#line 988 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 1195 "rygel-media-export-query-container-factory.c"
	}
}


static RygelSearchExpression* rygel_media_export_query_container_factory_parse_description (const gchar* description, gchar** pattern, gchar** attribute, gchar** upnp_class, gchar** name) {
	gchar* _vala_pattern = NULL;
	gchar* _vala_attribute = NULL;
	gchar* _vala_upnp_class = NULL;
	RygelSearchExpression* result = NULL;
	gchar** args = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	RygelSearchExpression* expression = NULL;
	gpointer _tmp3_ = NULL;
	RygelSearchExpression* _tmp4_ = NULL;
	gint i = 0;
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_val_if_fail (description != NULL, NULL);
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_val_if_fail (*name != NULL, NULL);
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp0_ = description;
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ",", 0);
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	args = _tmp2_;
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	args_length1 = _vala_array_length (_tmp1_);
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_args_size_ = args_length1;
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp3_ = NULL;
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp4_ = _rygel_search_expression_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, RYGEL_TYPE_SEARCH_EXPRESSION) ? ((RygelSearchExpression*) _tmp3_) : NULL);
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	expression = _tmp4_;
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (_vala_pattern);
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_vala_pattern = NULL;
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (_vala_attribute);
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_vala_attribute = NULL;
#line 201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (_vala_upnp_class);
#line 201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_vala_upnp_class = NULL;
#line 203 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	i = 0;
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	while (TRUE) {
#line 1251 "rygel-media-export-query-container-factory.c"
		gint _tmp5_ = 0;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		gchar* previous_attribute = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		gint _tmp10_ = 0;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar** _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		gint _tmp16_ = 0;
		const gchar* _tmp17_ = NULL;
		gint _tmp43_ = 0;
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp5_ = i;
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp6_ = args;
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp6__length1 = args_length1;
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		if (!(_tmp5_ < _tmp6__length1)) {
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			break;
#line 1280 "rygel-media-export-query-container-factory.c"
		}
#line 205 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp7_ = _vala_attribute;
#line 205 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp8_ = g_strdup (_tmp7_);
#line 205 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		previous_attribute = _tmp8_;
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp9_ = args;
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp9__length1 = args_length1;
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp10_ = i;
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp11_ = _tmp9_[_tmp10_];
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp12_ = string_replace (_tmp11_, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_g_free0 (_vala_attribute);
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_vala_attribute = _tmp12_;
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp13_ = _vala_attribute;
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp14_ = g_uri_unescape_string (_tmp13_, NULL);
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_g_free0 (_vala_attribute);
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_vala_attribute = _tmp14_;
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp15_ = args;
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp15__length1 = args_length1;
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp16_ = i;
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp17_ = _tmp15_[_tmp16_ + 1];
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		if (g_strcmp0 (_tmp17_, "?") != 0) {
#line 1320 "rygel-media-export-query-container-factory.c"
			gchar** _tmp18_ = NULL;
			gint _tmp18__length1 = 0;
			gint _tmp19_ = 0;
			const gchar* _tmp20_ = NULL;
			gchar** _tmp21_ = NULL;
			gint _tmp21__length1 = 0;
			gint _tmp22_ = 0;
			const gchar* _tmp23_ = NULL;
			gint _tmp24_ = 0;
			gchar** _tmp25_ = NULL;
			gint _tmp25__length1 = 0;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp18_ = args;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp18__length1 = args_length1;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp19_ = i;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp20_ = _tmp18_[_tmp19_];
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp21_ = args;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp21__length1 = args_length1;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp22_ = i;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp23_ = _tmp21_[_tmp22_ + 1];
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			rygel_media_export_query_container_factory_update_search_expression (&expression, _tmp20_, _tmp23_);
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp24_ = i;
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp25_ = args;
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp25__length1 = args_length1;
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			if ((_tmp24_ + 2) == _tmp25__length1) {
#line 1358 "rygel-media-export-query-container-factory.c"
				const gchar* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_tmp26_ = _vala_attribute;
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_tmp27_ = rygel_media_export_query_container_factory_map_upnp_class (_tmp26_);
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_g_free0 (_vala_upnp_class);
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_vala_upnp_class = _tmp27_;
#line 1369 "rygel-media-export-query-container-factory.c"
			}
		} else {
			gchar** _tmp28_ = NULL;
			gint _tmp28__length1 = 0;
			gint _tmp29_ = 0;
			gchar* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
			gchar** _tmp32_ = NULL;
			gint _tmp32__length1 = 0;
			gchar* _tmp33_ = NULL;
			const gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			gboolean _tmp36_ = FALSE;
			const gchar* _tmp37_ = NULL;
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp28_ = args;
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp28__length1 = args_length1;
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp29_ = i;
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp30_ = g_strdup ("%s");
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_g_free0 (_tmp28_[_tmp29_ + 1]);
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp28_[_tmp29_ + 1] = _tmp30_;
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp31_ = _tmp28_[_tmp29_ + 1];
#line 222 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp32_ = args;
#line 222 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp32__length1 = args_length1;
#line 222 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp33_ = _vala_g_strjoinv (",", _tmp32_, _tmp32__length1);
#line 222 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_g_free0 (_vala_pattern);
#line 222 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_vala_pattern = _tmp33_;
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp34_ = previous_attribute;
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp35_ = rygel_media_export_query_container_factory_map_upnp_class (_tmp34_);
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_g_free0 (_vala_upnp_class);
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_vala_upnp_class = _tmp35_;
#line 229 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_tmp37_ = *name;
#line 229 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			if (g_strcmp0 (_tmp37_, "") == 0) {
#line 1420 "rygel-media-export-query-container-factory.c"
				gint _tmp38_ = 0;
#line 229 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_tmp38_ = i;
#line 229 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_tmp36_ = _tmp38_ > 0;
#line 1426 "rygel-media-export-query-container-factory.c"
			} else {
#line 229 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_tmp36_ = FALSE;
#line 1430 "rygel-media-export-query-container-factory.c"
			}
#line 229 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			if (_tmp36_) {
#line 1434 "rygel-media-export-query-container-factory.c"
				gchar** _tmp39_ = NULL;
				gint _tmp39__length1 = 0;
				gint _tmp40_ = 0;
				const gchar* _tmp41_ = NULL;
				gchar* _tmp42_ = NULL;
#line 230 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_tmp39_ = args;
#line 230 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_tmp39__length1 = args_length1;
#line 230 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_tmp40_ = i;
#line 230 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_tmp41_ = _tmp39_[_tmp40_ - 1];
#line 230 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_tmp42_ = g_uri_unescape_string (_tmp41_, NULL);
#line 230 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				_g_free0 (*name);
#line 230 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
				*name = _tmp42_;
#line 1454 "rygel-media-export-query-container-factory.c"
			}
#line 233 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			_g_free0 (previous_attribute);
#line 233 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
			break;
#line 1460 "rygel-media-export-query-container-factory.c"
		}
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp43_ = i;
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		i = _tmp43_ + 2;
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_g_free0 (previous_attribute);
#line 1468 "rygel-media-export-query-container-factory.c"
	}
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	result = expression;
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	if (pattern) {
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		*pattern = _vala_pattern;
#line 1478 "rygel-media-export-query-container-factory.c"
	} else {
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_g_free0 (_vala_pattern);
#line 1482 "rygel-media-export-query-container-factory.c"
	}
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	if (attribute) {
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		*attribute = _vala_attribute;
#line 1488 "rygel-media-export-query-container-factory.c"
	} else {
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_g_free0 (_vala_attribute);
#line 1492 "rygel-media-export-query-container-factory.c"
	}
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	if (upnp_class) {
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		*upnp_class = _vala_upnp_class;
#line 1498 "rygel-media-export-query-container-factory.c"
	} else {
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_g_free0 (_vala_upnp_class);
#line 1502 "rygel-media-export-query-container-factory.c"
	}
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	return result;
#line 1506 "rygel-media-export-query-container-factory.c"
}


/**
     * Update a SearchExpression with a new key = value condition.
     *
     * Will modifiy the passed expression to (expression AND (key = value))
     *
     * @param expression The expression to update or null to create a new one
     * @param key        Key of the key/value condition
     * @param value      Value of the key/value condition
     */
static void rygel_media_export_query_container_factory_update_search_expression (RygelSearchExpression** expression, const gchar* key, const gchar* value) {
	RygelRelationalExpression* subexpression = NULL;
	RygelRelationalExpression* _tmp0_ = NULL;
	gchar* clean_key = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	RygelRelationalExpression* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	RygelRelationalExpression* _tmp6_ = NULL;
	RygelRelationalExpression* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	RygelSearchExpression* _tmp10_ = NULL;
#line 251 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_if_fail (key != NULL);
#line 251 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_return_if_fail (value != NULL);
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp0_ = rygel_relational_expression_new ();
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	subexpression = _tmp0_;
#line 256 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp1_ = key;
#line 256 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp2_ = string_replace (_tmp1_, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
#line 256 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	clean_key = _tmp2_;
#line 257 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp3_ = subexpression;
#line 257 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp4_ = clean_key;
#line 257 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp5_ = g_uri_unescape_string (_tmp4_, NULL);
#line 257 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (((RygelSearchExpression*) _tmp3_)->operand1);
#line 257 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	((RygelSearchExpression*) _tmp3_)->operand1 = _tmp5_;
#line 258 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp6_ = subexpression;
#line 258 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	((RygelSearchExpression*) _tmp6_)->op = (gpointer) ((gintptr) GUPNP_SEARCH_CRITERIA_OP_EQ);
#line 259 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp7_ = subexpression;
#line 259 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp8_ = value;
#line 259 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp9_ = g_uri_unescape_string (_tmp8_, NULL);
#line 259 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (((RygelSearchExpression*) _tmp7_)->operand2);
#line 259 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	((RygelSearchExpression*) _tmp7_)->operand2 = _tmp9_;
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_tmp10_ = *expression;
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	if (_tmp10_ != NULL) {
#line 1575 "rygel-media-export-query-container-factory.c"
		RygelLogicalExpression* conjunction = NULL;
		RygelLogicalExpression* _tmp11_ = NULL;
		RygelLogicalExpression* _tmp12_ = NULL;
		RygelSearchExpression* _tmp13_ = NULL;
		RygelSearchExpression* _tmp14_ = NULL;
		RygelLogicalExpression* _tmp15_ = NULL;
		RygelRelationalExpression* _tmp16_ = NULL;
		RygelSearchExpression* _tmp17_ = NULL;
		RygelLogicalExpression* _tmp18_ = NULL;
		RygelLogicalExpression* _tmp19_ = NULL;
		RygelSearchExpression* _tmp20_ = NULL;
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp11_ = rygel_logical_expression_new ();
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		conjunction = _tmp11_;
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp12_ = conjunction;
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp13_ = *expression;
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp14_ = _rygel_search_expression_ref0 (_tmp13_);
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _tmp12_)->operand1);
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		((RygelSearchExpression*) _tmp12_)->operand1 = _tmp14_;
#line 264 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp15_ = conjunction;
#line 264 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp16_ = subexpression;
#line 264 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp17_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) _tmp16_);
#line 264 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _tmp15_)->operand2);
#line 264 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		((RygelSearchExpression*) _tmp15_)->operand2 = _tmp17_;
#line 265 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp18_ = conjunction;
#line 265 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		((RygelSearchExpression*) _tmp18_)->op = (gpointer) ((gintptr) RYGEL_LOGICAL_OPERATOR_AND);
#line 266 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp19_ = conjunction;
#line 266 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp20_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) _tmp19_);
#line 266 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_rygel_search_expression_unref0 (*expression);
#line 266 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		*expression = _tmp20_;
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_rygel_search_expression_unref0 (conjunction);
#line 1625 "rygel-media-export-query-container-factory.c"
	} else {
		RygelRelationalExpression* _tmp21_ = NULL;
		RygelSearchExpression* _tmp22_ = NULL;
#line 268 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp21_ = subexpression;
#line 268 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_tmp22_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) _tmp21_);
#line 268 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		_rygel_search_expression_unref0 (*expression);
#line 268 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
		*expression = _tmp22_;
#line 1637 "rygel-media-export-query-container-factory.c"
	}
#line 251 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_free0 (clean_key);
#line 251 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_rygel_search_expression_unref0 (subexpression);
#line 1643 "rygel-media-export-query-container-factory.c"
}


static void rygel_media_export_query_container_factory_class_init (RygelMediaExportQueryContainerFactoryClass * klass) {
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	rygel_media_export_query_container_factory_parent_class = g_type_class_peek_parent (klass);
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaExportQueryContainerFactoryPrivate));
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_query_container_factory_finalize;
#line 1654 "rygel-media-export-query-container-factory.c"
}


static void rygel_media_export_query_container_factory_instance_init (RygelMediaExportQueryContainerFactory * self) {
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	self->priv = RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_GET_PRIVATE (self);
#line 1661 "rygel-media-export-query-container-factory.c"
}


static void rygel_media_export_query_container_factory_finalize (GObject* obj) {
	RygelMediaExportQueryContainerFactory * self;
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactory);
#line 31 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	_g_object_unref0 (self->priv->virtual_container_map);
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container-factory.vala"
	G_OBJECT_CLASS (rygel_media_export_query_container_factory_parent_class)->finalize (obj);
#line 1673 "rygel-media-export-query-container-factory.c"
}


/**
 * A helper class to create QueryContainer instances based on IDs.
 */
GType rygel_media_export_query_container_factory_get_type (void) {
	static volatile gsize rygel_media_export_query_container_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_query_container_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportQueryContainerFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_query_container_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportQueryContainerFactory), 0, (GInstanceInitFunc) rygel_media_export_query_container_factory_instance_init, NULL };
		GType rygel_media_export_query_container_factory_type_id;
		rygel_media_export_query_container_factory_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportQueryContainerFactory", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_query_container_factory_type_id__volatile, rygel_media_export_query_container_factory_type_id);
	}
	return rygel_media_export_query_container_factory_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



