/* rygel-browse.c generated by valac 0.40.8, the Vala compiler
 * generated from rygel-browse.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2007 OpenedHand Ltd.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Jorn Baayen <jorn@openedhand.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;
typedef struct _RygelMediaQueryActionPrivate RygelMediaQueryActionPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

#define RYGEL_TYPE_BROWSE (rygel_browse_get_type ())
#define RYGEL_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BROWSE, RygelBrowse))
#define RYGEL_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BROWSE, RygelBrowseClass))
#define RYGEL_IS_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BROWSE))
#define RYGEL_IS_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BROWSE))
#define RYGEL_BROWSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BROWSE, RygelBrowseClass))

typedef struct _RygelBrowse RygelBrowse;
typedef struct _RygelBrowseClass RygelBrowseClass;
typedef struct _RygelBrowsePrivate RygelBrowsePrivate;
enum  {
	RYGEL_BROWSE_0_PROPERTY,
	RYGEL_BROWSE_NUM_PROPERTIES
};
static GParamSpec* rygel_browse_properties[RYGEL_BROWSE_NUM_PROPERTIES];

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GUPnPServiceAction_free0(var) ((var == NULL) ? NULL : (var = (_vala_GUPnPServiceAction_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelBrowseFetchResultsData RygelBrowseFetchResultsData;
typedef struct _RygelBrowseHandleChildrenRequestData RygelBrowseHandleChildrenRequestData;

struct _RygelMediaQueryAction {
	GObject parent_instance;
	RygelMediaQueryActionPrivate * priv;
	gchar* object_id;
	gchar* browse_flag;
	gchar* filter;
	guint index;
	guint requested_count;
	gchar* sort_criteria;
	guint number_returned;
	guint total_matches;
	guint update_id;
	RygelMediaContainer* root_container;
	RygelHTTPServer* http_server;
	guint32 system_update_id;
	GUPnPServiceAction* action;
	RygelSerializer* serializer;
	RygelClientHacks* hacks;
	gchar* object_id_arg;
};

struct _RygelMediaQueryActionClass {
	GObjectClass parent_class;
	void (*parse_args) (RygelMediaQueryAction* self, GError** error);
	void (*fetch_results) (RygelMediaQueryAction* self, RygelMediaObject* media_object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*fetch_results_finish) (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error);
	void (*handle_error) (RygelMediaQueryAction* self, GError* _error_);
};

struct _RygelBrowse {
	RygelMediaQueryAction parent_instance;
	RygelBrowsePrivate * priv;
};

struct _RygelBrowseClass {
	RygelMediaQueryActionClass parent_class;
};

struct _RygelBrowsePrivate {
	gboolean fetch_metadata;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_CURRENT_TAG_VALUE = 702,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE = 703,
	RYGEL_CONTENT_DIRECTORY_ERROR_REQUIRED_TAG = 704,
	RYGEL_CONTENT_DIRECTORY_ERROR_READ_ONLY_TAG = 705,
	RYGEL_CONTENT_DIRECTORY_ERROR_PARAMETER_MISMATCH = 706,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SEARCH_CRITERIA = 708,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER = 710,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_FILE_TRANSFER = 717,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_OUTDATED_OBJECT_METADATA = 728,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelBrowseFetchResultsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelBrowse* self;
	RygelMediaObject* media_object;
	RygelMediaObjects* result;
	gboolean _tmp0_;
	RygelMediaObjects* _tmp1_;
	RygelMediaObjects* _tmp2_;
	RygelMediaObjects* _tmp3_;
	RygelMediaObjects* _tmp4_;
	RygelMediaObjects* _tmp5_;
	RygelMediaObjects* _tmp6_;
	GError * _inner_error_;
};

struct _RygelBrowseHandleChildrenRequestData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelBrowse* self;
	RygelMediaObject* media_object;
	RygelMediaObjects* result;
	GError* _tmp0_;
	RygelMediaContainer* container;
	RygelMediaContainer* _tmp1_;
	gboolean _tmp2_;
	RygelMediaContainer* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	RygelMediaContainer* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	RygelMediaContainer* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	guint _tmp12_;
	guint _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	RygelMediaContainer* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* sort_criteria;
	gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	RygelMediaContainer* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	guint _tmp28_;
	const gchar* _tmp29_;
	guint _tmp30_;
	RygelMediaObjects* children;
	RygelMediaContainer* _tmp31_;
	guint _tmp32_;
	guint _tmp33_;
	const gchar* _tmp34_;
	GCancellable* _tmp35_;
	GCancellable* _tmp36_;
	RygelMediaObjects* _tmp37_;
	guint _tmp38_;
	const gchar* _tmp39_;
	guint _tmp40_;
	GError * _inner_error_;
};


static gpointer rygel_browse_parent_class = NULL;

GType rygel_media_query_action_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_browse_get_type (void) G_GNUC_CONST;
#define RYGEL_BROWSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_BROWSE, RygelBrowsePrivate))
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
RygelBrowse* rygel_browse_new (RygelContentDirectory* content_dir,
                               GUPnPServiceAction* action);
RygelBrowse* rygel_browse_construct (GType object_type,
                                     RygelContentDirectory* content_dir,
                                     GUPnPServiceAction* action);
static GUPnPServiceAction* _vala_GUPnPServiceAction_copy (GUPnPServiceAction* self);
RygelMediaQueryAction* rygel_media_query_action_construct (GType object_type,
                                                           RygelContentDirectory* content_dir,
                                                           GUPnPServiceAction* action);
const gchar* rygel_client_hacks_get_object_id (RygelClientHacks* self);
static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self);
static void rygel_browse_real_parse_args (RygelMediaQueryAction* base,
                                   GError** error);
void rygel_media_query_action_parse_args (RygelMediaQueryAction* self,
                                          GError** error);
GQuark rygel_content_directory_error_quark (void);
static void rygel_browse_real_fetch_results_data_free (gpointer _data);
static void rygel_browse_real_fetch_results_async_ready_wrapper (GObject *source_object,
                                                          GAsyncResult *res,
                                                          void *user_data);
static void rygel_browse_real_fetch_results (RygelMediaQueryAction* base,
                                      RygelMediaObject* media_object,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static gboolean rygel_browse_real_fetch_results_co (RygelBrowseFetchResultsData* _data_);
static RygelMediaObjects* rygel_browse_handle_metadata_request (RygelBrowse* self,
                                                         RygelMediaObject* media_object,
                                                         GError** error);
static void rygel_browse_handle_children_request (RygelBrowse* self,
                                           RygelMediaObject* media_object,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static RygelMediaObjects* rygel_browse_handle_children_request_finish (RygelBrowse* self,
                                                                GAsyncResult* _res_,
                                                                GError** error);
static void rygel_browse_fetch_results_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
RygelMediaObjects* rygel_media_objects_new (void);
RygelMediaObjects* rygel_media_objects_construct (GType object_type);
static void rygel_browse_handle_children_request_data_free (gpointer _data);
static void rygel_browse_handle_children_request_async_ready_wrapper (GObject *source_object,
                                                               GAsyncResult *res,
                                                               void *user_data);
static gboolean rygel_browse_handle_children_request_co (RygelBrowseHandleChildrenRequestData* _data_);
gint rygel_media_container_get_child_count (RygelMediaContainer* self);
const gchar* rygel_media_container_get_sort_criteria (RygelMediaContainer* self);
void rygel_media_container_get_children (RygelMediaContainer* self,
                                         guint offset,
                                         guint max_count,
                                         const gchar* sort_criteria,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
RygelMediaObjects* rygel_media_container_get_children_finish (RygelMediaContainer* self,
                                                              GAsyncResult* _res_,
                                                              GError** error);
static void rygel_browse_handle_children_request_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void rygel_browse_real_handle_error (RygelMediaQueryAction* base,
                                     GError* _error_);
void rygel_media_query_action_handle_error (RygelMediaQueryAction* self,
                                            GError* _error_);
static void rygel_browse_finalize (GObject * obj);


static GUPnPServiceAction*
_vala_GUPnPServiceAction_copy (GUPnPServiceAction* self)
{
	return g_boxed_copy (gupnp_service_action_get_type (), self);
}


static gpointer
__vala_GUPnPServiceAction_copy0 (gpointer self)
{
	return self ? _vala_GUPnPServiceAction_copy (self) : NULL;
}


static void
_vala_GUPnPServiceAction_free (GUPnPServiceAction* self)
{
	g_boxed_free (gupnp_service_action_get_type (), self);
}


RygelBrowse*
rygel_browse_construct (GType object_type,
                        RygelContentDirectory* content_dir,
                        GUPnPServiceAction* action)
{
	RygelBrowse * self = NULL;
	GUPnPServiceAction* _tmp0_;
	RygelClientHacks* _tmp1_;
	g_return_val_if_fail (content_dir != NULL, NULL);
	g_return_val_if_fail (action != NULL, NULL);
	_tmp0_ = __vala_GUPnPServiceAction_copy0 (action);
	self = (RygelBrowse*) rygel_media_query_action_construct (object_type, content_dir, _tmp0_);
	_tmp1_ = ((RygelMediaQueryAction*) self)->hacks;
	if (_tmp1_ != NULL) {
		RygelClientHacks* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = ((RygelMediaQueryAction*) self)->hacks;
		_tmp3_ = rygel_client_hacks_get_object_id (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (((RygelMediaQueryAction*) self)->object_id_arg);
		((RygelMediaQueryAction*) self)->object_id_arg = _tmp5_;
	} else {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("ObjectID");
		_g_free0 (((RygelMediaQueryAction*) self)->object_id_arg);
		((RygelMediaQueryAction*) self)->object_id_arg = _tmp6_;
	}
	__vala_GUPnPServiceAction_free0 (action);
	return self;
}


RygelBrowse*
rygel_browse_new (RygelContentDirectory* content_dir,
                  GUPnPServiceAction* action)
{
	return rygel_browse_construct (RYGEL_TYPE_BROWSE, content_dir, action);
}


static void
rygel_browse_real_parse_args (RygelMediaQueryAction* base,
                              GError** error)
{
	RygelBrowse * self;
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	self = (RygelBrowse*) base;
	RYGEL_MEDIA_QUERY_ACTION_CLASS (rygel_browse_parent_class)->parse_args (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction), &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp0_ = ((RygelMediaQueryAction*) self)->action;
	gupnp_service_action_get (_tmp0_, "BrowseFlag", G_TYPE_STRING, &((RygelMediaQueryAction*) self)->browse_flag, NULL);
	_tmp2_ = ((RygelMediaQueryAction*) self)->browse_flag;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = ((RygelMediaQueryAction*) self)->browse_flag;
		_tmp1_ = g_strcmp0 (_tmp3_, "BrowseDirectChildren") == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		self->priv->fetch_metadata = FALSE;
	} else {
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		_tmp5_ = ((RygelMediaQueryAction*) self)->browse_flag;
		if (_tmp5_ != NULL) {
			const gchar* _tmp6_;
			_tmp6_ = ((RygelMediaQueryAction*) self)->browse_flag;
			_tmp4_ = g_strcmp0 (_tmp6_, "BrowseMetadata") == 0;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			self->priv->fetch_metadata = TRUE;
		} else {
			GError* _tmp7_;
			_tmp7_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _ ("Invalid Arguments"));
			_inner_error_ = _tmp7_;
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


static void
rygel_browse_real_fetch_results_data_free (gpointer _data)
{
	RygelBrowseFetchResultsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->media_object);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelBrowseFetchResultsData, _data_);
}


static void
rygel_browse_real_fetch_results_async_ready_wrapper (GObject *source_object,
                                                     GAsyncResult *res,
                                                     void *user_data)
{
	RygelBrowseFetchResultsData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
rygel_browse_real_fetch_results (RygelMediaQueryAction* base,
                                 RygelMediaObject* media_object,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	RygelBrowse * self;
	RygelBrowseFetchResultsData* _data_;
	RygelBrowse* _tmp0_;
	RygelMediaObject* _tmp1_;
	self = (RygelBrowse*) base;
	_data_ = g_slice_new0 (RygelBrowseFetchResultsData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rygel_browse_real_fetch_results_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_browse_real_fetch_results_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (media_object);
	_g_object_unref0 (_data_->media_object);
	_data_->media_object = _tmp1_;
	rygel_browse_real_fetch_results_co (_data_);
}


static RygelMediaObjects*
rygel_browse_real_fetch_results_finish (RygelMediaQueryAction* base,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	RygelMediaObjects* result;
	RygelBrowseFetchResultsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void
rygel_browse_fetch_results_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	RygelBrowseFetchResultsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_browse_real_fetch_results_co (_data_);
}


static gboolean
rygel_browse_real_fetch_results_co (RygelBrowseFetchResultsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->fetch_metadata;
	if (_data_->_tmp0_) {
		_data_->_tmp2_ = rygel_browse_handle_metadata_request (_data_->self, _data_->media_object, &_data_->_inner_error_);
		_data_->_tmp1_ = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp3_ = _data_->_tmp1_;
		_data_->_tmp1_ = NULL;
		_data_->result = _data_->_tmp3_;
		_g_object_unref0 (_data_->_tmp1_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_state_ = 1;
		rygel_browse_handle_children_request (_data_->self, _data_->media_object, rygel_browse_fetch_results_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp5_ = rygel_browse_handle_children_request_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp4_ = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp6_ = _data_->_tmp4_;
		_data_->_tmp4_ = NULL;
		_data_->result = _data_->_tmp6_;
		_g_object_unref0 (_data_->_tmp4_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}


static RygelMediaObjects*
rygel_browse_handle_metadata_request (RygelBrowse* self,
                                      RygelMediaObject* media_object,
                                      GError** error)
{
	RygelMediaObjects* result = NULL;
	RygelMediaObjects* results = NULL;
	RygelMediaObjects* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (media_object != NULL, NULL);
	((RygelMediaQueryAction*) self)->total_matches = (guint) 1;
	_tmp0_ = rygel_media_objects_new ();
	results = _tmp0_;
	gee_abstract_collection_add ((GeeAbstractCollection*) results, media_object);
	result = results;
	return result;
}


static void
rygel_browse_handle_children_request_data_free (gpointer _data)
{
	RygelBrowseHandleChildrenRequestData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->media_object);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelBrowseHandleChildrenRequestData, _data_);
}


static void
rygel_browse_handle_children_request_async_ready_wrapper (GObject *source_object,
                                                          GAsyncResult *res,
                                                          void *user_data)
{
	RygelBrowseHandleChildrenRequestData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void
rygel_browse_handle_children_request (RygelBrowse* self,
                                      RygelMediaObject* media_object,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	RygelBrowseHandleChildrenRequestData* _data_;
	RygelBrowse* _tmp0_;
	RygelMediaObject* _tmp1_;
	_data_ = g_slice_new0 (RygelBrowseHandleChildrenRequestData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rygel_browse_handle_children_request_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_browse_handle_children_request_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (media_object);
	_g_object_unref0 (_data_->media_object);
	_data_->media_object = _tmp1_;
	rygel_browse_handle_children_request_co (_data_);
}


static RygelMediaObjects*
rygel_browse_handle_children_request_finish (RygelBrowse* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	RygelMediaObjects* result;
	RygelBrowseHandleChildrenRequestData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void
rygel_browse_handle_children_request_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	RygelBrowseHandleChildrenRequestData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_browse_handle_children_request_co (_data_);
}


static gboolean
rygel_browse_handle_children_request_co (RygelBrowseHandleChildrenRequestData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_data_->media_object, RYGEL_TYPE_MEDIA_CONTAINER)) {
		_data_->_tmp0_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _ ("Cannot browse children on item"));
		_data_->_inner_error_ = _data_->_tmp0_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->media_object, RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer));
	_data_->container = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->container;
	_data_->_tmp4_ = rygel_media_container_get_child_count (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	if (-1 < _data_->_tmp5_) {
		_data_->_tmp6_ = _data_->container;
		_data_->_tmp7_ = rygel_media_container_get_child_count (_data_->_tmp6_);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp2_ = _data_->_tmp8_ < G_MAXINT;
	} else {
		_data_->_tmp2_ = FALSE;
	}
	if (_data_->_tmp2_) {
		_data_->_tmp9_ = _data_->container;
		_data_->_tmp10_ = rygel_media_container_get_child_count (_data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		((RygelMediaQueryAction*) _data_->self)->total_matches = (guint) _data_->_tmp11_;
	} else {
		((RygelMediaQueryAction*) _data_->self)->total_matches = (guint) 0;
	}
	_data_->_tmp12_ = ((RygelMediaQueryAction*) _data_->self)->requested_count;
	if (_data_->_tmp12_ == ((guint) 0)) {
		_data_->_tmp13_ = ((RygelMediaQueryAction*) _data_->self)->total_matches;
		((RygelMediaQueryAction*) _data_->self)->requested_count = _data_->_tmp13_;
	}
	_data_->_tmp15_ = ((RygelMediaQueryAction*) _data_->self)->sort_criteria;
	_data_->_tmp14_ = _data_->_tmp15_;
	if (_data_->_tmp14_ == NULL) {
		_data_->_tmp16_ = _data_->container;
		_data_->_tmp17_ = rygel_media_container_get_sort_criteria (_data_->_tmp16_);
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_tmp14_ = _data_->_tmp18_;
	}
	_data_->_tmp19_ = g_strdup (_data_->_tmp14_);
	_data_->sort_criteria = _data_->_tmp19_;
	_data_->_tmp21_ = ((RygelMediaQueryAction*) _data_->self)->sort_criteria;
	if (_data_->_tmp21_ == NULL) {
		_data_->_tmp22_ = _data_->container;
		_data_->_tmp23_ = rygel_media_container_get_sort_criteria (_data_->_tmp22_);
		_data_->_tmp24_ = _data_->_tmp23_;
		_data_->_tmp25_ = g_strdup_printf ("none, using default: %s", _data_->_tmp24_);
		_g_free0 (_data_->_tmp20_);
		_data_->_tmp20_ = _data_->_tmp25_;
	} else {
		_data_->_tmp26_ = ((RygelMediaQueryAction*) _data_->self)->sort_criteria;
		_data_->_tmp27_ = g_strdup (_data_->_tmp26_);
		_g_free0 (_data_->_tmp20_);
		_data_->_tmp20_ = _data_->_tmp27_;
	}
	_data_->_tmp28_ = ((RygelMediaQueryAction*) _data_->self)->requested_count;
	_data_->_tmp29_ = ((RygelMediaQueryAction*) _data_->self)->object_id;
	_data_->_tmp30_ = ((RygelMediaQueryAction*) _data_->self)->index;
	g_debug ("Fetching %u children of container '%s' from index %u " "with sort criteria %s", _data_->_tmp28_, _data_->_tmp29_, _data_->_tmp30_, _data_->_tmp20_);
	_data_->_tmp31_ = _data_->container;
	_data_->_tmp32_ = ((RygelMediaQueryAction*) _data_->self)->index;
	_data_->_tmp33_ = ((RygelMediaQueryAction*) _data_->self)->requested_count;
	_data_->_tmp34_ = _data_->sort_criteria;
	_data_->_tmp35_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
	_data_->_tmp36_ = _data_->_tmp35_;
	_data_->_state_ = 1;
	rygel_media_container_get_children (_data_->_tmp31_, _data_->_tmp32_, _data_->_tmp33_, _data_->_tmp34_, _data_->_tmp36_, rygel_browse_handle_children_request_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp37_ = rygel_media_container_get_children_finish (_data_->_tmp31_, _data_->_res_, &_data_->_inner_error_);
	_data_->children = _data_->_tmp37_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_free0 (_data_->_tmp20_);
		_g_free0 (_data_->sort_criteria);
		_g_object_unref0 (_data_->container);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp38_ = ((RygelMediaQueryAction*) _data_->self)->requested_count;
	_data_->_tmp39_ = ((RygelMediaQueryAction*) _data_->self)->object_id;
	_data_->_tmp40_ = ((RygelMediaQueryAction*) _data_->self)->index;
	g_debug ("rygel-browse.vala:125: Fetched %u children of container '%s' from inde" \
"x %u.", _data_->_tmp38_, _data_->_tmp39_, _data_->_tmp40_);
	_data_->result = _data_->children;
	_g_free0 (_data_->_tmp20_);
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->container);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void
rygel_browse_real_handle_error (RygelMediaQueryAction* base,
                                GError* _error_)
{
	RygelBrowse * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = (RygelBrowse*) base;
	_tmp0_ = ((RygelMediaQueryAction*) self)->object_id;
	_tmp1_ = _error_->message;
	g_warning (_ ("Failed to browse “%s”: %s\n"), _tmp0_, _tmp1_);
	RYGEL_MEDIA_QUERY_ACTION_CLASS (rygel_browse_parent_class)->handle_error (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction), _error_);
}


static void
rygel_browse_class_init (RygelBrowseClass * klass)
{
	rygel_browse_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelBrowsePrivate));
	((RygelMediaQueryActionClass *) klass)->parse_args = (void (*) (RygelMediaQueryAction *, GError**)) rygel_browse_real_parse_args;
	((RygelMediaQueryActionClass *) klass)->fetch_results = (void (*) (RygelMediaQueryAction *, RygelMediaObject*, GAsyncReadyCallback, gpointer)) rygel_browse_real_fetch_results;
	((RygelMediaQueryActionClass *) klass)->fetch_results_finish = (RygelMediaObjects* (*) (RygelMediaQueryAction *, GAsyncResult*, GError**)) rygel_browse_real_fetch_results_finish;
	((RygelMediaQueryActionClass *) klass)->handle_error = (void (*) (RygelMediaQueryAction *, GError*)) rygel_browse_real_handle_error;
	G_OBJECT_CLASS (klass)->finalize = rygel_browse_finalize;
}


static void
rygel_browse_instance_init (RygelBrowse * self)
{
	self->priv = RYGEL_BROWSE_GET_PRIVATE (self);
}


static void
rygel_browse_finalize (GObject * obj)
{
	RygelBrowse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_BROWSE, RygelBrowse);
	G_OBJECT_CLASS (rygel_browse_parent_class)->finalize (obj);
}


/**
 * Browse action implementation. This class is more or less the state-machine
 * associated with the Browse action handling that exists to make asynchronous
 * handling of Browse action possible.
 */
GType
rygel_browse_get_type (void)
{
	static volatile gsize rygel_browse_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_browse_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelBrowseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_browse_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelBrowse), 0, (GInstanceInitFunc) rygel_browse_instance_init, NULL };
		GType rygel_browse_type_id;
		rygel_browse_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_QUERY_ACTION, "RygelBrowse", &g_define_type_info, 0);
		g_once_init_leave (&rygel_browse_type_id__volatile, rygel_browse_type_id);
	}
	return rygel_browse_type_id__volatile;
}



