/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.types.ZipScanner;
import org.apache.tools.ant.util.MergingMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class Zip
extends MatchingTask {
    private File zipFile;
    private File baseDir;
    private boolean doCompress = true;
    protected String archiveType = "zip";
    private static long emptyCrc = new CRC32().getValue();
    protected String emptyBehavior = "skip";
    private Vector filesets = new Vector();
    private Hashtable addedDirs = new Hashtable();

    public void setZipfile(File file) {
        this.zipFile = file;
    }

    public void setBasedir(File file) {
        this.baseDir = file;
    }

    public void setCompress(boolean bl) {
        this.doCompress = bl;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void addZipfileset(ZipFileSet zipFileSet) {
        this.filesets.addElement(zipFileSet);
    }

    public void setWhenempty(String string) throws BuildException {
        if (!("fail".equals(string = string.toLowerCase()) || "skip".equals(string) || "create".equals(string))) {
            throw new BuildException("Unrecognized whenempty attribute: " + string);
        }
        this.emptyBehavior = string;
    }

    /*
     * Unable to fully structure code
     */
    public void execute() throws BuildException {
        if (this.baseDir == null && this.filesets.size() == 0 && "zip".equals(this.archiveType)) {
            throw new BuildException("basedir attribute must be set, or at least one fileset must be given!");
        }
        if (this.zipFile == null) {
            throw new BuildException("You must specify the " + this.archiveType + " file to create!");
        }
        var1_1 = new Vector<DirectoryScanner>();
        if (this.baseDir != null) {
            var1_1.addElement(this.getDirectoryScanner(this.baseDir));
        }
        var2_2 = 0;
        while (var2_2 < this.filesets.size()) {
            var3_3 = (FileSet)this.filesets.elementAt(var2_2);
            var1_1.addElement(var3_3.getDirectoryScanner(this.project));
            ++var2_2;
        }
        var3_4 = var1_1.size();
        var4_5 = new FileScanner[var3_4];
        var1_1.copyInto(var4_5);
        if (this.isUpToDate((FileScanner[])var4_5, this.zipFile)) {
            return;
        }
        this.log("Building " + this.archiveType + ": " + this.zipFile.getAbsolutePath());
        try {
            try {
                var5_6 = false;
                var6_8 = new ZipOutputStream(new FileOutputStream(this.zipFile));
                try {
                    if (this.doCompress) {
                        var6_8.setMethod(8);
                    } else {
                        var6_8.setMethod(0);
                    }
                    this.initZipOutputStream(var6_8);
                    if (this.baseDir != null) {
                        this.addFiles(this.getDirectoryScanner(this.baseDir), var6_8, "", "");
                    }
                    this.addFiles(this.filesets, var6_8);
                    var5_6 = true;
                    var8_10 = null;
                }
                catch (Throwable var7_14) {
                    block19: {
                        var8_11 = null;
                        try {
                            if (var6_8 != null) {
                                var6_8.close();
                            }
                        }
                        catch (IOException var9_13) {
                            if (!var5_6) break block19;
                            throw var9_13;
                        }
                    }
                    throw var7_14;
                }
                try {
                    if (var6_8 == null) ** GOTO lbl55
                    var6_8.close();
                }
                catch (IOException var9_12) {
                    if (!var5_6) ** GOTO lbl55
                    throw var9_12;
                }
lbl55:
                // 3 sources

                var11_15 = null;
                this.cleanUp();
            }
            catch (IOException var5_7) {
                var6_9 = "Problem creating " + this.archiveType + ": " + var5_7.getMessage();
                if (!this.zipFile.delete()) {
                    var6_9 = var6_9 + " (and the archive is probably corrupt but I could not delete it)";
                }
                throw new BuildException(var6_9, var5_7, this.location);
            }
        }
        catch (Throwable var10_17) {
            var11_16 = null;
            this.cleanUp();
            throw var10_17;
        }
    }

    protected void addFiles(FileScanner fileScanner, ZipOutputStream zipOutputStream, String string, String string2) throws IOException {
        Object object;
        if (string.length() > 0 && string2.length() > 0) {
            throw new BuildException("Both prefix and fullpath attributes may not be set on the same fileset.");
        }
        File file = fileScanner.getBasedir();
        String[] stringArray = fileScanner.getIncludedDirectories();
        if (stringArray.length > 0 && string2.length() > 0) {
            throw new BuildException("fullpath attribute may only be specified for filesets that specify a single file.");
        }
        int n = 0;
        while (n < stringArray.length) {
            object = stringArray[n].replace(File.separatorChar, '/');
            if (!((String)object).endsWith("/")) {
                object = (String)object + "/";
            }
            this.addParentDirs(file, (String)object, zipOutputStream, string);
            ++n;
        }
        object = fileScanner.getIncludedFiles();
        if (((String[])object).length > 1 && string2.length() > 0) {
            throw new BuildException("fullpath attribute may only be specified for filesets that specify a single file.");
        }
        int n2 = 0;
        while (n2 < ((Object)object).length) {
            File file2 = new File(file, (String)object[n2]);
            if (string2.length() > 0) {
                this.addParentDirs(null, string2, zipOutputStream, "");
                this.zipFile(file2, zipOutputStream, string2);
            } else {
                String string3 = ((String)object[n2]).replace(File.separatorChar, '/');
                this.addParentDirs(file, string3, zipOutputStream, string);
                this.zipFile(file2, zipOutputStream, string + string3);
            }
            ++n2;
        }
    }

    protected void addZipEntries(ZipFileSet zipFileSet, DirectoryScanner directoryScanner, ZipOutputStream zipOutputStream, String string) throws IOException {
        ZipEntry zipEntry;
        ZipScanner zipScanner = (ZipScanner)directoryScanner;
        File file = zipFileSet.getSrc();
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string2 = zipEntry.getName();
            if (!zipScanner.match(string2)) continue;
            this.addParentDirs(null, string2, zipOutputStream, string);
            if (zipEntry.isDirectory()) continue;
            this.zipFile(zipInputStream, zipOutputStream, string + string2, zipEntry.getTime());
        }
    }

    protected void initZipOutputStream(ZipOutputStream zipOutputStream) throws IOException, BuildException {
    }

    protected boolean isUpToDate(FileScanner[] fileScannerArray, File file) throws BuildException {
        String[][] stringArray = Zip.grabFileNames(fileScannerArray);
        File[] fileArray = Zip.grabFiles(fileScannerArray, stringArray);
        if (fileArray.length == 0) {
            if (this.emptyBehavior.equals("skip")) {
                this.log("Warning: skipping " + this.archiveType + " archive " + file + " because no files were included.", 1);
                return true;
            }
            if (this.emptyBehavior.equals("fail")) {
                throw new BuildException("Cannot create " + this.archiveType + " archive " + file + ": no files were included.", this.location);
            }
            if (file.exists()) {
                return true;
            }
            this.log("Note: creating empty " + this.archiveType + " archive " + file, 2);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                try {
                    byte[] byArray = new byte[22];
                    byArray[0] = 80;
                    byArray[1] = 75;
                    byArray[2] = 5;
                    byArray[3] = 6;
                    ((OutputStream)fileOutputStream).write(byArray);
                    Object var8_10 = null;
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    ((OutputStream)fileOutputStream).close();
                    throw throwable;
                }
                ((OutputStream)fileOutputStream).close();
                {
                }
            }
            catch (IOException iOException) {
                throw new BuildException("Could not create empty ZIP archive", iOException, this.location);
            }
            return true;
        }
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].equals(file)) {
                throw new BuildException("A zip file cannot include itself", this.location);
            }
            ++n;
        }
        if (!file.exists()) {
            return false;
        }
        SourceFileScanner sourceFileScanner = new SourceFileScanner(this);
        MergingMapper mergingMapper = new MergingMapper();
        mergingMapper.setTo(file.getAbsolutePath());
        int n2 = 0;
        while (n2 < fileScannerArray.length) {
            if (sourceFileScanner.restrict(stringArray[n2], fileScannerArray[n2].getBasedir(), null, mergingMapper).length > 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected static File[] grabFiles(FileScanner[] fileScannerArray) {
        return Zip.grabFiles(fileScannerArray, Zip.grabFileNames(fileScannerArray));
    }

    protected static File[] grabFiles(FileScanner[] fileScannerArray, String[][] stringArray) {
        Object[] objectArray;
        Vector<File> vector = new Vector<File>();
        int n = 0;
        while (n < stringArray.length) {
            objectArray = fileScannerArray[n].getBasedir();
            int n2 = 0;
            while (n2 < stringArray[n].length) {
                vector.addElement(new File((File)objectArray, stringArray[n][n2]));
                ++n2;
            }
            ++n;
        }
        objectArray = new File[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected static String[][] grabFileNames(FileScanner[] fileScannerArray) {
        String[][] stringArray = new String[fileScannerArray.length][];
        int n = 0;
        while (n < fileScannerArray.length) {
            String[] stringArray2 = fileScannerArray[n].getIncludedFiles();
            String[] stringArray3 = fileScannerArray[n].getIncludedDirectories();
            stringArray[n] = new String[stringArray2.length + stringArray3.length];
            System.arraycopy(stringArray2, 0, stringArray[n], 0, stringArray2.length);
            System.arraycopy(stringArray3, 0, stringArray[n], stringArray2.length, stringArray3.length);
            ++n;
        }
        return stringArray;
    }

    protected void zipDir(File file, ZipOutputStream zipOutputStream, String string) throws IOException {
        if (this.addedDirs.get(string) != null) {
            return;
        }
        this.addedDirs.put(string, string);
        ZipEntry zipEntry = new ZipEntry(string);
        if (file != null) {
            zipEntry.setTime(file.lastModified());
        }
        zipEntry.setSize(0L);
        zipEntry.setMethod(0);
        zipEntry.setCrc(emptyCrc);
        zipOutputStream.putNextEntry(zipEntry);
    }

    protected void zipFile(InputStream inputStream, ZipOutputStream zipOutputStream, String string, long l) throws IOException {
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setTime(l);
        if (!this.doCompress) {
            Object object;
            long l2 = 0L;
            CRC32 cRC32 = new CRC32();
            if (!inputStream.markSupported()) {
                object = new ByteArrayOutputStream();
                byte[] byArray = new byte[8192];
                int n = 0;
                do {
                    l2 += (long)n;
                    cRC32.update(byArray, 0, n);
                    ((ByteArrayOutputStream)object).write(byArray, 0, n);
                } while ((n = inputStream.read(byArray, 0, byArray.length)) != -1);
                inputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
            } else {
                inputStream.mark(Integer.MAX_VALUE);
                object = new byte[8192];
                int n = 0;
                do {
                    l2 += (long)n;
                    cRC32.update((byte[])object, 0, n);
                } while ((n = inputStream.read((byte[])object, 0, ((Object)object).length)) != -1);
                inputStream.reset();
            }
            zipEntry.setSize(l2);
            zipEntry.setCrc(cRC32.getValue());
        }
        zipOutputStream.putNextEntry(zipEntry);
        byte[] byArray = new byte[8192];
        int n = 0;
        do {
            zipOutputStream.write(byArray, 0, n);
        } while ((n = inputStream.read(byArray, 0, byArray.length)) != -1);
    }

    protected void zipFile(File file, ZipOutputStream zipOutputStream, String string) throws IOException {
        if (file.equals(this.zipFile)) {
            throw new BuildException("A zip file cannot include itself", this.location);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.zipFile(fileInputStream, zipOutputStream, string, file.lastModified());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
    }

    protected void addParentDirs(File file, String string, ZipOutputStream zipOutputStream, String string2) throws IOException {
        String string3;
        Stack<String> stack = new Stack<String>();
        int n = string.length();
        while ((n = string.lastIndexOf(47, n - 1)) != -1) {
            string3 = string.substring(0, n + 1);
            if (this.addedDirs.get(string2 + string3) != null) break;
            stack.push(string3);
        }
        while (!stack.isEmpty()) {
            string3 = (String)stack.pop();
            File file2 = null;
            file2 = file != null ? new File(file, string3) : new File(string3);
            this.zipDir(file2, zipOutputStream, string2 + string3);
        }
    }

    protected void addFiles(Vector vector, ZipOutputStream zipOutputStream) throws IOException {
        int n = 0;
        while (n < vector.size()) {
            FileSet fileSet = (FileSet)vector.elementAt(n);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.project);
            String string = "";
            String string2 = "";
            if (fileSet instanceof ZipFileSet) {
                ZipFileSet zipFileSet = (ZipFileSet)fileSet;
                string = zipFileSet.getPrefix();
                string2 = zipFileSet.getFullpath();
            }
            if (string.length() > 0 && !string.endsWith("/") && !string.endsWith("\\")) {
                string = string + "/";
            }
            if (string.length() > 0) {
                this.addParentDirs(null, string, zipOutputStream, "");
                this.zipDir(null, zipOutputStream, string);
            } else if (string2.length() > 0) {
                this.addParentDirs(null, string2, zipOutputStream, "");
            }
            if (fileSet instanceof ZipFileSet && ((ZipFileSet)fileSet).getSrc() != null) {
                this.addZipEntries((ZipFileSet)fileSet, directoryScanner, zipOutputStream, string);
            } else {
                this.addFiles(directoryScanner, zipOutputStream, string, string2);
            }
            ++n;
        }
    }

    protected void cleanUp() {
    }
}

