/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Stack;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.ElemTemplateElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class StackGuard {
    public static int m_recursionLimit = -1;
    Node m_xslRule;
    Node m_sourceXML;
    Stack stack = new Stack();

    public StackGuard() {
    }

    public StackGuard(ElemTemplateElement elemTemplateElement, Node node) {
        this.m_xslRule = elemTemplateElement;
        this.m_sourceXML = node;
    }

    public void checkForInfinateLoop(StackGuard stackGuard) throws TransformerException {
        int n = this.stack.size();
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            if (this.stack.elementAt(n3).equals(stackGuard)) {
                ++n2;
            }
            if (n2 >= m_recursionLimit) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                printWriter.println("Infinite loop diagnosed!  Stack trace:");
                int n4 = 0;
                while (n4 < n) {
                    printWriter.println("Source Elem #" + n4 + " ");
                    StackGuard stackGuard2 = (StackGuard)this.stack.elementAt(n3);
                    stackGuard2.print(printWriter);
                    ++n4;
                }
                printWriter.println("Source Elem #" + n4 + " ");
                stackGuard.print(printWriter);
                printWriter.println("End of infinite loop diagnosis.");
                throw new TransformerException(stringWriter.getBuffer().toString());
            }
            --n3;
        }
    }

    public boolean equals(Object object) {
        return ((StackGuard)object).m_xslRule.equals(this.m_xslRule) && ((StackGuard)object).m_sourceXML.equals(this.m_sourceXML);
    }

    public int getRecursionLimit() {
        return m_recursionLimit;
    }

    public void pop() {
        this.stack.pop();
    }

    public void print(PrintWriter printWriter) {
        if (this.m_sourceXML instanceof Text) {
            Text text = (Text)this.m_sourceXML;
            printWriter.println(text.getData());
        } else if (this.m_sourceXML instanceof Element) {
            Element element = (Element)this.m_sourceXML;
            printWriter.println(element.getNodeName());
        }
    }

    public void push(ElemTemplateElement elemTemplateElement, Node node) throws TransformerException {
        StackGuard stackGuard = new StackGuard(elemTemplateElement, node);
        this.checkForInfinateLoop(stackGuard);
        this.stack.push(stackGuard);
    }

    public void setRecursionLimit(int n) {
        m_recursionLimit = n;
    }
}

