/****************************************************************************
** Simplification et complétion de la classe QFtp
** Créé par Anacr0x : anacr0x@free.fr
**
** Sous licence GPL v2 ou plus
****************************************************************************/

#include "myftp.h"

// ////////////////////////////////////////////////////////////////
//
// MyFtp
//
// ////////////////////////////////////////////////////////////////

MyFtp::MyFtp(MyTreeWidget * ftp, MyTreeWidget * local, QLineEdit * ftpPath,
             QLineEdit * localPath)
{
	// On récupère les pointeurs des MyTreeWidget et du QLineEdit
	lvFtp = ftp;
	leFtpPath = ftpPath;

	dd = new MyDD(local, localPath);

	// Initialise les données
	path = "";
	queueAction = "";
	eraseStateBtn = QMessageBox::NoButton;
	lastFile = NULL;
	changeCurrentAction(None);
	isScanning = false;

	connect(this, SIGNAL(otherCommandFinished(int, bool)),
	        SLOT(slotCommandFinished(int, bool)));
	connect(this, SIGNAL(commandStarted(int)), SLOT(slotCommandStarted(int)));
	connect(this, SIGNAL(listInfo(const QUrlInfo &)),
	        SLOT(slotListInfo(const QUrlInfo &)));
	connect(this, SIGNAL(rawCommandReply(int, const QString &)),
	        SLOT(slotRawCommandReply(int, const QString &)));
	connect(&noDeco, SIGNAL(timeout()), SLOT(slotNoDecoTimer()));

	// Lance le timer de non-déconnexion
	noDeco.start(20000);
}

void MyFtp::connectFtp(QString host, int port, QString username, QString password,
                       bool showFiles)
{
	connectToHost(host, port);
	login(username, password);
	if (showFiles)
		changePath("/");
}

void MyFtp::disconnectFtp()
{
	idList.clear();
	path = "";
	// On remet l'action en cours d'origine et libère la mémoire
	changeCurrentAction(None);
	deleteAllFile();
	removeAllTransfers();
	// On efface le LineEdit de chemin ftp et ferme la connexion
	leFtpPath->clear();
	if (state()!=QFtp::Unconnected)
		close();
}

void MyFtp::changePath(bool display)
{
	if (currentAction != None || !idList.isEmpty())
		return;

	// On récupère le premier fichier sélectionné
	MyTreeWidgetItem *lvi = (MyTreeWidgetItem *) lvFtp->firstSelectedItem();
	if (!lvi || !lvi->isDir())
		return;

	// Si l'item est sélectionné et qu'il s'agit bien d'un répertoire
	changePath(lvi->text(0), display);
}

void MyFtp::changePath(const QString & FtpPath, bool display)
{
	if (FtpPath == "" || currentAction != None || !idList.isEmpty())
		return;
	// On change l'action en cours et rentre dans le dossier
	changeCurrentAction(ChangePath);
	cd(FtpPath);
	// Puis on récupère le chemin et affiche les dossiers/fichiers
	rawCommand("PWD");
	myListFunction(display);
}

void MyFtp::getList(bool display)
{
	if (idList.isEmpty() && currentAction == None)
		myListFunction(display);
}

void MyFtp::displayList()
{
	lvFtp->setUpdatesEnabled(false);
	lvFtp->clear();		// On efface d'abord la QListBox
	bool CdUp = false;		// Stock la présence ou non d'un ".."
	bool Refresh = false;	// Stock la présence ou non d'un "."

	// On rajoute le lien pour le dossier racine
	new MyTreeWidgetItem(lvFtp, true, "/");

	// Parcourt la liste des fichiers et les affiche un par un
	for (FileList * tmp = lastFile; tmp != NULL; tmp = tmp->before)
	{

		if (tmp->ui.name() == "..")	// S'il y a un "..", on l'indique
			CdUp = true;
		if (tmp->ui.name() == ".")	// S'il y a un ".", on l'indique
			Refresh = true;


		// Droits du fichier
		int perms = tmp->ui.permissions();
		QString droits = "----------";
		if (tmp->ui.isDir())
			droits[0] = 'd';
		if (perms & QUrlInfo::ReadOwner)
			droits[1] = 'r';
		if (perms & QUrlInfo::WriteOwner)
			droits[2] = 'w';
		if (perms & QUrlInfo::ExeOwner)
			droits[3] = 'x';
		if (perms & QUrlInfo::ReadGroup)
			droits[4] = 'r';
		if (perms & QUrlInfo::WriteGroup)
			droits[5] = 'w';
		if (perms & QUrlInfo::ExeGroup)
			droits[6] = 'x';
		if (perms & QUrlInfo::ReadOther)
			droits[7] = 'r';
		if (perms & QUrlInfo::WriteOther)
			droits[8] = 'w';
		if (perms & QUrlInfo::ExeOther)
			droits[9] = 'x';

		if (tmp->ui.isDir())
		{
			new MyTreeWidgetItem(lvFtp, true, tmp->ui.name(), "",
			                     tmp->ui.lastModified().toString(Qt::LocaleDate),
			                     droits, tmp->ui.owner());
		}
		else
		{
			// On récupère la taille en octet du fichier
			uint taille = tmp->ui.size();

			new MyTreeWidgetItem(lvFtp, false, tmp->ui.name(),
			                     QString::number(taille),
			                     tmp->ui.lastModified().toString(Qt::LocaleDate),
			                     droits, tmp->ui.owner());
		}
	}
	if (CdUp == false)		// S'il n'y a pas eu de "..", on en met un
	{
		new MyTreeWidgetItem(lvFtp, true, "..");
	}
	if (Refresh == false)	// S'il n'y a pas eu de ".", on en met un
	{
		new MyTreeWidgetItem(lvFtp, true, ".");
	}

	lvFtp->autoResize();
	lvFtp->setUpdatesEnabled(true);
}

void MyFtp::scanDir(QString FtpPath)
{
	isScanning = true;

	// On récupère le chemin absolu
	if (!QFileInfo(FtpPath).isRelative())
		TmpPath = FtpPath;
	else
	{
		if (FtpPath.startsWith("./"))
			FtpPath.remove(0, 2);
		else if (FtpPath[0] == '/')
			FtpPath.remove(0, 1);

		TmpPath = path + '/' + FtpPath;
	}

	// On demande ensuite de lister le dossier
	myListFunction(false, TmpPath);
}

void MyFtp::scanDirBis()
{
	// Si c'est le début du scannage, on rentre au tt début le nom du dossier à
	// scanné
	if (ScanDirList == "")
		ScanDirList = TmpPath + '\n';

	// On parcour la liste de fichier
	for (FileList * tmp = lastFile; tmp != NULL; tmp = tmp->before)
	{
		QString name = tmp->ui.name();
		if (MyTreeWidgetItem::isSimple(name))
		{
			// On inscrit les noms complets de fichier/dossier à la suite
			// le "!" signifie qu'il faut pensé à parcourir ce sous-dossier, il
			// est ensuite remplacé par un espace
			if (tmp->ui.isDir())
				ScanDirList.append("dir!:" + TmpPath + '/' + name + '\n');
			else
				ScanDirList.append("file:" + TmpPath + '/' + name + '\n');
		}
	}

	// On regarde s'il y a un sous-dossier a parcourir
	int place = ScanDirList.indexOf("dir!:");

	// Si on a trouvé un sous-dossier
	if (place != -1)
	{
		// On trouve le début du nom de dossier
		int start = place + 5;
		// On précise qu'on le scanne
		ScanDirList[place + 3] = ' ';
		// On récupère le nom de dossier et relance un nouveau scannage
		QString dirPath =
		    ScanDirList.mid(start, ScanDirList.indexOf('\n', place) - start);
		scanDir(dirPath);
	}
	// Si le scannage est finit
	else
	{
		// On trouve le dossier dans lequel on était au départ
		QString originalDir = ScanDirList.left(ScanDirList.indexOf('\n'));
		originalDir = originalDir.left(originalDir.lastIndexOf('/'));
		/*
		 * // On rerentre dedans if (originalDir == "") cd ("/"); else cd
		 * (originalDir);
		 *
		 * // On récupère le bon path rawCommand ("PWD");
		 */

		// On envoit un signal de fin
		emit scanDirFinished(ScanDirList);

		// Et lance certaines actions spéciales
		if (currentAction == DownloadDir)
			downloadDirBis(ScanDirList);
		else if (currentAction == DelDir)
			delDirBis(ScanDirList);

		// Pour finir, on efface le qstring et enlève l'état (important !)
		ScanDirList = "";
		isScanning = false;
	}
}

FileList *MyFtp::isFileExist(const QString & file)
{
	// On parcour la liste de fichier
	for (FileList * tmp = lastFile; tmp != NULL; tmp = tmp->before)
	{
		if (tmp->ui.name() == file)
			return tmp;
	}
	// Si on a rien trouvé
	return NULL;
}

void MyFtp::downloadSelection(const QString & destDir)
{
	// On énumère tous les items
	for (int item = 0; item < lvFtp->topLevelItemCount(); item++)
	{
		MyTreeWidgetItem *lvd = (MyTreeWidgetItem *) lvFtp->topLevelItem(item);
		// Si un item est sélectionné et valide
		if (lvd && lvFtp->isItemSelected(lvd) && lvd->isSimple())
		{
			// On récupére le nom du fichier
			QString name = lvd->text(0);

			// Si le fichier existe et qu'on doit peut être le supprimer
			if (eraseStateBtn != QMessageBox::YesToAll && dd->isFileExist(name))
			{
				// Si on doit zappé le fichier (option "NoToAll")
				if (eraseStateBtn == QMessageBox::NoToAll)
					continue;

				eraseStateBtn = QMessageBox::question(NULL, tr("Confirmation"),
				                                      trUtf8
				                                      ("Voulez-vous réellement écraser \"")
				                                      + name + "\" ?",
				                                      QMessageBox::Yes | QMessageBox::No |
				                                      QMessageBox::YesToAll | QMessageBox::NoToAll,
				                                      QMessageBox::YesToAll);

				// Si on écrase pas
				if (eraseStateBtn == QMessageBox::No || eraseStateBtn == QMessageBox::NoToAll)
					continue;
			}
			// Si c'est un dossier, téléchargement par récurrence
			if (lvd->isDir())
				downloadDir(path + '/' + name);

			// Si c'est un fichier, téléchargement normal
			else
				downloadFile(path + '/' + name, destDir + '/' + name);
		}
	}

	eraseStateBtn = QMessageBox::NoButton;
}

bool MyFtp::downloadFile(const QString & filename, const QString & dest)
{
	// S'il ne s'agit pas d'un fichier/dossier
	if (state() != QFtp::LoggedIn || !MyTreeWidgetItem::isSimple(filename))
		return false;

	// Crée un transfert pour le téléchargement de fichier
	MyTransfer t(filename, dest, MyTransfer::Download);
	return startTransfer(t);
}

void MyFtp::downloadDir(const QString & dir)
{
	if (dir == "")
		return;
	if (currentAction != None)
	{
		queueAction.append("downloadDir : " + dir + '\n');
		return;
	}
	// On change l'action en cour
	changeCurrentAction(DownloadDir);

	// On demande de scanné le dossier
	// ScanDir () en mode DownloadDir va lancer downloadDirBis () avec la liste des
	// fichiers à télécharger
	scanDir(dir);
}

void MyFtp::downloadDirBis(const QString & list)
{
	QString originalDir;
	QString localFilePath;
	int begin = 0;

	// On sépare tous les fichiers de la liste
	for (int i = 0; i >= 0; i++)
	{
		QString ftpFilePath = list.section('\n', i, i);
		if (ftpFilePath == "")
			break;

		// Si c'est le premier passage, il s'agit du dossier original
		if (i == 0)
		{
			// On trouve uniquement le nom du dossier
			originalDir = ftpFilePath.section('/', -1);
			// Et on le crée en local si nécessaire
			if (!dd->exists(originalDir))
				dd->mkdir(originalDir);

			// On compte le nombre de lettre à supprimer pour obtenir un chemin
			// relatif local
			begin = ftpFilePath.indexOf(originalDir) + 4;
		}
		// S'il s'agit d'un dossier, on le crée
		else if (ftpFilePath[0] == 'd')
		{
			localFilePath = ftpFilePath.replace(0, begin, ".");
			if (!dd->exists(localFilePath))
				dd->mkdir(localFilePath);
		}
		// Si c'est un fichier, on le télécharge
		else
		{
			localFilePath = ftpFilePath;
			setAutoLaunch(false);
			downloadFile(ftpFilePath.remove(0, 5),
			             dd->absoluteFilePath(localFilePath.
			                                  replace(0, begin, ".")));
		}
	}

	// On change l'état et réactualise les listes
	changeCurrentAction(None);
	// Si une action était en attente, on la lance
	if (queueAction != "")
		startNextQueueAction();
	else
		setAutoLaunch(true);	// On lance les transferts
}

void MyFtp::uploadSelection(const QString & destDir)
{
	// On récupère le chemin complet du MyDD
	QString absLocalDir = dd->absolutePath();
	// On énumère tous les items
	for (int item = 0; item < dd->lvLocal->topLevelItemCount(); item++)
	{
		MyTreeWidgetItem *lvu = (MyTreeWidgetItem *) dd->lvLocal->topLevelItem(item);
		// Si un item est sélectionné et valide
		if (lvu && dd->lvLocal->isItemSelected(lvu) && lvu->isSimple())
		{
			// Si destDir existe, on rentre dedans
			if (destDir != "")
			{
				cd(destDir);
				path += '/';
				path += destDir;
			}
			// On récupére le nom du fichier
			QString name = lvu->text(0);

			// Si le fichier existe et qu'on doit peut être le supprimer
			if (eraseStateBtn != QMessageBox::YesToAll && isFileExist(name))
			{
				// Si on doit zappé le fichier (option "NoToAll")
				if (eraseStateBtn == QMessageBox::NoToAll)
					continue;

				eraseStateBtn = QMessageBox::question(NULL, tr("Confirmation"),
				                                      trUtf8
				                                      ("Voulez-vous réellement écraser \"")
				                                      + name + "\" ?",
				                                      QMessageBox::Yes | QMessageBox::No |
				                                      QMessageBox::YesToAll | QMessageBox::NoToAll,
				                                      QMessageBox::YesToAll);

				// Si on écrase pas
				if (eraseStateBtn == QMessageBox::No || eraseStateBtn == QMessageBox::NoToAll)
					continue;
			}
			// Si c'est un dossier, téléchargement par récurrence
			if (lvu->isDir())
				uploadDir(absLocalDir + '/' + name);
			// Si c'est un fichier, téléchargement normal
			else
				uploadFile(absLocalDir + '/' + name, path + '/' + name);
		}
	}

	eraseStateBtn = QMessageBox::NoButton;
}

bool MyFtp::uploadFile(const QString & filename, const QString & dest)
{
	// S'il ne s'agit pas d'un fichier/dossier
	if (state() != QFtp::LoggedIn || !MyTreeWidgetItem::isSimple(filename))
		return false;

	// Crée un transfert pour l'envoi de fichier
	MyTransfer t(filename, dest, MyTransfer::Upload);
	return startTransfer(t);
}

void MyFtp::uploadDir(const QString & absLocalDir)
{
	if (absLocalDir == "")
		return;
	if (currentAction != None)
	{
		queueAction.append("uploadDir : " + absLocalDir + '\n');
		return;
	}
	// On change l'action en cour
	changeCurrentAction(UploadDir);

	// On demande de scanné le dossier
	// ScanDir () en mode UploadDir va lancer uploadDirBis () avec la liste des
	// fichiers à téléch
	QString list = dd->scanDir(absLocalDir);

	QString originalDir;
	QString ftpFilePath;
	int begin = 0;

	// On sépare tous les fichiers de la liste
	for (int i = 0; i >= 0; i++)
	{
		QString localFilePath = list.section('\n', i, i);
		if (localFilePath == "")
			break;

		// Si c'est le premier passage, il s'agit du dossier original
		if (i == 0)
		{
			// On trouve uniquement le nom du dossier
			originalDir = localFilePath.section('/', -1);
			// Et on ajoute le dossier dans une liste pour le crée (si besoin) sur
			// le ftp plus tard
			dirToMake = "./" + originalDir + "\n";

			// On compte le nombre de lettre à supprimer pour obtenir un chemin
			// relatif ftp
			begin = localFilePath.indexOf(originalDir) + 4;
		}
		// S'il s'agit d'un dossier, on le crée
		else if (localFilePath[0] == 'd')
		{
			ftpFilePath = localFilePath.replace(0, begin, ".");
			// Et on ajoute le dossier dans une liste pour le crée (si besoin) sur
			// le ftp plus tard
			dirToMake.append(ftpFilePath + "\n");
		}
		// Si c'est un fichier, on le télécharge
		else
		{
			ftpFilePath = localFilePath;
			setAutoLaunch(false);
			uploadFile(localFilePath.remove(0, 5),
			           ftpFilePath.replace(0, begin, "."));
		}
	}

	// S'il y a des dossier à crée, on lance myListFunction() qui lancera
	// uploadDirBis()
	// On peut ainsi vérifié dans la liste si le dossier est à crée
	if (dirToMake != "")
	{
		QString firstLine = dirToMake.section('\n', 0, 0);
		myListFunction(false, firstLine.left(firstLine.lastIndexOf('/')));
	}
	// S'il n'y a aucun dossier à créer, on lance les transferts
	else
	{
		// On change l'état
		changeCurrentAction(None);
		// Si une action était en attente, on la lance
		if (queueAction != "")
			startNextQueueAction();
		else
			setAutoLaunch(true);	// On lance les transferts
	}
}

void MyFtp::uploadDirBis()
{
	// On récupère la première ligne et la vire de la liste
	QString dirPath = dirToMake.section('\n', 0, 0);
	dirToMake.remove(0, dirToMake.indexOf('\n') + 1);
	// Si le dossier n'existe pas, on le crée
	if (!isFileExist(dirPath.section('/', -1)))
		mkdir(dirPath);

	// S'il y a encore des dossiers à créer, on relance myListFunction()
	if (dirToMake != "")
	{
		QString firstLine = dirToMake.section('\n', 0, 0);
		myListFunction(false, firstLine.left(firstLine.lastIndexOf('/')));
	}
	// S'il n'y a plus aucun dossier à créer, on lance les transferts
	else
	{
		// On change l'état
		changeCurrentAction(None);
		// Si une action était en attente, on la lance
		if (queueAction != "")
			startNextQueueAction();
		else
			setAutoLaunch(true);	// On lance les transferts
	}
}

void MyFtp::delSelection()
{
	if (currentAction == Abort || state() != QFtp::LoggedIn)
		return;

	// On énumère tous les items
	for (int item = 0; item < lvFtp->topLevelItemCount(); item++)
	{
		MyTreeWidgetItem *lvi = (MyTreeWidgetItem *) lvFtp->topLevelItem(item);
		// Si un item est sélectionné et valide
		if (lvi && lvFtp->isItemSelected(lvi) && lvi->isSimple())
		{
			// On récupére le nom du fichier
			QString name = lvi->text(0);
			// S'il s'agit d'un dossier : delNonEmptyDir(), sinon : remove()
			if (lvi->isDir())
			{
				// On commence la suppression des fichiers et sous-dossiers
				delDir(path + '/' + name);
			}
			else
			{
				// Si fichier, on le supprime
				remove
				(path + '/' + name);
				// Et on le supprime aussi de la liste chaïnée
				FileList *tmp = isFileExist(lvi->text(0));
				if (tmp)
					deleteOneFile(tmp);
			}
		}
	}
	// Ensuite on vide la listbox et ré-affiche tout
	getList();
}

void MyFtp::delDir(const QString & dir)
{
	if (dir == "")
		return;
	if (currentAction != None)
	{
		queueAction.append("delDir : " + dir + '\n');
		return;
	}
	// On change l'action en cour
	changeCurrentAction(DelDir);

	// On demande de scanné le dossier
	// ScanDir () en mode DelDir va lancer delDirBis () avec la liste des fichiers
	// à suppr
	scanDir(dir);
}

void MyFtp::delDirBis(const QString & list)
{
	// On compte le nombre de ligne
	const char *buf = list.toAscii();
	int nb = 0;
	while (*buf)
	{
		if (*buf == '\n')
			nb++;
		buf++;
	}

	// On sépare tous les fichiers de la liste en partant de la fin
	for (int i = nb - 1; i >= 0; i--)
	{
		QString ftpFilePath = list.section('\n', i, i);

		// On supprime le dossier/fichier un par un
		if (ftpFilePath[0] == 'd')
			rmdir(ftpFilePath.remove(0, 5));
		else if (ftpFilePath[0] == 'f')
			remove
			(ftpFilePath.remove(0, 5));
		else
		{
			rmdir(ftpFilePath);
			break;
		}
	}

	// On se remet en mode normal
	changeCurrentAction(None);

	// Si une action était en attente, on la lance
	if (queueAction != "")
		startNextQueueAction();
	else
	{
		// Ré-affiche la liste sans le dossier supprimé
		getList();
		// Et envoi un signal pour conclure
		emit delSelectionFinished();
	}
}

void MyFtp::renameSelection(QString newName, bool restoreExt)
{
	if (currentAction == Abort || state() != QFtp::LoggedIn)
		return;

	// On récupère le premier fichier sélectionné
	MyTreeWidgetItem *lvi = (MyTreeWidgetItem *) lvFtp->firstSelectedItem();
	if (!lvi || !lvi->isSimple())
		return;

	// On récupère l'ancien nom du fichier
	QString OldName = lvi->text(0);

	if (restoreExt == true)
	{
		// On récupère l'extension
		QString extFile = QFileInfo(OldName).completeSuffix();

		// Si l'extension existe et n'est pas la même
		if (extFile != "" && QFileInfo(newName).completeSuffix() != extFile)
			newName += "." + extFile;
	}

	rename(OldName, newName);

	// On renomme aussi le fichier dans la liste chaînée
	FileList *tmp = isFileExist(OldName);
	if (tmp)
		tmp->ui.setName(newName);

	// Ensuite on vide la listbox et ré-affiche tout
	getList();
}

MyFtp::FtpCurrentAction MyFtp::getCurrentAction()
{
	return currentAction;
}

void MyFtp::changeCurrentAction(FtpCurrentAction action)
{
	if (currentAction != Abort || action == None)
		currentAction = action;

	emit currentActionChanged(action);
}

int MyFtp::myListFunction(bool display, const QString & dir)
{
	// On précise si l'on affichera la liste ou non
	bDisplayListOrNot = display;

	// On lance la comande list en sauvegardant son id
	int tmp = list(dir);
	idList.append(tmp);

	return tmp;
}

bool MyFtp::deleteOneFile(FileList * file)
{
	if (!file)
		return false;

	// Permet de savoir si la suppression a reussi
	bool succes = false;

	// Si file est le dernier fichier de la liste, on change lastFile
	if (file == lastFile)
	{
		lastFile = lastFile->before;
		succes = true;
	}
	// Si il est au début ou au milieu
	else
	{
		// On l'enlève de la liste
		for (FileList * tmp = lastFile; tmp != NULL; tmp = tmp->before)
			if (tmp->before == file)
			{
				tmp->before = file->before;
				succes = true;
				break;
			}
	}
	// On libère la mémoire
	delete file;
	file = NULL;

	return succes;
}

void MyFtp::deleteAllFile()
{
	// On supprime un à un chaque fichier
	FileList *tmp = NULL;
	for (FileList * tmp2 = lastFile; tmp2 != NULL; tmp2 = tmp2->before)
	{
		if (tmp2 != lastFile)
			delete tmp;
		tmp = tmp2;
	}
	// On réinitialise lastFile
	lastFile = NULL;
}

void MyFtp::slotNoDecoTimer()
{
	// Lance une commande bidon (pour ne plus être inactif)
	// Semble ne pas marcher correctement, déconnexion possible...
	if (state() == QFtp::LoggedIn && currentId() == 0)
		rawCommand("NOOP");	// NOOP = NO OPeration
}

void MyFtp::startNextQueueAction()
{
	// On récupère la première ligne et la vire de la liste
	QString action = queueAction.section('\n', 0, 0);
	queueAction.remove(0, queueAction.indexOf('\n') + 1);

	QString function = action.left(action.indexOf(':') - 1);
	QString arg = action.mid(action.indexOf(':') + 2);

	if (function == "delDir")
		delDir(arg);
	else if (function == "downloadDir")
		downloadDir(arg);
	else if (function == "uploadDir")
		uploadDir(arg);
}

void MyFtp::slotListInfo(const QUrlInfo & i)
{
	// On rajoute chaque QUrlInfo à la liste chaînée
	FileList *list = new FileList();
	list->ui = i;
	list->before = lastFile;
	lastFile = list;
}

void MyFtp::slotCommandStarted(int id)
{
	for (int i = 0; i < idList.size(); ++i)
	{
		// Si l'id correspond a une commande list
		if (idList.at(i) == id)
		{
			// On efface la liste des anciens dossiers/fichiers obtenue
			deleteAllFile();

			return;
		}
	}
}

void MyFtp::slotCommandFinished(int id, bool error)
{
	// S'il y a une error, on l'affiche (sauf en cas d'abort)
	if (error == TRUE)
	{
		if (currentAction != Abort)
			emit detailledError(errorString());

		idList.clear();
		changeCurrentAction(None);
		return;
	}

	for (int i = 0; i < idList.size(); ++i)
	{
		// Si l'id correspond a une commande list
		if (idList.at(i) == id)
		{
			// On affiche la liste s'il le faut
			if (bDisplayListOrNot)
				displayList();
			// Indique la fin de la commande list
			emit listFinished(id);
			idList.removeAt(i);

			// S'il s'agit d'actions spéciales
			if (isScanning == true)
				scanDirBis();	// On continu de répertorier les sous-dossiers

			// S'il s'agit de la fin d'un upload de dossier
			else if (currentAction == UploadDir)
				uploadDirBis();
			// S'il s'agit de la fin d'un changement de dossier
			else if (currentAction == ChangePath)
			{
				changeCurrentAction(None);
				if (leFtpPath != NULL)
					leFtpPath->setText(getPath());
				emit changePathFinished();
			}

			break;
		}
	}
}

void MyFtp::slotRawCommandReply(int code, const QString & detail)
{
	// Si tout est bon, on récupère le chemin du ftp
	if (code == 257)
		path = detail.section('"', 1, 1);
}
