/*
 * jump.c
 * Thomas Nemeth, le 15.10.2003
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include "defines.h"
#include <ncurses.h>
#include <readline/readline.h>
#include "terminal.h"
#include "tmms.h"
#include "xmem.h"
#include "input.h"
#include "playlist.h"
#include "playerwin.h"
#include "playlistwin.h"
#include "printlog.h"


static int get_jump_position(char *title)
{
        char *line;
        int   new_pos = 0;

        player_display = FALSE;
        display_input(title, "New position : ");
        line = readline(NULL);
        if (line && (line[0] != 0))
        {
                new_pos = atoi(stripwhite(line));
                free(line);
        }
        close_input();

        return new_pos;
}


int jump_to()
{
        int new_pos = get_jump_position("Jump to...");

        if ((new_pos > 0) && (new_pos <= playlist_max()))
        {
                set_cursor(new_pos);
        }

        return CONT;
}


int jump_to_selected()
{
        int new_pos = get_jump_position("Jump to...");

        if ((new_pos > 0) && (new_pos <= playlist_nb_sel()))
        {
                int curs_pos = playlist_get_id_by_sel(new_pos);
                set_cursor(curs_pos);
        }

        return CONT;
}

