/*
 * modules.h
 * Thomas Nemeth, le 08.01.2002
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef MODULES_H
#define MODULES_H


typedef enum {NO_POS, FRAMES, SECONDS} Pos;


typedef struct {
    char  *ext;        /* Extension for supported files  */
    char  *cmd;        /* Command to launch player       */
    char  *pos;        /* Options for play/pause         */
    char  *dev;        /* Device specification option    */
    char  *opt;        /* Command options (output...)    */
    Pos    postype;    /* position type (seconds/frames) */
    int  (*parse)();   /* Output parsing function        */
    void (*infos)();   /* Get title's information        */
} Module;


typedef struct ModList {
    Module         *module;
    struct ModList *next;
} ModList;


extern ModList *mod_list;


void register_module(Module *module);
int get_format(const char *entry);
int is_http(const char *entry);
int has_module();
Module *get_module();
void unload_module();
char *get_command();
char *get_option();
char *get_device();
char *get_posopt();
char *get_position(int frame, int seconds);
void unregister_modules();


#endif

