#! /usr/bin/env python
# icons.py

import zlib, cStringIO, wx

__all__ = [\
    "MenuIcon",
    "SlideIcon",
    "VideoIcon",
    "DiscIcon",
    "GroupIcon"]

# ===================================================================
#
# EMBEDDED ICONS
# Functions to return bitmaps for icons converted using img2py
#
# ===================================================================
def MenuIcon():
    icon = zlib.decompress(
"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe4\xe7{\xba8\x86X\xf4\
n\x9d|Z\xb0A\x81\xc7%^\xe6u\xd3\xa4\x15G'm\xd9XQ\xc0f\xec`#\xf1\x80\x89%\xad\
\\^\x9eq\x8a\xc3m\xc6\x90\xff\x99\x1d\x1c\xd1G\xf6\xaa\x19L\xf2_\xff\xabo\
\xef\xcf\x80\x03\x8b\xb6D\xf0=\x8biym\xb3\x8bWsz\x94\xff\xce\x92\xd7L\x19O\
\xc4\xda8\xd7\xac~\xbe\xc7\xac\xb1\xf4\xdf\xa3\xf8\xd9\x0bl\xd9\xa3\xe7\xcfR\
\xf83\xa1\xe5A\xf9>\xc6\xb9\x86\x96\xb2\xf7\xfb\xd6\x18\x03\xadf\xf0t\xf5sY\
\xe7\x94\xd0\x04\x00,qBs")
    stream = cStringIO.StringIO(icon)
    return wx.BitmapFromImage(wx.ImageFromStream(stream))

def SlideIcon():
    """Slide icon, for slide elements inserted into disc layout tree
    """
    icon = zlib.decompress(
'x\xda\x01\xed\x01\x12\xfe\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\
\x10\x00\x00\x00\x10\x08\x06\x00\x00\x00\x1f\xf3\xffa\x00\x00\x00\x04sBIT\
\x08\x08\x08\x08|\x08d\x88\x00\x00\x01\xa4IDAT8\x8d\x9d\x92\xbbn\x13A\x14\
\x86\xbfsf\xd6\xb0Ndc%\xee\xa0%B\x88\x17\x80w\xa0 \x155B<\x01J^\x01\xa5\xce3\
\xf0\x1aTTH\xd4\x91\x02\x05\x82\x82\x04"\xdb\xf1\xae\xf7>\x14\xb3\x97\tq\x03\
\xa7\xd8\xd5\\\xcew\xfe\xff\xdf\x15\xc0\xf1\x9f\xe5\x9c\xc3\x02\x9c\xbd?C4\
\x1aX\xea\x10[cF\x15f\\`\'\x1b\xa2i\x8a\x9dn0q\x89\xa8c2>\x04\xf0\x00\x9a\
\x8a\x87/\x0f\xfeY\x81\x88t\x80\x12\x80\xc5\xe6\x07#\x1d\x91\x16\x96\xcf\xdf\
\xef\xb0\xca\x0cIa)k\xc5\x85F\x05\xc4\xc1\xabg\x1d\xa0\xce\xbc\'\x0c\xa2J\
\x14\tO\xee\x0b\x17k\xe1j\x03\xe7\xbf\xbd9\t\xfd\xb7o\x0f\xa8\x12\x00\x96\
\xb9\xe5\xdbJ)\x1b\xe5"\x15\xd2JXd\xc2d\x17\xe6c\x88-\x145\xa4\x15\xec\xc7!\
\xa0X\xfa\x851\xdc\x8b\r\x97\x99\xb2F\x99\xef(\x8f\xe6Bl\xfc\xe5\xcaA\xe3\
\xa0j \xd2\x10\x90_\x01\x904\x86\x9f\xb9\xe1\xbaTr\xa3\x9cg\xca\x97\x0c\xee\
\x1a0\nM\x03\xae\xf5/\x12\x02\xb2_\x00|\xcd-y\xa3\x14\xa2d\xaa\xb8\x114@*\
\xf8\x10\x8d\xcf\xc1\x05a\xb4\x80K\xbf\x98\x7f\xc2\x02;\xc0lkl\x12\xc4\'\xb7\
\x01\xd7\xebE{\xec/v\xd3\x04x\xb1\xfb\x9cm\xd5f\xb0\x00`\x95,\x87\xb9\xfd\
\xb0A\xc9\xd1\xc7\xb7\xcc&{\xcc\xa6{\xbcy\xf0z\xf8\x95\xbb\xcf\xb8J\x96=\xb9\
\x13\xef\x82\xa7?\x90\xbeyP\xe0\xea\xde\x02\x08N\x1c\xd2[\x0es\x80\xe3\xc7G}\
s\x0f88\xfdpK\xc1\xe0a\x08\xee\xdd\xd3\x93\x1b\xcd\x00\xe2\xda\x1d\x91\x9b\
\x93\xb6\xd5\xdf\xcd\x00\x7f\x002\xc3\xb1\x14\xa7\xc7#\xa6\x00\x00\x00\x00IE\
ND\xaeB`\x82\n\xfd\xd6$')
    stream = cStringIO.StringIO(icon)
    return wx.BitmapFromImage(wx.ImageFromStream(stream))

def VideoIcon():
    """Video icon, for video elements inserted into disc layout tree
    """
    icon = zlib.decompress(
'x\xda\x01*\x01\xd5\xfe\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\x10\
\x00\x00\x00\x10\x08\x06\x00\x00\x00\x1f\xf3\xffa\x00\x00\x00\x04sBIT\x08\
\x08\x08\x08|\x08d\x88\x00\x00\x00\xe1IDAT8\x8d\xe5\x93\xc1\x8d\x830\x10E\
\xdf\xb7L\xa4\xe4`\x94\x94\x80\xb4\xb2v\xeb\xa2\x05\x0eP\x00\x07j\xa0\x804\
\xb3- Q\xc9\xe4\x00\xde8$Y\x0e{\\_\xc6\x7f\xfcg\xfe\x9f\x91,\xc0\xea\xba\x06\
`\x1cG\x00\xf6\xf00\x0c\xc4\x18\t!\xe0\xfb\xbe\xa7m[\x00\xaa\xaa\x02\xd8\xc5\
M\xd3\x000\xcf3\x8e?\x1e\xdfu\x1d\xd34=X\xdc\xc3\xde{b\x8c\x94e\x89\xe2\xf5\
\xdb\x0eN\x14\x12\xde\x89\xc2\x89\x83\x96X\xa4\x98\xdf%\xbe\xce\'>/\'>\xce\
\xc7\xfb\x08\xa6%\xcaR\xe2\x17\xdf\x02[\t.\x91e\xa0\r\xe9]q~\\\xae\x9e\x84\
\xdf\x89\'wy\x0f\x97@*R"\xbc\xe8\x92\x84\xf2\'\x97w~\xaa\xd9\x8ea\xd9\x8eV\
\xbe\xb3\x95\xa8G\xde\x92\xd8.T\xd9\xb8\xd2\xdd\x01\xb6pR\xcdS\xb3\x17f0\xfb\
\x19\xf7?\xff\x85\x10\x027\xf2jp2\xad\x82\x02\x0b\x00\x00\x00\x00IEND\xaeB`\
\x82I4{\xad')
    stream = cStringIO.StringIO(icon)
    return wx.BitmapFromImage(wx.ImageFromStream(stream))

def DiscIcon():
    """Disc icon, for root element
    """
    icon = zlib.decompress(
'x\xda\x01N\x03\xb1\xfc\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\x10\
\x00\x00\x00\x10\x08\x06\x00\x00\x00\x1f\xf3\xffa\x00\x00\x00\x04sBIT\x08\
\x08\x08\x08|\x08d\x88\x00\x00\x03\x05IDAT8\x8dm\x93Mh\\e\x18\x85\x9f\xef\
\xde\xef\xbbw\xfe2vft&\t\xc6&Qcc\xa9\xa9\x0b\x17"U\x14\xa9\x82\xa2\xd6\x82)F\
\xad.\xa4\xd8\xdcUt\xd14UDP\x11\xc5\x11\x19\\\xb8P4\x15l\xfd[\x14[\x94\x16iI\
R\xb4XB\xabPA\x13kB\xdb$\xd3L23\x99\x9f\x9b{\xef\xe7b\xea\x90\x80\xef\xe6}\
\x17\xe7\x9c\xc59\xef\x11Zk\xcd\x9a\xf9\xee\xdb\xc3\xcc\x17\n\xa4Z\xef$\xdc\
\xd2M\xb1hR\xb88\xc1\xe5\xe93\xf4l\xee\xe2\xd9\x17v\xaf\x85#\xd6\n\x8c\xbe\
\xff.O\xf6?\x8a\xbe>\xc2_\xff\xc4\xb8ZP,.\x99X\xe5?Q\xd5\x19T<\xc5\xe9s\x93\
\xbc:\xf2RS\xc0\xf8\xef8:\xfc\x0eO\xddq7\xa2\xe8B\xa9N\xbc\xc5\xc5\x94\x1a\
\x01\x88\xc0\xc5\xf0*\x98\xd1$\xf7=\xfc4_\xe4\x8e\xac\x17x{\xcf\x107wvS\x9b]\
\xc6\x98-a,\xd5\xb9!\xe1b)\x8dF`\xf8Ud\xb2\x033\x96\xa2\xa3.\xd8\xde\xb7\x8d\
\xcf\xdf\xf8\x14\x00\xf3\xc6L\xfb\xeb\xe9H\x82\xaa\xefS\x0f|\xac\x15\x8f\x88\
\x16\xe8\xa8\xa2\xa4\xc3,.)\xec\xf2\x05\xac\xd6[\xe9 Fb5 \x12x\xdc\xde\xdd\
\xc9\xf7\xe3? \x8f\x9f\x1a\xa7\xf7\x96^ZL\xc5\x9c\x15b\xbe^\xa3{\xca%\x9b\
\xcb\xf2\xd5\xd8O\xb8\xab\x06\x0fl\xbb\x9f\x0fF>!]\xf3\x10\xaa\x82\x9650W)\
\xcd\xce"U<\xce\x82[\xe3\xb2\xae V\x8a\\\'\x15o~y\x8c\xf13\x13\xe4r9\x00\x1c\
\xc7\xa1\xd5\x8e\x91\x1d\xde\x07\xa6\x0b\xd2\x05\xd3c\xcb\xe6\x0c\xb2\xb3\
\xbd\x1di\xcak\x994\xd6\xd9\xdf&\xc9\xe5r\x0c\x0e\x0e6\xcdz\xed\xc00\xd9\xec\
\x8e&\x06\r\x1b{,d2\x1a\xc6\xb6,\xa4a\xa0L\x13[J\xa4\xd9\x0cgM\xe0\x92\x88\
\x7f\x0f\xb8\x01\xda\xf3\x11\x9e\xc6\xac\xd7\x90A\xb5J:\x99 \xa4\x14\x99x\
\x94\x8d\xa9\r<q\xefv\x1c\xc7ir\x1d\xc7a\xefs\x8f\xa3\xe3\x1a<\x1bQ\x0f\xd0^\
\xc0\xf4\xdcEd\xb5\xbc\xc4\xa6\xb6>\xd2\xb1(\xb6\x081\xfdw\x8d\xdd\x0f\r\x92\
_\xf4\xd8\xbfo?\xd2\x14\xf4\xdf5\xc0[/>\x0f\x95\xf3`u@\xb4\rV}&\xa7. \xbe>8\
\xaa\x1f\xe9\xb9\x8d+W\\\xf2W=\x96\x8b>\x85\x82\xcf\x86\xa4I*\xa3\xd8\xd4\
\x1bc\xe6d\x08\xbb\xa5Dfk\x1e+\x11F\xc8\x14Xm\x1c99\x86\xb1s\xe0\x19>:\xf4#s\
\x0b\r\xf2\xf2\xb2O8*\xb0\xc3\x06R5\xdc\xb2b\x9a\xf2\xa5\x18\xa5KQ\x82Z\t\
\xfc<\x87\xbe\xf9\x8c\xc7v\xeeh|\xe2\xd0{#\x8cM\xfeJ\xb9\x1c`J\xb0m\x03e\t\
\xec\x90\x81\x00dH\xe3\xb9\x8a\xcaB\x98\x95\xb9\x08\'NM\xb0k\xcf+\xeb\xbb\
\xf0\xf2\x87C\x9c\xfec\x0c\xeb\x1aY*\x81m\x1b\x8dW\xb64*\x12P\xcd\x879|\xecg\
\x1e\x1c8\xf0\xffm\x04\x18\xfd\xf8 3\xbfO\xd3\xdb\xd5\xc5\xd6\xbe\x9bH\xc6m\
\xce\xff2\xcf\xd9sS\xa4\xb7\xb4\xb2ko\xff\xbat\xff\x05\x8e\xd3%\xe2\x90864\
\x00\x00\x00\x00IEND\xaeB`\x82\xb5\xe0\x8b\x86')
    stream = cStringIO.StringIO(icon)
    return wx.BitmapFromImage(wx.ImageFromStream(stream))

def GroupIcon():
    """Group icon, for group elements inserted into disc layout tree
    """
    icon = zlib.decompress(
'x\xda\x01\xed\x01\x12\xfe\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\
\x10\x00\x00\x00\x10\x08\x06\x00\x00\x00\x1f\xf3\xffa\x00\x00\x00\x04sBIT\
\x08\x08\x08\x08|\x08d\x88\x00\x00\x01\xa4IDAT8\x8d\x9d\x92\xbbn\x13A\x14\
\x86\xbfsf\xd6\xb0Ndc%\xee\xa0%B\x88\x17\x80w\xa0 \x155B<\x01J^\x01\xa5\xce3\
\xf0\x1aTTH\xd4\x91\x02\x05\x82\x82\x04"\xdb\xf1\xae\xf7>\x14\xb3\x97\tq\x03\
\xa7\xd8\xd5\\\xcew\xfe\xff\xdf\x15\xc0\xf1\x9f\xe5\x9c\xc3\x02\x9c\xbd?C4\
\x1aX\xea\x10[cF\x15f\\`\'\x1b\xa2i\x8a\x9dn0q\x89\xa8c2>\x04\xf0\x00\x9a\
\x8a\x87/\x0f\xfeY\x81\x88t\x80\x12\x80\xc5\xe6\x07#\x1d\x91\x16\x96\xcf\xdf\
\xef\xb0\xca\x0cIa)k\xc5\x85F\x05\xc4\xc1\xabg\x1d\xa0\xce\xbc\'\x0c\xa2J\
\x14\tO\xee\x0b\x17k\xe1j\x03\xe7\xbf\xbd9\t\xfd\xb7o\x0f\xa8\x12\x00\x96\
\xb9\xe5\xdbJ)\x1b\xe5"\x15\xd2JXd\xc2d\x17\xe6c\x88-\x145\xa4\x15\xec\xc7!\
\xa0X\xfa\x851\xdc\x8b\r\x97\x99\xb2F\x99\xef(\x8f\xe6Bl\xfc\xe5\xcaA\xe3\
\xa0j \xd2\x10\x90_\x01\x904\x86\x9f\xb9\xe1\xbaTr\xa3\x9cg\xca\x97\x0c\xee\
\x1a0\nM\x03\xae\xf5/\x12\x02\xb2_\x00|\xcd-y\xa3\x14\xa2d\xaa\xb8\x114@*\
\xf8\x10\x8d\xcf\xc1\x05a\xb4\x80K\xbf\x98\x7f\xc2\x02;\xc0lkl\x12\xc4\'\xb7\
\x01\xd7\xebE{\xec/v\xd3\x04x\xb1\xfb\x9cm\xd5f\xb0\x00`\x95,\x87\xb9\xfd\
\xb0A\xc9\xd1\xc7\xb7\xcc&{\xcc\xa6{\xbcy\xf0z\xf8\x95\xbb\xcf\xb8J\x96=\xb9\
\x13\xef\x82\xa7?\x90\xbeyP\xe0\xea\xde\x02\x08N\x1c\xd2[\x0es\x80\xe3\xc7G}\
s\x0f88\xfdpK\xc1\xe0a\x08\xee\xdd\xd3\x93\x1b\xcd\x00\xe2\xda\x1d\x91\x9b\
\x93\xb6\xd5\xdf\xcd\x00\x7f\x002\xc3\xb1\x14\xa7\xc7#\xa6\x00\x00\x00\x00IE\
ND\xaeB`\x82\n\xfd\xd6$')
    stream = cStringIO.StringIO(icon)
    return wx.BitmapFromImage(wx.ImageFromStream(stream))


def AppIcon():
    """The tovid application icon as a bitmap
    
    This image is 32x32.  Although 16x16 would work, the image looks grainy in the application
    listing when switching windows (Alt+Tab)
    """
    icon = zlib.decompress(
'x\xda\x01\xcc\n3\xf5\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00 \x00\
\x00\x00 \x08\x06\x00\x00\x00szz\xf4\x00\x00\x00\x04sBIT\x08\x08\x08\x08|\
\x08d\x88\x00\x00\n\x83IDATX\x85\xa5\x97ip]\xe5y\xc7\xff\xefr\xee9\xf7\xe8\
\xee\xbaW\xb2\xb5\xaf\x96\x88\x1d\xaf\xc4\xd8\xc6uL X\xc2\xc4\xc4\x93\x04\
\xe2L;&vqC\xeb\x96\xc9L\x87)\xb4\x03x\xd2\xa6\x1d\xe0C&L2\xb63a&\x84$\x10\
\xe2!\xb11\x8bH\x8c\x82\x8c\xb1\xe3\xad\x18b\x1c\xc5\x8bdY\xb6\x16\xebJw?\
\xe7\xbc[?\x08ZZ\x82\x0b\xed\x7f\xe6\xff\xed}\x9f\xe77\xcf\xbb=/\xc1\'\xd0\
\xbau\xebB\xd1h\xb4\xae\xca\x894\x18\xadE\xae\x94\x1b\x1a\x1f\x1f\xbfz\xf8\
\xf0a\xf5I\xe2|P\xc4\x18C\xae5`\xf3\xe6\xbbS+\xe6\xdf\xf2\xe5\xbax\xdb\x860\
\x89^\x1f\x0f\xc7\x93\x89\x88\xcd\x1d[\xa3 \xf3\xeaR1;6Z\xbcz\xf0\x0fC\xbf\
\x7f\xee\xec\x99\xdf\xbd\xb4{\xf7n/\x9dN\xff\xff\x016o\xfezd\xfd\xda/~s\xe9\
\xd2e\x7f\x1bu2\xd53\xc3\x82\x88\x92\x02\xd5\x80\xeb\x00aG#\xa0\x12S&\xc0\
\x14\x04f\x88\xc4\xf8\xf4\xc5s\xe7\x07O\xec\xb8p\xf4\xcdg\xf6\xec\xd9#\xffO\
\x00\xb9\\\x0e\x8f\xff\xf3w\x16\xaf\xff\xec\x17~\xdc\xde\xde\xf5)\'\x12"\xc6\
\xa2\x98x\xd7\x83\x9fW\xa0\xd2 l\x03nX\xa3\xcc\x04&\x8d\x8f\xab\x90([\x06\
\xb2\n\x10!\x89\xf3g\x8f\xbfp\xf0\xc9\x9f\xde\xf3\xaf\x0f=2\xbel\xd9\xb2k\
\x02\xd0\xff\x99|\xf7c\xbbo\xdet\xeb\xa6\x03m\x8d\xed\xf3\x8d\xd4D\xf8\n\x8c\
\x00v\x9c\x820@\x030fv\xbc4\x06\x811\x08\x08\xa0-\xc0\xd8\x04&F\xd1\xb0f\xc9\
\xed\xbd\x7f\xff\xf5\xd7\xfe\xf1[\x0f\xb5\xf7\xf5\xf5}<\x80\\.\x87\xc7\x1fzt\
Y\xcf\xb2u\xbf\xa8v\x13\tH\x05h\r\xe5K(_\xc3Mr0>[,3[;Hh\xf8FC2\x03m\x03\xca1\
\x10\xae\x82\x0b\x89\xee\xeb\xda\xba\xbf\xb2\xed\xab\xfb\x1e|\xf0\x81\xc6\
\x81\x81\x81\xff\x1d`\xdb\xd6m\xb1[\x17\xdc\xf4\x93T8\x16\xd7\x9e\x80\xf1$ 5\
\x8c\xd2\x10\x9eD(L\xc1\xc2\x14xo\xc14\x80\xc0\x18x\xd4@\x87\x00\xed\x00AD\
\xc2a\x12q%\x11\x17\n\xcb\x17uwo\xd8\xd8\xf3\xc2\xf6\xed\xf7\xad\xcc\xe5r\
\x1f\r\xf0\xe4\x93O\x92\xf5\x0b>\xf7@K\xb2~\x9e\xf1\x02h?\x80\xf2\x04\x8c/\
\x00\xa9\xa0|\t\x1d(TUs\x80\x12\x18\x03\x18\x18\xf8P\xf0\x99\x81r\x00\x11U\
\xb0,\x81\xa4\x10H\n\x85\xa4\xd2\x88H\x8a\x8d\xebo\xfbt"\xd3\xf9L\xcf\xc6o\
\xfc\xcd\xfd\xf7\xdf\xcf\xff$\xc0\x0b\xcf\xef\x9d\xb3\xb0\xa1\xfd\xaf\x99\
\x0e\x00!`<\x1f\xba\xecA\x95|\x98\xca,\x84(\t\x84c\x14,4\xbb\x06\x1a\x06eh\
\xc8\x10 \xa3\x06\xc4\x15HK\x81\xb4\x90\xa8\x96\x1aN\xc0a<\x0b.O\xe0\xce\xf5\
\x7f\xe6\xba\xf1\xc6\xcd\'\x06\x83\xc7\xb6l\xd9\x12\xfe \x00\xeb\xe8\xe8\xa0\
\xcd\xa1\xc4\xb6\xe5\x9d\x0bn\'\xc4\x80h\x05h\x03h\x03\xa3\r\x8c\x01\x08!\
\x00\xa3`6C\xaeXD>\x98A\x85\x940A$\xfcj\x06U\x1d\xa0F\x07\x98\x13\x08$$\x05\
\xf3,\x18\xdf\x02\x02\x1bT;\xa8I5\xb8\xfb\xf7\xff\xf0W\xd5-\x9f\xbb\xa9\x14X\
\xd7\x1dzm\xcf\x81\xde\xde^\t\x00ldd\x84\x7f\xad\xf7\x8eo\xd7\xcf\x9d\xd3L9\
\x01\xa5\x06\x04\x1a\xd0\n\x90\nFj\x18m\xa0\x8d\xc6\xa8\x9c@\xa8%\x84xG\x0cN\
}\x15Ba\x81)1\x85\x8c\xab\xd1\x18HD|\x0eR\xb6\x81\xc0\x01\x91aP\xe5\x82\x1a\
\x07a;\x86w\xce\xbc5\xc9Y\xf9\xb0[\xdf\xb3Ax\x85\xe8\x1fO\x1f\x1aX\xb5j\x95\
\xa1\xf9|>Z\xbf\xb8k\x91\xdb^\x8bpS\n\xce\x9c\x08\x9c\x8c\x03\'\xc9\x11r5\
\xb8\xa9\x00\xc5\x02.\x8bq$\xdakA\x19\xc5\xd1C\x870x\xfa4\x92\xc9\x04\xae\
\xafiF\xf2J\x19\xe1|\x18(\xc4@\xfd8\xa8L\x80\xb1\x18\xa8\x1b\x01\xe2.L\xd2Ak\
\xd7uKF/\x1c{\x8b\x8a\xf1,\x89\x7f\xe6\xab\x7f<7z+\x00\xf0\xba\xb9u\xcd\xe9\
\x9at\x94\'"\xe0\xe9\xd8\xec\x0e\x17\x12\xba\xecC\x15<\xc8\x99\x12\xa6\'\xa6\
\x11\xed\xae\x83\xf0}\xdc\xb3iSe\xa0\xbf\xff<\xe7\xbc\xf4\xe0\x8e\x1d\x9dw\
\xdf{o\x92[\xd5 A\n\xc4\xb2\xa1,\x0e\xc5)\x04!\x10 P\x84@\x03pj\xeajFGG\xed\
\xa6\xf9\x97\xa6\x88\xddX-\xed\xce{\xef\xbb\xef\xbe\x834\x1a\x8b6Y\x82\x11Y\
\x08\xa0r\x15\xa8\xbc\x07\xe3IP\xc6a\xa5\xa2\x08w\xce\x05:\xd3p\\\x17\xa7N\
\x9c0\x03\xfd\xfd}\x94\xd2\x7f0\xc6\xfc\xdd\xb3O=\xb5\xdb\xf7<\x84".*Q\x1b"j\
\xc1\x84\t\xb8\xa5\x11\xb5$2\x96@\xbd\xe5\xa3\xd9\xf2\xd1\x99t\x19c\xacY\x8b\
\x92$\xd00\xd6\x9c\xd6r\xb9\xbc\x82\x97\xcbeV\x10\x1a!f\xa0\r\x81\x02 \r\xa0\
0km\x80\xe9\x12Au\xca \x9eHh\xd7u\xf7\xc7b\xb1\x03\x0b\x17.\x0c\x9a\xdb\xdaZ\
\x19\xe7\x10\x9e\x87\xf6$\x01\xa7\x801\xfa\xbdM\x8c\xff\xba\xb4\x0c\xe0\x10\
\x85t:=\xcf\xd0H\x12F\x00,\x12\x95R-\xe0CCC\xe3\xef\xe4\x84N\xb08\xa5\x06\
\xe0\x00,\x98YK\r.\x04\x12\x8a\xa283\x83\x8e\xeen\xf6\x83\xa7\x9f\xde\xf8\
\xfb\x13\'\x0e767\xc7\x16\xafX\xf1O\x9cs\x88\xf1\x1c\xbc\x912\xacT\x15X\xcc\
\x05\x8b\xd8\xa0n\x08\x84\xb1\xd9{[k\xe4*9TE\xa25\xa1d\xf7\x1c\xca8\x08q\x10\
\x18]\xc3\xc7\xc6\xc6\xc6\xe5\xc4\xe5|M2\x99\xa0\xca\x00B\x03RBK\x01\r\x1f\
\x82U@]\x0f\x85b\x11N\xa4\n+\xd7\xae\xed]\xbare\x0fc\x8cp\xceQ\x98\xc9\xc1\
\x1e\x03\x8a\x81\x04\x9f\xcc\x82;\xd3`a>k7\x04\x16\t\xe3\xfc\xd4\x18\xfa~s@4\
\x7f\xe6\x8e\xd6d\xd3<*e\xd4\x94\xc6\xdfV\xbe\xd6\x82\x13Br\xc3\xef\x9e\xfe\
\xc3\xa7j\xdboPZ\xc2\x10\x01C\x02\x18\x16\x00<\x80q\x04\xf2!\x8dI;\x82\xe1\
\xcb\xa3hF\x18\xd1\xb8K\xb4\xd40\x15\x85h\xc5FU\xaa\x16*_\x86\xf0<\xa8\xa2\
\x00\xad\x080.@C\x1e\x8e_<\x8c\xc1\xb1\x11\xc4\x1a\xe7\x91\x8e\x9b\xd6\x86\
\xe7\xcek\xf2\xb2\x97&q\xa6\xff\xcaD\x81\x90qV]]\r\xdf\xf7Zo^\xf3\xd9\x1b\
\xc1}\x18V\x01B>\x88\x1d@\x85\x03dm`\xd4\xb60#\xc3\xb0r.\x9c\xac\x85\xda\t\
\x1bb\xd8A"\\\x8dD\xb5\x0bc\x08\x08%0 0\x86B+ \x9b\x9b\xc1\xcb\'_\xc7d~\x062\
\x95BW\xef\xc6\xa0\xa1\xa3\xa6\xcc\xbdq\xdd\xd9\x18\xc7\x89W\xf6\x9e\xa2\xe0\
\xaf\xd0E\x8b\x16\x05}\x07^z\xe9\xad\xc1\xa39c\x95Al\x1f$\xec\xc3s\x04&-\x8a\
+!\x0b\xd3\xc6\x865\xcda\x95\x81\x088l\x16\x82E,\x94\xb3\x12\xd4\xe6 6\x07um\
\xb0\x88\x83\x80\x19\x1c\xbbp\x04G\x86\x0e\x83\x84(\x96\xdc\xb2\x1ak\xbf\xf4\
%\xa3\x0b\x93A4\xccUK}\x1d\xde\xd8\xb3\x7f\xac*Rwe\xc1\xe2Uo\xb0}\xfb\xf6\
\x99]\xbbvU\n\xa5\\\xdb-\xebV}\x9a\x84\rJ\xdc`\x9a3L\x858fh\x08<\x1f\x02\xcf\
\x11\xb8\x15\x824\xb1Pe,\xf8\x82@*\x03;\xc6`\x87\x19\xa6\xa7\xb38v\xea \xce\
\\8\x82\x86\xb9\x114u\xb5bEo\x0f\xb4Q`\xae-c5\r\xc5+#\xc3\xf2\xec\xdb\xa7\
\x82c\x07^\xefw\xdc\xc8\xde\x07\xbey\xf79\xde\xdd\xdd\x8d\x8e\x8e\x8e\xa9\
\x97^\xee\xfb\xd1\r\xab\x97\xdc\xd8\xfb\xe7w4\xe5)C\xceb\x98a\x16H\xd1\x02/\
\x110\x1fp\x0c\x81M\x18\x80\xd9W9\xf0}\xbc\xf9\xc6\xbfcF\x8e`jb\x02\xf1p\x08\
\xed]\xcd\xa8kkBc\xf7R\x10J\x91\xf7K\xe6\xd2\xe5+^\xa29#\xae\x0e\x8f\xa9W\
\x9e\xfe\xc1~\xcbr\x86w}\xef\xb1~`\xf6\xd4\xe1\xd9g\x9f\x95\xcb\x97/?\xf6\
\xe8\xb7\xbf\xbb\xd3n\x9a\xfb\xe0\xbc\xcf\xdf\x18\xc93\x0b\xda\xe7\xb0K\x14\
\xd4\x03\xb8\x04\xa8\x90\xb8<5\x8c\xe1\xa1\xb3\xb849\x89\x92_F\xba6\x03a\xe5\
a(\xc1\xda\xde\xdb\xd0\xda\xd9\x02\xad\x14.]8\x8bXM\r\xdc\xaa\x88\x1f)\x91\
\xf2o_\xd83\xf1z\xdf\x9ec\x95r\xd9\x9b?\xbf\xe5{\xff\xf9\x1a>\xf2\xc8#$\x9dN\
chh\xc8;~\xfc\xf8\xe5\xc3\xbf>\x18\xcet\xb6-H\xb6uX\xa1\xa2\x05V\x06\x98\x07\
8\x92\xe0\xc4\xc1W\xb0\xf7\xd7?C\xc3\x9cF\x18\xceP6\x12A8\x8a\x96\xae\xd5\
\xe8\x9c\xb7\x08P\n\xd5\x89$\x18\'\x98\xcae\x91\xcdf\x83P(^\xdc\xbb\xf7\xf9\
\xec\xc1\xd7\xf6\xf5\x97\x8a\xa5\x8buuu\xff\xf6\xc4\x13O\x04\xef\x03\xfc\xb7\
\xa6t\xcd\x9a5\xec\xc8\x91#]\x94\xd2{o\xdf\xb6\xf5k\xeb\xff\xe2\xaf\x92.\xaa\
\xc0\xcb@LR\xbcsl\x00\xe7/_\x86\x1dN\xc3r3\x90~\x16\xb5\xf5\xd7!\x11\xabB&\
\x13Gi\xea\x02\x96,\xbc\x1eZ\x17\x0ccZ\x1c:t\xa0t\xea\x9d\xe3\x07GF\x86\xcf\
\x17\x8b\xc5\x89\x96\xd6\xd6\xc7w\xee\xdc)>\xd8\x0f|\xa8+~\x0f\xa2UJygCK\xdb\
\xa6\xdb\xef\xbc{\xde\xeaU\xb7Y\xf5U)\x9c93\x88sW\xcb\xa0\x94\x83\x10\x06\
\xbf4\x86T\xa6\x05\x91H\x14\x91H\x08\xc2\x9b\x81\xf2\xf3\xba\xb6\xa6\xce?\
\xfdv\xff\xc8\xe9\xd3o\xfe\xaaX,6\x82\x90\x9f\xef\xdc\xb9\xeb\x97\r\r\r\x1fj\
\xc9\xfe\xe4\xbf`\xcb\x96-\xf4\xb9\xe7\x9eKU*\x95\x95Z\xeb\r\xf1x\xe2\xc6\
\xa5\x8bW4tt.s\xed\xf4|\xca\x98\x05B(\x94\xf2 \x83\x1c\xdc\xf8\\\x13\xe2L\
\xdb\x16\xe4\xd0\x99\xdfx\xb9\xec\xa5\xfd\x95rq\xc2\xf3*1\xc6\xado\xbd\xfa\
\xea\xab\xc3\x1f\xca|-\x00\x00\x18\x18\x18\xc0\xd6\xad[C###\xb5B\x88\x05\xc6\
\x98\xeb\xdb\xbb\x96\xac\xb9\xe1\xe6\xbf\\M(#\x94\x10P\xc6LP\x181U\xb1Z\xe9\
\xe5\x87/f\xc7N\xabr\xa9\xf0L\xa5RiUJ\xbd\xdc\xd3\xd3\xf3\xcb\x1d;v\xe8\x8fJ\
~M\x80\xf7\xd5\xd7\xd7\x87\x87\x1f~\x98\r\x0e\x0e\xbaK\x97\xdf\xb4\xbcy\xfe\
\x86\xa7@\x19\xd1\xa2\x08Q\x1e/\x15&\xdf\xf5\x8d\xaa<]*\x15o.\x14\n\xe7\x94R\
GS\xa9\xd4\xcf\xfa\xfa\xfa\xca\xd7\x8a\xfb\xb1\x01>\xa8\xad\xf7|\xa3\xa6\x14\
\xb8\xbf\xc8g/\xb61\xf8\x8f\xe6r\xb9\xf5\x94\xd2cJ\xa9\x84\xe7y\x872\x99\xcc\
\xf3/\xbe\xf8\xe2\xc7J\xfc\xbe>\xd4&_KF\x05\xd3\x83o\xff\xee\xfb\x85B\xe1_\
\x84\x10s\x1c\xc79\x9a\xc9d\x9e\xbf\xeb\xae\xbbNn\xdf\xbe\xfd\x9a\xa5\xfe\
\xe8\xa0\xc6\x90\x8f\xeb\x93\'O\x92\xba\xba\xbaM\x8d\x8d\x8dK6n\xdch}\x92\
\xb9\x1f\xe5\xff\x00\xae+e=VQ\xc4\x94\x00\x00\x00\x00IEND\xaeB`\x82\xf4\x8c9\
\xb3')
    stream = cStringIO.StringIO(icon)
    return wx.BitmapFromImage(wx.ImageFromStream(stream))
# ===================================================================
# End embedded icons
# ===================================================================
