;;;
;;; Copyright (c) 2003-2013 uim Project http://code.google.com/p/uim/
;;;
;;; All rights reserved.
;;;
;;; Redistribution and use in source and binary forms, with or without
;;; modification, are permitted provided that the following conditions
;;; are met:
;;; 1. Redistributions of source code must retain the above copyright
;;;    notice, this list of conditions and the following disclaimer.
;;; 2. Redistributions in binary form must reproduce the above copyright
;;;    notice, this list of conditions and the following disclaimer in the
;;;    documentation and/or other materials provided with the distribution.
;;; 3. Neither the name of authors nor the names of its contributors
;;;    may be used to endorse or promote products derived from this software
;;;    without specific prior written permission.
;;;
;;; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND
;;; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
;;; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;;; ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE
;;; FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
;;; OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
;;; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
;;; LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
;;; OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
;;; SUCH DAMAGE.
;;;;
;; https://sites.google.com/site/00trycode/ Retrieved 2013-06-26.

;;
(require "generic.scm")
;;
(define trycode-rule
  '(
    ;((("1" "1"))("")) ;(((" " "1" "1"))(""))
    ;((("2" "1"))("")) ;(((" " "2" "1"))(""))
    ;((("3" "1"))("")) ;(((" " "3" "1"))(""))
    ;((("4" "1"))("")) ;(((" " "4" "1"))(""))
    ;((("5" "1"))("")) ;(((" " "5" "1"))(""))
    ;((("6" "1"))("")) ;(((" " "6" "1"))(""))
    ;((("7" "1"))("")) ;(((" " "7" "1"))(""))
    ;((("8" "1"))("")) ;(((" " "8" "1"))(""))
    ;((("9" "1"))("")) ;(((" " "9" "1"))(""))
    ;((("0" "1"))("")) ;(((" " "0" "1"))(""))
    ((("q" "1"))("")) (((" " "q" "1"))(""))
    ((("w" "1"))("")) (((" " "w" "1"))("")) ; Winny
    ((("e" "1"))("")) (((" " "e" "1"))("")) ; ̵̣
    ((("r" "1"))("")) (((" " "r" "1"))(""))
    ((("t" "1"))("")) (((" " "t" "1"))(""))
    ((("y" "1"))("")) (((" " "y" "1"))(""))
    ((("u" "1"))("")) (((" " "u" "1"))("")) ; 
    ((("i" "1"))("")) (((" " "i" "1"))(""))
    ((("o" "1"))("õ")) (((" " "o" "1"))(""))
    ((("p" "1"))("")) (((" " "p" "1"))(""))
    ((("a" "1"))("")) (((" " "a" "1"))("")) ; ֤
    ((("s" "1"))("")) (((" " "s" "1"))(""))
    ((("d" "1"))("")) (((" " "d" "1"))("")) ; ̵̣
    ((("f" "1"))("")) (((" " "f" "1"))("")) ; ()
    ((("g" "1"))("")) (((" " "g" "1"))("")) ; ꤨǡ
    ((("h" "1"))("")) (((" " "h" "1"))(""))
    ((("j" "1"))("")) (((" " "j" "1"))(""))
    ((("k" "1"))("")) (((" " "k" "1"))(""))
    ((("l" "1"))("")) (((" " "l" "1"))("ȩ"))
    (((";" "1"))("")) (((" " ";" "1"))("ª"))
    ((("z" "1"))("")) (((" " "z" "1"))(""))
    ((("x" "1"))("")) (((" " "x" "1"))(""))
    ((("c" "1"))("")) ;(((" " "c" "1"))(""))
    ((("v" "1"))("")) ;(((" " "v" "1"))(""))
    ((("b" "1"))("ʳ")) (((" " "b" "1"))("")) ; ʳ֤
    ((("n" "1"))("")) (((" " "n" "1"))(""))
    ((("m" "1"))("")) (((" " "m" "1"))("")) ; 
    ((("," "1"))("")) (((" " "," "1"))(""))
    ((("." "1"))("")) (((" " "." "1"))(""))
    ((("/" "1"))("")) ;(((" " "/" "1"))(""))
    ;((("1" "2"))("")) ;(((" " "1" "2"))(""))
    ;((("2" "2"))("")) ;(((" " "2" "2"))(""))
    ;((("3" "2"))("")) ;(((" " "3" "2"))(""))
    ;((("4" "2"))("")) ;(((" " "4" "2"))(""))
    ;((("5" "2"))("")) ;(((" " "5" "2"))(""))
    ;((("6" "2"))("")) ;(((" " "6" "2"))(""))
    ;((("7" "2"))("")) ;(((" " "7" "2"))(""))
    ;((("8" "2"))("")) ;(((" " "8" "2"))(""))
    ;((("9" "2"))("")) ;(((" " "9" "2"))(""))
    ;((("0" "2"))("")) ;(((" " "0" "2"))(""))
    ((("q" "2"))("")) (((" " "q" "2"))("")) ; Ļ
    ((("w" "2"))("")) (((" " "w" "2"))(""))
    ((("e" "2"))("")) ;(((" " "e" "2"))(""))
    ((("r" "2"))("")) (((" " "r" "2"))("ʥ"))
    ((("t" "2"))("")) (((" " "t" "2"))(""))
    ((("y" "2"))("")) ;(((" " "y" "2"))(""))
    ((("u" "2"))("")) (((" " "u" "2"))(""))
    ((("i" "2"))("")) (((" " "i" "2"))(""))
    ((("o" "2"))("")) (((" " "o" "2"))(""))
    ((("p" "2"))("")) (((" " "p" "2"))(""))
    ((("a" "2"))("")) ;(((" " "a" "2"))(""))
    ((("s" "2"))("")) (((" " "s" "2"))("ť"))
    ((("d" "2"))("")) (((" " "d" "2"))(""))
    ((("f" "2"))("")) ;(((" " "f" "2"))(""))
    ((("g" "2"))("")) (((" " "g" "2"))(""))
    ((("h" "2"))("")) (((" " "h" "2"))(""))
    ((("j" "2"))("")) ;(((" " "j" "2"))(""))
    ((("k" "2"))("")) (((" " "k" "2"))("")) ; Ȥμγ
    ((("l" "2"))("")) (((" " "l" "2"))(""))
    (((";" "2"))("")) (((" " ";" "2"))(""))
    ((("z" "2"))("")) (((" " "z" "2"))(""))
    ((("x" "2"))("")) (((" " "x" "2"))(""))
    ((("c" "2"))("")) ;(((" " "c" "2"))(""))
    ((("v" "2"))("")) (((" " "v" "2"))(""))
    ((("b" "2"))("ʢ")) (((" " "b" "2"))(""))
    ((("n" "2"))("")) (((" " "n" "2"))("˥"))
    ((("m" "2"))("")) (((" " "m" "2"))(""))
    ((("," "2"))("")) ;(((" " "," "2"))(""))
    ((("." "2"))("")) (((" " "." "2"))(""))
    ((("/" "2"))("")) (((" " "/" "2"))(""))
    ;((("1" "3"))("")) ;(((" " "1" "3"))(""))
    ;((("2" "3"))("")) ;(((" " "2" "3"))(""))
    ;((("3" "3"))("")) ;(((" " "3" "3"))(""))
    ;((("4" "3"))("")) ;(((" " "4" "3"))(""))
    ;((("5" "3"))("")) ;(((" " "5" "3"))(""))
    ;((("6" "3"))("")) ;(((" " "6" "3"))(""))
    ;((("7" "3"))("")) ;(((" " "7" "3"))(""))
    ;((("8" "3"))("")) ;(((" " "8" "3"))(""))
    ;((("9" "3"))("")) ;(((" " "9" "3"))(""))
    ;((("0" "3"))("")) ;(((" " "0" "3"))(""))
    ((("q" "3"))("")) (((" " "q" "3"))(""))
    ((("w" "3"))("")) (((" " "w" "3"))(""))
    ((("e" "3"))("")) (((" " "e" "3"))(""))
    ((("r" "3"))("")) ;(((" " "r" "3"))(""))
    ((("t" "3"))("")) (((" " "t" "3"))(""))
    ((("y" "3"))("")) (((" " "y" "3"))(""))
    ((("u" "3"))("")) (((" " "u" "3"))(""))
    ((("i" "3"))("")) (((" " "i" "3"))(""))
    ((("o" "3"))("")) (((" " "o" "3"))(""))
    ((("p" "3"))("")) (((" " "p" "3"))("̪"))
    ((("a" "3"))("")) (((" " "a" "3"))(""))
    ((("s" "3"))("")) (((" " "s" "3"))("")) ; ᤺
    ((("d" "3"))("")) (((" " "d" "3"))(""))
    ((("f" "3"))("")) ;(((" " "f" "3"))(""))
    ((("g" "3"))("")) (((" " "g" "3"))("ˣ"))
    ((("h" "3"))("")) (((" " "h" "3"))(""))
    ((("j" "3"))("")) (((" " "j" "3"))(""))
    ((("k" "3"))("")) (((" " "k" "3"))(""))
    ((("l" "3"))("")) (((" " "l" "3"))(""))
    (((";" "3"))("")) (((" " ";" "3"))("")) ; 
    ((("z" "3"))("")) ;(((" " "z" "3"))(""))
    ((("x" "3"))("")) (((" " "x" "3"))("Ϫ")) ; happy birthday ġ桼
    ((("c" "3"))("")) (((" " "c" "3"))("")) ; Ϥ˷ؤǤ
    ((("v" "3"))("")) (((" " "v" "3"))(""))
    ((("b" "3"))("")) (((" " "b" "3"))(""))
    ((("n" "3"))("")) (((" " "n" "3"))(""))
    ((("m" "3"))("")) (((" " "m" "3"))("")) ; إ
    ((("," "3"))("")) (((" " "," "3"))(""))
    ((("." "3"))("")) (((" " "." "3"))(""))
    ((("/" "3"))("")) (((" " "/" "3"))(""))
    ;((("1" "4"))("")) ;(((" " "1" "4"))(""))
    ;((("2" "4"))("")) ;(((" " "2" "4"))(""))
    ;((("3" "4"))("")) ;(((" " "3" "4"))(""))
    ;((("4" "4"))("")) ;(((" " "4" "4"))(""))
    ;((("5" "4"))("")) ;(((" " "5" "4"))(""))
    ;((("6" "4"))("")) ;(((" " "6" "4"))(""))
    ;((("7" "4"))("")) ;(((" " "7" "4"))(""))
    ;((("8" "4"))("")) ;(((" " "8" "4"))(""))
    ;((("9" "4"))("")) ;(((" " "9" "4"))(""))
    ;((("0" "4"))("")) ;(((" " "0" "4"))(""))
    ((("q" "4"))("")) (((" " "q" "4"))(""))
    ((("w" "4"))("")) (((" " "w" "4"))(""))
    ((("e" "4"))("")) (((" " "e" "4"))("ע"))
    ((("r" "4"))("")) (((" " "r" "4"))(""))
    ((("t" "4"))("")) ;(((" " "t" "4"))(""))
    ((("y" "4"))("")) (((" " "y" "4"))(""))
    ((("u" "4"))("")) (((" " "u" "4"))(""))
    ((("i" "4"))("")) (((" " "i" "4"))("")) ; 
    ((("o" "4"))("")) (((" " "o" "4"))(""))
    ((("p" "4"))("")) (((" " "p" "4"))(""))
    ((("a" "4"))("")) (((" " "a" "4"))(""))
    ((("s" "4"))("")) ;(((" " "s" "4"))(""))
    ((("d" "4"))("")) (((" " "d" "4"))(""))
    ((("f" "4"))("")) (((" " "f" "4"))(""))
    ((("g" "4"))("")) (((" " "g" "4"))(""))
    ((("h" "4"))("ˮ")) (((" " "h" "4"))(""))
    ((("j" "4"))("")) (((" " "j" "4"))("Ƨ"))
    ((("k" "4"))("")) (((" " "k" "4"))(""))
    ((("l" "4"))("")) (((" " "l" "4"))("ò"))
    (((";" "4"))("")) (((" " ";" "4"))("")) ; Ը٤˶ĥ
    ((("z" "4"))("Ĭ")) (((" " "z" "4"))("")) ; 
    ((("x" "4"))("¡")) (((" " "x" "4"))(""))
    ((("c" "4"))("")) (((" " "c" "4"))(""))
    ((("v" "4"))("")) (((" " "v" "4"))("")) ; 㤯
    ((("b" "4"))("")) (((" " "b" "4"))(""))
    ((("n" "4"))("")) (((" " "n" "4"))("")) ; Ϥ
    ((("m" "4"))("")) (((" " "m" "4"))(""))
    ((("," "4"))("ɧ")) (((" " "," "4"))(""))
    ((("." "4"))("")) (((" " "." "4"))(""))
    ((("/" "4"))("")) (((" " "/" "4"))(""))
    ;((("1" "5"))("")) ;(((" " "1" "5"))(""))
    ;((("2" "5"))("")) ;(((" " "2" "5"))(""))
    ;((("3" "5"))("")) ;(((" " "3" "5"))(""))
    ;((("4" "5"))("")) ;(((" " "4" "5"))(""))
    ;((("5" "5"))("")) ;(((" " "5" "5"))(""))
    ;((("6" "5"))("")) ;(((" " "6" "5"))(""))
    ;((("7" "5"))("")) ;(((" " "7" "5"))(""))
    ;((("8" "5"))("")) ;(((" " "8" "5"))(""))
    ;((("9" "5"))("")) ;(((" " "9" "5"))(""))
    ;((("0" "5"))("")) ;(((" " "0" "5"))(""))
    ((("q" "5"))("")) (((" " "q" "5"))(""))
    ((("w" "5"))("˿")) (((" " "w" "5"))(""))
    ((("e" "5"))("")) (((" " "e" "5"))("")) ; Ƥ
    ((("r" "5"))("")) (((" " "r" "5"))(""))
    ((("t" "5"))("")) ;(((" " "t" "5"))(""))
    ((("y" "5"))("")) (((" " "y" "5"))(""))
    ((("u" "5"))("")) (((" " "u" "5"))(""))
    ((("i" "5"))("̩")) (((" " "i" "5"))(""))
    ((("o" "5"))("")) (((" " "o" "5"))(""))
    ((("p" "5"))("")) (((" " "p" "5"))(""))
    ((("a" "5"))("")) (((" " "a" "5"))(""))
    ((("s" "5"))("")) (((" " "s" "5"))(""))
    ((("d" "5"))("")) (((" " "d" "5"))(""))
    ((("f" "5"))("")) (((" " "f" "5"))(""))
    ((("g" "5"))("")) ;(((" " "g" "5"))(""))
    ((("h" "5"))("")) (((" " "h" "5"))("")) ; 夦
    ((("j" "5"))("")) (((" " "j" "5"))(""))
    ((("k" "5"))("")) ;(((" " "k" "5"))(""))
    ((("l" "5"))("")) (((" " "l" "5"))(""))
    (((";" "5"))("")) (((" " ";" "5"))(""))
    ((("z" "5"))("")) (((" " "z" "5"))(""))
    ((("x" "5"))("ĺ")) (((" " "x" "5"))("ƽ"))
    ((("c" "5"))("")) (((" " "c" "5"))("")) ; 
    ((("v" "5"))("")) (((" " "v" "5"))(""))
    ((("b" "5"))("")) (((" " "b" "5"))("")) ; Ų²
    ((("n" "5"))("¬")) (((" " "n" "5"))(""))
    ((("m" "5"))("")) (((" " "m" "5"))(""))
    ((("," "5"))("")) (((" " "," "5"))(""))
    ((("." "5"))("")) (((" " "." "5"))(""))
    ((("/" "5"))("")) (((" " "/" "5"))(""))
    ;((("1" "6"))("")) ;(((" " "1" "6"))(""))
    ;((("2" "6"))("")) ;(((" " "2" "6"))(""))
    ;((("3" "6"))("")) ;(((" " "3" "6"))(""))
    ;((("4" "6"))("")) ;(((" " "4" "6"))(""))
    ;((("5" "6"))("")) ;(((" " "5" "6"))(""))
    ;((("6" "6"))("")) ;(((" " "6" "6"))(""))
    ;((("7" "6"))("")) ;(((" " "7" "6"))(""))
    ;((("8" "6"))("")) ;(((" " "8" "6"))(""))
    ;((("9" "6"))("")) ;(((" " "9" "6"))(""))
    ;((("0" "6"))("")) ;(((" " "0" "6"))(""))
    ((("q" "6"))("")) (((" " "q" "6"))(""))
    ((("w" "6"))("")) (((" " "w" "6"))("")) ; 줤
    ((("e" "6"))("")) (((" " "e" "6"))(""))
    ((("r" "6"))("")) (((" " "r" "6"))("")) ; ¡ܿ
    ((("t" "6"))("")) (((" " "t" "6"))(""))
    ((("y" "6"))("©")) (((" " "y" "6"))("")) ; ©ݤ
    ((("u" "6"))("")) (((" " "u" "6"))(""))
    ((("i" "6"))("")) ;(((" " "i" "6"))(""))
    ((("o" "6"))("")) ;(((" " "o" "6"))(""))
    ((("p" "6"))("")) ;(((" " "p" "6"))(""))
    ((("a" "6"))("")) (((" " "a" "6"))(""))
    ((("s" "6"))("")) ;(((" " "s" "6"))(""))
    ((("d" "6"))("")) (((" " "d" "6"))(""))
    ((("f" "6"))("")) ;(((" " "f" "6"))(""))
    ((("g" "6"))("")) (((" " "g" "6"))(""))
    ((("h" "6"))("")) (((" " "h" "6"))(""))
    ((("j" "6"))("")) (((" " "j" "6"))(""))
    ((("k" "6"))("ū")) (((" " "k" "6"))(""))
    ((("l" "6"))("Ƹ")) (((" " "l" "6"))("")) ; ƸͶ
    (((";" "6"))("Ȫ")) (((" " ";" "6"))(""))
    ((("z" "6"))("")) (((" " "z" "6"))(""))
    ((("x" "6"))("")) ;(((" " "x" "6"))(""))
    ((("c" "6"))("")) (((" " "c" "6"))("")) ; ĥ꡼
    ((("v" "6"))("")) (((" " "v" "6"))(""))
    ((("b" "6"))("")) (((" " "b" "6"))(""))
    ((("n" "6"))("")) (((" " "n" "6"))("Ŀ"))
    ((("m" "6"))("")) (((" " "m" "6"))(""))
    ((("," "6"))("")) (((" " "," "6"))(""))
    ((("." "6"))("")) (((" " "." "6"))("é"))
    ((("/" "6"))("")) (((" " "/" "6"))(""))
    ;((("1" "7"))("")) ;(((" " "1" "7"))(""))
    ;((("2" "7"))("")) ;(((" " "2" "7"))(""))
    ;((("3" "7"))("")) ;(((" " "3" "7"))(""))
    ;((("4" "7"))("")) ;(((" " "4" "7"))(""))
    ;((("5" "7"))("")) ;(((" " "5" "7"))(""))
    ;((("6" "7"))("")) ;(((" " "6" "7"))(""))
    ;((("7" "7"))("")) ;(((" " "7" "7"))(""))
    ;((("8" "7"))("")) ;(((" " "8" "7"))(""))
    ;((("9" "7"))("")) ;(((" " "9" "7"))(""))
    ;((("0" "7"))("")) ;(((" " "0" "7"))(""))
    ((("q" "7"))("ü")) (((" " "q" "7"))(""))
    ((("w" "7"))("")) ;(((" " "w" "7"))(""))
    ((("e" "7"))("͹")) (((" " "e" "7"))("")) ; ͹
    ((("r" "7"))("")) (((" " "r" "7"))(""))
    ((("t" "7"))("")) ;(((" " "t" "7"))(""))
    ((("y" "7"))("")) (((" " "y" "7"))(""))
    ((("u" "7"))("")) (((" " "u" "7"))(""))
    ((("i" "7"))("")) (((" " "i" "7"))(""))
    ((("o" "7"))("")) ;(((" " "o" "7"))(""))
    ((("p" "7"))("")) (((" " "p" "7"))(""))
    ((("a" "7"))("")) (((" " "a" "7"))(""))
    ((("s" "7"))("")) (((" " "s" "7"))(""))
    ((("d" "7"))("")) (((" " "d" "7"))(""))
    ((("f" "7"))("")) (((" " "f" "7"))(""))
    ((("g" "7"))("æ")) (((" " "g" "7"))(""))
    ((("h" "7"))("")) (((" " "h" "7"))(""))
    ((("j" "7"))("")) (((" " "j" "7"))(""))
    ((("k" "7"))("")) (((" " "k" "7"))(""))
    ((("l" "7"))("º")) (((" " "l" "7"))(""))
    (((";" "7"))("")) (((" " ";" "7"))(""))
    ((("z" "7"))("")) (((" " "z" "7"))(""))
    ((("x" "7"))("")) (((" " "x" "7"))(""))
    ((("c" "7"))("")) (((" " "c" "7"))("")) ; 
    ((("v" "7"))("")) (((" " "v" "7"))(""))
    ((("b" "7"))("")) (((" " "b" "7"))("")) ; ٤פ
    ((("n" "7"))("")) (((" " "n" "7"))("")) ; Ȥζʤǲ
    ((("m" "7"))("")) ;(((" " "m" "7"))(""))
    ((("," "7"))("»")) (((" " "," "7"))(""))
    ((("." "7"))("ɶ")) (((" " "." "7"))(""))
    ((("/" "7"))("")) (((" " "/" "7"))("м"))
    ;((("1" "8"))("")) ;(((" " "1" "8"))(""))
    ;((("2" "8"))("")) ;(((" " "2" "8"))(""))
    ;((("3" "8"))("")) ;(((" " "3" "8"))(""))
    ;((("4" "8"))("")) ;(((" " "4" "8"))(""))
    ;((("5" "8"))("")) ;(((" " "5" "8"))(""))
    ;((("6" "8"))("")) ;(((" " "6" "8"))(""))
    ;((("7" "8"))("")) ;(((" " "7" "8"))(""))
    ;((("8" "8"))("")) ;(((" " "8" "8"))(""))
    ;((("9" "8"))("")) ;(((" " "9" "8"))(""))
    ;((("0" "8"))("")) ;(((" " "0" "8"))(""))
    ((("q" "8"))("")) (((" " "q" "8"))("")) ; 
    ((("w" "8"))("")) (((" " "w" "8"))(""))
    ((("e" "8"))("")) (((" " "e" "8"))("")) ; ֡
    ((("r" "8"))("")) (((" " "r" "8"))(""))
    ((("t" "8"))("")) (((" " "t" "8"))(""))
    ((("y" "8"))("")) (((" " "y" "8"))("")) ; 񡦽̱
    ((("u" "8"))("")) (((" " "u" "8"))("")) ; Ѥǵ椯
    ((("i" "8"))("")) (((" " "i" "8"))(""))
    ((("o" "8"))("")) (((" " "o" "8"))(""))
    ((("p" "8"))("")) (((" " "p" "8"))(""))
    ((("a" "8"))("")) ;(((" " "a" "8"))(""))
    ((("s" "8"))("")) (((" " "s" "8"))("Ŷ"))
    ((("d" "8"))("")) (((" " "d" "8"))(""))
    ((("f" "8"))("")) (((" " "f" "8"))(""))
    ((("g" "8"))("˽")) (((" " "g" "8"))("")) ; ˽
    ((("h" "8"))("")) (((" " "h" "8"))(""))
    ((("j" "8"))("")) (((" " "j" "8"))(""))
    ((("k" "8"))("")) (((" " "k" "8"))(""))
    ((("l" "8"))("")) ;(((" " "l" "8"))(""))
    (((";" "8"))("")) (((" " ";" "8"))(""))
    ((("z" "8"))("")) (((" " "z" "8"))(""))
    ((("x" "8"))("")) (((" " "x" "8"))(""))
    ((("c" "8"))("")) (((" " "c" "8"))("Ľ"))
    ((("v" "8"))("ε")) (((" " "v" "8"))("")) ; ɥ
    ((("b" "8"))("ʻ")) (((" " "b" "8"))(""))
    ((("n" "8"))("")) (((" " "n" "8"))(""))
    ((("m" "8"))("")) (((" " "m" "8"))(""))
    ((("," "8"))("Ũ")) (((" " "," "8"))(""))
    ((("." "8"))("")) (((" " "." "8"))(""))
    ((("/" "8"))("")) ;(((" " "/" "8"))(""))
    ;((("1" "9"))("")) ;(((" " "1" "9"))(""))
    ;((("2" "9"))("")) ;(((" " "2" "9"))(""))
    ;((("3" "9"))("")) ;(((" " "3" "9"))(""))
    ;((("4" "9"))("")) ;(((" " "4" "9"))(""))
    ;((("5" "9"))("")) ;(((" " "5" "9"))(""))
    ;((("6" "9"))("")) ;(((" " "6" "9"))(""))
    ;((("7" "9"))("")) ;(((" " "7" "9"))(""))
    ;((("8" "9"))("")) ;(((" " "8" "9"))(""))
    ;((("9" "9"))("")) ;(((" " "9" "9"))(""))
    ;((("0" "9"))("")) ;(((" " "0" "9"))(""))
    ((("q" "9"))("")) (((" " "q" "9"))(""))
    ((("w" "9"))("")) (((" " "w" "9"))(""))
    ((("e" "9"))("")) (((" " "e" "9"))(""))
    ((("r" "9"))("")) (((" " "r" "9"))(""))
    ((("t" "9"))("")) (((" " "t" "9"))(""))
    ((("y" "9"))("")) (((" " "y" "9"))(""))
    ((("u" "9"))("ǵ")) (((" " "u" "9"))(""))
    ((("i" "9"))("ǡ")) (((" " "i" "9"))(""))
    ((("o" "9"))("")) (((" " "o" "9"))(""))
    ((("p" "9"))("Ģ")) (((" " "p" "9"))(""))
    ((("a" "9"))("")) (((" " "a" "9"))(""))
    ((("s" "9"))("")) (((" " "s" "9"))(""))
    ((("d" "9"))("")) (((" " "d" "9"))(""))
    ((("f" "9"))("")) (((" " "f" "9"))("ʺ"))
    ((("g" "9"))("")) (((" " "g" "9"))(""))
    ((("h" "9"))("")) (((" " "h" "9"))(""))
    ((("j" "9"))("")) (((" " "j" "9"))(""))
    ((("k" "9"))("")) (((" " "k" "9"))(""))
    ((("l" "9"))("")) (((" " "l" "9"))("Ĥ"))
    (((";" "9"))("")) (((" " ";" "9"))(""))
    ((("z" "9"))("")) (((" " "z" "9"))(""))
    ((("x" "9"))("")) (((" " "x" "9"))(""))
    ((("c" "9"))("")) (((" " "c" "9"))(""))
    ((("v" "9"))("ð")) (((" " "v" "9"))("ó")) ; 
    ((("b" "9"))("")) (((" " "b" "9"))(""))
    ((("n" "9"))("")) (((" " "n" "9"))(""))
    ((("m" "9"))("")) (((" " "m" "9"))(""))
    ((("," "9"))("Ƽ")) (((" " "," "9"))("")) ; ꡦʬƼ
    ((("." "9"))("")) (((" " "." "9"))("ʯ"))
    ((("/" "9"))("")) (((" " "/" "9"))(""))
    ;((("1" "0"))("")) ;(((" " "1" "0"))(""))
    ;((("2" "0"))("")) ;(((" " "2" "0"))(""))
    ;((("3" "0"))("")) ;(((" " "3" "0"))(""))
    ;((("4" "0"))("")) ;(((" " "4" "0"))(""))
    ;((("5" "0"))("")) ;(((" " "5" "0"))(""))
    ;((("6" "0"))("")) ;(((" " "6" "0"))(""))
    ;((("7" "0"))("")) ;(((" " "7" "0"))(""))
    ;((("8" "0"))("")) ;(((" " "8" "0"))(""))
    ;((("9" "0"))("")) ;(((" " "9" "0"))(""))
    ;((("0" "0"))("")) ;(((" " "0" "0"))(""))
    ((("q" "0"))("")) (((" " "q" "0"))("")) ; Ҥ
    ((("w" "0"))("")) (((" " "w" "0"))(""))
    ((("e" "0"))("ɼ")) (((" " "e" "0"))(""))
    ((("r" "0"))("")) (((" " "r" "0"))(""))
    ((("t" "0"))("")) (((" " "t" "0"))(""))
    ((("y" "0"))("")) (((" " "y" "0"))(""))
    ((("u" "0"))("ζ")) (((" " "u" "0"))(""))
    ((("i" "0"))("ά")) (((" " "i" "0"))(""))
    ((("o" "0"))("θ")) (((" " "o" "0"))("κ"))
    ((("p" "0"))("")) (((" " "p" "0"))(""))
    ((("a" "0"))("§")) ;(((" " "a" "0"))(""))
    ((("s" "0"))("¸")) ;(((" " "s" "0"))(""))
    ((("d" "0"))("")) (((" " "d" "0"))(""))
    ((("f" "0"))("")) (((" " "f" "0"))(""))
    ((("g" "0"))("")) (((" " "g" "0"))("")) ; 㤯
    ((("h" "0"))("")) (((" " "h" "0"))(""))
    ((("j" "0"))("")) (((" " "j" "0"))(""))
    ((("k" "0"))("")) (((" " "k" "0"))("")) ; Ƥη
    ((("l" "0"))("")) (((" " "l" "0"))(""))
    (((";" "0"))("")) (((" " ";" "0"))("̼"))
    ((("z" "0"))("")) (((" " "z" "0"))("")) ; Ĥʡ
    ((("x" "0"))("")) (((" " "x" "0"))("")) ; 㢪Ƣ
    ((("c" "0"))("")) (((" " "c" "0"))("")) ; 
    ((("v" "0"))("")) (((" " "v" "0"))(""))
    ((("b" "0"))("")) (((" " "b" "0"))(""))
    ((("n" "0"))("")) (((" " "n" "0"))(""))
    ((("m" "0"))("")) (((" " "m" "0"))(""))
    ((("," "0"))("ǳ")) (((" " "," "0"))("˨"))
    ((("." "0"))("")) ;(((" " "." "0"))(""))
    ((("/" "0"))("")) (((" " "/" "0"))(""))
    ((("1" "q"))("")) ;(((" " "1" "q"))(""))
    ((("2" "q"))("")) (((" " "2" "q"))(""))
    ((("3" "q"))("")) (((" " "3" "q"))(""))
    ((("4" "q"))("")) (((" " "4" "q"))("ů"))
    ((("5" "q"))("")) (((" " "5" "q"))(""))
    ((("6" "q"))("")) (((" " "6" "q"))(""))
    ((("7" "q"))("")) ;(((" " "7" "q"))(""))
    ((("8" "q"))("ú")) (((" " "8" "q"))(""))
    ((("9" "q"))("")) (((" " "9" "q"))(""))
    ((("0" "q"))("")) (((" " "0" "q"))("ʨ"))
    ((("q" "q"))("")) (((" " "q" "q"))(""))
    ((("w" "q"))("")) (((" " "w" "q"))(""))
    ((("e" "q"))("")) (((" " "e" "q"))("Ů")) ; Ů
    ((("r" "q"))("")) (((" " "r" "q"))("")) ; 
    ((("t" "q"))("")) (((" " "t" "q"))("ǻ"))
    ((("y" "q"))("")) (((" " "y" "q"))(""))
    ((("u" "q"))("")) (((" " "u" "q"))(""))
    ((("i" "q"))("̳")) (((" " "i" "q"))(""))
    ((("o" "q"))("")) (((" " "o" "q"))(""))
    ((("p" "q"))("")) (((" " "p" "q"))(""))
    ((("a" "q"))("")) (((" " "a" "q"))(""))
    ((("s" "q"))("")) (((" " "s" "q"))(""))
    ((("d" "q"))("")) (((" " "d" "q"))(""))
    ((("f" "q"))("")) (((" " "f" "q"))(""))
    ((("g" "q"))("")) (((" " "g" "q"))(""))
    ((("h" "q"))("")) (((" " "h" "q"))(""))
    ((("j" "q"))("")) ;(((" " "j" "q"))(""))
    ((("k" "q"))("")) (((" " "k" "q"))("")) ; 
    ((("l" "q"))("")) ;(((" " "l" "q"))(""))
    (((";" "q"))("")) (((" " ";" "q"))("ݦ"))
    ((("z" "q"))("")) (((" " "z" "q"))(""))
    ((("x" "q"))("")) (((" " "x" "q"))(""))
    ((("c" "q"))("")) (((" " "c" "q"))(""))
    ((("v" "q"))("")) (((" " "v" "q"))(""))
    ((("b" "q"))("")) (((" " "b" "q"))(""))
    ((("n" "q"))("")) (((" " "n" "q"))(""))
    ((("m" "q"))("")) (((" " "m" "q"))(""))
    ((("," "q"))("Ū")) (((" " "," "q"))("ƴ")) ; ƴŪ
    ((("." "q"))("")) (((" " "." "q"))("")) ; 
    ((("/" "q"))("")) (((" " "/" "q"))(""))
    ((("1" "w"))("")) (((" " "1" "w"))(""))
    ((("2" "w"))("")) (((" " "2" "w"))(""))
    ((("3" "w"))("")) (((" " "3" "w"))("")) ; ݲ
    ((("4" "w"))("")) (((" " "4" "w"))(""))
    ((("5" "w"))("Ȳ")) (((" " "5" "w"))(""))
    ((("6" "w"))("")) ;(((" " "6" "w"))(""))
    ((("7" "w"))("")) (((" " "7" "w"))(""))
    ((("8" "w"))("")) (((" " "8" "w"))("ʵ"))
    ((("9" "w"))("")) (((" " "9" "w"))(""))
    ((("0" "w"))("")) ;(((" " "0" "w"))(""))
    ((("q" "w"))("")) (((" " "q" "w"))(""))
    ((("w" "w"))("")) (((" " "w" "w"))(""))
    ((("e" "w"))("")) (((" " "e" "w"))(""))
    ((("r" "w"))("ͳ")) (((" " "r" "w"))("µ"))
    ((("t" "w"))("")) (((" " "t" "w"))(""))
    ((("y" "w"))("")) (((" " "y" "w"))(""))
    ((("u" "w"))("")) (((" " "u" "w"))("")) ; 
    ((("i" "w"))("")) (((" " "i" "w"))(""))
    ((("o" "w"))("ɴ")) (((" " "o" "w"))("ƭ")) ; 100٤ʨƭ
    ((("p" "w"))("")) (((" " "p" "w"))("ƶ"))
    ((("a" "w"))("")) (((" " "a" "w"))(""))
    ((("s" "w"))("")) (((" " "s" "w"))(""))
    ((("d" "w"))("")) (((" " "d" "w"))(""))
    ((("f" "w"))("")) (((" " "f" "w"))(""))
    ((("g" "w"))("")) (((" " "g" "w"))("Ȧ")) ; Ȧ
    ((("h" "w"))("ʬ")) (((" " "h" "w"))("")) ; 櫓
    ((("j" "w"))("")) (((" " "j" "w"))(""))
    ((("k" "w"))("")) (((" " "k" "w"))(""))
    ((("l" "w"))("")) (((" " "l" "w"))("")) ; 
    (((";" "w"))("")) (((" " ";" "w"))("")) ; ѡ
    ((("z" "w"))("")) ;(((" " "z" "w"))(""))
    ((("x" "w"))("")) (((" " "x" "w"))(""))
    ((("c" "w"))("΢")) (((" " "c" "w"))("")) ; ()
    ((("v" "w"))("")) (((" " "v" "w"))(""))
    ((("b" "w"))("")) (((" " "b" "w"))(""))
    ((("n" "w"))("")) (((" " "n" "w"))(""))
    ((("m" "w"))("")) (((" " "m" "w"))("̽")) ; Pluto
    ((("," "w"))("")) (((" " "," "w"))(""))
    ((("." "w"))("")) ;(((" " "." "w"))(""))
    ((("/" "w"))("")) (((" " "/" "w"))(""))
    ((("1" "e"))("")) (((" " "1" "e"))("")) ; 
    ((("2" "e"))("")) (((" " "2" "e"))(""))
    ((("3" "e"))("")) (((" " "3" "e"))(""))
    ((("4" "e"))("")) (((" " "4" "e"))(""))
    ((("5" "e"))("")) (((" " "5" "e"))(""))
    ((("6" "e"))("")) ;(((" " "6" "e"))(""))
    ((("7" "e"))("")) (((" " "7" "e"))(""))
    ((("8" "e"))("Ʈ")) (((" " "8" "e"))("")) ; Ʈ
    ((("9" "e"))("")) (((" " "9" "e"))(""))
    ((("0" "e"))("ͼ")) (((" " "0" "e"))(""))
    ((("q" "e"))("")) (((" " "q" "e"))(""))
    ((("w" "e"))("")) (((" " "w" "e"))(""))
    ((("e" "e"))("ξ")) (((" " "e" "e"))(""))
    ((("r" "e"))("")) ;(((" " "r" "e"))(""))
    ((("t" "e"))("!")) (((" " "t" "e"))(""))
    ((("y" "e"))("")) (((" " "y" "e"))(""))
    ((("u" "e"))("")) (((" " "u" "e"))(""))
    ((("i" "e"))("")) (((" " "i" "e"))("")) ; 
    ((("o" "e"))("")) (((" " "o" "e"))(""))
    ((("p" "e"))("")) (((" " "p" "e"))(""))
    ((("a" "e"))("")) (((" " "a" "e"))("")) ; 
    ((("s" "e"))("")) (((" " "s" "e"))(""))
    ((("d" "e"))("")) (((" " "d" "e"))(""))
    ((("f" "e"))("")) (((" " "f" "e"))("̥"))
    ((("g" "e"))("")) (((" " "g" "e"))(""))
    ((("h" "e"))("7")) ;(((" " "h" "e"))(""))
    ((("j" "e"))("")) (((" " "j" "e"))(""))
    ((("k" "e"))("(")) (((" " "k" "e"))("")) ; ̤¿ʸϤ
    ((("l" "e"))("")) (((" " "l" "e"))("")) ; toy
    (((";" "e"))("")) (((" " ";" "e"))(""))
    ((("z" "e"))("")) (((" " "z" "e"))(""))
    ((("x" "e"))("")) (((" " "x" "e"))(""))
    ((("c" "e"))("")) (((" " "c" "e"))(""))
    ((("v" "e"))("")) (((" " "v" "e"))(""))
    ((("b" "e"))("")) (((" " "b" "e"))(""))
    ((("n" "e"))("")) ;(((" " "n" "e"))(""))
    ((("m" "e"))("")) (((" " "m" "e"))(""))
    ((("," "e"))("Ȭ")) (((" " "," "e"))(""))
    ((("." "e"))("")) (((" " "." "e"))(""))
    ((("/" "e"))("")) (((" " "/" "e"))("į"))
    ((("1" "r"))("")) (((" " "1" "r"))("ժ")) ; ginger
    ((("2" "r"))("")) (((" " "2" "r"))("ʽ"))
    ((("3" "r"))("")) ;(((" " "3" "r"))(""))
    ((("4" "r"))("")) (((" " "4" "r"))(""))
    ((("5" "r"))("")) (((" " "5" "r"))(""))
    ((("6" "r"))("")) (((" " "6" "r"))(""))
    ((("7" "r"))("")) (((" " "7" "r"))(""))
    ((("8" "r"))("")) (((" " "8" "r"))(""))
    ((("9" "r"))("®")) (((" " "9" "r"))(""))
    ((("0" "r"))("")) ;(((" " "0" "r"))(""))
    ((("q" "r"))("")) (((" " "q" "r"))(""))
    ((("w" "r"))("")) (((" " "w" "r"))(""))
    ((("e" "r"))("ǽ")) (((" " "e" "r"))(""))
    ((("r" "r"))("")) (((" " "r" "r"))(""))
    ((("t" "r"))("")) (((" " "t" "r"))(""))
    ((("y" "r"))("")) (((" " "y" "r"))(""))
    ((("u" "r"))("")) (((" " "u" "r"))(""))
    ((("i" "r"))("")) (((" " "i" "r"))("Ȥ"))
    ((("o" "r"))("ȯ")) (((" " "o" "r"))(""))
    ((("p" "r"))("Ω")) (((" " "p" "r"))(""))
    ((("a" "r"))("")) (((" " "a" "r"))(""))
    ((("s" "r"))("")) (((" " "s" "r"))(""))
    ((("d" "r"))("")) (((" " "d" "r"))(""))
    ((("f" "r"))("¦")) (((" " "f" "r"))("")) ; 
    ((("g" "r"))("")) (((" " "g" "r"))(""))
    ((("h" "r"))("")) (((" " "h" "r"))(""))
    ((("j" "r"))("")) (((" " "j" "r"))("")) ; Ĥ
    ((("k" "r"))("")) (((" " "k" "r"))(""))
    ((("l" "r"))("")) (((" " "l" "r"))("Ԣ"))
    (((";" "r"))("")) (((" " ";" "r"))(""))
    ((("z" "r"))("Ŭ")) (((" " "z" "r"))(""))
    ((("x" "r"))("")) (((" " "x" "r"))("Ӯ"))
    ((("c" "r"))("")) ;(((" " "c" "r"))(""))
    ((("v" "r"))("")) (((" " "v" "r"))(""))
    ((("b" "r"))("")) (((" " "b" "r"))(""))
    ((("n" "r"))("")) (((" " "n" "r"))(""))
    ((("m" "r"))("̾")) (((" " "m" "r"))(""))
    ((("," "r"))("")) (((" " "," "r"))(""))
    ((("." "r"))("")) (((" " "." "r"))(""))
    ((("/" "r"))("")) (((" " "/" "r"))("")) ; 
    ((("1" "t"))("")) ;(((" " "1" "t"))(""))
    ((("2" "t"))("")) (((" " "2" "t"))(""))
    ((("3" "t"))("")) (((" " "3" "t"))(""))
    ((("4" "t"))("")) (((" " "4" "t"))(""))
    ((("5" "t"))("")) ;(((" " "5" "t"))(""))
    ((("6" "t"))("")) ;(((" " "6" "t"))(""))
    ((("7" "t"))("")) (((" " "7" "t"))(""))
    ((("8" "t"))("")) (((" " "8" "t"))("")) ; 
    ((("9" "t"))("")) (((" " "9" "t"))(""))
    ((("0" "t"))("")) ;(((" " "0" "t"))(""))
    ((("q" "t"))("")) (((" " "q" "t"))(""))
    ((("w" "t"))("")) (((" " "w" "t"))(""))
    ((("e" "t"))("")) (((" " "e" "t"))("Ρ"))
    ((("r" "t"))("")) (((" " "r" "t"))(""))
    ((("t" "t"))("")) (((" " "t" "t"))(""))
    ((("y" "t"))("")) ;(((" " "y" "t"))(""))
    ((("u" "t"))("")) (((" " "u" "t"))(""))
    ((("i" "t"))("")) (((" " "i" "t"))("")) ; ޥ
    ((("o" "t"))("")) (((" " "o" "t"))(""))
    ((("p" "t"))("")) (((" " "p" "t"))(""))
    ((("a" "t"))("")) (((" " "a" "t"))("̨"))
    ((("s" "t"))("")) (((" " "s" "t"))("ø"))
    ((("d" "t"))("")) (((" " "d" "t"))(""))
    ((("f" "t"))("")) ;(((" " "f" "t"))(""))
    ((("g" "t"))("")) (((" " "g" "t"))("γ"))
    ((("h" "t"))("")) (((" " "h" "t"))(""))
    ((("j" "t"))("")) (((" " "j" "t"))("")) ; ̵
    ((("k" "t"))("8")) (((" " "k" "t"))("˪"))
    ((("l" "t"))("")) (((" " "l" "t"))(""))
    (((";" "t"))("ǯ")) ;(((" " ";" "t"))(""))
    ((("z" "t"))("")) (((" " "z" "t"))(""))
    ((("x" "t"))("")) (((" " "x" "t"))(""))
    ((("c" "t"))("")) (((" " "c" "t"))(""))
    ((("v" "t"))("")) (((" " "v" "t"))(""))
    ((("b" "t"))("")) (((" " "b" "t"))("̢"))
    ((("n" "t"))("")) (((" " "n" "t"))(""))
    ((("m" "t"))("")) (((" " "m" "t"))(""))
    ((("," "t"))("")) (((" " "," "t"))("")) ; ѥѥ
    ((("." "t"))("")) ;(((" " "." "t"))(""))
    ((("/" "t"))("")) (((" " "/" "t"))(""))
    ((("1" "y"))("")) ;(((" " "1" "y"))(""))
    ((("2" "y"))("ħ")) (((" " "2" "y"))(""))
    ((("3" "y"))("")) (((" " "3" "y"))(""))
    ((("4" "y"))("")) (((" " "4" "y"))(""))
    ((("5" "y"))("")) (((" " "5" "y"))("ȭ"))
    ((("6" "y"))("ɡ")) (((" " "6" "y"))(""))
    ((("7" "y"))("")) ;(((" " "7" "y"))(""))
    ((("8" "y"))("")) (((" " "8" "y"))(""))
    ((("9" "y"))("")) (((" " "9" "y"))(""))
    ((("0" "y"))("")) (((" " "0" "y"))("̡"))
    ((("q" "y"))("")) (((" " "q" "y"))(""))
    ((("w" "y"))("")) (((" " "w" "y"))(""))
    ((("e" "y"))("")) (((" " "e" "y"))(""))
    ((("r" "y"))("")) (((" " "r" "y"))(""))
    ((("t" "y"))("ɾ")) ;(((" " "t" "y"))(""))
    ((("y" "y"))("")) (((" " "y" "y"))(""))
    ((("u" "y"))("ˡ")) ;(((" " "u" "y"))(""))
    ((("i" "y"))("")) (((" " "i" "y"))(""))
    ((("o" "y"))("Ϻ")) (((" " "o" "y"))("ϭ"))
    ((("p" "y"))("")) (((" " "p" "y"))(""))
    ((("a" "y"))("")) (((" " "a" "y"))(""))
    ((("s" "y"))("")) (((" " "s" "y"))("")) ; Τ
    ((("d" "y"))("Ǥ")) (((" " "d" "y"))(""))
    ((("f" "y"))("")) (((" " "f" "y"))(""))
    ((("g" "y"))("˭")) (((" " "g" "y"))(""))
    ((("h" "y"))("")) (((" " "h" "y"))(""))
    ((("j" "y"))("")) (((" " "j" "y"))(""))
    ((("k" "y"))("")) (((" " "k" "y"))("Ч"))
    ((("l" "y"))("")) (((" " "l" "y"))(""))
    (((";" "y"))("")) (((" " ";" "y"))(""))
    ((("z" "y"))("")) (((" " "z" "y"))(""))
    ((("x" "y"))("")) (((" " "x" "y"))("η"))
    ((("c" "y"))("")) (((" " "c" "y"))(""))
    ((("v" "y"))("Ψ")) ;(((" " "v" "y"))(""))
    ((("b" "y"))("")) (((" " "b" "y"))(""))
    ((("n" "y"))("")) (((" " "n" "y"))(""))
    ((("m" "y"))("û")) (((" " "m" "y"))(""))
    ((("," "y"))("")) (((" " "," "y"))(""))
    ((("." "y"))("")) (((" " "." "y"))("ˤ"))
    ((("/" "y"))("")) (((" " "/" "y"))(""))
    ((("1" "u"))("")) ;(((" " "1" "u"))(""))
    ((("2" "u"))("")) (((" " "2" "u"))(""))
    ((("3" "u"))("")) (((" " "3" "u"))(""))
    ((("4" "u"))("")) (((" " "4" "u"))(""))
    ((("5" "u"))("ʣ")) ;(((" " "5" "u"))(""))
    ((("6" "u"))("ɹ")) (((" " "6" "u"))(""))
    ((("7" "u"))("")) (((" " "7" "u"))(""))
    ((("8" "u"))("")) (((" " "8" "u"))(""))
    ((("9" "u"))("")) (((" " "9" "u"))(""))
    ((("0" "u"))("")) (((" " "0" "u"))(""))
    ((("q" "u"))("")) (((" " "q" "u"))(""))
    ((("w" "u"))("")) (((" " "w" "u"))(""))
    ((("e" "u"))("")) (((" " "e" "u"))(""))
    ((("r" "u"))("")) (((" " "r" "u"))(""))
    ((("t" "u"))("")) (((" " "t" "u"))("")) ; 
    ((("y" "u"))("")) (((" " "y" "u"))(""))
    ((("u" "u"))("")) (((" " "u" "u"))("ͫ")) ; ͫʤ
    ((("i" "u"))("")) (((" " "i" "u"))(""))
    ((("o" "u"))("")) (((" " "o" "u"))("˻")) ; g
    ((("p" "u"))("")) ;(((" " "p" "u"))(""))
    ((("a" "u"))("")) (((" " "a" "u"))("̯"))
    ((("s" "u"))("")) (((" " "s" "u"))(""))
    ((("d" "u"))("")) (((" " "d" "u"))(""))
    ((("f" "u"))("")) (((" " "f" "u"))("ä"))
    ((("g" "u"))("")) (((" " "g" "u"))("")) ; ݤηθ
    ((("h" "u"))("")) (((" " "h" "u"))(""))
    ((("j" "u"))("")) (((" " "j" "u"))(""))
    ((("k" "u"))("")) (((" " "k" "u"))(""))
    ((("l" "u"))("")) (((" " "l" "u"))(""))
    (((";" "u"))("")) (((" " ";" "u"))("ȡ"))
    ((("z" "u"))("")) (((" " "z" "u"))("Ī"))
    ((("x" "u"))("")) (((" " "x" "u"))(""))
    ((("c" "u"))("ι")) (((" " "c" "u"))("")) ; ϶ι
    ((("v" "u"))("")) ;(((" " "v" "u"))(""))
    ((("b" "u"))("")) (((" " "b" "u"))(""))
    ((("n" "u"))("")) (((" " "n" "u"))("")) ; ڤ
    ((("m" "u"))("")) (((" " "m" "u"))(""))
    ((("," "u"))("")) (((" " "," "u"))(""))
    ((("." "u"))("")) ;(((" " "." "u"))(""))
    ((("/" "u"))("")) ;(((" " "/" "u"))(""))
    ((("1" "i"))("")) (((" " "1" "i"))(""))
    ((("2" "i"))("")) (((" " "2" "i"))(""))
    ((("3" "i"))("")) (((" " "3" "i"))(""))
    ((("4" "i"))("ɮ")) (((" " "4" "i"))(""))
    ((("5" "i"))("Τ")) (((" " "5" "i"))(""))
    ((("6" "i"))("")) (((" " "6" "i"))(""))
    ((("7" "i"))("")) (((" " "7" "i"))(""))
    ((("8" "i"))("")) (((" " "8" "i"))(""))
    ((("9" "i"))("")) (((" " "9" "i"))(""))
    ((("0" "i"))("")) (((" " "0" "i"))(""))
    ((("q" "i"))("")) (((" " "q" "i"))(""))
    ((("w" "i"))("")) (((" " "w" "i"))("Ͷ"))
    ((("e" "i"))("")) (((" " "e" "i"))(""))
    ((("r" "i"))("")) (((" " "r" "i"))("Ž")) ; Ϥ
    ((("t" "i"))("")) (((" " "t" "i"))(""))
    ((("y" "i"))("")) (((" " "y" "i"))(""))
    ((("u" "i"))("ī")) (((" " "u" "i"))(""))
    ((("i" "i"))("")) (((" " "i" "i"))(""))
    ((("o" "i"))("")) ;(((" " "o" "i"))(""))
    ((("p" "i"))("")) (((" " "p" "i"))("£"))
    ((("a" "i"))("")) (((" " "a" "i"))("")) ; ¤Ԥ
    ((("s" "i"))("")) (((" " "s" "i"))(""))
    ((("d" "i"))("ϫ")) (((" " "d" "i"))(""))
    ((("f" "i"))("")) (((" " "f" "i"))("Ż"))
    ((("g" "i"))("")) (((" " "g" "i"))(""))
    ((("h" "i"))("")) ;(((" " "h" "i"))(""))
    ((("j" "i"))("")) (((" " "j" "i"))(""))
    ((("k" "i"))("")) (((" " "k" "i"))("")) ; 
    ((("l" "i"))("")) (((" " "l" "i"))(""))
    (((";" "i"))("ë")) (((" " ";" "i"))(""))
    ((("z" "i"))("")) (((" " "z" "i"))(""))
    ((("x" "i"))("Ƴ")) ;(((" " "x" "i"))(""))
    ((("c" "i"))("ǧ")) (((" " "c" "i"))("Ǧ"))
    ((("v" "i"))("")) (((" " "v" "i"))(""))
    ((("b" "i"))("")) (((" " "b" "i"))(""))
    ((("n" "i"))("")) (((" " "n" "i"))(""))
    ((("m" "i"))("")) (((" " "m" "i"))(""))
    ((("," "i"))("")) (((" " "," "i"))("ϣ"))
    ((("." "i"))("ǰ")) (((" " "." "i"))("Ǳ"))
    ((("/" "i"))("Ư")) (((" " "/" "i"))(""))
    ((("1" "o"))("")) (((" " "1" "o"))(""))
    ((("2" "o"))("Ǽ")) (((" " "2" "o"))("")) ; ȤξǼޤ
    ((("3" "o"))("")) ;(((" " "3" "o"))(""))
    ((("4" "o"))("ƨ")) (((" " "4" "o"))(""))
    ((("5" "o"))("")) (((" " "5" "o"))("̲"))
    ((("6" "o"))("")) (((" " "6" "o"))("")) ; ֿ
    ((("7" "o"))("")) (((" " "7" "o"))(""))
    ((("8" "o"))("")) (((" " "8" "o"))("")) ; â
    ((("9" "o"))("")) (((" " "9" "o"))(""))
    ((("0" "o"))("")) (((" " "0" "o"))("")) ; ᡼
    ((("q" "o"))("")) (((" " "q" "o"))(""))
    ((("w" "o"))("")) (((" " "w" "o"))(""))
    ((("e" "o"))("")) (((" " "e" "o"))(""))
    ((("r" "o"))("")) (((" " "r" "o"))(""))
    ((("t" "o"))("")) (((" " "t" "o"))(""))
    ((("y" "o"))("")) (((" " "y" "o"))("ݨ"))
    ((("u" "o"))("")) ;(((" " "u" "o"))(""))
    ((("i" "o"))("")) (((" " "i" "o"))(""))
    ((("o" "o"))("")) ;(((" " "o" "o"))(""))
    ((("p" "o"))("")) (((" " "p" "o"))(""))
    ((("a" "o"))("")) (((" " "a" "o"))(""))
    ((("s" "o"))("")) (((" " "s" "o"))("")) ; 
    ((("d" "o"))("")) (((" " "d" "o"))(""))
    ((("f" "o"))("")) (((" " "f" "o"))(""))
    ((("g" "o"))("")) (((" " "g" "o"))(""))
    ((("h" "o"))("")) (((" " "h" "o"))(""))
    ((("j" "o"))("")) (((" " "j" "o"))(""))
    ((("k" "o"))("")) (((" " "k" "o"))(""))
    ((("l" "o"))("")) (((" " "l" "o"))(""))
    (((";" "o"))("")) ;(((" " ";" "o"))(""))
    ((("z" "o"))("")) (((" " "z" "o"))(""))
    ((("x" "o"))("")) (((" " "x" "o"))(""))
    ((("c" "o"))("")) (((" " "c" "o"))(""))
    ((("v" "o"))("")) ;(((" " "v" "o"))(""))
    ((("b" "o"))("")) (((" " "b" "o"))("¯"))
    ((("n" "o"))("")) (((" " "n" "o"))(""))
    ((("m" "o"))("")) ;(((" " "m" "o"))(""))
    ((("," "o"))("")) (((" " "," "o"))("")) ; Ф
    ((("." "o"))("")) (((" " "." "o"))(""))
    ((("/" "o"))("")) (((" " "/" "o"))(""))
    ((("1" "p"))("")) (((" " "1" "p"))(""))
    ((("2" "p"))("")) ;(((" " "2" "p"))(""))
    ((("3" "p"))("")) ;(((" " "3" "p"))(""))
    ((("4" "p"))("")) (((" " "4" "p"))(""))
    ((("5" "p"))("")) (((" " "5" "p"))("ȳ"))
    ((("6" "p"))("")) (((" " "6" "p"))("Ŧ"))
    ((("7" "p"))("")) (((" " "7" "p"))(""))
    ((("8" "p"))("")) (((" " "8" "p"))("̷"))
    ((("9" "p"))("")) (((" " "9" "p"))(""))
    ((("0" "p"))("")) (((" " "0" "p"))(""))
    ((("q" "p"))("")) ;(((" " "q" "p"))(""))
    ((("w" "p"))("")) (((" " "w" "p"))("ϧ"))
    ((("e" "p"))("")) (((" " "e" "p"))(""))
    ((("r" "p"))("")) (((" " "r" "p"))(""))
    ((("t" "p"))("")) ;(((" " "t" "p"))(""))
    ((("y" "p"))("̵")) (((" " "y" "p"))("ɵ"))
    ((("u" "p"))("")) (((" " "u" "p"))(""))
    ((("i" "p"))("")) (((" " "i" "p"))(""))
    ((("o" "p"))("")) (((" " "o" "p"))("˶"))
    ((("p" "p"))("")) (((" " "p" "p"))(""))
    ((("a" "p"))("")) (((" " "a" "p"))(""))
    ((("s" "p"))("")) (((" " "s" "p"))(""))
    ((("d" "p"))("")) (((" " "d" "p"))(""))
    ((("f" "p"))("")) (((" " "f" "p"))("س"))
    ((("g" "p"))("")) ;(((" " "g" "p"))(""))
    ((("h" "p"))("ͥ")) (((" " "h" "p"))(""))
    ((("j" "p"))("")) (((" " "j" "p"))(""))
    ((("k" "p"))("")) (((" " "k" "p"))(""))
    ((("l" "p"))("")) (((" " "l" "p"))(""))
    (((";" "p"))("")) (((" " ";" "p"))(""))
    ((("z" "p"))("")) ;(((" " "z" "p"))(""))
    ((("x" "p"))("")) (((" " "x" "p"))(""))
    ((("c" "p"))("")) (((" " "c" "p"))(""))
    ((("v" "p"))("")) (((" " "v" "p"))(""))
    ((("b" "p"))("")) (((" " "b" "p"))("Ǣ"))
    ((("n" "p"))("")) ;(((" " "n" "p"))(""))
    ((("m" "p"))("¨")) ;(((" " "m" "p"))(""))
    ((("," "p"))("")) (((" " "," "p"))(""))
    ((("." "p"))("")) (((" " "." "p"))("")) ; ̡
    ((("/" "p"))("")) (((" " "/" "p"))(""))
    ((("1" "a"))("")) (((" " "1" "a"))("")) ; 
    ((("2" "a"))("")) (((" " "2" "a"))("Ϯ"))
    ((("3" "a"))("")) (((" " "3" "a"))(""))
    ((("4" "a"))("")) (((" " "4" "a"))(""))
    ((("5" "a"))("ɩ")) (((" " "5" "a"))("ο"))
    ((("6" "a"))("")) (((" " "6" "a"))("ϰ"))
    ((("7" "a"))("")) (((" " "7" "a"))(""))
    ((("8" "a"))("Ļ")) (((" " "8" "a"))(""))
    ((("9" "a"))("")) ;(((" " "9" "a"))(""))
    ((("0" "a"))("")) (((" " "0" "a"))(""))
    ((("q" "a"))("")) (((" " "q" "a"))(""))
    ((("w" "a"))("")) ;(((" " "w" "a"))(""))
    ((("e" "a"))("")) (((" " "e" "a"))(""))
    ((("r" "a"))("")) (((" " "r" "a"))(""))
    ((("t" "a"))("")) (((" " "t" "a"))(""))
    ((("y" "a"))("")) (((" " "y" "a"))(""))
    ((("u" "a"))("")) (((" " "u" "a"))("")) ; stripe
    ((("i" "a"))("")) (((" " "i" "a"))(""))
    ((("o" "a"))("")) (((" " "o" "a"))(""))
    ((("p" "a"))("")) (((" " "p" "a"))(""))
    ((("a" "a"))("")) (((" " "a" "a"))(""))
    ((("s" "a"))("")) ;(((" " "s" "a"))(""))
    ((("d" "a"))("")) ;(((" " "d" "a"))(""))
    ((("f" "a"))("")) (((" " "f" "a"))(""))
    ((("g" "a"))("")) (((" " "g" "a"))(""))
    ((("h" "a"))("3")) (((" " "h" "a"))("")) ; 
    ((("j" "a"))("")) (((" " "j" "a"))(""))
    ((("k" "a"))("")) (((" " "k" "a"))("")) ; Ţ0
    ((("l" "a"))("")) (((" " "l" "a"))(""))
    (((";" "a"))("")) (((" " ";" "a"))(""))
    ((("z" "a"))("")) (((" " "z" "a"))(""))
    ((("x" "a"))("")) (((" " "x" "a"))(""))
    ((("c" "a"))("")) (((" " "c" "a"))(""))
    ((("v" "a"))("")) (((" " "v" "a"))("")) ; ʡ
    ((("b" "a"))("")) (((" " "b" "a"))(""))
    ((("n" "a"))("")) (((" " "n" "a"))(""))
    ((("m" "a"))("")) (((" " "m" "a"))(""))
    ((("," "a"))("")) (((" " "," "a"))(""))
    ((("." "a"))("")) (((" " "." "a"))(""))
    ((("/" "a"))("")) (((" " "/" "a"))(""))
    ((("1" "s"))("")) (((" " "1" "s"))("")) ; ԤԤ
    ((("2" "s"))("")) (((" " "2" "s"))(""))
    ((("3" "s"))("")) (((" " "3" "s"))(""))
    ((("4" "s"))("")) (((" " "4" "s"))(""))
    ((("5" "s"))("ɳ")) (((" " "5" "s"))(""))
    ((("6" "s"))("ŵ")) ;(((" " "6" "s"))(""))
    ((("7" "s"))("")) ;(((" " "7" "s"))(""))
    ((("8" "s"))("")) ;(((" " "8" "s"))(""))
    ((("9" "s"))("")) ;(((" " "9" "s"))(""))
    ((("0" "s"))("")) (((" " "0" "s"))(""))
    ((("q" "s"))("")) (((" " "q" "s"))("ƿ"))
    ((("w" "s"))("ͺ")) (((" " "w" "s"))(""))
    ((("e" "s"))("")) ;(((" " "e" "s"))(""))
    ((("r" "s"))("")) (((" " "r" "s"))("ÿ"))
    ((("t" "s"))("")) ;(((" " "t" "s"))(""))
    ((("y" "s"))("")) (((" " "y" "s"))(""))
    ((("u" "s"))("")) (((" " "u" "s"))(""))
    ((("i" "s"))("")) (((" " "i" "s"))(""))
    ((("o" "s"))("")) (((" " "o" "s"))(""))
    ((("p" "s"))("")) (((" " "p" "s"))("ϵ"))
    ((("a" "s"))("")) (((" " "a" "s"))("š"))
    ((("s" "s"))("")) (((" " "s" "s"))(""))
    ((("d" "s"))("")) (((" " "d" "s"))(""))
    ((("f" "s"))("")) (((" " "f" "s"))("å"))
    ((("g" "s"))("")) (((" " "g" "s"))(""))
    ((("h" "s"))("")) (((" " "h" "s"))("")) ; ֡ץ
    ((("j" "s"))("")) (((" " "j" "s"))(""))
    ((("k" "s"))("")) (((" " "k" "s"))("á"))
    ((("l" "s"))("")) (((" " "l" "s"))(""))
    (((";" "s"))("")) (((" " ";" "s"))(""))
    ((("z" "s"))("")) ;(((" " "z" "s"))(""))
    ((("x" "s"))("")) (((" " "x" "s"))(""))
    ((("c" "s"))("¢")) ;(((" " "c" "s"))(""))
    ((("v" "s"))("")) (((" " "v" "s"))("")) ; Ϥ
    ((("b" "s"))("¤")) (((" " "b" "s"))(""))
    ((("n" "s"))("")) (((" " "n" "s"))("Ϥ")) ; Ҳ̾
    ((("m" "s"))("")) (((" " "m" "s"))("")) ; club
    ((("," "s"))("")) (((" " "," "s"))(""))
    ((("." "s"))("")) (((" " "." "s"))("˧"))
    ((("/" "s"))("")) (((" " "/" "s"))("")) ; phosphorus
    ((("1" "d"))("")) (((" " "1" "d"))("")) ; ץƥ
    ((("2" "d"))("")) (((" " "2" "d"))(""))
    ((("3" "d"))("")) (((" " "3" "d"))(""))
    ((("4" "d"))("")) ;(((" " "4" "d"))(""))
    ((("5" "d"))("")) (((" " "5" "d"))("ǭ"))
    ((("6" "d"))("")) ;(((" " "6" "d"))(""))
    ((("7" "d"))("")) (((" " "7" "d"))(""))
    ((("8" "d"))("")) (((" " "8" "d"))(""))
    ((("9" "d"))("ʩ")) (((" " "9" "d"))(""))
    ((("0" "d"))("")) (((" " "0" "d"))(""))
    ((("q" "d"))("")) (((" " "q" "d"))(""))
    ((("w" "d"))("")) ;(((" " "w" "d"))(""))
    ((("e" "d"))("")) (((" " "e" "d"))(""))
    ((("r" "d"))("³")) (((" " "r" "d"))(""))
    ((("t" "d"))("")) (((" " "t" "d"))("")) ; (饷)2ʸ
    ((("y" "d"))("")) (((" " "y" "d"))("ݵ"))
    ((("u" "d"))("4")) (((" " "u" "d"))("")) ; 4ǯ1
    ((("i" "d"))(")")) (((" " "i" "d"))("")) ; Ʊ
    ((("o" "d"))("")) (((" " "o" "d"))("")) ; 夦
    ((("p" "d"))("")) (((" " "p" "d"))(""))
    ((("a" "d"))("")) (((" " "a" "d"))("")) ; 礦
    ((("s" "d"))("")) (((" " "s" "d"))(""))
    ((("d" "d"))("")) (((" " "d" "d"))(""))
    ((("f" "d"))("")) (((" " "f" "d"))("Ǭ"))
    ((("g" "d"))("")) (((" " "g" "d"))(""))
    ((("h" "d"))("")) (((" " "h" "d"))(""))
    ((("j" "d"))("")) (((" " "j" "d"))(""))
    ((("k" "d"))("")) (((" " "k" "d"))("")) ; ΤΤ
    ((("l" "d"))("5")) (((" " "l" "d"))("")) ; 
    (((";" "d"))("1")) (((" " ";" "d"))("")) ; 
    ((("z" "d"))("")) (((" " "z" "d"))(""))
    ((("x" "d"))("")) (((" " "x" "d"))(""))
    ((("c" "d"))("")) (((" " "c" "d"))(""))
    ((("v" "d"))("Ⱦ")) (((" " "v" "d"))("ȼ"))
    ((("b" "d"))("")) (((" " "b" "d"))(""))
    ((("n" "d"))("")) (((" " "n" "d"))("")) ; 
    ((("m" "d"))("")) (((" " "m" "d"))(""))
    ((("," "d"))("")) (((" " "," "d"))("")) ; 饤֥
    ((("." "d"))("")) (((" " "." "d"))(""))
    ((("/" "d"))("")) (((" " "/" "d"))("ɤ"))
    ((("1" "f"))("")) (((" " "1" "f"))("")) ; ڤ
    ((("2" "f"))("")) (((" " "2" "f"))(""))
    ((("3" "f"))("")) (((" " "3" "f"))(""))
    ((("4" "f"))("")) ;(((" " "4" "f"))(""))
    ((("5" "f"))("ʰ")) (((" " "5" "f"))("ʮ"))
    ((("6" "f"))("")) (((" " "6" "f"))("ɿ")) ; ɿ
    ((("7" "f"))("")) (((" " "7" "f"))(""))
    ((("8" "f"))("")) ;(((" " "8" "f"))(""))
    ((("9" "f"))("")) ;(((" " "9" "f"))(""))
    ((("0" "f"))("ɸ")) (((" " "0" "f"))("ɺ"))
    ((("q" "f"))("")) (((" " "q" "f"))(""))
    ((("w" "f"))("")) (((" " "w" "f"))("Ϩ")) ; Ⱦʬ
    ((("e" "f"))("")) (((" " "e" "f"))(""))
    ((("r" "f"))("")) (((" " "r" "f"))(""))
    ((("t" "f"))("")) (((" " "t" "f"))(""))
    ((("y" "f"))("")) (((" " "y" "f"))(""))
    ((("u" "f"))("")) (((" " "u" "f"))(""))
    ((("i" "f"))("6")) (((" " "i" "f"))("")) ; 1+5
    ((("o" "f"))("")) (((" " "o" "f"))(""))
    ((("p" "f"))("")) (((" " "p" "f"))(""))
    ((("a" "f"))("")) (((" " "a" "f"))(""))
    ((("s" "f"))("ͽ")) (((" " "s" "f"))("ͱ"))
    ((("d" "f"))("")) (((" " "d" "f"))(""))
    ((("f" "f"))("")) (((" " "f" "f"))(""))
    ((("g" "f"))("")) (((" " "g" "f"))(""))
    ((("h" "f"))("")) (((" " "h" "f"))(""))
    ;((("j" "f"))("")) ;(((" " "j" "f"))(""))
    ((("k" "f"))("0")) (((" " "k" "f"))("")) ; null
    ((("l" "f"))("")) (((" " "l" "f"))(""))
    (((";" "f"))("2")) (((" " ";" "f"))("")) ; 2ch
    ((("z" "f"))("")) ;(((" " "z" "f"))(""))
    ((("x" "f"))("")) (((" " "x" "f"))(""))
    ((("c" "f"))("")) (((" " "c" "f"))(""))
    ((("v" "f"))("")) (((" " "v" "f"))(""))
    ((("b" "f"))("")) (((" " "b" "f"))(""))
    ((("n" "f"))("")) (((" " "n" "f"))(""))
    ((("m" "f"))("")) (((" " "m" "f"))("")) ; interview
    ((("," "f"))("")) (((" " "," "f"))(""))
    ((("." "f"))("")) (((" " "." "f"))(""))
    ((("/" "f"))("")) (((" " "/" "f"))(""))
    ((("1" "g"))("")) (((" " "1" "g"))(""))
    ((("2" "g"))("")) (((" " "2" "g"))(""))
    ((("3" "g"))("")) (((" " "3" "g"))(""))
    ((("4" "g"))("")) (((" " "4" "g"))(""))
    ((("5" "g"))("")) (((" " "5" "g"))("ʾ"))
    ((("6" "g"))("")) (((" " "6" "g"))("ϴ"))
    ((("7" "g"))(";")) (((" " "7" "g"))(""))
    ((("8" "g"))("")) (((" " "8" "g"))(""))
    ((("9" "g"))("")) (((" " "9" "g"))("")) ; 
    ((("0" "g"))("")) (((" " "0" "g"))(""))
    ((("q" "g"))("")) (((" " "q" "g"))(""))
    ((("w" "g"))("")) ;(((" " "w" "g"))(""))
    ((("e" "g"))("")) (((" " "e" "g"))("")) ; Ҥ
    ((("r" "g"))("")) (((" " "r" "g"))(""))
    ((("t" "g"))("ʹ")) (((" " "t" "g"))("İ"))
    ((("y" "g"))("")) (((" " "y" "g"))(""))
    ((("u" "g"))("")) (((" " "u" "g"))(""))
    ((("i" "g"))("")) (((" " "i" "g"))(""))
    ((("o" "g"))("")) (((" " "o" "g"))(""))
    ((("p" "g"))("")) ;(((" " "p" "g"))(""))
    ((("a" "g"))("")) (((" " "a" "g"))(""))
    ((("s" "g"))("")) (((" " "s" "g"))(""))
    ((("d" "g"))("")) (((" " "d" "g"))(""))
    ((("f" "g"))("")) ;(((" " "f" "g"))(""))
    ((("g" "g"))("")) (((" " "g" "g"))(""))
    ((("h" "g"))("")) ;(((" " "h" "g"))(""))
    ((("j" "g"))("")) (((" " "j" "g"))("þ")) ; þ
    ((("k" "g"))("")) (((" " "k" "g"))(""))
    ((("l" "g"))("")) (((" " "l" "g"))(""))
    (((";" "g"))("")) ;(((" " ";" "g"))(""))
    ((("z" "g"))("ž")) (((" " "z" "g"))(""))
    ((("x" "g"))("")) (((" " "x" "g"))(""))
    ((("c" "g"))("")) (((" " "c" "g"))(""))
    ((("v" "g"))("")) (((" " "v" "g"))(""))
    ((("b" "g"))("")) ;(((" " "b" "g"))(""))
    ((("n" "g"))("")) ;(((" " "n" "g"))(""))
    ((("m" "g"))("")) (((" " "m" "g"))("ˢ")) ; 
    ((("," "g"))("")) (((" " "," "g"))(""))
    ((("." "g"))("Ĺ")) (((" " "." "g"))("ͪ"))
    ((("/" "g"))("")) (((" " "/" "g"))("")) ; 
    ((("1" "h"))("")) (((" " "1" "h"))(""))
    ((("2" "h"))("")) (((" " "2" "h"))(""))
    ((("3" "h"))("")) (((" " "3" "h"))(""))
    ((("4" "h"))("")) (((" " "4" "h"))(""))
    ((("5" "h"))("")) (((" " "5" "h"))(""))
    ((("6" "h"))("")) (((" " "6" "h"))(""))
    ((("7" "h"))("")) (((" " "7" "h"))(""))
    ((("8" "h"))("")) (((" " "8" "h"))(""))
    ((("9" "h"))("")) (((" " "9" "h"))(""))
    ((("0" "h"))("")) (((" " "0" "h"))("۹"))
    ((("q" "h"))("")) (((" " "q" "h"))(""))
    ((("w" "h"))("")) (((" " "w" "h"))(""))
    ((("e" "h"))("")) (((" " "e" "h"))(""))
    ((("r" "h"))("ϩ")) (((" " "r" "h"))(""))
    ((("t" "h"))("")) (((" " "t" "h"))("Ѩ"))
    ((("y" "h"))("")) (((" " "y" "h"))("̸"))
    ((("u" "h"))("")) (((" " "u" "h"))(""))
    ((("i" "h"))("")) (((" " "i" "h"))("")) ; ưʪΤԤ
    ((("o" "h"))("")) (((" " "o" "h"))("")) ; 
    ((("p" "h"))("ʪ")) (((" " "p" "h"))("ͣ"))
    ((("a" "h"))("")) (((" " "a" "h"))("")) ; 
    ((("s" "h"))("ɬ")) (((" " "s" "h"))(""))
    ((("d" "h"))("")) ;(((" " "d" "h"))(""))
    ((("f" "h"))("")) (((" " "f" "h"))("ۣ"))
    ((("g" "h"))("")) (((" " "g" "h"))(""))
    ((("h" "h"))("")) (((" " "h" "h"))("")) ; 
    ((("j" "h"))("")) (((" " "j" "h"))("")) ; ⤦
    ((("k" "h"))("")) (((" " "k" "h"))(""))
    ((("l" "h"))("ƣ")) (((" " "l" "h"))(""))
    (((";" "h"))("ͭ")) (((" " ";" "h"))(""))
    ((("z" "h"))("")) (((" " "z" "h"))(""))
    ((("x" "h"))("ʼ")) (((" " "x" "h"))(""))
    ((("c" "h"))("")) ;(((" " "c" "h"))(""))
    ((("v" "h"))("")) (((" " "v" "h"))(""))
    ((("b" "h"))("")) (((" " "b" "h"))("ν"))
    ((("n" "h"))("")) (((" " "n" "h"))("")) ; 
    ((("m" "h"))("")) (((" " "m" "h"))(""))
    ((("," "h"))("")) (((" " "," "h"))("")) ; ֥ĥ֥
    ((("." "h"))("ʿ")) (((" " "." "h"))(""))
    ((("/" "h"))("")) (((" " "/" "h"))(""))
    ((("1" "j"))("")) ;(((" " "1" "j"))(""))
    ((("2" "j"))("")) (((" " "2" "j"))(""))
    ((("3" "j"))("")) (((" " "3" "j"))("ϼ"))
    ((("4" "j"))("")) ;(((" " "4" "j"))(""))
    ((("5" "j"))("")) (((" " "5" "j"))("")) ; Ϣ
    ((("6" "j"))("")) (((" " "6" "j"))(""))
    ((("7" "j"))("")) (((" " "7" "j"))(""))
    ((("8" "j"))("")) (((" " "8" "j"))(""))
    ((("9" "j"))("ź")) ;(((" " "9" "j"))(""))
    ((("0" "j"))("")) ;(((" " "0" "j"))(""))
    ((("q" "j"))("")) (((" " "q" "j"))(""))
    ((("w" "j"))("ĥ")) (((" " "w" "j"))("ı"))
    ((("e" "j"))("")) (((" " "e" "j"))(""))
    ((("r" "j"))("")) (((" " "r" "j"))("˸"))
    ((("t" "j"))("")) (((" " "t" "j"))(""))
    ((("y" "j"))("")) (((" " "y" "j"))("")) ; ֥
    ((("u" "j"))("")) (((" " "u" "j"))(""))
    ((("i" "j"))("")) (((" " "i" "j"))(""))
    ((("o" "j"))("")) (((" " "o" "j"))(""))
    ((("p" "j"))("")) (((" " "p" "j"))(""))
    ((("a" "j"))("͢")) (((" " "a" "j"))("͡"))
    ((("s" "j"))("")) ;(((" " "s" "j"))(""))
    ((("d" "j"))("")) (((" " "d" "j"))("Ͼ"))
    ;((("f" "j"))("")) ;(((" " "f" "j"))(""))
    ((("g" "j"))("ή")) (((" " "g" "j"))("β"))
    ((("h" "j"))("Ϣ")) (((" " "h" "j"))(""))
    ((("j" "j"))("Ŵ")) (((" " "j" "j"))(""))
    ((("k" "j"))("")) (((" " "k" "j"))("ļ")) ; ļ
    ((("l" "j"))("")) (((" " "l" "j"))(""))
    (((";" "j"))("")) ;(((" " ";" "j"))(""))
    ((("z" "j"))("")) (((" " "z" "j"))("ȱ"))
    ((("x" "j"))("")) (((" " "x" "j"))(""))
    ((("c" "j"))("")) (((" " "c" "j"))(""))
    ((("v" "j"))("")) (((" " "v" "j"))("")) ; Ǧ
    ((("b" "j"))("")) (((" " "b" "j"))(""))
    ((("n" "j"))("")) (((" " "n" "j"))(""))
    ((("m" "j"))("")) (((" " "m" "j"))(""))
    ((("," "j"))("")) (((" " "," "j"))("")) ; ()
    ((("." "j"))("")) (((" " "." "j"))(""))
    ((("/" "j"))("")) (((" " "/" "j"))(""))
    ((("1" "k"))("")) (((" " "1" "k"))(""))
    ((("2" "k"))("")) ;(((" " "2" "k"))(""))
    ((("3" "k"))("")) ;(((" " "3" "k"))(""))
    ((("4" "k"))("")) (((" " "4" "k"))(""))
    ((("5" "k"))("")) (((" " "5" "k"))(""))
    ((("6" "k"))("")) ;(((" " "6" "k"))(""))
    ((("7" "k"))("")) (((" " "7" "k"))(""))
    ((("8" "k"))("")) (((" " "8" "k"))(""))
    ((("9" "k"))("Ű")) (((" " "9" "k"))("ű"))
    ((("0" "k"))("̦")) (((" " "0" "k"))(""))
    ((("q" "k"))("")) (((" " "q" "k"))(""))
    ((("w" "k"))("")) (((" " "w" "k"))(""))
    ((("e" "k"))("")) ;(((" " "e" "k"))(""))
    ((("r" "k"))("")) (((" " "r" "k"))(""))
    ((("t" "k"))("")) (((" " "t" "k"))(""))
    ((("y" "k"))("")) (((" " "y" "k"))(""))
    ((("u" "k"))("")) (((" " "u" "k"))(""))
    ((("i" "k"))("")) (((" " "i" "k"))(""))
    ((("o" "k"))("")) (((" " "o" "k"))("Լ")) ; 
    ((("p" "k"))("")) (((" " "p" "k"))(""))
    ((("a" "k"))("")) (((" " "a" "k"))("¶"))
    ((("s" "k"))("")) (((" " "s" "k"))(""))
    ((("d" "k"))("̣")) (((" " "d" "k"))(""))
    ((("f" "k"))("")) ;(((" " "f" "k"))(""))
    ((("g" "k"))("")) (((" " "g" "k"))(""))
    ((("h" "k"))("")) (((" " "h" "k"))("")) ; distortion
    ((("j" "k"))("")) (((" " "j" "k"))("")) ; ȸ
    ((("k" "k"))("")) (((" " "k" "k"))("")) ; embroidery 
    ((("l" "k"))("¾")) (((" " "l" "k"))(""))
    (((";" "k"))("")) (((" " ";" "k"))(""))
    ((("z" "k"))("")) (((" " "z" "k"))("")) ; 
    ((("x" "k"))("")) (((" " "x" "k"))(""))
    ((("c" "k"))("")) (((" " "c" "k"))(""))
    ((("v" "k"))("")) (((" " "v" "k"))(""))
    ((("b" "k"))("̿")) (((" " "b" "k"))(""))
    ((("n" "k"))("¼")) (((" " "n" "k"))("")) ; Ϳ
    ((("m" "k"))("")) (((" " "m" "k"))(""))
    ((("," "k"))("")) (((" " "," "k"))(""))
    ((("." "k"))("")) (((" " "." "k"))(""))
    ((("/" "k"))("")) (((" " "/" "k"))(""))
    ((("1" "l"))("")) (((" " "1" "l"))(""))
    ((("2" "l"))("")) ;(((" " "2" "l"))(""))
    ((("3" "l"))("̴")) (((" " "3" "l"))("ѳ"))
    ((("4" "l"))("")) ;(((" " "4" "l"))(""))
    ((("5" "l"))("")) (((" " "5" "l"))(""))
    ((("6" "l"))("")) ;(((" " "6" "l"))(""))
    ((("7" "l"))("")) (((" " "7" "l"))(""))
    ((("8" "l"))("")) (((" " "8" "l"))("")) ; 񤷤Ʋ¤
    ((("9" "l"))("")) (((" " "9" "l"))(""))
    ((("0" "l"))("")) (((" " "0" "l"))(""))
    ((("q" "l"))("")) (((" " "q" "l"))(""))
    ((("w" "l"))("")) (((" " "w" "l"))(""))
    ((("e" "l"))("")) (((" " "e" "l"))(""))
    ((("r" "l"))("")) (((" " "r" "l"))(""))
    ((("t" "l"))("")) (((" " "t" "l"))("")) ; ±
    ((("y" "l"))("")) ;(((" " "y" "l"))(""))
    ((("u" "l"))("̱")) (((" " "u" "l"))(""))
    ((("i" "l"))("")) (((" " "i" "l"))(""))
    ((("o" "l"))("")) (((" " "o" "l"))("ũ"))
    ((("p" "l"))("")) (((" " "p" "l"))(""))
    ((("a" "l"))("­")) (((" " "a" "l"))(""))
    ((("s" "l"))("")) (((" " "s" "l"))(""))
    ((("d" "l"))("")) (((" " "d" "l"))(""))
    ((("f" "l"))("")) (((" " "f" "l"))("˵"))
    ((("g" "l"))("")) (((" " "g" "l"))("۩"))
    ((("h" "l"))("")) (((" " "h" "l"))(""))
    ((("j" "l"))("")) (((" " "j" "l"))("¥"))
    ((("k" "l"))("ŷ")) (((" " "k" "l"))("")) ; ŷ桦
    ((("l" "l"))("")) (((" " "l" "l"))(""))
    (((";" "l"))("ʸ")) (((" " ";" "l"))(""))
    ((("z" "l"))("")) (((" " "z" "l"))(""))
    ((("x" "l"))("")) (((" " "x" "l"))(""))
    ((("c" "l"))("")) (((" " "c" "l"))(""))
    ((("v" "l"))("")) (((" " "v" "l"))(""))
    ((("b" "l"))("")) (((" " "b" "l"))("ķ"))
    ((("n" "l"))("")) (((" " "n" "l"))(""))
    ((("m" "l"))("")) (((" " "m" "l"))(""))
    ((("," "l"))("")) (((" " "," "l"))(""))
    ((("." "l"))("")) ;(((" " "." "l"))(""))
    ((("/" "l"))("")) ;(((" " "/" "l"))(""))
    ((("1" ";"))("")) (((" " "1" ";"))(""))
    ((("2" ";"))("")) (((" " "2" ";"))("")) ; 
    ((("3" ";"))("")) (((" " "3" ";"))(""))
    ((("4" ";"))("")) (((" " "4" ";"))(""))
    ((("5" ";"))("")) (((" " "5" ";"))(""))
    ((("6" ";"))("")) (((" " "6" ";"))(""))
    ((("7" ";"))("")) (((" " "7" ";"))("ɪ"))
    ((("8" ";"))("Ʒ")) (((" " "8" ";"))("Ǩ"))
    ((("9" ";"))("ƫ")) (((" " "9" ";"))(""))
    ((("0" ";"))("")) (((" " "0" ";"))("")) ; ޤĤ
    ((("q" ";"))("")) (((" " "q" ";"))(""))
    ((("w" ";"))("")) (((" " "w" ";"))(""))
    ((("e" ";"))("")) (((" " "e" ";"))("")) ; Ҷ򼸤
    ((("r" ";"))("")) (((" " "r" ";"))("ĩ"))
    ((("t" ";"))("")) ;(((" " "t" ";"))(""))
    ((("y" ";"))("")) (((" " "y" ";"))(""))
    ((("u" ";"))("")) ;(((" " "u" ";"))(""))
    ((("i" ";"))("")) (((" " "i" ";"))(""))
    ((("o" ";"))("")) (((" " "o" ";"))(""))
    ((("p" ";"))("")) (((" " "p" ";"))("")) ; 
    ((("a" ";"))("")) (((" " "a" ";"))(""))
    ((("s" ";"))("")) (((" " "s" ";"))(""))
    ((("d" ";"))("")) (((" " "d" ";"))("")) ; 
    ((("f" ";"))("")) (((" " "f" ";"))(""))
    ((("g" ";"))("")) ;(((" " "g" ";"))(""))
    ((("h" ";"))("")) (((" " "h" ";"))("˷"))
    ((("j" ";"))("")) ;(((" " "j" ";"))(""))
    ((("k" ";"))("")) (((" " "k" ";"))(""))
    ((("l" ";"))("")) (((" " "l" ";"))(""))
    (((";" ";"))("")) (((" " ";" ";"))(""))
    ((("z" ";"))("")) (((" " "z" ";"))(""))
    ((("x" ";"))("")) (((" " "x" ";"))("")) ; ˤ()
    ((("c" ";"))("")) ;(((" " "c" ";"))(""))
    ((("v" ";"))("")) (((" " "v" ";"))(""))
    ((("b" ";"))("")) (((" " "b" ";"))("")) ; ()
    ((("n" ";"))("")) (((" " "n" ";"))(""))
    ((("m" ";"))("")) (((" " "m" ";"))(""))
    ((("," ";"))("")) (((" " "," ";"))("")) ; ʿơ
    ((("." ";"))("")) (((" " "." ";"))(""))
    ((("/" ";"))("")) (((" " "/" ";"))(""))
    ((("1" "z"))("")) (((" " "1" "z"))(""))
    ((("2" "z"))("")) (((" " "2" "z"))(""))
    ((("3" "z"))("")) (((" " "3" "z"))(""))
    ((("4" "z"))("")) (((" " "4" "z"))(""))
    ((("5" "z"))("")) ;(((" " "5" "z"))(""))
    ((("6" "z"))("")) (((" " "6" "z"))("")) ; !
    ((("7" "z"))("")) (((" " "7" "z"))(""))
    ((("8" "z"))("")) (((" " "8" "z"))(""))
    ((("9" "z"))("")) ;(((" " "9" "z"))(""))
    ((("0" "z"))("")) (((" " "0" "z"))(""))
    ((("q" "z"))("")) (((" " "q" "z"))("")) ; հ
    ((("w" "z"))("")) (((" " "w" "z"))("")) ; 錄
    ((("e" "z"))("")) (((" " "e" "z"))(""))
    ((("r" "z"))("")) (((" " "r" "z"))(""))
    ((("t" "z"))("")) (((" " "t" "z"))(""))
    ((("y" "z"))("Ź")) ;(((" " "y" "z"))(""))
    ((("u" "z"))("")) (((" " "u" "z"))(""))
    ((("i" "z"))("Į")) (((" " "i" "z"))(""))
    ((("o" "z"))("")) (((" " "o" "z"))(""))
    ((("p" "z"))("")) (((" " "p" "z"))("˫"))
    ((("a" "z"))("")) ;(((" " "a" "z"))(""))
    ((("s" "z"))("ͧ")) (((" " "s" "z"))("")) ; ami
    ((("d" "z"))("´")) (((" " "d" "z"))(""))
    ((("f" "z"))("")) (((" " "f" "z"))("͵"))
    ((("g" "z"))("")) (((" " "g" "z"))("")) ; ʤ
    ((("h" "z"))("")) (((" " "h" "z"))(""))
    ((("j" "z"))("")) (((" " "j" "z"))("")) ; ɥ饭
    ((("k" "z"))("")) (((" " "k" "z"))(""))
    ((("l" "z"))("")) (((" " "l" "z"))("")) ; 岼դˤȸѤδ
    (((";" "z"))("")) (((" " ";" "z"))("")) ; (饷)1ʸ
    ((("z" "z"))("")) (((" " "z" "z"))(""))
    ((("x" "z"))("")) (((" " "x" "z"))(""))
    ((("c" "z"))("")) ;(((" " "c" "z"))(""))
    ((("v" "z"))("")) (((" " "v" "z"))(""))
    ((("b" "z"))("%")) (((" " "b" "z"))("Ķ")) ; ȥޥ
    ((("n" "z"))("")) (((" " "n" "z"))("±"))
    ((("m" "z"))("ƻ")) (((" " "m" "z"))(""))
    ((("," "z"))("")) (((" " "," "z"))("")) ; ֤פ
    ((("." "z"))("")) (((" " "." "z"))(""))
    ((("/" "z"))("")) (((" " "/" "z"))(""))
    ((("1" "x"))("")) (((" " "1" "x"))(""))
    ((("2" "x"))("ɲ")) (((" " "2" "x"))("ɱ"))
    ((("3" "x"))("")) (((" " "3" "x"))(""))
    ((("4" "x"))("")) (((" " "4" "x"))(""))
    ((("5" "x"))("")) ;(((" " "5" "x"))(""))
    ((("6" "x"))("")) ;(((" " "6" "x"))(""))
    ((("7" "x"))("")) (((" " "7" "x"))(""))
    ((("8" "x"))("")) ;(((" " "8" "x"))(""))
    ((("9" "x"))("")) (((" " "9" "x"))(""))
    ((("0" "x"))("Ȩ")) (((" " "0" "x"))(""))
    ((("q" "x"))("")) (((" " "q" "x"))(""))
    ((("w" "x"))("")) ;(((" " "w" "x"))(""))
    ((("e" "x"))("ˬ")) (((" " "e" "x"))("")) ; ͤ
    ((("r" "x"))("ͻ")) (((" " "r" "x"))(""))
    ((("t" "x"))("")) (((" " "t" "x"))(""))
    ((("y" "x"))("")) (((" " "y" "x"))(""))
    ((("u" "x"))("")) (((" " "u" "x"))(""))
    ((("i" "x"))("")) (((" " "i" "x"))(""))
    ((("o" "x"))("")) (((" " "o" "x"))(""))
    ((("p" "x"))("")) (((" " "p" "x"))("Ʃ"))
    ((("a" "x"))("")) (((" " "a" "x"))(""))
    ((("s" "x"))("")) (((" " "s" "x"))("ɨ")) ; ˢꥢԥɨ
    ((("d" "x"))("")) (((" " "d" "x"))(""))
    ((("f" "x"))("")) (((" " "f" "x"))(""))
    ((("g" "x"))("")) (((" " "g" "x"))("ƥ"))
    ((("h" "x"))("")) (((" " "h" "x"))(""))
    ((("j" "x"))("")) (((" " "j" "x"))("")) ; coward
    ((("k" "x"))("")) (((" " "k" "x"))(""))
    ((("l" "x"))("")) (((" " "l" "x"))(""))
    (((";" "x"))("Ʊ")) (((" " ";" "x"))("˰")) ; Ʊ˰
    ((("z" "x"))("Ƚ")) ;(((" " "z" "x"))(""))
    ((("x" "x"))("")) (((" " "x" "x"))(""))
    ((("c" "x"))("")) (((" " "c" "x"))(""))
    ((("v" "x"))("")) (((" " "v" "x"))(""))
    ((("b" "x"))("")) (((" " "b" "x"))("")) ; give up
    ((("n" "x"))("")) (((" " "n" "x"))(""))
    ((("m" "x"))("")) (((" " "m" "x"))(""))
    ((("," "x"))("")) (((" " "," "x"))(""))
    ((("." "x"))("")) (((" " "." "x"))(""))
    ((("/" "x"))("")) ;(((" " "/" "x"))(""))
    ((("1" "c"))("")) (((" " "1" "c"))(""))
    ((("2" "c"))("")) (((" " "2" "c"))("")) ; 
    ((("3" "c"))("")) (((" " "3" "c"))(""))
    ((("4" "c"))("˴")) (((" " "4" "c"))(""))
    ((("5" "c"))("")) ;(((" " "5" "c"))(""))
    ((("6" "c"))("˼")) (((" " "6" "c"))(""))
    ((("7" "c"))("")) (((" " "7" "c"))(""))
    ((("8" "c"))("")) (((" " "8" "c"))(""))
    ((("9" "c"))("°")) (((" " "9" "c"))(""))
    ((("0" "c"))("")) (((" " "0" "c"))(""))
    ((("q" "c"))("")) (((" " "q" "c"))(""))
    ((("w" "c"))("")) (((" " "w" "c"))(""))
    ((("e" "c"))("λ")) (((" " "e" "c"))("μ")) ; 礦
    ((("r" "c"))("")) ;(((" " "r" "c"))(""))
    ((("t" "c"))("Ǯ")) (((" " "t" "c"))(""))
    ((("y" "c"))("")) (((" " "y" "c"))(""))
    ((("u" "c"))("")) ;(((" " "u" "c"))(""))
    ((("i" "c"))("ϻ")) (((" " "i" "c"))(""))
    ((("o" "c"))("")) (((" " "o" "c"))(""))
    ((("p" "c"))("ư")) (((" " "p" "c"))(""))
    ((("a" "c"))("")) ;(((" " "a" "c"))(""))
    ((("s" "c"))("Ƭ")) (((" " "s" "c"))("˹"))
    ((("d" "c"))("")) (((" " "d" "c"))(""))
    ((("f" "c"))("")) (((" " "f" "c"))(""))
    ((("g" "c"))("")) ;(((" " "g" "c"))(""))
    ((("h" "c"))("")) (((" " "h" "c"))(""))
    ((("j" "c"))("")) (((" " "j" "c"))("Σ"))
    ((("k" "c"))("")) (((" " "k" "c"))(""))
    ((("l" "c"))("")) (((" " "l" "c"))("")) ; ֤
    (((";" "c"))("")) (((" " ";" "c"))(""))
    ((("z" "c"))("")) (((" " "z" "c"))(""))
    ((("x" "c"))("")) (((" " "x" "c"))(""))
    ((("c" "c"))("")) (((" " "c" "c"))(""))
    ((("v" "c"))("")) (((" " "v" "c"))("")) ; Ĥ
    ((("b" "c"))("")) (((" " "b" "c"))(""))
    ((("n" "c"))("")) (((" " "n" "c"))(""))
    ((("m" "c"))("")) (((" " "m" "c"))(""))
    ((("," "c"))("")) (((" " "," "c"))(""))
    ((("." "c"))("")) (((" " "." "c"))(""))
    ((("/" "c"))("")) (((" " "/" "c"))("")) ; С
    ((("1" "v"))("")) (((" " "1" "v"))(""))
    ((("2" "v"))("")) (((" " "2" "v"))(""))
    ((("3" "v"))("")) ;(((" " "3" "v"))(""))
    ((("4" "v"))("")) (((" " "4" "v"))(""))
    ((("5" "v"))("")) (((" " "5" "v"))(""))
    ((("6" "v"))("")) (((" " "6" "v"))(""))
    ((("7" "v"))("")) (((" " "7" "v"))(""))
    ((("8" "v"))("")) (((" " "8" "v"))(""))
    ((("9" "v"))("")) (((" " "9" "v"))(""))
    ((("0" "v"))("Υ")) (((" " "0" "v"))(""))
    ((("q" "v"))("")) (((" " "q" "v"))(""))
    ((("w" "v"))("")) (((" " "w" "v"))(""))
    ((("e" "v"))("")) (((" " "e" "v"))(""))
    ((("r" "v"))("")) (((" " "r" "v"))(""))
    ((("t" "v"))("")) ;(((" " "t" "v"))(""))
    ((("y" "v"))("")) (((" " "y" "v"))(""))
    ((("u" "v"))("")) (((" " "u" "v"))(""))
    ((("i" "v"))("")) (((" " "i" "v"))(""))
    ((("o" "v"))("")) (((" " "o" "v"))("ǣ"))
    ((("p" "v"))("")) (((" " "p" "v"))("ǥ"))
    ((("a" "v"))("")) (((" " "a" "v"))("̻")) ; ळ
    ((("s" "v"))("")) (((" " "s" "v"))(""))
    ((("d" "v"))("")) (((" " "d" "v"))(""))
    ((("f" "v"))("ľ")) (((" " "f" "v"))(""))
    ((("g" "v"))("")) (((" " "g" "v"))(""))
    ((("h" "v"))("")) (((" " "h" "v"))(""))
    ((("j" "v"))("")) (((" " "j" "v"))(""))
    ((("k" "v"))("9")) (((" " "k" "v"))("")) ; 9
    ((("l" "v"))("")) (((" " "l" "v"))("˦"))
    (((";" "v"))("")) (((" " ";" "v"))(""))
    ((("z" "v"))("")) (((" " "z" "v"))("")) ; 
    ((("x" "v"))("")) (((" " "x" "v"))("")) ; 夦
    ((("c" "v"))("")) (((" " "c" "v"))(""))
    ((("v" "v"))("")) (((" " "v" "v"))("ĵ"))
    ((("b" "v"))("")) (((" " "b" "v"))("ȶ"))
    ((("n" "v"))("")) (((" " "n" "v"))("")) ; Ѱ
    ((("m" "v"))("")) (((" " "m" "v"))("ͩ")) ; ͩ
    ((("," "v"))("")) (((" " "," "v"))(""))
    ((("." "v"))("")) (((" " "." "v"))(""))
    ((("/" "v"))("")) (((" " "/" "v"))(""))
    ((("1" "b"))("")) (((" " "1" "b"))(""))
    ((("2" "b"))("")) (((" " "2" "b"))(""))
    ((("3" "b"))("Χ")) ;(((" " "3" "b"))(""))
    ((("4" "b"))("")) (((" " "4" "b"))(""))
    ((("5" "b"))("")) (((" " "5" "b"))("ϳ"))
    ((("6" "b"))("")) (((" " "6" "b"))(""))
    ((("7" "b"))("")) (((" " "7" "b"))(""))
    ((("8" "b"))("")) (((" " "8" "b"))(""))
    ((("9" "b"))("")) (((" " "9" "b"))(""))
    ((("0" "b"))("")) (((" " "0" "b"))(""))
    ((("q" "b"))("²")) ;(((" " "q" "b"))(""))
    ((("w" "b"))("")) (((" " "w" "b"))("ǫ"))
    ((("e" "b"))("̤")) ;(((" " "e" "b"))(""))
    ((("r" "b"))("")) ;(((" " "r" "b"))(""))
    ((("t" "b"))("")) (((" " "t" "b"))("")) ; 
    ((("y" "b"))("")) (((" " "y" "b"))(""))
    ((("u" "b"))("")) (((" " "u" "b"))("")) ; 
    ((("i" "b"))("")) (((" " "i" "b"))(""))
    ((("o" "b"))("")) ;(((" " "o" "b"))(""))
    ((("p" "b"))("")) (((" " "p" "b"))("Ъ"))
    ((("a" "b"))("")) (((" " "a" "b"))(""))
    ((("s" "b"))("")) (((" " "s" "b"))("")) ; 
    ((("d" "b"))("")) (((" " "d" "b"))(""))
    ((("f" "b"))("˾")) (((" " "f" "b"))(""))
    ((("g" "b"))("")) (((" " "g" "b"))("ö"))
    ((("h" "b"))("")) (((" " "h" "b"))("ſ")) ; ſ
    ((("j" "b"))("")) (((" " "j" "b"))(""))
    ((("k" "b"))("")) (((" " "k" "b"))("ɰ"))
    ((("l" "b"))("")) (((" " "l" "b"))("·"))
    (((";" "b"))("")) (((" " ";" "b"))(""))
    ((("z" "b"))("")) (((" " "z" "b"))(""))
    ((("x" "b"))("")) (((" " "x" "b"))("Ĩ"))
    ((("c" "b"))("")) (((" " "c" "b"))("")) ; 
    ((("v" "b"))("ʡ")) (((" " "v" "b"))(""))
    ((("b" "b"))("")) (((" " "b" "b"))(""))
    ((("n" "b"))("")) (((" " "n" "b"))("ʷ")) ; ʷϵ
    ((("m" "b"))("")) (((" " "m" "b"))("")) ; 
    ((("," "b"))("")) (((" " "," "b"))(""))
    ((("." "b"))("")) ;(((" " "." "b"))(""))
    ((("/" "b"))("")) (((" " "/" "b"))("")) ; 
    ((("1" "n"))("")) (((" " "1" "n"))(""))
    ((("2" "n"))("")) (((" " "2" "n"))(""))
    ((("3" "n"))("")) (((" " "3" "n"))(""))
    ((("4" "n"))("")) (((" " "4" "n"))(""))
    ((("5" "n"))("ϯ")) (((" " "5" "n"))(""))
    ((("6" "n"))("")) (((" " "6" "n"))(""))
    ((("7" "n"))("")) (((" " "7" "n"))(""))
    ((("8" "n"))("")) (((" " "8" "n"))(""))
    ((("9" "n"))("")) (((" " "9" "n"))("")) ; Ҿ졦
    ((("0" "n"))("")) ;(((" " "0" "n"))(""))
    ((("q" "n"))("")) (((" " "q" "n"))(""))
    ((("w" "n"))("ģ")) (((" " "w" "n"))("")) ; 
    ((("e" "n"))("")) (((" " "e" "n"))(""))
    ((("r" "n"))("")) (((" " "r" "n"))(""))
    ((("t" "n"))("")) (((" " "t" "n"))("")) ; get
    ((("y" "n"))("")) (((" " "y" "n"))(""))
    ((("u" "n"))("")) (((" " "u" "n"))(""))
    ((("i" "n"))("")) (((" " "i" "n"))(""))
    ((("o" "n"))("")) ;(((" " "o" "n"))(""))
    ((("p" "n"))("")) (((" " "p" "n"))(""))
    ((("a" "n"))("")) (((" " "a" "n"))(""))
    ((("s" "n"))("Ͽ")) (((" " "s" "n"))("Ͻ"))
    ((("d" "n"))("")) (((" " "d" "n"))(""))
    ((("f" "n"))("")) (((" " "f" "n"))(""))
    ((("g" "n"))("")) (((" " "g" "n"))(""))
    ((("h" "n"))("")) (((" " "h" "n"))(""))
    ((("j" "n"))("")) ;(((" " "j" "n"))(""))
    ((("k" "n"))("")) ;(((" " "k" "n"))(""))
    ((("l" "n"))("ɽ")) ;(((" " "l" "n"))(""))
    (((";" "n"))("")) (((" " ";" "n"))(""))
    ((("z" "n"))("")) (((" " "z" "n"))(""))
    ((("x" "n"))("")) (((" " "x" "n"))(""))
    ((("c" "n"))("")) (((" " "c" "n"))(""))
    ((("v" "n"))("")) ;(((" " "v" "n"))(""))
    ((("b" "n"))("")) (((" " "b" "n"))("ϲ"))
    ((("n" "n"))("")) (((" " "n" "n"))(""))
    ((("m" "n"))("")) (((" " "m" "n"))(""))
    ((("," "n"))("")) (((" " "," "n"))(""))
    ((("." "n"))("")) (((" " "." "n"))(""))
    ((("/" "n"))("")) (((" " "/" "n"))(""))
    ((("1" "m"))("")) (((" " "1" "m"))("ɯ"))
    ((("2" "m"))("")) (((" " "2" "m"))(""))
    ((("3" "m"))("")) (((" " "3" "m"))(""))
    ((("4" "m"))("Ǿ")) (((" " "4" "m"))("Ǻ"))
    ((("5" "m"))("Ϸ")) (((" " "5" "m"))("")) ; Ϸ
    ((("6" "m"))("")) (((" " "6" "m"))("")) ; 
    ((("7" "m"))("")) (((" " "7" "m"))(""))
    ((("8" "m"))("«")) (((" " "8" "m"))(""))
    ((("9" "m"))("")) (((" " "9" "m"))("")) ; Ǥ
    ((("0" "m"))("̮")) (((" " "0" "m"))(""))
    ((("q" "m"))("")) (((" " "q" "m"))(""))
    ((("w" "m"))("")) (((" " "w" "m"))(""))
    ((("e" "m"))("")) (((" " "e" "m"))(""))
    ((("r" "m"))("ã")) (((" " "r" "m"))(""))
    ((("t" "m"))("")) (((" " "t" "m"))("")) ; 
    ((("y" "m"))("")) (((" " "y" "m"))(""))
    ((("u" "m"))("˺")) (((" " "u" "m"))(""))
    ((("i" "m"))("Ƥ")) ;(((" " "i" "m"))(""))
    ((("o" "m"))("")) (((" " "o" "m"))(""))
    ((("p" "m"))("")) (((" " "p" "m"))(""))
    ((("a" "m"))("")) (((" " "a" "m"))(""))
    ((("s" "m"))("")) (((" " "s" "m"))("")) ; ߤߤ
    ((("d" "m"))("")) (((" " "d" "m"))(""))
    ((("f" "m"))("")) (((" " "f" "m"))(""))
    ((("g" "m"))("")) ;(((" " "g" "m"))(""))
    ((("h" "m"))("")) (((" " "h" "m"))(""))
    ((("j" "m"))("¿")) (((" " "j" "m"))(""))
    ((("k" "m"))("")) (((" " "k" "m"))(""))
    ((("l" "m"))("")) (((" " "l" "m"))(""))
    (((";" "m"))("")) (((" " ";" "m"))(""))
    ((("z" "m"))("Ƿ")) (((" " "z" "m"))("˳"))
    ((("x" "m"))("")) (((" " "x" "m"))(""))
    ((("c" "m"))("")) (((" " "c" "m"))(""))
    ((("v" "m"))("")) ;(((" " "v" "m"))(""))
    ((("b" "m"))("")) (((" " "b" "m"))(""))
    ((("n" "m"))("")) (((" " "n" "m"))(""))
    ((("m" "m"))("")) ;(((" " "m" "m"))(""))
    ((("," "m"))("")) (((" " "," "m"))("")) ; 餳ޤ
    ((("." "m"))("")) (((" " "." "m"))(""))
    ((("/" "m"))("")) (((" " "/" "m"))(""))
    ((("1" ","))("α")) (((" " "1" ","))("ί"))
    ((("2" ","))("")) (((" " "2" ","))(""))
    ((("3" ","))("")) (((" " "3" ","))("Ħ"))
    ((("4" ","))("Ʀ")) (((" " "4" ","))(""))
    ((("5" ","))("")) (((" " "5" ","))(""))
    ((("6" ","))("")) ;(((" " "6" ","))(""))
    ((("7" ","))("")) (((" " "7" ","))(""))
    ((("8" ","))("¹")) (((" " "8" ","))("½"))
    ((("9" ","))("")) (((" " "9" ","))(""))
    ((("0" ","))("ͦ")) (((" " "0" ","))("ͯ"))
    ((("q" ","))("")) (((" " "q" ","))(""))
    ((("w" ","))("")) (((" " "w" ","))(""))
    ((("e" ","))("")) (((" " "e" ","))(""))
    ((("r" ","))("")) (((" " "r" ","))(""))
    ((("t" ","))("")) (((" " "t" ","))(""))
    ((("y" ","))("")) (((" " "y" ","))(""))
    ((("u" ","))("")) (((" " "u" ","))(""))
    ((("i" ","))("")) (((" " "i" ","))(""))
    ((("o" ","))("")) (((" " "o" ","))(""))
    ((("p" ","))("")) ;(((" " "p" ","))(""))
    ((("a" ","))("")) (((" " "a" ","))(""))
    ((("s" ","))("")) (((" " "s" ","))(""))
    ((("d" ","))("")) (((" " "d" ","))(""))
    ((("f" ","))("")) (((" " "f" ","))(""))
    ((("g" ","))("")) ;(((" " "g" ","))(""))
    ((("h" ","))("Ĵ")) (((" " "h" ","))(""))
    ((("j" ","))("")) (((" " "j" ","))("")) ; ߤ
    ((("k" ","))("")) (((" " "k" ","))("")) ; ݥ
    ((("l" ","))("")) (((" " "l" ","))(""))
    (((";" ","))("")) (((" " ";" ","))("")) ; Ρ֥ߡ
    ((("z" ","))("")) (((" " "z" ","))(""))
    ((("x" ","))("ʧ")) (((" " "x" ","))(""))
    ((("c" ","))("")) (((" " "c" ","))(""))
    ((("v" ","))("")) ;(((" " "v" ","))(""))
    ((("b" ","))("")) (((" " "b" ","))(""))
    ((("n" ","))("")) (((" " "n" ","))(""))
    ((("m" ","))("")) (((" " "m" ","))(""))
    ((("," ","))("")) ;(((" " "," ","))(""))
    ((("." ","))("")) (((" " "." ","))(""))
    ((("/" ","))("")) (((" " "/" ","))(""))
    ((("1" "."))("")) ;(((" " "1" "."))(""))
    ((("2" "."))("")) (((" " "2" "."))(""))
    ((("3" "."))("?")) (((" " "3" "."))(""))
    ((("4" "."))("")) ;(((" " "4" "."))(""))
    ((("5" "."))("")) ;(((" " "5" "."))(""))
    ((("6" "."))("")) (((" " "6" "."))(""))
    ((("7" "."))("")) ;(((" " "7" "."))(""))
    ((("8" "."))("")) (((" " "8" "."))("ĸ"))
    ((("9" "."))("")) (((" " "9" "."))(""))
    ((("0" "."))("")) (((" " "0" "."))(""))
    ((("q" "."))("")) (((" " "q" "."))(""))
    ((("w" "."))("")) (((" " "w" "."))(""))
    ((("e" "."))("")) ;(((" " "e" "."))(""))
    ((("r" "."))("")) (((" " "r" "."))("ܴ")) ; ܴ
    ((("t" "."))("")) (((" " "t" "."))(""))
    ((("y" "."))("")) (((" " "y" "."))("ʤ"))
    ((("u" "."))("")) ;(((" " "u" "."))(""))
    ((("i" "."))("")) (((" " "i" "."))(""))
    ((("o" "."))("")) (((" " "o" "."))("")) ; 桼⥢
    ((("p" "."))("")) (((" " "p" "."))("")) ; 
    ((("a" "."))("")) (((" " "a" "."))("ì")) ; ̡֤פ
    ((("s" "."))("Ÿ")) ;(((" " "s" "."))(""))
    ((("d" "."))("")) (((" " "d" "."))("")) ; ٻ̤
    ((("f" "."))("")) (((" " "f" "."))(""))
    ((("g" "."))("ï")) ;(((" " "g" "."))(""))
    ((("h" "."))("")) ;(((" " "h" "."))(""))
    ((("j" "."))("")) (((" " "j" "."))(""))
    ((("k" "."))("")) ;(((" " "k" "."))(""))
    ((("l" "."))("")) ;(((" " "l" "."))(""))
    (((";" "."))("")) (((" " ";" "."))("ƹ"))
    ((("z" "."))("")) (((" " "z" "."))("")) ; Ȥ
    ((("x" "."))("")) (((" " "x" "."))(""))
    ((("c" "."))("")) ;(((" " "c" "."))(""))
    ((("v" "."))("")) ;(((" " "v" "."))(""))
    ((("b" "."))("ͷ")) (((" " "b" "."))(""))
    ((("n" "."))("")) (((" " "n" "."))(""))
    ((("m" "."))("")) (((" " "m" "."))(""))
    ((("," "."))("")) ;(((" " "," "."))(""))
    ((("." "."))("")) ;(((" " "." "."))(""))
    ((("/" "."))("Ϳ")) (((" " "/" "."))(""))
    ((("1" "/"))("")) ;(((" " "1" "/"))(""))
    ((("2" "/"))("")) (((" " "2" "/"))("ų"))
    ((("3" "/"))("")) (((" " "3" "/"))("Ǵ"))
    ((("4" "/"))("Ȣ")) (((" " "4" "/"))("ê"))
    ((("5" "/"))("")) (((" " "5" "/"))(""))
    ((("6" "/"))("")) (((" " "6" "/"))(""))
    ((("7" "/"))("")) ;(((" " "7" "/"))(""))
    ((("8" "/"))("Ĳ")) (((" " "8" "/"))(""))
    ((("9" "/"))("ʴ")) (((" " "9" "/"))("ʶ"))
    ((("0" "/"))("")) (((" " "0" "/"))(""))
    ((("q" "/"))("")) (((" " "q" "/"))(""))
    ((("w" "/"))("ȴ")) (((" " "w" "/"))(""))
    ((("e" "/"))("")) (((" " "e" "/"))(""))
    ((("r" "/"))("")) (((" " "r" "/"))(""))
    ((("t" "/"))("")) ;(((" " "t" "/"))(""))
    ((("y" "/"))("ô")) (((" " "y" "/"))("â"))
    ((("u" "/"))("Φ")) (((" " "u" "/"))("δ"))
    ((("i" "/"))("")) (((" " "i" "/"))(""))
    ((("o" "/"))("")) ;(((" " "o" "/"))(""))
    ((("p" "/"))("")) (((" " "p" "/"))(""))
    ((("a" "/"))("")) (((" " "a" "/"))(""))
    ((("s" "/"))("")) (((" " "s" "/"))(""))
    ((("d" "/"))("")) (((" " "d" "/"))(""))
    ((("f" "/"))("")) (((" " "f" "/"))("ţ"))
    ((("g" "/"))("Ʋ")) ;(((" " "g" "/"))(""))
    ((("h" "/"))("")) (((" " "h" "/"))(""))
    ((("j" "/"))("")) (((" " "j" "/"))("")) ; 
    ((("k" "/"))("")) (((" " "k" "/"))("")) ; Ⱦʬ
    ((("l" "/"))("")) ;(((" " "l" "/"))(""))
    (((";" "/"))("")) (((" " ";" "/"))(""))
    ((("z" "/"))("")) (((" " "z" "/"))(""))
    ((("x" "/"))("")) ;(((" " "x" "/"))(""))
    ((("c" "/"))("")) (((" " "c" "/"))(""))
    ((("v" "/"))("")) (((" " "v" "/"))(""))
    ((("b" "/"))("ñ")) (((" " "b" "/"))("")) ; ϽŤñ
    ((("n" "/"))("")) (((" " "n" "/"))(""))
    ((("m" "/"))("")) (((" " "m" "/"))("")) ; 
    ((("," "/"))("")) (((" " "," "/"))("")) ; äƳ
    ((("." "/"))("ȿ")) (((" " "." "/"))(""))
    ((("/" "/"))("")) ;(((" " "/" "/"))(""))
    (((" " " "))(" "))))

(define trycode-init-handler
  (lambda (id im arg)
    (generic-context-new id im trycode-rule #f)))

(generic-register-im
 'trycode
 "ja"
 "EUC-JP"
 (N_ "Try-Code")
 (N_ "A kanji direct input method")
 trycode-init-handler)
