// The original version of this code (revision 2 of the Subversion
// archive) was released subject to the following license:

//   Copyright (c) 2006, Sun Microsystems, Inc.  All rights reserved.
//   Redistribution and use in source and binary forms, with or
//   without modification, are permitted provided that the following
//   conditions are met:

//   * Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above
//     copyright notice, this list of conditions and the following
//     disclaimer in the documentation and/or other materials provided
//     with the distribution.
//   * Neither the name of Sun Microsystems or the names of
//     contributors may be used to endorse or promote products derived
//     from this software without specific prior written permission.
 
//   THIS SOFTWARE IS PROVIDED BY SUN AND ITS LICENSORS ``AS IS'' AND
//   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
//   THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//   PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SUN OR ITS
//   LICENSORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
//   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
//   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
//   USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
//   AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
//   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
//   ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
//   POSSIBILITY OF SUCH DAMAGE.

// Subsequent additions and modifications are Copyright (c) 2006 David
// Carlton, and may be used subject to the same conditions.

#include "config.h"

#include <iosfwd>
#include <setjmp.h>
#include <signal.h>

#ifdef HAVE_EXECINFO_H
#include <execinfo.h>
#endif

namespace UnitTest {

  namespace Private {

    // A helper class for managing signal handlers.  Use it as follows:
    //
    // {
    //   const char *volatile signalled = 0;
    //   SigHandler handler;
    //   sigjmp_buf jumpBuf;

    //   if (sigsetjmp(jumpBuf, 1) == 0) {
    //     handler.setUp(&jumpBuf);

    //     // Do whatever you wanted to do in normal case;
    //   } else {
    //     signalled = handler.sigName();
    //   }

    //   // Code here can see if a signal was thrown by looking at the
    //   // value of 'signalled': if it's 0, then there was no signal,
    //   // otherwise it contains the name of the signal that was
    //   // caught.
    // }

    class SigHandler {
    public:
      explicit SigHandler(std::ostream *stream);
      ~SigHandler();

      void setUp(sigjmp_buf *buf);

      // Return the name of the last signal.
      const char *sigName() const;

    private:
      static void handler(int signum);

      static void dumpStack();

      static SigHandler *handler_;

      std::ostream *stream_;
      SigHandler *oldHandler_;
      sigjmp_buf *jumpBuf_;
      struct sigaction oldSegvAction_;
      struct sigaction oldFpeAction_;
      struct sigaction oldAbrtAction_;
      int sigNum_;
    };

  }

}
