// The original version of this code (revision 2 of the Subversion
// archive) was released subject to the following license:

//   Copyright (c) 2006, Sun Microsystems, Inc.  All rights reserved.
//   Redistribution and use in source and binary forms, with or
//   without modification, are permitted provided that the following
//   conditions are met:

//   * Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above
//     copyright notice, this list of conditions and the following
//     disclaimer in the documentation and/or other materials provided
//     with the distribution.
//   * Neither the name of Sun Microsystems or the names of
//     contributors may be used to endorse or promote products derived
//     from this software without specific prior written permission.
 
//   THIS SOFTWARE IS PROVIDED BY SUN AND ITS LICENSORS ``AS IS'' AND
//   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
//   THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//   PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SUN OR ITS
//   LICENSORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
//   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
//   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
//   USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
//   AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
//   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
//   ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
//   POSSIBILITY OF SUCH DAMAGE.

// Subsequent additions and modifications are Copyright (c) 2006 David
// Carlton, and may be used subject to the same conditions.

#include <ExistingBase.hpp>

#include <UnitTest.hpp>

#include <memory>

#include "unittesttest.hpp"

namespace ExistingBaseTest {

  using namespace UnitTest;

  class Obj : public ExistingObject<Obj> {};

  class Count : public ExistingBase<Obj> {
  public:
    void run() {
      ASSERT_EQUALS(0, existing());

      Obj a;
      ASSERT_EQUALS(1, existing());

      {
	Obj b;
	ASSERT_EQUALS(2, existing());

	Obj c(b);
	ASSERT_EQUALS(3, existing());
      }

      ASSERT_EQUALS(1, existing());
    }
  };

  class Destructor {
  public:
    ~Destructor() {
      obj_.reset();
    }

    void run() {
      std::ostringstream oss;

      Suite suite;
      suite.stream(oss);
      suite.add<Test>();
      suite.run();

      ASSERT_EQUALS(1, suite.failures());
    }

  private:
    class Test : public ExistingBase<Obj> {
    public:
      void run() {
	obj_.reset(new Obj());
      }
    };

    static std::auto_ptr<Obj> obj_;
  };

  std::auto_ptr<Obj> Destructor::obj_;

  class All : public Suite {
  public:
    All() {
      add<Count>();
      add<Destructor>();
    }
  };

}

UnitTest::TestPtr existingBaseTests() {
  return UnitTest::createSuite<ExistingBaseTest::All>();
}
