/* Analog VU meter plugin for xmms
 *
 * Copyright (C) 2002 Pekka Harjamki <analogvu@mcfish.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#include <math.h>
#include <stdio.h> 
#include <stdlib.h> 
#include <string.h> 
#include <sys/time.h>
#include <pthread.h>
 
#include <xmms/util.h>

#include "vumeter.h"

/*
 * Define external variables
 */

extern gint 		worker_running;
extern gint16 		shared_pcm_data[2][512];
extern GdkPixmap 	*doublebuf;
extern GtkWidget 	*area;
extern struct 		vumeter_cfg_info vumeter_cfg;
extern float		left_needle_power[max_avarage_samples],
			right_needle_power[max_avarage_samples];

/*
 * Worker thread
 */

void *vumeter_worker(void *arg)
{
 int c,a=0,b=0;
 float max=32767.0,best_value[2]={0.0,0.0},ltmp=0.0,rtmp=0.0;
 struct timezone tz;
 struct timeval tv_cur,tv_past;
 long delay_value;

 // Set initial value
 gettimeofday(&tv_past,&tz);

 // Start thread loop
 while(worker_running>0)
 {
  do
  {
   // Test to see, if thread should shutdown
   if(worker_running==0) 
   {
    pthread_exit(NULL);
   }

   // Do we have new data packet waiting?
   if(worker_running==2)
   {
    // Reset values
    best_value[0]=0.0;
    best_value[1]=0.0;

    // Lock gdk, so that values don't change while we are reading them
    gdk_threads_enter();

    a=vumeter_cfg.accuracy+1;
    b=vumeter_cfg.av_samples;

    // Process sound data
    for(c=0; c<512; c+=a)
    {
     if( abs( (float)shared_pcm_data[0][c] > best_value[0]) ) 
      best_value[0]=(float)abs(shared_pcm_data[0][c]);

     if( abs( (float)shared_pcm_data[1][c] > best_value[1]) ) 
      best_value[1]=(float)abs(shared_pcm_data[1][c]);
    }

    gdk_threads_leave();


    ltmp=sqrt((best_value[0]/max))*180.0;
    rtmp=sqrt((best_value[1]/max))*180.0;

    for(c=b; c>=1; c--) 
    {
     left_needle_power[c]=left_needle_power[c-1];
     right_needle_power[c]=right_needle_power[c-1];
    }

    left_needle_power[0]=ltmp;
    right_needle_power[0]=rtmp;

    // Reset value
    if(worker_running==2) worker_running=1;

   } // endIF

   xmms_usleep(1000);

   gettimeofday(&tv_cur,&tz);
   delay_value=(tv_cur.tv_sec-tv_past.tv_sec)*10000000+(tv_cur.tv_usec-tv_past.tv_usec);

  } while( delay_value < 18000 );


  gdk_threads_enter();
 	 gettimeofday(&tv_past,&tz);
	 if(doublebuf!=NULL && area!=NULL) gtk_widget_draw(area,NULL);
  gdk_threads_leave();

 } // endWHILE (worker_running>0)

 pthread_exit(NULL);
}       
