/***************************************************************************
@author:    Fabian Wuertz <xadras@sidux.com>
@copyright: Fabian Wuertz <xadras@sidux.com>
@license:   GPL2, GPL3

@project:   Waheela
@file:      background.cpp    
***************************************************************************/


#include "background.h"


#include <KColorDialog>
#include <klocale.h>
#include <KPageDialog>
#include <QDesktopWidget>
#include <QApplication>
#include <KStandardDirs>


Background::Background (QWidget* parent, Qt::WFlags flags): QWidget (parent, flags)
{  
	show();
	setAutoFillBackground(true);
	
	QDesktopWidget* desktopWidget = QApplication::desktop();
	screensize = desktopWidget->screenGeometry();
}


void Background::setBackground(QString theme) {
	QString currentWallpaper;
	QStringList wallpapers = KGlobal::dirs()->findAllResources("wallpaper", theme+"/contents/images/");
	if( wallpapers.count() == 0 ) {
		return;
	}
	
	QStringListIterator wallpapersIterator(wallpapers);
	bool done = FALSE;
	while (wallpapersIterator.hasNext() and !done) {
		QString wallpaper =  wallpapersIterator.next();
		if( wallpaper.contains(QString::number(screensize.width())+"x"+QString::number(screensize.height())) ) {
			currentWallpaper = wallpaper;
			done = TRUE;
		}
	}
	if(!done) {
		int i = wallpapers.count()-1;
		while(i >= 0 and !done) {
			QStringList tmpList = wallpapers[i].split("/");
			tmpList = tmpList[tmpList.count()-1].split(".");
			int wallpaperWidth = 0, wallpaperHeight = 0;
			QString test;
			if( tmpList.count() > 0 ) {
				tmpList = tmpList[0].split("x");
				wallpaperWidth = tmpList[0].toInt();
				wallpaperHeight = tmpList[1].toInt();
			}
		  
			int screenRatio = 100*screensize.width()/screensize.height();
			int wallpaperRatio = 100*wallpaperWidth / wallpaperHeight;
			
			if(screenRatio == wallpaperRatio) {
				currentWallpaper =  wallpapers[i];
				done = TRUE;
			}
			i--;
		}
		
	if(!done) {
		currentWallpaper =  wallpapers[wallpapers.count()-1];
	}
		
	}



	// set wallpaper
	QPalette p = palette();
	QPixmap pixmap(currentWallpaper);
	QSize size(screensize.width() , screensize.height());
	QPixmap pixmap1(pixmap.scaled(size));
	p.setBrush(QPalette::Background,  pixmap1);
	setPalette(p);
}
