class ControlWidget < Qt::StackedWidget

  slots :show_start_page,
        :show_gallery_page,
        :show_photo_page,
        :show_video_page,
        :show_settings_page

  def initialize(parent = nil)
    super(parent)

    @start_page = StartPage.new
    add_widget @start_page
    show_start_page

    @gallery_page = GalleryPage.new
    add_widget @gallery_page

    @photo_page = PhotoPage.new
    add_widget @photo_page

    @video_page = VideoPage.new
    add_widget @video_page

    @settings_page = SettingsPage.new
    add_widget @settings_page
  end

  def show_start_page
    set_current_widget @start_page
  end

  def show_gallery_page
    set_current_widget @gallery_page
  end

  def show_photo_page
    set_current_widget @photo_page
  end

  def show_video_page
    set_current_widget @video_page
  end

  def show_settings_page
    set_current_widget @settings_page
  end

end
