class PreviewWidget < Qt::Widget

  def initialize(parent = nil)
    super(parent)

    webcam_view = ViewWidgetFactory.create

    no_wc_widget = Qt::Widget.new do
      set_layout( Qt::HBoxLayout.new do
        no_margins
        add_stretch
        add_widget Qt::Label.new{ set_pixmap $webkam_app.pixmap(:warning) }
        add_widget Qt::Label.new(large_font('Webcam not found!'))
        add_stretch
    end ) end

    stacked_layout = Qt::StackedLayout.new do
      add_widget webcam_view
      add_widget no_wc_widget
    end

    layout = Qt::VBoxLayout.new do
      add_layout stacked_layout
      add_spacing 5
      add_widget LogoWidget.new
    end

    if $dev_pool.webcam?
      stacked_layout.set_current_widget webcam_view
    else
      stacked_layout.set_current_widget no_wc_widget
      $dev_pool.connect(SIGNAL :webcam_added) do
        stacked_layout.set_current_widget webcam_view
        WebcamVideoStream.instance.play
      end
    end

    set_layout layout
  end
  
end

class LogoWidget < Qt::Widget
  def initialize(parent = nil)
    super(parent)

    webkam_pixmap = Qt::Label.new{set_pixmap $webkam_app.pixmap(:webkam)}
    webkam_pixmap.install_event_filter self

    app_name_text = Qt::Label.new(large_font($webkam_app.name))
    app_name_text.install_event_filter self

    version_text = Qt::Label.new(small_font('version' + ' ' + $webkam_app.version))
    version_text.install_event_filter self

    layout = Qt::HBoxLayout.new do
      no_margins
      no_spaces
      add_stretch
      add_widget webkam_pixmap
      add_layout( Qt::VBoxLayout.new do
        no_margins
        no_spaces
        add_widget app_name_text
        add_widget version_text
    end ) end

    set_layout layout
  end

  def eventFilter(obj, event)
    if event.type == Qt::Event::MouseButtonPress
      Qt::DesktopServices::open_url Qt::Url.new($webkam_app.website)
      true
    else false end
  end

end

