class SettingsPage < ControlPage

  def initialize(parent = nil)
    super(parent)

    @device_cmbb = Qt::ComboBox.new {enabled_when_webcam_present}

    device_label = Qt::Label.new('Webcam Device:') { |l| l.set_buddy  @device_cmbb}

    @resolution_cmbb = Qt::ComboBox.new { enabled_when_webcam_present }

    resolution_label = Qt::Label.new('Webcam Resolution:') { |l| l.set_buddy  @resolution_cmbb}

    webcam_layout = Qt::GridLayout.new do |l|
      l.no_spaces
      l.no_margins
      l.set_column_stretch(0, 1)
      l.add_widget(device_label, 0, 1, Qt::AlignRight)
      l.add_widget(@device_cmbb, 0, 2)
      l.add_widget(resolution_label, 1, 1, Qt::AlignRight)
      l.add_widget(@resolution_cmbb, 1, 2)
      l.set_column_stretch(3, 1)
    end

    $dev_pool.connect(SIGNAL :webcam_added) { populate_cmbbs }

    @accel_video_ckb = Qt::CheckBox.new do
      set_checked($settings.accelerate_video_render)      
      enabled_when_webcam_present
    end
    @accel_video_ckb.connect(SIGNAL('stateChanged(int)')){ accel_video_changed}

    @flash_ckb = Qt::CheckBox.new { set_checked($settings.flash) }
    @flash_ckb.connect(SIGNAL('stateChanged(int)')){ flash_changed }

    @video_path_le = Qt::LineEdit.new do
      set_text $settings.video_path
      set_read_only true
    end
    @video_path_le.connect(SIGNAL('textChanged(QString)')){video_path_changed}

    @photo_path_le = Qt::LineEdit.new do
      set_text $settings.photo_path
      set_read_only true
    end
    @photo_path_le.connect(SIGNAL('textChanged(QString)')){photo_path_changed}

    add_group('Webcam Settings', :webcam_small) do |g|
      g.add_layout webcam_layout
    end

    accel_video = labeled_widget('Accelerated Video Rendering', @accel_video_ckb, false, true)
    flash = labeled_widget("Flash Effect", @flash_ckb, false, true)
    
    add_group('Display Settings', :display_small) do |g|
      g.add_widget accel_video
      g.add_widget flash
    end

    add_group('Directories', :folder_small, false) do |g|
      g.add_widget select_directory_widget(:photo_small, @photo_path_le, "Photo")
  #    g.add_widget select_directory_widget(:video_small, @video_path_le, "Video")
    end

    add_stretch
  end

  def select_directory_widget(icon, line_edit, text)
    Qt::Widget.new do set_layout( Qt::HBoxLayout.new do
      set_contents_margins(0, 0, 0, 0)
      add_widget Qt::Label.new(text + ':')
      add_widget line_edit
      add_widget( Qt::PushButton.new($webkam_app.icon(icon), '') do
        connect(SIGNAL :clicked) do
          dir = Qt::FileDialog.get_existing_directory(self, text + ' ' + 'Directory', line_edit.text,
                Qt::FileDialog::ShowDirsOnly | Qt::FileDialog::DontResolveSymlinks )

          line_edit.text = dir if dir
  end end ) end ) end end

  def resolution_changed
    res = @resolution_cmbb.item_data(@resolution_cmbb.current_index).to_size
    webcam = $settings.webcam
    webcam['resolution'] = [res.width, res.height]
    
    $settings.set_webcam(webcam)

    stream = WebcamVideoStream.instance
    stream.set_resolution(webcam['resolution'])
    stream.play
  end

  def device_changed
    dev = @device_cmbb.item_data(@device_cmbb.current_index).to_string
     WebcamVideoStream.destroy
    stream = WebcamVideoStream.instance(dev)

    webcam = {'device' => dev, 'resolution' => stream.resolution}
    $settings.set_webcam(webcam)

    stream.play

    populate_resolution_cmbb
  end

  def accel_video_changed
    $settings.set_accelerate_video_render(@accel_video_ckb.is_checked)
    WebcamVideoStream.destroy
    WebcamVideoStream.instance($settings.webcam['device']).play
  end

  def photo_path_changed
    $settings.set_photo_path(@photo_path_le.text)
  end

  def video_path_changed
    $settings.set_video_path(@video_path_le.text)
  end

  def populate_device_cmbb
    @device_cmbb.disconnect(SIGNAL('currentIndexChanged(int)'))

    @device_cmbb.clear
    $dev_pool.webcams.each do |wc|
      @device_cmbb.add_item(wc[1], Qt::Variant.new(wc[0]))
    end

    index = @device_cmbb.find_data(Qt::Variant.new($settings.webcam['device']))
    @device_cmbb.set_current_index(index)

    @device_cmbb.connect(SIGNAL('currentIndexChanged(int)')){ device_changed }
  end

  def populate_resolution_cmbb
    @resolution_cmbb.disconnect(SIGNAL('currentIndexChanged(int)'))

    stream = WebcamVideoStream.instance

    @resolution_cmbb.clear
    stream.resolutions.each do |res|
      width, height = *res
      @resolution_cmbb.add_item(width.to_s + 'x' + height.to_s, Qt::Variant.new(Qt::Size.new(width, height)))
    end

    res = stream.resolution
    width, height = *res

    @resolution_cmbb.set_current_index(@resolution_cmbb.find_data(Qt::Variant.new(Qt::Size.new(width, height))))

    @resolution_cmbb.connect(SIGNAL('currentIndexChanged(int)')){resolution_changed}
  end

  def flash_changed
    $settings.set_flash(@flash_ckb.is_checked)
  end

  def showEvent(event)
    return unless $dev_pool.webcam?

    populate_device_cmbb
    populate_resolution_cmbb
  end

end

