#include "wimexim.h"
#include <string.h>
#include <stdlib.h>

typedef struct{
    XimHeader	h;
    uint16_t	imid;
    uint16_t	sz;
    Attribute attr[];
}__attribute__((packed)) XimGetImValuesReply;

int get_input_styles(char* base,char** a,uint16_t* idlist,int idlen);

Attrs_t ImAttrs[]={
    {ATTR_TYPE_STYLES,XNQueryInputStyle,IM_INPUT_STYLE,0,get_input_styles,NULL},
    {0,NULL,0,0,NULL,NULL}
};

void dbg_get_im_vals(XimGetImValues* pkt)
{
    Array a;
    ArNew(&a,1,NULL);
    for(int n=0; n<pkt->sz/2; ++n)
	ArPrint(&a,"[%hd]",pkt->id[n]);
    MSG("im-id=%hd id=%s\n",pkt->imid,ArAdr(&a));
    ArDelete(&a);
}

/*
  ic.cΥԡImAttrsIcAttrs㤦ʤ,Τ˹˰䤹
*/
int get_im_values(char* base,char** buf,uint16_t* idlist,int idlen)
{
    int used,used_all=0;
    while(idlen>0 && *idlist!=IC_SEP){
	used = ImAttrs[*idlist].Getter(base,buf,idlist,idlen);
	idlist += used;
	idlen -= used;
	used_all += used;
    }
    return used_all;
}

int GetImValues(Display* disp,WxContext* cx,XimGetImValues* pkt)
{
    VERBOSE(dbg_get_im_vals(pkt));

    char *abuf;
    int bufsize,idlen = pkt->sz/2;

    //ǡ礭׻
    abuf = (char*)sizeof(XimGetImValuesReply);
    get_im_values(NULL,&abuf,pkt->id,idlen);
    bufsize = (int)abuf;

    //ºݤ˥ǡ
    char buf[bufsize];
    XimGetImValuesReply *r = (typeof(r))buf;
    abuf = (char*) r->attr;
    get_im_values(abuf/*NULLʳ*/,&abuf,pkt->id,idlen);

    r->imid = pkt->imid;
    r->sz = bufsize - sizeof(*r);

    send_n(disp,cx->Client,XIM_GET_IM_VALUES_REPLY,buf,bufsize);
    return 0;
}

//ϥΰ֤
int get_input_styles(char* base,char** a,uint16_t* idlist,int idlen UNUSED)
{
    static uint32_t styles[]={
	XIMPreeditPosition|XIMStatusNothing,
	XIMPreeditPosition|XIMStatusNone,
	XIMPreeditPosition|XIMStatusArea,
	XIMPreeditCallbacks|XIMStatusNothing,
	XIMPreeditCallbacks|XIMStatusNone,
	XIMPreeditCallbacks|XIMStatusArea,
	XIMPreeditArea|XIMStatusNothing,
	XIMPreeditArea|XIMStatusNone,
	XIMPreeditArea|XIMStatusArea,
	XIMPreeditNothing|XIMStatusNothing,
	XIMPreeditNothing|XIMStatusNone,
	XIMPreeditNothing|XIMStatusArea,
    };

    //padɬפʤ
    if(base != NULL){
	Attribute *at = (Attribute*)*a;
	Styles *s = (Styles*)(at->value);
	at->id = *idlist;
	at->sz = sizeof(Styles)+sizeof(styles);
	s->count = ITEMS(styles);
	memcpy(s->styles,styles,sizeof(styles));
    }
    *a += sizeof(Attribute)+sizeof(Styles)+sizeof(styles);
    return 1;
}
