#include "wimexim.h"
#include "wimeapi.h"

void preedit_area_pos(Display* disp,Window cl,const IcData* icp);

//ConfigureNotifyȤ
//StructureNotifyMask򥻥åȤɥ֤
static Window target_window(const IcData* ic)
{
    return ic->Attrs.ClientWindow;
}
//ư
static void move_wime(Display* disp,const IcData* ic,int x UNUSED,int y UNUSED)
{
    preedit_area_pos(disp,MoveWineWindow(disp,ic),ic);
}
    
static int open_ime(CallbackParam* p,bool st)
{
    WimeEnableIme(p->Ic->WimeCxn,st,true,true);
    return 0;
}

static void init(CallbackParam* p)
{
    XSelectInput(p->Disp,p->Ic->Attrs.ClientWindow,StructureNotifyMask);
    SetCompFont(p->Ic);
    move_wime(p->Disp,p->Ic,0,0);
}

static int done_preedit(CallbackParam* p UNUSED)
{
    return 0;
}

//ime˽ʤä̵뤹
static bool reject_key(CallbackParam* p UNUSED)
{
    return false;
}

//ѴɥXNAreaǻꤵ줿˰ư
void preedit_area_pos(Display* disp,Window cl,const IcData* icp)
{
    XRectangle rect;

    /* Preedit-AttributeAreaʤcl礭X롣
       off-the-spotXNAreaʤȤϤΤ*/
    if(TEST2(icp->Attrs.Defined,IC_PREEDIT_ATTR,IC_AREA)){
	LOG("	area size = preedit-area\n");
	rect = icp->Attrs.Preedit.Cmn.Area;
    }else{
	LOG("	area size = XGetWindowAttributes()\n");
	XWindowAttributes at;
	XGetWindowAttributes(disp,cl,&at);
	rect.x = rect.y = 0;
	rect.width = at.width;
	rect.height = at.height;
    }
    /*???
      ʤWIME_POS_RECTǤѴɥɽʤʤΤ
      WIME_POS_POINTǰ֤Τ߻ꤷǥåԥ󥰤Ȥ롣
      width,heightȤäƤʤΤǾifʸelseϸǤϰ̣ʤ
      ͳʬäȤΤ˻ĤƤ
    */
    WimeSetCompWin(icp->WimeCxn,WIME_POS_POINT,rect.x,rect.y);
    LOG("\tpreedit area (%d,%d) %dx%d\n",rect.x,rect.y,rect.width,rect.height);
}

ConvCallbackFuncs ConvFuncOffTheSpot = {
    .OpenIme =		open_ime,
    .Done =		done_preedit,
    .Draw =		ConvDoNothing,
    .RejectKey =	reject_key,
    .Cleanup =		ConvDoNothing,
    .SetSpotLoc =	ConvDoNothing,
    .Init =		init,
    .TargetWindow =	target_window,
    .MoveWime =		move_wime,
};
