#include "wimexim.h"
#include "wimeapi.h"
#include <string.h>
#include <stdlib.h>

/*
  XIM_PREEDIT_STARTΤʸϤ줿Ȥˤ褦Ȼפä
  XIM_PREEDIT_STARTäXIM_PREEDIT_START_REPLYɬפ롣
  ߤι¤Ǥϥ٥Ȥ뤿˥ᥤ롼פʤФʤʤ
  ΤᤳδؿXIM_PREEDIT_START뤳Ȥˤ롣
  ʸ³Ϥ硢XIM_PREEDIT_DONE,XIM_PREEDIT_START³뤳Ȥˤ롣
  ѴϾ֤ˤʤäƤ櫓ǡҤȤĤäꤷʤǤϤϤ᤿XIM_PREEDIT_START,ϤäXIM_PREEDIT_DONEˤϤƤ饤٥Ȥä쥹ݥ󥹤ʤ뤫
  ⤽⥫֤ʤɤξǤʤΤǡ䥦ɥŬڤʾɽ뤳ȤǤʤon-the-spotФϿͤʤȤˤ롣
*/

typedef struct{
    XimHeader	h;
    uint16_t	imid;
    uint16_t	icid;
    int32_t	caret;
    int32_t	chg_first;
    int32_t	chg_length;
    int32_t	status;
    int16_t	str_len;
    char	str[0];
    //		pad(2+len)
}__attribute__((packed)) XimPreeditDraw1;

typedef struct{
    int16_t	feedback_len;
    int16_t	dum;
    int32_t	feedback[0];
}__attribute__((packed)) XimPreeditDraw2;

#define PREEDIT_DRAW_NO_STR	1
#define PREEDIT_DRAW_NO_FB	2

static int open_ime(CallbackParam* p,bool st)
{
    int code,sync;
    if(st){
	code = XIM_PREEDIT_START;
	sync = XIM_PREEDIT_START_REPLY;
    }else{
	code = XIM_PREEDIT_DONE;
	sync = 0;
    }
    WimeEnableIme(p->Ic->WimeCxn,st,true,false);
    send_ww(p->Disp,p->Client,code,p->Pkt->imid,p->Pkt->icid);
    return sync;
}

static void draw(CallbackParam* p)
{
    XimPreeditDraw1 *d1;
    XimPreeditDraw2 *d2;
    WimeCompStrInfo si;
    int d1size,pktsize,ctlen,x;
    char *ej,*ct;

    ej = WimeGetCompStr(p->Ic->WimeCxn,&si);
    LOG("%d %d %d %d %d %s\n",si.CursorPos,si.DeltaStart,si.TargetClause,si.TargetClLen,si.Length,ej);

    if(ej!=NULL){
	ct = EucjpToCtext(ej);
	ctlen = strlen(ct);
    }else{
	ct = NULL;
	ctlen = 0;
    }
    d1size = sizeof(*d1)+ctlen+Pad(2+ctlen);
    pktsize = d1size+sizeof(*d2)+si.Length*sizeof(d2->feedback[0]);

    d1 = malloc(pktsize);
    d2 = (XimPreeditDraw2*)((char*)d1 + d1size);
    d1->imid = p->Pkt->imid;
    d1->icid = p->Pkt->icid;
    d1->caret = si.CursorPos;
    d1->chg_first = 0;

    //ԽХåեˤ
    if(p->Ic->PreeditLen > 0){
	d1->chg_length = p->Ic->PreeditLen;
	d1->status = PREEDIT_DRAW_NO_STR|PREEDIT_DRAW_NO_FB;
	send_n(p->Disp,p->Client,XIM_PREEDIT_DRAW,d1,pktsize);
    }

    if(ej != NULL){
	//ХåեΤ֤
	d1->chg_length = 0; //si.Length;	
	d1->status = 0;
	memcpy(d1->str,ct,d1->str_len=ctlen);
    
	d2->feedback_len = sizeof(d2->feedback[0])*si.Length;
	for(x=0; x<si.Length; ++x)
	    d2->feedback[x]=XIMUnderline;
	if(si.TargetClause != -1){
	    for(x=0; x<si.TargetClLen; ++x)
		d2->feedback[si.TargetClause+x] = XIMReverse;
	}
	send_n(p->Disp,p->Client,XIM_PREEDIT_DRAW,d1,pktsize);

	p->Ic->PreeditLen = si.Length;

	free(ej);
    }
    free(ct);
    free(d1);
}

static int done_preedit(CallbackParam* p)
{
    if(p->Ic->PreeditLen > 0){
	/* ooǤԽʸõʤФcommitŤϤƤޤ
	   leafpadǤʤ*/
	int bufsize = sizeof(XimPreeditDraw1)+Pad(2)+sizeof(XimPreeditDraw2);
	char buf[bufsize];
	XimPreeditDraw1 *d1 = memset(buf,0,bufsize);
	d1->imid = p->Pkt->imid;
	d1->icid = p->Pkt->icid;
	d1->chg_length = p->Ic->PreeditLen;
	d1->status = PREEDIT_DRAW_NO_STR|PREEDIT_DRAW_NO_FB;
	send_n(p->Disp,p->Client,XIM_PREEDIT_DRAW,d1,bufsize);
    }
    p->Ic->PreeditLen = 0;
    send_ww(p->Disp,p->Client,XIM_PREEDIT_DONE,p->Pkt->imid,p->Pkt->icid);
    send_ww(p->Disp,p->Client,XIM_PREEDIT_START,p->Pkt->imid,p->Pkt->icid);
    return XIM_PREEDIT_START_REPLY;
}

static bool reject_key(CallbackParam* p UNUSED)
{
    /*
      ԽΤȤXIM_FORWARD_EVENT֤bad protocolˤʤäƤޤ
      gtkΤȤ 򤱤뤿ˡԽʸ󤬤ʤȤ֤
    */
    WimeCompStrInfo si;
    char *cmp = WimeGetCompStr(p->Ic->WimeCxn,&si);
    bool st = (cmp==NULL);
    free(cmp);
    return st;
}

static void init(CallbackParam* p)
{
    /*!!!
      ֤Ǥʤ򺸾ˤƤ
      礭ϤΤޤޤˤƤҤäȤ鸵礭Ƹ䥦ɥ
      ɽʤ⤷ʤ
    */
    WimeMoveShadowWin(p->Ic->WimeCxn,0,0,-1,-1);
}

ConvCallbackFuncs ConvFuncOnTheSpot = {
    .OpenIme =		open_ime,
    .Done =		done_preedit,
    .Draw =		draw,
    .RejectKey =	reject_key,
    .Cleanup =		ConvDoNothing,
    .SetSpotLoc =	ConvDoNothing,
    .Init =		init,
    .TargetWindow =	ConvDoNothing,
    .MoveWime =		ConvDoNothing,
};
