#ifndef WIME_WIMEXIM_H
#define WIME_WIMEXIM_H

#include <X11/Xlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <stdbool.h>
#include "array.h"
#include "x.h"
#include "ut.h"
#include "wimelog.h"

#if 0
#undef LOG
#undef MSG
#define LOG ERR
#define MSG ERR
#endif

#define PACKET_MAX_SIZE MEMBERSIZE(XEvent,xclient.data.b)
#define FLG(x) (1<<(x))
#define TEST2(v,x,y) (((v) & (FLG(x)|FLG(y)))==(FLG(x)|(FLG(y))))

//im°ֹ(ӥåȰ֤ȤƤȤ
enum{
    IM_INPUT_STYLE,
};

//ic°ֹ(ӥåȰ֤ȤƤȤ
enum{
    IC_INPUT_STYLE,
    IC_CLIENT_WINDOW,
    IC_FOCUS_WINDOW,
    IC_FILTER_EVENTS,
    IC_STRING_CONV,
    IC_RESET_STATE,
    IC_HOTKEY_STATE,
    IC_PREEDIT_ATTR,
    IC_STATUS_ATTR,

    IC_AREA,
    IC_AREA_NEEDED,
    IC_COLOR_MAP,
    IC_FG,
    IC_BG,
    IC_BG_PIXMAP,
    IC_FONTSET,
    IC_LINE_SPACE,
    IC_CURSOR,

    IC_SPOT_LOC,
    IC_STATE,

    IC_SEP
};

//PreeditAttrStatusAttrζ̹
typedef struct{
    XRectangle	Area;
    XRectangle	AreaNeeded;
    Colormap	ColorMap;
    unsigned	Foreground;
    unsigned	Background;
    Pixmap	BgPixmap;
    char*	FontSet;
    unsigned	LineSpace;
    Cursor	CursorId;
} CommonAttr;

typedef struct{
    CommonAttr	Cmn;
    XPoint	SpotLocation;
    unsigned	State;
} PreeditAttr;

typedef struct{
    CommonAttr	Cmn;
} StatusAttr;

typedef struct{
    unsigned		Defined;
    unsigned		InputStyle;
    Window		ClientWindow;
    Window		FocusWindow;
    unsigned		FilterEvents;
    XIMStringConversionText StrConv;
    XIMResetState	ResetState;
    XIMHotKeyTriggers	Hotkey;
    XIMHotKeyState	HotkeyState;
    PreeditAttr		Preedit;
    StatusAttr		StatusArea;
} IcAttributes;

typedef struct IcData_s IcData;

//ˡ
typedef struct{
    IcData *Ic;
    Display *Disp;
    Window Client;
    const XimImIc* Pkt;
} CallbackParam;

typedef struct{
    void (*Init)(CallbackParam*);
    int (*OpenIme)(CallbackParam* p,bool);
    int (*Done)(CallbackParam*);
    void (*Draw)(CallbackParam*);
    bool (*RejectKey)(CallbackParam*); //trueʤ饭򥯥饤Ȥ֤
    void (*Cleanup)(CallbackParam*); //DestroyIcǸƤӤ
    void (*SetSpotLoc)(const CallbackParam*,const XPoint*); //over-the-spotΤ

    Window (*TargetWindow)(const IcData*);
    void (*MoveWime)(Display*,const IcData*,int x,int y);
} ConvCallbackFuncs;

struct IcData_s {
    IcAttributes Attrs;
    unsigned Flags;
    int WimeCxn; //wimeΥƥֹ
    int CompFontHeight; //ѴɥեȤι⤵̤=-1,顼=0
    ConvCallbackFuncs *ConvFunc; //on-the-spot,over-the-spotʤ
    int PreeditLen; //ߤԽʸĹ
};    

typedef struct{
    Window Proxy;
    Window Client;
    int Sync;
    int Flags;
    Array Ic; //IcData  Ic[icid-1]
    char *Encoding; //ǥե(ctext)ΤȤNULL
} WxContext;

typedef struct{
    XimAttrType Type;
    const char *Name;
    int Number;
    int Offset;
    int (*Getter)(char* base,char** a,uint16_t* idlist,int idlen);
    int (*Setter)(void* adr,Attribute* a,const CallbackParam*);
} Attrs_t;

//IcDataΥե饰
#define ICF_IME_ENABLE		1	//ơɥɽƤ(IcData)
#define ICF_SPOT_LOC		8	//Ѵɥư(IcData)
#define ICF_INVALID		4	//̤Ѿ
#define ICF_CB_INIT		2	//ConvCallbackFuncs->InitƤ

//WxContextΥե饰
#define IMF_EXT_SET_EV_MASK	2	//ExtSetEventMaskȤ
#define IMF_INVALID		4	//̤Ѿ
#define IMF_CLOSE		0x10	//

void send_n(Display* disp,Window client,unsigned major,void* h,int size);
void send_0(Display* disp,Window win,unsigned mj);
void send_ww(Display* disp,Window win,unsigned mj,uint16_t p1,uint16_t p2);
int pad(int n);

void CommitChar(Display* disp,Window client,uint16_t imid,uint16_t icid,const char* ch);
void DisconnectClient(Display* disp,WxContext* cx);
char* EucjpToCtext(const char* ej);
void ConvDoNothing(); //ConvCallbackFuncs
void MoveInputWindow(Display* disp,const XConfigureEvent* ev);
Window MoveWineWindow(Display* disp,const IcData* icp); //ư
void SetCompFont(IcData* ic);

int Open(Display* disp,WxContext* pl,XimOpen* pkt);
int Close(Display* disp,WxContext*,XimClose* pkt);
int Error(Display* disp,WxContext*,XimError* pkt);
int QueryExtension(Display* disp,WxContext*,XimQueryExtension* pkt);
int EncodingNego(Display* disp,WxContext*,XimEncodingNego* pkt);
int Connect(Display* disp,WxContext*,XimConnect* pkt);
int Disconnect(Display* disp,WxContext*);
int GetImValues(Display* disp,WxContext*,XimGetImValues* pkt);
int CreateIc(Display* disp,WxContext* pl,XimCreateIc* pkt);
int SyncReply(Display* disp,WxContext* pl,XimImIc* pkt);
int ForwardEvent(Display* disp,WxContext* cx,XimForwardEvent* pkt);
int TriggerNotify(Display* disp,WxContext* cx,XimTriggerNotify* pkt);
int DestroyIc(Display* disp,WxContext* cx,XimImIc* pkt);
int SetIcValues(Display* disp,WxContext* cx,XimSetIcValues* pkt);
int GetIcValues(Display* disp,WxContext* cx,XimGetIcValues* pkt);
int SetIcFocus(Display* disp,WxContext* cx,XimImIc* pkt);
int UnsetIcFocus(Display* disp,WxContext* cx,XimImIc* pkt);
int PreeditStartReply(Display* disp,WxContext* cx,XimPreeditStartReply* pkt);

int ForwardEvent_nwm(Display* disp,WxContext* cx,XimForwardEvent* pkt);
int CreateIc_nwm(Display* disp,WxContext* cx,XimCreateIc* pkt);
int DestroyIc_nwm(Display* disp,WxContext* cx,XimImIc* pkt);
int SetIcFocus_nwm(Display* disp,WxContext* cx,XimImIc* pkt);
int UnsetIcFocus_nwm(Display* disp,WxContext* cx,XimImIc* pkt);
int Disconnect_nwm(Display* disp,WxContext* cx);

extern const char CTXT[];
extern const char EUCJP[];

#endif
