/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: pxcjpgfa.cpp,v 1.1.26.1 2004/07/09 01:51:18 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#define INITGUID

// include
#include "hxtypes.h"
#include "hxwintyp.h"
#include "hxcom.h"
#include "hxcomm.h"
#include "hxplugn.h"
#include "hxver.h"
#include "ihxpckts.h"

// pnmisc
#include "baseobj.h"
#include "unkimp.h"

// pncont
#include "hxslist.h"
#include "carray.h"
#include "hxmap.h"

// pxcomlib
#include "pxffmcod.h"
#include "pxrndcod.h"
#include "glist.h"
#include "gstring.h"
#include "pxmapmgr.h"
#include "pxparse.h"

// jpeglib
#include "ijglwrap.h"

// pxcjpeg2
#include "pxcjpgff.h"
#include "pxcjpgrn.h"
#include "pxcjpgfa.h"

// pndebug
#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE		
static char HX_THIS_FILE[] = __FILE__;
#endif

STDAPI ENTRYPOINT(HXCREATEINSTANCE)(IUnknown** ppIUnknown)
{
    HX_RESULT retVal = HXR_OK;

    if (ppIUnknown)
    {
        CRealPixJPEGCodecFactory* pFactory = new CRealPixJPEGCodecFactory();
        if (pFactory)
        {
            retVal = pFactory->QueryInterface(IID_IUnknown, (void**) ppIUnknown);
        }
        else
        {
            retVal = HXR_OUTOFMEMORY;
        }
        if (FAILED(retVal))
        {
            HX_DELETE(pFactory);
        }
    }
    else
    {
        retVal = HXR_INVALID_PARAMETER;
    }

    return retVal;
}   

STDAPI ENTRYPOINT(CanUnload)(void)
{
    return (CHXBaseCountingObject::ObjectsActive() > 0 ? HXR_FAIL : HXR_OK);
}

CRealPixJPEGCodecFactory::CRealPixJPEGCodecFactory()
{
    m_lRefCount = 0;
}

CRealPixJPEGCodecFactory::~CRealPixJPEGCodecFactory()
{
}

STDMETHODIMP CRealPixJPEGCodecFactory::QueryInterface(REFIID riid, void** ppvObj)
{
    HX_RESULT retVal = HXR_OK;

    if (ppvObj)
    {
        // Set default
        *ppvObj = NULL;
        // Check for IID type
        if (IsEqualIID(riid, IID_IUnknown))
        {
            AddRef();
            *ppvObj = (IUnknown*) (IHXPluginFactory*) this;
        }
        else if (IsEqualIID(riid, IID_IHXPluginFactory))
        {
            AddRef();
            *ppvObj = (IHXPluginFactory*) this;
        }
        else
        {
            retVal = HXR_NOINTERFACE;
        }
    }
    else
    {
        retVal = HXR_FAIL;
    }

    return retVal;
}

STDMETHODIMP_(UINT32) CRealPixJPEGCodecFactory::AddRef()
{
    return InterlockedIncrement(&m_lRefCount);
}


STDMETHODIMP_(UINT32) CRealPixJPEGCodecFactory::Release()
{
    if (InterlockedDecrement(&m_lRefCount) > 0)
    {
        return m_lRefCount;
    }

    delete this;

    return 0;
}

STDMETHODIMP_(UINT16) CRealPixJPEGCodecFactory::GetNumPlugins()
{
    return 2;
}

STDMETHODIMP CRealPixJPEGCodecFactory::GetPlugin(UINT16 usIndex, IUnknown** ppPlugin)
{
    HX_RESULT retVal = HXR_OK;

    if (usIndex < 2 && ppPlugin)
    {
        if (usIndex == 0)
        {
            retVal = CRealPixJPEGFileFormatCodec::HXCreateInstance(ppPlugin);
        }
        else
        {
            retVal = CRealPixJPEGRendererCodec::HXCreateInstance(ppPlugin);
        }
    }
    else
    {
        retVal = HXR_INVALID_PARAMETER;
    }

    return retVal;
}

