/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: escsmil.cpp,v 1.2.18.1 2004/07/09 01:57:20 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "hxcom.h"     /* IUnknown */
#include "hxtypes.h" 
#include "hxbuffer.h"
#include "hxiids.h"
#include "hxstrutl.h"
#include "hxstring.h"
#include "growingq.h"
#include "xmlesc.h"
#include "escsmil.h"
#include "vsrcinfo.h"

/*___________________________________________________________________________
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Static variable declarations
 *___________________________________________________________________________
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

const char* const CEscapeSMIL::m_pHotSMILTags[] = 
{ 
      "ref"
    , "animation"
    , "audio"
    , "img"
    , "video"
    , "text"
    , "textstream"
    , "meta"
    , 0};

/*___________________________________________________________________________
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 *  CEscapeXMLtoHTML::PushHeader(queue)
 *
 *  PARAMETERS:
 *	queue	The queue to push the output to.
 *
 *  DESCRIPTION:
 *	This function pushes the header information for the smil file.
 *
 *  RETURNS
 *	void
 *___________________________________________________________________________
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
void
CEscapeSMIL::PushHeader(CBigByteGrowingQueue* queue)
{
    queue->EnQueue(z_pOpen);
    
    char buf[sizeof(z_pImage_ss) + sizeof(z_pSMILImageLoc) /* Flawfinder: ignore */
    		+ sizeof(z_pSMILAltText)];
    //sprintf(buf, z_pImage_ss, z_pSMILImageLoc, z_pSMILAltText);
    queue->EnQueue(z_pSMILHeader);
    
    //queue->EnQueue(z_pSMILHREF);
    //queue->EnQueue(buf);
    //queue->EnQueue("</a>");

    queue->EnQueue(z_pStream);
    queue->EnQueue(z_pSMILName);
    queue->EnQueue(z_pEndLine);
    
    PushCommonHeader(queue);

    sprintf(buf, z_pXMLSource_s, z_pSMILName); /* Flawfinder: ignore */
    queue->EnQueue(buf);
    queue->EnQueue(z_pClose);
    
    queue->EnQueue(z_pSMILTrailer);
}

/*___________________________________________________________________________
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 *  CEscapeXMLtoHTML::OnTag(cp, pObj, queue)
 *
 *  PARAMETERS:
 *
 *	cp	It points to the first whitespace after a tag name we are
 *		looking for
 *	ulLen	Length to end of cp so we don't overrun the buffer
 *	pObj	The current state of the Parse Function, this can be used
 *		to continue parsing.  its tag member contains the name
 *		of the tag
 *	queue	The queue to push the output to.
 *
 *  DESCRIPTION:
 *	This function is used to wrap any key attributes in the any tags in
 *	m_pHotRTTags. It calls CEscapeXMLtoHTML to do most the work
 *
 *  RETURNS
 *	UINT32
 *	    number of characters used off cp
 *___________________________________________________________________________
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
UINT32
CEscapeSMIL::OnTag(const UCHAR* cp, UINT32 ulLen, DataObject* pObj,
		   CBigByteGrowingQueue* pQueue)
{
    if ( strcasecmp(pObj->tag, "meta") == 0 )
    {
	// special case - we need to find the base -
	const UCHAR* pBeginName = NULL;
	const UCHAR* pBeginContent = NULL;
	const UCHAR* pEndTag = NULL;
	const char* walker = (const char*)cp;
	BOOL bInComment = FALSE;
	UINT32 ulEscLen = 0;
	while ( (!pEndTag) && ulEscLen < ulLen)
	{
	    if ( !bInComment )
	    {
		if ( *walker == '>')
		{
		    pEndTag = (const UCHAR*)walker;
		    ++pEndTag;
		}
		else if ( ulEscLen + 6 < ulLen && 
		    isspace(*(walker-1)) && 
		    !strncmp(walker, "name", 4) &&
		    (*(walker+4) == '=' || isspace(*(walker+4))) )
		{
		    walker += 4;
		    ulEscLen += 4;
		    while ( isspace(*walker) && ulEscLen < ulLen )
		    {
			++walker;
			++ulEscLen;
		    }

		    HX_ASSERT(*walker == '=');
		    if ( *walker == '=' )
		    {
			++walker;
			++ulEscLen;
			while ( isspace(*walker) && ulEscLen < ulLen )
			{
			    ++walker;
			    ++ulEscLen;
			}
			HX_ASSERT(*walker == '\"' || *walker == '\'');
			if ( *walker == '\"' || *walker == '\'' )
			{
			    ++walker;
			    ++ulEscLen;
			    pBeginName = (const UCHAR*)walker;
			}
		    }
		}
		else if ( ulEscLen + 7 < ulLen &&  
		    isspace(*(walker-1)) && 
		    !strncmp(walker, "content", 7) &&
		    (*(walker+7) == '='|| isspace(*(walker+7))) )
		{
		    walker += 7;
		    ulEscLen += 7;
		    while ( isspace(*walker) && ulEscLen < ulLen )
		    {
			++walker;
			++ulEscLen;
		    }
		    HX_ASSERT(*walker == '=');
		    if ( *walker == '=' )
		    {
			++walker;
			++ulEscLen;
			while ( isspace(*walker) && ulEscLen < ulLen )
			{
			    ++walker;
			    ++ulEscLen;
			}
			HX_ASSERT(*walker == '\"' || *walker == '\'');
			if ( *walker == '\"' || *walker == '\'' )
			{
			    ++walker;
			    ++ulEscLen;
			    pBeginContent = (const UCHAR*)walker;
			}
		    }
		}
		else if ( ulEscLen + 4 < ulLen && 
		    !strncmp(walker, "<!--", 4) )
		{
		    bInComment = TRUE;
		    walker += 3;
		    ulEscLen += 3;
		}
	    }
	    else
	    {
		if ( ulEscLen + 3 < ulLen && !strncmp(walker, "-->", 3) )
		{
		    bInComment = FALSE;
		    walker += 2;
		    ulEscLen += 2;
		}
	    }
	    ++walker;
	    ++ulEscLen;
	}
	if ( pEndTag == NULL || pBeginName == NULL || pBeginContent == NULL )
	{
	    return 0;
	}
	else if ( strncmp((const char*)pBeginName, "base", 4) == 0 )
	{
	    char* pOldPath = m_pOurPath;
	    char* pEndContent = (char*)strchr((const char*)pBeginContent, '\"');
	    if ( pEndContent == NULL )
	    {
		pEndContent = (char*)strchr((const char*)pBeginContent, '\'');
	    }
	    HX_ASSERT(pEndContent);
	    UINT32 ulConLen = 0;
	    if ( pEndContent )
	    {
		ulConLen = (const UCHAR*)pEndContent - pBeginContent;
	    }
	    m_pOurPath = new char[strlen(pOldPath) + ulConLen + 2];
	    strcpy(m_pOurPath, pOldPath);
	    HX_VECTOR_DELETE(pOldPath);
	    if ( *pBeginContent == '/' )
	    {
		strncpy(m_pOurPath, (const char*)pBeginContent, ulConLen);
		m_pOurPath[ulConLen] = '\0';
	    }
	    // if it is alpha it is a relative directory name
	    else if ( isalnum(*pBeginContent) )
	    {
		// 1 for "/"
		UINT32 len = strlen(m_pOurPath) + ulConLen + 1;
		strcat(m_pOurPath, "/");
		strncat(m_pOurPath, (const char*)pBeginContent, ulConLen);
		m_pOurPath[len] = '\0';
	    }
	    else if ( !strncmp((const char*)pBeginContent, "./", 2) )
	    {
		// -1 for .
		UINT32 len = strlen(m_pOurPath) + ulConLen - 1;
		strncat(m_pOurPath, (const char*)pBeginContent + 1, ulConLen - 1);
		m_pOurPath[len] = '\0';
	    }
	    else if ( !strncmp((const char*)pBeginContent, "../", 3 ) )
	    {
		int count = 0;

		const char* pRelativePath = (const char*)pBeginContent;
		char* pCurrentEndOfPath = m_pOurPath;
		pCurrentEndOfPath += strlen(m_pOurPath);

		// back up a directory off of the file path for
		// every ../ we find
		while (!strncmp((const char*)pRelativePath, "../", 3 ))
		{
		    // we found a ../ so back up a directory on the path,
		    // walk backwards to the previous / and set it to null
		    while (*pCurrentEndOfPath != '/' && 
			pCurrentEndOfPath >= m_pOurPath)
		    {
			pCurrentEndOfPath--;
		    }
		    // watch to make sure we don't have more ../ than directories
		    if ( pCurrentEndOfPath < m_pOurPath )
		    {
			++pCurrentEndOfPath;
		    }
		    *pCurrentEndOfPath = '\0';
		    pRelativePath +=3;
		}

		UINT32 len = (pCurrentEndOfPath - m_pOurPath) + 
		    ulConLen - (pRelativePath - (const char*)pBeginContent) + 1;
		
		// back 1 off of pRelativePath so we get the / that's there.
		strncat(m_pOurPath, (const char*)pRelativePath - 1,
		    ulConLen - (pRelativePath - (const char*)pBeginContent) + 1);
		m_pOurPath[len] = '\0';
	    }
	    else
	    {
		HX_ASSERT(FALSE);
		return 0;
	    }
	    // get rid of the trailing '/' if there is one.
	    ulConLen = strlen(m_pOurPath);
	    if ( m_pOurPath[ulConLen-1] == '/' )
	    {
		m_pOurPath[ulConLen-1] = '\0';
	    }
	}
	return 0;
    }
    else
    {
	// src=" attribute is the only one we are looking for.
	return WrapAttributeWithHREF(cp, ulLen, pObj, pQueue, "src");
    }
}
